---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, communication, diaporama,
              PowerPoint, slides, diapositives, transparents, présentations,
              support de présentation
---

# Comment préparer une présentation (avec des "diapos") ?

La réponse à cette question donne un aperçu historique détaillé. Mais, 
si vous êtes pressé, regardez directement la classe <ctanpkg:beamer>, 
qui permet de préparer des présentations à projeter avec un vidéoprojecteur.
La présente FAQ propose même des articles dédiés à cette classe, 
dont [une prise en main](/4_domaines_specialises/communication/diaporama/premiers_pas_avec_beamer)
de <ctanpkg:beamer>.

:::{todo} Ajouter des exemples.
:::


## Petite histoire des présentations

La version originale de LaTeX, quand Leslie Lamport l'a conçue, proposait 
un programme séparé, `SliTeX` (comme *slide-TeX*), pour produire 
des diapositives ; cela date de l'époque où il s'agissait  
de vraies [diapositives](wpfr:Diapositive) pour les conférences, 
ce qui demandait de séparer les couleurs pour l'impression. Le programme 
en question s'occupait de ça, et donnait le résultat attendu, à l'époque.
Lorsque LaTeX2e est arrivé, SliTeX n'avait plus de raison d'être 
un programme séparé, et ses fonctionnalités ont été fournies 
par la classe <ctanpkg:slides>. Cette simplification n'a plus grand 
intérêt de nos jours car plus personne n'utilise de diapositives.

Quand les diapositives ont cédé la place 
aux [transparents](wpfr:Transparent_(projection)) (ces feuilles de rhodoïd
à placer sur la vitre d'un rétroprojecteur), les classes <ctanpkg:seminar> 
et [FoilTeX](ctanpkg:foiltex) ont été développées. Là encore, la technologie
et les modes ont rendu ce type de support obsolète. Mais les fonctionnalités
de ces classes ont été étendues pour s'adapter à l'usage 
d'un [vidéoprojecteur](wpfr:Vidéoprojecteur) (voir ci-dessous).

L'avènement de [Microsoft PowerPoint](wpfr:Microsoft_PowerPoint) (aussi 
médiocres qu'aient été ses premières versions) a créé une demande 
pour des diapos animées : des images qui révèlent leur contenu d'une manière
plus élaborée qu'en remplaçant simplement une page par une autre, 
comme c'était la norme lorsque <ctanpkg:slides>, [FoilTeX](ctanpkg:foiltex) 
et <ctanpkg:seminar> ont été conçus.


## Avec des solutions actuelles

### La classe <ctanpkg:beamer>

La classe <ctanpkg:beamer> est très puissante, mais 
relativement facile à maîtriser, Comme son nom l'indique [^footnote-1], 
elle a été conçue pour être utilisée avec des vidéoprojecteurs. Elle utilise 
l'extension [TikZ](ctanpkg:pgf) pour le support graphique. Il est également
très simple de sortir une version imprimée de la présentation préparée 
avec <ctanpkg:beamer>.

De très nombreux thèmes sont été créés pour <ctanpkg:beamer>. Voici 
quelques galeries :
- [_Beamer gallery_ de Ian Blanes](https://deic.uab.cat/~iblanes/beamer_gallery/) ;
- [la liste du site latex-beamer.com](https://latex-beamer.com/tutorials/beamer-themes/) ;
- [une galerie très complète de Uwe Ziegenhagen sur GitHub](https://github.com/UweZiegenhagen/LaTeX-Beamer-Theme-Overview/blob/main/OVERVIEW.md).

Vous pouvez aussi consulter les pages dédiées :
- "[](/4_domaines_specialises/communication/diaporama/premiers_pas_avec_beamer)" ;
- "[](/4_domaines_specialises/communication/diaporama/mode_presentateur_pour_beamer)".


### L'extension <ctanpkg:lecturer>

L'extension [Lecturer](ctanpkg:lecturer) est originellement développée
pour Plain TeX, mais utilisable avec beaucoup de formats dont LaTeX. 
Cette extension, au lieu d’utiliser une machinerie TeX sophistiquée, s’appuie
sur les possibilités qu’offre PDF. Ainsi, pour lire une présentation produite
avec [Lecturer](ctanpkg:lecturer), il vous faudra un lecteur PDF qui sait
interpréter le code PDF et un peu de Javascript (Acrobat Reader ou Okular 
le permettent). Cette extension est utilisable avec les moteurs pdfTeX 
et LuaTeX (mais pas XeTeX).  

Chaque page est composée par le moteur TeX, et les éléments sont affichés 
à l’écran avec les fonctionnalités de PDF pour la superposition 
et les effets dynamiques. 

Un des avantages de cette extension est que vous pouvez positionner 
n’importe quel matériel à n’importe quelle place, et cela de façon très simple.
De plus, les présentations sont très facilement personnalisables. 


### La classe <ctanpkg:elpres>

:::{todo} Il existe aussi <ctanpkg:elpres> parmi les extensions actuellement 
maintenues.
:::


## Avec des solutions anciennes

### La classe <ctanpkg:prosper> 

Pour poursuivre l'aperçu historique de l'introduction, 
la classe <ctanpkg:prosper> s'appuie sur <ctanpkg:seminar> pour fournir 
des effets dynamiques et autres; elle permet à la fois de produire 
une présentation à projeter directement, ou d'imprimer des transparents. 
L'extension complémentaire <ctanpkg:ppr-prv> ajoute des fonctions 
de "prévisualisation" (communément appelée "l'impression de polycopiés"). 
L'extension <ctanpkg:HA-prosper>, que vous chargez avec <ctanpkg:prosper>,
corrige quelques bogues, ajoute plusieurs fonctions et fournit des thèmes
pour les diapositives. La classe (plus récente) <ctanpkg:powerdot> 
est conçue comme un remplacement de <ctanpkg:prosper> 
et <ctanpkg:HA-prosper>, co-écrite par l'auteur de HA-prosper.


### La classe <ctanpkg:talk> 

La classe <ctanpkg:talk> est une autre classe très fonctionnelle, mais facile
à apprendre, qui prétend différer de <ctanpkg:beamer> et autres systèmes 
mentionnés ci-dessus en ce qu'elle ne vous impose pas un style de diapositive.
Vous pouvez spécifier plusieurs styles, et pouvez passer de l'un à l'autre 
entre les diapositives, selon vos besoins. La classe elle-même ne fournit 
qu'un seul style, sous le nom `greybars` : la suggestion de l'auteur est que
les utilisateurs apportent leurs contributions, comme avec la 
[_Beamer gallery_](https://deic.uab.cat/~iblanes/beamer_gallery/).


### La classe <ctanpkg:present> 

La classe <ctanpkg:present> est conçue pour être utilisée avec Plain TeX
uniquement ; sa conception est simple, à tel point que son auteur 
espère que les utilisateurs seront eux-mêmes capables de modifier 
ses commandes.


### La classe <ctanpkg:ppower4> 

L'extension <ctanpkg:ppower4> (communément appelé `pp4`) est un programme 
auxiliaire en Java qui post-traite le PDF, pour "animer" le fichier 
aux endroits que vous avez marqués avec des commandes de l'extension `pp4`.
Attention, ces commandes ne fonctionnent que sur les PDF générés par pdfLaTeX,
LaTeX, ou `dvipdfm` (sur la sortie de LaTeX) ; elles ne fonctionnent pas 
si vous êtes passé par `dvips`.


### Les extensions <ctanpkg:pdfscreen> et <ctanpkg:texpower> 

Les extensions <ctanpkg:pdfscreen> et <ctanpkg:texpower> 
permettent des effets dynamiques dans des documents formatés 
dans des classes "plus modestes" ; <ctanpkg:pdfscreen> vous permettra même 
d'insérer des "effets de présentation" dans un document 
de classe <ctanpkg:article>.

Un examen plus détaillé des alternatives (y compris des exemples de code 
utilisant plusieurs d'entre elles) peut être trouvé 
sur [le site de Michael Wiedmann](https://www.miwie.org/presentations/) 
(en anglais).


## Et avec ConTeXt ?

Les utilisateurs de ConTeXt verront que tout ce dont ils ont besoin ou presque
se trouve déjà dans ConTeXt lui-même ; le wiki ConTeX garden fournit 
[un résumé](https://wiki.contextgarden.net/Presentation_Styles) 
utile de ce qui est disponible, avec des exemples (en anglais).


:::{sources}
- [Producing presentations (including slides)](faquk:FAQ-slidecls)
- [Tutoriel : Créez vos diaporamas en LaTeX avec Beamer !](https://pub.phyks.me/sdz/sdz/creez-vos-diaporamas-en-latex-avec-beamer.html)
- [Beamer](wpfr:Beamer)
:::


[^footnote-1]: *beamer* est un pseudo-anglicisme désignant un vidéoprojecteur
  en allemand, néerlandais et français de Suisse