---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, paragraphes, citation
---

# Comment mettre en page des citations ?

Il existe deux environnements de gestion des citations :

- `quote` pour les citations courtes ;
- `quotation` pour les citations longues.

En voici un exemple :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\begin{quote}
L'environnement \texttt{quote} ne place pas de retrait d'alinéa 
sur la première ligne de ses paragraphes, et l'espace vertical 
entre ceux-ci est supérieur à celui d'un texte standard.

La preuve !
\end{quote}

\begin{quotation}
L'environnement \texttt{quotation} place un retrait d'alinéa 
sur la première ligne de ses paragraphes, et ne rajoute pas d'espace 
vertical entre ceux-ci.

La preuve !
\end{quotation}

Dans les deux cas, les marges droite et gauche sont plus importantes
que celles d'un texte standard.
\end{document}
```

Vous pouvez également consulter la question 
"[](/3_composition/texte/titres/ajouter_une_epigraphe)".