/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath;

import com.github.ajalt.colormath.Ansi16;
import com.github.ajalt.colormath.Ansi256;
import com.github.ajalt.colormath.CMYK;
import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.HSV;
import com.github.ajalt.colormath.HueColor;
import com.github.ajalt.colormath.LAB;
import com.github.ajalt.colormath.RGB;
import com.github.ajalt.colormath.RenderCondition;
import com.github.ajalt.colormath.XYZ;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B)\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bB'\u0012\u0006\u0010\u0003\u001a\u00020\t\u0012\u0006\u0010\u0005\u001a\u00020\t\u0012\u0006\u0010\u0006\u001a\u00020\t\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\tH\u00c6\u0003J\t\u0010\u0014\u001a\u00020\tH\u00c6\u0003J\t\u0010\u0015\u001a\u00020\tH\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0004H\u00c6\u0003J1\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\t2\b\b\u0002\u0010\u0005\u001a\u00020\t2\b\b\u0002\u0010\u0006\u001a\u00020\t2\b\b\u0002\u0010\u0007\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\tH\u00d6\u0001J\b\u0010\u001d\u001a\u00020\u0000H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\t\u0010\"\u001a\u00020#H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u0003\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006$"}, d2={"Lcom/github/ajalt/colormath/HSL;", "Lcom/github/ajalt/colormath/Color;", "Lcom/github/ajalt/colormath/HueColor;", "h", "", "s", "l", "a", "(FFFF)V", "", "(IIIF)V", "getA", "()F", "alpha", "getAlpha", "getH", "()I", "getL", "getS", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "toHSL", "toHSV", "Lcom/github/ajalt/colormath/HSV;", "toRGB", "Lcom/github/ajalt/colormath/RGB;", "toString", "", "colormath"})
public final class HSL
implements Color,
HueColor {
    private final int h;
    private final int s;
    private final int l;
    private final float a;

    @Override
    public float getAlpha() {
        return this.a;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public RGB toRGB() {
        double h = (double)this.getH() / 360.0;
        double s = (double)this.s / 100.0;
        double l = (double)this.l / 100.0;
        if (s == 0.0) {
            int v = MathKt.roundToInt(l * (double)255);
            return new RGB(v, v, v, 0.0f, 8, null);
        }
        double t2 = l < 0.5 ? l * (1.0 + s) : l + s - l * s;
        double t1 = (double)2 * l - t2;
        Double[] rgb = new Double[]{0.0, 0.0, 0.0};
        int n = 0;
        int n2 = 2;
        while (n <= n2) {
            void i;
            double t3 = h + 0.3333333333333333 * -((double)i - 1.0);
            if (t3 < 0.0) {
                t3 += 1.0;
            }
            if (t3 > 1.0) {
                t3 -= 1.0;
            }
            double v = (double)6 * t3 < 1.0 ? t1 + (t2 - t1) * (double)6 * t3 : ((double)2 * t3 < 1.0 ? t2 : ((double)3 * t3 < (double)2 ? t1 + (t2 - t1) * (0.6666666666666666 - t3) * (double)6 : t1));
            rgb[i] = v;
            ++i;
        }
        return new RGB(rgb[0], rgb[1], rgb[2], (double)this.getAlpha());
    }

    @Override
    @NotNull
    public HSV toHSV() {
        double h = this.getH();
        double s = (double)this.s / (double)100;
        double l = (double)this.l / (double)100;
        double smin = s;
        double d = 0.01;
        boolean bl = false;
        double lmin = Math.max(l, d);
        double v = (l + (s *= (l *= (double)2) <= 1.0 ? l : (double)2 - l)) / (double)2;
        double sv = l == 0.0 ? (double)2 * (smin *= lmin <= 1.0 ? lmin : (double)2 - lmin) / (lmin + smin) : (double)2 * s / (l + s);
        return new HSV(MathKt.roundToInt(h), MathKt.roundToInt(sv * (double)100), MathKt.roundToInt(v * (double)100), this.getAlpha());
    }

    @Override
    @NotNull
    public HSL toHSL() {
        return this;
    }

    @Override
    public int getH() {
        return this.h;
    }

    public final int getS() {
        return this.s;
    }

    public final int getL() {
        return this.l;
    }

    public final float getA() {
        return this.a;
    }

    public HSL(int h, int s, int l, float a) {
        this.h = h;
        this.s = s;
        this.l = l;
        this.a = a;
        int n = this.getH();
        n = 0 <= n && 360 >= n ? 1 : 0;
        boolean bl = false;
        boolean bl2 = false;
        if (n == 0) {
            boolean bl3 = false;
            String string = "h must be in range [0, 360]";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = this.s;
        n = 0 <= n && 100 >= n ? 1 : 0;
        bl = false;
        bl2 = false;
        if (n == 0) {
            boolean bl4 = false;
            String string = "s must be in range [0, 100]";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = this.l;
        n = 0 <= n && 100 >= n ? 1 : 0;
        bl = false;
        bl2 = false;
        if (n == 0) {
            boolean bl5 = false;
            String string = "l must be in range [0, 100]";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        float f = this.a;
        boolean bl6 = f >= 0.0f && f <= 1.0f;
        bl = false;
        bl2 = false;
        if (!bl6) {
            boolean bl7 = false;
            String string = "a must be in range [0, 1] in " + this;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ HSL(int n, int n2, int n3, float f, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 8) != 0) {
            f = 1.0f;
        }
        this(n, n2, n3, f);
    }

    public HSL(float h, float s, float l, float a) {
        this(MathKt.roundToInt(h), MathKt.roundToInt(s * (float)100), MathKt.roundToInt(l * (float)100), a);
    }

    public /* synthetic */ HSL(float f, float f2, float f3, float f4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            f4 = 1.0f;
        }
        this(f, f2, f3, f4);
    }

    @Override
    @NotNull
    public String toHex(boolean withNumberSign, @NotNull RenderCondition renderAlpha) {
        Intrinsics.checkNotNullParameter((Object)renderAlpha, "renderAlpha");
        return Color.DefaultImpls.toHex(this, withNumberSign, renderAlpha);
    }

    @Override
    @NotNull
    public Ansi16 toAnsi16() {
        return Color.DefaultImpls.toAnsi16(this);
    }

    @Override
    @NotNull
    public Ansi256 toAnsi256() {
        return Color.DefaultImpls.toAnsi256(this);
    }

    @Override
    @NotNull
    public CMYK toCMYK() {
        return Color.DefaultImpls.toCMYK(this);
    }

    @Override
    @NotNull
    public XYZ toXYZ() {
        return Color.DefaultImpls.toXYZ(this);
    }

    @Override
    @NotNull
    public LAB toLAB() {
        return Color.DefaultImpls.toLAB(this);
    }

    public final int component1() {
        return this.getH();
    }

    public final int component2() {
        return this.s;
    }

    public final int component3() {
        return this.l;
    }

    public final float component4() {
        return this.a;
    }

    @NotNull
    public final HSL copy(int h, int s, int l, float a) {
        return new HSL(h, s, l, a);
    }

    public static /* synthetic */ HSL copy$default(HSL hSL, int n, int n2, int n3, float f, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = hSL.getH();
        }
        if ((n4 & 2) != 0) {
            n2 = hSL.s;
        }
        if ((n4 & 4) != 0) {
            n3 = hSL.l;
        }
        if ((n4 & 8) != 0) {
            f = hSL.a;
        }
        return hSL.copy(n, n2, n3, f);
    }

    @NotNull
    public String toString() {
        return "HSL(h=" + this.getH() + ", s=" + this.s + ", l=" + this.l + ", a=" + this.a + ")";
    }

    public int hashCode() {
        return ((Integer.hashCode(this.getH()) * 31 + Integer.hashCode(this.s)) * 31 + Integer.hashCode(this.l)) * 31 + Float.hashCode(this.a);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof HSL)) break block3;
                HSL hSL = (HSL)object;
                if (this.getH() != hSL.getH() || this.s != hSL.s || this.l != hSL.l || Float.compare(this.a, hSL.a) != 0) break block3;
            }
            return true;
        }
        return false;
    }
}

