# License

This work may be distributed and/or modified under the conditions of the
LaTeX Project Public License, either version 1.3 of this license or
(at your option) any later version. The latest version of this license
is in http://www.latex-project.org/lppl.txt and version 1.3 or later is
part of all distributions of LaTeX version 2005/12/01 or later.

# Authors

Original contents (2016): [Anders O.F. Hendrickson](/author/hendrickson) ([contact](mailto:anders.o.f.hendricksonATgmail.com))

2019-2023: [Matthieu Guerquin-Kern](/author/guerquin-kern) ([contact](mailto:guerquin-kernATcrans.org))

# Contents

This work, under version number 1.0, consists of the files
[`moodle.dtx`](/tex-archive/macros/latex/contrib/moodle/moodle.dtx),
[`moodle.ins`](/tex-archive/macros/latex/contrib/moodle/moodle.ins), and the derived documentation
file [`moodle.pdf`](/tex-archive/macros/latex/contrib/moodle/moodle.pdf).

The derived file `moodle.sty` can be downloaded from [here](https://www.tug.org/svn/texlive/trunk/Master/texmf-dist/tex/latex/moodle/moodle.sty?view=co).
Details on how to generate derived files from the sources are given in Section "Building" at the end of this document.

A TDS archive [moodle.tds.zip](http://mirrors.ctan.org/install/macros/latex/contrib/moodle.tds.zip) is
also available to be conveniently expanded in your local texmf directory.
It contains the derived files `moodle.sty`, `moodle.pdf` and a set of test files.

# Requirements

This package (`moodle.sty`) requires the following packages:
- [`environ`](/pkg/environ),
- [`xkeyval`](/pkg/xkeyval),
- [`amssymb`](/pkg/amssymb),
- [`trimspaces`](/pkg/trimspaces),
- [`etex`](pkg/etex),
- [`etoolbox`](pkg/etoolbox),
- [`xpatch`](pkg/xpatch),
- [`array`](pkg/array),
- [`ifplatform`](/pkg/ifplatform),
- [`shellesc`](pkg/shellesc),
- [`readprov`](pkg/readprov),
- [`fancybox`](pkg/fancybox), and
- [`getitems`](pkg/getitems).

The package option `handout` requires:
- [`randomlist`](pkg/randomlist).

In order to manipulate images, the package relies on the following tools:
- [`graphics`](pkg/graphics),
- [GhostScript](www.ghostscript.com),
- [ImageMagick](www.imagemagick.org), and
- [optipng](http://optipng.sourceforge.net/).

Instead, to compile the documentation, the following LaTeX packages are
necessary:
- [`amssymb`](pkg/amssymb),
- [`babel`](pkg/babel),
- [`booktabs`](pkg/booktabs),
- [`changelog`](pkg/changelog),
- [`dtxdescribe`](pkg/dtxdescribe),
- [`eurosym`](pkg/eurosym),
- [`hyperref`](pkg/hyperref),
- [`longtable`](pkg/longtable),
- [`minted`](pkg/minted),
- [`microtype`](pkg/microtype),
- [`tikz`](pkg/tikz),
- [`threeparttable`](pkg/threeparttable), and
- [`varioref`](pkg/varioref).

# Building

The file `moodle.sty` can be generated using the command
```bash
latex moodle.ins
````
The documentation file `moodle.pdf` can be generated by running
successively the three commands:
```bash
lualatex -halt-on-error -shell-escape moodle.dtx
makeindex -s gglo.ist -o moodle.gls moodle.glo
lualatex -halt-on-error -shell-escape moodle.dtx
```
(n.b. the requirements in the previous section)
