# linkedthm — Linked Theorem–Proof Environments

**Version:** 1.0  
**Author:** Luis A. Ortega  
**License:** LPPL 1.3c  
**Date:** 2025-07-21

---

This LaTeX package provides an easy way to hyperlink between theorem-like environments and their corresponding proofs.

- Automatically restates a theorem inside its proof
- Adds clickable [Proof] and [Return] links using `hyperref`
- Works with any `amsthm`-compatible environment

---

## Example

```latex
\newtheorem{theorem}{Theorem}
\usepackage{linkedthm}

\DeclareLinkedTheorem{linkedtheorem}{theorem}{Theorem}

\begin{linkedtheorem}{thm:example}
All even numbers greater than 2 are the sum of two primes.
\end{linkedtheorem}

\begin{linkedproof}{thm:example}
This is known as Goldbach's conjecture and remains unproven.
\end{linkedproof}
