' create or replace build profiles for TeXnicCenter;
' leave other TeXnicCenter settings alone

' This script gets the location of TL from its command-line parameter.

Option Explicit

On Error Resume Next

' cumulative messages and warnings
Dim mess
' root of TL installation
Dim sTL
' root of TL extras
Dim sXtra

''''''''''''''''''''''''''''''''''''''''
Sub quitting
  ' count on wrapper or caller for passing mess to the user
  wscript.echo mess
  wscript.quit
End Sub

sub DisplayMessage( m )
  ' while debugging from command prompt:
  ' wscript.echo m
  ' production version previously
  ' MsgBox m, options, Menu_Name & " TeXnicCenter Configurator"
  ' now relies on wrapper for feedback
  mess = (mess & m & vbCrLf)
End Sub

' load necessary functionality

Dim oWsh, oFS, oReg

Set oWsh = Wscript.CreateObject("WScript.Shell")
Set oFS = CreateObject("Scripting.FileSystemObject")

' WMI registry access, needed for enumerating subkeys (!)

Set oReg = GetObject("winmgmts:{impersonationLevel=impersonate}//" _
    & "./root/default:StdRegProv")
If Err.number <> 0 Then
  Err.clear
  DisplayMessage "Error in registry access; aborting."
  quitting
End If

' WMI registry access uses these constants for referencing hives:
const hkcr=&h80000000
const hkcu=&h80000001
const hklm=&h80000002

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Function DeleteRegBranch( sHive, sBranch )

  Dim resnum, resbool, sKeyName, sNames

  ' Delete an existing key.
  ' clear any error conditions before returning

  On Error Resume Next

  resnum = oReg.DeleteKey(sHive, sBranch)
  If ( Not Err ) And (resnum = 0 ) Then
    'DisplayMessage "deleting " & sBranch, vbOK
    resbool = true
  else
    ' If the deletion failed, start deleting subkeys.
    ' No need to keep track of success;
    ' we delete what we can and check in the end
    ' whether we CAN delete the key.
    Err.clear

    ' Subkey Enumerator
    resnum = oReg.EnumKey (sHive, sBranch, sNames)
    If resnum = 0 Then
      For Each sKeyName In sNames
        'DisplayMessage "recursively deleting " & sBranch & "\" & sKeyName, _
        '    vbOK
        DeleteRegBranch sHive, sBranch & "\" & sKeyName
      Next
    End If
    ' no need to delete values separately

    ' Now we can try again to delete the registry key.
    ' This will fail if there was a previous failure.
    resnum = oReg.DeleteKey( sHive, sBranch )
    If Err.number <> 0 Then
      resnum = Err.number
      Err.clear
      resbool = false
    elseif resnum <> 0 Then
      resbool = False
    Else
      resbool = True
    End If
    wscript.sleep 50 ' may prevent some failures
  End If
  DeleteRegBranch = resbool

End Function

Sub Main

  On Error Resume Next

  Dim l, i, s, sTNCpro, sPr, sP, oArgs
  ' for pdf viewer:
  Dim sTmp, oTmp, aSubKeys

  Err.clear

  mess = ""

  ' wscript.echo "starting"

  sXtra = oFS.GetParentFolderName(oFS.GetParentFolderName( _
    Wscript.ScriptFullName))
  ' mess = mess & "TL root: " & sTL & vbCrLf
  ' mess = mess & "extras root: " & sXtra & vbCrLf

  Set oArgs = wscript.Arguments
  if oArgs.Count < 1 Then
    sTL = oFS.GetParentFolderName( sXtra )
  else
    sTL = oArgs(0)
  end If

  If Not oFS.FolderExists( sTL ) Then
    DisplayMessage "TeX Live not found; aborting...", vbCritical
    quitting
  End If
  If Not oFS.FolderExists( sXtra & "\TeXnicCenter") then
    DisplayMessage "TeXNicCenter not found; aborting...", vbCritical
    quitting
  End If

  ' remove old settings recursively

  Err.clear
  DeleteRegBranch hkcu, "software\toolscenter\texniccenter\profiles"
  DeleteRegBranch hkcu, "software\toolscenter\texniccenternt\profiles"
  Err.clear

  ' MsgBox ("Check that all profiles have been deleted")

  Const sPro = "HKCU\Software\ToolsCenter\TeXnicCenterNT\Profiles\"

  ' [pdf]latex
  For Each sPr in Array( _
    "LaTeX >> DVI\", "LaTeX >> DVI => PDF\", "LaTeX => PDF\", "LaTeX => PS\", _
        "LaTeX => PS => PDF\", "LuaLaTeX => PDF\", "XeLaTeX => PDF\")
    Err.clear
    sP = sPro & sPr
    oWsh.RegWrite sP & "RunLatex", 1, "REG_DWORD"
    If sPr = "LaTeX => PDF\" Then
      oWsh.RegWrite sP & "LatexPath", sTL & "\bin\win32\pdflatex.exe"
    ElseIf sPr = "LuaLaTeX => PDF\" Then
      oWsh.RegWrite sP & "LatexPath", sTL & "\bin\win32\lualatex.exe"
    ElseIf sPr = "XeLaTeX => PDF\" Then
      oWsh.RegWrite sP & "LatexPath", sTL & "\bin\win32\xelatex.exe"
    Else
      oWsh.RegWrite sP & "LatexPath", sTL & "\bin\win32\latex.exe"
    End If
    oWsh.RegWrite sP & "LatexArgs", "-synctex=-1 -interaction=nonstopmode ""%Wm"""
    oWsh.RegWrite sP & "LatexStopOnError", 0, "REG_DWORD"
    oWsh.RegWrite sP & "RunBibTex", 1, "REG_DWORD"
    oWsh.RegWrite sP & "BibTexPath", sTL & "\bin\win32\bibtex.exe"
    oWsh.RegWrite sP & "BibTexArgs", """%tm"""
    oWsh.RegWrite sP & "RunMakeIndex", 1, "REG_DWORD"
    oWsh.RegWrite sP & "MakeIndexPath", sTL & "\bin\win32\makeindex.exe"
    oWsh.RegWrite sP & "MakeIndexArgs", """%tm"""
    oWsh.RegWrite sP & "CloseViewBeforeCompilation", 0, "REG_DWORD"
  Next

  ' postprocessing: dvips
  For Each sPr in Array("LaTeX => PS\", "LaTeX => PS => PDF\")
    sP = sPro & sPr & "PostProcessors\"
  oWsh.RegWrite sP & "PostProcessor0", _
      "DviPs" & vbLf & _
      sTL & "\bin\win32\dvips.exe" & vbLf & """%Bm.dvi""" & vbLf & vbLf
  Next

  ' postprocessing: dvipdfm
  oWsh.RegWrite sPro & "LaTeX >> DVI => PDF\PostProcessor0", _
      "dvipdfm" & vbLf & _
      sTL & "\bin\win32\dvipdfm.exe" & vbLf & """%bm.dvi""" & vbLf & vbLf

  ' postprocessing: ps2pdf
  oWsh.RegWrite sPro & _
      "LaTeX => PS => PDF\PostProcessors\PostProcessor1", "gswin32c" & vbLf & _
      sTL & "\bin\win32\rungs.exe" & vbLf & _
      " -sPAPERSIZE#a4 -dPDFSETTINGS#/prepress -dCOMPATIBILITYLEVEL#1.4" & _
      " -dNOPAUSE -dBATCH -q -dSAFER -sDEVICE#pdfwrite" & _
      " -sOutputFile#""%Bm.pdf"" ""%Bm.ps""" & vbLf & vbLf

  ' viewing: dvi
  sPr = "LaTeX >> DVI\"
  oWsh.RegWrite sPro & sPr & "ViewerPath", """" & sTL &_
     "\bin\win32\dviout.exe"""

  For Each s in Array("ViewCurrentCmd\", "ViewProjectCmd\")
    sP = sPro & sPr & s
    oWsh.RegWrite sP & "ProcessCmd", _
      """" & sTL & "\bin\win32\dviout.exe""" & vbLf & """%bm.dvi"""
    oWsh.RegWrite sP & "DDECmd", vbLf & "System" & vbLf & vbLf
  Next

  ' viewing: ps
  sPr = "LaTeX => PS\"
  oWsh.RegWrite sPro & sPr & "ViewerPath", """" & sTL & "\bin\win32\psv.exe"""
  For Each s in Array("ViewCurrentCmd\", "ViewProjectCmd\")
    sP = sPro & sPr & s
    oWsh.RegWrite sP & "ProcessCmd", _
        """" & sTL & "\bin\win32\psv.exe""" & vbLf & """%bm.ps"""
    oWsh.RegWrite sP & "DDECmd", vbLf & "System" & vbLf & vbLf
  Next

  ' viewing: pdf
  For Each sPr in Array("LaTeX => PDF\", "LaTeX >> DVI => PDF\", _
      "LaTeX => PS => PDF\", "LuaLaTeX => PDF\", "XeLaTeX => PDF\")
    ' wscript.echo "Doing " & spr
    Err.clear
    oWsh.RegWrite sPro & sPr & "ViewerPath", sXtra & _
        "\SumatraPDF\SumatraPDF.exe -inverse-search ""\""" & sXtra _
        & "\TeXnicCenter\TeXnicCenter.exe\""" & _
        " /ddecmd \""[goto('%f','%l')]\"""""
    oWsh.RegWrite sPro & sPr & "CloseViewBeforeCompilation", 0, "REG_DWORD"
    For Each s in Array("ViewCurrentCmd\", "ViewProjectCmd\")
      sP = sPro & sPr & s
      oWsh.RegWrite sP & "ActiveType", 1, "REG_DWORD"
      oWsh.RegWrite sP & "DDECmd", "SUMATRA" & vbLf & "control" & vbLf & _
        "[ForwardSearch(""%bm.pdf"",""%Wc"",%l,0,0,1)]" & vbLf & sXtra _
        & "\SumatraPDF\SumatraPDF.exe -inverse-search ""\""" & sXtra _
        & "\TeXnicCenter\TeXnicCenter.exe\""" & _
        " /ddecmd \""[goto('%f','%l')]\"""""
      oWsh.RegWrite sP & "ProcessCmd", vbLf
    Next
    'oWsh.RegWrite sPro & sPr
  Next

  DisplayMessage _
      "TeXnicCenter now configured for TeX Live and SumatraPDF"

  wscript.echo mess

End Sub

Main
