---
myst:
  html_meta:
    keywords: LaTeX, fichiers, fontes, fontes T1, Type 1, mathématiques, format de fontes,
              typographie
---

# Quelles sont les fontes T1 disponibles pour les mathématiques ?

Si vous ne vous intéressez qu'au texte, vous pouvez en principe utiliser 
n'importe laquelle des très nombreuses polices de texte disponibles aux formats Adobe Type 1, 
TrueType ou OpenType. 
La contrainte est, bien sûr, que votre prévisualisateur et votre pilote d'imprimante 
doivent prendre en charge ces polices (TeX lui-même ne se préoccupe *que* des métriques, 
pas des programmes de caractères proprement dits).

Si vous avez également besoin de mathématiques, votre choix est plus limité, 
notamment en raison des exigences de TeX en matière de polices mathématiques 
(pour plus de détails, voir les articles de B.K.P. Horn du 
[TUGboat 14(3)](https://tug.org/TUGboat/Articles/tb14-3/tb40horn.pdf), 
ou de Thierry Bouche du [TUGboat 19(2)](https://tug.org/TUGboat/Articles/tb19-2/tb59bouc.pdf)). 
Plusieurs options sont disponibles :
- soit basées sur les créations de Knuth ;
- soit par ajout de polices de caractères commerciales et gratuites. L'ensemble de MicroPress 
  nommé "informal math" en est un cas assez spécifique.

Les utilisateurs devraient également envisager les possibilités de composition de
[maths avec des polices OpenType](/5_fichiers/formats/fontes/fontes_opentype_pour_les_mathematiques).


## Des catalogues de fontes

*The LaTeX font catalogue* tient une [liste à jour](https://tug.org/FontCatalogue/mathfonts.html) 
qui décrit les polices en donnant uniquement des noms et de courts exemples. 

Un autre document bien utile est le *<ctanpkg:free-math-font-survey>* de Stephen Hartke. 
Cette enquête de 2006 couvre la plupart des polices mentionnées dans *The LaTeX font catalogue*, 
mais en mentionne également certaines (telles que <ctanpkg:Belleek>) que le catalogue omet.
Il présente en particulier des exemples très complets d'utilisation.


## Fontes libres

Les familles de polices "gratuites" qui prennent en charge les mathématiques TeX comprennent :


### *Computer Modern*, de Donald E. Knuth

Cet ensemble comprend 75 fontes, avec une mise à l'échelle optique.
Les polices *Computer Modern* (CM) ont été conçues à l'origine en MetaFont, 
et sont désormais également disponibles sous forme de contours modulables. 
Il existe des versions commerciales et des versions du domaine public, 
ainsi que des versions Adobe Type 1 et TrueType. 
Y&Y et Blue Sky Research ont développé un ensemble de versions vectorielles de ces polices 
dans le cadre d'une entreprise commerciale. Ils ont depuis cédé les droits d'auteur à l'AMS 
et les polices sont désormais disponibles gratuitement auprès du CTAN. 
Leur qualité est telle qu'elles sont devenues la norme *de facto* pour les versions Type 1 des polices.


### Les *fontes AMS*, de l'American Mathematical Society 

Cet ensemble comprend 52 fontes, avec une mise à échelle optique.
Il offre des compléments à l'ensemble *Computer Modern*, 
y compris deux ensembles de polices de symboles (`msam` et `msbm`) et des polices de texte *Euler*. 
Ces dernières ne constituent pas une famille à part entière, mais méritent d'être évoquées ici 
(notamment parce que plusieurs autres familles imitent les polices de symboles). 
Les versions de type 1 de ces polices sont disponibles gratuitement sur CTAN. 
L'extension <ctanpkg:eulervm> permet d'utiliser l'alphabet mathématique *Euler*
en conjonction avec des polices de texte qui ne fournissent pas d'alphabet mathématique propre 
(par exemple, *Adobe Palatino* ou *Minion*).


### MathPazo, de Diego Puga

Comprenant 5 polices, *Pazo Math* est une famille de polices de type 1 
convenant à la composition de mathématiques en combinaison avec la famille de polices de texte *Palatino*. 
Quatre des cinq polices de l'extension associée, <ctanpkg:mathpazo>, sont des alphabets mathématiques, 
dans des formes droites et italiques, des graisses moyennes et grasses. 
La cinquième police contient une petite sélection de caractères 
"[gras du tableau](/4_domaines_specialises/mathematiques/symboles/symboles_d_ensembles)" 
(choisis pour leur signification mathématique). 
Le support de LaTeX2e est disponible dans 
[PSNFSS](/5_fichiers/formats/fontes/utiliser_des_fontes_adobe_t1_avec_tex).
Les polices sont sous licence GPL, avec un texte permettant l'utilisation des polices 
dans des documents publiés.


### *Fourier*/*Utopia*, de Michel Bovani

La famille *Fourier*, qui comprend 15 polices, est construite sur Adobe *Utopia* 
(mise à disposition gratuitement par Adobe). 
Les polices fournissent l'ensemble des symboles mathématiques de base de *Computer Modern*, 
et ajoutent de nombreux symboles mathématiques de l'AMS 
(bien que vous soyez censé utiliser certains des polices de l'AMS elles-mêmes). 
Il existe également plusieurs autres symboles mathématiques et décoratifs. 
Les polices sont livrées avec une extension <ctanpkg:fourier> pour une utilisation avec LaTeX.
Le support de l'encodage OT1 pour le texte n'est pas fourni ; vous devez utiliser T1.


### *Fourier*/*New Century Schoolbook*, de Michael Zedler

`Fouriernc` est une configuration utilisant les polices *Fourier* 
en lien avec des polices de texte *New Century Schoolbook*.


### *KP-fonts*, du projet Johannes Kepler

La famille `kp-fonts` fournit un ensemble complet de polices textuelles et mathématiques. 
L'ensemble comprend des polices de remplacement à chasse fixe et sans empattement
(bien que certaines sources suggèrent que ces dernières sont moins réussies, 
et devraient supprimées lors du chargement d'extension LaTeX <ctanpkg:kpfonts>). 
Le site du TUG en propose un [exemple](<https://tug.org/FontCatalogue/kpserif/>).


### MathDesign, de Paul Pichaureau

Cet ensemble propose jusqu'à présent trois polices mathématiques 
correspondant aux polices libres Adobe *Utopia*, URW *Garamond* et Bitstream *Charter*
(dont les versions texte sont toutes disponibles séparément, sur CTAN, au format Type 1), 
ainsi que 3 polices basées sur des polices commerciales Adobe *Garamond Pro*, Adobe *UtopiaStd*
et ITC *Charter* (toutes disponibles à l'achat sur le web). 
Le CTAN propose de nombreuses documentations et exemples. 
Le site du TUG propose des [exemples](<https://tug.org/FontCatalogue/kpserif/>)
de variantes libres d'URW *Garamond*.


### Belleek, de Richard Kinch

Belleek, avec ces 3 polices, est le résultat des réflexions de Richard Kinch sur la manière 
dont MetaFont pourrait être utilisé à l'avenir : 
ces polices ont été publiées simultanément en tant que source MetaFont, 
en tant que polices Type 1 et en tant que polices TrueType. 
Les polices remplacent directement l'ensemble MathTime de base 
(à titre d'exemple de "ce qui pourrait être fait").

Un [document](https://www.truetex.com/belleek.pdf) expose les réflexions de Kinch, 
partant de considérations sur la supériorité "intellectuelle" de MetaFont 
pour évaluer les raisons pour lesquelles son adoption est si limitée 
et ce qui pourrait être fait pour résoudre le problème.


### MTPro2 Lite, de Michael Spivak (*Publish or Perish, Inc*)

Un sous-ensemble (fonctionnel) du jeu de polices *MathTime Pro 2* a été mis à disposition 
gratuitement pour un usage général. Bien qu'il n'offre pas toutes les possibilitéis
du produit commercial (voir ci-dessous), il s'agit néanmoins d'un jeu de polices intéressant.


### Mathptmx, de Alan Jeffrey, Walter Schmidt et autres

Le jeu <ctanpkg:mathptmx> contient des polices virtuelles mathématiques italiques, symboles 
 et romaines, construites à partir des polices Adobe *Times*, *Symbol*, 
*Zapf Chancery* et *Computer Modern*. Le mélange résultant n'est pas tout à fait heureux 
mais peut passer dans de nombreuses circonstances. 
Le véritable avantage est que les polices *mathptm* sont (effectivement) gratuites, 
et que les fichiers PostScript qui en résultent peuvent être librement échangés. 
Le support sous LaTeX2e est disponible avec 
[PSNFSS](/5_fichiers/formats/fontes/utiliser_des_fontes_adobe_t1_avec_tex).


### *Computer Modern Bright Free*

Leur version vectorielle sont présentées ci-dessous avec leurs équivalents commerciaux.


### URW *Classico*

Ces 4 fontes, dont le support LaTeX est dû à Bob Tennent, sont des clones d'*Optima* de Zapf 
disponibles auprès du CTAN (pour un usage non commercial uniquement). 
Le support mathématique peut être fourni en utilisant les extensions <ctanpkg:eulervm> 
ou <ctanpkg:sansmath>. En tant que famille de polices sans-serif, 
*Optima* est particulièrement adaptée aux présentations.


## Fontes commerciales

Les polices capables de définir des mathématiques avec TeX et disponibles dans le commerce, 
comprennent :


### *BA Math*, de MicroPress Inc.

*BA Math* est une famille de 13 polices avec empattement, 
inspirée par l'élégance et la perfection graphique de John Baskerville. 
BA Math comprend les polices nécessaires à la composition mathématique 
(italique mathématique, symboles mathématiques et extensions) dans des graisses normales et grasses. 
La famille comprend également des polices de texte encodées OT1 et T1 de différentes formes, 
ainsi que des polices avec les glyphes les plus utiles de l'encodage TS1. 
Des commandes permettant d'utiliser les polices avec Plain TeX, 
LaTeX 2.09 et LaTeX actuel sont fournies. Des informations ont pu être trouvées sur une archive 
du [site de MicroPress](http://web.archive.org/web/20211016015138/http://www.micropress-inc.com/fonts/bamath/bamain.htm) 
mais la société n'existe plus.


### *CH Math*, de MicroPress Inc.

*CH Math* est une famille de 15 polices à empattement 
conçues pour accompagner Bitstream *Charter* dans le domaine des mathématiques. 
La distribution inclut quatre polices de texte Bitstream gratuites, 
en plus des 15 polices MicroPress. Des informations ont pu être trouvées sur une archive 
du [site de MicroPress](http://web.archive.org/web/20211016015135/http://www.micropress-inc.com/fonts/chmath/chmain.htm) 
mais la société n'existe plus.


### *Computer Modern Bright*, de Walter Schmidt

*Computer Modern Bright* est une famille de 62 polices sans empattement avec une mise à échelle optique, 
 basée sur les polices *Computer Modern* de Knuth. 
 Elle comprend les polices nécessaires à la composition mathématique, y compris les symboles AMS, 
 ainsi que des polices de texte et de symboles de différentes formes. 
 Cette collection est accompagnée de son propre ensemble de fichiers à utiliser avec LaTeX. 
 Les polices *Computer Modern Bright* sont fournies au format Type 1 par MicroPress, Inc. 
 L'ensemble <ctanpkg:hfbright> offre des polices Type 1 gratuites pour le texte utilisant l'encodage OT1 
 --- les polices <ctanpkg:cm-super> fournissent les polices dans l'encodage de texte T1 
 mais ne traitent pas les mathématiques *Computer Modern Bright*. 
 Des informations ont pu être trouvées sur une archive 
 du [site de MicroPress](http://web.archive.org/web/20211016015141/http://www.micropress-inc.com/fonts/brmath/brmain.htm)
 mais la société n'existe plus.


### *Concrete Math*, de Ulrik Vieth

Les 25 polices *Concrete Math* (avec une mise à échelle optique) 
sont dérivées des caractères *Concrete Roman* conçus par Knuth. 
Elles offrent une collection de polices mathématiques italiques, de symboles mathématiques et 
d'extensions mathématiques, ainsi que des polices de symboles AMS qui s'adaptent à *Concrete Roman*, 
de sorte que *Concrete* peut être utilisé comme remplacement complet de *Computer Modern*. 
Comme *Concrete* est considérablement plus sombre que *Computer Modern*, 
cette famille peut être particulièrement intéressante pour l'impression en basse résolution 
ou pour des cas particuliers comme les affiches ou les transparents. 
Les polices *Concrete Math*, ainsi que les polices *Concrete Roman*, 
sont fournies au format Type 1 par MicroPress, Inc. 
Des informations ont pu être trouvées sur une archive 
du [site de MicroPress](http://web.archive.org/web/20211016015141/http://www.micropress-inc.com/fonts/ccmath/ccmain.htm)
mais la société n'existe plus.


### *HV Math*, from MicroPress Inc.

*HV Math* est une famille de 14 polices de caractères sans empattement, 
inspirée de la police *Helvetica*. *HV Math* comprend les polices nécessaires 
à la composition mathématique (italique, symboles et extensions mathématiques) 
dans des graisses normales et grasses. 
La famille comprend également toutes les polices de texte encodées OT1 et T1 de différentes formes, 
ainsi que des polices contenant les glyphes les plus utiles de l'encodage TS1. 
Des commandes permettant d'utiliser les polices avec Plain TeX, LaTeX 2.09 et LaTeX sont fournies. 
Des copies matricielles des polices sont disponibles gratuitement sur CTAN. 
Des informations ont pu être trouvées sur une archive 
du [site de MicroPress](http://web.archive.org/web/20211016015143/http://www.micropress-inc.com/fonts/hvmath/hvmain.htm)
mais la société n'existe plus.


### *Informal Math*, de MicroPress Inc.

*Informal Math* est une famille de 7 polices vectorielles fantaisistes 
vaguement basées sur la famille *Tekton* d'Adobe, des polices qui imitent le texte écrit à la main. 
*Informal Math* comprend les polices nécessaires à la composition mathématique 
(italique, symboles et extensions mathématiques) en graisse normale, 
ainsi que des polices de texte encodées OT1 dans des formes droites et obliques. 
Des commandes permettant d'utiliser les polices avec Plain TeX, LaTeX 2.09 et LaTeX sont fournies. 
Des informations ont été trouvées sur une archive 
du [site de MicroPress](http://web.archive.org/web/20211016015133/http://www.micropress-inc.com/fonts/ifmath/ifmain.htm)
mais la société n'existe plus.


### *Lucida Bright* avec *Lucida New Math*, de Chuck Bigelow et Kris Holmes

*Lucida* est une famille de 25 polices apparentées comprenant des polices avec empattement, 
sans empattement, sans empattement à largeur fixe, calligraphiques, en *blackletter*, 
mais aussi la police d'écriture liée de Kris Holmes. 
Elles ne sont pas aussi "filiformes" que *Computer Modern*, avec une grande hauteur x, 
et comprennent un plus grand ensemble de symboles mathématiques, d'opérateurs, de relations et
de délimiteurs que *Computer Modern* (plus de 800 au lieu de 384). 
Elles comprennent également les ensembles de symboles AMS `msam` et `msbm`. 
*Lucida Bright Expert* (14 polices) ajoute à l'ensemble une largeur fixe sérifiée, 
une autre police d'écriture manuscrite, des petites capitales, des mathématiques grasses, 
des "mathématiques italiques" droites, etc. 
Le support de LaTeX est disponible avec PSNFSS. 
Des métriques pré-construites sont également fournies. 
Le TUG a le droit de distribuer ces polices : 
son site web dispose d'une [page](https://tug.org/lucida/) sur le sujet.


### Adobe *Lucida*, *LucidaSans* et *LucidaMath*

Dans ces 12 polices, *Lucida* et *LucidaMath* sont généralement considérées 
comme un peu trop grasses. Les trois polices mathématiques ne contiennent que 
les glyphes des polices *Computer Modern* (italique, symboles et extensions mathématiques). 
Le support pour l'utilisation de *LucidaMath* avec TeX n'est pas très bon.
Vous devrez travailler sur le réencodage des polices, etc. Dans un certain sens, 
cet ensemble est l'ancêtre de l'ensemble de polices *LucidaBright* plus *LucidaNewMath*, 
qui ne sont pas disponibles actuellement.


### *MathTime Pro2*, de Michael Spivak (*Publish or Perish Inc*.)

Cette dernière version de la famille MathTime couvre toutes les graisses 
(moyennes, grasses et épaisses) et tous les symboles des versions précédentes de *MathTime*. 
Elle dispose en outre d'une gamme de symboles beaucoup plus étendue 
et de nombreuses améliorations typographiques qui permettent d'obtenir des documents de grande qualité. 
Les polices sont supportées à la fois par Plain TeX et LaTeX2e.
Elles sont exclusivement disponibles à l'achat auprès de 
[Personal TeX Inc](/6_distributions/installation/implementations_commerciales).
Pour plus de détails, des échantillons et des prospectus, voir <https://pctex.com/mtpro2.html>.


### *Minion Pro* et *MnSymbolAdobe*, de Achim Blumensath *et al*.

*Minion Pro* dérive de la police OpenType commerciale largement disponible du même nom d'Adobe.
Des scripts sont fournis pour convertir les parties pertinentes de cette police au format Adobe Type 1. 
L'extension <ctanpkg:MinionPro> met en place le support texte et mathématique 
en utilisant *Minion Pro* mais un jeu de polices distinct (et gratuit) 
*MnSymbol* étend considérablement la couverture des symboles.


### *PA Math* 

*PA Math* est une famille de polices de caractères avec empattement basée sur *Palatino*. 
Elle comprend les polices nécessaires à la composition mathématique 
(italique, symboles et extensions mathématiques, symboles calligraphiques) 
dans les graisses normales et grasses. 
La famille comprend également toutes les polices de texte encodées OT1, T1 de différentes formes, 
ainsi que des polices avec les glyphes les plus utiles de l'encodage TS1. 
Des commandes permettant d'utiliser les polices avec Plain TeX, LaTeX 2.09 et LaTeX sont fournies.
Des informations ont pu être trouvées sur une archive
du [site de MicroPress](http://web.archive.org/web/20211016015125/http://www.micropress-inc.com/fonts/pamath/pamain.htm)
mais la société n'existe plus.


### *TM Math*, de MicroPress Inc.

*TM Math* est une famille de 14 polices de caractères avec empattement, inspirée de la police *Times*. 
*TM Math* comprend les polices nécessaires à la composition mathématique 
(italique, symboles et extensions mathématiques)  en graisses normales et grasses. 
La famille comprend également toutes les polices de texte encodées OT1 et T1 de différentes formes, 
ainsi que des polices contenant les glyphes les plus utiles de l'encodage TS1. 
Des commandess permettant d'utiliser les polices avec Plain TeX, LaTeX 2.09 et LaTeX sont fournies. 
Des copies matricielles des polices sont disponibles gratuitement sur CTAN. 
Des informations ont pu être trouvées sur une archive 
du [site de MicroPress](http://web.archive.org/web/20211016015120/http://www.micropress-inc.com/fonts/tmmath/tmmain.htm) 
mais la société n'existe plus.


### <ctanpkg:pxfonts>, <ctanpkg:txfonts> et leurs dérivés

Ces deux jeux de polices doivent être mentionnés, 
même s'ils ne produisent pas actuellement des résultats satisfaisants. 
Leur auteur ne travaille plus dessus, et plusieurs problèmes ont été identifiés.


#### L'ensemble *Pxfonts* version 1.0 (26 fonts) by Young Ryu.


L'ensemble <ctanpkg:pxfonts> est constitué de 26 polices :

  - des polices de texte virtuelles utilisant Adobe *Palatino* 
  (ou son remplaçant URW *Palladio*) avec des symboles plus, égal et barre oblique modifiés ;
  - des alphabets mathématiques utilisant *Palatino* (ou *Palladio*) ;
  - des polices mathématiques de tous les symboles des polices mathématiques modernes 
  (`cmsy`, `cmmi`, `cmex` et les lettres grecques de `cmr`) ;
  - des polices mathématiques de tous les symboles correspondant aux polices AMS 
  (`msam` et `msbm`) ;
  - des polices mathématiques supplémentaires pour divers symboles.

Les polices de texte sont disponibles dans les encodages OT1, T1 et LY1. 
Les symboles encodés TS sont également disponibles. 
Les polices sans serif et à chasse fixe fournies avec l'ensemble `txfonts` 
(voir ci-dessous) peuvent être utilisées avec `pxfonts`. 
L'ensemble `txfonts` devrait être installé lorsque `pxfonts` l'est. 
Les fichiers de support LaTeX, `dvips` et pdfTeX sont inclus.

Les polices ne sont pas parfaites. Les largeurs assignées aux caractères 
dans le fichier `tfm` sont erronées pour certains glyphes. 
Ceci peut causer des séquences de caractères qui paraissent erronées, 
ou même, dans certains cas, qui se chevauchent. 
Les polices `newtx` visent à réduire ces problèmes.

Les polices sont sous licence GPL. Leur utilisation dans des publications est autorisée.


#### *Newpx*, de Michael Sharpe

Cette collection est dérivée de `pxfonts` de Young Ryu.
Les métriques des polices mathématiques ont été ajustées 
pour que le résultat soit moins compacte que lorsque `pxfonts` est utilisé, 
ce qui l'améliore grandement. 
Deux extensions sont fournies : [newpxtext](ctanpkg:newpx) pour utiliser les polices de texte
et [newpxmath](ctanpkg:newpx) pour les mathématiques.


#### L'ensemble *Txfonts*, de Young Ryu 

L'ensemble `txfonts` se compose de 42 polices :

  - des polices de texte virtuelles utilisant Adobe *Times* 
  (ou la police URW *Nimbus Roman No9 L* qui remplace *Times* 
  et qui est distribuée dans le cadre de la collection URW "basic 35") 
  avec des symboles plus, égal et barre oblique modifiés ;
  - des jeux de polices sans empattement et à chasse fixe 
  (le jeu de polices sans empattement est basé sur Adobe *Helvetica*) ;
  - des alphabets mathématiques utilisant Adobe *Times*, 
  ou l'équivalent URW *Nimbus Roman No9* ;
  - des polices mathématiques de tous les symboles des polices mathématiques modernes 
  (`cmsy`, `cmmi`, `cmex` et les lettres grecques de `cmr`) ;
  - des polices mathématiques de tous les symboles correspondant aux polices AMS 
  (`msam` et `msbm`) ;
  - des polices mathématiques supplémentaires pour divers symboles.

Les polices de texte sont disponibles dans les encodages OT1, T1 et LY1. 
Des symboles encodés TS sont également disponibles.

Ces polices ne sont pas parfaites : les largeurs assignées aux caractères 
dans le fichier `tfm` sont erronées pour certains glyphes. 
Ceci peut causer des séquences de caractères qui paraissent erronées, 
ou même, dans certains cas, qui se chevauchent. 
Les polices `newtx` visent à réduire ces problèmes.

Les polices sont sous licence GPL. Leur utilisation dans des publications est autorisée.


#### L'extension <ctanpkg:txfontsb>, de Young Ryu et Antonis Tsolomitis

L'extension <ctanpkg:txfontsb> regroupe `txfonts`, étendu pour fournir un jeu de petites capitales, 
des chiffres de style ancien et des caractères grecs (à partir du jeu de polices GNU *Freefont*). 
La [documentation](ctanpkg:txfontsb) est également disponible pour cette variante.


#### *Newtxby*, de Michael Sharpe

Cette collection est dérivée de `txfonts` de Young Ryu. 
Les métriques des polices mathématiques ont été ajustées 
pour que le résultat soit moins compact que lorsque `txfonts` est utilisé, ce qui l'améliore grandement.
Deux extensions sont fournies : [newtxtext](ctanpkg:newtx) pour utiliser les polices de texte 
et [newtxmath](ctanpkg:newtx) pour les mathématiques. 
Des options sont fournies pour remplacer les lettres et les symboles de l'ensemble *Libertine*
et de la police *Garamond* de l'extension [garamondx](ctanpkg:garamondx) 
(mais notez que [garamondx](ctanpkg:garamondx), qui est une adaptation de URW *Garamond*, 
n'est pas disponible via TeX Live).


### Autres fontes commerciales

Enfin, il ne faut pas oublier les polices propriétaires provenant de diverses sources. 
Disposer d'un jeu de polices vectorielles de haute qualité fonctionnant avec TeX 
peut donner à un éditeur un réel avantage concurrentiel. Aussi, certains éditeurs ont payé 
(très cher) pour que de tels jeux de polices soient créés pour eux. 
Malheureusement, ces jeux ne sont pas disponibles gratuitement, 
même s'il est probable qu'ils soient plus complets que ceux qui le sont.

Il semble n'exister qu'une liste très limitée de jeux de polices mathématiques commerciales.
Une police mathématique de type 1 doit être explicitement conçue pour être utilisée avec TeX, 
ce qui est une entreprise coûteuse, et présente peu d'intérêt pour les autres marchés. 
En outre, le marché des polices commerciales TeX est minuscule 
par rapport aux ventes considérables d'autres jeux de polices.

Les polices de texte au format Type 1 sont disponibles auprès de nombreux fournisseurs, 
dont Adobe, Monotype et Bitstream. Toutefois, il convient de se méfier des "collections"
de polices bon marché. Nombre d'entre elles contournent les restrictions 
en matière de droits d'auteur en supprimant (ou en bloquant) 
certaines parties des programmes de polices, telles que les indices. 
Un tel comportement est à la fois contraire à l'éthique et mauvais pour le consommateur. 
Les polices peuvent ne pas avoir un bon rendu (ou pas de rendu du tout, sous ATM), 
ne pas avoir le complément "standard" de 228 glyphes, 
ou ne pas inclure de fichiers métriques (dont vous avez besoin pour créer des fichiers TFM).

TrueType a longtemps été le format "natif" pour Windows 
mais MicroSoft a rejoint le développement de la spécification OpenType, 
et les versions récentes de Windows fonctionneront sans problème 
avec des polices de ces deux formats. 
Certaines implémentations de TeX telles que [TrueTeX](faquk:FAQ-commercial) 
utilisent les versions TrueType des polices *Computer Modern* et *Times Maths*
pour rendre les documents TeX sous Windows 
sans avoir besoin d'un logiciel système supplémentaire comme ATM.
Lorsqu'il est utilisé sur un système fonctionnant sous Windows XP ou une version ultérieure, 
TrueTeX peut également utiliser les polices Adobe Type 1.

Lors du choix des polices, vous devrez parfois tenir compte d'environnements logiciels différents du vôtre. 
En effet, si vous devez envoyer vos documents finis à d'autres personnes pour qu'elles les utilisent, 
vous devez vous demander si un format de police donné posera des problèmes de compatibilité. 
Les éditeurs peuvent exiger exclusivement des polices TrueType 
parce que leurs systèmes sont basés sur Windows, ou exclusivement des polices Type 1 
parce que leurs systèmes sont basés sur la popularité (initiale) de ce format dans l'industrie de l'édition.
De nombreux intervenants s'en moquent tant que vous leur présentez un fichier d'impression fini 
(PostScript ou PDF) pour leur périphérique de sortie.


:::{sources}
[Choice of Type 1 fonts for typesetting Maths](faquk:FAQ-psfchoice)
:::
