/*

Pro svou instalaci OS/2 upravil Kuben (kuben@scova.vabo.cz) podle verze 
dodan k dvips, 23.5.1998.
Translated from Piet Tutelaar's Unix shell script
into Rexx by Sebastian Rahtz, 15.8.92 (spqr@minster.york.ac.uk)

===================================================================================

   This script file makes a new TeX PK font, because one wasn't
   found.  Parameters are:

   name dpi bdpi magnification [[mode] subdir]

   `name' is the name of the font, such as `cmr10'.  `dpi' is
   the resolution the font is needed at.  `bdpi' is the base
   resolution, useful for figuring out the mode to make the font
   in.  `magnification' is a string to pass to MF as the
   magnification.  `mode', if supplied, is the mode to use.

   Prvn se budou hledat T1 fonty v souboru EMTEXDIR\DATA\DVIPS\adobe.sez.
   Pokud se najdou, bude sputen program ps2pk.
   V opanm ppad bude sputn maketexp.cmd.

*/


call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
os2env='OS2ENVIRONMENT'

/****  SENSIBLE SETUP VALUES  ****/

/* The emtex base directory default when EMTEXDIR is not set */
EMTEXDIR_DEFAULT='d:\emtex'

/* base path for emtex */
EMTEXDIR=value('EMTEXDIR','',os2env)
if EMTEXDIR='' then do
        EMTEXDIR=EMTEXDIR_DEFAULT
end

/* Verze ghostscriptu */
GS_VER=601

/* The T1INPUTS default directories, when T1INPUTS is not set */
T1INPUTS_DEFAULT=EMTEXDIR'\GS\GS'GS_VER'\fonts;'EMTEXDIR'\DATA\DVIPS\FONTY;'EMTEXDIR'\DATA\DVIPS'

/* The TEXCONFIG default directory, when TEXCONFIG is not set */
TEXCONFIG_DEFAULT=EMTEXDIR'\data\dvips'

/* The DVIDRVFONTS default directory, when DVIDRVFONTS is not set */
DVIDRVFONTS_DEFAULT=EMTEXDIR'\texfonts'


PARSE Arg all_args
argc=words(all_args)
if ( argc < 4  | argc > 5 ) then
do
   say "Usage: make_pk fontname dpi bdpi magnification [mode]"
   exit 1
end

/* Where we look for Type1 fonts and AFM files */
T1INPUTS=value('T1INPUTS',,os2env)
if T1INPUTS='' then
do
        T1INPUTS=value('T1INPUTS',T1INPUTS_DEFAULT,os2env)
        T1INPUTS=value('T1INPUTS',,os2env)
end


/* Where we look for dvips stuff */
TEXCONFIG=value('TEXCONFIG',,os2env)
if TEXCONFIG='' then do
        TEXCONFIG=TEXCONFIG_DEFAULT
end
listoftype1files=TEXCONFIG'\adobe.sez'


NAME=word(all_args,1)
DPI=word(all_args,2)
BDPI=word(all_args,3)
MAG=word(all_args,4)
if argc > 4 then
        MODE=word(all_args,5)
else
   if BDPI = 300   then
      MODE='laserjet'
   else if BDPI = 600    then
      MODE='laserjetIV'
   else if BDPI = 1270   then
      MODE='linohi'
   else if BDPI = 2540   then
      MODE='linosuper'
   else
    do
      say 'I do not know the mode for ' BDPI
      say 'update this Make_PK script'
      exit 1
    end

/* destination of pk files */
DVIDRVFONTS=value('DVIDRVFONTS',,os2env)
if DVIDRVFONTS = '' then
        DVIDRVFONTS=DVIDRVFONTS_DEFAULT
if  MODE='laserjet' then
        DESTDIR=DVIDRVFONTS'\LJ'
else if MODE='deskjet' then
        DESTDIR=DVIDRVFONTS'\DJ'
else if MODE='laserjetIV' then
        DESTDIR=DVIDRVFONTS'\LJH'
else if MODE='epsonfx' then
        DESTDIR=DVIDRVFONTS'\FX'
else if MODE='lqlores' then
        DESTDIR=DVIDRVFONTS'\LQL'


say 'making for ' MODE ' in ' DESTDIR
call sysfiletree DESTDIR ,'test', 'OD'
if test.0=0 then
      call SysMkDir DESTDIR
SUBDIR='dpi'DPI
DESTDIR=DESTDIR'\'SUBDIR
call sysfiletree DESTDIR ,'test', 'OD'
if test.0=0 then
      call SysMkDir DESTDIR

PKNAME=NAME'.pk'
destpk=DESTDIR'\'PKNAME

fname = stream(destpk , 'C', 'QUERY EXISTS')
if \ (fname ='') then
  do
     say DESTDIR'\'PKNAME 'already exists!'
    exit 0
  end

/* OK, try to make the font by some means */

/* first try Adobe Type1 fonts */

file.0=0
call sysfilesearch NAME' ', listoftype1files, 'FILE.', 'C'
/* if that succeeded, the variable FILE contains the
matching lines in the file describing the fonts */
if rc=3 then
do
   say 'You should install file ' listoftype1files
   exit 0
end
ZDROJ=''
KODOVANI=''
SKLON=''
ROZSIRENI=''
if FILE.0>0 then
   do i=1 to file.0
        if word(file.i,1)=NAME then
                do
                ZDROJ=word(file.i,2)
                if \ (word(file.i,3) = 'NE') then
                   KODOVANI=word(file.i,3)
                if \ (word(file.i,4) = 'NE') then
                   SKLON=word(file.i,4)
                if \ (word(file.i,5) = 'NE') then
                   ROZSIRENI=word(file.i,5)
                leave
                end
   end
if ZDROJ='' then  /* failed to locate a name in the list */
do
        say 'No entry for PS font'  NAME 'in' listoftype1files||'.'
        say 'METAFONT will be tried.'
        signal VOLAT_MF
end

/* CELYZDROJ=syssearchpath('T1INPUTS',ZDROJ)  */
/* T1INPUTS mus bt stavov promnn */
CELYZDROJ=syssearchpath('T1INPUTS',ZDROJ)
        say 'Result of PFB search: 'CELYZDROJ
        if CELYZDROJ='' then
        do
              say 'Sorry, no PostScript font found'
              exit 1
        end

ZVETSENI=bdpi * mag

if \ (KODOVANI='') then
  KODOVANI='-e '||KODOVANI

if \ (SKLON='') then
  SKLON='-S '||SKLON

if \ (ROZSIRENI='') then
  ROZSIRENI='-E '||ROZSIRENI

job='ps2pk -v ' KODOVANI '-X '||ZVETSENI SKLON ROZSIRENI ZDROJ DESTPK

/* say job */
job
exit 0

VOLAT_MF:
job='call maketexp.cmd' NAME DPI BDPI MAG MODE
/* say job */
job

/* say "Konec" */

exit 0
