/*
 * Decompiled with CFR 0.152.
 */
package nts.typo;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import nts.base.Dimen;
import nts.base.Glue;
import nts.base.Num;
import nts.builder.OutputBuilder;
import nts.command.CommandBase;
import nts.command.CountPrim;
import nts.command.DimenPrim;
import nts.command.SkipPrim;
import nts.command.TokenList;
import nts.io.Log;
import nts.node.Box;
import nts.node.Node;
import nts.node.NodeList;
import nts.node.PageSplit;
import nts.node.PenaltyNode;
import nts.node.VBoxNode;
import nts.node.VoidBoxNode;
import nts.typo.Page;
import nts.typo.SetBoxPrim;
import nts.typo.TypoCommand;
import nts.typo.VSplitPrim;
import nts.typo.VertGroup;

public abstract class Page
extends TypoCommand {
    public static final int BOOLP_TRACING_PAGES = CommandBase.newBoolParam();
    public static final int DIMP_VSIZE = CommandBase.newDimParam();
    public static final int DIMP_MAX_DEPTH = CommandBase.newDimParam();
    public static final int GLUEP_TOP_SKIP = CommandBase.newGlueParam();
    public static final int TOKSP_OUTPUT = CommandBase.newToksParam();
    public static final int INTP_MAX_DEAD_CYCLES = CommandBase.newIntParam();
    public static final int BOOLP_HOLDING_INSERTS = CommandBase.newBoolParam();
    private static List pageList;

    private static boolean tracing() {
        return CommandBase.getConfig().getBoolParam(BOOLP_TRACING_PAGES);
    }

    private static String badToString(int b) {
        return b >= 0x3FFFFFFF ? "*" : Integer.toString(b);
    }

    public static PageSplit getPageSplit() {
        return pageList;
    }

    public static List getPageList() {
        return pageList;
    }

    public static void makeStaticData(CountPrim countReg, DimenPrim dimenReg, SkipPrim skipReg, SetBoxPrim boxReg, TokenList.Maintainer topMark, TokenList.Maintainer firstMark, TokenList.Maintainer botMark) {
        pageList = new List(countReg, dimenReg, skipReg, boxReg, topMark, firstMark, botMark);
    }

    public static void writeStaticData(ObjectOutputStream output) throws IOException {
        output.writeObject(pageList);
    }

    public static void readStaticData(ObjectInputStream input) throws IOException, ClassNotFoundException {
        pageList = (List)input.readObject();
    }

    public abstract void addOn(Log var1);

    public static class List
    extends PageSplit {
        private static final TypoCommand.VBoxPacker pagePacker = new 1();
        private final CountPrim countReg;
        private final DimenPrim dimenReg;
        private final SkipPrim skipReg;
        private final SetBoxPrim boxReg;
        private final TokenList.Maintainer topMark;
        private final TokenList.Maintainer firstMark;
        private final TokenList.Maintainer botMark;
        protected boolean active = false;
        public int deadCycles = 0;

        public boolean outputActive() {
            return this.active;
        }

        public boolean canChangeNums() {
            return true;
        }

        public void build() {
            if (!this.active) {
                super.build();
            }
        }

        public boolean canChangeDimens() {
            return super.canChangeDimens() && !this.active;
        }

        public void show(Log log, int depth, int breadth) {
            this.show(log, depth, breadth, this.active);
        }

        public int getDeadCycles() {
            return this.deadCycles;
        }

        public void resetDeadCycles() {
            this.deadCycles = 0;
        }

        protected void initSpecs() {
            this.goal = CommandBase.getConfig().getDimParam(DIMP_VSIZE);
            this.maxDepth = CommandBase.getConfig().getDimParam(DIMP_MAX_DEPTH);
            if (Page.tracing()) {
                CommandBase.diagLog.startLine().add("%% goal height=").add(this.goal.toString()).add(", max depth=").add(this.maxDepth.toString()).startLine();
            }
        }

        protected void setInsVBox(int num, Box box) {
            this.boxReg.foist(num, box);
        }

        protected Box getInsVBox(int num) {
            Box box = this.boxReg.get(num);
            if (!box.isVoid() && !box.isVBox()) {
                CommandBase.error("MisplacedInsert");
                this.boxReg.showAndPurge(num);
                box = this.boxReg.get(num);
            }
            return box;
        }

        protected Glue getInsSkip(int num) {
            Glue skip = this.skipReg.get(num);
            if (skip.getShrOrder() != 0 && !skip.getShrink().isZero()) {
                CommandBase.error("InfShrinkInsert", this.skipReg, CommandBase.num(num));
            }
            return skip;
        }

        protected Dimen getInsSize(int num) {
            return this.dimenReg.get(num);
        }

        protected int getInsFactor(int num) {
            return this.countReg.get(num).intVal();
        }

        protected void foistOutputBox(Box box) {
            this.boxReg.foist(CommandBase.getConfig().getIntParam(TypoCommand.INTP_OUTPUT_BOX_NUM), box);
        }

        protected void checkOutputBox(String ident) {
            int num = CommandBase.getConfig().getIntParam(TypoCommand.INTP_OUTPUT_BOX_NUM);
            if (!this.boxReg.get(num).isVoid()) {
                CommandBase.error(ident, CommandBase.esc(this.boxReg.getDesc()), CommandBase.num(num));
                this.boxReg.showAndPurge(num);
            }
        }

        protected void traceSplitCost(int num, Dimen space, Dimen best, int cost) {
            if (Page.tracing()) {
                CommandBase.diagLog.startLine().add("% split").add(num).add(" to ").add(space.toString()).add(',').add(best.toString()).add(" p=").add(cost).startLine();
            }
        }

        protected boolean insertsWanted() {
            return !CommandBase.getConfig().getBoolParam(BOOLP_HOLDING_INSERTS);
        }

        protected Node splitTopAdjustment(Dimen height, Glue topSkip) {
            return VSplitPrim.makeTopAdjustment(height, TypoCommand.GLUEP_SPLIT_TOP_SKIP, topSkip);
        }

        protected Node topAdjustment(Dimen height) {
            return VSplitPrim.makeTopAdjustment(height, GLUEP_TOP_SKIP);
        }

        protected void traceCost(int pen, int bad, int cost, boolean best) {
            if (Page.tracing()) {
                CommandBase.diagLog.startLine().add("% t=").add(this.soFar.toString()).add(" g=").add(this.goal.toString()).add(" b=").add(Page.badToString(bad)).add(" p=").add(pen).add(" c=").add(Page.badToString(cost));
                if (best) {
                    CommandBase.diagLog.add('#');
                }
                CommandBase.diagLog.startLine();
            }
        }

        protected boolean performOutput(NodeList list, Dimen height) {
            this.setOutputPenalty();
            this.setMarks(list);
            this.checkOutputBox("NonEmptyOutBox");
            VBoxNode box = pagePacker.packVBox(list, height, true, this.maxDepth);
            TokenList.Inserter output = CommandBase.getConfig().getToksInserter(TOKSP_OUTPUT);
            if (!output.isEmpty()) {
                this.foistOutputBox(box);
                if (this.deadCycles < CommandBase.getConfig().getIntParam(INTP_MAX_DEAD_CYCLES)) {
                    this.active = true;
                    ++this.deadCycles;
                    List list2 = this;
                    if (list2 == null) {
                        throw null;
                    }
                    CommandBase.pushLevel(list2.new OutputGroup());
                    output.insertToks();
                    CommandBase.scanLeftBrace();
                    this.depth = Dimen.ZERO;
                    return true;
                }
                CommandBase.error("TooMuchDead", CommandBase.num(this.deadCycles));
            }
            this.foistOutputBox(VoidBoxNode.BOX);
            TypoCommand.shipOut(box);
            this.startNextPage();
            return false;
        }

        private void setOutputPenalty() {
            int pen = -10000;
            if (!this.isEmpty()) {
                pen = 10000;
                Node node = this.nodeAt(0);
                if (node.isPenalty()) {
                    this.data.set(0, new PenaltyNode(Num.valueOf(pen)));
                    pen = node.getPenalty().intVal();
                }
            }
            TypoCommand.getTypoConfig().setOutputPenalty(pen);
        }

        private void setMarks(NodeList list) {
            this.topMark.setToksValue(this.botMark.getToksValue());
            if (!VSplitPrim.setMarks(list.nodes(), this.firstMark, this.botMark)) {
                this.firstMark.setToksValue(this.topMark.getToksValue());
            }
        }

        public List(CountPrim countReg, DimenPrim dimenReg, SkipPrim skipReg, SetBoxPrim boxReg, TokenList.Maintainer topMark, TokenList.Maintainer firstMark, TokenList.Maintainer botMark) {
            this.countReg = countReg;
            this.dimenReg = dimenReg;
            this.skipReg = skipReg;
            this.boxReg = boxReg;
            this.topMark = topMark;
            this.firstMark = firstMark;
            this.botMark = botMark;
        }

        public class OutputGroup
        extends VertGroup {
            public void stop() {
                CommandBase.getTokStack().dropFinishedPop();
                super.stop();
            }

            public void close() {
                List.this.active = false;
                List.this.insertPenalties = 0;
                List.this.checkOutputBox("NonEmptyOutBoxAfter");
                List.this.startNextPage(this.builder.getList().nodes());
                super.close();
                List.this.build();
            }

            protected OutputGroup() {
                super(new OutputBuilder(CommandBase.currLineNumber()));
            }
        }
    }
}

