/*
 * Decompiled with CFR 0.152.
 */
package nts.node;

import nts.base.Glue;
import nts.io.CntxLog;
import nts.io.Log;
import nts.node.BreakingCntx;
import nts.node.DiscardableNode;
import nts.node.FontMetric;
import nts.node.NodeEnum;
import nts.node.NodeList;

public abstract class AnySkipNode
extends DiscardableNode {
    protected final Glue skip;

    public Glue getSkip() {
        return this.skip;
    }

    public boolean isSkip() {
        return true;
    }

    public void addOn(Log log, CntxLog cntx) {
        log.addEsc("glue");
        String name = this.getName();
        if (name != null) {
            log.add('(').addEsc(name).add(')');
        }
        log.add(' ').add(this.skip.toString());
    }

    public FontMetric addShortlyOn(Log log, FontMetric metric) {
        if (!this.skip.isZero()) {
            log.add(' ');
        }
        return metric;
    }

    public String getName() {
        return null;
    }

    public boolean canFollowKernBreak() {
        return true;
    }

    public NodeEnum atBreakReplacement() {
        return NodeList.EMPTY_ENUM;
    }

    public int breakPenalty(BreakingCntx brCntx) {
        return brCntx.spaceBreaking() && brCntx.allowedAtSkip() ? 0 : 10000;
    }

    public AnySkipNode(Glue skip) {
        this.skip = skip;
    }
}

