/*
 * Decompiled with CFR 0.152.
 */
package nts.hyph;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;
import nts.hyph.WordMap;
import nts.hyph.WordTrie;

public class WordTree
implements WordMap {
    public static final WordTree NULL;
    public static final Entry NULL_ENTRY;
    public static final Pack NULL_PACK;
    private final Entry root = new Entry('\u0000', null);
    private int count = 0;
    private char maxCode = '\u0000';

    private static boolean sameObjects(Object x, Object y) {
        return x == null ? y == null : x.equals(y);
    }

    private Entry find(Entry from, char code) {
        Entry ent = from.below;
        while (ent != null) {
            if (code == ent.code) {
                return ent;
            }
            if (code < ent.code) break;
            ent = ent.next;
        }
        return null;
    }

    private Entry get(Entry from, char code) {
        boolean first = true;
        Entry ent = from.below;
        while (ent != null) {
            if (code == ent.code) {
                return ent;
            }
            if (code < ent.code) break;
            first = false;
            from = ent;
            ent = from.next;
        }
        ent = new Entry(code, ent);
        if (first) {
            from.below = ent;
        } else {
            from.next = ent;
        }
        if (this.maxCode < code) {
            this.maxCode = code;
        }
        ++this.count;
        return ent;
    }

    private Entry find(Entry from, String word) {
        int i = 0;
        while (i < word.length() && from != null) {
            from = this.find(from, word.charAt(i));
            ++i;
        }
        return from;
    }

    private Entry get(Entry from, String word) {
        int i = 0;
        while (i < word.length()) {
            from = this.get(from, word.charAt(i));
            ++i;
        }
        return from;
    }

    public Object get(String word) {
        Entry ent = this.find(this.root, word);
        return ent != null ? ent.value : null;
    }

    public Object put(String word, Object value) {
        Entry ent = this.get(this.root, word);
        Object old = ent.value;
        ent.value = value;
        return old;
    }

    public WordMap.Seeker seeker() {
        WordTree wordTree = this;
        if (wordTree == null) {
            throw null;
        }
        return wordTree.new Seeker();
    }

    public Enumeration entries() {
        WordTree wordTree = this;
        if (wordTree == null) {
            throw null;
        }
        return wordTree.new Enum();
    }

    public WordMap packed() {
        Pack compressed = new Compressor().compress(this.root.below);
        WordTree wordTree = this;
        if (wordTree == null) {
            throw null;
        }
        WordTrie.Entry[] tab = wordTree.new Packer().packed(compressed);
        return new WordTrie(tab, this.maxCode);
    }

    private static class Entry
    implements Serializable {
        final char code;
        Object value;
        Entry below;
        Entry next;

        public Entry(char code, Object value, Entry below, Entry next) {
            this.code = code;
            this.value = value;
            this.below = below;
            this.next = next;
        }

        public Entry(char code, Entry next) {
            this.code = code;
            this.value = null;
            this.below = null;
            this.next = next;
        }
    }

    public class Seeker
    implements WordMap.Seeker {
        private Entry curr;

        public void reset() {
            this.curr = WordTree.this.root;
        }

        public boolean isValid() {
            return this.curr != null;
        }

        public void seek(char code) {
            if (this.curr != null) {
                this.curr = WordTree.this.find(this.curr, code);
            }
        }

        public Object get() {
            return this.curr != null ? this.curr.value : null;
        }

        public Seeker() {
            this.curr = WordTree.this.root;
        }
    }

    private class Enum
    implements Enumeration {
        private Stack stack = new Stack();
        private Entry curr;

        private void step() {
            block6: {
                if (this.curr.below != null) {
                    this.stack.push(this.curr);
                    this.curr = this.curr.below;
                } else if (this.curr.next != null) {
                    this.curr = this.curr.next;
                } else {
                    do {
                        if (this.stack.empty()) {
                            this.curr = null;
                            break block6;
                        }
                        this.curr = (Entry)this.stack.pop();
                    } while (this.curr.next == null);
                    this.curr = this.curr.next;
                }
            }
        }

        public boolean hasMoreElements() {
            return this.curr != null;
        }

        public Object nextElement() {
            if (this.curr == null) {
                throw new NoSuchElementException("WordTree is finished");
            }
            Enum enum_ = this;
            if (enum_ == null) {
                throw null;
            }
            Map.Entry mapEnt = new Map.Entry(enum_){
                private Entry ent;
                private String key;
                private final /* synthetic */ Enum this$0;

                private String makeKey() {
                    char[] codes = new char[Enum.access$1(this.this$0).size() + 1];
                    int i = 0;
                    while (i < Enum.access$1(this.this$0).size()) {
                        codes[i] = ((Entry)Enum.access$1((Enum)this.this$0).get((int)i)).code;
                        ++i;
                    }
                    codes[i] = Enum.access$0((Enum)this.this$0).code;
                    return new String(codes);
                }

                public Object getKey() {
                    return this.key;
                }

                public Object getValue() {
                    return this.ent.value;
                }

                public Object setValue(Object value) {
                    Object old = this.ent.value;
                    this.ent.value = value;
                    return old;
                }
                {
                    this.this$0 = this$0;
                    this.ent = Enum.access$0(this.this$0);
                    this.key = this.makeKey();
                    this.constructor$0(this$0);
                }

                private final void constructor$0(Enum enum_) {
                }
            };
            this.step();
            return mapEnt;
        }

        static /* synthetic */ Entry access$0(Enum enum_) {
            return enum_.curr;
        }

        static /* synthetic */ Stack access$1(Enum enum_) {
            return enum_.stack;
        }

        Enum() {
            this.curr = ((WordTree)WordTree.this).root.below;
        }
    }

    private static class Pack {
        final char code;
        final Object value;
        final Pack below;
        final Pack next;
        int start = 0;

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Pack)) {
                return false;
            }
            Pack that = (Pack)obj;
            return this.code == that.code && WordTree.sameObjects(this.value, that.value) && this.below == that.below && this.next == that.next;
        }

        public int hashCode() {
            int h = 191 * this.code;
            if (this.value != null) {
                h += 313 * this.value.hashCode();
            }
            if (this.below != null) {
                h += 1009 * this.below.hashCode();
            }
            if (this.next != null) {
                h += 1571 * this.next.hashCode();
            }
            return h;
        }

        public Pack(char code, Object value, Pack below, Pack next) {
            this.code = code;
            this.value = value;
            this.below = below;
            this.next = next;
        }
    }

    private static class Compressor {
        private HashMap shareMap = new HashMap();
        private int shared = 0;

        public int sharedCount() {
            return this.shared;
        }

        public Pack compress(Entry ent) {
            if (ent != null) {
                Pack pack = new Pack(ent.code, ent.value, this.compress(ent.below), this.compress(ent.next));
                Pack hashed = (Pack)this.shareMap.get(pack);
                if (hashed == null) {
                    this.shareMap.put(pack, pack);
                } else {
                    pack = hashed;
                    ++this.shared;
                }
                return pack;
            }
            return null;
        }

        Compressor() {
        }
    }

    private class Packer {
        private BitSet taken;
        private BitSet used;
        private WordTrie.Entry[] table;

        public WordTrie.Entry[] packed(Pack pack) {
            this.taken = new BitSet(WordTree.this.count);
            this.used = new BitSet(WordTree.this.count);
            this.taken.set(WordTree.this.maxCode);
            this.used.set(0);
            int start = pack != null ? this.allocate(pack) : 0;
            int size = this.used.size();
            while (!this.used.get(size - 1)) {
                --size;
            }
            this.used = null;
            this.taken = null;
            WordTrie.Entry[] tab = new WordTrie.Entry[size];
            tab[0] = new WordTrie.Entry('\u0000', start, null);
            if (start != 0) {
                this.table = tab;
                this.distribute(pack, start);
                this.table = null;
            }
            return tab;
        }

        private void distribute(Pack pack, int start) {
            do {
                this.table[start + pack.code] = new WordTrie.Entry(pack.code, pack.start, pack.value);
                if (pack.start == 0) continue;
                this.distribute(pack.below, pack.start);
            } while ((pack = pack.next) != null);
        }

        private int allocate(Pack pack) {
            int start = this.firstFit(pack);
            do {
                if (pack.below == null || pack.start != 0) continue;
                pack.start = this.allocate(pack.below);
            } while ((pack = pack.next) != null);
            return start;
        }

        private int firstFit(Pack pack) {
            int start = '\u0001' - pack.code;
            while (true) {
                if (this.taken.get(start + WordTree.this.maxCode)) {
                    ++start;
                    continue;
                }
                Pack p = pack;
                while (!this.used.get(start + p.code)) {
                    p = p.next;
                    if (p != null) continue;
                    this.taken.set(start + WordTree.this.maxCode);
                    Pack q = pack;
                    do {
                        this.used.set(start + q.code);
                    } while ((q = q.next) != null);
                    return start;
                }
                ++start;
            }
        }

        Packer() {
        }
    }
}

