/*
 * Decompiled with CFR 0.152.
 */
package nts.command;

import nts.command.FileName;
import nts.command.FilePos;
import nts.command.SequenceTokenizer;
import nts.command.Tokenizer;
import nts.io.InputLine;
import nts.io.LineInput;

public class LineInputTokenizer
extends SequenceTokenizer {
    private LineInput input;
    private InputHandler inpHandler;
    private FileName name;
    private boolean forceEOF = false;
    private boolean used = false;
    private int lineNum = 0;

    public boolean close() {
        this.input.close();
        this.inpHandler.closeInput();
        return true;
    }

    public boolean endInput() {
        this.forceEOF = true;
        return true;
    }

    public Tokenizer nextTokenizer() {
        if (this.forceEOF) {
            return null;
        }
        InputLine line = this.input.readLine();
        this.lineNum = this.input.getLineNumber();
        if (line == null) {
            if (this.used) {
                return null;
            }
            line = this.inpHandler.emptyLine();
            this.lineNum = 1;
        }
        this.used = true;
        line = this.inpHandler.confirmLine(line);
        return this.inpHandler.makeTokenizer(line, "l." + this.lineNum + " ", true);
    }

    public boolean enoughContext() {
        return true;
    }

    public FilePos filePos() {
        return new FilePos(this.name, this.lineNum);
    }

    public LineInputTokenizer(LineInput input, InputHandler inpHandler, FileName name) {
        this.input = input;
        this.inpHandler = inpHandler;
        this.name = name;
    }

    public static interface InputHandler {
        public void closeInput();

        public InputLine emptyLine();

        public InputLine confirmLine(InputLine var1);

        public Tokenizer makeTokenizer(InputLine var1, String var2, boolean var3);
    }
}

