/***************************************************************************\
*                                                                           *
*   WINCON.H                                                                *
*                                                                           *
*   Some headers are used from the cygnus project                           *
*   Modified by:                                                            *
*    kiefer@isys.de                                                         *
*    rainer@mathematik.uni-bielefeld.de                                     *
*									    *
\***************************************************************************/

#if !defined (_WINCON_H)
#define _WINCON_H

#ifdef __cplusplus
extern "C" {
#endif

typedef struct {
  SHORT X;
  SHORT Y;
} COORD;

typedef struct {
  SHORT Left;
  SHORT Top;
  SHORT Right;
  SHORT Bottom;
} SMALL_RECT;

typedef struct
  {
    int bKeyDown;
    WORD wRepeatCount;
    WORD wVirtualKeyCode;
    WORD wVirtualScanCode;
    union
      {
	WCHAR UnicodeChar;
	CHAR AsciiChar;
      } uChar;
    DWORD dwControlKeyState;
  } KEY_EVENT_RECORD  __attribute__ ((packed));
typedef KEY_EVENT_RECORD *PKEY_EVENT_RECORD;

#define RIGHT_ALT_PRESSED 0x1
#define LEFT_ALT_PRESSED 0x2
#define RIGHT_CTRL_PRESSED 0x4
#define LEFT_CTRL_PRESSED 0x8
#define SHIFT_PRESSED 0x10
#define NUMLOCK_ON 0x20
#define SCROLLLOCK_ON 0x40
#define CAPSLOCK_ON 0x80
#define ENHANCED_KEY 0x100

typedef struct {
    COORD dwMousePosition;
    DWORD dwButtonState;
    DWORD dwControlKeyState;
    DWORD dwEventFlags;
  } MOUSE_EVENT_RECORD, *PMOUSE_EVENT_RECORD;

#define CONSOLE_TEXTMODE_BUFFER 1

#define FROM_LEFT_1ST_BUTTON_PRESSED 0x0001
#define RIGHTMOST_BUTTON_PRESSED 0x0002
#define FROM_LEFT_2ND_BUTTON_PRESSED 0x0004
#define FROM_LEFT_3RD_BUTTON_PRESSED 0x0008
#define FROM_LEFT_4TH_BUTTON_PRESSED 0x0010

#define MOUSE_MOVED 0x0001
#define DOUBLE_CLICK 0x0002

typedef struct {
    COORD dwSize;
  } WINDOW_BUFFER_SIZE_RECORD, *PWINDOW_BUFFER_SIZE_RECORD;

typedef struct {
    UINT dwCommandId;
  } MENU_EVENT_RECORD, *PMENU_EVENT_RECORD;

typedef struct {
    BOOL bSetFocus;
} FOCUS_EVENT_RECORD, *PFOCUS_EVENT_RECORD;

typedef struct {
    WORD EventType;
    union {
	KEY_EVENT_RECORD KeyEvent;
	MOUSE_EVENT_RECORD MouseEvent;
	WINDOW_BUFFER_SIZE_RECORD WindowBufferSizeEvent;
	MENU_EVENT_RECORD MenuEvent;
	FOCUS_EVENT_RECORD FocusEvent;
      } Event;
  } INPUT_RECORD, *PINPUT_RECORD;

#define KEY_EVENT 0x1
#define MOUSE_EVENT 0x2
#define WINDOW_BUFFER_SIZE_EVENT 0x4
#define MENU_EVENT 0x8
#define FOCUS_EVENT 0x10

typedef struct {
    union {
	WCHAR UnicodeChar;
	CHAR AsciiChar;
      } Char;
    WORD Attributes;
  } CHAR_INFO;


#define FOREGROUND_BLUE 0x01
#define FOREGROUND_GREEN 0x02
#define FOREGROUND_RED 0x04
#define FOREGROUND_INTENSITY 0x08
#define BACKGROUND_BLUE 0x10
#define BACKGROUND_GREEN 0x20
#define BACKGROUND_RED 0x40
#define BACKGROUND_INTENSITY 0x80

typedef struct {
    COORD dwSize;
    COORD dwCursorPosition;
    WORD wAttributes;
    SMALL_RECT srWindow;
    COORD dwMaximumWindowSize;
  }
CONSOLE_SCREEN_BUFFER_INFO, *PCONSOLE_SCREEN_BUFFER_INFO;

typedef struct {
    DWORD dwSize;
    BOOL bVisible;
  }
CONSOLE_CURSOR_INFO, *PCONSOLE_CURSOR_INFO;

#define CTRL_C_EVENT 0
#define CTRL_BREAK_EVENT 1
#define CTRL_CLOSE_EVENT 2
#define CTRL_LOGOFF_EVENT 5
#define CTRL_SHUTDOWN_EVENT 6

#define ENABLE_PROCESSED_INPUT 0x01
#define ENABLE_LINE_INPUT 0x02
#define ENABLE_ECHO_INPUT 0x04
#define ENABLE_WINDOW_INPUT 0x08
#define ENABLE_MOUSE_INPUT 0x10

#define ENABLE_PROCESSED_OUTPUT 0x01
#define ENABLE_WRAP_AT_EOL_OUTPUT 0x02


typedef BOOL WINAPI (*PHANDLER_ROUTINE)(DWORD);
BOOL WINAPI SetConsoleCtrlHandler(PHANDLER_ROUTINE,BOOL);

BOOL WINAPI AllocConsole (VOID);
HANDLE WINAPI CreateConsoleScreenBuffer (DWORD access, DWORD mode,
					 CONST SECURITY_ATTRIBUTES * lattr,
					 DWORD flags, VOID * ptr);
BOOL WINAPI FillConsoleOutputAttribute (HANDLE h, WORD attr, DWORD len,
					COORD co, DWORD * done);
#define FillConsoleOutputCharacter TFUNCT(FillConsoleOutputCharacter)
BOOL WINAPI FillConsoleOutputCharacter(HANDLE h, TCHAR c, DWORD len,
					 COORD co, DWORD * done);
BOOL WINAPI FlushConsoleInputBuffer (HANDLE h);
BOOL WINAPI FreeConsole (VOID);
BOOL WINAPI GenerateConsoleCtrlEvent(DWORD  ev,    DWORD group);
UINT WINAPI GetConsoleCP(VOID);
BOOL WINAPI GetConsoleCursorInfo(HANDLE h, CONSOLE_CURSOR_INFO *info);
BOOL WINAPI GetConsoleMode(HANDLE h, DWORD * mode);
UINT WINAPI GetConsoleOutputCP(VOID);
BOOL WINAPI GetConsoleScreenBufferInfo(HANDLE h, CONSOLE_SCREEN_BUFFER_INFO *ptr);
#define GetConsoleTitle TFUNCT(GetConsoleTitle)
DWORD WINAPI GetConsoleTitle(LPTSTR lpStr, DWORD len);
COORD WINAPI GetLargestConsoleWindowSize (HANDLE h);
BOOL WINAPI GetNumberOfConsoleInputEvents (HANDLE h, DWORD * n);
BOOL WINAPI GetNumberOfConsoleMouseButtons (DWORD * n);
#define PeekConsoleInput TFUNCT(PeekConsoleInput)
BOOL WINAPI PeekConsoleInput(HANDLE h, INPUT_RECORD * ptr,
			       DWORD len, DWORD * done);
#define ReadConsole TFUNCT(ReadConsole)
BOOL WINAPI ReadConsole(HANDLE h, VOID * ptr, DWORD len,
			  DWORD * done, VOID * res);
#define ReadConsoleInput TFUNCT(ReadConsoleInput)
BOOL WINAPI ReadConsoleInput(HANDLE h, INPUT_RECORD * ptr,
			       DWORD len, DWORD * done);
#define ReadConsoleOutput TFUNCT(ReadConsoleOutput)
BOOL WINAPI ReadConsoleOutput(HANDLE h, CHAR_INFO * ptr,
				COORD size, COORD fred, SMALL_RECT * reg);
BOOL WINAPI ReadConsoleOutputAttribute(HANDLE h, WORD * attr,
					DWORD len, COORD rc, DWORD * done);
#define ReadConsoleOutputCharacter TFUNCT(ReadConsoleOutputCharacter)
BOOL WINAPI ReadConsoleOutputCharacter(HANDLE h, LPTSTR c,
					 DWORD len, COORD rc, DWORD * done);
#define ScrollConsoleScreenBuffer TFUNCT(ScrollConsoleScreenBuffer)
BOOL WINAPI ScrollConsoleScreenBuffer(HANDLE h, CONST SMALL_RECT * sr,
					CONST SMALL_RECT * cr,
					COORD cpos, CONST CHAR_INFO * i);
BOOL WINAPI SetConsoleActiveScreenBuffer (HANDLE h);
BOOL WINAPI SetConsoleCP (UINT i);
BOOL WINAPI SetConsoleCursorInfo (HANDLE h,  CONST CONSOLE_CURSOR_INFO * info);
BOOL WINAPI SetConsoleCursorPosition (HANDLE h, COORD pos);
BOOL WINAPI SetConsoleMode (HANDLE h, DWORD mode);
BOOL WINAPI SetConsoleOutputCP (UINT i);
BOOL WINAPI SetConsoleScreenBufferSize (HANDLE h, COORD size);
BOOL WINAPI SetConsoleTextAttribute (HANDLE h,
				     WORD attrs);
#define SetConsoleTitle TFUNCT(SetConsoleTitle)
BOOL WINAPI SetConsoleTitle(LPCTSTR str);
BOOL WINAPI SetConsoleWindowInfo (HANDLE h, BOOL abs, CONST SMALL_RECT * wnd);
#define WriteConsole TFUNCT(WriteConsole)
BOOL WINAPI WriteConsole(HANDLE h, CONST VOID *   ptr,
			   DWORD slen, DWORD * done, VOID * res);
#define WriteConsoleInput TFUNCT(WriteConsoleInput)
BOOL WINAPI WriteConsoleInput(HANDLE h, CONST INPUT_RECORD * ptr,
				DWORD len, DWORD * done);
#define WriteConsoleOutput TFUNCT(WriteConsoleOutput)
BOOL WINAPI WriteConsoleOutput(HANDLE  h, CONST CHAR_INFO * ptr,
				 COORD size, COORD fred, SMALL_RECT* where);
BOOL WINAPI WriteConsoleOutputAttribute (HANDLE h, CONST WORD *attr,
					 DWORD len, COORD co, DWORD * done);
#define WriteConsoleOutputCharacter TFUNCT(WriteConsoleOutputCharacter)
BOOL WINAPI WriteConsoleOutputCharacter(HANDLE h, LPTSTR c,
					  DWORD len, COORD co, DWORD * done);

#ifdef __cplusplus
}
#endif

#endif /* !defined (_WINCON_H) */
