/*****

      $Source: d:\gunther\source\grc/RCS/resnt.h,v $
      $Author: gunther $
      $Date: 1996/01/02 23:17:24 $
      $Revision: 1.5 $

	Changed by: Fred Kiefer (kiefer@isys.de) 1996/6/2

 *****/

#ifndef _RESNT_H
#define _RESNT_H

#ifdef __cplusplus
extern "C" {
#endif

#define RC_INVOKED
#include <windows.h>

typedef long LONG;
typedef unsigned long DWORD;
typedef unsigned short WORD;
#define MAKELANGID(p, s)       ((((WORD)(s)) << 10) | (WORD)(p))

#define RT_TOOLBAR 0xF1

/* common controls */
#define     CTL_BUTTON     0x80
#define     CTL_EDIT       0x81
#define     CTL_STATIC     0x82
#define     CTL_LISTBOX    0x83
#define     CTL_SCROLLBAR  0x84
#define     CTL_COMBOBOX   0x85

/* valid memory flags */
/* I think that MOVEABLE and PURE should be exchanged, but I am not
	sure about it, so I leave it the old way */
#define MOVEABLE	0x0010
#define PURE		0x0020
#define PRELOAD		0x0040
#define DISCARDABLE	0x1000

/* memory flags */
#define MEMFLAG_MOVEABLE	0x0010
#define MEMFLAG_FIXED		0
#define MEMFLAG_PURE		0x0020
#define MEMFLAG_IMPURE		0
#define MEMFLAG_PRELOAD		0x0040
#define MEMFLAG_LOADONCALL	0
#define MEMFLAG_DISCARDABLE	0x1000

#define INVAL_WCHAR ((wchar_t)0xffff)	    /* invalid uni char */

/* This only works for size being of the form 2**n */
#define ROUNDUP(x, size) (((x)+(size-1))&~(size-1))
#define PADDING(x, size) ((size-1) - (((x)+(size-1)) & (size-1)))

#pragma pack(1)

/* windows res structures */

typedef struct {
    unsigned long  DataSize;
    unsigned long  HeaderSize;
    unsigned short FirstWord[1];
} ResourceHead;

typedef struct {
    unsigned long  DataVersion;
    unsigned short MemoryFlags;
    unsigned short LanguageId;
    unsigned long  Version;
    unsigned long  Characteristics;
} ResourceTail;

#define TAIL_SIZE   sizeof(ResourceTail)

typedef struct {
    unsigned long style;
    unsigned long dwExtendedStyle;
    unsigned short cdit;
    unsigned short x;
    unsigned short y;
    unsigned short cx;
    unsigned short cy;
} DLGTEMPLATE;

#define DLGTEMPLATE_SIZE sizeof(DLGTEMPLATE)

typedef struct {  
    unsigned long style;
    unsigned long dwExtendedStyle;
    short x;
    short y;
    short cx;
    short cy;
    unsigned short id;
} DLGITEMTEMPLATE;

#define DLGITEM_SIZE sizeof(DLGITEMTEMPLATE)


typedef struct {
    unsigned short PointSize;
    unsigned short TypefaceName[50];
} DLGFONT;

typedef struct {
     unsigned short fFlags;
     unsigned short wAscii;
     unsigned short wId;
     unsigned short padding;
} ACCELTABLEENTRY;

#define ACC_VIRTKEY		0x01
#define ACC_NOINVERT	0x02
#define ACC_SHIFT		0x04
#define ACC_CONTROL		0x08
#define ACC_ALT			0x10
#define ACC_LAST		0x80

typedef struct { 
    unsigned short bfType;
    unsigned long  bfSize;
    unsigned short bfReserved1;
    unsigned short bfReserved2;
    unsigned long bfOffBits;
} BMP_FILEHEADER; 

#define BMP_FILEHEADER_SIZE sizeof(BMP_FILEHEADER)

/* icon file header structures */
typedef struct {
    unsigned char bWidth;
    unsigned char bHeight;
    unsigned char bColorCount;
    unsigned char bReserved;
    unsigned short wPlanes;
    unsigned short wBitCount;
    unsigned long dwBytesInRes;
    unsigned long dwImageOffset;
} ICONDIRENTRY;

#define ICONDIRENTRY_SIZE  sizeof(ICONDIRENTRY)

/* icon resource structures */
typedef struct {
     unsigned short wReserved;
     unsigned short wType;
     unsigned short wCount;
}  IconHeader;

#define ICONHEADER_SIZE sizeof(IconHeader)

typedef struct{
     unsigned char bWidth;
     unsigned char bHeight;
     unsigned char bColorCount;
     unsigned char bReserved;
     unsigned short wPlanes;
     unsigned short wBitCount;
     unsigned long lBytesInRes;
     unsigned short wNameOrdinal;
} IconResourceDirectory;

#define IconResourceDirectory_SIZE sizeof(IconResourceDirectory) 


typedef struct {
     unsigned short wWidth;
     unsigned short wHeight;
     unsigned short wPlanes;
     unsigned short wBitCount;
     unsigned long  lBytesInRes;
     unsigned short wNameOrdinal;
} CursorResourceDirectory;

#define CursorResourceDirectory_SIZE sizeof(CursorResourceDirectory)

typedef struct {
    short xHotspot;
    short yHotspot;
} CursorComponent;

#define CursorComponent_SIZE sizeof(CursorComponent)

typedef struct {
    unsigned char bWidth;
    unsigned char bHeight;
    unsigned char bColorCount;
    unsigned char bReserved;
    unsigned short wXHotspot;
    unsigned short wYHotspot;
    unsigned long lBytesInRes;
    unsigned long dwImageOffset;
} CURSORDIRENTRY;

#define CURSORDIRENTRY_SIZE sizeof(CURSORDIRENTRY)


typedef struct {
     unsigned short wVersion;
     unsigned short cbHeaderSize;
} MenuHeader;

#define MenuHeader_SIZE sizeof(MenuHeader)
  
typedef struct {
     unsigned short fItemFlags;
     unsigned short szItemText[1];
} PopupMenuItem;
  
typedef struct {
     unsigned short fItemFlags;
     unsigned short wMenuID;
     unsigned short szItemText[1];
} NormalMenuItem;

#define     MENUFLAG_GRAYED         0x0001
#define     MENUFLAG_INACTIVE       0x0002
#define     MENUFLAG_BITMAP         0x0004
#define     MENUFLAG_OWNERDRAW      0x0100
#define     MENUFLAG_CHECKED        0x0008
#define     MENUFLAG_POPUP          0x0010
#define     MENUFLAG_MENUBARBREAK   0x0020
#define     MENUFLAG_MENUBREAK      0x0040
#define     MENUFLAG_ENDMENU        0x0080
#define     MENUFLAG_SEPARATOR      0x1000

typedef struct {
	DWORD   dwSignature;
	DWORD   dwStrucVersion;
	DWORD   dwFileVersionMS;
	DWORD   dwFileVersionLS;
	DWORD   dwProductVersionMS;
	DWORD   dwProductVersionLS; 
	DWORD   dwFileFlagsMask;
	DWORD   dwFileFlags;
	DWORD   dwFileOS;
	DWORD   dwFileType;
	DWORD   dwFileSubtype;
	DWORD   dwFileDateMS;
	DWORD   dwFileDateLS;
} VS_FIXEDFILEINFO;


#pragma pack()


#ifdef __cplusplus
}
#endif

#endif

