/* -*-C++-*-
 * ###################################################################
 *  Cpptcl - connecting C++ with Tcl
 * 
 *  FILE: "member_file_io.cc"
 *                                    created: 29/10/97 {9:25:28 am} 
 *                                last update: 17/12/97 {12:37:38 am} 
 *  Author: Vince Darley
 *  E-mail: <darley@fas.harvard.edu>
 *    mail: Division of Engineering and Applied Sciences, Harvard University
 *          Oxford Street, Cambridge MA 02138, USA
 *     www: <http://www.fas.harvard.edu/~darley/>
 *  
 * ========================================================================
 *               Copyright (c) 1997 Vince Darley
 * ========================================================================
 *  See header file for further information
 * ###################################################################
 */

#include "member_file_io.h"
#include <fstream.h>

Cpptcl_IBaseClass(member_file,"memberfile",cpp_config_mem);
Cpptcl_IBaseClass(member_file_i,"imemberfile",member_file);
Cpptcl_IBaseClass(member_file_o,"omemberfile",member_file);
Cpptcl_IBaseClass(member_file_io,"iomemberfile",member_file);

void member_file::tcl_set(tcl_object* o, tcl_args_reader& istr) const {
	if(read_only()) {
		istr.setstate(tcl_args_reader::Fail);
	} else {
		// get name of file from args
		Tcl_Obj* obj = istr;
		if(!obj) {
			istr.setstate(tcl_args_reader::Fail);
			return;
		}
		int len;
		const char* ch = Tcl_GetStringFromObj(obj,&len);
		// set the stream appropriately
		if(len) {
		    if (!open(o,ch)) {
			    istr.setstate(tcl_args_reader::Fail);
		    }			
		} else {
		    close(o);
		}
	}	
}

bool member_file_io::open(tcl_object* o, const char* n) const {
	if(strm.fs(o).is_open())
		strm.fs(o).close();
	strm.fs(o).clear();
	strm.fs(o).open(n,ios::in | ios::out);
    return (strm.fs(o).good() ? true : false);
}

bool member_file_i::open(tcl_object* o, const char* n) const {
	if(strm.ifs(o).is_open())
		strm.ifs(o).close();
	strm.ifs(o).clear();
	strm.ifs(o).open(n,ios::in);
    return (strm.ifs(o).good() ? true : false);
}

bool member_file_o::open(tcl_object* o, const char* n) const {
	if(strm.ofs(o).is_open())
		strm.ofs(o).close();
	strm.ofs(o).clear();
	// ios::append should be selectable somehow
	strm.ofs(o).open(n,ios::out | ios::trunc);
    return (strm.ofs(o).good() ? true : false);
}
