# call of the index preparing program connected to file $main_file   
#
# Copyright (C) 1994  G. Lamprecht, W. Lotz, R. Weibezahn; LRW c/o Uni Bremen
# Copyright (C) 1996  G. Lamprecht, W. Lotz, R. Weibezahn; IWD, Bremen University

proc index {f austext} {

  upvar 1 $austext a

  global  vv index inoptions main_file isuffe isuffa dirprefix indcmd indcmdmax

  set a ""
  # don't clear screen by call of writescr0 (index may be called automatically after TeX run!)

  if {$dirprefix==""} {set mainfile $main_file} else {set mainfile [fileName $main_file]} 

  if {$mainfile==""} {set a "${a}***** $vv(ea1)\n"; mybell 2; return}

  writescr $f "[datime] $vv(in1) \"$mainfile\"\n"


  if { [file exists $mainfile$isuffe] } {	# --> index preparing (makeindex)

    set stdinout [regexp {<[ ]*\$mainfile.idx[ ]*>[ ]*\$mainfile.ind} "$inoptions"]
    #set opteval "[eval set $inoptions]"; #does not work with "<$mainfile""
    regsub -all {\$mainfile} "$inoptions" $mainfile opteval
    TestPut 4 "<$stdinout> <:$inoptions:> <$index $opteval \[$mainfile\]>"
    unlink -nocomplain $mainfile.ilg

    if {$stdinout==1} {# call via exec (<stdin >stdout!): file specification in $inoptions
      writescr $f "$index $opteval\n"; update
      SigChldB; set res [catch "exec $index  $opteval" message]; SigChldU
      set a "${a}$message"
    } else {
      writescr $f "$index $opteval $mainfile$isuffe\n"; update
      eval mkCmd_wait $f $index [list "$opteval $mainfile$isuffe"]
    }

 } else {	# input file for indexpreparing not found!

   set a "${a}\n***** $vv(aus5)  $mainfile$isuffe  $vv(ea4)\n      $vv(in2)\n"
   set a "${a}	\\documentclass\{...\}\\usepackage\{makeidx\}   % (LaTeX2e)\n"
   set a "${a}	%\\documentstyle\[...,makeidx,...\]\{...\}   % (LaTeX2.09)\n"
   set a "${a}	  ...\n"
   set a "${a}	  \\makeindex\n"
   set a "${a}	\\begin\{document\}\n"
   set a "${a}	  ... \\index\{...\} ...\n"
   set a "${a}	  \\printindex\n"
   set a "${a}	\\end\{document\}\n"
   mybell 2

  }

}
