unit formulas;

interface
uses common,strings;


Procedure Equation(var cq:TconvertedPass1;end_of_code: Longint);

implementation
uses pass1,charactr;{}

type FmlTranslationArray=record
    szWP:  string[11];		{ original WordPerfect term }
    szTeX: pchar;		{ translated LATEX term     }
    end;

{ special meaning of digits in the LATEX term:
** 0: previous argument,
** 1: next argument,
** 2: next next argument,
** 5: same word as WordPerfect, with "\" before, lower case,
** 6: same word as WordPerfect, with "\" before,right case
** 7: count Ampersands and write count times the following char
** 8: adding \displaystyle if in first level
**
** lower case chars in the WP-term match only lower case chars in
** the WordPerfect formula,
** upper case chars match both cases
**
** note: the order of words is sometimes essential !
** first the more specialized and longer words
** then the more common and shorter words.
}

const FmlTransTableSize=251;
  FmlTransTable: array[0..FmlTransTableSize] of FmlTranslationArray=
(
{ 11 char words }
  (szWP:'SMALLCOPROD';szTeX:'\coprod'), { bad translation }
{ 10 char words }
  (szWP:'STACKALIGN';szTeX:'\begin{array}{r@{}l}81\end{array}'),
  (szWP:'varepsilon';szTeX:'5'),
{ 9 char words }
  (szWP:'BIGOMINUS';szTeX:'\ominus'), { bad translation }
  (szWP:'BIGOTIMES';szTeX:'5'),
  (szWP:'IDENTICAL';szTeX:'?'), { no translation known }
  (szWP:'LINESPACE';szTeX:'\vspace{1}'), { very bad translation }
  (szWP:'MINUSPLUS';szTeX:'\mp'),
  (szWP:'PLUSMINUS';szTeX:'\pm'),
  (szWP:'SMALLOINT';szTeX:'\oint'), { bad translation }
  (szWP:'SMALLPROD';szTeX:'\prod'), { bad translation }
  (szWP:'THEREFORE';szTeX:'?'), { no translation known }
  (szWP:'UNDERLINE';szTeX:'5{1}'),
{ 8 char words }
  (szWP:'ANGSTROM';szTeX:'\AA'),
  (szWP:'BIGOPLUS';szTeX:'5'),
  (szWP:'BIGSQCAP';szTeX:'\sqcap'), { bad translation }
  (szWP:'BIGSQCUP';szTeX:'5'),
  (szWP:'BIGUPLUS';szTeX:'5'),
  (szWP:'BIGWEDGE';szTeX:'5'),
  (szWP:'DOTSAXIS';szTeX:'\cdots'),
  (szWP:'DOTSDIAG';szTeX:'\ddots'),
  (szWP:'DOTSVERT';szTeX:'\vdots'),
  (szWP:'EMPTYSET';szTeX:'5'),
  (szWP:'INFINITY';szTeX:'\infty'),
  (szWP:'LONGDIVS';szTeX:'\div'), { very bad translation }
  (szWP:'OVERLINE';szTeX:'5{1}'),
  (szWP:'PARALLEL';szTeX:'5'),
  (szWP:'SETMINUS';szTeX:'\\'),
  (szWP:'SMALLINT';szTeX:'\int'), { bad translation }
  (szWP:'SMALLSUM';szTeX:'\sum'), { bad translation }
  (szWP:'SQSUBSET';szTeX:'5'),
  (szWP:'SQSUPSET';szTeX:'5'),
  (szWP:'varsigma';szTeX:'5'),
  (szWP:'vartheta';szTeX:'5'),
{ 7 char words }
  (szWP:'BECAUSE';szTeX:'?'), { no translation known }
  (szWP:'BETWEEN';szTeX:'?'), { no translation known }
  (szWP:'BIGODIV';szTeX:'\div'), { very bad translation }
  (szWP:'BIGODOT';szTeX:'5'),
  (szWP:'BINOMSM';szTeX:'{\small {1 \choose 2}}'),
  (szWP:'DOTSLOW';szTeX:'\ldots'),
  (szWP:'epsilon';szTeX:'5'),
  (szWP:'EPSILON';szTeX:'\epsilon'),
  (szWP:'LDBRACK';szTeX:'['),	{ very bad translation }
  (szWP:'LONGDIV';szTeX:'\div'), { very bad translation }
  (szWP:'omikron';szTeX:'o'),	{ very bad translation }
  (szWP:'OMIKRON';szTeX:'O'),	{ very bad translation }
  (szWP:'MASSERT';szTeX:'\dashv'),
  (szWP:'MATFORM';szTeX:''),	{ no translation kwown }
  (szWP:'MSANGLE';szTeX:'\angle'), { bad translation }
  (szWP:'NASYMEQ';szTeX:'\not\asymp'),
  (szWP:'PARTIAL';szTeX:'5'),
  (szWP:'PHANTOM';szTeX:''),	{ no translation known }
  (szWP:'RDBRACK';szTeX:']'),	{ very bad translation }
  (szWP:'RTANGLE';szTeX:'?'),	{ no translation known }
  (szWP:'upsilon';szTeX:'\upsilon'),
  (szWP:'UPSILON';szTeX:'\Upsilon'),
{ 6 char words }
  (szWP:'ALIGNC';szTeX:''),    { no translation known }
  (szWP:'ALIGNL';szTeX:''),    { no translation kwown }
  (szWP:'ALINGR';szTeX:''),    { no translation known }
  (szWP:'APPROX';szTeX:'5'),
  (szWP:'arccos';szTeX:'5'),
  (szWP:'arcsin';szTeX:'5'),
  (szWP:'arctan';szTeX:'5'),
  (szWP:'ASSERT';szTeX:'\vdash'),
  (szWP:'ASYMEQ';szTeX:'\asymp'),
  (szWP:'BIGCAP';szTeX:'5'),
  (szWP:'BIGCUP';szTeX:'5'),
  (szWP:'BIGVEE';szTeX:'5'),
  (szWP:'CIRCLE';szTeX:'\dot{0}'), { no translation known }
  (szWP:'COPROD';szTeX:'5'),
  (szWP:'EXISTS';szTeX:'5'),
  (szWP:'FORALL';szTeX:'5'),
  (szWP:'lambda';szTeX:'5'),
  (szWP:'LAMBDA';szTeX:'\Lambda'),
  (szWP:'LANGLE';szTeX:'5'),
  (szWP:'LBRACE';szTeX:'\{'),
  (szWP:'LFLOOR';szTeX:'5'),
  (szWP:'liminf';szTeX:'5'),
  (szWP:'limsup';szTeX:'5'),
  (szWP:'MATRIX';szTeX:'\begin{array}{7}1\end{array}'),
  (szWP:'MODELS';szTeX:'5'),
  (szWP:'NEQUIV';szTeX:'\not\equiv'),
  (szWP:'OMINUS';szTeX:'5'),
  (szWP:'OTIMES';szTeX:'5'),
  (szWP:'OVERSM';szTeX:'{\small \frac{0}{1}}'),
  (szWP:'PRECEQ';szTeX:'5'),
  (szWP:'PROPTO';szTeX:'5'),
  (szWP:'QEQUAL';szTeX:'?'),	{ no translation known }
  (szWP:'RANGLE';szTeX:'5'),
  (szWP:'RBRACE';szTeX:'\}'),
  (szWP:'RFLOOR';szTeX:'5'),
  (szWP:'RIMAGE';szTeX:'?'),	{ no translation known }
  (szWP:'SANGLE';szTeX:'\angle'), { bad translation }
  (szWP:'SUBSET';szTeX:'5'),
  (szWP:'SUCCEQ';szTeX:'5'),
  (szWP:'SUPSET';szTeX:'5'),
  (szWP:'varphi';szTeX:'5'),
  (szWP:'varrho';szTeX:'5'),
  (szWP:'WREATH';szTeX:'\wr'),
{ 5 char words }
  (szWP:'ACUTE';szTeX:'5{0}'),
  (szWP:'alpha';szTeX:'5'),
  (szWP:'ALPHA';szTeX:'A'),
  (szWP:'ANGLE';szTeX:'5'),
  (szWP:'BINOM';szTeX:'{1 \choose 2}'),
  (szWP:'BREVE';szTeX:'5{0}'),
  (szWP:'cosec';szTeX:'\csc'),
  (szWP:'DDDOT';szTeX:'\ddot{0}'), { no tranlation known }
  (szWP:'delta';szTeX:'5'),
  (szWP:'DELTA';szTeX:'\Delta'),
  (szWP:'DLINE';szTeX:'\|'),
  (szWP:'DOTEQ';szTeX:'5'),
  (szWP:'EQUIV';szTeX:'5'),
  (szWP:'FROWN';szTeX:'5'),
  (szWP:'gamma';szTeX:'5'),
  (szWP:'GAMMA';szTeX:'\Gamma'),
  (szWP:'GRAVE';szTeX:'5{0}'),
  (szWP:'IMAGE';szTeX:'?'), { no translation known }
  (szWP:'kappa';szTeX:'5'),
  (szWP:'KAPPA';szTeX:'\Kappa'),
  (szWP:'LCEIL';szTeX:'5'),
  (szWP:'NOTIN';szTeX:'5'),
  (szWP:'NROOT';szTeX:' \sqrt[1]{2}'),
  (szWP:'omega';szTeX:'\omega'),
  (szWP:'OMEGA';szTeX:'\Omega'),
  (szWP:'OPLUS';szTeX:'5'),
  (szWP:'RCEIL';szTeX:'5'),
  (szWP:'RIGHT';szTeX:'5'),
  (szWP:'sigma';szTeX:'5'),
  (szWP:'SIGMA';szTeX:'\Sigma'),
  (szWP:'SIMEQ';szTeX:'5'),
  (szWP:'SMILE';szTeX:'5'),
  (szWP:'SQCAP';szTeX:'5'),
  (szWP:'SQCUP';szTeX:'5'),
  (szWP:'STACK';szTeX:'\begin{array}{c}1\end{array}'),
  (szWP:'theta';szTeX:'5'),
  (szWP:'THETA';szTeX:'\Theta'),
  (szWP:'TILDE';szTeX:'5{0}'),
  (szWP:'TIMES';szTeX:'5'),
  (szWP:'UPLUS';szTeX:'5'),
  (szWP:'varpi';szTeX:'5'),
  (szWP:'VARPI';szTeX:'6'),
{ Words with 4 chars }
  (szWP:'beta';szTeX:'5'),
  (szWP:'BETA';szTeX:'B'),
  (szWP:'BOLD';szTeX:'{\bf 1}'),
  (szWP:'CDOT';szTeX:'5'),
  (szWP:'CONG';szTeX:'5'),
  (szWP:'cosh';szTeX:'5'),
  (szWP:'coth';szTeX:'5'),
  (szWP:'DDOT';szTeX:'5{0}'),
  (szWP:'DSUM';szTeX:'?'), { no translation known }
  (szWP:'DYAD';szTeX:'\bar{0}'), { no translation known }
  (szWP:'FROM';szTeX:'_{1}'),
  (szWP:'FUNC';szTeX:'{\rm 1}'),
  (szWP:'GRAD';szTeX:'\nabla'),
  (szWP:'HORZ';szTeX:'\hspace{1}'), { very bad translation }
  (szWP:'IMAG';szTeX:'\Im'),
  (szWP:'iota';szTeX:'5'),
  (szWP:'IOTA';szTeX:'I'),
  (szWP:'ITAL';szTeX:'{\it 1}'),
  (szWP:'LEFT';szTeX:'5'),
  (szWP:'LINE';szTeX:'|'),
  (szWP:'NISO';szTeX:'?'), { no translation known }
  (szWP:'ODIV';szTeX:'\div'), { very bad translation }
  (szWP:'ODOT';szTeX:'5'),
  (szWP:'OINT';szTeX:'5'),
  (szWP:'OVER';szTeX:' \frac{0}{1}'),
  (szWP:'OWNS';szTeX:'\ni'),
  (szWP:'PERP';szTeX:'5'),
  (szWP:'PREC';szTeX:'5'),
  (szWP:'PROD';szTeX:'5'),
  (szWP:'REAL';szTeX:'\Re'),
  (szWP:'sinh';szTeX:'5'),
  (szWP:'SQRT';szTeX:'5{1}'),
  (szWP:'SUCC';szTeX:'5'),
  (szWP:'tanh';szTeX:'5'),
  (szWP:'VERT';szTeX:'\vspace{1}'), { very bad translation }
  (szWP:'zeta';szTeX:'5'),
  (szWP:'ZETA';szTeX:'Z'),
{ Words with 3 chars }
(*  (szWP:''''';szTeX:'{0'''}'), !!! *)
  (szWP:'AND';szTeX:'\wedge'),
  (szWP:'arc';szTeX:'{\rm arc}'),
  (szWP:'BAR';szTeX:'5{0}'),
  (szWP:'CAP';szTeX:'5'),
  (szWP:'chi';szTeX:'5'),
  (szWP:'CHI';szTeX:'X'),
  (szWP:'cos';szTeX:'5'),
  (szWP:'cot';szTeX:'5'),
  (szWP:'CUP';szTeX:'5'),
  (szWP:'DEG';szTeX:'\degree'),
  (szWP:'det';szTeX:'5'),
  (szWP:'DIV';szTeX:'5'),
  (szWP:'DOT';szTeX:'5{0}'),
  (szWP:'eta';szTeX:'5'),
  (szWP:'ETA';szTeX:'H'),
  (szWP:'exp';szTeX:'5'),
  (szWP:'gcd';szTeX:'5'),
  (szWP:'GGG';szTeX:'\gg'), { no tranlation known }
  (szWP:'HAT';szTeX:'5{0}'),
  (szWP:'INF';szTeX:'\infty'),
  (szWP:'INT';szTeX:'5'),
  (szWP:'ISO';szTeX:'?'), { no translation known }
  (szWP:'lim';szTeX:'5'),
  (szWP:'LLL';szTeX:'\ll'), { no translation known }
  (szWP:'log';szTeX:'{\rm log}'),
  (szWP:'max';szTeX:'5'),
  (szWP:'MHO';szTeX:'5'),
  (szWP:'min';szTeX:'5'),
  (szWP:'mod';szTeX:'{\rm mod}'),
  (szWP:'NOT';szTeX:'\neg'),
  (szWP:'phi';szTeX:'5'),
  (szWP:'PHI';szTeX:'\Phi'),
  (szWP:'psi';szTeX:'5'),
  (szWP:'PSI';szTeX:'\Psi'),
  (szWP:'rho';szTeX:'5'),
  (szWP:'RHO';szTeX:'P'),
  (szWP:'sec';szTeX:'5'),
  (szWP:'SIM';szTeX:'5'),
  (szWP:'sin';szTeX:'5'),
  (szWP:'SUB';szTeX:'_{1}'),
  (szWP:'SUM';szTeX:'5'),
  (szWP:'SUP';szTeX:'^{1}'),
  (szWP:'tan';szTeX:'5'),
  (szWP:'tau';szTeX:'5'),
  (szWP:'TAU';szTeX:'\Tau'),
  (szWP:'TOP';szTeX:'5'),
  (szWP:'VEC';szTeX:'5{0}'),
  (szWP:'XOR';szTeX:'?'), { no translation known }

{ words with 2 chars }
  (szWP:'!=';szTeX:'\neq'),
  (szWP:'==';szTeX:'\equiv'),
  (szWP:'+-';szTeX:'\pm'),
  (szWP:'-+';szTeX:'\mp'),
  (szWP:'<=';szTeX:'\le'),
  (szWP:'<<';szTeX:'\ll'),
  (szWP:'>=';szTeX:'\ge'),
  (szWP:'>>';szTeX:'\gg'),
  (szWP:'''';szTeX:'{0''}'),
  (szWP:'IN';szTeX:'5'),
  (szWP:'ln';szTeX:'5'),
  (szWP:'mu';szTeX:'\mu'),
  (szWP:'MU';szTeX:'\Mu'),
  (szWP:'nu';szTeX:'\nu'),
  (szWP:'NU';szTeX:'N'),
  (szWP:'OR';szTeX:'\vee'),
  (szWP:'pi';szTeX:'5'),
  (szWP:'PI';szTeX:'\Pi'),
  (szWP:'TO';szTeX:'^{1}'),
  (szWP:'xi';szTeX:'5'),
  (szWP:'XI';szTeX:'\Xi'),
{ 1 char words }
  (szWP:'^';szTeX:'^{1}'),
  (szWP:'_';szTeX:'_{1}'),
(*  (szWP:''';szTeX:'{0'}'), *)
  (szWP:'`';szTeX:'\,'),
  (szWP:'#';szTeX:' \\ '),
{  (szWP:'&';szTeX:'&8'),}
  (szWP:'\''';szTeX:'\dq')
);


Function RemoveSymbol(var str1,str2:string;const symbol:string;var xpos:integer):Boolean;
var i,i2:integer;
    t:string;

Label NewTest,NewTest2;
begin
 i:=pos(symbol,str2);

(* if i>1 then    {fix symbol, which begins by \anything}
     if (str2[i-1]='\') or (str2[i-1] in ['0'..'9','A'..'z']) then
        begin
        asm int 3; end;
        t:=copy(str2,i,length(str2)-i);
        i2:=pos(symbol,t);
        i:=i+i2;
        if i2<=0 then i:=0;     {here is a bug!!, the test should run more than twice}
        end;*)


 if i<=0 then
 	begin
        t:=UpCases(str2);
        i:=pos(symbol,t);

(*      if i>1 then    {fix symbol, which begins by \anything}
            if (str2[i-1]='\') or (str2[i-1] in ['0'..'9','A'..'z']) then
               begin
               t:=copy(t,i,length(str2)-i);
               i2:=pos(symbol,t);
               i:=i+i2;
               if i2<=0 then i:=0; {here is a bug!!, the test should run more than twice}
               end; *)

        if i<=0 then
        	begin
	        RemoveSymbol:=False;
	        exit;
        	end;

        end;

  if ((i>1) and (str2[i-1] in ['a'..'z','A'..'Z','\'])) then
  	begin
        RemoveSymbol:=False;
	exit;
        end;

  str1:=str1+copy(str2,1,i-1);
  str2:=copy(str2,i+length(symbol),length(str2)-i-length(symbol)+1);

  xpos:=i;
  RemoveSymbol:=True;
end;

Function Remove1stArg(var str,arg:string):Boolean;
var i:integer;
    c,LastC:char;
begin
 arg:='';

 while((str<>'') and (str[1]=' ')) do
         str:=copy(str,2,length(str)-1);

 i:=0;
 LastC:=#0;
 while((str<>'') and ((str[1]<>' ')or(i<>0))) do
 	begin
        c:=str[1];
        if (i<=0) then
        	begin
	        if not(c in ['0'..'9','a'..'z','A'..'Z','\','{']) then break;
                end;

        str:=copy(str,2,length(str)-1);

        if LastC<>'\' then
           begin
           if c='{' then
		   begin;
		   inc(i);
                   if i=1 then continue;
		   end;
           if c='}' then
		   begin;
		   dec(i);
                   if i=0 then break;
		   end;
           if ((c='\')and(i=0))and(arg<>'') then
                   begin
                   str:=c+str;
	   	   break;
                   end;
	   end;
        arg:=arg+c;
        LastC:=c;
        end;
end;

Function RemoveLastArg(var str,arg:string):Boolean;
var i:integer;
    c:char;
begin
 arg:='';

 while((str<>'') and (str[length(str)]=' ')) do
         str:=copy(str,1,length(str)-1);

 i:=0;
 while((str<>'') and ((str[length(str)]<>' ')or(i<>0))) do
 	begin
        c:=str[length(str)];
        if (i<=0) then
        	begin
                if not(c in ['0'..'9','a'..'z','A'..'Z','\','}']) then break;
                end;

        str:=copy(str,1,length(str)-1);

        if c='}' then
		begin;
		inc(i);
                if i=1 then continue;
		end;
        if c='{' then
		begin;
		dec(i);
                if i=0 then break;
		end;

        arg:=c+arg;
        end;
end;




Function Interpret(var strB,strE:string;const seq,symbol,arg0,arg1,arg2:string):String;
var i,j,a,a2:integer;
    p:integer;
begin
 if (strE[1]<>'_')and(strE[1]<>'^') then strE:=' '+strE;

 p:=0;
 for i:= 1 to length(seq) do
 	begin
        case seq[i] of
                '0':begin
                    if p=0 then p:=length(strB);
		    strB:=strB+arg0;
                    end;
                '1':begin
                    if p=0 then p:=length(strB);
		    strB:=strB+arg1;
                    end;
                '2':begin
                    if p=0 then p:=length(strB);
		    strB:=strB+arg2;
                    end;
        	'5':strB:=strB+'\'+lowcases(symbol);
                '6':strB:=strB+'\'+symbol;
                '7':begin
                    a:=0;
                    a2:=0;

                    for j:=1 to length(arg1) do
                    	begin
                        if arg1[j]='&' then inc(a2);
                        if arg1[j]='#' then
				begin
				if a2>a then a:=a2;
                                a2:=0;
                                end;
                        end;
                    if a2>a then a:=a2;

                    for j:=0 to a do strB:=strB+'c';
                    end;
        	else begin
                     strB:=strB+seq[i];
	             end;
             end;
        end;

if p<>0 then
	begin
        strE:=copy(strB,p+1,length(strB)-p)+strE;
        strB:=copy(strB,1,p);
        end;

end;


Procedure Equation(var cq:TconvertedPass1;end_of_code: Longint);
Var OldEnvir:char;
    j:integer;
    xpos,i:integer;
    StrBeg,StrEnd,arg0,arg1,arg2:string;

    chr_set,chr_code:byte;
    captionLen,EquLen:word;
    CaptionPos:Longint;
    OldFlag:Byte;
    AnchorType:Byte;
    StrangeMath:Boolean;
label EqEmpty;
Begin       	     { less length }
{   crackobject(cq,end_of_code);{}
   OldEnvir:=cq.Envir;
   StrangeMath:=False;

   Jump_in_file(cq.wpd^,2);
   Read(cq.wpd^,AnchorType);
   AnchorType:=AnchorType and $03;  {0-Paragraph, 1-Page, 2-Character}

   Jump_in_file(cq.wpd^,112);
   Rd_word(cq.wpd^,captionLen);	{total length of caption}
   CaptionPos:=Filepos(cq.wpd^);

   Jump_in_file(cq.wpd^,captionLen+10);
   Rd_word(cq.wpd^,EquLen);		{total length of equation}
   StrBeg:='';

   OldFlag:=cq.flag;
   cq.flag:=Nothing;
   inc(cq.recursion);
   end_of_code := end_of_code - 4;
   cq.actualpos:=filepos(cq.wpd^);

   if end_of_code>cq.actualpos+EquLen then
		end_of_code:=cq.actualpos+EquLen;
   While cq.actualpos < end_of_code  Do
	 Begin
         Read(cq.wpd^,cq.by);
         if chr(cq.by) in [#0..#5,'$'] then break;
         if cq.by=ord('') then cq.by:=ord('-');
         if chr(cq.by) in [#10,#13,' '..'z','{','}',')','(','~','&'] then
	      Begin
              if (cq.by=10)or(cq.by=13) then cq.by:=ord(' ');
              StrBeg:=StrBeg+chr(cq.by);

              inc(cq.actualpos);
              End
              else begin	{why special wp characters are in equations?}
                   if cq.by=$C0 then {extended character}
                   	begin
                        Read(cq.wpd^,chr_code);
                        Read(cq.wpd^,chr_set);
                        strend:=StrPas(ext_chr_str(chr_set,chr_code,cq));
                        Read(cq.wpd^,cq.by);
                        if strend[1]='$' then strend:=copy(strend,2,length(strend)-2)+' '
                        		 else strend:='{\rm '+strend+'}';
                        strbeg:=strbeg+strend;
                        strend:='';
                        end
                        else ProcessKey(cq);
                   end;
         End;

   while ((length(StrBeg)>0)and(StrBeg[1]=' ')) do
   	begin
        StrBeg:=Copy(StrBeg,2,length(StrBeg)-1)
        end;
   if ((length(StrBeg)>2) and (StrBeg[length(strbeg)-1]<>'\'))
         and(StrBeg[length(strbeg)]='&') then
         	StrBeg:=Copy(StrBeg,1,length(StrBeg)-1);


   if StrBeg='' then
   		goto EqEmpty;	{equation is empty-nothing to do}


   if AnchorType<>2 then
      begin
      writeln(cq.strip^);
      cq.line_term := 'h';     { Hard return }

      Make_tabelentry_envir_extra_end(cq);

      cq.Envir:='Q';
      cq.char_on_line:=False;
      cq.nomore_valid_tabs := False;
      cq.rownum:=cq.rownum+1;
      Make_tabelentry_attr(cq);
      cq.latex_tabpos:=0;
      end;


  strend:='';
  for i:=0 to FmlTransTableSize do
  	begin
        xpos:=0;

        strend:=strbeg+strend;
        strbeg:='';
        while RemoveSymbol(strbeg,strend,FmlTransTable[i].szWP,xpos) do
		begin
                arg0:='';
                arg1:='';
                arg2:='';
                if pos('0',StrPas(FmlTransTable[i].szTex))>0 then
			RemoveLastArg(strBeg,arg0);
                if pos('1',StrPas(FmlTransTable[i].szTex))>0 then
			Remove1stArg(strEnd,arg1);
                if pos('2',StrPas(FmlTransTable[i].szTex))>0 then
			Remove1stArg(strEnd,arg2);

                StrBeg:=cutstr(StrBeg);
                StrEnd:=cutstr(StrEnd);

                interpret(strbeg,strend,StrPas(FmlTransTable[i].szTex),FmlTransTable[i].szWp,arg0,arg1,arg2);
{               writeln;
                writeln(strbeg+strend);}
		end;
        end;
  strbeg:=strbeg+strend;
  strend:='';

  if AnchorType<>2 then
      begin
      writeln(cq.strip^,strbeg);

{     if(CaptionLen>0) then
  	  begin
          seek(cq.wpd^,CaptionPos);
          DoCaption(cq,CaptionLen);
          end;}
      cq.Envir:='Q';

      cq.line_term := 'p';     { Soft return }
      Make_tabelentry_envir_extra_end(cq);

      cq.char_on_line:=False;
      cq.nomore_valid_tabs := False;
      cq.rownum:=cq.rownum+1;
      Make_tabelentry_attr(cq);
      cq.latex_tabpos:=0;
      end
   else begin
        For j:=cq.openptr[cq.depth] Downto 1 Do
        	begin
{               writeln(Open_com[cq.attr_rij[cq.depth,j]]);}
                if Open_com[cq.attr_rij[cq.depth,j]][1]='$' then {math is already active}
                	begin
                        StrangeMath:=True;
                        end;
                end;
        if StrangeMath then write(cq.strip^,'}{',strbeg,'}{\rm ')
		       else write(cq.strip^,' $',strbeg,'$ ');
        end;

EqEmpty:
   dec(cq.recursion);
   cq.flag:=OldFlag;
   cq.Envir:=OldEnvir;
   cq.ObjType:='Equation';
End;

end.