##############################################################################
##############################################################################
##
##  ARCHIVE HEADER INFORMATION
##
##  @Make-file{
##      FILENAME    = "os2-cset.mak",
##      VERSION     = "1.00",
##      DATE        = "",
##      TIME        = "",
##
##      AUTHOR      = "Niel Kempson",
##      ADDRESS     = "25 Whitethorn Drive, Cheltenham, GL52 5LL, England",
##      TELEPHONE   = "+44-242 579105",
##      EMAIL       = "kempson@tex.ac.uk (Internet)",
##
##      SUPPORTED   = "yes",
##      ARCHIVED    = "tex.ac.uk, ftp.tex.ac.uk",
##      KEYWORDS    = "VVcode",
##
##      CODETABLE   = "ISO/ASCII",
##      CHECKSUM    = "51492 1481 5732 57976",
##
##      DOCSTRING   = { This file is part of VVcode.
##                  }
##  }
##
##  MODULE CONTENTS
##
##      [tbs]
##
##  COPYRIGHT
##
##      Copyright (c) 1991-1993 by Niel Kempson <kempson@tex.ac.uk>
##
##      This program is free software; you can redistribute it and/or
##      modify it under the terms of the GNU General Public License as
##      published by the Free Software Foundation; either version 1, or
##      (at your option) any later version.
##
##      This program is distributed in the hope that it will be useful,
##      but WITHOUT ANY WARRANTY; without even the implied warranty of
##      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
##      General Public License for more details.
##
##      You should have received a copy of the GNU General Public License
##      along with this program; if not, write to the Free Software
##      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
##
##      In other words, you are welcome to use, share and improve this
##      program.  You are forbidden to forbid anyone else to use, share
##      and improve what you give them.   Help stamp out software-hoarding!  
##
##  CHANGE LOG
##
##############################################################################
##############################################################################


##############################################################################
#
# Local definitions for file types and compilation / linking.
#
# If your OS/2 compiler is already supported it should not be necessary to 
# modify any part of the Makefile except the local definitions below.	Here 
# are some examples known to work for my OS/2 C compilers.
#
#   EMX/GNUC v2.1
#
#	CC	            = GCC
#	LINK	            = GCC
#	CCMODEL             = 
#       CCDEFINES           = -DOS2 
#	CFLAGS	            = -c -g  -Wall -Wconversion $(CCDEFINES) -o $@
#	LFLAGS	            = -g -o $@
#
#   IBM C Set/2 v1.00 (using migration libraries)
#
#	CC	            = ICC
#	LINK	            = ICC
#	CCMODEL             = 
#       CCDEFINES           = 
#	CFLAGS	            = /C /W3 /Kb /Sm /O- /Q+ /Ti $(CCDEFINES) 
#	LFLAGS	            = /Q+
#
#   Microsoft C v6.0
#
#	CC	            = CL
#	LINK	            = CL
#	CCMODEL             = /AS
#       CCDEFINES           = 
#	CFLAGS	            = $(CCMODEL) /c /W4 /Zd /Zi /Od $(CCDEFINES) /Lp
#	LFLAGS	            = $(CCMODEL) /Lp /link /PMTYPE:VIO 
#
##############################################################################
# Start of local definitions.
##############################################################################
CC	            = ICC
LINK	            = ICC
CCMODEL             = 
CCDEFINES           = 
CFLAGS	            = /C /W3 /Kb /Sm /O- /Q+ /Ti $(CCDEFINES) 
LFLAGS	            = /Q+
##############################################################################
# End of local definitions.
##############################################################################


##############################################################################
# File types and default rule for compilation
##############################################################################
EXE		= .exe
OBJ		= .obj

.SUFFIXES:      .c .h $(OBJ) $(EXE)

.c.obj:
	$(CC)  $(CFLAGS)  $*.c    	

##############################################################################
# Target Groupings
##############################################################################
HDRFILES	= checkos.h machine.h local.h globals.h specific.h vvutils.h

OBJFILES	= vvencode$(OBJ) vvdecode$(OBJ) vveparse$(OBJ) \
		  vvutils$(OBJ) os2$(OBJ)

EXEFILES	= vvencode$(EXE) vvdecode$(EXE)

##############################################################################
# Top level targets
##############################################################################
vvcode:		$(EXEFILES)
	@ echo VVcode built

clean:
	- del *$(OBJ)
	- del *$(EXE)
    
#-----------------------------------------------------------------------------
# Dependencies for executables
#-----------------------------------------------------------------------------
vvencode$(EXE): vvencode$(OBJ) vvutils$(OBJ) os2$(OBJ)
	$(LINK)  vvencode$(OBJ) vvutils$(OBJ) os2$(OBJ) $(LFLAGS)

vvdecode$(EXE):	vvdecode$(OBJ) vveparse$(OBJ) vvutils$(OBJ) os2$(OBJ)
	$(LINK)  vvdecode$(OBJ) vveparse$(OBJ) vvutils$(OBJ) \
                 os2$(OBJ) $(LFLAGS)

#-----------------------------------------------------------------------------
# Dependencies for object files
#-----------------------------------------------------------------------------
vvencode$(OBJ): vvencode.c $(HDRFILES)

vvdecode$(OBJ): vvdecode.c $(HDRFILES) vveparse.h

vveparse$(OBJ):	vveparse.c $(HDRFILES) vveparse.h

vvutils$(OBJ):	vvutils.c $(HDRFILES)

os2$(OBJ):	os2.c $(HDRFILES)
