/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.builder;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Map;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.builder.AdaptableBuilder;
import net.sourceforge.texlipse.builder.Builder;
import net.sourceforge.texlipse.builder.BuilderCoreException;
import net.sourceforge.texlipse.builder.BuilderRegistry;
import net.sourceforge.texlipse.builder.OutputFileManager;
import net.sourceforge.texlipse.builder.ProjectFileTracking;
import net.sourceforge.texlipse.properties.TexlipseProperties;
import net.sourceforge.texlipse.texparser.LatexParserUtils;
import net.sourceforge.texlipse.viewer.ViewerManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class TexlipseBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = TexlipseBuilder.class.getName();
    public static final String MARKER_TYPE = String.valueOf(TexlipseProperties.PACKAGE_NAME) + ".builderproblem";
    public static final String LAYOUT_WARNING_TYPE = String.valueOf(TexlipseProperties.PACKAGE_NAME) + ".layoutproblem";
    private static final int validDocumentLimit = 10;
    private static final String NO_PARTIAL_BUILD = "%##noBuild";

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        ProjectFileTracking fileTracking = new ProjectFileTracking(project);
        OutputFileManager fileManager = new OutputFileManager(project, fileTracking);
        Object rebuild = TexlipseProperties.getSessionProperty((IResource)project, "forcedRebuild");
        Job[] jobArray = Job.getJobManager().find((Object)"TexDocument Parser");
        int n = jobArray.length;
        int n2 = 0;
        while (n2 < n) {
            Job parser = jobArray[n2];
            int state = parser.getState();
            if (state == 2 || state == 1) {
                parser.cancel();
                parser.schedule();
            }
            try {
                parser.join();
            }
            catch (InterruptedException interruptedException) {}
            ++n2;
        }
        if (rebuild == null && fileManager.isUpToDate()) {
            return null;
        }
        BuilderRegistry.clearConsole();
        String s = TexlipseProperties.getProjectProperty((IResource)project, "partialBuild");
        if (s != null) {
            this.partialBuild(project, fileManager, monitor);
        } else {
            this.buildFile(project, null, fileManager, monitor);
        }
        TexlipseProperties.setSessionProperty((IResource)project, "forcedRebuild", null);
        return null;
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        ProjectFileTracking fileTracking = new ProjectFileTracking(project);
        OutputFileManager fileManager = new OutputFileManager(project, fileTracking);
        BuilderRegistry.clearConsole();
        TexlipseProperties.setSessionProperty((IResource)project, "rerunLatex", null);
        TexlipseProperties.setSessionProperty((IResource)project, "rerunBibtex", null);
        TexlipseProperties.setSessionProperty((IResource)project, "bibFilesChanged", null);
        String mainFile = TexlipseProperties.getProjectProperty((IResource)project, "mainTexFile");
        if (mainFile == null || mainFile.length() == 0) {
            return;
        }
        fileManager.cleanTempFiles(monitor);
        fileManager.cleanOutputFile(monitor);
        monitor.subTask(TexlipsePlugin.getResourceString("builderSubTaskCleanMarkers"));
        this.deleteMarkers(project);
        project.refreshLocal(2, monitor);
        monitor.done();
    }

    private void partialBuild(IProject project, OutputFileManager fileManager, IProgressMonitor monitor) throws CoreException {
        IResource res;
        IEditorPart part = TexlipsePlugin.getCurrentWorkbenchPage().getActiveEditor();
        ITextEditor editor = null;
        if (part instanceof ITextEditor) {
            editor = (ITextEditor)part;
        }
        if ((res = (IResource)part.getEditorInput().getAdapter(IResource.class)) == null || res.getType() != 1 || !res.getProject().equals((Object)project)) {
            return;
        }
        String resourceName = res.getName();
        int extIndex = resourceName.lastIndexOf(46);
        String ext = resourceName.substring(extIndex + 1);
        IDocument doc = editor.getDocumentProvider().getDocument((Object)part.getEditorInput());
        if (TexlipseProperties.isProjectPropertiesFileChanged(project)) {
            TexlipseProperties.loadProjectProperties(project);
        }
        IFile file = project.getFile(res.getProjectRelativePath());
        String content = doc.get();
        if (content.indexOf(NO_PARTIAL_BUILD) >= 0) {
            return;
        }
        if (resourceName.equals(TexlipseProperties.getProjectProperty((IResource)project, "mainTexFile")) || !ext.equals("tex") && !ext.equals("ltx")) {
            TexlipseProperties.setSessionProperty((IResource)project, "partialFile", null);
            this.buildFile(project, null, fileManager, monitor);
            return;
        }
        if (LatexParserUtils.findCommand(content, "\\documentclass", 0) != -1 || LatexParserUtils.findCommand(content, "\\documentstyle", 0) != -1 || LatexParserUtils.findBeginEnvironment(content, "document", 0) != null) {
            TexlipseProperties.setSessionProperty((IResource)project, "partialFile", file);
            this.buildFile(project, file, fileManager, monitor);
            return;
        }
        String tempFileContents = this.getTempFileContents(file, project, monitor);
        if (tempFileContents == null) {
            return;
        }
        IContainer folder = TexlipseProperties.getProjectSourceDir(project);
        IFile tmpFile = folder.getFile((IPath)new Path("tempPartial00000.tex"));
        TexlipseProperties.setSessionProperty((IResource)project, "partialFile", tmpFile);
        if (tmpFile == null) {
            throw new CoreException(TexlipsePlugin.stat("Can't create temp file"));
        }
        ByteArrayInputStream bar = new ByteArrayInputStream(tempFileContents.getBytes());
        if (tmpFile.exists()) {
            tmpFile.setContents((InputStream)bar, true, false, monitor);
        } else {
            tmpFile.create((InputStream)bar, true, monitor);
        }
        tmpFile.setDerived(true);
        this.buildFile(project, tmpFile, fileManager, monitor);
    }

    private String getTempFileContents(IFile file, IProject project, IProgressMonitor monitor) throws CoreException {
        String preamble = (String)TexlipseProperties.getSessionProperty((IResource)project, "preamble");
        if (preamble == null) {
            BuilderRegistry.printToConsole(TexlipsePlugin.getResourceString("builderNoPreambleFound"));
            return null;
        }
        String bibsty = (String)TexlipseProperties.getSessionProperty((IResource)project, "bibStyle");
        String[] bibli = (String[])TexlipseProperties.getSessionProperty((IResource)project, "bibFiles");
        Boolean biblatexMode = (Boolean)TexlipseProperties.getSessionProperty((IResource)project, "biblatexMode");
        Boolean localBib = (Boolean)TexlipseProperties.getSessionProperty((IResource)project, "biblatexLocalBib");
        StringBuilder sb = new StringBuilder("\\input{");
        String name = ViewerManager.resolveRelativePath(TexlipseProperties.getProjectSourceDir(project).getProjectRelativePath(), file.getProjectRelativePath());
        name = name.substring(0, name.lastIndexOf(46) + 1);
        boolean ws = false;
        if (name.indexOf(32) >= 0) {
            sb.append('\"');
            ws = true;
        }
        int i = 0;
        while (i < name.length() - 1) {
            char c = name.charAt(i);
            if (c == File.separatorChar) {
                sb.append('/');
            } else if (c == ' ') {
                sb.append("\\space ");
            } else {
                sb.append(c);
            }
            ++i;
        }
        if (ws) {
            sb.append('\"');
        }
        sb.append("}\n");
        if (biblatexMode == null) {
            if (bibsty != null) {
                sb.append("\\bibliographystyle{");
                sb.append(bibsty);
                sb.append("}\n");
            }
            if (bibli != null && bibli.length > 0) {
                sb.append("\\bibliography{");
                i = 0;
                while (i < bibli.length - 1) {
                    int ext = bibli[i].lastIndexOf(46);
                    if (ext >= 0) {
                        sb.append(bibli[i].substring(0, ext));
                    } else {
                        sb.append(bibli[i]);
                    }
                    sb.append(',');
                    ++i;
                }
                if (bibli.length > 1 || !bibli[0].equals(".bib")) {
                    int ext = bibli[bibli.length - 1].lastIndexOf(46);
                    if (ext >= 0) {
                        sb.append(bibli[bibli.length - 1].substring(0, ext));
                    } else {
                        sb.append(bibli[bibli.length - 1]);
                    }
                }
                sb.append("}\n");
            }
        } else if (localBib == null) {
            sb.append("\\printbibliography");
        }
        sb.append("\n\\end{document}\n");
        return String.valueOf(preamble) + '\n' + sb.toString();
    }

    private void buildFile(IProject project, IFile resource, OutputFileManager fileManager, IProgressMonitor monitor) throws CoreException {
        if (TexlipseProperties.isProjectPropertiesFileChanged(project)) {
            TexlipseProperties.loadProjectProperties(project);
        }
        Builder builder = null;
        try {
            builder = this.checkBuilderSettings(project);
        }
        catch (CoreException coreException) {
            return;
        }
        if (resource == null) {
            try {
                resource = (IFile)this.checkFileSettings(project, monitor);
            }
            catch (CoreException coreException) {}
            if (resource == null) {
                return;
            }
        }
        monitor.beginTask(TexlipsePlugin.getResourceString("builderSubTaskBuild"), 100);
        this.deleteMarkers(project);
        monitor.worked(1);
        builder.reset(monitor);
        fileManager.setCurrentSourceFile(resource);
        fileManager.performBeforeBuild(monitor);
        try {
            builder.build((IResource)resource);
        }
        catch (BuilderCoreException builderCoreException) {}
        fileManager.performAfterBuild(monitor);
        monitor.done();
    }

    private IResource checkFileSettings(IProject project, IProgressMonitor monitor) throws CoreException {
        String outputFile;
        String mainFile = TexlipseProperties.getProjectProperty((IResource)project, "mainTexFile");
        if (mainFile == null || mainFile.length() == 0) {
            BuilderRegistry.printToConsole(TexlipsePlugin.getResourceString("builderErrorMainFileNotSet").replaceAll("%s", project.getName()));
        }
        if ((outputFile = TexlipseProperties.getProjectProperty((IResource)project, "outputFile")) == null || outputFile.length() == 0) {
            BuilderRegistry.printToConsole(TexlipsePlugin.getResourceString("builderErrorOutputFileNotSet").replaceAll("%s", project.getName()));
            throw new CoreException(TexlipsePlugin.stat("Project output file name not set."));
        }
        IFile resource = TexlipseProperties.getProjectSourceFile(project);
        if (resource == null || !resource.exists()) {
            BuilderRegistry.printToConsole(TexlipsePlugin.getResourceString("builderErrorMainFileNotFound").replaceAll("%s", project.getName()));
            throw new CoreException(TexlipsePlugin.stat("Main .tex -file not found."));
        }
        if (resource.getRawLocation().toFile().length() < 10L) {
            return null;
        }
        return resource;
    }

    private Builder checkBuilderSettings(IProject project) throws CoreException {
        String format = TexlipseProperties.getProjectProperty((IResource)project, "outputFormat");
        if (format == null || format.length() == 0) {
            BuilderRegistry.printToConsole(TexlipsePlugin.getResourceString("builderErrorOutputFormatNotSet").replaceAll("%s", project.getName()));
            throw new CoreException(TexlipsePlugin.stat("Project output file format not set."));
        }
        String str = TexlipseProperties.getProjectProperty((IResource)project, "builderNum");
        if (str == null) {
            BuilderRegistry.printToConsole(TexlipsePlugin.getResourceString("builderErrorOutputBuilderNotSet").replaceAll("%s", project.getName()));
            throw new CoreException(TexlipsePlugin.stat("No builder selected."));
        }
        int number = 0;
        try {
            number = Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {}
        Builder builder = BuilderRegistry.get(number);
        if (builder instanceof AdaptableBuilder) {
            ((AdaptableBuilder)((Object)builder)).updateBuilder(project);
        }
        if (builder == null) {
            BuilderRegistry.printToConsole(TexlipsePlugin.getResourceString("builderErrorBuilderNumberNotSet").replaceAll("%s", project.getName()).replaceAll("%f", format).replaceAll("%i", String.valueOf(number)));
            throw new CoreException(TexlipsePlugin.stat("Builder (#" + number + ") for " + format + " output format not configured."));
        }
        if (!builder.isValid()) {
            BuilderRegistry.printToConsole(TexlipsePlugin.getResourceString("builderErrorBuilderNumberInvalid").replaceAll("%s", project.getName()).replaceAll("%f", format).replaceAll("%i", String.valueOf(number)));
            throw new CoreException(TexlipsePlugin.stat("Builder (#" + number + ") for " + format + " output format has an invalid configuration. Please check" + "if paths to builder programs are set up correctly."));
        }
        return builder;
    }

    protected void deleteMarkers(IProject project) throws CoreException {
        project.deleteMarkers(MARKER_TYPE, false, 2);
        project.deleteMarkers(LAYOUT_WARNING_TYPE, false, 2);
    }
}

