/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2007  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/

/*
   list_abs.c: Liste der Abstracts schreiben
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "refs.h"
#include "fl_ut.h"
#include "str_refs.h"
#include "ix04_fun.h"
#include "str_fun.h"
#include "interf.h"
#include "initial.h"
#include "list_abs.h"



#define ZEILE_LEN 30600

 extern config_set one_config_set;
 extern char wrtxtbu[WRTXTBU_LEN + 1];

 extern char textpfad[PFAD_LEN+1];
 extern char rdbpfad[PFAD_LEN+1];
 extern char log_name[PFAD_LEN+1];
 
 
 static char txt_name[PFAD_LEN + 1];
 static char bbt_name[PFAD_LEN + 1];
 
 extern char abstr_dat_name[PFAD_LEN + 1];
 extern char abstr_pix_name[PFAD_LEN + 1];


 static char kennziffer[KENNZIFFER_LEN + 1];
 static char * zeile;

 static FILE * fpbbt;
 static FILE * fptxt;
 static FILE * fpabsdat;

 extern FILE * ix04file;

 static bbatchtable_rec        one_bbt_rec;
 extern abstr_rec              one_abstr_rec;
 extern abstrpix_rec           ix04rec;

 static int getfilenames_list_abs(void);
 static int dateien_oeffnen_list_abs(void);
 static int dateien_schliessen_list_abs(void);
 static int machlist_list_abs(void);

 
int list_abs_main(void)
{
     if (!getfilenames_list_abs())
     {
         return 1;
     }
     if ((zeile = (char *) malloc ((ZEILE_LEN +1) * sizeof(char)))==NULL)
     {
         wrtxt("\nMemory allocation error in function 'list_abs_main()'\n");
     }
     if (dateien_oeffnen_list_abs())
     {
         machlist_list_abs();
         dateien_schliessen_list_abs();
         load_file_yn(txt_name);
     }
     free(zeile);
     return 0;
}


static int getfilenames_list_abs(void)
{
  char datei[PFAD_LEN+1];
  if (!dateivornamen_holen(datei,"Please enter name for text file (default `abstr')"))
  {
     strcpy(datei,"abstr");
  }
  strlimcpy(txt_name,textpfad,PFAD_LEN);
  strlimcat(txt_name,datei,PFAD_LEN);
  strlimcat(txt_name,".txt",PFAD_LEN);
  if (isfile(txt_name))
  {
     if (!do_overwrite_yn())
     {
        return 0;
     }
  }
   
  /* begin new 3.12.2006 */
  wrtxt(LIST_ABS_EXPL1);
  /* end new 3.12.2006 */

  if (!datei_suchen_mit_pfad("*.bbt",rdbpfad,bbt_name))
  {
     wrtxt("\n(No file selected)\n");
     return 0;
  }
  return 1;
}

static int dateien_oeffnen_list_abs(void)
{
    if (filesize(abstr_pix_name)==0)
    {
        wrtxt("\n(Abstract index file is empty, aborted)\n");
        return 0;
    }
    if (!read_ix04(abstr_pix_name))
    {
        return 0;
    }
    if ((fpabsdat=fopen(abstr_dat_name,"rb"))==NULL)
    {
       sprintf(wrtxtbu,"\n(ERROR: cannot read %s)\n",abstr_dat_name);
       wrtxt(wrtxtbu);
       close_ix04();
       return 0;
    }
    if ((fpbbt=fopen(bbt_name,"rb"))==NULL)
    {
       sprintf(wrtxtbu,"\n(ERROR: cannot read %s)\n",bbt_name);
       wrtxt(wrtxtbu);
       close_ix04();
       fclose(fpabsdat);
       return 0;
    }
    if ((fptxt=fopen(txt_name,"w"))==NULL)
    {
       sprintf(wrtxtbu,"\n(ERROR: cannot write into %s)\n",txt_name);
       wrtxt(wrtxtbu);
       close_ix04();
       fclose(fpabsdat);
       fclose(fpbbt);
       return 0;
    }
    if (!logdatei_oeffnen())
    {
       sprintf(wrtxtbu,"\nERROR: cannot create log file\n");
       wrtxt(wrtxtbu);
       close_ix04();
       fclose(fpabsdat);
       fclose(fpbbt);
       fclose(fptxt);
       return 0;
    }
    return 1;
}

static int dateien_schliessen_list_abs(void)
{
   close_ix04();
   fclose(fpabsdat);
   fclose(fpbbt);
   fclose(fptxt);
   logdatei_schliessen();
   return 1;
}


static int machlist_list_abs(void)
{
   long i, ii, j, anzahl_records, byte_zeiger, rec_zeiger, anzahl_bloecke;
   unsigned int laenge;
   j = 1;
   fseek(fpbbt,0L,SEEK_END);
   byte_zeiger = ftell(fpbbt);
   rewind(fpbbt);
   anzahl_records = byte_zeiger / sizeof(one_bbt_rec);
   anzahl_records--;
   if (anzahl_records==-1)
   {
       wrtxt("\n(Current bbt-file is empty, please press any key)\n");
       return 0;
   }
   sprintf(wrtxtbu,"\n(Compiling %li references)\n",anzahl_records+1);
   wrtxt(wrtxtbu);
   for (i=0;i<=anzahl_records;i++)
   {
       if ((i % 100)==0)
       {
          if (i==100) wrtxt("\n");
          if (i>0)
          {
            sprintf(wrtxtbu,"[%li] ",i);
            wrtxt(wrtxtbu);
          }
       }
       fread(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt);
       strcpy(kennziffer,one_bbt_rec.kennziffer);
       if (locate_ix04(kennziffer,&ix04rec) > -1)
       {
         rec_zeiger = ix04rec.abstr_rptr;
         byte_zeiger = rec_zeiger * sizeof(one_abstr_rec);
         strcpy(zeile,"");
         fseek(fpabsdat,byte_zeiger,SEEK_SET);
         fread(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabsdat);
         fseek(fpabsdat,byte_zeiger,SEEK_SET);
         anzahl_bloecke = one_abstr_rec.abstr_n;
         for (ii=1;ii<=anzahl_bloecke;ii++)
         {
             fread(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabsdat);
             strlimcat(zeile,one_abstr_rec.abs_text,ZEILE_LEN+1);
         }
         laenge = strlen(zeile);
         for (ii=0;ii<laenge;ii++)
         {
            if (zeile[ii]=='\xfe')
            {
              zeile[ii]='\n';
            }
         }
         fprintf(fptxt,"==========================================="
         "==================================");
         fprintf(fptxt,"\nABSTRACT TEXT No %s\n",kennziffer);
         fprintf(fptxt,"==========================================="
         "==================================");
         fprintf(fptxt,"\n\n");
         fprintf(fptxt,"%s\n\n",zeile);
         j++;
       }
       else
       {
          // fprintf(fplog,"Abstract text '%s' not found\n",kennziffer);
          sprintf(wrtxtbu,"Abstract text '%s' not found",kennziffer);
          logdatei_schreiben(wrtxtbu);
       }
   }
   if (i > 100) wrtxt("\n");
   sprintf(wrtxtbu,"\n(Completed, text file `%s' written)\n",
                    txt_name);
   wrtxt(wrtxtbu);
   return 1;
}


