#
# mncyclib.pm
# library module for monocyclic compounds
#
print "module mncyclib version 1.1 2000-01-17\n";

# Zyklobutan
# parameter: "cb", , , startpos, bliste, radius
sub cb_default_
{
    my ($iAnz, $p1, $iAngle, $iStart, $BT, $bAromat, $rRadius) = @_;
    $$iAnz = 4;
    $$iStart = $$p1 = $$iAngle = 0;
    $$rRadius = $rLenN;
    $$bAromat = $false;
    @$BT = (9, 9, 0, 0);
}

sub cb_
{
    my ($XYstart, $rRadius, $rRadius_bak, $iAnz, $p1, $iAngle, $iStart, 
			$M, $rLena, $rThetaa, $XYa, $BLa, $t, $b, $r) = @_;

    $$rRadius_bak = $$rRadius = abs($$rRadius);
    $$XYa[0] = loc->new(0,0);
    $$XYa[1] = getpos($$XYa[0], -130, $$rRadius);
    $$XYa[2] = getpos($$XYa[1], 140, $$rRadius);
    $$XYa[3] = getpos($$XYa[2], -30, $$rRadius*1.5);
    @$rThetaa = (-130, 140, -30, getangle($$XYa[3], $$XYa[0]));
    @$rLena = ($$rRadius, $$rRadius, $$rRadius*1.5, 
	getlength($$XYa[3], $$XYa[0]));
  
    grep(($_->rotate($iAngle) && 0), @$XYa);
    my $XYshift = loc->new($$XYa[$iStart]);
    grep(($_->translate(- $XYshift->{"x"},
			- $XYshift->{"y"}) && 0), @$XYa);
    grep(($_->translate($XYstart) && 0), @$XYa);
    $M->eq(0,0);
    $M->translate($XYstart);
    @$BLa = (0, 1, 2, 3);   # start atom
    @$r = (60, -100, 150, -60);
    @$t = (120, 170, 90,   30);
    @$b = (30,  -90, -150, -90);
    grep((($_ += $iAngle) && 0), @$r, @$t, @$b, @$rThetaa);
}



# Zyklopentan envelope-Konformation
# parameter: "cp", conformertyp, , startpos, bliste, radius
sub cp_default_
{
    my ($iAnz, $conf, $iAngle, $iStart, $BT, $bAromat, $rRadius) = @_;
    $$iAnz = 5;
    $$iStart = $$conf = $$iAngle = 0;
    $$rRadius = $rLenN;
    $$bAromat = $false;
    @$BT = (9, 9, 0, 0, 0);
}

sub cp_
{
    my ($XYstart, $rRadius, $rRadius_bak, $iAnz, $conf, $iAngle, $iStart, 
			$M, $rLena, $rThetaa, $XYa, $BLa, $t, $b, $r) = @_;

    $$rRadius_bak = $$rRadius = abs($$rRadius);
    $$XYa[0] = loc->new(0,0);
    if ($conf == 0)
    {
	$$XYa[1] = getpos($$XYa[0], -120, $$rRadius*1.5);
	$$XYa[2] = getpos($$XYa[1], 170, $$rRadius);
	$$XYa[3] = getpos($$XYa[2], 20, $$rRadius);
	$$XYa[4] = getpos($$XYa[3], -10, $$rRadius);
	@$rThetaa = (-120, 170, 20, -10, getangle($$XYa[4], $$XYa[0]));
	@$rLena = ($$rRadius*1.5, $$rRadius, $$rRadius, $$rRadius, 
		getlength($$XYa[4], $$XYa[0]));
	@$r = (80, -60, -170, 110, -50);
	@$t = (150, 30,  150, 150, 30);
	@$b = (30,  -90, -90, -90, -90);
    }
    elsif ($conf == 1)
    {
	$$XYa[1] = getpos($$XYa[0], -160, $$rRadius);
	$$XYa[2] = getpos($$XYa[1], 170, $$rRadius);
	$$XYa[3] = getpos($$XYa[2], 100, $$rRadius);
	$$XYa[4] = getpos($$XYa[0], 170, $$rRadius);
	@$rThetaa = (-160, 170, 100, getangle($$XYa[3], $$XYa[4]), -10);
	@$rLena = ($$rRadius, $$rRadius, $$rRadius,
		getlength($$XYa[3], $$XYa[4]), $$rRadius);
	@$r = (0, -60, -150, 120, 60);
	@$t = (90,  90,  150,  90,   90);
	@$b = (-30, -60, -90, -150, -150);
    }
    elsif ($conf == 2)
    {
	$$XYa[1] = getpos($$XYa[0], -160, $$rRadius);
	$$XYa[2] = getpos($$XYa[1], 140, $$rRadius*1.5);
	$$XYa[4] = getpos($$XYa[0], 170, $$rRadius);
	$$XYa[3] = getpos($$XYa[4], -160, $$rRadius);
	@$rThetaa = (-160, 140, getangle($$XYa[2], $$XYa[3]), 20, -10);
	@$rLena = ($$rRadius, $$rRadius*1.5, 
		getlength($$XYa[2], $$XYa[3]), $$rRadius, $$rRadius);
	@$r = (0, -90, 120, -120, 90);
	@$t = (90,  0,   60,  150, 90);
	@$b = (-30, -90, 180, -90, -60);
    }
    elsif ($conf == 3)
    {
	$$XYa[1] = getpos($$XYa[0], -160, $$rRadius);
	$$XYa[2] = getpos($$XYa[1], 140, $$rRadius);
	$$XYa[3] = getpos($$XYa[2], 20, $$rRadius);
	$$XYa[4] = getpos($$XYa[0], 100, $$rRadius*1.5);
	@$rThetaa = (-160, 140, 20, getangle($$XYa[3], $$XYa[4]), -80);
	@$rLena = ($$rRadius, $$rRadius, $$rRadius, 
		getlength($$XYa[3], $$XYa[4]), $$rRadius*1.5);
	@$r = (-30, -90, 180, -60, 80);
	@$t = (30,  -10,  90,  120,   150);
	@$b = (-90, -90, -150, -90, 30);
    }
  
    grep(($_->rotate($iAngle) && 0), @$XYa);
    my $XYshift = loc->new($$XYa[$iStart]);
    grep(($_->translate(- $XYshift->{"x"},
			- $XYshift->{"y"}) && 0), @$XYa);
    grep(($_->translate($XYstart) && 0), @$XYa);
    $M->eq(0,0);
    $M->translate($XYstart);
    @$BLa = (0, 1, 2, 3, 4);   # start atom
    grep((($_ += $iAngle) && 0), @$r, @$t, @$b, @$rThetaa);
}



# Furanosering 
# parameter: "furanose", , , startpos, bliste, radius
sub furanose_default_
{
    my ($iAnz, $conf, $iAngle, $iStart, $BT, $bAromat, $rRadius) = @_;
    $$iAnz = 5;
    $$iStart = $$conf = $$iAngle = 0;
    $$rRadius = $rLenN;
    $$bAromat = $false;
    @$BT = (0, 9, 9, 9, 0);
}

sub furanose_
{
    my ($XYstart, $rRadius, $rRadius_bak, $iAnz, $conf, $iAngle, $iStart, 
			$M, $rLena, $rThetaa, $XYa, $BLa, $t, $b, $r) = @_;

    $$rRadius_bak = $$rRadius = abs($$rRadius);
    $$XYa[0] = loc->new(0,0);
    $$XYa[1] = getpos($$XYa[0], -30, $$rRadius*2/sqrt(3));
    $$XYa[2] = getpos($$XYa[1], -120, $$rRadius);
    $$XYa[3] = getpos($$XYa[2], 180, $$rRadius);
    $$XYa[4] = getpos($$XYa[3], 120, $$rRadius);
    @$rThetaa = (-30, -120, 180, 120,30);
    @$rLena = ($$rRadius*2/sqrt(3), $$rRadius, $$rRadius, $$rRadius, $$rRadius*2/sqrt(3));
    @$r = (90, 30, -60, -120, 150);
    @$t = (150, 60,  0, -60, -150);
    @$b = (30,  -30, -120, 180, 120);
  
    grep(($_->rotate($iAngle) && 0), @$XYa);
    my $XYshift = loc->new($$XYa[$iStart]);
    grep(($_->translate(- $XYshift->{"x"},
			- $XYshift->{"y"}) && 0), @$XYa);
    grep(($_->translate($XYstart) && 0), @$XYa);
    $M->eq(0,0);
    $M->translate($XYstart);
    @$BLa = (0, 1, 2, 3, 4);   # start atom
    grep((($_ += $iAngle) && 0), @$r, @$t, @$b, @$rThetaa);
}
