"""
DO NOT ALTER THIS FILE IN ANY WAY, IT IS GENERATED AUTOMATICALLY. SEE THE SCRIPT
`update_unicode_table.py` FOR MORE INFORMATION.

This file contains a table of unicode code point to LaTeX command mapping. It
has 2369 entries and was derived from
<https://raw.githubusercontent.com/w3c/xml-entities/gh-pages/unicode.xml>."""
#pylint: disable=too-many-lines,missing-docstring


import enum

class LaTeXMode(enum.Enum):
    """Represent either math or text mode. Math mode in LaTeX is e.g.
    everything between $ and $."""
    mathmode = 1
    textmode = 0

unicode_table = {
    161: {LaTeXMode.textmode: '\\textexclamdown ', LaTeXMode.mathmode: '\\textexclamdown'},
    162: {LaTeXMode.textmode: '\\textcent ', LaTeXMode.mathmode: '\\mbox{\\textcent}'},
    163: {LaTeXMode.textmode: '\\textsterling ', LaTeXMode.mathmode: '\\sterling'},
    164: {LaTeXMode.textmode: '\\textcurrency ', LaTeXMode.mathmode: '\\mbox{\\textcurrency}'},
    165: {LaTeXMode.textmode: '\\textyen ', LaTeXMode.mathmode: '\\yen'},
    166: {LaTeXMode.textmode: '\\textbrokenbar '},
    167: {LaTeXMode.textmode: '\\textsection ', LaTeXMode.mathmode: '\\S'},
    168: {LaTeXMode.textmode: '\\textasciidieresis '},
    169: {LaTeXMode.textmode: '\\textcopyright ', LaTeXMode.mathmode: '\\copyright'},
    170: {LaTeXMode.textmode: '\\textordfeminine '},
    171: {LaTeXMode.textmode: '\\guillemotleft ', LaTeXMode.mathmode: '\\mbox{\\guillemotleft}'},
    172: {LaTeXMode.textmode: '\\lnot ', LaTeXMode.mathmode: '\\neg'},
    173: {LaTeXMode.textmode: '\\-'},
    174: {LaTeXMode.textmode: '\\textregistered ', LaTeXMode.mathmode: '\\circledR'},
    175: {LaTeXMode.textmode: '\\textasciimacron '},
    176: {LaTeXMode.textmode: '\\textdegree ', LaTeXMode.mathmode: '\\degree'},
    177: {LaTeXMode.textmode: '\\pm ', LaTeXMode.mathmode: '\\pm'},
    178: {LaTeXMode.textmode: '{^2}', LaTeXMode.mathmode: '^2'},
    179: {LaTeXMode.textmode: '{^3}', LaTeXMode.mathmode: '^3'},
    180: {LaTeXMode.textmode: '\\textasciiacute ', LaTeXMode.mathmode: '\\textasciiacute'},
    181: {LaTeXMode.textmode: '\\mathrm{\\mu}', LaTeXMode.mathmode: '\\mu'},
    182: {LaTeXMode.textmode: '\\textparagraph ', LaTeXMode.mathmode: '\\P'},
    183: {LaTeXMode.textmode: '\\cdot ', LaTeXMode.mathmode: '\\cdotp'},
    184: {LaTeXMode.textmode: '\\c{}', LaTeXMode.mathmode: '\\mbox{\\c{}}'},
    185: {LaTeXMode.textmode: '{^1}', LaTeXMode.mathmode: '^1'},
    186: {LaTeXMode.textmode: '\\textordmasculine '},
    187: {LaTeXMode.textmode: '\\guillemotright ', LaTeXMode.mathmode: '\\mbox{\\guillemotright}'},
    188: {LaTeXMode.textmode: '\\textonequarter '},
    189: {LaTeXMode.textmode: '\\textonehalf '},
    190: {LaTeXMode.textmode: '\\textthreequarters '},
    191: {LaTeXMode.textmode: '\\textquestiondown ', LaTeXMode.mathmode: '\\textquestiondown'},
    192: {LaTeXMode.textmode: '\\`{A}', LaTeXMode.mathmode: '\\grave{A}'},
    193: {LaTeXMode.textmode: "\\'{A}", LaTeXMode.mathmode: '\\acute{A}'},
    194: {LaTeXMode.textmode: '\\^{A}', LaTeXMode.mathmode: '\\hat{A}'},
    195: {LaTeXMode.textmode: '\\~{A}', LaTeXMode.mathmode: '\\tilde{A}'},
    196: {LaTeXMode.textmode: '\\"{A}', LaTeXMode.mathmode: '\\ddot{A}'},
    197: {LaTeXMode.textmode: '\\AA '},
    198: {LaTeXMode.textmode: '\\AE ', LaTeXMode.mathmode: '\\AE'},
    199: {LaTeXMode.textmode: '\\c{C}', LaTeXMode.mathmode: '\\mbox{\\c{C}}'},
    200: {LaTeXMode.textmode: '\\`{E}', LaTeXMode.mathmode: '\\grave{E}'},
    201: {LaTeXMode.textmode: "\\'{E}", LaTeXMode.mathmode: '\\acute{E}'},
    202: {LaTeXMode.textmode: '\\^{E}', LaTeXMode.mathmode: '\\hat{E}'},
    203: {LaTeXMode.textmode: '\\"{E}', LaTeXMode.mathmode: '\\ddot{E}'},
    204: {LaTeXMode.textmode: '\\`{I}', LaTeXMode.mathmode: '\\grave{I}'},
    205: {LaTeXMode.textmode: "\\'{I}", LaTeXMode.mathmode: '\\acute{I}'},
    206: {LaTeXMode.textmode: '\\^{I}', LaTeXMode.mathmode: '\\hat{I}'},
    207: {LaTeXMode.textmode: '\\"{I}', LaTeXMode.mathmode: '\\ddot{I}'},
    208: {LaTeXMode.textmode: '\\DH '},
    209: {LaTeXMode.textmode: '\\~{N}', LaTeXMode.mathmode: '\\tilde{N}'},
    210: {LaTeXMode.textmode: '\\`{O}', LaTeXMode.mathmode: '\\grave{O}'},
    211: {LaTeXMode.textmode: "\\'{O}", LaTeXMode.mathmode: '\\acute{O}'},
    212: {LaTeXMode.textmode: '\\^{O}', LaTeXMode.mathmode: '\\hat{O}'},
    213: {LaTeXMode.textmode: '\\~{O}', LaTeXMode.mathmode: '\\tilde{O}'},
    214: {LaTeXMode.textmode: '\\"{O}', LaTeXMode.mathmode: '\\ddot{O}'},
    215: {LaTeXMode.textmode: '\\texttimes ', LaTeXMode.mathmode: '\\times'},
    216: {LaTeXMode.textmode: '\\O ', LaTeXMode.mathmode: '\\O'},
    217: {LaTeXMode.textmode: '\\`{U}', LaTeXMode.mathmode: '\\grave{U}'},
    218: {LaTeXMode.textmode: "\\'{U}", LaTeXMode.mathmode: '\\acute{U}'},
    219: {LaTeXMode.textmode: '\\^{U}', LaTeXMode.mathmode: '\\hat{U}'},
    220: {LaTeXMode.textmode: '\\"{U}', LaTeXMode.mathmode: '\\ddot{U}'},
    221: {LaTeXMode.textmode: "\\'{Y}", LaTeXMode.mathmode: '\\acute{Y}'},
    222: {LaTeXMode.textmode: '\\TH '},
    223: {LaTeXMode.textmode: '\\ss ', LaTeXMode.mathmode: '\\ss'},
    224: {LaTeXMode.textmode: '\\`{a}', LaTeXMode.mathmode: '\\grave{a}'},
    225: {LaTeXMode.textmode: "\\'{a}", LaTeXMode.mathmode: '\\acute{a}'},
    226: {LaTeXMode.textmode: '\\^{a}', LaTeXMode.mathmode: '\\hat{a}'},
    227: {LaTeXMode.textmode: '\\~{a}', LaTeXMode.mathmode: '\\tilde{a}'},
    228: {LaTeXMode.textmode: '\\"{a}', LaTeXMode.mathmode: '\\ddot{a}'},
    229: {LaTeXMode.textmode: '\\aa '},
    230: {LaTeXMode.textmode: '\\ae ', LaTeXMode.mathmode: '\\ae'},
    231: {LaTeXMode.textmode: '\\c{c}', LaTeXMode.mathmode: '\\mbox{\\c{c}}'},
    232: {LaTeXMode.textmode: '\\`{e}', LaTeXMode.mathmode: '\\grave{e}'},
    233: {LaTeXMode.textmode: "\\'{e}", LaTeXMode.mathmode: '\\acute{e}'},
    234: {LaTeXMode.textmode: '\\^{e}', LaTeXMode.mathmode: '\\hat{e}'},
    235: {LaTeXMode.textmode: '\\"{e}', LaTeXMode.mathmode: '\\ddot{e}'},
    236: {LaTeXMode.textmode: '\\`{\\i}', LaTeXMode.mathmode: '\\grave{\\imath}'},
    237: {LaTeXMode.textmode: "\\'{\\i}", LaTeXMode.mathmode: '\\acute{\\imath}'},
    238: {LaTeXMode.textmode: '\\^{\\i}', LaTeXMode.mathmode: '\\hat{\\imath}'},
    239: {LaTeXMode.textmode: '\\"{\\i}', LaTeXMode.mathmode: '\\ddot{\\imath}'},
    240: {LaTeXMode.textmode: '\\dh ', LaTeXMode.mathmode: '\\eth'},
    241: {LaTeXMode.textmode: '\\~{n}', LaTeXMode.mathmode: '\\tilde{n}'},
    242: {LaTeXMode.textmode: '\\`{o}', LaTeXMode.mathmode: '\\grave{o}'},
    243: {LaTeXMode.textmode: "\\'{o}", LaTeXMode.mathmode: '\\acute{o}'},
    244: {LaTeXMode.textmode: '\\^{o}', LaTeXMode.mathmode: '\\hat{o}'},
    245: {LaTeXMode.textmode: '\\~{o}', LaTeXMode.mathmode: '\\tilde{o}'},
    246: {LaTeXMode.textmode: '\\"{o}', LaTeXMode.mathmode: '\\ddot{o}'},
    247: {LaTeXMode.textmode: '\\div ', LaTeXMode.mathmode: '\\div'},
    248: {LaTeXMode.textmode: '\\o ', LaTeXMode.mathmode: '\\o'},
    249: {LaTeXMode.textmode: '\\`{u}', LaTeXMode.mathmode: '\\grave{u}'},
    250: {LaTeXMode.textmode: "\\'{u}", LaTeXMode.mathmode: '\\acute{u}'},
    251: {LaTeXMode.textmode: '\\^{u}', LaTeXMode.mathmode: '\\hat{u}'},
    252: {LaTeXMode.textmode: '\\"{u}', LaTeXMode.mathmode: '\\ddot{u}'},
    253: {LaTeXMode.textmode: "\\'{y}", LaTeXMode.mathmode: '\\acute{y}'},
    254: {LaTeXMode.textmode: '\\th '},
    255: {LaTeXMode.textmode: '\\"{y}', LaTeXMode.mathmode: '\\ddot{y}'},
    256: {LaTeXMode.textmode: '\\={A}', LaTeXMode.mathmode: '\\bar{A}'},
    257: {LaTeXMode.textmode: '\\={a}', LaTeXMode.mathmode: '\\bar{a}'},
    258: {LaTeXMode.textmode: '\\u{A}', LaTeXMode.mathmode: '\\breve{A}'},
    259: {LaTeXMode.textmode: '\\u{a}', LaTeXMode.mathmode: '\\u{a}'},
    260: {LaTeXMode.textmode: '\\k{A}'},
    261: {LaTeXMode.textmode: '\\k{a}'},
    262: {LaTeXMode.textmode: "\\'{C}", LaTeXMode.mathmode: '\\acute{C}'},
    263: {LaTeXMode.textmode: "\\'{c}", LaTeXMode.mathmode: '\\acute{c}'},
    264: {LaTeXMode.textmode: '\\^{C}', LaTeXMode.mathmode: '\\hat{C}'},
    265: {LaTeXMode.textmode: '\\^{c}', LaTeXMode.mathmode: '\\hat{c}'},
    266: {LaTeXMode.textmode: '\\.{C}', LaTeXMode.mathmode: '\\dot{C}'},
    267: {LaTeXMode.textmode: '\\.{c}', LaTeXMode.mathmode: '\\dot{c}'},
    268: {LaTeXMode.textmode: '\\v{C}', LaTeXMode.mathmode: '\\check{C}'},
    269: {LaTeXMode.textmode: '\\v{c}', LaTeXMode.mathmode: '\\check{c}'},
    270: {LaTeXMode.textmode: '\\v{D}', LaTeXMode.mathmode: '\\check{D}'},
    271: {LaTeXMode.textmode: '\\v{d}', LaTeXMode.mathmode: '\\check{d}'},
    272: {LaTeXMode.textmode: '\\DJ '},
    273: {LaTeXMode.textmode: '\\dj '},
    274: {LaTeXMode.textmode: '\\={E}', LaTeXMode.mathmode: '\\bar{E}'},
    275: {LaTeXMode.textmode: '\\={e}', LaTeXMode.mathmode: '\\bar{e}'},
    276: {LaTeXMode.textmode: '\\u{E}', LaTeXMode.mathmode: '\\breve{E}'},
    277: {LaTeXMode.textmode: '\\u{e}', LaTeXMode.mathmode: '\\breve{e}'},
    278: {LaTeXMode.textmode: '\\.{E}', LaTeXMode.mathmode: '\\dot{E}'},
    279: {LaTeXMode.textmode: '\\.{e}', LaTeXMode.mathmode: '\\dot{e}'},
    280: {LaTeXMode.textmode: '\\k{E}', LaTeXMode.mathmode: '\\k{E}'},
    281: {LaTeXMode.textmode: '\\k{e}'},
    282: {LaTeXMode.textmode: '\\v{E}', LaTeXMode.mathmode: '\\check{E}'},
    283: {LaTeXMode.textmode: '\\v{e}', LaTeXMode.mathmode: '\\check{e}'},
    284: {LaTeXMode.textmode: '\\^{G}', LaTeXMode.mathmode: '\\hat{G}'},
    285: {LaTeXMode.textmode: '\\^{g}', LaTeXMode.mathmode: '\\hat{g}'},
    286: {LaTeXMode.textmode: '\\u{G}', LaTeXMode.mathmode: '\\breve{G}'},
    287: {LaTeXMode.textmode: '\\u{g}', LaTeXMode.mathmode: '\\breve{g}'},
    288: {LaTeXMode.textmode: '\\.{G}', LaTeXMode.mathmode: '\\dot{G}'},
    289: {LaTeXMode.textmode: '\\.{g}', LaTeXMode.mathmode: '\\dot{g}'},
    290: {LaTeXMode.textmode: '\\c{G}', LaTeXMode.mathmode: '\\mbox{\\c{G}}'},
    291: {LaTeXMode.textmode: '\\c{g}', LaTeXMode.mathmode: '\\mbox{\\c{g}}'},
    292: {LaTeXMode.textmode: '\\^{H}', LaTeXMode.mathmode: '\\hat{H}'},
    293: {LaTeXMode.textmode: '\\^{h}', LaTeXMode.mathmode: '\\hat{h}'},
    294: {LaTeXMode.textmode: '{\\fontencoding{LELA}\\selectfont\\char40}'},
    295: {LaTeXMode.textmode: '\\Elzxh '},
    296: {LaTeXMode.textmode: '\\~{I}', LaTeXMode.mathmode: '\\tilde{I}'},
    297: {LaTeXMode.textmode: '\\~{\\i}', LaTeXMode.mathmode: '\\tilde{\\imath}'},
    298: {LaTeXMode.textmode: '\\={I}', LaTeXMode.mathmode: '\\bar{I}'},
    299: {LaTeXMode.textmode: '\\={\\i}', LaTeXMode.mathmode: '\\bar{\\imath}'},
    300: {LaTeXMode.textmode: '\\u{I}', LaTeXMode.mathmode: '\\breve{I}'},
    301: {LaTeXMode.textmode: '\\u{\\i}', LaTeXMode.mathmode: '\\breve{\\imath}'},
    302: {LaTeXMode.textmode: '\\k{I}'},
    303: {LaTeXMode.textmode: '\\k{i}'},
    304: {LaTeXMode.textmode: '\\.{I}', LaTeXMode.mathmode: '\\dot{I}'},
    305: {LaTeXMode.textmode: '\\i ', LaTeXMode.mathmode: '\\imath'},
    306: {LaTeXMode.textmode: 'IJ'},
    307: {LaTeXMode.textmode: 'ij'},
    308: {LaTeXMode.textmode: '\\^{J}', LaTeXMode.mathmode: '\\hat{J}'},
    309: {LaTeXMode.textmode: '\\^{\\j}', LaTeXMode.mathmode: '\\hat{\\jmath}'},
    310: {LaTeXMode.textmode: '\\c{K}', LaTeXMode.mathmode: '\\mbox{\\c{K}}'},
    311: {LaTeXMode.textmode: '\\c{k}', LaTeXMode.mathmode: '\\mbox{\\c{k}}'},
    312: {LaTeXMode.textmode: '{\\fontencoding{LELA}\\selectfont\\char91}'},
    313: {LaTeXMode.textmode: "\\'{L}", LaTeXMode.mathmode: '\\acute{L}'},
    314: {LaTeXMode.textmode: "\\'{l}", LaTeXMode.mathmode: '\\acute{l}'},
    315: {LaTeXMode.textmode: '\\c{L}', LaTeXMode.mathmode: '\\mbox{\\c{L}}'},
    316: {LaTeXMode.textmode: '\\c{l}', LaTeXMode.mathmode: '\\mbox{\\c{l}}'},
    317: {LaTeXMode.textmode: '\\v{L}', LaTeXMode.mathmode: '\\check{L}'},
    318: {LaTeXMode.textmode: '\\v{l}', LaTeXMode.mathmode: '\\check{l}'},
    319: {LaTeXMode.textmode: '{\\fontencoding{LELA}\\selectfont\\char201}'},
    320: {LaTeXMode.textmode: '{\\fontencoding{LELA}\\selectfont\\char202}'},
    321: {LaTeXMode.textmode: '\\L ', LaTeXMode.mathmode: '\\L'},
    322: {LaTeXMode.textmode: '\\l ', LaTeXMode.mathmode: '\\l'},
    323: {LaTeXMode.textmode: "\\'{N}", LaTeXMode.mathmode: '\\acute{N}'},
    324: {LaTeXMode.textmode: "\\'{n}", LaTeXMode.mathmode: '\\acute{n}'},
    325: {LaTeXMode.textmode: '\\c{N}', LaTeXMode.mathmode: '\\mbox{\\c{N}}'},
    326: {LaTeXMode.textmode: '\\c{n}', LaTeXMode.mathmode: '\\mbox{\\c{n}}'},
    327: {LaTeXMode.textmode: '\\v{N}', LaTeXMode.mathmode: '\\check{N}'},
    328: {LaTeXMode.textmode: '\\v{n}', LaTeXMode.mathmode: '\\check{n}'},
    329: {LaTeXMode.textmode: "'n"},
    330: {LaTeXMode.textmode: '\\NG '},
    331: {LaTeXMode.textmode: '\\ng '},
    332: {LaTeXMode.textmode: '\\={O}', LaTeXMode.mathmode: '\\bar{O}'},
    333: {LaTeXMode.textmode: '\\={o}', LaTeXMode.mathmode: '\\bar{o}'},
    334: {LaTeXMode.textmode: '\\u{O}', LaTeXMode.mathmode: '\\breve{O}'},
    335: {LaTeXMode.textmode: '\\u{o}', LaTeXMode.mathmode: '\\breve{o}'},
    336: {LaTeXMode.textmode: '\\H{O}', LaTeXMode.mathmode: '\\mbox{\\H{O}}'},
    337: {LaTeXMode.textmode: '\\H{o}', LaTeXMode.mathmode: '\\mbox{\\H{o}}'},
    338: {LaTeXMode.textmode: '\\OE ', LaTeXMode.mathmode: '\\OE'},
    339: {LaTeXMode.textmode: '\\oe ', LaTeXMode.mathmode: '\\oe'},
    340: {LaTeXMode.textmode: "\\'{R}", LaTeXMode.mathmode: '\\acute{R}'},
    341: {LaTeXMode.textmode: "\\'{r}", LaTeXMode.mathmode: '\\acute{r}'},
    342: {LaTeXMode.textmode: '\\c{R}', LaTeXMode.mathmode: '\\mbox{\\c{R}}'},
    343: {LaTeXMode.textmode: '\\c{r}', LaTeXMode.mathmode: '\\mbox{\\c{r}}'},
    344: {LaTeXMode.textmode: '\\v{R}', LaTeXMode.mathmode: '\\check{R}'},
    345: {LaTeXMode.textmode: '\\v{r}', LaTeXMode.mathmode: '\\check{r}'},
    346: {LaTeXMode.textmode: "\\'{S}", LaTeXMode.mathmode: '\\acute{S}'},
    347: {LaTeXMode.textmode: "\\'{s}", LaTeXMode.mathmode: '\\acute{s}'},
    348: {LaTeXMode.textmode: '\\^{S}', LaTeXMode.mathmode: '\\hat{S}'},
    349: {LaTeXMode.textmode: '\\^{s}', LaTeXMode.mathmode: '\\hat{s}'},
    350: {LaTeXMode.textmode: '\\c{S}', LaTeXMode.mathmode: '\\mbox{\\c{S}}'},
    351: {LaTeXMode.textmode: '\\c{s}', LaTeXMode.mathmode: '\\mbox{\\c{s}}'},
    352: {LaTeXMode.textmode: '\\v{S}', LaTeXMode.mathmode: '\\check{S}'},
    353: {LaTeXMode.textmode: '\\v{s}', LaTeXMode.mathmode: '\\check{s}'},
    354: {LaTeXMode.textmode: '\\c{T}', LaTeXMode.mathmode: '\\mbox{\\c{T}}'},
    355: {LaTeXMode.textmode: '\\c{t}', LaTeXMode.mathmode: '\\mbox{\\c{t}}'},
    356: {LaTeXMode.textmode: '\\v{T}', LaTeXMode.mathmode: '\\check{T}'},
    357: {LaTeXMode.textmode: '\\v{t}', LaTeXMode.mathmode: '\\check{t}'},
    358: {LaTeXMode.textmode: '{\\fontencoding{LELA}\\selectfont\\char47}'},
    359: {LaTeXMode.textmode: '{\\fontencoding{LELA}\\selectfont\\char63}'},
    360: {LaTeXMode.textmode: '\\~{U}', LaTeXMode.mathmode: '\\tilde{U}'},
    361: {LaTeXMode.textmode: '\\~{u}', LaTeXMode.mathmode: '\\tilde{u}'},
    362: {LaTeXMode.textmode: '\\={U}', LaTeXMode.mathmode: '\\bar{U}'},
    363: {LaTeXMode.textmode: '\\={u}', LaTeXMode.mathmode: '\\bar{u}'},
    364: {LaTeXMode.textmode: '\\u{U}', LaTeXMode.mathmode: '\\breve{U}'},
    365: {LaTeXMode.textmode: '\\u{u}', LaTeXMode.mathmode: '\\breve{u}'},
    366: {LaTeXMode.textmode: '\\r{U}', LaTeXMode.mathmode: '\\mathring{U}'},
    367: {LaTeXMode.textmode: '\\r{u}', LaTeXMode.mathmode: '\\mathring{u}'},
    368: {LaTeXMode.textmode: '\\H{U}', LaTeXMode.mathmode: '\\mbox{\\H{U}}'},
    369: {LaTeXMode.textmode: '\\H{u}', LaTeXMode.mathmode: '\\mbox{\\H{u}}'},
    370: {LaTeXMode.textmode: '\\k{U}', LaTeXMode.mathmode: '\\k{U}'},
    371: {LaTeXMode.textmode: '\\k{u}'},
    372: {LaTeXMode.textmode: '\\^{W}', LaTeXMode.mathmode: '\\hat{W}'},
    373: {LaTeXMode.textmode: '\\^{w}', LaTeXMode.mathmode: '\\hat{w}'},
    374: {LaTeXMode.textmode: '\\^{Y}', LaTeXMode.mathmode: '\\hat{Y}'},
    375: {LaTeXMode.textmode: '\\^{y}', LaTeXMode.mathmode: '\\hat{y}'},
    376: {LaTeXMode.textmode: '\\"{Y}', LaTeXMode.mathmode: '\\ddot{Y}'},
    377: {LaTeXMode.textmode: "\\'{Z}", LaTeXMode.mathmode: '\\acute{Z}'},
    378: {LaTeXMode.textmode: "\\'{z}", LaTeXMode.mathmode: '\\acute{z}'},
    379: {LaTeXMode.textmode: '\\.{Z}', LaTeXMode.mathmode: '\\dot{Z}'},
    380: {LaTeXMode.textmode: '\\.{z}', LaTeXMode.mathmode: '\\dot{z}'},
    381: {LaTeXMode.textmode: '\\v{Z}', LaTeXMode.mathmode: '\\check{Z}'},
    382: {LaTeXMode.textmode: '\\v{z}', LaTeXMode.mathmode: '\\check{z}'},
    402: {LaTeXMode.textmode: 'f'},
    405: {LaTeXMode.textmode: '\\texthvlig '},
    414: {LaTeXMode.textmode: '\\textnrleg '},
    426: {LaTeXMode.textmode: '\\eth '},
    450: {LaTeXMode.textmode: '\\textdoublepipe '},
    501: {LaTeXMode.textmode: "\\'{g}", LaTeXMode.mathmode: '\\acute{g}'},
    592: {LaTeXMode.textmode: '\\Elztrna '},
    594: {LaTeXMode.textmode: '\\Elztrnsa '},
    596: {LaTeXMode.textmode: '\\Elzopeno '},
    598: {LaTeXMode.textmode: '\\Elzrtld '},
    601: {LaTeXMode.textmode: '\\Elzschwa '},
    603: {LaTeXMode.textmode: '\\varepsilon '},
    609: {LaTeXMode.textmode: 'g'},
    611: {LaTeXMode.textmode: '\\Elzpgamma '},
    612: {LaTeXMode.textmode: '\\Elzpbgam '},
    613: {LaTeXMode.textmode: '\\Elztrnh '},
    620: {LaTeXMode.textmode: '\\Elzbtdl '},
    621: {LaTeXMode.textmode: '\\Elzrtll '},
    623: {LaTeXMode.textmode: '\\Elztrnm '},
    624: {LaTeXMode.textmode: '\\Elztrnmlr '},
    625: {LaTeXMode.textmode: '\\Elzltlmr '},
    627: {LaTeXMode.textmode: '\\Elzrtln '},
    631: {LaTeXMode.textmode: '\\Elzclomeg '},
    632: {LaTeXMode.textmode: '\\textphi '},
    633: {LaTeXMode.textmode: '\\Elztrnr '},
    634: {LaTeXMode.textmode: '\\Elztrnrl '},
    635: {LaTeXMode.textmode: '\\Elzrttrnr '},
    636: {LaTeXMode.textmode: '\\Elzrl '},
    637: {LaTeXMode.textmode: '\\Elzrtlr '},
    638: {LaTeXMode.textmode: '\\Elzfhr '},
    642: {LaTeXMode.textmode: '\\Elzrtls '},
    643: {LaTeXMode.textmode: '\\Elzesh '},
    647: {LaTeXMode.textmode: '\\Elztrnt '},
    648: {LaTeXMode.textmode: '\\Elzrtlt '},
    650: {LaTeXMode.textmode: '\\Elzpupsil '},
    651: {LaTeXMode.textmode: '\\Elzpscrv '},
    652: {LaTeXMode.textmode: '\\Elzinvv '},
    653: {LaTeXMode.textmode: '\\Elzinvw '},
    654: {LaTeXMode.textmode: '\\Elztrny '},
    656: {LaTeXMode.textmode: '\\Elzrtlz '},
    658: {LaTeXMode.textmode: '\\Elzyogh '},
    660: {LaTeXMode.textmode: '\\Elzglst '},
    661: {LaTeXMode.textmode: '\\Elzreglst '},
    662: {LaTeXMode.textmode: '\\Elzinglst '},
    670: {LaTeXMode.textmode: '\\textturnk '},
    676: {LaTeXMode.textmode: '\\Elzdyogh '},
    679: {LaTeXMode.textmode: '\\Elztesh '},
    700: {LaTeXMode.textmode: "'", LaTeXMode.mathmode: '\\rasp'},
    711: {LaTeXMode.textmode: '\\textasciicaron '},
    712: {LaTeXMode.textmode: '\\Elzverts '},
    716: {LaTeXMode.textmode: '\\Elzverti '},
    720: {LaTeXMode.textmode: '\\Elzlmrk '},
    721: {LaTeXMode.textmode: '\\Elzhlmrk '},
    722: {LaTeXMode.textmode: '\\Elzsbrhr '},
    723: {LaTeXMode.textmode: '\\Elzsblhr '},
    724: {LaTeXMode.textmode: '\\Elzrais '},
    725: {LaTeXMode.textmode: '\\Elzlow '},
    728: {LaTeXMode.textmode: '\\textasciibreve ', LaTeXMode.mathmode: '\\u'},
    729: {LaTeXMode.textmode: '\\textperiodcentered ', LaTeXMode.mathmode: '\\dot{}'},
    730: {LaTeXMode.textmode: '\\r{}', LaTeXMode.mathmode: '\\mathring{}'},
    731: {LaTeXMode.textmode: '\\k{}', LaTeXMode.mathmode: '\\mbox{\\k{}}'},
    732: {LaTeXMode.textmode: '\\texttildelow '},
    733: {LaTeXMode.textmode: '\\H{}', LaTeXMode.mathmode: '\\mbox{\\H{}}'},
    741: {LaTeXMode.textmode: '\\tone{55}'},
    742: {LaTeXMode.textmode: '\\tone{44}'},
    743: {LaTeXMode.textmode: '\\tone{33}'},
    744: {LaTeXMode.textmode: '\\tone{22}'},
    745: {LaTeXMode.textmode: '\\tone{11}'},
    768: {LaTeXMode.textmode: '\\`', LaTeXMode.mathmode: '\\grave'},
    769: {LaTeXMode.textmode: "\\'", LaTeXMode.mathmode: '\\acute'},
    770: {LaTeXMode.textmode: '\\^', LaTeXMode.mathmode: '\\hat'},
    771: {LaTeXMode.textmode: '\\~', LaTeXMode.mathmode: '\\tilde'},
    772: {LaTeXMode.textmode: '\\=', LaTeXMode.mathmode: '\\bar'},
    774: {LaTeXMode.textmode: '\\u', LaTeXMode.mathmode: '\\breve'},
    775: {LaTeXMode.textmode: '\\.', LaTeXMode.mathmode: '\\dot'},
    776: {LaTeXMode.textmode: '\\"', LaTeXMode.mathmode: '\\ddot'},
    778: {LaTeXMode.textmode: '\\r', LaTeXMode.mathmode: '\\ocirc'},
    779: {LaTeXMode.textmode: '\\H', LaTeXMode.mathmode: '\\H'},
    780: {LaTeXMode.textmode: '\\v', LaTeXMode.mathmode: '\\check'},
    783: {LaTeXMode.textmode: '\\cyrchar\\C'},
    801: {LaTeXMode.textmode: '\\Elzpalh '},
    807: {LaTeXMode.textmode: '\\c', LaTeXMode.mathmode: '\\c'},
    810: {LaTeXMode.textmode: '\\Elzsbbrg '},
    824: {LaTeXMode.mathmode: '\\forks'},
    902: {LaTeXMode.textmode: "\\'{A}", LaTeXMode.mathmode: '\\acute{A}'},
    904: {LaTeXMode.textmode: "\\'{E}", LaTeXMode.mathmode: '\\acute{E}'},
    905: {LaTeXMode.textmode: "\\'{H}", LaTeXMode.mathmode: '\\grave{H}'},
    906: {LaTeXMode.textmode: "\\'{}{I}", LaTeXMode.mathmode: "\\mathrm{'I}"},
    908: {LaTeXMode.textmode: "\\'{}O", LaTeXMode.mathmode: "\\mathrm{'O}"},
    910: {LaTeXMode.textmode: "\\mathrm{'Y}"},
    911: {LaTeXMode.textmode: "\\mathrm{'\\Omega}"},
    912: {LaTeXMode.textmode: '\\acute{\\ddot{\\iota}}'},
    913: {LaTeXMode.textmode: '\\Alpha '},
    914: {LaTeXMode.textmode: '\\Beta '},
    915: {LaTeXMode.textmode: '\\Gamma ', LaTeXMode.mathmode: '\\Gamma'},
    916: {LaTeXMode.textmode: '\\Delta ', LaTeXMode.mathmode: '\\Delta'},
    917: {LaTeXMode.textmode: '\\Epsilon '},
    918: {LaTeXMode.textmode: '\\Zeta '},
    919: {LaTeXMode.textmode: '\\Eta '},
    920: {LaTeXMode.textmode: '\\Theta ', LaTeXMode.mathmode: '\\Theta'},
    921: {LaTeXMode.textmode: '\\Iota '},
    922: {LaTeXMode.textmode: '\\Kappa '},
    923: {LaTeXMode.textmode: '\\Lambda ', LaTeXMode.mathmode: '\\Lambda'},
    924: {LaTeXMode.textmode: 'M'},
    925: {LaTeXMode.textmode: 'N'},
    926: {LaTeXMode.textmode: '\\Xi ', LaTeXMode.mathmode: '\\Xi'},
    927: {LaTeXMode.textmode: 'O'},
    928: {LaTeXMode.textmode: '\\Pi ', LaTeXMode.mathmode: '\\Pi'},
    929: {LaTeXMode.textmode: '\\Rho '},
    931: {LaTeXMode.textmode: '\\Sigma ', LaTeXMode.mathmode: '\\Sigma'},
    932: {LaTeXMode.textmode: '\\Tau '},
    933: {LaTeXMode.textmode: '\\Upsilon '},
    934: {LaTeXMode.textmode: '\\Phi ', LaTeXMode.mathmode: '\\Phi'},
    935: {LaTeXMode.textmode: '\\Chi '},
    936: {LaTeXMode.textmode: '\\Psi ', LaTeXMode.mathmode: '\\Psi'},
    937: {LaTeXMode.textmode: '\\Omega ', LaTeXMode.mathmode: '\\Omega'},
    938: {LaTeXMode.textmode: '\\mathrm{\\ddot{I}}'},
    939: {LaTeXMode.textmode: '\\mathrm{\\ddot{Y}}'},
    940: {LaTeXMode.textmode: "\\'{$\\alpha$}", LaTeXMode.mathmode: '\\acute{\\alpha}'},
    941: {LaTeXMode.textmode: '\\acute{\\epsilon}'},
    942: {LaTeXMode.textmode: '\\acute{\\eta}'},
    943: {LaTeXMode.textmode: '\\acute{\\iota}'},
    944: {LaTeXMode.textmode: '\\acute{\\ddot{\\upsilon}}'},
    945: {LaTeXMode.textmode: '\\alpha ', LaTeXMode.mathmode: '\\alpha'},
    946: {LaTeXMode.textmode: '\\beta ', LaTeXMode.mathmode: '\\beta'},
    947: {LaTeXMode.textmode: '\\gamma ', LaTeXMode.mathmode: '\\gamma'},
    948: {LaTeXMode.textmode: '\\delta ', LaTeXMode.mathmode: '\\delta'},
    949: {LaTeXMode.textmode: '\\epsilon ', LaTeXMode.mathmode: '\\varepsilon'},
    950: {LaTeXMode.textmode: '\\zeta ', LaTeXMode.mathmode: '\\zeta'},
    951: {LaTeXMode.textmode: '\\eta ', LaTeXMode.mathmode: '\\eta'},
    952: {LaTeXMode.textmode: '\\texttheta ', LaTeXMode.mathmode: '\\theta'},
    953: {LaTeXMode.textmode: '\\iota ', LaTeXMode.mathmode: '\\iota'},
    954: {LaTeXMode.textmode: '\\kappa ', LaTeXMode.mathmode: '\\kappa'},
    955: {LaTeXMode.textmode: '\\lambda ', LaTeXMode.mathmode: '\\lambda'},
    956: {LaTeXMode.textmode: '\\mu ', LaTeXMode.mathmode: '\\mu'},
    957: {LaTeXMode.textmode: '\\nu ', LaTeXMode.mathmode: '\\nu'},
    958: {LaTeXMode.textmode: '\\xi ', LaTeXMode.mathmode: '\\xi'},
    959: {LaTeXMode.textmode: 'o'},
    960: {LaTeXMode.textmode: '\\pi ', LaTeXMode.mathmode: '\\pi'},
    961: {LaTeXMode.textmode: '\\rho ', LaTeXMode.mathmode: '\\rho'},
    962: {LaTeXMode.textmode: '\\varsigma ', LaTeXMode.mathmode: '\\varsigma'},
    963: {LaTeXMode.textmode: '\\sigma ', LaTeXMode.mathmode: '\\sigma'},
    964: {LaTeXMode.textmode: '\\tau ', LaTeXMode.mathmode: '\\tau'},
    965: {LaTeXMode.textmode: '\\upsilon ', LaTeXMode.mathmode: '\\upsilon'},
    966: {LaTeXMode.textmode: '\\varphi ', LaTeXMode.mathmode: '\\varphi'},
    967: {LaTeXMode.textmode: '\\chi ', LaTeXMode.mathmode: '\\chi'},
    968: {LaTeXMode.textmode: '\\psi ', LaTeXMode.mathmode: '\\psi'},
    969: {LaTeXMode.textmode: '\\omega ', LaTeXMode.mathmode: '\\omega'},
    970: {LaTeXMode.textmode: '\\ddot{\\iota}'},
    971: {LaTeXMode.textmode: '\\ddot{\\upsilon}'},
    972: {LaTeXMode.textmode: "\\'{o}", LaTeXMode.mathmode: '\\acute{o}'},
    973: {LaTeXMode.textmode: '\\acute{\\upsilon}'},
    974: {LaTeXMode.textmode: '\\acute{\\omega}'},
    977: {LaTeXMode.textmode: '\\textvartheta ', LaTeXMode.mathmode: '\\vartheta '},
    978: {LaTeXMode.textmode: '\\Upsilon ', LaTeXMode.mathmode: '\\Upsilon'},
    981: {LaTeXMode.textmode: '\\phi ', LaTeXMode.mathmode: '\\phi'},
    982: {LaTeXMode.textmode: '\\varpi ', LaTeXMode.mathmode: '\\varpi'},
    986: {LaTeXMode.textmode: '\\Stigma '},
    988: {LaTeXMode.textmode: '\\Digamma '},
    989: {LaTeXMode.textmode: '\\digamma ', LaTeXMode.mathmode: '\\digamma'},
    990: {LaTeXMode.textmode: '\\Koppa '},
    992: {LaTeXMode.textmode: '\\Sampi '},
    1008: {LaTeXMode.textmode: '\\varkappa ', LaTeXMode.mathmode: '\\varkappa'},
    1009: {LaTeXMode.textmode: '\\varrho ', LaTeXMode.mathmode: '\\varrho'},
    1014: {LaTeXMode.textmode: '\\backepsilon ', LaTeXMode.mathmode: '\\backepsilon'},
    1025: {LaTeXMode.textmode: '\\cyrchar\\CYRYO '},
    1026: {LaTeXMode.textmode: '\\cyrchar\\CYRDJE '},
    1027: {LaTeXMode.textmode: "\\cyrchar{\\'\\CYRG}"},
    1028: {LaTeXMode.textmode: '\\cyrchar\\CYRIE '},
    1029: {LaTeXMode.textmode: '\\cyrchar\\CYRDZE '},
    1030: {LaTeXMode.textmode: '\\cyrchar\\CYRII '},
    1031: {LaTeXMode.textmode: '\\cyrchar\\CYRYI '},
    1032: {LaTeXMode.textmode: '\\cyrchar\\CYRJE '},
    1033: {LaTeXMode.textmode: '\\cyrchar\\CYRLJE '},
    1034: {LaTeXMode.textmode: '\\cyrchar\\CYRNJE '},
    1035: {LaTeXMode.textmode: '\\cyrchar\\CYRTSHE '},
    1036: {LaTeXMode.textmode: "\\cyrchar{\\'\\CYRK}"},
    1038: {LaTeXMode.textmode: '\\cyrchar\\CYRUSHRT '},
    1039: {LaTeXMode.textmode: '\\cyrchar\\CYRDZHE '},
    1040: {LaTeXMode.textmode: '\\cyrchar\\CYRA '},
    1041: {LaTeXMode.textmode: '\\cyrchar\\CYRB '},
    1042: {LaTeXMode.textmode: '\\cyrchar\\CYRV '},
    1043: {LaTeXMode.textmode: '\\cyrchar\\CYRG '},
    1044: {LaTeXMode.textmode: '\\cyrchar\\CYRD '},
    1045: {LaTeXMode.textmode: '\\cyrchar\\CYRE '},
    1046: {LaTeXMode.textmode: '\\cyrchar\\CYRZH '},
    1047: {LaTeXMode.textmode: '\\cyrchar\\CYRZ '},
    1048: {LaTeXMode.textmode: '\\cyrchar\\CYRI '},
    1049: {LaTeXMode.textmode: '\\cyrchar\\CYRISHRT '},
    1050: {LaTeXMode.textmode: '\\cyrchar\\CYRK '},
    1051: {LaTeXMode.textmode: '\\cyrchar\\CYRL '},
    1052: {LaTeXMode.textmode: '\\cyrchar\\CYRM '},
    1053: {LaTeXMode.textmode: '\\cyrchar\\CYRN '},
    1054: {LaTeXMode.textmode: '\\cyrchar\\CYRO '},
    1055: {LaTeXMode.textmode: '\\cyrchar\\CYRP '},
    1056: {LaTeXMode.textmode: '\\cyrchar\\CYRR '},
    1057: {LaTeXMode.textmode: '\\cyrchar\\CYRS '},
    1058: {LaTeXMode.textmode: '\\cyrchar\\CYRT '},
    1059: {LaTeXMode.textmode: '\\cyrchar\\CYRU '},
    1060: {LaTeXMode.textmode: '\\cyrchar\\CYRF '},
    1061: {LaTeXMode.textmode: '\\cyrchar\\CYRH '},
    1062: {LaTeXMode.textmode: '\\cyrchar\\CYRC '},
    1063: {LaTeXMode.textmode: '\\cyrchar\\CYRCH '},
    1064: {LaTeXMode.textmode: '\\cyrchar\\CYRSH '},
    1065: {LaTeXMode.textmode: '\\cyrchar\\CYRSHCH '},
    1066: {LaTeXMode.textmode: '\\cyrchar\\CYRHRDSN '},
    1067: {LaTeXMode.textmode: '\\cyrchar\\CYRERY '},
    1068: {LaTeXMode.textmode: '\\cyrchar\\CYRSFTSN '},
    1069: {LaTeXMode.textmode: '\\cyrchar\\CYREREV '},
    1070: {LaTeXMode.textmode: '\\cyrchar\\CYRYU '},
    1071: {LaTeXMode.textmode: '\\cyrchar\\CYRYA '},
    1072: {LaTeXMode.textmode: '\\cyrchar\\cyra '},
    1073: {LaTeXMode.textmode: '\\cyrchar\\cyrb '},
    1074: {LaTeXMode.textmode: '\\cyrchar\\cyrv '},
    1075: {LaTeXMode.textmode: '\\cyrchar\\cyrg '},
    1076: {LaTeXMode.textmode: '\\cyrchar\\cyrd '},
    1077: {LaTeXMode.textmode: '\\cyrchar\\cyre '},
    1078: {LaTeXMode.textmode: '\\cyrchar\\cyrzh '},
    1079: {LaTeXMode.textmode: '\\cyrchar\\cyrz '},
    1080: {LaTeXMode.textmode: '\\cyrchar\\cyri '},
    1081: {LaTeXMode.textmode: '\\cyrchar\\cyrishrt '},
    1082: {LaTeXMode.textmode: '\\cyrchar\\cyrk '},
    1083: {LaTeXMode.textmode: '\\cyrchar\\cyrl '},
    1084: {LaTeXMode.textmode: '\\cyrchar\\cyrm '},
    1085: {LaTeXMode.textmode: '\\cyrchar\\cyrn '},
    1086: {LaTeXMode.textmode: '\\cyrchar\\cyro '},
    1087: {LaTeXMode.textmode: '\\cyrchar\\cyrp '},
    1088: {LaTeXMode.textmode: '\\cyrchar\\cyrr '},
    1089: {LaTeXMode.textmode: '\\cyrchar\\cyrs '},
    1090: {LaTeXMode.textmode: '\\cyrchar\\cyrt '},
    1091: {LaTeXMode.textmode: '\\cyrchar\\cyru '},
    1092: {LaTeXMode.textmode: '\\cyrchar\\cyrf '},
    1093: {LaTeXMode.textmode: '\\cyrchar\\cyrh '},
    1094: {LaTeXMode.textmode: '\\cyrchar\\cyrc '},
    1095: {LaTeXMode.textmode: '\\cyrchar\\cyrch '},
    1096: {LaTeXMode.textmode: '\\cyrchar\\cyrsh '},
    1097: {LaTeXMode.textmode: '\\cyrchar\\cyrshch '},
    1098: {LaTeXMode.textmode: '\\cyrchar\\cyrhrdsn '},
    1099: {LaTeXMode.textmode: '\\cyrchar\\cyrery '},
    1100: {LaTeXMode.textmode: '\\cyrchar\\cyrsftsn '},
    1101: {LaTeXMode.textmode: '\\cyrchar\\cyrerev '},
    1102: {LaTeXMode.textmode: '\\cyrchar\\cyryu '},
    1103: {LaTeXMode.textmode: '\\cyrchar\\cyrya '},
    1105: {LaTeXMode.textmode: '\\cyrchar\\cyryo '},
    1106: {LaTeXMode.textmode: '\\cyrchar\\cyrdje '},
    1107: {LaTeXMode.textmode: "\\cyrchar{\\'\\cyrg}"},
    1108: {LaTeXMode.textmode: '\\cyrchar\\cyrie '},
    1109: {LaTeXMode.textmode: '\\cyrchar\\cyrdze '},
    1110: {LaTeXMode.textmode: '\\cyrchar\\cyrii '},
    1111: {LaTeXMode.textmode: '\\cyrchar\\cyryi '},
    1112: {LaTeXMode.textmode: '\\cyrchar\\cyrje '},
    1113: {LaTeXMode.textmode: '\\cyrchar\\cyrlje '},
    1114: {LaTeXMode.textmode: '\\cyrchar\\cyrnje '},
    1115: {LaTeXMode.textmode: '\\cyrchar\\cyrtshe '},
    1116: {LaTeXMode.textmode: "\\cyrchar{\\'\\cyrk}"},
    1118: {LaTeXMode.textmode: '\\cyrchar\\cyrushrt '},
    1119: {LaTeXMode.textmode: '\\cyrchar\\cyrdzhe '},
    1120: {LaTeXMode.textmode: '\\cyrchar\\CYROMEGA '},
    1121: {LaTeXMode.textmode: '\\cyrchar\\cyromega '},
    1122: {LaTeXMode.textmode: '\\cyrchar\\CYRYAT '},
    1124: {LaTeXMode.textmode: '\\cyrchar\\CYRIOTE '},
    1125: {LaTeXMode.textmode: '\\cyrchar\\cyriote '},
    1126: {LaTeXMode.textmode: '\\cyrchar\\CYRLYUS '},
    1127: {LaTeXMode.textmode: '\\cyrchar\\cyrlyus '},
    1128: {LaTeXMode.textmode: '\\cyrchar\\CYRIOTLYUS '},
    1129: {LaTeXMode.textmode: '\\cyrchar\\cyriotlyus '},
    1130: {LaTeXMode.textmode: '\\cyrchar\\CYRBYUS '},
    1132: {LaTeXMode.textmode: '\\cyrchar\\CYRIOTBYUS '},
    1133: {LaTeXMode.textmode: '\\cyrchar\\cyriotbyus '},
    1134: {LaTeXMode.textmode: '\\cyrchar\\CYRKSI '},
    1135: {LaTeXMode.textmode: '\\cyrchar\\cyrksi '},
    1136: {LaTeXMode.textmode: '\\cyrchar\\CYRPSI '},
    1137: {LaTeXMode.textmode: '\\cyrchar\\cyrpsi '},
    1138: {LaTeXMode.textmode: '\\cyrchar\\CYRFITA '},
    1140: {LaTeXMode.textmode: '\\cyrchar\\CYRIZH '},
    1144: {LaTeXMode.textmode: '\\cyrchar\\CYRUK '},
    1145: {LaTeXMode.textmode: '\\cyrchar\\cyruk '},
    1146: {LaTeXMode.textmode: '\\cyrchar\\CYROMEGARND '},
    1147: {LaTeXMode.textmode: '\\cyrchar\\cyromegarnd '},
    1148: {LaTeXMode.textmode: '\\cyrchar\\CYROMEGATITLO '},
    1149: {LaTeXMode.textmode: '\\cyrchar\\cyromegatitlo '},
    1150: {LaTeXMode.textmode: '\\cyrchar\\CYROT '},
    1151: {LaTeXMode.textmode: '\\cyrchar\\cyrot '},
    1152: {LaTeXMode.textmode: '\\cyrchar\\CYRKOPPA '},
    1153: {LaTeXMode.textmode: '\\cyrchar\\cyrkoppa '},
    1154: {LaTeXMode.textmode: '\\cyrchar\\cyrthousands '},
    1160: {LaTeXMode.textmode: '\\cyrchar\\cyrhundredthousands '},
    1161: {LaTeXMode.textmode: '\\cyrchar\\cyrmillions '},
    1164: {LaTeXMode.textmode: '\\cyrchar\\CYRSEMISFTSN '},
    1165: {LaTeXMode.textmode: '\\cyrchar\\cyrsemisftsn '},
    1166: {LaTeXMode.textmode: '\\cyrchar\\CYRRTICK '},
    1167: {LaTeXMode.textmode: '\\cyrchar\\cyrrtick '},
    1168: {LaTeXMode.textmode: '\\cyrchar\\CYRGUP '},
    1169: {LaTeXMode.textmode: '\\cyrchar\\cyrgup '},
    1170: {LaTeXMode.textmode: '\\cyrchar\\CYRGHCRS '},
    1171: {LaTeXMode.textmode: '\\cyrchar\\cyrghcrs '},
    1172: {LaTeXMode.textmode: '\\cyrchar\\CYRGHK '},
    1173: {LaTeXMode.textmode: '\\cyrchar\\cyrghk '},
    1174: {LaTeXMode.textmode: '\\cyrchar\\CYRZHDSC '},
    1175: {LaTeXMode.textmode: '\\cyrchar\\cyrzhdsc '},
    1176: {LaTeXMode.textmode: '\\cyrchar\\CYRZDSC '},
    1177: {LaTeXMode.textmode: '\\cyrchar\\cyrzdsc '},
    1178: {LaTeXMode.textmode: '\\cyrchar\\CYRKDSC '},
    1179: {LaTeXMode.textmode: '\\cyrchar\\cyrkdsc '},
    1180: {LaTeXMode.textmode: '\\cyrchar\\CYRKVCRS '},
    1181: {LaTeXMode.textmode: '\\cyrchar\\cyrkvcrs '},
    1182: {LaTeXMode.textmode: '\\cyrchar\\CYRKHCRS '},
    1183: {LaTeXMode.textmode: '\\cyrchar\\cyrkhcrs '},
    1184: {LaTeXMode.textmode: '\\cyrchar\\CYRKBEAK '},
    1185: {LaTeXMode.textmode: '\\cyrchar\\cyrkbeak '},
    1186: {LaTeXMode.textmode: '\\cyrchar\\CYRNDSC '},
    1187: {LaTeXMode.textmode: '\\cyrchar\\cyrndsc '},
    1188: {LaTeXMode.textmode: '\\cyrchar\\CYRNG '},
    1189: {LaTeXMode.textmode: '\\cyrchar\\cyrng '},
    1190: {LaTeXMode.textmode: '\\cyrchar\\CYRPHK '},
    1191: {LaTeXMode.textmode: '\\cyrchar\\cyrphk '},
    1192: {LaTeXMode.textmode: '\\cyrchar\\CYRABHHA '},
    1193: {LaTeXMode.textmode: '\\cyrchar\\cyrabhha '},
    1194: {LaTeXMode.textmode: '\\cyrchar\\CYRSDSC '},
    1195: {LaTeXMode.textmode: '\\cyrchar\\cyrsdsc '},
    1196: {LaTeXMode.textmode: '\\cyrchar\\CYRTDSC '},
    1197: {LaTeXMode.textmode: '\\cyrchar\\cyrtdsc '},
    1198: {LaTeXMode.textmode: '\\cyrchar\\CYRY '},
    1199: {LaTeXMode.textmode: '\\cyrchar\\cyry '},
    1200: {LaTeXMode.textmode: '\\cyrchar\\CYRYHCRS '},
    1201: {LaTeXMode.textmode: '\\cyrchar\\cyryhcrs '},
    1202: {LaTeXMode.textmode: '\\cyrchar\\CYRHDSC '},
    1203: {LaTeXMode.textmode: '\\cyrchar\\cyrhdsc '},
    1204: {LaTeXMode.textmode: '\\cyrchar\\CYRTETSE '},
    1205: {LaTeXMode.textmode: '\\cyrchar\\cyrtetse '},
    1206: {LaTeXMode.textmode: '\\cyrchar\\CYRCHRDSC '},
    1207: {LaTeXMode.textmode: '\\cyrchar\\cyrchrdsc '},
    1208: {LaTeXMode.textmode: '\\cyrchar\\CYRCHVCRS '},
    1209: {LaTeXMode.textmode: '\\cyrchar\\cyrchvcrs '},
    1210: {LaTeXMode.textmode: '\\cyrchar\\CYRSHHA '},
    1211: {LaTeXMode.textmode: '\\cyrchar\\cyrshha '},
    1212: {LaTeXMode.textmode: '\\cyrchar\\CYRABHCH '},
    1213: {LaTeXMode.textmode: '\\cyrchar\\cyrabhch '},
    1214: {LaTeXMode.textmode: '\\cyrchar\\CYRABHCHDSC '},
    1215: {LaTeXMode.textmode: '\\cyrchar\\cyrabhchdsc '},
    1216: {LaTeXMode.textmode: '\\cyrchar\\CYRpalochka '},
    1219: {LaTeXMode.textmode: '\\cyrchar\\CYRKHK '},
    1220: {LaTeXMode.textmode: '\\cyrchar\\cyrkhk '},
    1223: {LaTeXMode.textmode: '\\cyrchar\\CYRNHK '},
    1224: {LaTeXMode.textmode: '\\cyrchar\\cyrnhk '},
    1227: {LaTeXMode.textmode: '\\cyrchar\\CYRCHLDSC '},
    1228: {LaTeXMode.textmode: '\\cyrchar\\cyrchldsc '},
    1236: {LaTeXMode.textmode: '\\cyrchar\\CYRAE '},
    1237: {LaTeXMode.textmode: '\\cyrchar\\cyrae '},
    1240: {LaTeXMode.textmode: '\\cyrchar\\CYRSCHWA '},
    1241: {LaTeXMode.textmode: '\\cyrchar\\cyrschwa '},
    1248: {LaTeXMode.textmode: '\\cyrchar\\CYRABHDZE '},
    1249: {LaTeXMode.textmode: '\\cyrchar\\cyrabhdze '},
    1256: {LaTeXMode.textmode: '\\cyrchar\\CYROTLD '},
    1257: {LaTeXMode.textmode: '\\cyrchar\\cyrotld '},
    8194: {LaTeXMode.textmode: '\\hspace{0.6em}', LaTeXMode.mathmode: '\\enspace'},
    8195: {LaTeXMode.textmode: '\\hspace{1em}', LaTeXMode.mathmode: '\\quad'},
    8196: {LaTeXMode.textmode: '\\hspace{0.33em}'},
    8197: {LaTeXMode.textmode: '\\hspace{0.25em}', LaTeXMode.mathmode: '\\thickspace'},
    8198: {LaTeXMode.textmode: '\\hspace{0.166em}'},
    8199: {LaTeXMode.textmode: '\\hphantom{0}'},
    8200: {LaTeXMode.textmode: '\\hphantom{,}'},
    8201: {LaTeXMode.textmode: '\\hspace{0.167em}', LaTeXMode.mathmode: '\\thinspace'},
    8202: {LaTeXMode.textmode: '\\mkern1mu ', LaTeXMode.mathmode: '\\hspace'},
    8208: {LaTeXMode.textmode: '-'},
    8211: {LaTeXMode.textmode: '\\textendash ', LaTeXMode.mathmode: '\\mathrm{\\textendash}'},
    8212: {LaTeXMode.textmode: '\\textemdash ', LaTeXMode.mathmode: '\\emdash'},
    8213: {LaTeXMode.textmode: '\\rule{1em}{1pt}'},
    8214: {LaTeXMode.textmode: '\\Vert ', LaTeXMode.mathmode: '\\Vert'},
    8216: {LaTeXMode.textmode: '`', LaTeXMode.mathmode: '\\lq'},
    8217: {LaTeXMode.textmode: "'", LaTeXMode.mathmode: '\\rq'},
    8218: {LaTeXMode.textmode: ','},
    8219: {LaTeXMode.textmode: '\\Elzreapos '},
    8220: {LaTeXMode.textmode: '\\textquotedblleft ', LaTeXMode.mathmode: '\\textquotedblleft'},
    8221: {LaTeXMode.textmode: '\\textquotedblright ', LaTeXMode.mathmode: '\\textquotedblright'},
    8222: {LaTeXMode.textmode: ',,'},
    8224: {LaTeXMode.textmode: '\\textdagger ', LaTeXMode.mathmode: '\\dagger'},
    8225: {LaTeXMode.textmode: '\\textdaggerdbl ', LaTeXMode.mathmode: '\\ddagger'},
    8226: {LaTeXMode.textmode: '\\textbullet ', LaTeXMode.mathmode: '\\bullet'},
    8228: {LaTeXMode.textmode: '.'},
    8229: {LaTeXMode.textmode: '..'},
    8230: {LaTeXMode.textmode: '\\ldots ', LaTeXMode.mathmode: '\\dots'},
    8240: {LaTeXMode.textmode: '\\textperthousand '},
    8241: {LaTeXMode.textmode: '\\textpertenthousand '},
    8242: {LaTeXMode.textmode: "{'}", LaTeXMode.mathmode: '\\prime'},
    8243: {LaTeXMode.textmode: "{''}"},
    8244: {LaTeXMode.textmode: "{'''}"},
    8245: {LaTeXMode.textmode: '\\backprime ', LaTeXMode.mathmode: '\\backprime'},
    8279: {LaTeXMode.textmode: "''''"},
    8411: {LaTeXMode.textmode: '\\dddot ', LaTeXMode.mathmode: '\\dddot'},
    8412: {LaTeXMode.textmode: '\\ddddot ', LaTeXMode.mathmode: '\\ddddot'},
    8421: {LaTeXMode.textmode: '{\\rlap{\\textbackslash}{{/}\\!\\!{/}}}'},
    8450: {LaTeXMode.textmode: '\\mathbb{C}'},
    8459: {LaTeXMode.textmode: '\\mathscr{H}'},
    8460: {LaTeXMode.textmode: '\\mathfrak{H}'},
    8461: {LaTeXMode.textmode: '\\mathbb{H}'},
    8463: {LaTeXMode.textmode: '\\hslash ', LaTeXMode.mathmode: '\\hslash'},
    8464: {LaTeXMode.textmode: '\\mathscr{I}'},
    8465: {LaTeXMode.textmode: '\\mathfrak{I}', LaTeXMode.mathmode: '\\Im'},
    8466: {LaTeXMode.textmode: '\\mathscr{L}'},
    8467: {LaTeXMode.textmode: '\\mathscr{l}', LaTeXMode.mathmode: '\\ell'},
    8469: {LaTeXMode.textmode: '\\mathbb{N}'},
    8470: {LaTeXMode.textmode: '\\cyrchar\\textnumero ', LaTeXMode.mathmode: '\\textnumero'},
    8472: {LaTeXMode.textmode: '\\wp ', LaTeXMode.mathmode: '\\wp'},
    8473: {LaTeXMode.textmode: '\\mathbb{P}'},
    8474: {LaTeXMode.textmode: '\\mathbb{Q}'},
    8475: {LaTeXMode.textmode: '\\mathscr{R}'},
    8476: {LaTeXMode.textmode: '\\mathfrak{R}', LaTeXMode.mathmode: '\\Re'},
    8477: {LaTeXMode.textmode: '\\mathbb{R}'},
    8478: {LaTeXMode.textmode: '\\Elzxrat '},
    8482: {LaTeXMode.textmode: '\\texttrademark '},
    8484: {LaTeXMode.textmode: '\\mathbb{Z}'},
    8486: {LaTeXMode.textmode: '\\Omega '},
    8487: {LaTeXMode.textmode: '\\mho ', LaTeXMode.mathmode: '\\mho'},
    8488: {LaTeXMode.textmode: '\\mathfrak{Z}'},
    8489: {LaTeXMode.textmode: '\\ElsevierGlyph{2129}'},
    8491: {LaTeXMode.textmode: '\\AA ', LaTeXMode.mathmode: '\\AA'},
    8492: {LaTeXMode.textmode: '\\mathscr{B}'},
    8493: {LaTeXMode.textmode: '\\mathfrak{C}'},
    8495: {LaTeXMode.textmode: '\\mathscr{e}'},
    8496: {LaTeXMode.textmode: '\\mathscr{E}'},
    8497: {LaTeXMode.textmode: '\\mathscr{F}'},
    8499: {LaTeXMode.textmode: '\\mathscr{M}'},
    8500: {LaTeXMode.textmode: '\\mathscr{o}'},
    8501: {LaTeXMode.textmode: '\\aleph ', LaTeXMode.mathmode: '\\aleph'},
    8502: {LaTeXMode.textmode: '\\beth ', LaTeXMode.mathmode: '\\beth'},
    8503: {LaTeXMode.textmode: '\\gimel ', LaTeXMode.mathmode: '\\gimel'},
    8504: {LaTeXMode.textmode: '\\daleth ', LaTeXMode.mathmode: '\\daleth'},
    8512: {LaTeXMode.mathmode: '\\bbsum'},
    8531: {LaTeXMode.textmode: '\\textfrac{1}{3}'},
    8532: {LaTeXMode.textmode: '\\textfrac{2}{3}'},
    8533: {LaTeXMode.textmode: '\\textfrac{1}{5}'},
    8534: {LaTeXMode.textmode: '\\textfrac{2}{5}'},
    8535: {LaTeXMode.textmode: '\\textfrac{3}{5}'},
    8536: {LaTeXMode.textmode: '\\textfrac{4}{5}'},
    8537: {LaTeXMode.textmode: '\\textfrac{1}{6}'},
    8538: {LaTeXMode.textmode: '\\textfrac{5}{6}'},
    8539: {LaTeXMode.textmode: '\\textfrac{1}{8}'},
    8540: {LaTeXMode.textmode: '\\textfrac{3}{8}'},
    8541: {LaTeXMode.textmode: '\\textfrac{5}{8}'},
    8542: {LaTeXMode.textmode: '\\textfrac{7}{8}'},
    8592: {LaTeXMode.textmode: '\\leftarrow ', LaTeXMode.mathmode: '\\leftarrow'},
    8593: {LaTeXMode.textmode: '\\uparrow ', LaTeXMode.mathmode: '\\uparrow'},
    8594: {LaTeXMode.textmode: '\\rightarrow ', LaTeXMode.mathmode: '\\rightarrow'},
    8595: {LaTeXMode.textmode: '\\downarrow ', LaTeXMode.mathmode: '\\downarrow'},
    8596: {LaTeXMode.textmode: '\\leftrightarrow ', LaTeXMode.mathmode: '\\leftrightarrow'},
    8597: {LaTeXMode.textmode: '\\updownarrow ', LaTeXMode.mathmode: '\\updownarrow'},
    8598: {LaTeXMode.textmode: '\\nwarrow ', LaTeXMode.mathmode: '\\nwarrow'},
    8599: {LaTeXMode.textmode: '\\nearrow ', LaTeXMode.mathmode: '\\nearrow'},
    8600: {LaTeXMode.textmode: '\\searrow ', LaTeXMode.mathmode: '\\searrow'},
    8601: {LaTeXMode.textmode: '\\swarrow ', LaTeXMode.mathmode: '\\swarrow'},
    8602: {LaTeXMode.textmode: '\\nleftarrow ', LaTeXMode.mathmode: '\\nleftarrow'},
    8603: {LaTeXMode.textmode: '\\nrightarrow ', LaTeXMode.mathmode: '\\nrightarrow'},
    8604: {LaTeXMode.textmode: '\\arrowwaveleft ', LaTeXMode.mathmode: '\\leftsquigarrow'},
    8605: {LaTeXMode.textmode: '\\arrowwaveright ', LaTeXMode.mathmode: '\\rightsquigarrow'},
    8606: {LaTeXMode.textmode: '\\twoheadleftarrow ', LaTeXMode.mathmode: '\\twoheadleftarrow'},
    8608: {LaTeXMode.textmode: '\\twoheadrightarrow ', LaTeXMode.mathmode: '\\twoheadrightarrow'},
    8610: {LaTeXMode.textmode: '\\leftarrowtail ', LaTeXMode.mathmode: '\\leftarrowtail'},
    8611: {LaTeXMode.textmode: '\\rightarrowtail ', LaTeXMode.mathmode: '\\rightarrowtail'},
    8614: {LaTeXMode.textmode: '\\mapsto ', LaTeXMode.mathmode: '\\mapsto'},
    8617: {LaTeXMode.textmode: '\\hookleftarrow ', LaTeXMode.mathmode: '\\hookleftarrow'},
    8618: {LaTeXMode.textmode: '\\hookrightarrow ', LaTeXMode.mathmode: '\\hookrightarrow'},
    8619: {LaTeXMode.textmode: '\\looparrowleft ', LaTeXMode.mathmode: '\\looparrowleft'},
    8620: {LaTeXMode.textmode: '\\looparrowright ', LaTeXMode.mathmode: '\\looparrowright'},
    8621: {LaTeXMode.textmode: '\\leftrightsquigarrow ', LaTeXMode.mathmode: '\\leftrightsquigarrow'},
    8622: {LaTeXMode.textmode: '\\nleftrightarrow ', LaTeXMode.mathmode: '\\nleftrightarrow'},
    8624: {LaTeXMode.textmode: '\\Lsh ', LaTeXMode.mathmode: '\\Lsh'},
    8625: {LaTeXMode.textmode: '\\Rsh ', LaTeXMode.mathmode: '\\Rsh'},
    8627: {LaTeXMode.textmode: '\\ElsevierGlyph{21B3}'},
    8630: {LaTeXMode.textmode: '\\curvearrowleft ', LaTeXMode.mathmode: '\\curvearrowleft'},
    8631: {LaTeXMode.textmode: '\\curvearrowright ', LaTeXMode.mathmode: '\\curvearrowright'},
    8634: {LaTeXMode.textmode: '\\circlearrowleft '},
    8635: {LaTeXMode.textmode: '\\circlearrowright '},
    8636: {LaTeXMode.textmode: '\\leftharpoonup ', LaTeXMode.mathmode: '\\leftharpoonup'},
    8637: {LaTeXMode.textmode: '\\leftharpoondown ', LaTeXMode.mathmode: '\\leftharpoondown'},
    8638: {LaTeXMode.textmode: '\\upharpoonright ', LaTeXMode.mathmode: '\\upharpoonleft'},
    8639: {LaTeXMode.textmode: '\\upharpoonleft ', LaTeXMode.mathmode: '\\upharpoonright'},
    8640: {LaTeXMode.textmode: '\\rightharpoonup ', LaTeXMode.mathmode: '\\rightharpoonup'},
    8641: {LaTeXMode.textmode: '\\rightharpoondown ', LaTeXMode.mathmode: '\\rightharpoondown'},
    8642: {LaTeXMode.textmode: '\\downharpoonright ', LaTeXMode.mathmode: '\\downharpoonright'},
    8643: {LaTeXMode.textmode: '\\downharpoonleft ', LaTeXMode.mathmode: '\\downharpoonleft'},
    8644: {LaTeXMode.textmode: '\\rightleftarrows ', LaTeXMode.mathmode: '\\rightleftarrows'},
    8645: {LaTeXMode.textmode: '\\dblarrowupdown '},
    8646: {LaTeXMode.textmode: '\\leftrightarrows ', LaTeXMode.mathmode: '\\leftrightarrows'},
    8647: {LaTeXMode.textmode: '\\leftleftarrows ', LaTeXMode.mathmode: '\\leftleftarrows'},
    8648: {LaTeXMode.textmode: '\\upuparrows ', LaTeXMode.mathmode: '\\upuparrows'},
    8649: {LaTeXMode.textmode: '\\rightrightarrows ', LaTeXMode.mathmode: '\\rightrightarrows'},
    8650: {LaTeXMode.textmode: '\\downdownarrows ', LaTeXMode.mathmode: '\\downdownarrows'},
    8651: {LaTeXMode.textmode: '\\leftrightharpoons ', LaTeXMode.mathmode: '\\leftrightharpoons'},
    8652: {LaTeXMode.textmode: '\\rightleftharpoons ', LaTeXMode.mathmode: '\\rightleftharpoons'},
    8653: {LaTeXMode.textmode: '\\nLeftarrow ', LaTeXMode.mathmode: '\\nLeftarrow'},
    8654: {LaTeXMode.textmode: '\\nLeftrightarrow ', LaTeXMode.mathmode: '\\nLeftrightarrow'},
    8655: {LaTeXMode.textmode: '\\nRightarrow ', LaTeXMode.mathmode: '\\nRightarrow'},
    8656: {LaTeXMode.textmode: '\\Leftarrow ', LaTeXMode.mathmode: '\\Leftarrow'},
    8657: {LaTeXMode.textmode: '\\Uparrow ', LaTeXMode.mathmode: '\\Uparrow'},
    8658: {LaTeXMode.textmode: '\\Rightarrow ', LaTeXMode.mathmode: '\\Rightarrow'},
    8659: {LaTeXMode.textmode: '\\Downarrow ', LaTeXMode.mathmode: '\\Downarrow'},
    8660: {LaTeXMode.textmode: '\\Leftrightarrow ', LaTeXMode.mathmode: '\\Leftrightarrow'},
    8661: {LaTeXMode.textmode: '\\Updownarrow ', LaTeXMode.mathmode: '\\Updownarrow'},
    8666: {LaTeXMode.textmode: '\\Lleftarrow ', LaTeXMode.mathmode: '\\Lleftarrow'},
    8667: {LaTeXMode.textmode: '\\Rrightarrow ', LaTeXMode.mathmode: '\\Rrightarrow'},
    8669: {LaTeXMode.textmode: '\\rightsquigarrow '},
    8693: {LaTeXMode.textmode: '\\DownArrowUpArrow '},
    8701: {LaTeXMode.mathmode: '\\leftarrowtriangle'},
    8702: {LaTeXMode.mathmode: '\\rightarrowtriangle'},
    8703: {LaTeXMode.mathmode: '\\leftrightarrowtria*'},
    8704: {LaTeXMode.textmode: '\\forall ', LaTeXMode.mathmode: '\\forall'},
    8705: {LaTeXMode.textmode: '\\complement ', LaTeXMode.mathmode: '\\complement'},
    8706: {LaTeXMode.textmode: '\\partial ', LaTeXMode.mathmode: '\\partial'},
    8707: {LaTeXMode.textmode: '\\exists ', LaTeXMode.mathmode: '\\exists'},
    8708: {LaTeXMode.textmode: '\\nexists ', LaTeXMode.mathmode: '\\nexists'},
    8709: {LaTeXMode.textmode: '\\varnothing ', LaTeXMode.mathmode: '\\varnothing'},
    8711: {LaTeXMode.textmode: '\\nabla ', LaTeXMode.mathmode: '\\nabla'},
    8712: {LaTeXMode.textmode: '\\in '},
    8713: {LaTeXMode.textmode: '\\not\\in ', LaTeXMode.mathmode: '\\notin'},
    8714: {LaTeXMode.mathmode: '\\in'},
    8715: {LaTeXMode.textmode: '\\ni ', LaTeXMode.mathmode: '\\ni'},
    8716: {LaTeXMode.textmode: '\\not\\ni '},
    8719: {LaTeXMode.textmode: '\\prod ', LaTeXMode.mathmode: '\\prod'},
    8720: {LaTeXMode.textmode: '\\coprod ', LaTeXMode.mathmode: '\\coprod'},
    8721: {LaTeXMode.textmode: '\\sum ', LaTeXMode.mathmode: '\\sum'},
    8722: {LaTeXMode.textmode: '-', LaTeXMode.mathmode: '-'},
    8723: {LaTeXMode.textmode: '\\mp ', LaTeXMode.mathmode: '\\mp'},
    8724: {LaTeXMode.textmode: '\\dotplus ', LaTeXMode.mathmode: '\\dotplus'},
    8726: {LaTeXMode.textmode: '\\setminus ', LaTeXMode.mathmode: '\\setminus'},
    8727: {LaTeXMode.textmode: '{_\\ast}', LaTeXMode.mathmode: '\\ast'},
    8728: {LaTeXMode.textmode: '\\circ ', LaTeXMode.mathmode: '\\circ'},
    8729: {LaTeXMode.textmode: '\\bullet '},
    8730: {LaTeXMode.textmode: '\\surd ', LaTeXMode.mathmode: '\\surd'},
    8733: {LaTeXMode.textmode: '\\propto ', LaTeXMode.mathmode: '\\propto'},
    8734: {LaTeXMode.textmode: '\\infty ', LaTeXMode.mathmode: '\\infty'},
    8735: {LaTeXMode.textmode: '\\rightangle '},
    8736: {LaTeXMode.textmode: '\\angle ', LaTeXMode.mathmode: '\\angle'},
    8737: {LaTeXMode.textmode: '\\measuredangle ', LaTeXMode.mathmode: '\\measuredangle'},
    8738: {LaTeXMode.textmode: '\\sphericalangle ', LaTeXMode.mathmode: '\\sphericalangle'},
    8739: {LaTeXMode.textmode: '\\mid ', LaTeXMode.mathmode: '\\mid'},
    8740: {LaTeXMode.textmode: '\\nmid ', LaTeXMode.mathmode: '\\nmid'},
    8741: {LaTeXMode.textmode: '\\parallel ', LaTeXMode.mathmode: '\\parallel'},
    8742: {LaTeXMode.textmode: '\\nparallel ', LaTeXMode.mathmode: '\\nparallel'},
    8743: {LaTeXMode.textmode: '\\wedge ', LaTeXMode.mathmode: '\\wedge'},
    8744: {LaTeXMode.textmode: '\\vee ', LaTeXMode.mathmode: '\\vee'},
    8745: {LaTeXMode.textmode: '\\cap ', LaTeXMode.mathmode: '\\cap'},
    8746: {LaTeXMode.textmode: '\\cup ', LaTeXMode.mathmode: '\\cup'},
    8747: {LaTeXMode.textmode: '\\int ', LaTeXMode.mathmode: '\\int'},
    8748: {LaTeXMode.textmode: '\\int\\!\\int ', LaTeXMode.mathmode: '\\iint'},
    8749: {LaTeXMode.textmode: '\\int\\!\\int\\!\\int ', LaTeXMode.mathmode: '\\iiint'},
    8750: {LaTeXMode.textmode: '\\oint ', LaTeXMode.mathmode: '\\oint'},
    8751: {LaTeXMode.textmode: '\\surfintegral ', LaTeXMode.mathmode: '\\oiint'},
    8752: {LaTeXMode.textmode: '\\volintegral ', LaTeXMode.mathmode: '\\oiiint'},
    8753: {LaTeXMode.textmode: '\\clwintegral '},
    8754: {LaTeXMode.textmode: '\\ElsevierGlyph{2232}'},
    8755: {LaTeXMode.textmode: '\\ElsevierGlyph{2233}'},
    8756: {LaTeXMode.textmode: '\\therefore ', LaTeXMode.mathmode: '\\therefore'},
    8757: {LaTeXMode.textmode: '\\because ', LaTeXMode.mathmode: '\\because'},
    8759: {LaTeXMode.textmode: '\\Colon ', LaTeXMode.mathmode: '\\Colon'},
    8760: {LaTeXMode.textmode: '\\ElsevierGlyph{2238}', LaTeXMode.mathmode: '\\dotminus'},
    8762: {LaTeXMode.textmode: '\\mathbin{{:}\\!\\!{-}\\!\\!{:}}'},
    8763: {LaTeXMode.textmode: '\\homothetic ', LaTeXMode.mathmode: '\\kernelcontraction'},
    8764: {LaTeXMode.textmode: '\\sim ', LaTeXMode.mathmode: '\\sim'},
    8765: {LaTeXMode.textmode: '\\backsim ', LaTeXMode.mathmode: '\\backsim'},
    8766: {LaTeXMode.textmode: '\\lazysinv '},
    8768: {LaTeXMode.textmode: '\\wr ', LaTeXMode.mathmode: '\\wr'},
    8769: {LaTeXMode.textmode: '\\not\\sim ', LaTeXMode.mathmode: '\\nsim'},
    8770: {LaTeXMode.textmode: '\\NotEqualTilde ', LaTeXMode.mathmode: '\\neqsim'},
    8771: {LaTeXMode.textmode: '\\simeq ', LaTeXMode.mathmode: '\\simeq'},
    8772: {LaTeXMode.textmode: '\\not\\simeq ', LaTeXMode.mathmode: '\\nsime'},
    8773: {LaTeXMode.textmode: '\\cong ', LaTeXMode.mathmode: '\\cong'},
    8774: {LaTeXMode.textmode: '\\approxnotequal '},
    8775: {LaTeXMode.textmode: '\\not\\cong ', LaTeXMode.mathmode: '\\ncong'},
    8776: {LaTeXMode.textmode: '\\approx ', LaTeXMode.mathmode: '\\approx'},
    8777: {LaTeXMode.textmode: '\\not\\approx ', LaTeXMode.mathmode: '\\napprox'},
    8778: {LaTeXMode.textmode: '\\approxeq ', LaTeXMode.mathmode: '\\approxeq'},
    8779: {LaTeXMode.textmode: '\\not\\apid '},
    8780: {LaTeXMode.textmode: '\\allequal '},
    8781: {LaTeXMode.textmode: '\\asymp ', LaTeXMode.mathmode: '\\asymp'},
    8782: {LaTeXMode.textmode: '\\NotHumpDownHump ', LaTeXMode.mathmode: '\\nBumpeq'},
    8783: {LaTeXMode.textmode: '\\NotHumpEqual ', LaTeXMode.mathmode: '\\nbumpeq'},
    8784: {LaTeXMode.textmode: '\\not\\doteq'},
    8785: {LaTeXMode.textmode: '\\doteqdot ', LaTeXMode.mathmode: '\\Doteq'},
    8786: {LaTeXMode.textmode: '\\fallingdotseq ', LaTeXMode.mathmode: '\\fallingdotseq'},
    8787: {LaTeXMode.textmode: '\\risingdotseq ', LaTeXMode.mathmode: '\\risingdotseq'},
    8788: {LaTeXMode.textmode: ':=', LaTeXMode.mathmode: '\\coloneq'},
    8789: {LaTeXMode.textmode: '=:', LaTeXMode.mathmode: '\\eqcolon'},
    8790: {LaTeXMode.textmode: '\\eqcirc ', LaTeXMode.mathmode: '\\eqcirc'},
    8791: {LaTeXMode.textmode: '\\circeq ', LaTeXMode.mathmode: '\\circeq'},
    8793: {LaTeXMode.textmode: '\\estimates ', LaTeXMode.mathmode: '\\wedgeq'},
    8794: {LaTeXMode.textmode: '\\ElsevierGlyph{225A}'},
    8795: {LaTeXMode.textmode: '\\starequal '},
    8796: {LaTeXMode.textmode: '\\triangleq ', LaTeXMode.mathmode: '\\triangleq'},
    8799: {LaTeXMode.textmode: '\\ElsevierGlyph{225F}', LaTeXMode.mathmode: '\\questeq'},
    8800: {LaTeXMode.textmode: '\\not =', LaTeXMode.mathmode: '\\ne'},
    8801: {LaTeXMode.textmode: '\\equiv ', LaTeXMode.mathmode: '\\equiv'},
    8802: {LaTeXMode.textmode: '\\not\\equiv ', LaTeXMode.mathmode: '\\nequiv'},
    8804: {LaTeXMode.textmode: '\\leq ', LaTeXMode.mathmode: '\\le'},
    8805: {LaTeXMode.textmode: '\\geq ', LaTeXMode.mathmode: '\\ge'},
    8806: {LaTeXMode.textmode: '\\leqq ', LaTeXMode.mathmode: '\\leqq'},
    8807: {LaTeXMode.textmode: '\\geqq ', LaTeXMode.mathmode: '\\geqq'},
    8808: {LaTeXMode.textmode: '\\lvertneqq ', LaTeXMode.mathmode: '\\lvertneqq'},
    8809: {LaTeXMode.textmode: '\\gvertneqq ', LaTeXMode.mathmode: '\\gvertneqq'},
    8810: {LaTeXMode.textmode: '\\NotLessLess '},
    8811: {LaTeXMode.textmode: '\\NotGreaterGreater '},
    8812: {LaTeXMode.textmode: '\\between ', LaTeXMode.mathmode: '\\between'},
    8813: {LaTeXMode.textmode: '\\not\\kern-0.3em\\times '},
    8814: {LaTeXMode.textmode: '\\not<', LaTeXMode.mathmode: '\\nless'},
    8815: {LaTeXMode.textmode: '\\not>', LaTeXMode.mathmode: '\\ngtr'},
    8816: {LaTeXMode.textmode: '\\not\\leq ', LaTeXMode.mathmode: '\\nleq'},
    8817: {LaTeXMode.textmode: '\\not\\geq ', LaTeXMode.mathmode: '\\ngeq'},
    8818: {LaTeXMode.textmode: '\\lessequivlnt ', LaTeXMode.mathmode: '\\lesssim'},
    8819: {LaTeXMode.textmode: '\\greaterequivlnt ', LaTeXMode.mathmode: '\\gtrsim'},
    8820: {LaTeXMode.textmode: '\\ElsevierGlyph{2274}'},
    8821: {LaTeXMode.textmode: '\\ElsevierGlyph{2275}'},
    8822: {LaTeXMode.textmode: '\\lessgtr ', LaTeXMode.mathmode: '\\lessgtr'},
    8823: {LaTeXMode.textmode: '\\gtrless ', LaTeXMode.mathmode: '\\gtrless'},
    8824: {LaTeXMode.textmode: '\\notlessgreater '},
    8825: {LaTeXMode.textmode: '\\notgreaterless '},
    8826: {LaTeXMode.textmode: '\\prec ', LaTeXMode.mathmode: '\\prec'},
    8827: {LaTeXMode.textmode: '\\succ ', LaTeXMode.mathmode: '\\succ'},
    8828: {LaTeXMode.textmode: '\\preccurlyeq ', LaTeXMode.mathmode: '\\preccurlyeq'},
    8829: {LaTeXMode.textmode: '\\succcurlyeq ', LaTeXMode.mathmode: '\\succcurlyeq'},
    8830: {LaTeXMode.textmode: '\\NotPrecedesTilde ', LaTeXMode.mathmode: '\\nprecsim'},
    8831: {LaTeXMode.textmode: '\\NotSucceedsTilde ', LaTeXMode.mathmode: '\\nsuccsim'},
    8832: {LaTeXMode.textmode: '\\not\\prec ', LaTeXMode.mathmode: '\\nprec'},
    8833: {LaTeXMode.textmode: '\\not\\succ ', LaTeXMode.mathmode: '\\nsucc'},
    8834: {LaTeXMode.textmode: '\\subset ', LaTeXMode.mathmode: '\\subset'},
    8835: {LaTeXMode.textmode: '\\supset ', LaTeXMode.mathmode: '\\supset'},
    8836: {LaTeXMode.textmode: '\\not\\subset ', LaTeXMode.mathmode: '\\nsubset'},
    8837: {LaTeXMode.textmode: '\\not\\supset ', LaTeXMode.mathmode: '\\nsupset'},
    8838: {LaTeXMode.textmode: '\\subseteq ', LaTeXMode.mathmode: '\\subseteq'},
    8839: {LaTeXMode.textmode: '\\supseteq ', LaTeXMode.mathmode: '\\supseteq'},
    8840: {LaTeXMode.textmode: '\\not\\subseteq ', LaTeXMode.mathmode: '\\nsubseteq'},
    8841: {LaTeXMode.textmode: '\\not\\supseteq ', LaTeXMode.mathmode: '\\nsupseteq'},
    8842: {LaTeXMode.textmode: '\\varsubsetneqq ', LaTeXMode.mathmode: '\\varsubsetneqq'},
    8843: {LaTeXMode.textmode: '\\varsupsetneq ', LaTeXMode.mathmode: '\\varsupsetneq'},
    8846: {LaTeXMode.textmode: '\\uplus ', LaTeXMode.mathmode: '\\uplus'},
    8847: {LaTeXMode.textmode: '\\NotSquareSubset '},
    8848: {LaTeXMode.textmode: '\\NotSquareSuperset '},
    8849: {LaTeXMode.textmode: '\\sqsubseteq ', LaTeXMode.mathmode: '\\sqsubseteq'},
    8850: {LaTeXMode.textmode: '\\sqsupseteq ', LaTeXMode.mathmode: '\\sqsupseteq'},
    8851: {LaTeXMode.textmode: '\\sqcap ', LaTeXMode.mathmode: '\\sqcap'},
    8852: {LaTeXMode.textmode: '\\sqcup ', LaTeXMode.mathmode: '\\sqcup'},
    8853: {LaTeXMode.textmode: '\\oplus ', LaTeXMode.mathmode: '\\oplus'},
    8854: {LaTeXMode.textmode: '\\ominus ', LaTeXMode.mathmode: '\\ominus'},
    8855: {LaTeXMode.textmode: '\\otimes ', LaTeXMode.mathmode: '\\otimes'},
    8856: {LaTeXMode.textmode: '\\oslash ', LaTeXMode.mathmode: '\\oslash'},
    8857: {LaTeXMode.textmode: '\\odot ', LaTeXMode.mathmode: '\\odot'},
    8858: {LaTeXMode.textmode: '\\circledcirc ', LaTeXMode.mathmode: '\\circledcirc'},
    8859: {LaTeXMode.textmode: '\\circledast ', LaTeXMode.mathmode: '\\circledast'},
    8861: {LaTeXMode.textmode: '\\circleddash ', LaTeXMode.mathmode: '\\circleddash'},
    8862: {LaTeXMode.textmode: '\\boxplus ', LaTeXMode.mathmode: '\\boxplus'},
    8863: {LaTeXMode.textmode: '\\boxminus ', LaTeXMode.mathmode: '\\boxminus'},
    8864: {LaTeXMode.textmode: '\\boxtimes ', LaTeXMode.mathmode: '\\boxtimes'},
    8865: {LaTeXMode.textmode: '\\boxdot ', LaTeXMode.mathmode: '\\boxdot'},
    8866: {LaTeXMode.textmode: '\\vdash ', LaTeXMode.mathmode: '\\vdash'},
    8867: {LaTeXMode.textmode: '\\dashv ', LaTeXMode.mathmode: '\\dashv'},
    8868: {LaTeXMode.textmode: '\\top ', LaTeXMode.mathmode: '\\top'},
    8869: {LaTeXMode.textmode: '\\perp ', LaTeXMode.mathmode: '\\perp'},
    8871: {LaTeXMode.textmode: '\\truestate ', LaTeXMode.mathmode: '\\models'},
    8872: {LaTeXMode.textmode: '\\forcesextra ', LaTeXMode.mathmode: '\\vDash'},
    8873: {LaTeXMode.textmode: '\\Vdash ', LaTeXMode.mathmode: '\\Vdash'},
    8874: {LaTeXMode.textmode: '\\Vvdash ', LaTeXMode.mathmode: '\\Vvdash'},
    8875: {LaTeXMode.textmode: '\\VDash '},
    8876: {LaTeXMode.textmode: '\\nvdash ', LaTeXMode.mathmode: '\\nvdash'},
    8877: {LaTeXMode.textmode: '\\nvDash ', LaTeXMode.mathmode: '\\nvDash'},
    8878: {LaTeXMode.textmode: '\\nVdash ', LaTeXMode.mathmode: '\\nVdash'},
    8879: {LaTeXMode.textmode: '\\nVDash ', LaTeXMode.mathmode: '\\nVDash'},
    8882: {LaTeXMode.textmode: '\\vartriangleleft ', LaTeXMode.mathmode: '\\vartriangleleft'},
    8883: {LaTeXMode.textmode: '\\vartriangleright ', LaTeXMode.mathmode: '\\vartriangleright'},
    8884: {LaTeXMode.textmode: '\\trianglelefteq ', LaTeXMode.mathmode: '\\trianglelefteq'},
    8885: {LaTeXMode.textmode: '\\trianglerighteq ', LaTeXMode.mathmode: '\\trianglerighteq'},
    8886: {LaTeXMode.textmode: '\\original '},
    8887: {LaTeXMode.textmode: '\\image '},
    8888: {LaTeXMode.textmode: '\\multimap ', LaTeXMode.mathmode: '\\multimap'},
    8889: {LaTeXMode.textmode: '\\hermitconjmatrix '},
    8890: {LaTeXMode.textmode: '\\intercal ', LaTeXMode.mathmode: '\\intercal'},
    8891: {LaTeXMode.textmode: '\\veebar ', LaTeXMode.mathmode: '\\veebar'},
    8894: {LaTeXMode.textmode: '\\rightanglearc '},
    8896: {LaTeXMode.textmode: '\\ElsevierGlyph{22C0}', LaTeXMode.mathmode: '\\bigwedge'},
    8897: {LaTeXMode.textmode: '\\ElsevierGlyph{22C1}', LaTeXMode.mathmode: '\\bigvee'},
    8898: {LaTeXMode.textmode: '\\bigcap ', LaTeXMode.mathmode: '\\bigcap'},
    8899: {LaTeXMode.textmode: '\\bigcup ', LaTeXMode.mathmode: '\\bigcup'},
    8900: {LaTeXMode.textmode: '\\diamond ', LaTeXMode.mathmode: '\\diamond'},
    8901: {LaTeXMode.textmode: '\\cdot ', LaTeXMode.mathmode: '\\cdot'},
    8902: {LaTeXMode.textmode: '\\star ', LaTeXMode.mathmode: '\\star'},
    8903: {LaTeXMode.textmode: '\\divideontimes ', LaTeXMode.mathmode: '\\divideontimes'},
    8904: {LaTeXMode.textmode: '\\bowtie ', LaTeXMode.mathmode: '\\bowtie'},
    8905: {LaTeXMode.textmode: '\\ltimes ', LaTeXMode.mathmode: '\\ltimes'},
    8906: {LaTeXMode.textmode: '\\rtimes ', LaTeXMode.mathmode: '\\rtimes'},
    8907: {LaTeXMode.textmode: '\\leftthreetimes ', LaTeXMode.mathmode: '\\leftthreetimes'},
    8908: {LaTeXMode.textmode: '\\rightthreetimes ', LaTeXMode.mathmode: '\\rightthreetimes'},
    8909: {LaTeXMode.textmode: '\\backsimeq ', LaTeXMode.mathmode: '\\backsimeq'},
    8910: {LaTeXMode.textmode: '\\curlyvee ', LaTeXMode.mathmode: '\\curlyvee'},
    8911: {LaTeXMode.textmode: '\\curlywedge ', LaTeXMode.mathmode: '\\curlywedge'},
    8912: {LaTeXMode.textmode: '\\Subset ', LaTeXMode.mathmode: '\\Subset'},
    8913: {LaTeXMode.textmode: '\\Supset ', LaTeXMode.mathmode: '\\Supset'},
    8914: {LaTeXMode.textmode: '\\Cap ', LaTeXMode.mathmode: '\\Cap'},
    8915: {LaTeXMode.textmode: '\\Cup ', LaTeXMode.mathmode: '\\Cup'},
    8916: {LaTeXMode.textmode: '\\pitchfork ', LaTeXMode.mathmode: '\\pitchfork'},
    8918: {LaTeXMode.textmode: '\\lessdot ', LaTeXMode.mathmode: '\\lessdot'},
    8919: {LaTeXMode.textmode: '\\gtrdot ', LaTeXMode.mathmode: '\\gtrdot'},
    8920: {LaTeXMode.textmode: '\\verymuchless '},
    8921: {LaTeXMode.textmode: '\\verymuchgreater ', LaTeXMode.mathmode: '\\ggg'},
    8922: {LaTeXMode.textmode: '\\lesseqgtr ', LaTeXMode.mathmode: '\\lesseqgtr'},
    8923: {LaTeXMode.textmode: '\\gtreqless ', LaTeXMode.mathmode: '\\gtreqless'},
    8926: {LaTeXMode.textmode: '\\curlyeqprec ', LaTeXMode.mathmode: '\\curlyeqprec'},
    8927: {LaTeXMode.textmode: '\\curlyeqsucc ', LaTeXMode.mathmode: '\\curlyeqsucc'},
    8930: {LaTeXMode.textmode: '\\not\\sqsubseteq '},
    8931: {LaTeXMode.textmode: '\\not\\sqsupseteq '},
    8933: {LaTeXMode.textmode: '\\Elzsqspne '},
    8934: {LaTeXMode.textmode: '\\lnsim ', LaTeXMode.mathmode: '\\lnsim'},
    8935: {LaTeXMode.textmode: '\\gnsim ', LaTeXMode.mathmode: '\\gnsim'},
    8936: {LaTeXMode.textmode: '\\precedesnotsimilar ', LaTeXMode.mathmode: '\\precnsim'},
    8937: {LaTeXMode.textmode: '\\succnsim ', LaTeXMode.mathmode: '\\succnsim'},
    8938: {LaTeXMode.textmode: '\\ntriangleleft ', LaTeXMode.mathmode: '\\ntriangleleft'},
    8939: {LaTeXMode.textmode: '\\ntriangleright ', LaTeXMode.mathmode: '\\ntriangleright'},
    8940: {LaTeXMode.textmode: '\\ntrianglelefteq ', LaTeXMode.mathmode: '\\ntrianglelefteq'},
    8941: {LaTeXMode.textmode: '\\ntrianglerighteq ', LaTeXMode.mathmode: '\\ntrianglerighteq'},
    8942: {LaTeXMode.textmode: '\\vdots ', LaTeXMode.mathmode: '\\vdots'},
    8943: {LaTeXMode.textmode: '\\cdots ', LaTeXMode.mathmode: '\\cdots'},
    8944: {LaTeXMode.textmode: '\\upslopeellipsis ', LaTeXMode.mathmode: '\\adots'},
    8945: {LaTeXMode.textmode: '\\downslopeellipsis ', LaTeXMode.mathmode: '\\ddots'},
    8966: {LaTeXMode.textmode: '\\varperspcorrespond '},
    8968: {LaTeXMode.textmode: '\\lceil ', LaTeXMode.mathmode: '\\lceil'},
    8969: {LaTeXMode.textmode: '\\rceil ', LaTeXMode.mathmode: '\\rceil'},
    8970: {LaTeXMode.textmode: '\\lfloor ', LaTeXMode.mathmode: '\\lfloor'},
    8971: {LaTeXMode.textmode: '\\rfloor ', LaTeXMode.mathmode: '\\rfloor'},
    8981: {LaTeXMode.textmode: '\\recorder '},
    8982: {LaTeXMode.textmode: '\\mathchar"2208'},
    8988: {LaTeXMode.textmode: '\\ulcorner ', LaTeXMode.mathmode: '\\ulcorner'},
    8989: {LaTeXMode.textmode: '\\urcorner ', LaTeXMode.mathmode: '\\urcorner'},
    8990: {LaTeXMode.textmode: '\\llcorner ', LaTeXMode.mathmode: '\\llcorner'},
    8991: {LaTeXMode.textmode: '\\lrcorner ', LaTeXMode.mathmode: '\\lrcorner'},
    8994: {LaTeXMode.textmode: '\\frown ', LaTeXMode.mathmode: '\\frown'},
    8995: {LaTeXMode.textmode: '\\smile ', LaTeXMode.mathmode: '\\smile'},
    9021: {LaTeXMode.textmode: '\\ElsevierGlyph{E838}', LaTeXMode.mathmode: '\\obar'},
    9123: {LaTeXMode.textmode: '\\Elzdlcorn '},
    9136: {LaTeXMode.textmode: '\\lmoustache ', LaTeXMode.mathmode: '\\lmoustache'},
    9137: {LaTeXMode.textmode: '\\rmoustache ', LaTeXMode.mathmode: '\\rmoustache'},
    9251: {LaTeXMode.textmode: '\\textvisiblespace '},
    9312: {LaTeXMode.textmode: '\\ding{172}'},
    9313: {LaTeXMode.textmode: '\\ding{173}'},
    9314: {LaTeXMode.textmode: '\\ding{174}'},
    9315: {LaTeXMode.textmode: '\\ding{175}'},
    9316: {LaTeXMode.textmode: '\\ding{176}'},
    9317: {LaTeXMode.textmode: '\\ding{177}'},
    9318: {LaTeXMode.textmode: '\\ding{178}'},
    9319: {LaTeXMode.textmode: '\\ding{179}'},
    9320: {LaTeXMode.textmode: '\\ding{180}'},
    9321: {LaTeXMode.textmode: '\\ding{181}'},
    9416: {LaTeXMode.textmode: '\\circledS ', LaTeXMode.mathmode: '\\circledS'},
    9478: {LaTeXMode.textmode: '\\Elzdshfnc '},
    9497: {LaTeXMode.textmode: '\\Elzsqfnw '},
    9585: {LaTeXMode.textmode: '\\diagup ', LaTeXMode.mathmode: '\\diagup'},
    9586: {LaTeXMode.mathmode: '\\diagdown'},
    9632: {LaTeXMode.textmode: '\\ding{110}', LaTeXMode.mathmode: '\\blacksquare'},
    9633: {LaTeXMode.textmode: '\\square ', LaTeXMode.mathmode: '\\square'},
    9642: {LaTeXMode.textmode: '\\blacksquare '},
    9645: {LaTeXMode.textmode: '\\fbox{~~}'},
    9647: {LaTeXMode.textmode: '\\Elzvrecto '},
    9649: {LaTeXMode.textmode: '\\ElsevierGlyph{E381}'},
    9650: {LaTeXMode.textmode: '\\ding{115}'},
    9651: {LaTeXMode.textmode: '\\bigtriangleup ', LaTeXMode.mathmode: '\\bigtriangleup'},
    9652: {LaTeXMode.textmode: '\\blacktriangle ', LaTeXMode.mathmode: '\\blacktriangle'},
    9653: {LaTeXMode.textmode: '\\vartriangle ', LaTeXMode.mathmode: '\\vartriangle'},
    9656: {LaTeXMode.textmode: '\\blacktriangleright ', LaTeXMode.mathmode: '\\blacktriangleright'},
    9657: {LaTeXMode.textmode: '\\triangleright ', LaTeXMode.mathmode: '\\triangleright'},
    9660: {LaTeXMode.textmode: '\\ding{116}'},
    9661: {LaTeXMode.textmode: '\\bigtriangledown ', LaTeXMode.mathmode: '\\bigtriangledown'},
    9662: {LaTeXMode.textmode: '\\blacktriangledown ', LaTeXMode.mathmode: '\\blacktriangledown'},
    9663: {LaTeXMode.textmode: '\\triangledown ', LaTeXMode.mathmode: '\\triangledown'},
    9666: {LaTeXMode.textmode: '\\blacktriangleleft ', LaTeXMode.mathmode: '\\blacktriangleleft'},
    9667: {LaTeXMode.textmode: '\\triangleleft ', LaTeXMode.mathmode: '\\triangleleft'},
    9670: {LaTeXMode.textmode: '\\ding{117}'},
    9674: {LaTeXMode.textmode: '\\lozenge ', LaTeXMode.mathmode: '\\lozenge'},
    9675: {LaTeXMode.textmode: '\\bigcirc ', LaTeXMode.mathmode: '\\bigcirc'},
    9679: {LaTeXMode.textmode: '\\ding{108}'},
    9680: {LaTeXMode.textmode: '\\Elzcirfl '},
    9681: {LaTeXMode.textmode: '\\Elzcirfr '},
    9682: {LaTeXMode.textmode: '\\Elzcirfb '},
    9687: {LaTeXMode.textmode: '\\ding{119}'},
    9688: {LaTeXMode.textmode: '\\Elzrvbull '},
    9703: {LaTeXMode.textmode: '\\Elzsqfl '},
    9704: {LaTeXMode.textmode: '\\Elzsqfr '},
    9706: {LaTeXMode.textmode: '\\Elzsqfse '},
    9711: {LaTeXMode.textmode: '\\bigcirc '},
    9733: {LaTeXMode.textmode: '\\ding{72}', LaTeXMode.mathmode: '\\bigstar'},
    9742: {LaTeXMode.textmode: '\\ding{37}'},
    9755: {LaTeXMode.textmode: '\\ding{42}'},
    9758: {LaTeXMode.textmode: '\\ding{43}'},
    9792: {LaTeXMode.textmode: '\\venus '},
    9794: {LaTeXMode.textmode: '\\male '},
    9799: {LaTeXMode.textmode: '\\pluto '},
    9800: {LaTeXMode.textmode: '\\aries '},
    9801: {LaTeXMode.textmode: '\\taurus '},
    9802: {LaTeXMode.textmode: '\\gemini '},
    9803: {LaTeXMode.textmode: '\\cancer '},
    9804: {LaTeXMode.textmode: '\\leo '},
    9805: {LaTeXMode.textmode: '\\virgo '},
    9806: {LaTeXMode.textmode: '\\libra '},
    9807: {LaTeXMode.textmode: '\\scorpio '},
    9808: {LaTeXMode.textmode: '\\sagittarius '},
    9809: {LaTeXMode.textmode: '\\capricornus '},
    9810: {LaTeXMode.textmode: '\\aquarius '},
    9811: {LaTeXMode.textmode: '\\pisces '},
    9824: {LaTeXMode.textmode: '\\ding{171}', LaTeXMode.mathmode: '\\spadesuit'},
    9826: {LaTeXMode.textmode: '\\diamond ', LaTeXMode.mathmode: '\\diamondsuit'},
    9827: {LaTeXMode.textmode: '\\ding{168}', LaTeXMode.mathmode: '\\clubsuit'},
    9829: {LaTeXMode.textmode: '\\ding{170}'},
    9830: {LaTeXMode.textmode: '\\ding{169}'},
    9833: {LaTeXMode.textmode: '\\quarternote '},
    9834: {LaTeXMode.textmode: '\\eighthnote '},
    9837: {LaTeXMode.textmode: '\\flat ', LaTeXMode.mathmode: '\\flat'},
    9838: {LaTeXMode.textmode: '\\natural ', LaTeXMode.mathmode: '\\natural'},
    9839: {LaTeXMode.textmode: '\\sharp ', LaTeXMode.mathmode: '\\sharp'},
    9985: {LaTeXMode.textmode: '\\ding{33}'},
    9986: {LaTeXMode.textmode: '\\ding{34}'},
    9987: {LaTeXMode.textmode: '\\ding{35}'},
    9988: {LaTeXMode.textmode: '\\ding{36}'},
    9990: {LaTeXMode.textmode: '\\ding{38}'},
    9991: {LaTeXMode.textmode: '\\ding{39}'},
    9992: {LaTeXMode.textmode: '\\ding{40}'},
    9993: {LaTeXMode.textmode: '\\ding{41}'},
    9996: {LaTeXMode.textmode: '\\ding{44}'},
    9997: {LaTeXMode.textmode: '\\ding{45}'},
    9998: {LaTeXMode.textmode: '\\ding{46}'},
    9999: {LaTeXMode.textmode: '\\ding{47}'},
    10000: {LaTeXMode.textmode: '\\ding{48}'},
    10001: {LaTeXMode.textmode: '\\ding{49}'},
    10002: {LaTeXMode.textmode: '\\ding{50}'},
    10003: {LaTeXMode.textmode: '\\ding{51}', LaTeXMode.mathmode: '\\checkmark'},
    10004: {LaTeXMode.textmode: '\\ding{52}'},
    10005: {LaTeXMode.textmode: '\\ding{53}'},
    10006: {LaTeXMode.textmode: '\\ding{54}'},
    10007: {LaTeXMode.textmode: '\\ding{55}'},
    10008: {LaTeXMode.textmode: '\\ding{56}'},
    10009: {LaTeXMode.textmode: '\\ding{57}'},
    10010: {LaTeXMode.textmode: '\\ding{58}'},
    10011: {LaTeXMode.textmode: '\\ding{59}'},
    10012: {LaTeXMode.textmode: '\\ding{60}'},
    10013: {LaTeXMode.textmode: '\\ding{61}'},
    10014: {LaTeXMode.textmode: '\\ding{62}'},
    10015: {LaTeXMode.textmode: '\\ding{63}'},
    10016: {LaTeXMode.textmode: '\\ding{64}', LaTeXMode.mathmode: '\\maltese'},
    10017: {LaTeXMode.textmode: '\\ding{65}'},
    10018: {LaTeXMode.textmode: '\\ding{66}'},
    10019: {LaTeXMode.textmode: '\\ding{67}'},
    10020: {LaTeXMode.textmode: '\\ding{68}'},
    10021: {LaTeXMode.textmode: '\\ding{69}'},
    10022: {LaTeXMode.textmode: '\\ding{70}'},
    10023: {LaTeXMode.textmode: '\\ding{71}'},
    10025: {LaTeXMode.textmode: '\\ding{73}'},
    10026: {LaTeXMode.textmode: '\\ding{74}'},
    10027: {LaTeXMode.textmode: '\\ding{75}'},
    10028: {LaTeXMode.textmode: '\\ding{76}'},
    10029: {LaTeXMode.textmode: '\\ding{77}'},
    10030: {LaTeXMode.textmode: '\\ding{78}'},
    10031: {LaTeXMode.textmode: '\\ding{79}'},
    10032: {LaTeXMode.textmode: '\\ding{80}'},
    10033: {LaTeXMode.textmode: '\\ding{81}'},
    10034: {LaTeXMode.textmode: '\\ding{82}'},
    10035: {LaTeXMode.textmode: '\\ding{83}'},
    10036: {LaTeXMode.textmode: '\\ding{84}'},
    10037: {LaTeXMode.textmode: '\\ding{85}'},
    10038: {LaTeXMode.textmode: '\\ding{86}'},
    10039: {LaTeXMode.textmode: '\\ding{87}'},
    10040: {LaTeXMode.textmode: '\\ding{88}'},
    10041: {LaTeXMode.textmode: '\\ding{89}'},
    10042: {LaTeXMode.textmode: '\\ding{90}'},
    10043: {LaTeXMode.textmode: '\\ding{91}'},
    10044: {LaTeXMode.textmode: '\\ding{92}'},
    10045: {LaTeXMode.textmode: '\\ding{93}'},
    10046: {LaTeXMode.textmode: '\\ding{94}'},
    10047: {LaTeXMode.textmode: '\\ding{95}'},
    10048: {LaTeXMode.textmode: '\\ding{96}'},
    10049: {LaTeXMode.textmode: '\\ding{97}'},
    10050: {LaTeXMode.textmode: '\\ding{98}'},
    10051: {LaTeXMode.textmode: '\\ding{99}'},
    10052: {LaTeXMode.textmode: '\\ding{100}'},
    10053: {LaTeXMode.textmode: '\\ding{101}'},
    10054: {LaTeXMode.textmode: '\\ding{102}'},
    10055: {LaTeXMode.textmode: '\\ding{103}'},
    10056: {LaTeXMode.textmode: '\\ding{104}'},
    10057: {LaTeXMode.textmode: '\\ding{105}'},
    10058: {LaTeXMode.textmode: '\\ding{106}'},
    10059: {LaTeXMode.textmode: '\\ding{107}'},
    10061: {LaTeXMode.textmode: '\\ding{109}'},
    10063: {LaTeXMode.textmode: '\\ding{111}'},
    10064: {LaTeXMode.textmode: '\\ding{112}'},
    10065: {LaTeXMode.textmode: '\\ding{113}'},
    10066: {LaTeXMode.textmode: '\\ding{114}'},
    10070: {LaTeXMode.textmode: '\\ding{118}'},
    10072: {LaTeXMode.textmode: '\\ding{120}'},
    10073: {LaTeXMode.textmode: '\\ding{121}'},
    10074: {LaTeXMode.textmode: '\\ding{122}'},
    10075: {LaTeXMode.textmode: '\\ding{123}'},
    10076: {LaTeXMode.textmode: '\\ding{124}'},
    10077: {LaTeXMode.textmode: '\\ding{125}'},
    10078: {LaTeXMode.textmode: '\\ding{126}'},
    10081: {LaTeXMode.textmode: '\\ding{161}'},
    10082: {LaTeXMode.textmode: '\\ding{162}'},
    10083: {LaTeXMode.textmode: '\\ding{163}'},
    10084: {LaTeXMode.textmode: '\\ding{164}'},
    10085: {LaTeXMode.textmode: '\\ding{165}'},
    10086: {LaTeXMode.textmode: '\\ding{166}'},
    10087: {LaTeXMode.textmode: '\\ding{167}'},
    10102: {LaTeXMode.textmode: '\\ding{182}'},
    10103: {LaTeXMode.textmode: '\\ding{183}'},
    10104: {LaTeXMode.textmode: '\\ding{184}'},
    10105: {LaTeXMode.textmode: '\\ding{185}'},
    10106: {LaTeXMode.textmode: '\\ding{186}'},
    10107: {LaTeXMode.textmode: '\\ding{187}'},
    10108: {LaTeXMode.textmode: '\\ding{188}'},
    10109: {LaTeXMode.textmode: '\\ding{189}'},
    10110: {LaTeXMode.textmode: '\\ding{190}'},
    10111: {LaTeXMode.textmode: '\\ding{191}'},
    10112: {LaTeXMode.textmode: '\\ding{192}'},
    10113: {LaTeXMode.textmode: '\\ding{193}'},
    10114: {LaTeXMode.textmode: '\\ding{194}'},
    10115: {LaTeXMode.textmode: '\\ding{195}'},
    10116: {LaTeXMode.textmode: '\\ding{196}'},
    10117: {LaTeXMode.textmode: '\\ding{197}'},
    10118: {LaTeXMode.textmode: '\\ding{198}'},
    10119: {LaTeXMode.textmode: '\\ding{199}'},
    10120: {LaTeXMode.textmode: '\\ding{200}'},
    10121: {LaTeXMode.textmode: '\\ding{201}'},
    10122: {LaTeXMode.textmode: '\\ding{202}'},
    10123: {LaTeXMode.textmode: '\\ding{203}'},
    10124: {LaTeXMode.textmode: '\\ding{204}'},
    10125: {LaTeXMode.textmode: '\\ding{205}'},
    10126: {LaTeXMode.textmode: '\\ding{206}'},
    10127: {LaTeXMode.textmode: '\\ding{207}'},
    10128: {LaTeXMode.textmode: '\\ding{208}'},
    10129: {LaTeXMode.textmode: '\\ding{209}'},
    10130: {LaTeXMode.textmode: '\\ding{210}'},
    10131: {LaTeXMode.textmode: '\\ding{211}'},
    10132: {LaTeXMode.textmode: '\\ding{212}'},
    10136: {LaTeXMode.textmode: '\\ding{216}'},
    10137: {LaTeXMode.textmode: '\\ding{217}'},
    10138: {LaTeXMode.textmode: '\\ding{218}'},
    10139: {LaTeXMode.textmode: '\\ding{219}'},
    10140: {LaTeXMode.textmode: '\\ding{220}'},
    10141: {LaTeXMode.textmode: '\\ding{221}'},
    10142: {LaTeXMode.textmode: '\\ding{222}'},
    10143: {LaTeXMode.textmode: '\\ding{223}'},
    10144: {LaTeXMode.textmode: '\\ding{224}'},
    10145: {LaTeXMode.textmode: '\\ding{225}'},
    10146: {LaTeXMode.textmode: '\\ding{226}'},
    10147: {LaTeXMode.textmode: '\\ding{227}'},
    10148: {LaTeXMode.textmode: '\\ding{228}'},
    10149: {LaTeXMode.textmode: '\\ding{229}'},
    10150: {LaTeXMode.textmode: '\\ding{230}'},
    10151: {LaTeXMode.textmode: '\\ding{231}'},
    10152: {LaTeXMode.textmode: '\\ding{232}'},
    10153: {LaTeXMode.textmode: '\\ding{233}'},
    10154: {LaTeXMode.textmode: '\\ding{234}'},
    10155: {LaTeXMode.textmode: '\\ding{235}'},
    10156: {LaTeXMode.textmode: '\\ding{236}'},
    10157: {LaTeXMode.textmode: '\\ding{237}'},
    10158: {LaTeXMode.textmode: '\\ding{238}'},
    10159: {LaTeXMode.textmode: '\\ding{239}'},
    10161: {LaTeXMode.textmode: '\\ding{241}'},
    10162: {LaTeXMode.textmode: '\\ding{242}'},
    10163: {LaTeXMode.textmode: '\\ding{243}'},
    10164: {LaTeXMode.textmode: '\\ding{244}'},
    10165: {LaTeXMode.textmode: '\\ding{245}'},
    10166: {LaTeXMode.textmode: '\\ding{246}'},
    10167: {LaTeXMode.textmode: '\\ding{247}'},
    10168: {LaTeXMode.textmode: '\\ding{248}'},
    10169: {LaTeXMode.textmode: '\\ding{249}'},
    10170: {LaTeXMode.textmode: '\\ding{250}'},
    10171: {LaTeXMode.textmode: '\\ding{251}'},
    10172: {LaTeXMode.textmode: '\\ding{252}'},
    10173: {LaTeXMode.textmode: '\\ding{253}'},
    10174: {LaTeXMode.textmode: '\\ding{254}'},
    10229: {LaTeXMode.textmode: '\\longleftarrow ', LaTeXMode.mathmode: '\\longleftarrow'},
    10230: {LaTeXMode.textmode: '\\longrightarrow ', LaTeXMode.mathmode: '\\longrightarrow'},
    10231: {LaTeXMode.textmode: '\\longleftrightarrow ', LaTeXMode.mathmode: '\\longleftrightarrow'},
    10232: {LaTeXMode.textmode: '\\Longleftarrow ', LaTeXMode.mathmode: '\\Longleftarrow'},
    10233: {LaTeXMode.textmode: '\\Longrightarrow ', LaTeXMode.mathmode: '\\Longrightarrow'},
    10234: {LaTeXMode.textmode: '\\Longleftrightarrow ', LaTeXMode.mathmode: '\\Longleftrightarrow'},
    10236: {LaTeXMode.textmode: '\\longmapsto ', LaTeXMode.mathmode: '\\longmapsto'},
    10239: {LaTeXMode.textmode: '\\sim\\joinrel\\leadsto'},
    10501: {LaTeXMode.textmode: '\\ElsevierGlyph{E212}'},
    10502: {LaTeXMode.mathmode: '\\Mapsfrom'},
    10503: {LaTeXMode.mathmode: '\\Mapsto'},
    10506: {LaTeXMode.mathmode: '\\Uuparrow'},
    10507: {LaTeXMode.mathmode: '\\Ddownarrow'},
    10511: {LaTeXMode.mathmode: '\\dbkarow'},
    10512: {LaTeXMode.mathmode: '\\drbkarrow'},
    10514: {LaTeXMode.textmode: '\\UpArrowBar '},
    10515: {LaTeXMode.textmode: '\\DownArrowBar '},
    10518: {LaTeXMode.mathmode: '\\twoheadrightarrowtail'},
    10531: {LaTeXMode.textmode: '\\ElsevierGlyph{E20C}'},
    10532: {LaTeXMode.textmode: '\\ElsevierGlyph{E20D}'},
    10533: {LaTeXMode.textmode: '\\ElsevierGlyph{E20B}', LaTeXMode.mathmode: '\\hksearow'},
    10534: {LaTeXMode.textmode: '\\ElsevierGlyph{E20A}', LaTeXMode.mathmode: '\\hkswarow'},
    10535: {LaTeXMode.textmode: '\\ElsevierGlyph{E211}', LaTeXMode.mathmode: '\\tona'},
    10536: {LaTeXMode.textmode: '\\ElsevierGlyph{E20E}', LaTeXMode.mathmode: '\\toea'},
    10537: {LaTeXMode.textmode: '\\ElsevierGlyph{E20F}', LaTeXMode.mathmode: '\\tosa'},
    10538: {LaTeXMode.textmode: '\\ElsevierGlyph{E210}', LaTeXMode.mathmode: '\\towa'},
    10539: {LaTeXMode.mathmode: '\\rdiagovfdiag'},
    10540: {LaTeXMode.mathmode: '\\fdiagovrdiag'},
    10541: {LaTeXMode.mathmode: '\\seovnearrow'},
    10542: {LaTeXMode.mathmode: '\\neovsearrow'},
    10543: {LaTeXMode.mathmode: '\\fdiagovnearrow'},
    10544: {LaTeXMode.mathmode: '\\rdiagovsearrow'},
    10545: {LaTeXMode.mathmode: '\\neovnwarrow'},
    10546: {LaTeXMode.mathmode: '\\nwovnearrow'},
    10547: {LaTeXMode.textmode: '\\ElsevierGlyph{E21D}'},
    10550: {LaTeXMode.textmode: '\\ElsevierGlyph{E21A}'},
    10551: {LaTeXMode.textmode: '\\ElsevierGlyph{E219}'},
    10560: {LaTeXMode.textmode: '\\Elolarr ', LaTeXMode.mathmode: '\\circlearrowleft'},
    10561: {LaTeXMode.textmode: '\\Elorarr ', LaTeXMode.mathmode: '\\circlearrowright'},
    10562: {LaTeXMode.textmode: '\\ElzRlarr '},
    10564: {LaTeXMode.textmode: '\\ElzrLarr '},
    10567: {LaTeXMode.textmode: '\\Elzrarrx '},
    10574: {LaTeXMode.textmode: '\\LeftRightVector '},
    10575: {LaTeXMode.textmode: '\\RightUpDownVector '},
    10576: {LaTeXMode.textmode: '\\DownLeftRightVector '},
    10577: {LaTeXMode.textmode: '\\LeftUpDownVector '},
    10578: {LaTeXMode.textmode: '\\LeftVectorBar '},
    10579: {LaTeXMode.textmode: '\\RightVectorBar '},
    10580: {LaTeXMode.textmode: '\\RightUpVectorBar '},
    10581: {LaTeXMode.textmode: '\\RightDownVectorBar '},
    10582: {LaTeXMode.textmode: '\\DownLeftVectorBar '},
    10583: {LaTeXMode.textmode: '\\DownRightVectorBar '},
    10584: {LaTeXMode.textmode: '\\LeftUpVectorBar '},
    10585: {LaTeXMode.textmode: '\\LeftDownVectorBar '},
    10586: {LaTeXMode.textmode: '\\LeftTeeVector '},
    10587: {LaTeXMode.textmode: '\\RightTeeVector '},
    10588: {LaTeXMode.textmode: '\\RightUpTeeVector '},
    10589: {LaTeXMode.textmode: '\\RightDownTeeVector '},
    10590: {LaTeXMode.textmode: '\\DownLeftTeeVector '},
    10591: {LaTeXMode.textmode: '\\DownRightTeeVector '},
    10592: {LaTeXMode.textmode: '\\LeftUpTeeVector '},
    10593: {LaTeXMode.textmode: '\\LeftDownTeeVector '},
    10606: {LaTeXMode.textmode: '\\UpEquilibrium '},
    10607: {LaTeXMode.textmode: '\\ReverseUpEquilibrium '},
    10608: {LaTeXMode.textmode: '\\RoundImplies '},
    10620: {LaTeXMode.textmode: '\\ElsevierGlyph{E214}'},
    10621: {LaTeXMode.textmode: '\\ElsevierGlyph{E215}'},
    10624: {LaTeXMode.textmode: '\\Elztfnc ', LaTeXMode.mathmode: '\\Vvert'},
    10629: {LaTeXMode.textmode: '\\ElsevierGlyph{3018}'},
    10630: {LaTeXMode.textmode: '\\Elroang '},
    10643: {LaTeXMode.textmode: '<\\kern-0.58em('},
    10644: {LaTeXMode.textmode: '\\ElsevierGlyph{E291}'},
    10649: {LaTeXMode.textmode: '\\Elzddfnc '},
    10652: {LaTeXMode.textmode: '\\Angle '},
    10656: {LaTeXMode.textmode: '\\Elzlpargt '},
    10677: {LaTeXMode.textmode: '\\ElsevierGlyph{E260}'},
    10678: {LaTeXMode.textmode: '\\ElsevierGlyph{E61B}'},
    10680: {LaTeXMode.mathmode: '\\obslash'},
    10692: {LaTeXMode.mathmode: '\\boxdiag'},
    10693: {LaTeXMode.mathmode: '\\boxbslash'},
    10694: {LaTeXMode.mathmode: '\\boxast'},
    10695: {LaTeXMode.mathmode: '\\boxcircle'},
    10698: {LaTeXMode.textmode: '\\ElzLap '},
    10699: {LaTeXMode.textmode: '\\Elzdefas '},
    10703: {LaTeXMode.textmode: '\\NotLeftTriangleBar '},
    10704: {LaTeXMode.textmode: '\\NotRightTriangleBar '},
    10716: {LaTeXMode.textmode: '\\ElsevierGlyph{E372}'},
    10719: {LaTeXMode.mathmode: '\\dualmap'},
    10722: {LaTeXMode.mathmode: '\\shuffle'},
    10731: {LaTeXMode.textmode: '\\blacklozenge ', LaTeXMode.mathmode: '\\blacklozenge'},
    10740: {LaTeXMode.textmode: '\\RuleDelayed '},
    10752: {LaTeXMode.mathmode: '\\bigodot'},
    10753: {LaTeXMode.mathmode: '\\bigoplus'},
    10754: {LaTeXMode.mathmode: '\\bigotimes'},
    10755: {LaTeXMode.mathmode: '\\bigcupdot'},
    10756: {LaTeXMode.textmode: '\\Elxuplus ', LaTeXMode.mathmode: '\\biguplus'},
    10757: {LaTeXMode.textmode: '\\ElzThr ', LaTeXMode.mathmode: '\\bigsqcap'},
    10758: {LaTeXMode.textmode: '\\Elxsqcup ', LaTeXMode.mathmode: '\\bigsqcup'},
    10759: {LaTeXMode.textmode: '\\ElzInf ', LaTeXMode.mathmode: '\\conjquant'},
    10760: {LaTeXMode.textmode: '\\ElzSup ', LaTeXMode.mathmode: '\\disjquant'},
    10761: {LaTeXMode.mathmode: '\\bigtimes'},
    10765: {LaTeXMode.textmode: '\\ElzCint ', LaTeXMode.mathmode: '\\intbar'},
    10766: {LaTeXMode.mathmode: '\\intBar'},
    10767: {LaTeXMode.textmode: '\\clockoint '},
    10768: {LaTeXMode.textmode: '\\ElsevierGlyph{E395}'},
    10774: {LaTeXMode.textmode: '\\sqrint '},
    10776: {LaTeXMode.mathmode: '\\intx'},
    10777: {LaTeXMode.mathmode: '\\intcap'},
    10778: {LaTeXMode.mathmode: '\\intcup'},
    10779: {LaTeXMode.mathmode: '\\upint'},
    10780: {LaTeXMode.mathmode: '\\lowint'},
    10789: {LaTeXMode.textmode: '\\ElsevierGlyph{E25A}', LaTeXMode.mathmode: '\\plusdot'},
    10794: {LaTeXMode.textmode: '\\ElsevierGlyph{E25B}', LaTeXMode.mathmode: '\\minusdot'},
    10797: {LaTeXMode.textmode: '\\ElsevierGlyph{E25C}'},
    10798: {LaTeXMode.textmode: '\\ElsevierGlyph{E25D}'},
    10799: {LaTeXMode.textmode: '\\ElzTimes '},
    10802: {LaTeXMode.mathmode: '\\btimes'},
    10804: {LaTeXMode.textmode: '\\ElsevierGlyph{E25E}'},
    10805: {LaTeXMode.textmode: '\\ElsevierGlyph{E25E}'},
    10812: {LaTeXMode.textmode: '\\ElsevierGlyph{E259}', LaTeXMode.mathmode: '\\intprod'},
    10813: {LaTeXMode.mathmode: '\\intprodr'},
    10815: {LaTeXMode.textmode: '\\amalg ', LaTeXMode.mathmode: '\\amalg'},
    10835: {LaTeXMode.textmode: '\\ElzAnd '},
    10836: {LaTeXMode.textmode: '\\ElzOr '},
    10837: {LaTeXMode.textmode: '\\ElsevierGlyph{E36E}'},
    10838: {LaTeXMode.textmode: '\\ElOr '},
    10846: {LaTeXMode.textmode: '\\perspcorrespond ', LaTeXMode.mathmode: '\\doublebarwedge'},
    10847: {LaTeXMode.textmode: '\\Elzminhat '},
    10851: {LaTeXMode.textmode: '\\ElsevierGlyph{225A}'},
    10862: {LaTeXMode.textmode: '\\stackrel{*}{=}'},
    10869: {LaTeXMode.textmode: '\\Equal '},
    10871: {LaTeXMode.mathmode: '\\ddotseq'},
    10877: {LaTeXMode.textmode: '\\nleqslant ', LaTeXMode.mathmode: '\\nleqslant'},
    10878: {LaTeXMode.textmode: '\\ngeqslant ', LaTeXMode.mathmode: '\\ngeqslant'},
    10885: {LaTeXMode.textmode: '\\lessapprox ', LaTeXMode.mathmode: '\\lessapprox'},
    10886: {LaTeXMode.textmode: '\\gtrapprox ', LaTeXMode.mathmode: '\\gtrapprox'},
    10887: {LaTeXMode.textmode: '\\lneq ', LaTeXMode.mathmode: '\\lneq'},
    10888: {LaTeXMode.textmode: '\\gneq ', LaTeXMode.mathmode: '\\gneq'},
    10889: {LaTeXMode.textmode: '\\lnapprox ', LaTeXMode.mathmode: '\\lnapprox'},
    10890: {LaTeXMode.textmode: '\\gnapprox ', LaTeXMode.mathmode: '\\gnapprox'},
    10891: {LaTeXMode.textmode: '\\lesseqqgtr ', LaTeXMode.mathmode: '\\lesseqqgtr'},
    10892: {LaTeXMode.textmode: '\\gtreqqless ', LaTeXMode.mathmode: '\\gtreqqless'},
    10901: {LaTeXMode.textmode: '\\eqslantless ', LaTeXMode.mathmode: '\\eqslantless'},
    10902: {LaTeXMode.textmode: '\\eqslantgtr ', LaTeXMode.mathmode: '\\eqslantgtr'},
    10909: {LaTeXMode.textmode: '\\Pisymbol{ppi020}{117}'},
    10910: {LaTeXMode.textmode: '\\Pisymbol{ppi020}{105}'},
    10913: {LaTeXMode.textmode: '\\NotNestedLessLess '},
    10914: {LaTeXMode.textmode: '\\NotNestedGreaterGreater '},
    10915: {LaTeXMode.mathmode: '\\partialmeetcontraction'},
    10926: {LaTeXMode.mathmode: '\\bumpeqq'},
    10927: {LaTeXMode.textmode: '\\not\\preceq ', LaTeXMode.mathmode: '\\npreceq'},
    10928: {LaTeXMode.textmode: '\\not\\succeq ', LaTeXMode.mathmode: '\\nsucceq'},
    10933: {LaTeXMode.textmode: '\\precneqq ', LaTeXMode.mathmode: '\\precneqq'},
    10934: {LaTeXMode.textmode: '\\succneqq ', LaTeXMode.mathmode: '\\succneqq'},
    10935: {LaTeXMode.textmode: '\\precapprox ', LaTeXMode.mathmode: '\\precapprox'},
    10936: {LaTeXMode.textmode: '\\succapprox ', LaTeXMode.mathmode: '\\succapprox'},
    10937: {LaTeXMode.textmode: '\\precnapprox ', LaTeXMode.mathmode: '\\precnapprox'},
    10938: {LaTeXMode.textmode: '\\succnapprox ', LaTeXMode.mathmode: '\\succnapprox'},
    10949: {LaTeXMode.textmode: '\\nsubseteqq ', LaTeXMode.mathmode: '\\nsubseteqq'},
    10950: {LaTeXMode.textmode: '\\nsupseteqq'},
    10955: {LaTeXMode.textmode: '\\subsetneqq ', LaTeXMode.mathmode: '\\subsetneqq'},
    10956: {LaTeXMode.textmode: '\\supsetneqq ', LaTeXMode.mathmode: '\\supsetneqq'},
    10971: {LaTeXMode.mathmode: '\\mlcp'},
    10973: {LaTeXMode.mathmode: '\\forks'},
    10979: {LaTeXMode.mathmode: '\\dashV'},
    10980: {LaTeXMode.mathmode: '\\Dashv'},
    10987: {LaTeXMode.textmode: '\\ElsevierGlyph{E30D}'},
    10996: {LaTeXMode.mathmode: '\\interleave'},
    10998: {LaTeXMode.textmode: '\\Elztdcol '},
    11005: {LaTeXMode.textmode: '{\\rlap{\\textbackslash}{{/}\\!\\!{/}}}'},
    12298: {LaTeXMode.textmode: '\\ElsevierGlyph{300A}'},
    12299: {LaTeXMode.textmode: '\\ElsevierGlyph{300B}'},
    12312: {LaTeXMode.textmode: '\\ElsevierGlyph{3018}'},
    12313: {LaTeXMode.textmode: '\\ElsevierGlyph{3019}'},
    12314: {LaTeXMode.textmode: '\\openbracketleft '},
    12315: {LaTeXMode.textmode: '\\openbracketright '},
    64256: {LaTeXMode.textmode: 'ff'},
    64257: {LaTeXMode.textmode: 'fi'},
    64258: {LaTeXMode.textmode: 'fl'},
    64259: {LaTeXMode.textmode: 'ffi'},
    64260: {LaTeXMode.textmode: 'ffl'},
    65024: {LaTeXMode.textmode: '\\varsupsetneq ', LaTeXMode.mathmode: '\\varsupsetneq'},
    119808: {LaTeXMode.textmode: '\\mathbf{A}'},
    119809: {LaTeXMode.textmode: '\\mathbf{B}'},
    119810: {LaTeXMode.textmode: '\\mathbf{C}'},
    119811: {LaTeXMode.textmode: '\\mathbf{D}'},
    119812: {LaTeXMode.textmode: '\\mathbf{E}'},
    119813: {LaTeXMode.textmode: '\\mathbf{F}'},
    119814: {LaTeXMode.textmode: '\\mathbf{G}'},
    119815: {LaTeXMode.textmode: '\\mathbf{H}'},
    119816: {LaTeXMode.textmode: '\\mathbf{I}'},
    119817: {LaTeXMode.textmode: '\\mathbf{J}'},
    119818: {LaTeXMode.textmode: '\\mathbf{K}'},
    119819: {LaTeXMode.textmode: '\\mathbf{L}'},
    119820: {LaTeXMode.textmode: '\\mathbf{M}'},
    119821: {LaTeXMode.textmode: '\\mathbf{N}'},
    119822: {LaTeXMode.textmode: '\\mathbf{O}'},
    119823: {LaTeXMode.textmode: '\\mathbf{P}'},
    119824: {LaTeXMode.textmode: '\\mathbf{Q}'},
    119825: {LaTeXMode.textmode: '\\mathbf{R}'},
    119826: {LaTeXMode.textmode: '\\mathbf{S}'},
    119827: {LaTeXMode.textmode: '\\mathbf{T}'},
    119828: {LaTeXMode.textmode: '\\mathbf{U}'},
    119829: {LaTeXMode.textmode: '\\mathbf{V}'},
    119830: {LaTeXMode.textmode: '\\mathbf{W}'},
    119831: {LaTeXMode.textmode: '\\mathbf{X}'},
    119832: {LaTeXMode.textmode: '\\mathbf{Y}'},
    119833: {LaTeXMode.textmode: '\\mathbf{Z}'},
    119834: {LaTeXMode.textmode: '\\mathbf{a}'},
    119835: {LaTeXMode.textmode: '\\mathbf{b}'},
    119836: {LaTeXMode.textmode: '\\mathbf{c}'},
    119837: {LaTeXMode.textmode: '\\mathbf{d}'},
    119838: {LaTeXMode.textmode: '\\mathbf{e}'},
    119839: {LaTeXMode.textmode: '\\mathbf{f}'},
    119840: {LaTeXMode.textmode: '\\mathbf{g}'},
    119841: {LaTeXMode.textmode: '\\mathbf{h}'},
    119842: {LaTeXMode.textmode: '\\mathbf{i}'},
    119843: {LaTeXMode.textmode: '\\mathbf{j}'},
    119844: {LaTeXMode.textmode: '\\mathbf{k}'},
    119845: {LaTeXMode.textmode: '\\mathbf{l}'},
    119846: {LaTeXMode.textmode: '\\mathbf{m}'},
    119847: {LaTeXMode.textmode: '\\mathbf{n}'},
    119848: {LaTeXMode.textmode: '\\mathbf{o}'},
    119849: {LaTeXMode.textmode: '\\mathbf{p}'},
    119850: {LaTeXMode.textmode: '\\mathbf{q}'},
    119851: {LaTeXMode.textmode: '\\mathbf{r}'},
    119852: {LaTeXMode.textmode: '\\mathbf{s}'},
    119853: {LaTeXMode.textmode: '\\mathbf{t}'},
    119854: {LaTeXMode.textmode: '\\mathbf{u}'},
    119855: {LaTeXMode.textmode: '\\mathbf{v}'},
    119856: {LaTeXMode.textmode: '\\mathbf{w}'},
    119857: {LaTeXMode.textmode: '\\mathbf{x}'},
    119858: {LaTeXMode.textmode: '\\mathbf{y}'},
    119859: {LaTeXMode.textmode: '\\mathbf{z}'},
    119860: {LaTeXMode.textmode: '\\mathmit{A}'},
    119861: {LaTeXMode.textmode: '\\mathmit{B}'},
    119862: {LaTeXMode.textmode: '\\mathmit{C}'},
    119863: {LaTeXMode.textmode: '\\mathmit{D}'},
    119864: {LaTeXMode.textmode: '\\mathmit{E}'},
    119865: {LaTeXMode.textmode: '\\mathmit{F}'},
    119866: {LaTeXMode.textmode: '\\mathmit{G}'},
    119867: {LaTeXMode.textmode: '\\mathmit{H}'},
    119868: {LaTeXMode.textmode: '\\mathmit{I}'},
    119869: {LaTeXMode.textmode: '\\mathmit{J}'},
    119870: {LaTeXMode.textmode: '\\mathmit{K}'},
    119871: {LaTeXMode.textmode: '\\mathmit{L}'},
    119872: {LaTeXMode.textmode: '\\mathmit{M}'},
    119873: {LaTeXMode.textmode: '\\mathmit{N}'},
    119874: {LaTeXMode.textmode: '\\mathmit{O}'},
    119875: {LaTeXMode.textmode: '\\mathmit{P}'},
    119876: {LaTeXMode.textmode: '\\mathmit{Q}'},
    119877: {LaTeXMode.textmode: '\\mathmit{R}'},
    119878: {LaTeXMode.textmode: '\\mathmit{S}'},
    119879: {LaTeXMode.textmode: '\\mathmit{T}'},
    119880: {LaTeXMode.textmode: '\\mathmit{U}'},
    119881: {LaTeXMode.textmode: '\\mathmit{V}'},
    119882: {LaTeXMode.textmode: '\\mathmit{W}'},
    119883: {LaTeXMode.textmode: '\\mathmit{X}'},
    119884: {LaTeXMode.textmode: '\\mathmit{Y}'},
    119885: {LaTeXMode.textmode: '\\mathmit{Z}'},
    119886: {LaTeXMode.textmode: '\\mathmit{a}'},
    119887: {LaTeXMode.textmode: '\\mathmit{b}'},
    119888: {LaTeXMode.textmode: '\\mathmit{c}'},
    119889: {LaTeXMode.textmode: '\\mathmit{d}'},
    119890: {LaTeXMode.textmode: '\\mathmit{e}'},
    119891: {LaTeXMode.textmode: '\\mathmit{f}'},
    119892: {LaTeXMode.textmode: '\\mathmit{g}'},
    119894: {LaTeXMode.textmode: '\\mathmit{i}'},
    119895: {LaTeXMode.textmode: '\\mathmit{j}'},
    119896: {LaTeXMode.textmode: '\\mathmit{k}'},
    119897: {LaTeXMode.textmode: '\\mathmit{l}'},
    119898: {LaTeXMode.textmode: '\\mathmit{m}'},
    119899: {LaTeXMode.textmode: '\\mathmit{n}'},
    119900: {LaTeXMode.textmode: '\\mathmit{o}'},
    119901: {LaTeXMode.textmode: '\\mathmit{p}'},
    119902: {LaTeXMode.textmode: '\\mathmit{q}'},
    119903: {LaTeXMode.textmode: '\\mathmit{r}'},
    119904: {LaTeXMode.textmode: '\\mathmit{s}'},
    119905: {LaTeXMode.textmode: '\\mathmit{t}'},
    119906: {LaTeXMode.textmode: '\\mathmit{u}'},
    119907: {LaTeXMode.textmode: '\\mathmit{v}'},
    119908: {LaTeXMode.textmode: '\\mathmit{w}'},
    119909: {LaTeXMode.textmode: '\\mathmit{x}'},
    119910: {LaTeXMode.textmode: '\\mathmit{y}'},
    119911: {LaTeXMode.textmode: '\\mathmit{z}'},
    119912: {LaTeXMode.textmode: '\\mathbit{A}'},
    119913: {LaTeXMode.textmode: '\\mathbit{B}'},
    119914: {LaTeXMode.textmode: '\\mathbit{C}'},
    119915: {LaTeXMode.textmode: '\\mathbit{D}'},
    119916: {LaTeXMode.textmode: '\\mathbit{E}'},
    119917: {LaTeXMode.textmode: '\\mathbit{F}'},
    119918: {LaTeXMode.textmode: '\\mathbit{G}'},
    119919: {LaTeXMode.textmode: '\\mathbit{H}'},
    119920: {LaTeXMode.textmode: '\\mathbit{I}'},
    119921: {LaTeXMode.textmode: '\\mathbit{J}'},
    119922: {LaTeXMode.textmode: '\\mathbit{K}'},
    119923: {LaTeXMode.textmode: '\\mathbit{L}'},
    119924: {LaTeXMode.textmode: '\\mathbit{M}'},
    119925: {LaTeXMode.textmode: '\\mathbit{N}'},
    119926: {LaTeXMode.textmode: '\\mathbit{O}'},
    119927: {LaTeXMode.textmode: '\\mathbit{P}'},
    119928: {LaTeXMode.textmode: '\\mathbit{Q}'},
    119929: {LaTeXMode.textmode: '\\mathbit{R}'},
    119930: {LaTeXMode.textmode: '\\mathbit{S}'},
    119931: {LaTeXMode.textmode: '\\mathbit{T}'},
    119932: {LaTeXMode.textmode: '\\mathbit{U}'},
    119933: {LaTeXMode.textmode: '\\mathbit{V}'},
    119934: {LaTeXMode.textmode: '\\mathbit{W}'},
    119935: {LaTeXMode.textmode: '\\mathbit{X}'},
    119936: {LaTeXMode.textmode: '\\mathbit{Y}'},
    119937: {LaTeXMode.textmode: '\\mathbit{Z}'},
    119938: {LaTeXMode.textmode: '\\mathbit{a}'},
    119939: {LaTeXMode.textmode: '\\mathbit{b}'},
    119940: {LaTeXMode.textmode: '\\mathbit{c}'},
    119941: {LaTeXMode.textmode: '\\mathbit{d}'},
    119942: {LaTeXMode.textmode: '\\mathbit{e}'},
    119943: {LaTeXMode.textmode: '\\mathbit{f}'},
    119944: {LaTeXMode.textmode: '\\mathbit{g}'},
    119945: {LaTeXMode.textmode: '\\mathbit{h}'},
    119946: {LaTeXMode.textmode: '\\mathbit{i}'},
    119947: {LaTeXMode.textmode: '\\mathbit{j}'},
    119948: {LaTeXMode.textmode: '\\mathbit{k}'},
    119949: {LaTeXMode.textmode: '\\mathbit{l}'},
    119950: {LaTeXMode.textmode: '\\mathbit{m}'},
    119951: {LaTeXMode.textmode: '\\mathbit{n}'},
    119952: {LaTeXMode.textmode: '\\mathbit{o}'},
    119953: {LaTeXMode.textmode: '\\mathbit{p}'},
    119954: {LaTeXMode.textmode: '\\mathbit{q}'},
    119955: {LaTeXMode.textmode: '\\mathbit{r}'},
    119956: {LaTeXMode.textmode: '\\mathbit{s}'},
    119957: {LaTeXMode.textmode: '\\mathbit{t}'},
    119958: {LaTeXMode.textmode: '\\mathbit{u}'},
    119959: {LaTeXMode.textmode: '\\mathbit{v}'},
    119960: {LaTeXMode.textmode: '\\mathbit{w}'},
    119961: {LaTeXMode.textmode: '\\mathbit{x}'},
    119962: {LaTeXMode.textmode: '\\mathbit{y}'},
    119963: {LaTeXMode.textmode: '\\mathbit{z}'},
    119964: {LaTeXMode.textmode: '\\mathscr{A}'},
    119966: {LaTeXMode.textmode: '\\mathscr{C}'},
    119967: {LaTeXMode.textmode: '\\mathscr{D}'},
    119970: {LaTeXMode.textmode: '\\mathscr{G}'},
    119973: {LaTeXMode.textmode: '\\mathscr{J}'},
    119974: {LaTeXMode.textmode: '\\mathscr{K}'},
    119977: {LaTeXMode.textmode: '\\mathscr{N}'},
    119978: {LaTeXMode.textmode: '\\mathscr{O}'},
    119979: {LaTeXMode.textmode: '\\mathscr{P}'},
    119980: {LaTeXMode.textmode: '\\mathscr{Q}'},
    119982: {LaTeXMode.textmode: '\\mathscr{S}'},
    119983: {LaTeXMode.textmode: '\\mathscr{T}'},
    119984: {LaTeXMode.textmode: '\\mathscr{U}'},
    119985: {LaTeXMode.textmode: '\\mathscr{V}'},
    119986: {LaTeXMode.textmode: '\\mathscr{W}'},
    119987: {LaTeXMode.textmode: '\\mathscr{X}'},
    119988: {LaTeXMode.textmode: '\\mathscr{Y}'},
    119989: {LaTeXMode.textmode: '\\mathscr{Z}'},
    119990: {LaTeXMode.textmode: '\\mathscr{a}'},
    119991: {LaTeXMode.textmode: '\\mathscr{b}'},
    119992: {LaTeXMode.textmode: '\\mathscr{c}'},
    119993: {LaTeXMode.textmode: '\\mathscr{d}'},
    119995: {LaTeXMode.textmode: '\\mathscr{f}'},
    119997: {LaTeXMode.textmode: '\\mathscr{h}'},
    119998: {LaTeXMode.textmode: '\\mathscr{i}'},
    119999: {LaTeXMode.textmode: '\\mathscr{j}'},
    120000: {LaTeXMode.textmode: '\\mathscr{k}'},
    120001: {LaTeXMode.textmode: '\\mathscr{l}'},
    120002: {LaTeXMode.textmode: '\\mathscr{m}'},
    120003: {LaTeXMode.textmode: '\\mathscr{n}'},
    120005: {LaTeXMode.textmode: '\\mathscr{p}'},
    120006: {LaTeXMode.textmode: '\\mathscr{q}'},
    120007: {LaTeXMode.textmode: '\\mathscr{r}'},
    120008: {LaTeXMode.textmode: '\\mathscr{s}'},
    120009: {LaTeXMode.textmode: '\\mathscr{t}'},
    120010: {LaTeXMode.textmode: '\\mathscr{u}'},
    120011: {LaTeXMode.textmode: '\\mathscr{v}'},
    120012: {LaTeXMode.textmode: '\\mathscr{w}'},
    120013: {LaTeXMode.textmode: '\\mathscr{x}'},
    120014: {LaTeXMode.textmode: '\\mathscr{y}'},
    120015: {LaTeXMode.textmode: '\\mathscr{z}'},
    120016: {LaTeXMode.textmode: '\\mathbcal{A}'},
    120017: {LaTeXMode.textmode: '\\mathbcal{B}'},
    120018: {LaTeXMode.textmode: '\\mathbcal{C}'},
    120019: {LaTeXMode.textmode: '\\mathbcal{D}'},
    120020: {LaTeXMode.textmode: '\\mathbcal{E}'},
    120021: {LaTeXMode.textmode: '\\mathbcal{F}'},
    120022: {LaTeXMode.textmode: '\\mathbcal{G}'},
    120023: {LaTeXMode.textmode: '\\mathbcal{H}'},
    120024: {LaTeXMode.textmode: '\\mathbcal{I}'},
    120025: {LaTeXMode.textmode: '\\mathbcal{J}'},
    120026: {LaTeXMode.textmode: '\\mathbcal{K}'},
    120027: {LaTeXMode.textmode: '\\mathbcal{L}'},
    120028: {LaTeXMode.textmode: '\\mathbcal{M}'},
    120029: {LaTeXMode.textmode: '\\mathbcal{N}'},
    120030: {LaTeXMode.textmode: '\\mathbcal{O}'},
    120031: {LaTeXMode.textmode: '\\mathbcal{P}'},
    120032: {LaTeXMode.textmode: '\\mathbcal{Q}'},
    120033: {LaTeXMode.textmode: '\\mathbcal{R}'},
    120034: {LaTeXMode.textmode: '\\mathbcal{S}'},
    120035: {LaTeXMode.textmode: '\\mathbcal{T}'},
    120036: {LaTeXMode.textmode: '\\mathbcal{U}'},
    120037: {LaTeXMode.textmode: '\\mathbcal{V}'},
    120038: {LaTeXMode.textmode: '\\mathbcal{W}'},
    120039: {LaTeXMode.textmode: '\\mathbcal{X}'},
    120040: {LaTeXMode.textmode: '\\mathbcal{Y}'},
    120041: {LaTeXMode.textmode: '\\mathbcal{Z}'},
    120042: {LaTeXMode.textmode: '\\mathbcal{a}'},
    120043: {LaTeXMode.textmode: '\\mathbcal{b}'},
    120044: {LaTeXMode.textmode: '\\mathbcal{c}'},
    120045: {LaTeXMode.textmode: '\\mathbcal{d}'},
    120046: {LaTeXMode.textmode: '\\mathbcal{e}'},
    120047: {LaTeXMode.textmode: '\\mathbcal{f}'},
    120048: {LaTeXMode.textmode: '\\mathbcal{g}'},
    120049: {LaTeXMode.textmode: '\\mathbcal{h}'},
    120050: {LaTeXMode.textmode: '\\mathbcal{i}'},
    120051: {LaTeXMode.textmode: '\\mathbcal{j}'},
    120052: {LaTeXMode.textmode: '\\mathbcal{k}'},
    120053: {LaTeXMode.textmode: '\\mathbcal{l}'},
    120054: {LaTeXMode.textmode: '\\mathbcal{m}'},
    120055: {LaTeXMode.textmode: '\\mathbcal{n}'},
    120056: {LaTeXMode.textmode: '\\mathbcal{o}'},
    120057: {LaTeXMode.textmode: '\\mathbcal{p}'},
    120058: {LaTeXMode.textmode: '\\mathbcal{q}'},
    120059: {LaTeXMode.textmode: '\\mathbcal{r}'},
    120060: {LaTeXMode.textmode: '\\mathbcal{s}'},
    120061: {LaTeXMode.textmode: '\\mathbcal{t}'},
    120062: {LaTeXMode.textmode: '\\mathbcal{u}'},
    120063: {LaTeXMode.textmode: '\\mathbcal{v}'},
    120064: {LaTeXMode.textmode: '\\mathbcal{w}'},
    120065: {LaTeXMode.textmode: '\\mathbcal{x}'},
    120066: {LaTeXMode.textmode: '\\mathbcal{y}'},
    120067: {LaTeXMode.textmode: '\\mathbcal{z}'},
    120068: {LaTeXMode.textmode: '\\mathfrak{A}'},
    120069: {LaTeXMode.textmode: '\\mathfrak{B}'},
    120071: {LaTeXMode.textmode: '\\mathfrak{D}'},
    120072: {LaTeXMode.textmode: '\\mathfrak{E}'},
    120073: {LaTeXMode.textmode: '\\mathfrak{F}'},
    120074: {LaTeXMode.textmode: '\\mathfrak{G}'},
    120077: {LaTeXMode.textmode: '\\mathfrak{J}'},
    120078: {LaTeXMode.textmode: '\\mathfrak{K}'},
    120079: {LaTeXMode.textmode: '\\mathfrak{L}'},
    120080: {LaTeXMode.textmode: '\\mathfrak{M}'},
    120081: {LaTeXMode.textmode: '\\mathfrak{N}'},
    120082: {LaTeXMode.textmode: '\\mathfrak{O}'},
    120083: {LaTeXMode.textmode: '\\mathfrak{P}'},
    120084: {LaTeXMode.textmode: '\\mathfrak{Q}'},
    120086: {LaTeXMode.textmode: '\\mathfrak{S}'},
    120087: {LaTeXMode.textmode: '\\mathfrak{T}'},
    120088: {LaTeXMode.textmode: '\\mathfrak{U}'},
    120089: {LaTeXMode.textmode: '\\mathfrak{V}'},
    120090: {LaTeXMode.textmode: '\\mathfrak{W}'},
    120091: {LaTeXMode.textmode: '\\mathfrak{X}'},
    120092: {LaTeXMode.textmode: '\\mathfrak{Y}'},
    120094: {LaTeXMode.textmode: '\\mathfrak{a}'},
    120095: {LaTeXMode.textmode: '\\mathfrak{b}'},
    120096: {LaTeXMode.textmode: '\\mathfrak{c}'},
    120097: {LaTeXMode.textmode: '\\mathfrak{d}'},
    120098: {LaTeXMode.textmode: '\\mathfrak{e}'},
    120099: {LaTeXMode.textmode: '\\mathfrak{f}'},
    120100: {LaTeXMode.textmode: '\\mathfrak{g}'},
    120101: {LaTeXMode.textmode: '\\mathfrak{h}'},
    120102: {LaTeXMode.textmode: '\\mathfrak{i}'},
    120103: {LaTeXMode.textmode: '\\mathfrak{j}'},
    120104: {LaTeXMode.textmode: '\\mathfrak{k}'},
    120105: {LaTeXMode.textmode: '\\mathfrak{l}'},
    120106: {LaTeXMode.textmode: '\\mathfrak{m}'},
    120107: {LaTeXMode.textmode: '\\mathfrak{n}'},
    120108: {LaTeXMode.textmode: '\\mathfrak{o}'},
    120109: {LaTeXMode.textmode: '\\mathfrak{p}'},
    120110: {LaTeXMode.textmode: '\\mathfrak{q}'},
    120111: {LaTeXMode.textmode: '\\mathfrak{r}'},
    120112: {LaTeXMode.textmode: '\\mathfrak{s}'},
    120113: {LaTeXMode.textmode: '\\mathfrak{t}'},
    120114: {LaTeXMode.textmode: '\\mathfrak{u}'},
    120115: {LaTeXMode.textmode: '\\mathfrak{v}'},
    120116: {LaTeXMode.textmode: '\\mathfrak{w}'},
    120117: {LaTeXMode.textmode: '\\mathfrak{x}'},
    120118: {LaTeXMode.textmode: '\\mathfrak{y}'},
    120119: {LaTeXMode.textmode: '\\mathfrak{z}'},
    120120: {LaTeXMode.textmode: '\\mathbb{A}'},
    120121: {LaTeXMode.textmode: '\\mathbb{B}'},
    120123: {LaTeXMode.textmode: '\\mathbb{D}'},
    120124: {LaTeXMode.textmode: '\\mathbb{E}'},
    120125: {LaTeXMode.textmode: '\\mathbb{F}'},
    120126: {LaTeXMode.textmode: '\\mathbb{G}'},
    120128: {LaTeXMode.textmode: '\\mathbb{I}'},
    120129: {LaTeXMode.textmode: '\\mathbb{J}'},
    120130: {LaTeXMode.textmode: '\\mathbb{K}'},
    120131: {LaTeXMode.textmode: '\\mathbb{L}'},
    120132: {LaTeXMode.textmode: '\\mathbb{M}'},
    120134: {LaTeXMode.textmode: '\\mathbb{O}'},
    120138: {LaTeXMode.textmode: '\\mathbb{S}'},
    120139: {LaTeXMode.textmode: '\\mathbb{T}'},
    120140: {LaTeXMode.textmode: '\\mathbb{U}'},
    120141: {LaTeXMode.textmode: '\\mathbb{V}'},
    120142: {LaTeXMode.textmode: '\\mathbb{W}'},
    120143: {LaTeXMode.textmode: '\\mathbb{X}'},
    120144: {LaTeXMode.textmode: '\\mathbb{Y}'},
    120146: {LaTeXMode.textmode: '\\mathbb{a}'},
    120147: {LaTeXMode.textmode: '\\mathbb{b}'},
    120148: {LaTeXMode.textmode: '\\mathbb{c}'},
    120149: {LaTeXMode.textmode: '\\mathbb{d}'},
    120150: {LaTeXMode.textmode: '\\mathbb{e}'},
    120151: {LaTeXMode.textmode: '\\mathbb{f}'},
    120152: {LaTeXMode.textmode: '\\mathbb{g}'},
    120153: {LaTeXMode.textmode: '\\mathbb{h}'},
    120154: {LaTeXMode.textmode: '\\mathbb{i}'},
    120155: {LaTeXMode.textmode: '\\mathbb{j}'},
    120156: {LaTeXMode.textmode: '\\mathbb{k}'},
    120157: {LaTeXMode.textmode: '\\mathbb{l}'},
    120158: {LaTeXMode.textmode: '\\mathbb{m}'},
    120159: {LaTeXMode.textmode: '\\mathbb{n}'},
    120160: {LaTeXMode.textmode: '\\mathbb{o}'},
    120161: {LaTeXMode.textmode: '\\mathbb{p}'},
    120162: {LaTeXMode.textmode: '\\mathbb{q}'},
    120163: {LaTeXMode.textmode: '\\mathbb{r}'},
    120164: {LaTeXMode.textmode: '\\mathbb{s}'},
    120165: {LaTeXMode.textmode: '\\mathbb{t}'},
    120166: {LaTeXMode.textmode: '\\mathbb{u}'},
    120167: {LaTeXMode.textmode: '\\mathbb{v}'},
    120168: {LaTeXMode.textmode: '\\mathbb{w}'},
    120169: {LaTeXMode.textmode: '\\mathbb{x}'},
    120170: {LaTeXMode.textmode: '\\mathbb{y}'},
    120171: {LaTeXMode.textmode: '\\mathbb{z}'},
    120172: {LaTeXMode.textmode: '\\mathbfrak{A}'},
    120173: {LaTeXMode.textmode: '\\mathbfrak{B}'},
    120174: {LaTeXMode.textmode: '\\mathbfrak{C}'},
    120175: {LaTeXMode.textmode: '\\mathbfrak{D}'},
    120176: {LaTeXMode.textmode: '\\mathbfrak{E}'},
    120177: {LaTeXMode.textmode: '\\mathbfrak{F}'},
    120178: {LaTeXMode.textmode: '\\mathbfrak{G}'},
    120179: {LaTeXMode.textmode: '\\mathbfrak{H}'},
    120180: {LaTeXMode.textmode: '\\mathbfrak{I}'},
    120181: {LaTeXMode.textmode: '\\mathbfrak{J}'},
    120182: {LaTeXMode.textmode: '\\mathbfrak{K}'},
    120183: {LaTeXMode.textmode: '\\mathbfrak{L}'},
    120184: {LaTeXMode.textmode: '\\mathbfrak{M}'},
    120185: {LaTeXMode.textmode: '\\mathbfrak{N}'},
    120186: {LaTeXMode.textmode: '\\mathbfrak{O}'},
    120187: {LaTeXMode.textmode: '\\mathbfrak{P}'},
    120188: {LaTeXMode.textmode: '\\mathbfrak{Q}'},
    120189: {LaTeXMode.textmode: '\\mathbfrak{R}'},
    120190: {LaTeXMode.textmode: '\\mathbfrak{S}'},
    120191: {LaTeXMode.textmode: '\\mathbfrak{T}'},
    120192: {LaTeXMode.textmode: '\\mathbfrak{U}'},
    120193: {LaTeXMode.textmode: '\\mathbfrak{V}'},
    120194: {LaTeXMode.textmode: '\\mathbfrak{W}'},
    120195: {LaTeXMode.textmode: '\\mathbfrak{X}'},
    120196: {LaTeXMode.textmode: '\\mathbfrak{Y}'},
    120197: {LaTeXMode.textmode: '\\mathbfrak{Z}'},
    120198: {LaTeXMode.textmode: '\\mathbfrak{a}'},
    120199: {LaTeXMode.textmode: '\\mathbfrak{b}'},
    120200: {LaTeXMode.textmode: '\\mathbfrak{c}'},
    120201: {LaTeXMode.textmode: '\\mathbfrak{d}'},
    120202: {LaTeXMode.textmode: '\\mathbfrak{e}'},
    120203: {LaTeXMode.textmode: '\\mathbfrak{f}'},
    120204: {LaTeXMode.textmode: '\\mathbfrak{g}'},
    120205: {LaTeXMode.textmode: '\\mathbfrak{h}'},
    120206: {LaTeXMode.textmode: '\\mathbfrak{i}'},
    120207: {LaTeXMode.textmode: '\\mathbfrak{j}'},
    120208: {LaTeXMode.textmode: '\\mathbfrak{k}'},
    120209: {LaTeXMode.textmode: '\\mathbfrak{l}'},
    120210: {LaTeXMode.textmode: '\\mathbfrak{m}'},
    120211: {LaTeXMode.textmode: '\\mathbfrak{n}'},
    120212: {LaTeXMode.textmode: '\\mathbfrak{o}'},
    120213: {LaTeXMode.textmode: '\\mathbfrak{p}'},
    120214: {LaTeXMode.textmode: '\\mathbfrak{q}'},
    120215: {LaTeXMode.textmode: '\\mathbfrak{r}'},
    120216: {LaTeXMode.textmode: '\\mathbfrak{s}'},
    120217: {LaTeXMode.textmode: '\\mathbfrak{t}'},
    120218: {LaTeXMode.textmode: '\\mathbfrak{u}'},
    120219: {LaTeXMode.textmode: '\\mathbfrak{v}'},
    120220: {LaTeXMode.textmode: '\\mathbfrak{w}'},
    120221: {LaTeXMode.textmode: '\\mathbfrak{x}'},
    120222: {LaTeXMode.textmode: '\\mathbfrak{y}'},
    120223: {LaTeXMode.textmode: '\\mathbfrak{z}'},
    120224: {LaTeXMode.textmode: '\\mathsf{A}'},
    120225: {LaTeXMode.textmode: '\\mathsf{B}'},
    120226: {LaTeXMode.textmode: '\\mathsf{C}'},
    120227: {LaTeXMode.textmode: '\\mathsf{D}'},
    120228: {LaTeXMode.textmode: '\\mathsf{E}'},
    120229: {LaTeXMode.textmode: '\\mathsf{F}'},
    120230: {LaTeXMode.textmode: '\\mathsf{G}'},
    120231: {LaTeXMode.textmode: '\\mathsf{H}'},
    120232: {LaTeXMode.textmode: '\\mathsf{I}'},
    120233: {LaTeXMode.textmode: '\\mathsf{J}'},
    120234: {LaTeXMode.textmode: '\\mathsf{K}'},
    120235: {LaTeXMode.textmode: '\\mathsf{L}'},
    120236: {LaTeXMode.textmode: '\\mathsf{M}'},
    120237: {LaTeXMode.textmode: '\\mathsf{N}'},
    120238: {LaTeXMode.textmode: '\\mathsf{O}'},
    120239: {LaTeXMode.textmode: '\\mathsf{P}'},
    120240: {LaTeXMode.textmode: '\\mathsf{Q}'},
    120241: {LaTeXMode.textmode: '\\mathsf{R}'},
    120242: {LaTeXMode.textmode: '\\mathsf{S}'},
    120243: {LaTeXMode.textmode: '\\mathsf{T}'},
    120244: {LaTeXMode.textmode: '\\mathsf{U}'},
    120245: {LaTeXMode.textmode: '\\mathsf{V}'},
    120246: {LaTeXMode.textmode: '\\mathsf{W}'},
    120247: {LaTeXMode.textmode: '\\mathsf{X}'},
    120248: {LaTeXMode.textmode: '\\mathsf{Y}'},
    120249: {LaTeXMode.textmode: '\\mathsf{Z}'},
    120250: {LaTeXMode.textmode: '\\mathsf{a}'},
    120251: {LaTeXMode.textmode: '\\mathsf{b}'},
    120252: {LaTeXMode.textmode: '\\mathsf{c}'},
    120253: {LaTeXMode.textmode: '\\mathsf{d}'},
    120254: {LaTeXMode.textmode: '\\mathsf{e}'},
    120255: {LaTeXMode.textmode: '\\mathsf{f}'},
    120256: {LaTeXMode.textmode: '\\mathsf{g}'},
    120257: {LaTeXMode.textmode: '\\mathsf{h}'},
    120258: {LaTeXMode.textmode: '\\mathsf{i}'},
    120259: {LaTeXMode.textmode: '\\mathsf{j}'},
    120260: {LaTeXMode.textmode: '\\mathsf{k}'},
    120261: {LaTeXMode.textmode: '\\mathsf{l}'},
    120262: {LaTeXMode.textmode: '\\mathsf{m}'},
    120263: {LaTeXMode.textmode: '\\mathsf{n}'},
    120264: {LaTeXMode.textmode: '\\mathsf{o}'},
    120265: {LaTeXMode.textmode: '\\mathsf{p}'},
    120266: {LaTeXMode.textmode: '\\mathsf{q}'},
    120267: {LaTeXMode.textmode: '\\mathsf{r}'},
    120268: {LaTeXMode.textmode: '\\mathsf{s}'},
    120269: {LaTeXMode.textmode: '\\mathsf{t}'},
    120270: {LaTeXMode.textmode: '\\mathsf{u}'},
    120271: {LaTeXMode.textmode: '\\mathsf{v}'},
    120272: {LaTeXMode.textmode: '\\mathsf{w}'},
    120273: {LaTeXMode.textmode: '\\mathsf{x}'},
    120274: {LaTeXMode.textmode: '\\mathsf{y}'},
    120275: {LaTeXMode.textmode: '\\mathsf{z}'},
    120276: {LaTeXMode.textmode: '\\mathsfbf{A}'},
    120277: {LaTeXMode.textmode: '\\mathsfbf{B}'},
    120278: {LaTeXMode.textmode: '\\mathsfbf{C}'},
    120279: {LaTeXMode.textmode: '\\mathsfbf{D}'},
    120280: {LaTeXMode.textmode: '\\mathsfbf{E}'},
    120281: {LaTeXMode.textmode: '\\mathsfbf{F}'},
    120282: {LaTeXMode.textmode: '\\mathsfbf{G}'},
    120283: {LaTeXMode.textmode: '\\mathsfbf{H}'},
    120284: {LaTeXMode.textmode: '\\mathsfbf{I}'},
    120285: {LaTeXMode.textmode: '\\mathsfbf{J}'},
    120286: {LaTeXMode.textmode: '\\mathsfbf{K}'},
    120287: {LaTeXMode.textmode: '\\mathsfbf{L}'},
    120288: {LaTeXMode.textmode: '\\mathsfbf{M}'},
    120289: {LaTeXMode.textmode: '\\mathsfbf{N}'},
    120290: {LaTeXMode.textmode: '\\mathsfbf{O}'},
    120291: {LaTeXMode.textmode: '\\mathsfbf{P}'},
    120292: {LaTeXMode.textmode: '\\mathsfbf{Q}'},
    120293: {LaTeXMode.textmode: '\\mathsfbf{R}'},
    120294: {LaTeXMode.textmode: '\\mathsfbf{S}'},
    120295: {LaTeXMode.textmode: '\\mathsfbf{T}'},
    120296: {LaTeXMode.textmode: '\\mathsfbf{U}'},
    120297: {LaTeXMode.textmode: '\\mathsfbf{V}'},
    120298: {LaTeXMode.textmode: '\\mathsfbf{W}'},
    120299: {LaTeXMode.textmode: '\\mathsfbf{X}'},
    120300: {LaTeXMode.textmode: '\\mathsfbf{Y}'},
    120301: {LaTeXMode.textmode: '\\mathsfbf{Z}'},
    120302: {LaTeXMode.textmode: '\\mathsfbf{a}'},
    120303: {LaTeXMode.textmode: '\\mathsfbf{b}'},
    120304: {LaTeXMode.textmode: '\\mathsfbf{c}'},
    120305: {LaTeXMode.textmode: '\\mathsfbf{d}'},
    120306: {LaTeXMode.textmode: '\\mathsfbf{e}'},
    120307: {LaTeXMode.textmode: '\\mathsfbf{f}'},
    120308: {LaTeXMode.textmode: '\\mathsfbf{g}'},
    120309: {LaTeXMode.textmode: '\\mathsfbf{h}'},
    120310: {LaTeXMode.textmode: '\\mathsfbf{i}'},
    120311: {LaTeXMode.textmode: '\\mathsfbf{j}'},
    120312: {LaTeXMode.textmode: '\\mathsfbf{k}'},
    120313: {LaTeXMode.textmode: '\\mathsfbf{l}'},
    120314: {LaTeXMode.textmode: '\\mathsfbf{m}'},
    120315: {LaTeXMode.textmode: '\\mathsfbf{n}'},
    120316: {LaTeXMode.textmode: '\\mathsfbf{o}'},
    120317: {LaTeXMode.textmode: '\\mathsfbf{p}'},
    120318: {LaTeXMode.textmode: '\\mathsfbf{q}'},
    120319: {LaTeXMode.textmode: '\\mathsfbf{r}'},
    120320: {LaTeXMode.textmode: '\\mathsfbf{s}'},
    120321: {LaTeXMode.textmode: '\\mathsfbf{t}'},
    120322: {LaTeXMode.textmode: '\\mathsfbf{u}'},
    120323: {LaTeXMode.textmode: '\\mathsfbf{v}'},
    120324: {LaTeXMode.textmode: '\\mathsfbf{w}'},
    120325: {LaTeXMode.textmode: '\\mathsfbf{x}'},
    120326: {LaTeXMode.textmode: '\\mathsfbf{y}'},
    120327: {LaTeXMode.textmode: '\\mathsfbf{z}'},
    120328: {LaTeXMode.textmode: '\\mathsfsl{A}'},
    120329: {LaTeXMode.textmode: '\\mathsfsl{B}'},
    120330: {LaTeXMode.textmode: '\\mathsfsl{C}'},
    120331: {LaTeXMode.textmode: '\\mathsfsl{D}'},
    120332: {LaTeXMode.textmode: '\\mathsfsl{E}'},
    120333: {LaTeXMode.textmode: '\\mathsfsl{F}'},
    120334: {LaTeXMode.textmode: '\\mathsfsl{G}'},
    120335: {LaTeXMode.textmode: '\\mathsfsl{H}'},
    120336: {LaTeXMode.textmode: '\\mathsfsl{I}'},
    120337: {LaTeXMode.textmode: '\\mathsfsl{J}'},
    120338: {LaTeXMode.textmode: '\\mathsfsl{K}'},
    120339: {LaTeXMode.textmode: '\\mathsfsl{L}'},
    120340: {LaTeXMode.textmode: '\\mathsfsl{M}'},
    120341: {LaTeXMode.textmode: '\\mathsfsl{N}'},
    120342: {LaTeXMode.textmode: '\\mathsfsl{O}'},
    120343: {LaTeXMode.textmode: '\\mathsfsl{P}'},
    120344: {LaTeXMode.textmode: '\\mathsfsl{Q}'},
    120345: {LaTeXMode.textmode: '\\mathsfsl{R}'},
    120346: {LaTeXMode.textmode: '\\mathsfsl{S}'},
    120347: {LaTeXMode.textmode: '\\mathsfsl{T}'},
    120348: {LaTeXMode.textmode: '\\mathsfsl{U}'},
    120349: {LaTeXMode.textmode: '\\mathsfsl{V}'},
    120350: {LaTeXMode.textmode: '\\mathsfsl{W}'},
    120351: {LaTeXMode.textmode: '\\mathsfsl{X}'},
    120352: {LaTeXMode.textmode: '\\mathsfsl{Y}'},
    120353: {LaTeXMode.textmode: '\\mathsfsl{Z}'},
    120354: {LaTeXMode.textmode: '\\mathsfsl{a}'},
    120355: {LaTeXMode.textmode: '\\mathsfsl{b}'},
    120356: {LaTeXMode.textmode: '\\mathsfsl{c}'},
    120357: {LaTeXMode.textmode: '\\mathsfsl{d}'},
    120358: {LaTeXMode.textmode: '\\mathsfsl{e}'},
    120359: {LaTeXMode.textmode: '\\mathsfsl{f}'},
    120360: {LaTeXMode.textmode: '\\mathsfsl{g}'},
    120361: {LaTeXMode.textmode: '\\mathsfsl{h}'},
    120362: {LaTeXMode.textmode: '\\mathsfsl{i}'},
    120363: {LaTeXMode.textmode: '\\mathsfsl{j}'},
    120364: {LaTeXMode.textmode: '\\mathsfsl{k}'},
    120365: {LaTeXMode.textmode: '\\mathsfsl{l}'},
    120366: {LaTeXMode.textmode: '\\mathsfsl{m}'},
    120367: {LaTeXMode.textmode: '\\mathsfsl{n}'},
    120368: {LaTeXMode.textmode: '\\mathsfsl{o}'},
    120369: {LaTeXMode.textmode: '\\mathsfsl{p}'},
    120370: {LaTeXMode.textmode: '\\mathsfsl{q}'},
    120371: {LaTeXMode.textmode: '\\mathsfsl{r}'},
    120372: {LaTeXMode.textmode: '\\mathsfsl{s}'},
    120373: {LaTeXMode.textmode: '\\mathsfsl{t}'},
    120374: {LaTeXMode.textmode: '\\mathsfsl{u}'},
    120375: {LaTeXMode.textmode: '\\mathsfsl{v}'},
    120376: {LaTeXMode.textmode: '\\mathsfsl{w}'},
    120377: {LaTeXMode.textmode: '\\mathsfsl{x}'},
    120378: {LaTeXMode.textmode: '\\mathsfsl{y}'},
    120379: {LaTeXMode.textmode: '\\mathsfsl{z}'},
    120380: {LaTeXMode.textmode: '\\mathsfbfsl{A}'},
    120381: {LaTeXMode.textmode: '\\mathsfbfsl{B}'},
    120382: {LaTeXMode.textmode: '\\mathsfbfsl{C}'},
    120383: {LaTeXMode.textmode: '\\mathsfbfsl{D}'},
    120384: {LaTeXMode.textmode: '\\mathsfbfsl{E}'},
    120385: {LaTeXMode.textmode: '\\mathsfbfsl{F}'},
    120386: {LaTeXMode.textmode: '\\mathsfbfsl{G}'},
    120387: {LaTeXMode.textmode: '\\mathsfbfsl{H}'},
    120388: {LaTeXMode.textmode: '\\mathsfbfsl{I}'},
    120389: {LaTeXMode.textmode: '\\mathsfbfsl{J}'},
    120390: {LaTeXMode.textmode: '\\mathsfbfsl{K}'},
    120391: {LaTeXMode.textmode: '\\mathsfbfsl{L}'},
    120392: {LaTeXMode.textmode: '\\mathsfbfsl{M}'},
    120393: {LaTeXMode.textmode: '\\mathsfbfsl{N}'},
    120394: {LaTeXMode.textmode: '\\mathsfbfsl{O}'},
    120395: {LaTeXMode.textmode: '\\mathsfbfsl{P}'},
    120396: {LaTeXMode.textmode: '\\mathsfbfsl{Q}'},
    120397: {LaTeXMode.textmode: '\\mathsfbfsl{R}'},
    120398: {LaTeXMode.textmode: '\\mathsfbfsl{S}'},
    120399: {LaTeXMode.textmode: '\\mathsfbfsl{T}'},
    120400: {LaTeXMode.textmode: '\\mathsfbfsl{U}'},
    120401: {LaTeXMode.textmode: '\\mathsfbfsl{V}'},
    120402: {LaTeXMode.textmode: '\\mathsfbfsl{W}'},
    120403: {LaTeXMode.textmode: '\\mathsfbfsl{X}'},
    120404: {LaTeXMode.textmode: '\\mathsfbfsl{Y}'},
    120405: {LaTeXMode.textmode: '\\mathsfbfsl{Z}'},
    120406: {LaTeXMode.textmode: '\\mathsfbfsl{a}'},
    120407: {LaTeXMode.textmode: '\\mathsfbfsl{b}'},
    120408: {LaTeXMode.textmode: '\\mathsfbfsl{c}'},
    120409: {LaTeXMode.textmode: '\\mathsfbfsl{d}'},
    120410: {LaTeXMode.textmode: '\\mathsfbfsl{e}'},
    120411: {LaTeXMode.textmode: '\\mathsfbfsl{f}'},
    120412: {LaTeXMode.textmode: '\\mathsfbfsl{g}'},
    120413: {LaTeXMode.textmode: '\\mathsfbfsl{h}'},
    120414: {LaTeXMode.textmode: '\\mathsfbfsl{i}'},
    120415: {LaTeXMode.textmode: '\\mathsfbfsl{j}'},
    120416: {LaTeXMode.textmode: '\\mathsfbfsl{k}'},
    120417: {LaTeXMode.textmode: '\\mathsfbfsl{l}'},
    120418: {LaTeXMode.textmode: '\\mathsfbfsl{m}'},
    120419: {LaTeXMode.textmode: '\\mathsfbfsl{n}'},
    120420: {LaTeXMode.textmode: '\\mathsfbfsl{o}'},
    120421: {LaTeXMode.textmode: '\\mathsfbfsl{p}'},
    120422: {LaTeXMode.textmode: '\\mathsfbfsl{q}'},
    120423: {LaTeXMode.textmode: '\\mathsfbfsl{r}'},
    120424: {LaTeXMode.textmode: '\\mathsfbfsl{s}'},
    120425: {LaTeXMode.textmode: '\\mathsfbfsl{t}'},
    120426: {LaTeXMode.textmode: '\\mathsfbfsl{u}'},
    120427: {LaTeXMode.textmode: '\\mathsfbfsl{v}'},
    120428: {LaTeXMode.textmode: '\\mathsfbfsl{w}'},
    120429: {LaTeXMode.textmode: '\\mathsfbfsl{x}'},
    120430: {LaTeXMode.textmode: '\\mathsfbfsl{y}'},
    120431: {LaTeXMode.textmode: '\\mathsfbfsl{z}'},
    120432: {LaTeXMode.textmode: '\\mathtt{A}'},
    120433: {LaTeXMode.textmode: '\\mathtt{B}'},
    120434: {LaTeXMode.textmode: '\\mathtt{C}'},
    120435: {LaTeXMode.textmode: '\\mathtt{D}'},
    120436: {LaTeXMode.textmode: '\\mathtt{E}'},
    120437: {LaTeXMode.textmode: '\\mathtt{F}'},
    120438: {LaTeXMode.textmode: '\\mathtt{G}'},
    120439: {LaTeXMode.textmode: '\\mathtt{H}'},
    120440: {LaTeXMode.textmode: '\\mathtt{I}'},
    120441: {LaTeXMode.textmode: '\\mathtt{J}'},
    120442: {LaTeXMode.textmode: '\\mathtt{K}'},
    120443: {LaTeXMode.textmode: '\\mathtt{L}'},
    120444: {LaTeXMode.textmode: '\\mathtt{M}'},
    120445: {LaTeXMode.textmode: '\\mathtt{N}'},
    120446: {LaTeXMode.textmode: '\\mathtt{O}'},
    120447: {LaTeXMode.textmode: '\\mathtt{P}'},
    120448: {LaTeXMode.textmode: '\\mathtt{Q}'},
    120449: {LaTeXMode.textmode: '\\mathtt{R}'},
    120450: {LaTeXMode.textmode: '\\mathtt{S}'},
    120451: {LaTeXMode.textmode: '\\mathtt{T}'},
    120452: {LaTeXMode.textmode: '\\mathtt{U}'},
    120453: {LaTeXMode.textmode: '\\mathtt{V}'},
    120454: {LaTeXMode.textmode: '\\mathtt{W}'},
    120455: {LaTeXMode.textmode: '\\mathtt{X}'},
    120456: {LaTeXMode.textmode: '\\mathtt{Y}'},
    120457: {LaTeXMode.textmode: '\\mathtt{Z}'},
    120458: {LaTeXMode.textmode: '\\mathtt{a}'},
    120459: {LaTeXMode.textmode: '\\mathtt{b}'},
    120460: {LaTeXMode.textmode: '\\mathtt{c}'},
    120461: {LaTeXMode.textmode: '\\mathtt{d}'},
    120462: {LaTeXMode.textmode: '\\mathtt{e}'},
    120463: {LaTeXMode.textmode: '\\mathtt{f}'},
    120464: {LaTeXMode.textmode: '\\mathtt{g}'},
    120465: {LaTeXMode.textmode: '\\mathtt{h}'},
    120466: {LaTeXMode.textmode: '\\mathtt{i}'},
    120467: {LaTeXMode.textmode: '\\mathtt{j}'},
    120468: {LaTeXMode.textmode: '\\mathtt{k}'},
    120469: {LaTeXMode.textmode: '\\mathtt{l}'},
    120470: {LaTeXMode.textmode: '\\mathtt{m}'},
    120471: {LaTeXMode.textmode: '\\mathtt{n}'},
    120472: {LaTeXMode.textmode: '\\mathtt{o}'},
    120473: {LaTeXMode.textmode: '\\mathtt{p}'},
    120474: {LaTeXMode.textmode: '\\mathtt{q}'},
    120475: {LaTeXMode.textmode: '\\mathtt{r}'},
    120476: {LaTeXMode.textmode: '\\mathtt{s}'},
    120477: {LaTeXMode.textmode: '\\mathtt{t}'},
    120478: {LaTeXMode.textmode: '\\mathtt{u}'},
    120479: {LaTeXMode.textmode: '\\mathtt{v}'},
    120480: {LaTeXMode.textmode: '\\mathtt{w}'},
    120481: {LaTeXMode.textmode: '\\mathtt{x}'},
    120482: {LaTeXMode.textmode: '\\mathtt{y}'},
    120483: {LaTeXMode.textmode: '\\mathtt{z}'},
    120488: {LaTeXMode.textmode: '\\mathbf{\\Alpha}'},
    120489: {LaTeXMode.textmode: '\\mathbf{\\Beta}'},
    120490: {LaTeXMode.textmode: '\\mathbf{\\Gamma}'},
    120491: {LaTeXMode.textmode: '\\mathbf{\\Delta}'},
    120492: {LaTeXMode.textmode: '\\mathbf{\\Epsilon}'},
    120493: {LaTeXMode.textmode: '\\mathbf{\\Zeta}'},
    120494: {LaTeXMode.textmode: '\\mathbf{\\Eta}'},
    120495: {LaTeXMode.textmode: '\\mathbf{\\Theta}'},
    120496: {LaTeXMode.textmode: '\\mathbf{\\Iota}'},
    120497: {LaTeXMode.textmode: '\\mathbf{\\Kappa}'},
    120498: {LaTeXMode.textmode: '\\mathbf{\\Lambda}'},
    120499: {LaTeXMode.textmode: '\\mathbf{M}'},
    120500: {LaTeXMode.textmode: 'N'},
    120501: {LaTeXMode.textmode: '\\mathbf{\\Xi}'},
    120502: {LaTeXMode.textmode: 'O'},
    120503: {LaTeXMode.textmode: '\\mathbf{\\Pi}'},
    120504: {LaTeXMode.textmode: '\\mathbf{\\Rho}'},
    120505: {LaTeXMode.textmode: '\\mathbf{\\vartheta}'},
    120506: {LaTeXMode.textmode: '\\mathbf{\\Sigma}'},
    120507: {LaTeXMode.textmode: '\\mathbf{\\Tau}'},
    120508: {LaTeXMode.textmode: '\\mathbf{\\Upsilon}'},
    120509: {LaTeXMode.textmode: '\\mathbf{\\Phi}'},
    120510: {LaTeXMode.textmode: '\\mathbf{\\Chi}'},
    120511: {LaTeXMode.textmode: '\\mathbf{\\Psi}'},
    120512: {LaTeXMode.textmode: '\\mathbf{\\Omega}'},
    120513: {LaTeXMode.textmode: '\\mathbf{\\nabla}'},
    120514: {LaTeXMode.textmode: '\\mathbf{\\alpha}'},
    120515: {LaTeXMode.textmode: '\\mathbf{\\beta}'},
    120516: {LaTeXMode.textmode: '\\mathbf{\\gamma}'},
    120517: {LaTeXMode.textmode: '\\mathbf{\\delta}'},
    120518: {LaTeXMode.textmode: '\\mathbf{\\epsilon}'},
    120519: {LaTeXMode.textmode: '\\mathbf{\\zeta}'},
    120520: {LaTeXMode.textmode: '\\mathbf{\\eta}'},
    120521: {LaTeXMode.textmode: '\\mathbf{\\theta}'},
    120522: {LaTeXMode.textmode: '\\mathbf{\\iota}'},
    120523: {LaTeXMode.textmode: '\\mathbf{\\kappa}'},
    120524: {LaTeXMode.textmode: '\\mathbf{\\lambda}'},
    120525: {LaTeXMode.textmode: '\\mathbf{\\mu}'},
    120526: {LaTeXMode.textmode: '\\mathbf{\\nu}'},
    120527: {LaTeXMode.textmode: '\\mathbf{\\xi}'},
    120528: {LaTeXMode.textmode: '\\mathbf{o}'},
    120529: {LaTeXMode.textmode: '\\mathbf{\\pi}'},
    120530: {LaTeXMode.textmode: '\\mathbf{\\rho}'},
    120531: {LaTeXMode.textmode: '\\mathbf{\\varsigma}'},
    120532: {LaTeXMode.textmode: '\\mathbf{\\sigma}'},
    120533: {LaTeXMode.textmode: '\\mathbf{\\tau}'},
    120534: {LaTeXMode.textmode: '\\mathbf{\\upsilon}'},
    120535: {LaTeXMode.textmode: '\\mathbf{\\phi}'},
    120536: {LaTeXMode.textmode: '\\mathbf{\\chi}'},
    120537: {LaTeXMode.textmode: '\\mathbf{\\psi}'},
    120538: {LaTeXMode.textmode: '\\mathbf{\\omega}'},
    120539: {LaTeXMode.textmode: '\\partial '},
    120540: {LaTeXMode.textmode: '\\mathbf{\\varepsilon}'},
    120541: {LaTeXMode.textmode: '\\mathbf{\\vartheta}'},
    120542: {LaTeXMode.textmode: '\\mathbf{\\varkappa}'},
    120543: {LaTeXMode.textmode: '\\mathbf{\\phi}'},
    120544: {LaTeXMode.textmode: '\\mathbf{\\varrho}'},
    120545: {LaTeXMode.textmode: '\\mathbf{\\varpi}'},
    120546: {LaTeXMode.textmode: '\\mathmit{\\Alpha}'},
    120547: {LaTeXMode.textmode: '\\mathmit{\\Beta}'},
    120548: {LaTeXMode.textmode: '\\mathmit{\\Gamma}'},
    120549: {LaTeXMode.textmode: '\\mathmit{\\Delta}'},
    120550: {LaTeXMode.textmode: '\\mathmit{\\Epsilon}'},
    120551: {LaTeXMode.textmode: '\\mathmit{\\Zeta}'},
    120552: {LaTeXMode.textmode: '\\mathmit{\\Eta}'},
    120553: {LaTeXMode.textmode: '\\mathmit{\\Theta}'},
    120554: {LaTeXMode.textmode: '\\mathmit{\\Iota}'},
    120555: {LaTeXMode.textmode: '\\mathmit{\\Kappa}'},
    120556: {LaTeXMode.textmode: '\\mathmit{\\Lambda}'},
    120557: {LaTeXMode.textmode: '\\mathmit{M}'},
    120558: {LaTeXMode.textmode: 'N'},
    120559: {LaTeXMode.textmode: '\\mathmit{\\Xi}'},
    120560: {LaTeXMode.textmode: 'O'},
    120561: {LaTeXMode.textmode: '\\mathmit{\\Pi}'},
    120562: {LaTeXMode.textmode: '\\mathmit{\\Rho}'},
    120563: {LaTeXMode.textmode: '\\mathmit{\\vartheta}'},
    120564: {LaTeXMode.textmode: '\\mathmit{\\Sigma}'},
    120565: {LaTeXMode.textmode: '\\mathmit{\\Tau}'},
    120566: {LaTeXMode.textmode: '\\mathmit{\\Upsilon}'},
    120567: {LaTeXMode.textmode: '\\mathmit{\\Phi}'},
    120568: {LaTeXMode.textmode: '\\mathmit{\\Chi}'},
    120569: {LaTeXMode.textmode: '\\mathmit{\\Psi}'},
    120570: {LaTeXMode.textmode: '\\mathmit{\\Omega}'},
    120571: {LaTeXMode.textmode: '\\mathmit{\\nabla}'},
    120572: {LaTeXMode.textmode: '\\mathmit{\\alpha}'},
    120573: {LaTeXMode.textmode: '\\mathmit{\\beta}'},
    120574: {LaTeXMode.textmode: '\\mathmit{\\gamma}'},
    120575: {LaTeXMode.textmode: '\\mathmit{\\delta}'},
    120576: {LaTeXMode.textmode: '\\mathmit{\\epsilon}'},
    120577: {LaTeXMode.textmode: '\\mathmit{\\zeta}'},
    120578: {LaTeXMode.textmode: '\\mathmit{\\eta}'},
    120579: {LaTeXMode.textmode: '\\mathmit{\\theta}'},
    120580: {LaTeXMode.textmode: '\\mathmit{\\iota}'},
    120581: {LaTeXMode.textmode: '\\mathmit{\\kappa}'},
    120582: {LaTeXMode.textmode: '\\mathmit{\\lambda}'},
    120583: {LaTeXMode.textmode: '\\mathmit{\\mu}'},
    120584: {LaTeXMode.textmode: '\\mathmit{\\nu}'},
    120585: {LaTeXMode.textmode: '\\mathmit{\\xi}'},
    120586: {LaTeXMode.textmode: '\\mathmit{o}'},
    120587: {LaTeXMode.textmode: '\\mathmit{\\pi}'},
    120588: {LaTeXMode.textmode: '\\mathmit{\\rho}'},
    120589: {LaTeXMode.textmode: '\\mathmit{\\varsigma}'},
    120590: {LaTeXMode.textmode: '\\mathmit{\\sigma}'},
    120591: {LaTeXMode.textmode: '\\mathmit{\\tau}'},
    120592: {LaTeXMode.textmode: '\\mathmit{\\upsilon}'},
    120593: {LaTeXMode.textmode: '\\mathmit{\\phi}'},
    120594: {LaTeXMode.textmode: '\\mathmit{\\chi}'},
    120595: {LaTeXMode.textmode: '\\mathmit{\\psi}'},
    120596: {LaTeXMode.textmode: '\\mathmit{\\omega}'},
    120597: {LaTeXMode.textmode: '\\partial '},
    120598: {LaTeXMode.textmode: '\\in'},
    120599: {LaTeXMode.textmode: '\\mathmit{\\vartheta}'},
    120600: {LaTeXMode.textmode: '\\mathmit{\\varkappa}'},
    120601: {LaTeXMode.textmode: '\\mathmit{\\phi}'},
    120602: {LaTeXMode.textmode: '\\mathmit{\\varrho}'},
    120603: {LaTeXMode.textmode: '\\mathmit{\\varpi}'},
    120604: {LaTeXMode.textmode: '\\mathbit{\\Alpha}'},
    120605: {LaTeXMode.textmode: '\\mathbit{\\Beta}'},
    120606: {LaTeXMode.textmode: '\\mathbit{\\Gamma}'},
    120607: {LaTeXMode.textmode: '\\mathbit{\\Delta}'},
    120608: {LaTeXMode.textmode: '\\mathbit{\\Epsilon}'},
    120609: {LaTeXMode.textmode: '\\mathbit{\\Zeta}'},
    120610: {LaTeXMode.textmode: '\\mathbit{\\Eta}'},
    120611: {LaTeXMode.textmode: '\\mathbit{\\Theta}'},
    120612: {LaTeXMode.textmode: '\\mathbit{\\Iota}'},
    120613: {LaTeXMode.textmode: '\\mathbit{\\Kappa}'},
    120614: {LaTeXMode.textmode: '\\mathbit{\\Lambda}'},
    120615: {LaTeXMode.textmode: '\\mathbit{M}'},
    120616: {LaTeXMode.textmode: '\\mathbit{N}'},
    120617: {LaTeXMode.textmode: '\\mathbit{\\Xi}'},
    120618: {LaTeXMode.textmode: 'O'},
    120619: {LaTeXMode.textmode: '\\mathbit{\\Pi}'},
    120620: {LaTeXMode.textmode: '\\mathbit{\\Rho}'},
    120621: {LaTeXMode.textmode: '\\mathbit{O}'},
    120622: {LaTeXMode.textmode: '\\mathbit{\\Sigma}'},
    120623: {LaTeXMode.textmode: '\\mathbit{\\Tau}'},
    120624: {LaTeXMode.textmode: '\\mathbit{\\Upsilon}'},
    120625: {LaTeXMode.textmode: '\\mathbit{\\Phi}'},
    120626: {LaTeXMode.textmode: '\\mathbit{\\Chi}'},
    120627: {LaTeXMode.textmode: '\\mathbit{\\Psi}'},
    120628: {LaTeXMode.textmode: '\\mathbit{\\Omega}'},
    120629: {LaTeXMode.textmode: '\\mathbit{\\nabla}'},
    120630: {LaTeXMode.textmode: '\\mathbit{\\alpha}'},
    120631: {LaTeXMode.textmode: '\\mathbit{\\beta}'},
    120632: {LaTeXMode.textmode: '\\mathbit{\\gamma}'},
    120633: {LaTeXMode.textmode: '\\mathbit{\\delta}'},
    120634: {LaTeXMode.textmode: '\\mathbit{\\epsilon}'},
    120635: {LaTeXMode.textmode: '\\mathbit{\\zeta}'},
    120636: {LaTeXMode.textmode: '\\mathbit{\\eta}'},
    120637: {LaTeXMode.textmode: '\\mathbit{\\theta}'},
    120638: {LaTeXMode.textmode: '\\mathbit{\\iota}'},
    120639: {LaTeXMode.textmode: '\\mathbit{\\kappa}'},
    120640: {LaTeXMode.textmode: '\\mathbit{\\lambda}'},
    120641: {LaTeXMode.textmode: '\\mathbit{\\mu}'},
    120642: {LaTeXMode.textmode: '\\mathbit{\\nu}'},
    120643: {LaTeXMode.textmode: '\\mathbit{\\xi}'},
    120644: {LaTeXMode.textmode: '\\mathbit{o}'},
    120645: {LaTeXMode.textmode: '\\mathbit{\\pi}'},
    120646: {LaTeXMode.textmode: '\\mathbit{\\rho}'},
    120647: {LaTeXMode.textmode: '\\mathbit{\\varsigma}'},
    120648: {LaTeXMode.textmode: '\\mathbit{\\sigma}'},
    120649: {LaTeXMode.textmode: '\\mathbit{\\tau}'},
    120650: {LaTeXMode.textmode: '\\mathbit{\\upsilon}'},
    120651: {LaTeXMode.textmode: '\\mathbit{\\phi}'},
    120652: {LaTeXMode.textmode: '\\mathbit{\\chi}'},
    120653: {LaTeXMode.textmode: '\\mathbit{\\psi}'},
    120654: {LaTeXMode.textmode: '\\mathbit{\\omega}'},
    120655: {LaTeXMode.textmode: '\\partial '},
    120656: {LaTeXMode.textmode: '\\in'},
    120657: {LaTeXMode.textmode: '\\mathbit{\\vartheta}'},
    120658: {LaTeXMode.textmode: '\\mathbit{\\varkappa}'},
    120659: {LaTeXMode.textmode: '\\mathbit{\\phi}'},
    120660: {LaTeXMode.textmode: '\\mathbit{\\varrho}'},
    120661: {LaTeXMode.textmode: '\\mathbit{\\varpi}'},
    120662: {LaTeXMode.textmode: '\\mathsfbf{\\Alpha}'},
    120663: {LaTeXMode.textmode: '\\mathsfbf{\\Beta}'},
    120664: {LaTeXMode.textmode: '\\mathsfbf{\\Gamma}'},
    120665: {LaTeXMode.textmode: '\\mathsfbf{\\Delta}'},
    120666: {LaTeXMode.textmode: '\\mathsfbf{\\Epsilon}'},
    120667: {LaTeXMode.textmode: '\\mathsfbf{\\Zeta}'},
    120668: {LaTeXMode.textmode: '\\mathsfbf{\\Eta}'},
    120669: {LaTeXMode.textmode: '\\mathsfbf{\\Theta}'},
    120670: {LaTeXMode.textmode: '\\mathsfbf{\\Iota}'},
    120671: {LaTeXMode.textmode: '\\mathsfbf{\\Kappa}'},
    120672: {LaTeXMode.textmode: '\\mathsfbf{\\Lambda}'},
    120673: {LaTeXMode.textmode: '\\mathsfbf{M}'},
    120674: {LaTeXMode.textmode: '\\mathsfbf{N}'},
    120675: {LaTeXMode.textmode: '\\mathsfbf{\\Xi}'},
    120676: {LaTeXMode.textmode: 'O'},
    120677: {LaTeXMode.textmode: '\\mathsfbf{\\Pi}'},
    120678: {LaTeXMode.textmode: '\\mathsfbf{\\Rho}'},
    120679: {LaTeXMode.textmode: '\\mathsfbf{\\vartheta}'},
    120680: {LaTeXMode.textmode: '\\mathsfbf{\\Sigma}'},
    120681: {LaTeXMode.textmode: '\\mathsfbf{\\Tau}'},
    120682: {LaTeXMode.textmode: '\\mathsfbf{\\Upsilon}'},
    120683: {LaTeXMode.textmode: '\\mathsfbf{\\Phi}'},
    120684: {LaTeXMode.textmode: '\\mathsfbf{\\Chi}'},
    120685: {LaTeXMode.textmode: '\\mathsfbf{\\Psi}'},
    120686: {LaTeXMode.textmode: '\\mathsfbf{\\Omega}'},
    120687: {LaTeXMode.textmode: '\\mathsfbf{\\nabla}'},
    120688: {LaTeXMode.textmode: '\\mathsfbf{\\alpha}'},
    120689: {LaTeXMode.textmode: '\\mathsfbf{\\beta}'},
    120690: {LaTeXMode.textmode: '\\mathsfbf{\\gamma}'},
    120691: {LaTeXMode.textmode: '\\mathsfbf{\\delta}'},
    120692: {LaTeXMode.textmode: '\\mathsfbf{\\epsilon}'},
    120693: {LaTeXMode.textmode: '\\mathsfbf{\\zeta}'},
    120694: {LaTeXMode.textmode: '\\mathsfbf{\\eta}'},
    120695: {LaTeXMode.textmode: '\\mathsfbf{\\theta}'},
    120696: {LaTeXMode.textmode: '\\mathsfbf{\\iota}'},
    120697: {LaTeXMode.textmode: '\\mathsfbf{\\kappa}'},
    120698: {LaTeXMode.textmode: '\\mathsfbf{\\lambda}'},
    120699: {LaTeXMode.textmode: '\\mathsfbf{\\mu}'},
    120700: {LaTeXMode.textmode: '\\mathsfbf{\\nu}'},
    120701: {LaTeXMode.textmode: '\\mathsfbf{\\xi}'},
    120702: {LaTeXMode.textmode: '\\mathsfbf{o}'},
    120703: {LaTeXMode.textmode: '\\mathsfbf{\\pi}'},
    120704: {LaTeXMode.textmode: '\\mathsfbf{\\rho}'},
    120705: {LaTeXMode.textmode: '\\mathsfbf{\\varsigma}'},
    120706: {LaTeXMode.textmode: '\\mathsfbf{\\sigma}'},
    120707: {LaTeXMode.textmode: '\\mathsfbf{\\tau}'},
    120708: {LaTeXMode.textmode: '\\mathsfbf{\\upsilon}'},
    120709: {LaTeXMode.textmode: '\\mathsfbf{\\phi}'},
    120710: {LaTeXMode.textmode: '\\mathsfbf{\\chi}'},
    120711: {LaTeXMode.textmode: '\\mathsfbf{\\psi}'},
    120712: {LaTeXMode.textmode: '\\mathsfbf{\\omega}'},
    120713: {LaTeXMode.textmode: '\\partial '},
    120714: {LaTeXMode.textmode: '\\mathsfbf{\\varepsilon}'},
    120715: {LaTeXMode.textmode: '\\mathsfbf{\\vartheta}'},
    120716: {LaTeXMode.textmode: '\\mathsfbf{\\varkappa}'},
    120717: {LaTeXMode.textmode: '\\mathsfbf{\\phi}'},
    120718: {LaTeXMode.textmode: '\\mathsfbf{\\varrho}'},
    120719: {LaTeXMode.textmode: '\\mathsfbf{\\varpi}'},
    120720: {LaTeXMode.textmode: '\\mathsfbfsl{\\Alpha}'},
    120721: {LaTeXMode.textmode: '\\mathsfbfsl{\\Beta}'},
    120722: {LaTeXMode.textmode: '\\mathsfbfsl{\\Gamma}'},
    120723: {LaTeXMode.textmode: '\\mathsfbfsl{\\Delta}'},
    120724: {LaTeXMode.textmode: '\\mathsfbfsl{\\Epsilon}'},
    120725: {LaTeXMode.textmode: '\\mathsfbfsl{\\Zeta}'},
    120726: {LaTeXMode.textmode: '\\mathsfbfsl{\\Eta}'},
    120727: {LaTeXMode.textmode: '\\mathsfbfsl{\\vartheta}'},
    120728: {LaTeXMode.textmode: '\\mathsfbfsl{\\Iota}'},
    120729: {LaTeXMode.textmode: '\\mathsfbfsl{\\Kappa}'},
    120730: {LaTeXMode.textmode: '\\mathsfbfsl{\\Lambda}'},
    120731: {LaTeXMode.textmode: '\\mathsfbfsl{M}'},
    120732: {LaTeXMode.textmode: '\\mathsfbfsl{N}'},
    120733: {LaTeXMode.textmode: '\\mathsfbfsl{\\Xi}'},
    120734: {LaTeXMode.textmode: 'O'},
    120735: {LaTeXMode.textmode: '\\mathsfbfsl{\\Pi}'},
    120736: {LaTeXMode.textmode: '\\mathsfbfsl{\\Rho}'},
    120737: {LaTeXMode.textmode: '\\mathsfbfsl{\\vartheta}'},
    120738: {LaTeXMode.textmode: '\\mathsfbfsl{\\Sigma}'},
    120739: {LaTeXMode.textmode: '\\mathsfbfsl{\\Tau}'},
    120740: {LaTeXMode.textmode: '\\mathsfbfsl{\\Upsilon}'},
    120741: {LaTeXMode.textmode: '\\mathsfbfsl{\\Phi}'},
    120742: {LaTeXMode.textmode: '\\mathsfbfsl{\\Chi}'},
    120743: {LaTeXMode.textmode: '\\mathsfbfsl{\\Psi}'},
    120744: {LaTeXMode.textmode: '\\mathsfbfsl{\\Omega}'},
    120745: {LaTeXMode.textmode: '\\mathsfbfsl{\\nabla}'},
    120746: {LaTeXMode.textmode: '\\mathsfbfsl{\\alpha}'},
    120747: {LaTeXMode.textmode: '\\mathsfbfsl{\\beta}'},
    120748: {LaTeXMode.textmode: '\\mathsfbfsl{\\gamma}'},
    120749: {LaTeXMode.textmode: '\\mathsfbfsl{\\delta}'},
    120750: {LaTeXMode.textmode: '\\mathsfbfsl{\\epsilon}'},
    120751: {LaTeXMode.textmode: '\\mathsfbfsl{\\zeta}'},
    120752: {LaTeXMode.textmode: '\\mathsfbfsl{\\eta}'},
    120753: {LaTeXMode.textmode: '\\mathsfbfsl{\\vartheta}'},
    120754: {LaTeXMode.textmode: '\\mathsfbfsl{\\iota}'},
    120755: {LaTeXMode.textmode: '\\mathsfbfsl{\\kappa}'},
    120756: {LaTeXMode.textmode: '\\mathsfbfsl{\\lambda}'},
    120757: {LaTeXMode.textmode: '\\mathsfbfsl{\\mu}'},
    120758: {LaTeXMode.textmode: '\\mathsfbfsl{\\nu}'},
    120759: {LaTeXMode.textmode: '\\mathsfbfsl{\\xi}'},
    120760: {LaTeXMode.textmode: '\\mathsfbfsl{o}'},
    120761: {LaTeXMode.textmode: '\\mathsfbfsl{\\pi}'},
    120762: {LaTeXMode.textmode: '\\mathsfbfsl{\\rho}'},
    120763: {LaTeXMode.textmode: '\\mathsfbfsl{\\varsigma}'},
    120764: {LaTeXMode.textmode: '\\mathsfbfsl{\\sigma}'},
    120765: {LaTeXMode.textmode: '\\mathsfbfsl{\\tau}'},
    120766: {LaTeXMode.textmode: '\\mathsfbfsl{\\upsilon}'},
    120767: {LaTeXMode.textmode: '\\mathsfbfsl{\\phi}'},
    120768: {LaTeXMode.textmode: '\\mathsfbfsl{\\chi}'},
    120769: {LaTeXMode.textmode: '\\mathsfbfsl{\\psi}'},
    120770: {LaTeXMode.textmode: '\\mathsfbfsl{\\omega}'},
    120771: {LaTeXMode.textmode: '\\partial '},
    120772: {LaTeXMode.textmode: '\\in'},
    120773: {LaTeXMode.textmode: '\\mathsfbfsl{\\vartheta}'},
    120774: {LaTeXMode.textmode: '\\mathsfbfsl{\\varkappa}'},
    120775: {LaTeXMode.textmode: '\\mathsfbfsl{\\phi}'},
    120776: {LaTeXMode.textmode: '\\mathsfbfsl{\\varrho}'},
    120777: {LaTeXMode.textmode: '\\mathsfbfsl{\\varpi}'},
    120782: {LaTeXMode.textmode: '\\mathbf{0}'},
    120783: {LaTeXMode.textmode: '\\mathbf{1}'},
    120784: {LaTeXMode.textmode: '\\mathbf{2}'},
    120785: {LaTeXMode.textmode: '\\mathbf{3}'},
    120786: {LaTeXMode.textmode: '\\mathbf{4}'},
    120787: {LaTeXMode.textmode: '\\mathbf{5}'},
    120788: {LaTeXMode.textmode: '\\mathbf{6}'},
    120789: {LaTeXMode.textmode: '\\mathbf{7}'},
    120790: {LaTeXMode.textmode: '\\mathbf{8}'},
    120791: {LaTeXMode.textmode: '\\mathbf{9}'},
    120792: {LaTeXMode.textmode: '\\mathbb{0}'},
    120793: {LaTeXMode.textmode: '\\mathbb{1}'},
    120794: {LaTeXMode.textmode: '\\mathbb{2}'},
    120795: {LaTeXMode.textmode: '\\mathbb{3}'},
    120796: {LaTeXMode.textmode: '\\mathbb{4}'},
    120797: {LaTeXMode.textmode: '\\mathbb{5}'},
    120798: {LaTeXMode.textmode: '\\mathbb{6}'},
    120799: {LaTeXMode.textmode: '\\mathbb{7}'},
    120800: {LaTeXMode.textmode: '\\mathbb{8}'},
    120801: {LaTeXMode.textmode: '\\mathbb{9}'},
    120802: {LaTeXMode.textmode: '\\mathsf{0}'},
    120803: {LaTeXMode.textmode: '\\mathsf{1}'},
    120804: {LaTeXMode.textmode: '\\mathsf{2}'},
    120805: {LaTeXMode.textmode: '\\mathsf{3}'},
    120806: {LaTeXMode.textmode: '\\mathsf{4}'},
    120807: {LaTeXMode.textmode: '\\mathsf{5}'},
    120808: {LaTeXMode.textmode: '\\mathsf{6}'},
    120809: {LaTeXMode.textmode: '\\mathsf{7}'},
    120810: {LaTeXMode.textmode: '\\mathsf{8}'},
    120811: {LaTeXMode.textmode: '\\mathsf{9}'},
    120812: {LaTeXMode.textmode: '\\mathsfbf{0}'},
    120813: {LaTeXMode.textmode: '\\mathsfbf{1}'},
    120814: {LaTeXMode.textmode: '\\mathsfbf{2}'},
    120815: {LaTeXMode.textmode: '\\mathsfbf{3}'},
    120816: {LaTeXMode.textmode: '\\mathsfbf{4}'},
    120817: {LaTeXMode.textmode: '\\mathsfbf{5}'},
    120818: {LaTeXMode.textmode: '\\mathsfbf{6}'},
    120819: {LaTeXMode.textmode: '\\mathsfbf{7}'},
    120820: {LaTeXMode.textmode: '\\mathsfbf{8}'},
    120821: {LaTeXMode.textmode: '\\mathsfbf{9}'},
    120822: {LaTeXMode.textmode: '\\mathtt{0}'},
    120823: {LaTeXMode.textmode: '\\mathtt{1}'},
    120824: {LaTeXMode.textmode: '\\mathtt{2}'},
    120825: {LaTeXMode.textmode: '\\mathtt{3}'},
    120826: {LaTeXMode.textmode: '\\mathtt{4}'},
    120827: {LaTeXMode.textmode: '\\mathtt{5}'},
    120828: {LaTeXMode.textmode: '\\mathtt{6}'},
    120829: {LaTeXMode.textmode: '\\mathtt{7}'},
    120830: {LaTeXMode.textmode: '\\mathtt{8}'},
    120831: {LaTeXMode.textmode: '\\mathtt{9}'},
    }

