program pgn2cb;
{$m 65520,0,600000}


uses
  ch_ppgn, ch_files, ch_parse, crt, dos;

var
  t_game_numb, game_numb, not_printed_games : longint;
  f1: filetype;
  target, target2, source : sourcetype;
  game : gametype;
  target_idx : longint;
  i : integer;
  log_fil : text;
  log_name : pathstr;

begin
  io_test;
  writeln;
  writeln('Carsten Hansen, CH0506@HDC.HHA.DK, any comment welcome');
  writeln;
  writeln('SYNTAX: PGN2CB source-file target-file');
  writeln;
  source.name:='';
  target.name:='';
  if paramcount=0 then
  begin
    write('Type name of PGN-file:         ');
    readln(source.name);
    write('Name of new ChessBase file:    ');
    readln(target.name);
    if length(target.name)=0 then
      target.name:=source.name;
  end
  else
  if paramcount=1 then
  begin
    source.name:=paramstr(1);
    target.name:=source.name;
  end
  else
  begin
    source.name:=paramstr(1);
    target.name:=paramstr(2);
  end;
  if not file_exist(source.name) then
  begin
    remove_ext(source.name);
    source.name:=source.name+'.pgn';
  end;

  if file_exist(source.name) then
  begin
    remove_ext(target.name);
    find_path(target.name,target.path);
    open_file_for_read(f1,source.name);
    io_test;
    open_file_for_write(target.index,target.path+target.name+'.III');
    io_test;
    open_file_for_write(target.game ,target.path+target.name+'.CBF');
    io_test;  io_error:=not(copyerror=0);
    game_numb:=0;
    t_game_numb:=0;
    target_idx:=0;
    not_printed_games:=0;
    put_index_val(target.index,target_idx+game_numb+2);
    writeln;
    if not io_error then
    begin
      while (not io_error) and (not f1.eof) and (not keypressed) do
      begin
        read_pgn(f1,game);
        if (not game.illegal_move) and
        not (f1.eof and (game.numb_of_moves=0)) then
        begin
          write_cb_gamehead(game);
          target_idx:=target_idx+game.len;
          inc(t_game_numb);
          put_index_val(target.index,target_idx+t_game_numb+2);
          for i:=0 to game.len-1 do
            put_next_byte(target.game,game.bytes[i]);
          inc(game_numb);
        end
        else
        begin
          if not (f1.eof and (game.numb_of_moves=0)) then
          begin
            inc(not_printed_games);
            if not_printed_games=1 then
            begin
              log_name:=source.name;
              remove_ext(log_name);
              log_name:=log_name+'.log';
              assign(log_fil,log_name);
              rewrite(log_fil);
            end;
            writeln(log_fil,game_numb+1:6,'':4,game.cb_players);
            inc(game_numb);
          end;
        end;
        gotoxy(10,wherey);
        write(game_numb,'  Games examined  ',
              not_printed_games,'  Games omitted');
      end;
    end
    else
    begin
      writeln('IO-error while opening ',source.name);
    end;

    close_read_file(f1);
    close_write_file(target.index);
    close_write_file(target.game);
    if not_printed_games>0 then
      close(log_fil);
    open_file_for_read(target.index,target.path+target.name+'.III');
    io_test;
    open_file_for_write(target2.index,target.path+target.name+'.CBI');
    io_test;
    put_index_val(target2.index,t_game_numb+1);
    for i:=0 to game_numb do
    begin
      put_index_val(target2.index,get_index_val(target.index));
      if (i mod 50=0) then
        write('.');
    end;
    close_write_file(target2.index);
    close_read_file(target.index);
    erase(target.index.f);
  end
  else
  begin
    writeln(source.name,' Does not exist');
  end;
end.

