# ts_param.tcl

proc initparams {} {

  set s {
    { Edit  0 {
        {"Intern" "intern" "%e"}
        {"vi &" "exbg" "xterm -geometry %g -e vi !i+%! %e"}
    } }
    { Compose 0 {
      {"LaTeX" "exwin" "latex %p"}
      {"TeX" "exwin" "tex %p"}
    } }
    { Reference 0 {
      {"Makeindex" "exwin" "makeindex %r.idx"}
    } }
    { View 0 {
      {"Xdvi" "exwin" "xdvi -geometry %g %r" }
      {"Xdvi &" "exbg" "xdvi -geometry %g %r"}
      {"Ghostview" "exwin" "ghostview %r.ps"}
    } }
    { Print 0 {
      {"DVIPS" exwin "dvips -t a4 !l-t landscape! !0-p %! !9-l %! !c-c %! !o-A! !e-B! !x%! %r"}
    } }
    { Graphic 0 {
      {"XFig &" "exbg" "xfig -geometry %g -but_ 3 -me %o.fig"}
    } }
    { Util 0 {
      {"View Logfile" exwin "less %r.log"}
      {"Delete Waste" exwin "rm *.aux *.log *.toc *.ind *.ilg *.bak"}
      {"Shell" exwin "/bin/sh"}
    } }
    { Filter 0 {
    } }
  }
  return $s
}

proc readparams {} {
  global params ted gparams

  if {$params(Primary_file) != ""} {
    set files "[file rootname $params(Primary_file)].prj"
  } else {
    set files {}
  }
  lappend files $params(local_paramfile) $params(global_paramfile)
  set s [initparams]
  foreach fn $files {
    if {![catch {set fd [open $fn r]}]} {
      set s [read $fd]
      close $fd
      break
    }
  }
  foreach cmd {Edit Compose View Print Reference Graphic Util Filter} {
    set params($cmd) {}
    set params(${cmd}_name) {}
    set params(${cmd}_default) 0
  }
  set ted(global_params) {}
  foreach l $s {
    set cmd [lindex $l 0]
    switch $cmd {
      Edit -
      Compose -
      View -
      Print -
      Reference -
      Graphic -
      Util -
      Filter {
        set default [lindex $l 1]
        set params($cmd) [lindex $l 2]
        set params(${cmd}_name) [lindex [lindex $params($cmd) $default] 0]
        set params(${cmd}_default) $default
      } 
      Options {
#       Set default values
        set gparams(hlplan) "eng"
        set gparams(showicons) 1
        set lopt [lindex $l 1]
        foreach par $lopt {
          set p0 [lindex $par 0]
	  set p1 [lindex $par 1]
	  set gparams($p0) $p1
        }
      }
    }
  }
}

proc writeparams {{default ""}} {
  global params ted gparams

  if {$params(Primary_file) != "" && $default == ""} {
    set fn "[file rootname $params(Primary_file)].prj"
  } else {
    set fn $params(local_paramfile)
  }
  set fd [open $fn w]
  foreach cmd {Edit Compose Reference View Print Util Graphic Filter} {
    puts $fd "\{ $cmd $params(${cmd}_default) \{"
      foreach l $params($cmd) {
        puts $fd "\{$l\}"
      }
    puts $fd "\} \}"
  }
  puts $fd "\{ Options \{"
  foreach l [array names gparams] {
    puts $fd "\{[list $l $gparams($l)]\}"
  }
  puts $fd "\} \}"
  close $fd
}

proc SPSetFields {i} {
  global pdlg

  set pdlg(sel) $i
  set l [lindex $pdlg(cmds) $i] 
  if {[llength $l] > 0} {set pdlg(name) [lindex $l 0]}
  if {[llength $l] > 1} {set pdlg(cmd) [lindex $l 1]}
  if {[llength $l] > 2} {set pdlg(opt) [lindex $l 2]}
}

proc SPSelect {i} {
  global pdlg

  .pdlg.t.b activate $i
  .pdlg.t.b select anchor $i
  .pdlg.t.b select set anchor $i
  .pdlg.t.b see $i
  SPSetFields $i
}

proc SPCopy {{new 0}} {
  global pdlg params

  if {$new} {
    foreach f {name cmd opt} {
      set pdlg($f) ""
    }
  }
  SPEnableEdit
  focus .pdlg.c.ename
  tkwait variable pdlg(bapply)
  if {$pdlg(bapply)} {
    lappend pdlg(cmds) [list $pdlg(name) $pdlg(cmd) $pdlg(opt)]
    .pdlg.t.b insert end $pdlg(name)
    set pdlg(sel) [expr [.pdlg.t.b size] - 1]
  }
  SPSelect $pdlg(sel)
  SPEnableEdit disable
  focus .pdlg.t.b
}

proc SPEdit {} {
  global pdlg

  SPEnableEdit
  focus .pdlg.c.ename
  tkwait variable pdlg(bapply)
  if {$pdlg(bapply)} {
    set l [list $pdlg(name) $pdlg(cmd) $pdlg(opt)]
    set pdlg(cmds) \
      [lreplace $pdlg(cmds) $pdlg(sel) $pdlg(sel) $l]
    .pdlg.t.b delete $pdlg(sel)
    .pdlg.t.b insert $pdlg(sel) $pdlg(name)
  }
  SPSelect $pdlg(sel)
  SPEnableEdit disable
  focus .pdlg.t.b
}

proc SPDel {} {
  global pdlg params

  if {[Dialog .ddlg $params(dlg_geom) "" "Delete entry $pdlg(name)" \
    question 0 1 {Yes <Any-y>} {No <Any-n>}] == 0} {
    debug "PDel"
    set pdlg(cmds) \
      [lreplace $pdlg(cmds) $pdlg(sel) $pdlg(sel)]
    .pdlg.t.b delete $pdlg(sel)
    SPSelect 0
  }
}

proc SPMove {{dist 1}} {
  global pdlg

  if {$dist < 0 && $pdlg(sel) == 0} return
  f {$dist > 0 && $pdlg(sel) >= [expr [llength $pdlg(cmds)]-1]} return
  set l [lindex $pdlg(cmds) $pdlg(sel)]
  set pdlg(cmds) [lreplace $pdlg(cmds) $pdlg(sel) $pdlg(sel)]
  .pdlg.t.b delete $pdlg(sel)
  if {$dist < 0} {set dist -1} else {set dist 1}
  incr pdlg(sel) $dist
  set pdlg(cmds) [linsert $pdlg(cmds) $pdlg(sel) $l]
  .pdlg.t.b insert $pdlg(sel) [lindex $l 0]
  SPSelect $pdlg(sel)
}

proc SPEnableEdit {{state normal}} {
  global pdlg

  if {$state == "normal"} {
    set reverse disable
  } else {
    set reverse normal
  }
  foreach w {.pdlg.c.rintern .pdlg.c.rfg .pdlg.c.rbg .pdlg.c.rterm
    .pdlg.c.ename .pdlg.c.eopt .pdlg.c.bapply .pdlg.c.bforget} {
    $w configure -state $state
  }
}

proc selectparams {cmd} {
  global params pdlg

  toplevel .pdlg
  wm geometry .pdlg $params(dlg_geom)
  wm title .pdlg "Select Command $cmd"

  frame .pdlg.t
  pack .pdlg.t -side top -fill x
  scrollbar .pdlg.t.s -command ".pdlg.t.b yview" -takefocus 0
  listbox .pdlg.t.b -yscroll ".pdlg.t.s set" -relief sunken -bd 1 \
    -takefocus 0
  grid .pdlg.t.b -row 0 -column 0 -rowspan 6 -sticky nsew
  grid .pdlg.t.s -row 0 -column 1 -rowspan 6 -sticky nsew
  button .pdlg.t.new -text "New" -underline 0 -command {SPCopy 1} -takefocus 0
  button .pdlg.t.copy -text "Copy" -underline 0 -command SPCopy -takefocus 0
  button .pdlg.t.edit -text "Edit" -underline 0 -command SPEdit -takefocus 0
  button .pdlg.t.del  -text "Delete" -underline 0 -command SPDel -takefocus 0
  button .pdlg.t.up   -text "Move Up"  -underline 5 -command {SPMove -1} \
    -takefocus 0
  button .pdlg.t.down -text "Move Down" -underline 7 -command {SPMove 1} \
    -takefocus 0
  grid .pdlg.t.new  -row 0 -column 2 -sticky ew
  grid .pdlg.t.copy -row 1 -column 2 -sticky ew
  grid .pdlg.t.edit -row 2 -column 2 -sticky ew
  grid .pdlg.t.del  -row 3 -column 2 -sticky ew
  grid .pdlg.t.up   -row 4 -column 2 -sticky ew
  grid .pdlg.t.down -row 5 -column 2 -sticky ew
  grid columnconfigure .pdlg.t 0 -weight 1

  frame .pdlg.r1 -height 2 -bd 1 -relief sunken
  pack .pdlg.r1 -pady 2 -fill x

  frame .pdlg.c
  pack .pdlg.c -side top -fill x
  label .pdlg.c.lname -text "Name:"
  entry .pdlg.c.ename -textvariable pdlg(name) -width 8 -state disabled
  grid .pdlg.c.lname -row 0 -column 0 -sticky w
  grid .pdlg.c.ename -row 0 -column 1 -columnspan 4 -sticky w
  label .pdlg.c.lscope -text "Scope:"
  radiobutton .pdlg.c.rfg -text "Foreground" -underline 0 -indicatoron false \
    -state disabled -variable pdlg(cmd) -value exwin
  radiobutton .pdlg.c.rbg -text "Background" -underline 0 -indicatoron false \
    -state disabled -variable pdlg(cmd) -value exbg
  radiobutton .pdlg.c.rterm -text "XTerm" -underline 0 -indicatoron false \
    -state disabled -variable pdlg(cmd) -value xtermbg
  radiobutton .pdlg.c.rintern -text "Intern" -underline 0 -indicatoron false \
    -state disabled -variable pdlg(cmd) -value intern
  grid .pdlg.c.lscope -row 1 -column 0 -sticky w
  grid .pdlg.c.rfg     -row 1 -column 1 -sticky ew
  grid .pdlg.c.rbg     -row 1 -column 2 -sticky ew
  grid .pdlg.c.rterm   -row 1 -column 3 -sticky ew
  if {$cmd == "Edit"} {
    grid .pdlg.c.rintern -row 1 -column 4 -sticky ew
  } else {
    .pdlg.c.rintern configure -takefocus 0
  }
  label .pdlg.c.lopt -text "Command:"
  entry .pdlg.c.eopt -textvariable pdlg(opt) -width 40 -state disabled
  grid .pdlg.c.lopt -row 2 -column 0 -sticky w
  grid .pdlg.c.eopt -row 2 -column 1 -columnspan 4 -sticky w
  button .pdlg.c.bapply -text Apply -default active -state disabled \
    -command {set pdlg(bapply) 1}
  button .pdlg.c.bforget -text Forget -state disabled \
    -command {set pdlg(bapply) 0}
  grid .pdlg.c.bapply -row 3 -column 1
  grid .pdlg.c.bforget -row 3 -column 2

  frame .pdlg.r2 -height 2 -bd 1 -relief sunken
  pack .pdlg.r2 -fill x -side top -pady 2

  frame .pdlg.b
  pack .pdlg.b -fill x -side top
  button .pdlg.b.bok -text OK -default active -command {set pdlg(ok) 1} \
    -takefocus 0
  button .pdlg.b.bcancel -text Cancel -command {set pdlg(ok) 0} -takefocus 0
  pack .pdlg.b.bok -side left -expand true -padx 10 -pady 5
  pack .pdlg.b.bcancel -side left -expand true -padx 10 -pady 5

  set pdlg(cmds) $params($cmd)
  foreach l $pdlg(cmds) {
    .pdlg.t.b insert end [lindex $l 0]
  }
  set pdlg(sel) $params(${cmd}_default)
  set pdlg(name) $params(${cmd}_name)
  SPSetFields $pdlg(sel)

# Bindings
  bindtags .pdlg.t.b [list Listbox .pdlg.t.b all]
  bind .pdlg.t.b <Any-Return> {set pdlg(ok) 1}
  bind .pdlg.t.b <Escape>  {set pdlg(ok) 0}
  bind .pdlg.t.b <Any-n>   {SPCopy 1}
  bind .pdlg.t.b <Any-c>   {SPCopy}
  bind .pdlg.t.b <Any-e>   {SPEdit}
  bind .pdlg.t.b <Any-d>   {SPDel}
  bind .pdlg.t.b <Any-u>   {SPMove -1}
  bind .pdlg.t.b <Any-w>   {SPMove 1}
  bind .pdlg.t.b <Delete>  {SPDel}
  bind .pdlg.t.b <Down>    {SPSetFields [%W index active]}
  bind .pdlg.t.b <Up>      {SPSetFields [%W index active]}
  bind .pdlg.t.b <1>	   {SPSetFields [%W nearest %y]}
  foreach w {ename eopt rintern rfg rbg rterm bapply bforget} {
    bind .pdlg.c.$w <Any-Return> {set pdlg(bapply) 1}
    bind .pdlg.c.$w <Escape>     {set pdlg(bapply) 0}
  }
  SPSelect $pdlg(sel)
  set old_focus [focus]
  focus .pdlg.t.b
  grab .pdlg
  tkwait var pdlg(ok)
  grab release .pdlg
  focus $old_focus
  destroy .pdlg
  if {$pdlg(ok)} {
    set params($cmd) $pdlg(cmds)
    set l [lindex $params($cmd) $pdlg(sel)]
    set params(${cmd}_name) [lindex $l 0]
    set params(${cmd}_default) $pdlg(sel)
    if {$cmd == "Util"} {
      utilmenu .menubar.mUtil
    }
    writeparams
  }
  return
}

# selectfilter

proc sfSetFields {i} {
  global pdlg

  set pdlg(sel) $i
  set l [lindex $pdlg(cmds) $i] 
  if {[llength $l] > 0} {set pdlg(name) [lindex $l 0]}
  if {[llength $l] > 1} {set pdlg(source) [lindex $l 1]}
  if {[llength $l] > 2} {set pdlg(target) [lindex $l 2]}
  if {[llength $l] > 3} {set pdlg(cmd) [lindex $l 3]}
}

proc sfSelect {i} {
  global pdlg

  .pdlg.t.b activate $i
  .pdlg.t.b select anchor $i
  .pdlg.t.b select set anchor $i
  .pdlg.t.b see $i
  sfSetFields $i
}

proc sfCopy {{new 0}} {
  global pdlg params

  if {$new} {
    foreach f {name cmd opt} {
      set pdlg($f) ""
    }
  }
  sfEnableEdit
  focus .pdlg.c.ename
  tkwait variable pdlg(bapply)
  if {$pdlg(bapply)} {
    lappend pdlg(cmds) [list $pdlg(name) $pdlg(source) $pdlg(target) \
      $pdlg(cmd)]
    .pdlg.t.b insert end $pdlg(name)
    set pdlg(sel) [expr [.pdlg.t.b size] - 1]
  }
  sfSelect $pdlg(sel)
  sfEnableEdit disable
  focus .pdlg.t.b
}

proc sfEdit {} {
  global pdlg

  sfEnableEdit
  focus .pdlg.c.ename
  tkwait variable pdlg(bapply)
  if {$pdlg(bapply)} {
    set l [list $pdlg(name) $pdlg(source) $pdlg(target) $pdlg(cmd)]
    set pdlg(cmds) \
      [lreplace $pdlg(cmds) $pdlg(sel) $pdlg(sel) $l]
    .pdlg.t.b delete $pdlg(sel)
    .pdlg.t.b insert $pdlg(sel) $pdlg(name)
  }
  sfSelect $pdlg(sel)
  sfEnableEdit disable
  focus .pdlg.t.b
}

proc sfDel {} {
  global pdlg params

  if {[Dialog .ddlg $params(dlg_geom) "" "Delete entry $pdlg(name)" \
    question 0 1 {Yes <Any-y>} {No <Any-n>}] == 0} {
    debug "PDel"
    set pdlg(cmds) \
      [lreplace $pdlg(cmds) $pdlg(sel) $pdlg(sel)]
    .pdlg.t.b delete $pdlg(sel)
    sfSelect 0
  }
}

proc sfMove {{dist 1}} {
  global pdlg

  if {$dist < 0 && $pdlg(sel) == 0} return
  if {$dist > 0 && $pdlg(sel) >= [expr [llength $pdlg(cmds)]-1]} return
  set l [lindex $pdlg(cmds) $pdlg(sel)]
  set pdlg(cmds) [lreplace $pdlg(cmds) $pdlg(sel) $pdlg(sel)]
  .pdlg.t.b delete $pdlg(sel)
  if {$dist < 0} {set dist -1} else {set dist 1}
  incr pdlg(sel) $dist
  set pdlg(cmds) [linsert $pdlg(cmds) $pdlg(sel) $l]
  .pdlg.t.b insert $pdlg(sel) [lindex $l 0]
  sfSelect $pdlg(sel)
}

proc sfEnableEdit {{state normal}} {
  global pdlg

  if {$state == "normal"} {
    set reverse disable
  } else {
    set reverse normal
  }
  foreach w {.pdlg.c.rtex .pdlg.c.rdvi .pdlg.c.etarget .pdlg.c.ecmd 
    .pdlg.c.ename .pdlg.c.bapply .pdlg.c.bforget} {
    $w configure -state $state
  }
}

proc selectfilter {} {
  global params pdlg

  toplevel .pdlg
  wm geometry .pdlg $params(dlg_geom)
  wm title .pdlg "Select Filter"

  frame .pdlg.t
  pack .pdlg.t -side top -fill x
  scrollbar .pdlg.t.s -command ".pdlg.t.b yview" -takefocus 0
  listbox .pdlg.t.b -yscroll ".pdlg.t.s set" -relief sunken -bd 1 \
    -takefocus 0
  grid .pdlg.t.b -row 0 -column 0 -rowspan 6 -sticky nsew
  grid .pdlg.t.s -row 0 -column 1 -rowspan 6 -sticky nsew
  button .pdlg.t.new -text "New" -underline 0 -command {sfCopy 1} -takefocus 0
  button .pdlg.t.copy -text "Copy" -underline 0 -command sfCopy -takefocus 0
  button .pdlg.t.edit -text "Edit" -underline 0 -command sfEdit -takefocus 0
  button .pdlg.t.del  -text "Delete" -underline 0 -command sfDel -takefocus 0
  button .pdlg.t.up   -text "Move Up"  -underline 5 -command {sfMove -1} \
    -takefocus 0
  button .pdlg.t.down -text "Move Down" -underline 7 -command {sfMove 1} \
    -takefocus 0
  grid .pdlg.t.new  -row 0 -column 2 -sticky ew
  grid .pdlg.t.copy -row 1 -column 2 -sticky ew
  grid .pdlg.t.edit -row 2 -column 2 -sticky ew
  grid .pdlg.t.del  -row 3 -column 2 -sticky ew
  grid .pdlg.t.up   -row 4 -column 2 -sticky ew
  grid .pdlg.t.down -row 5 -column 2 -sticky ew
  grid columnconfigure .pdlg.t 0 -weight 1

  frame .pdlg.r1 -height 2 -bd 1 -relief sunken
  pack .pdlg.r1 -pady 2 -fill x

  frame .pdlg.c
  pack .pdlg.c -side top -fill x
  label .pdlg.c.lname -text "Name:"
  entry .pdlg.c.ename -textvariable pdlg(name) -width 8 -state disabled
  grid .pdlg.c.lname -row 0 -column 0 -sticky w
  grid .pdlg.c.ename -row 0 -column 1 -columnspan 4 -sticky w
  label .pdlg.c.lsource -text "Source:"
  radiobutton .pdlg.c.rtex -text "TeX" -variable pdlg(source) -value "%r.tex" \
    -state disabled -indicatoron 0
  radiobutton .pdlg.c.rdvi -text "DVI" -variable pdlg(source) -value "%r.dvi" \
    -state disabled -indicatoron 0
  grid .pdlg.c.lsource -row 1 -column 0 -sticky w
  grid .pdlg.c.rtex -row 1 -column 1 -sticky w
  grid .pdlg.c.rdvi -row 1 -column 2 -sticky w
  label .pdlg.c.ltarget -text "Target:"
  entry .pdlg.c.etarget -textvariable pdlg(target) -width 20 -state disabled
  grid .pdlg.c.ltarget -row 2 -column 0 -sticky w
  grid .pdlg.c.etarget -row 2 -column 1 -columnspan 4 -sticky w
  label .pdlg.c.lcmd -text "Command:"
  entry .pdlg.c.ecmd -textvariable pdlg(cmd) -width 40 -state disabled
  grid .pdlg.c.lcmd -row 3 -column 0 -sticky w
  grid .pdlg.c.ecmd -row 3 -column 1 -columnspan 4 -sticky w
  button .pdlg.c.bapply -text Apply -default active -state disabled \
    -command {set pdlg(bapply) 1}
  button .pdlg.c.bforget -text Forget -state disabled \
    -command {set pdlg(bapply) 0}
  grid .pdlg.c.bapply -row 4 -column 1 -columnspan 2
  grid .pdlg.c.bforget -row 4 -column 3
  grid columnconfigure .pdlg.c 4 -weight 1

  frame .pdlg.r2 -height 2 -bd 1 -relief sunken
  pack .pdlg.r2 -fill x -side top -pady 2

  frame .pdlg.b
  pack .pdlg.b -fill x -side top
  button .pdlg.b.bok -text OK -default active -command {set pdlg(ok) 1} \
    -takefocus 0
  button .pdlg.b.bcancel -text Cancel -command {set pdlg(ok) 0} -takefocus 0
  pack .pdlg.b.bok -side left -expand true -padx 10 -pady 5
  pack .pdlg.b.bcancel -side left -expand true -padx 10 -pady 5

  set pdlg(cmds) $params(Filter)
  foreach l $pdlg(cmds) {
    .pdlg.t.b insert end [lindex $l 0]
  }
  set pdlg(sel) $params(Filter_default)
  set pdlg(name) $params(Filter_name)
  sfSetFields $pdlg(sel)

# Bindings
  bindtags .pdlg.t.b [list Listbox .pdlg.t.b all]
  bind .pdlg.t.b <Any-Return> {set pdlg(ok) 1}
  bind .pdlg.t.b <Escape>  {set pdlg(ok) 0}
  bind .pdlg.t.b <Any-n>   {sfCopy 1}
  bind .pdlg.t.b <Any-c>   {sfCopy}
  bind .pdlg.t.b <Any-e>   {sfEdit}
  bind .pdlg.t.b <Any-d>   {sfDel}
  bind .pdlg.t.b <Any-u>   {sfMove -1}
  bind .pdlg.t.b <Any-w>   {sfMove 1}
  bind .pdlg.t.b <Delete>  {sfDel}
  bind .pdlg.t.b <Down>    {sfSetFields [%W index active]}
  bind .pdlg.t.b <Up>      {sfSetFields [%W index active]}
  bind .pdlg.t.b <1>	   {sfSetFields [%W nearest %y]}
  foreach w {ename ecmd rtex rdvi etarget ename bapply bforget} {
    bind .pdlg.c.$w <Any-Return> {set pdlg(bapply) 1}
    bind .pdlg.c.$w <Escape>     {set pdlg(bapply) 0}
  }
  sfSelect $pdlg(sel)
  set old_focus [focus]
  focus .pdlg.t.b
  grab .pdlg
  tkwait var pdlg(ok)
  grab release .pdlg
  focus $old_focus
  destroy .pdlg
  if {$pdlg(ok)} {
    set params(Filter) $pdlg(cmds)
    set l [lindex $params(Filter) $pdlg(sel)]
    set params(Filter_name) [lindex $l 0]
    set params(Filter_default) $pdlg(sel)
    writeparams
  }
  return
}

proc SACmd {} {
  global adlg params

  set params($adlg(cmd)_default) [.selact index active]
  set l [lindex $params($adlg(cmd)) $params($adlg(cmd)_default)]
  set params($adlg(cmd)_name) [lindex $l 0]

  grab release .selact
  focus $adlg(focus)
  .selact unpost
  destroy .selact
}

proc SelectAction {w cmd} {
  global adlg params

  #if [winfo exists .selact] {destroy .selact}
  set adlg(list) {}
  set adlg(cmd) $cmd
  catch {menu .selact -tearoff 0}
  .selact delete 0 end
  foreach e $params($cmd) {
    lappend adlg(list) [lindex $e 0]
    .selact add command -label [lindex $e 0] -command {SACmd}
  }
  set x [winfo rootx $w]
  set y [expr [winfo rooty $w] + [winfo height $w]]
  .selact post $x $y
  .selact activate $params(${cmd}_default)
  set adlg(focus) [focus]
  focus .selact
  grab -global .selact
}

proc eoGetColor {w x} {
  global odlg

  set odlg(colorval) [format "#%02x%02x%02x" \
    $odlg(red) $odlg(green) $odlg(blue)]
  if {$odlg(grd) == "bg" && $odlg(kind) != "search"} {
    foreach k {normal comment err env} {
      $w.l$k configure -bg $odlg(colorval)
      set odlg(bgnormal) $odlg(colorval)
    }
  } else {
    $w.l$odlg(kind) configure -$odlg(grd) $odlg(colorval)
    set odlg($odlg(grd)$odlg(kind)) $odlg(colorval)
  }
  $w.sred configure -troughcolor [format "#%02x0000" $odlg(red)]
  $w.sgreen configure -troughcolor [format "#00%02x00" $odlg(green)]
  $w.sblue configure -troughcolor [format "#0000%02x" $odlg(blue)]
}

proc eoSetColor {w} {
  global odlg

  if {$odlg(grd) == "bg" && $odlg(kind) != "search"} {
    set rgb $odlg(bgnormal)
  } else {
    set rgb $odlg($odlg(grd)$odlg(kind))
  }
  scan $rgb "#%02x%02x%02x" odlg(red) odlg(green) odlg(blue)
  eoGetColor $w 0
}

proc eoSelFont {w} {
  global odlg

  foreach k {normal comment err search env} {
    $w.l$k configure -font [list $odlg(font) $odlg(fontsize) $odlg(fontstyle)]
  }
}

proc OptionsColor {w} {
  global odlg

  radiobutton $w.fg -text Foreground -variable odlg(grd) -value fg \
    -command "eoSetColor $w" -indicatoron 0
  radiobutton $w.bg -text Background -variable odlg(grd) -value bg \
    -command "eoSetColor $w" -indicatoron 0
  entry $w.colorval -textvariable odlg(colorval) -width 7 -font fixed
  grid $w.fg -row 0 -column 0 -sticky ew
  grid $w.bg -row 0 -column 1 -sticky ew
  grid $w.colorval -row 0 -column 2 -columnspan 3
  radiobutton $w.rnormal -text "Normal:" -variable odlg(kind) -value normal \
    -command "eoSetColor $w"
  radiobutton $w.rcomment -text "Comment" -variable odlg(kind) \
    -value comment -command "eoSetColor $w"
  radiobutton $w.rerr -text "Mistake:" -variable odlg(kind) \
    -value err -command "eoSetColor $w"
  radiobutton $w.renv -text "\\begin\\end:" -variable odlg(kind) -value env \
    -command "eoSetColor $w"
  radiobutton $w.rsearch -text "Search:" -variable odlg(kind) -value search \
    -command "eoSetColor $w"
  label $w.lnormal -text "Normal text" -anchor w
  label $w.lcomment -text "% A Comment" -anchor w
  label $w.lerr -text "a missteke" -anchor w
  label $w.lenv -text "\\begin{letter}" -anchor w
  label $w.lsearch -text "Search text" -anchor w
  grid $w.rnormal  -row 1 -column 0 -sticky w
  grid $w.lnormal  -row 1 -column 1 -sticky ew
  grid $w.rcomment -row 2 -column 0 -sticky w
  grid $w.lcomment -row 2 -column 1 -sticky ew
  grid $w.rerr -row 3 -column 0 -sticky w
  grid $w.lerr -row 3 -column 1 -sticky ew
  grid $w.renv     -row 4 -column 0 -sticky w
  grid $w.lenv     -row 4 -column 1 -sticky ew
  grid $w.rsearch  -row 5 -column 0 -sticky w
  grid $w.lsearch  -row 5 -column 1 -sticky ew
  scale $w.sred -from 0 -to 255 -orient vertical -variable odlg(red) \
    -command "eoGetColor $w" -showvalue 0
  scale $w.sgreen -from 0 -to 255 -orient vertical -variable odlg(green) \
    -command "eoGetColor $w" -showvalue 0
  scale $w.sblue -from 0 -to 255 -orient vertical -variable odlg(blue) \
    -command "eoGetColor $w" -showvalue 0
  grid $w.sred   -row 1 -column 2 -rowspan 5 -sticky ns
  grid $w.sgreen -row 1 -column 3 -rowspan 5 -sticky ns
  grid $w.sblue  -row 1 -column 4 -rowspan 5 -sticky ns
  label $w.lfont -text "Font:"
  ts_optionMenu $w.bfont odlg(font) "eoSelFont $w" fixed courier
  ts_optionMenu $w.bfsize odlg(fontsize) "eoSelFont $w" 8 10 12 14 16 18 20
  ts_optionMenu $w.bfstyle odlg(fontstyle) "eoSelFont $w" normal italic bold 
  grid $w.lfont -row 6 -column 0 -sticky w
  grid $w.bfont -row 7 -column 0 -sticky ew
  grid $w.bfstyle -row 7 -column 1 -sticky ew
  grid $w.bfsize -row 7 -column 2 -columnspan 3 -sticky w
}

proc eoReconfig {} {
  global gparams params odlg

  foreach l [array names odlg] {
    set gparams($l) $odlg($l)
  }
  .term config \
    -font [list $gparams(font) $gparams(fontsize) $gparams(fontstyle)]
  for {set i 0} {$i < 10} {incr i} {
    if [winfo exists .t$i] {
      .t$i.text config -bg $gparams(bgnormal) -fg $gparams(fgnormal) \
        -insertbackground $gparams(fgnormal) \
        -font [list $gparams(font) $gparams(fontsize) $gparams(fontstyle)] \
        -width $gparams(editwidth) -height $gparams(editheight)
      .t$i.text tag configure comment -foreground $gparams(fgcomment)
      .t$i.text tag configure env -foreground $gparams(fgenv)
      .t$i.text tag configure repl -background $gparams(bgsearch) \
        -foreground $gparams(fgsearch)
    }
  }
  writeparams
}


proc EditOptions {} {
  global params odlg gparams

  toplevel .odlg
  wm geometry .odlg $params(dlg_geom)
  wm title .odlg "Global settings"

  frame .odlg.p
  pack .odlg.p -side top -fill both -pady 2 -anchor w
  frame .odlg.r1 -height 2 -bd 1 -relief sunken
  pack .odlg.r1 -fill x
  frame .odlg.c
  pack .odlg.c -side top -fill both -pady 2
  frame .odlg.r2 -height 2 -bd 1 -relief sunken
  pack .odlg.r2 -fill x
  frame .odlg.b
  pack .odlg.b -fill x -pady 2

  checkbutton .odlg.p.bsave -text "Autosave" -anchor w \
    -variable odlg(save)
  label .odlg.p.linterval -text "Interval \[s\]:"
  entry .odlg.p.einterval -width 4 -textvariable odlg(interval)
  checkbutton .odlg.p.bbak  -text "BAK File" -anchor w \
    -variable odlg(bak)
  label .odlg.p.lesize -text "Editor size:"
  entry .odlg.p.eewidth -textvariable odlg(editwidth) -width 4
  label .odlg.p.lex -text "x"
  entry .odlg.p.eeheight -textvariable odlg(editheight) -width 4
  label .odlg.p.ltab -text "Tab Stop:"
  entry .odlg.p.etab -textvariable odlg(tabstop) -width 4
  checkbutton .odlg.p.bwrap -text "Auto Wrap" -anchor w \
    -variable odlg(wrap)
  checkbutton .odlg.p.baind  -text "AutoIndent" -anchor w \
    -variable odlg(autoind)
  checkbutton .odlg.p.bext  -text "Auto \\end{..}" -anchor w \
    -variable odlg(autoext)
  grid .odlg.p.bsave -row 0 -column 0 -sticky w
  grid .odlg.p.linterval -row 0 -column 1 -columnspan 2 -sticky w
  grid .odlg.p.einterval -row 0 -column 3 -sticky w
  grid .odlg.p.bbak -row 0 -column 4 -sticky w
  grid .odlg.p.lesize -row 1 -column 0 -sticky w
  grid .odlg.p.eewidth -row 1 -column 1 -sticky e
  grid .odlg.p.lex -row 1 -column 2 -sticky w
  grid .odlg.p.eeheight -row 1 -column 3 -sticky w
  grid .odlg.p.ltab -row 2 -column 0
  grid .odlg.p.etab -row 2 -column 1 -sticky e
  grid .odlg.p.bwrap -row 3 -column 0 -sticky w
  grid .odlg.p.baind -row 3 -column 1 -columnspan 3 -sticky w
  grid .odlg.p.bext -row 3 -column 4 -sticky w

  radiobutton .odlg.c.fg -text Foreground -variable odlg(grd) -value fg \
    -command "eoSetColor .odlg.c" -indicatoron 0
  radiobutton .odlg.c.bg -text Background -variable odlg(grd) -value bg \
    -command "eoSetColor .odlg.c" -indicatoron 0
  entry .odlg.c.colorval -textvariable odlg(colorval) -width 7 -font fixed
  grid .odlg.c.fg -row 0 -column 0 -sticky ew
  grid .odlg.c.bg -row 0 -column 1 -sticky ew
  grid .odlg.c.colorval -row 0 -column 2 -columnspan 3
  radiobutton .odlg.c.rnormal -text "Normal:" -variable odlg(kind) \
    -value normal -command "eoSetColor .odlg.c"
  radiobutton .odlg.c.rcomment -text "Comment" -variable odlg(kind) \
    -value comment -command "eoSetColor .odlg.c"
  radiobutton .odlg.c.rerr -text "Mistake:" -variable odlg(kind) \
    -value err -command "eoSetColor .odlg.c"
  radiobutton .odlg.c.renv -text "\\begin\\end:" -variable odlg(kind) \
    -value env -command "eoSetColor .odlg.c"
  radiobutton .odlg.c.rsearch -text "Search:" -variable odlg(kind) \
    -value search -command "eoSetColor .odlg.c"
  label .odlg.c.lnormal -text "Normal text" -anchor w
  label .odlg.c.lcomment -text "% A Comment" -anchor w
  label .odlg.c.lerr -text "a missteke" -anchor w
  label .odlg.c.lenv -text "\\begin{letter}" -anchor w
  label .odlg.c.lsearch -text "Search text" -anchor w
  grid .odlg.c.rnormal  -row 1 -column 0 -sticky w
  grid .odlg.c.lnormal  -row 1 -column 1 -sticky ew
  grid .odlg.c.rcomment -row 2 -column 0 -sticky w
  grid .odlg.c.lcomment -row 2 -column 1 -sticky ew
  grid .odlg.c.rerr -row 3 -column 0 -sticky w
  grid .odlg.c.lerr -row 3 -column 1 -sticky ew
  grid .odlg.c.renv     -row 4 -column 0 -sticky w
  grid .odlg.c.lenv     -row 4 -column 1 -sticky ew
  grid .odlg.c.rsearch  -row 5 -column 0 -sticky w
  grid .odlg.c.lsearch  -row 5 -column 1 -sticky ew
  scale .odlg.c.sred -from 0 -to 255 -orient vertical -variable odlg(red) \
    -command "eoGetColor .odlg.c" -showvalue 0 -bg red
  scale .odlg.c.sgreen -from 0 -to 255 -orient vertical -variable odlg(green) \
    -command "eoGetColor .odlg.c" -showvalue 0 -bg green
  scale .odlg.c.sblue -from 0 -to 255 -orient vertical -variable odlg(blue) \
    -command "eoGetColor .odlg.c" -showvalue 0 -bg blue
  grid .odlg.c.sred   -row 1 -column 2 -rowspan 5 -sticky ns
  grid .odlg.c.sgreen -row 1 -column 3 -rowspan 5 -sticky ns
  grid .odlg.c.sblue  -row 1 -column 4 -rowspan 5 -sticky ns
  label .odlg.c.lfont -text "Font:"
  ts_optionMenu .odlg.c.bfont odlg(font) "eoSelFont .odlg.c" fixed courier
  ts_optionMenu .odlg.c.bfstyle odlg(fontstyle) "eoSelFont .odlg.c" \
    normal italic bold 
  ts_optionMenu .odlg.c.bfsize odlg(fontsize) "eoSelFont .odlg.c" \
    8 10 12 14 16 18 20
  grid .odlg.c.lfont -row 6 -column 0 -sticky w
  grid .odlg.c.bfont -row 7 -column 0 -sticky ew
  grid .odlg.c.bfstyle -row 7 -column 1 -sticky ew
  grid .odlg.c.bfsize -row 7 -column 2 -columnspan 3 -sticky w

  button .odlg.b.bok -text "OK" -command {set odlg(ok) 1} -default active
  button .odlg.b.bcancel -text Cancel -command {set odlg(ok) 0}
  pack .odlg.b.bok .odlg.b.bcancel -side left -pady 5 -expand 1

  bind .odlg <Control-Return> { set odlg(ok) 1 }
  bind .odlg <Escape> { set odlg(ok) 0 }

  set odlg(seltxt) normal
  set odlg(font) fixed
  set odlg(fontsize) 12
  set odlg(fontstyle) normal
  set odlg(wrap) 1
  set odlg(interval) 30
  set odlg(bak) 0
  set odlg(save) 1
  set odlg(fgnormal) #000000
  set odlg(bgnormal) #ffffff
  set odlg(fgcomment) #000000
  set odlg(fgerr) #ff0000
  set odlg(fgenv) #000000
  set odlg(fgsearch) #ffffff
  set odlg(bgsearch) #000000
  set odlg(termwidth) 80
  set odlg(termheight) 24
  set odlg(editwidth) 80
  foreach l [array names gparams] {
    set odlg($l) $gparams($l)
  }
  if {$odlg(pos) == ""} {
    set odlg(pos) "+[winfo rootx .]+[winfo rooty .]"
  }
  set odlg(grd) fg
  set odlg(kind) normal
  foreach r {normal comment err env} {
    .odlg.c.l$r configure -fg $odlg(fg$r) -bg $odlg(bgnormal)
  }
  .odlg.c.lsearch configure -fg $odlg(fgsearch) -bg $odlg(bgsearch)
  eoSetColor .odlg.c 
  eoSelFont .odlg.c
  set odlg(page) general                                 
  set old_focus [focus]
  focus .odlg.p.bsave
  grab .odlg
  tkwait variable odlg(ok)
  if {$odlg(ok)} {
    eoReconfig
  }
  grab release .odlg
  focus $old_focus
  destroy .odlg
  return
}

proc goReconfig {} {
  global gparams params odlg

  foreach l [array names odlg] {
    set gparams($l) $odlg($l)
  }
  if {$odlg(pos) != ""} {
    set gparams(pos) $odlg(pos)
    update idletasks
    wm withdraw .
    wm geometry . $odlg(pos)
    wm deiconify .
    SetPos   
  } else {
    set pos [wm geometry .]
    if {[regexp {\+[0-9]+\+[0-9]+} $pos pos]} {
      set gparams(pos) $pos
    }
  }
  .term config -width $gparams(termwidth) -height $gparams(termheight)
  writeparams
}

proc GlobalOptions {} {
  global params odlg gparams

  toplevel .odlg
  wm geometry .odlg $params(dlg_geom)
  wm title .odlg "Global settings"

  frame .odlg.nb
  pack .odlg.nb -side top -fill both -pady 2
  frame .odlg.r2 -height 2 -bd 1 -relief sunken
  pack .odlg.r2 -fill x
  frame .odlg.b
  pack .odlg.b -fill x -pady 2

  label .odlg.nb.lpos -text "TS Window Position:" -underline 4
  entry .odlg.nb.epos -textvariable odlg(pos) -font fixed -width 10
  grid .odlg.nb.lpos -row 0 -column 0 -sticky w
  grid .odlg.nb.epos -row 0 -column 1 -columnspan 3 -sticky w
  label .odlg.nb.lhlp -text "Help language:" -underline 0 -anchor w
  ts_optionMenu .odlg.nb.ohlp odlg(hlplan) "" deutsch english
  grid .odlg.nb.lhlp -row 1 -column 0 -sticky nw
  grid .odlg.nb.ohlp -row 1 -column 1 -columnspan 3 -sticky w
  label .odlg.nb.ltsize -text "Terminal size:" -underline 0
  entry .odlg.nb.etw -textvariable odlg(termwidth) -font fixed -width 3
  label .odlg.nb.ltx -text "x" -underline 0
  entry .odlg.nb.eth -textvariable odlg(termheight) -font fixed -width 3
  grid .odlg.nb.ltsize -row 2 -column 0 -sticky w
  grid .odlg.nb.etw -row 2 -column 1 -sticky w
  grid .odlg.nb.ltx -row 2 -column 2 -sticky w
  grid .odlg.nb.eth -row 2 -column 3 -sticky w
  frame .odlg.nb.r1 -height 2 -bd 1 -relief sunken
  label .odlg.nb.lispell -text "Ispell parameter"
  label .odlg.nb.llang -text "Language (-d):" -underline 0 -anchor w
  entry .odlg.nb.elang -textvariable odlg(splang)
  label .odlg.nb.lenc -text "Encoding (-T):" -underline 0 -anchor w
  entry .odlg.nb.eenc -textvariable odlg(spenc)
  grid .odlg.nb.r1 -row 3 -column 0 -columnspan 4 -sticky ew -pady 2
  grid .odlg.nb.lispell -row 4 -column 0 -columnspan 2 -sticky w
  grid .odlg.nb.llang -row 5 -column 0 -sticky w
  grid .odlg.nb.elang -row 5 -column 1 -columnspan 3 -sticky w
  grid .odlg.nb.lenc -row 6 -column 0 -sticky w
  grid .odlg.nb.eenc -row 6 -column 1 -columnspan 3 -sticky w

  button .odlg.b.bok -text "Ok" -command {set odlg(ok) 1} -default active
  button .odlg.b.bcancel -text Cancel -command {set odlg(ok) 0}
  pack .odlg.b.bok .odlg.b.bcancel -side left -pady 5 -expand 1

  bind .odlg <Control-Return> { set odlg(ok) 1 }
  bind .odlg <Escape> { set odlg(ok) 0 }

  foreach l [array names gparams] {
    set odlg($l) $gparams($l)
  }
  if {$odlg(pos) == ""} {
    set odlg(pos) "+[winfo rootx .]+[winfo rooty .]"
  }
  set old_focus [focus]
  focus .odlg.nb.epos
  grab .odlg
  tkwait variable odlg(ok)
  if {$odlg(ok)} {
    goReconfig
  }
  grab release .odlg
  focus $old_focus
  destroy .odlg
  return
}
