/* -*-C-*- */
#include "texsgi.h"
#include "globals.h"
#include "proto.h"
char           *getenv(char *s);
static int helpwid = -1, pagewid = -1;

int
  main(argc, argv)
int             argc;
char           *argv[];
{
  register int    k;  /* loop index */
  register int    file_args;  /* count of file arguments */
  
  
  (void) strcpy(g_progname, argv[0]);  /* save program name */
  
  (void) initglob();  /* do this before argc check! */
  (void) read_startup_file("");
  
  for (k = 1; k < argc; ++k) {
    if (*argv[k] == '-')  /* -switch */
      (void) option(argv[k]);
  }
  
  if (!quiet) {
    (void) fprintf(stderr, "[TeX82 DVI Version %s]\n", VERSION_NO);
    (void) fprintf(stderr, "[%s]\n", DEVICE_ID);
  }
  if (npage == 0) {  /* no page ranges given, make a large one */
    page_begin[0] = 1;
    page_end[0] = 32767;  /* arbitrary large integer */
    page_step[0] = 1;
    npage = 1;
  } else      /* need font defs from postamble if only some
	       * pages to be output */
    preload = TRUE;
  
  file_args = 0;
  for (k = 1; k < argc; ++k) {
    if (*argv[k] != '-') {  /* must be file argument */
      file_args++;
      (void) dvifile(argc, argv, argv[k]);
    }
  }
  
  if (file_args == 0)  /* use stdin/stdout instead */
    (void) dvifile(argc, argv, "");
  
  (void) alldone();  /* this will never return */
  return (0);    /* never executed; avoid compiler warnings */
}

void parse_config_file(fp)
     FILE *fp;
{
  char line[128], word[32], *p, *w;
  
  while(fgets(line, 132, fp)) {
    p = line;
    w = word;
    while(!isalpha(*p))
      p++;
    while(isalpha(*p))
      *w++ = *p++;
    *w = '\0';
    if(strcmp(word, "prefposition") == 0)
      sscanf(p, " %d %d %d %d ", &win_left, &win_right, &win_bottom, &win_top);
    if(strcmp(word, "prefsize") == 0)
      sscanf(p, " %d %d ", &win_x_size, &win_y_size);
    if(strcmp(word, "keepaspect") == 0)
      sscanf(p, " %d %d ", &win_y_aspect, &win_x_aspect);
    if(strcmp(word, "quiet") == 0) {
      quiet = TRUE;
    }
    if(strcmp(word, "helpposition") == 0)
      sscanf(p, " %d %d ", &help_ox, &help_oy);
    if(strcmp(word, "showhelp") == 0) {
      showhelp = TRUE;
    }
    if(strcmp(word, "noshowhelp") == 0) {
      showhelp = FALSE;
    }
    if(strcmp(word, "inverse") == 0) {
      fgcolor = BGCOLOR;
      bgcolor = FGCOLOR;
    }
    if (strcmp(word, "leftmargin") == 0) {
      leftmargin = inch(++p);
    }
    if (strcmp(word, "topmargin") == 0) {
      topmargin = inch(++p);
    }
/*
    if (strcmp(word, "nopreload") == 0) {
      preload = FALSE;
    }
*/
    if(strcmp(word, "magnification") == 0)
      sscanf(p, " %d ", &runmag);
  }
}

void
  read_startup_file(filename)
char *filename;
{
  char *home, f[128];
  FILE *fp;

  if (filename[0] == '\0') {
    home = getenv("HOME");
    if(home != (char *)NULL) {
      strcpy(f, home);
      strcat(f, "/.texsgirc"); /* ~/.texsgirc */
      fp = fopen(f, "r");
      if(fp != (FILE *)NULL) {
	parse_config_file(fp);
	fclose(fp);
      }
    }
    fp = fopen(".texsgirc", "r"); /* current directory */
    if(fp != (FILE *)NULL) {
      parse_config_file(fp);
      fclose(fp);
    }
  } else {
    fp = fopen(filename, "r"); /* specified with -S switch */
    if(fp != (FILE *)NULL) {
      parse_config_file(fp);
      fclose(fp);
    } else {
      fprintf(stderr, "texsgi: cannot open optional startup file (%s)\n",
	      filename);
    }
  }
}

void
  abortrun(code)
int             code;

{
  /*******************************************************************
    This routine  is called  on both  success and  failure to  terminate
    execution.  All open files (except stdin, stdout, stderr) are closed
    before calling exit() to quit.
    *******************************************************************/
  
  UNSIGN16        k;
  
  for (k = 0; k < (UNSIGN16) nopen; ++k)
    if (font_files[k].font_id != (FILE *) NULL)
      (void) fclose(font_files[k].font_id);
  
  if (dvifp != (FILE *) NULL)
    (void) fclose(dvifp);
  if (plotfp != (FILE *) NULL)
    (void) fclose(plotfp);
  if (g_dolog && (g_logfp != (FILE *) NULL))
    (void) fclose(g_logfp);
  
  (void) exit(code);
}


float
  actfact(unmodsize)
register UNSIGN32 unmodsize;

/***********************************************************************
  Compute the actual size factor given the integer approximation unmodsize
  = (magnification  factor)*1000.   Values  not found  in  the  table  are
  rounded to the nearest table  entry; this ensures that rounding  errors,
  or  user  magnification  parameter  input  errors  result  in  something
  reasonable.  mag_table[] has a  wider range of magnifications  available
  than most sites will have, and can be used to find a nearest match  font
  when one is missing.
  ***********************************************************************/

{
  register INT16  k;
  register UNSIGN32 tab_entry;
  
  for (k = 1; k < MAGTABSIZE; ++k) {
    tab_entry = MAGSIZE(mag_table[k]);  /* round entry */
    if (unmodsize < tab_entry) {  /* choose nearer of k-1,k
				   * entries */
      if (unmodsize < MAGSIZE((mag_table[k - 1] + mag_table[k]) / 2.0))
	k--;  /* choose smaller one */
      break;
    } else if (unmodsize == tab_entry)
      break;
  }
  mag_index = ((k < MAGTABSIZE) ? k : (MAGTABSIZE - 1));  /* set global index */
  return ((float) mag_table[mag_index]);
}


void
  alldone()
{
  register int    t;
  
  if ((g_errenc != 0) && g_dolog && (g_logfp != (FILE *) NULL)) { 
    /* 
     * errors occurred - copy log file to stderr
     */
    (void) fflush(g_logfp);  /* make sure file is up-to-date */
    (void) rewind(g_logfp);  /* rewind it */
    while ((t = (int) getc(g_logfp)) != EOF)  /* copy to stderr */
      (void) putc((char) t, stderr);
    (void) fclose(g_logfp);  /* close it */
    g_logfp = (FILE *) NULL;
  }
  abortrun(g_errenc);
}


void
  clearpage()
{
  color(bgcolor);
  clear();
}

void
  drawstatusline()
{
  char            buf[128];
  
  color(bgcolor);
  sboxf(27, 3, (win_x_size - 3), 20);
  color(fgcolor);
  sbox(27, 3, (win_x_size - 3), 20);
  sprintf(buf,
	  "Document [%s] page: %d/%d  TeX pages: %s, (X[%d], Y[%d], Mag[%ld])",
	  dviname,
	  (int) (cur_index + 1), (int) page_count, tctos(),
	  (int) xscreen, (int) yscreen, (long) runmag);
  cmov2i(30, 5);
  charstr(buf);
  color(bgcolor);
}

void
  bopact()
{        /* beginning-of-page action */
  setcursor(0, 0, 0);
  pbghpos = pbgvpos = -99;
  cpagep = (long) ftell(dvifp) - 1L;
  ppagep = (long) nosignex(dvifp, (BYTE) 4);
  
  clearpage();
}

void
  clrrow()
{        /* clear the current character image row,
	  * parray[] */
}

void
  clrparr(p, m, n)
short           p[];
int             m, n;
{
  int             i;
  
  for (i = 0; i < (m + 1) * (n + 1); i++)
    p[i] = bgcolor;
}

void
  devinit(argc, argv)    /* initialize device */
int             argc;
char           *argv[];
{
  register UNSIGN16 the_font;  /* loop index */
  register UNSIGN16 the_char;  /* loop index */
  
  char           *tcp;
  
#if    ALLOW_INTERRUPT
#else        /* NOT ALLOW_INTERRUPT */
  signal(SIGINT, SIG_IGN);/* ignore interrupts */
#endif        /* ALLOW_INTERRUPT */

  if (showhelp) {
    printhelp();
  }
  initterm();
  qdevice(KEYBD);
  qdevice(WINCLOSE);
  qdevice(WINQUIT);
  
#if    ALLOW_INTERRUPT
#else        /* NOT ALLOW_INTERRUPT */
  signal(SIGINT, gotint);  /* catch interrupts */
#endif        /* ALLOW_INTERRUPT */
  
  /* Clear all font char_entry pointers */
  for (the_font = 0; the_font < (NBGFONTS + (NBGFONTS + 2) / 3); ++the_font)
    for (the_char = FIRSTPXLCHAR; the_char <= LASTPXLCHAR; ++the_char)
      bgcp[the_font][the_char] = (struct char_entry *) NULL;
}

void
  devterm()
{        /* terminate device */
  rsetterm();
}

void
  eopact()
{        /* end-of-page action */
  int             dev, saved_val;
  INT16           np;  /* input page number */
  BOOLEAN         show_page;  /* page redisplay flag */
  int             tc;  /* temporary character */
  short           val;
  
  drawstatusline();
  saved_val = FALSE;
  show_page = FALSE;
  for (;;) {
    if (!saved_val)
      dev = qread(&val);
    /* fprintf(stderr,"dev = %d, val = %o\n", dev, (int)val); */
    switch (dev) {
    case REDRAW:
      if (val == helpwid) {
	printhelp();
	reshapeviewport();
      } else {
	show_page = TRUE;
	reshapeviewport();
	getsize(&win_x_size, &win_y_size);
	ortho2(0.0, (float) win_x_size, 0.0, (float) (win_y_size));
      }
      break;
    case WINCLOSE:
      if (val == helpwid) {
	winclose(helpwid);
	helpwid = -1;
      }
      break;
    case KEYBD:
      tc = val;
      switch (tc) {
      case '0':  /* goto n-th page (recursively) */
      case '1':
      case '2':
      case '3':
      case '4':
      case '5':
      case '6':
      case '7':
      case '8':
      case '9':
	np = DIGVAL(tc);
	for (;;) {
	  dev = qread(&val);
	  tc = val;
	  if (isdigit(tc))
	    np = 10 * np + DIGVAL(tc);
	  else if ((tc == '\177') || (tc == '\b'))
	    np /= 10;  /* rubout last digit */
	  else {
	    saved_val = TRUE;
	    break;
	  }
	}
	np = MIN(np, page_count);  /* big numbers go to
				    * last page */
	if (np > 0) {  /* got a page number */
	  cur_index = np - 1;
	  show_page = TRUE;  /* out-of-sequence page */
	  xscreen = 0;
	  yscreen = 0;
	} else
	  show_page = FALSE;
	break;
	
      case ' ':  /* normal case - start next page */
      case '+':
      case 'f':
      case '\026':  /* CTRL-V, emacs users */
	if (cur_index < page_count - 1) {
	  cur_index++;
	} else {
	  cur_index = 0;
	}
	xscreen = 0;
	yscreen = 0;
	show_page = TRUE;
	break;
	
      case '-':  /* redisplay from previous page */
      case 'b':
      case 0366: /* ALT-V, emacs users */
      case '\b':
	if (cur_index > 0) {
	  cur_index--;
	} else {  /* no previous page--ignore */
	  cur_index = page_count -1;
	}
	xscreen = 0;
	yscreen = 0;
	show_page = TRUE;
	break;
	
      case '\004':  /* CTRL-D */
	yscreen += (YSIZE / MINFRAC);
	show_page = TRUE;
	break;
	
      case 'd':  /* move down and redisplay  */
      case '\016':  /* CTL-N */
	yscreen += (YSIZE / NORMFRAC);
	show_page = TRUE;
	break;
	
      case 'D':
	yscreen += (YSIZE / MAXFRAC);
	show_page = TRUE;
	break;
	
      case '\025':  /* CTRL-U */
	yscreen -= (YSIZE / MINFRAC);
	show_page = TRUE;
	break;
	
      case 'u':  /* move up and redisplay */
      case '\020':  /* CTL-P */
	yscreen -= (YSIZE / NORMFRAC);
	show_page = TRUE;
	break;
	
      case 'U':
	yscreen -= (YSIZE / MAXFRAC);
	show_page = TRUE;
	break;
	
      case '\022':  /* CTRL-R */
	xscreen -= (XSIZE / MINFRAC) / 2;
	show_page = TRUE;
	break;
	
      case 'r':  /* move right and redisplay */
      case '\006':  /* CTL-F */
	xscreen -= (XSIZE / NORMFRAC) / 2;
	show_page = TRUE;
	break;
	
      case 'R':
	xscreen -= (XSIZE / MAXFRAC) / 2;
	show_page = TRUE;
	break;
	
      case '\014': /* CTRL-L */
	xscreen += (XSIZE / MINFRAC) / 2;
	show_page = TRUE;
	break;
	
      case 'l':  /* move left and redisplay */
      case '\002':  /* CTL-B */
	xscreen += (XSIZE / NORMFRAC) / 2;
	show_page = TRUE;
	break;
	
      case 'L':
	xscreen += (XSIZE / MAXFRAC) / 2;
	show_page = TRUE;
	break;
	
      case 'i':  /* reverse fgcolor and bgcolor */
	{
	  int             tmp;
	  
	  tmp = fgcolor;
	  fgcolor = bgcolor;
	  bgcolor = tmp;
	  show_page = TRUE;
	}
	break;
	
      case 'Q':  /* toggle quiet mode */
	quiet = !quiet;
	break;
	
      case 'h':
      case 'H':
	xscreen = 0;
	yscreen = 0;
	show_page = TRUE;
	break;
	
      case '?':  /* print out help again */
	printhelp();
	break;
	
      case 's':  /* zoom down one magstep (1.2) */
	runmag = MAGSIZE(actfact((UNSIGN32) ((5 * runmag) / 6)));
	conv = ((float) num / (float) den) *
	  ((float) runmag / (float) STDMAG) *
	    
#if    USEGLOBALMAG
	    actfact(mag) *
#endif
	      
	      ((float) RESOLUTION / 254000.0);
	(void) unloadfonts();
	show_page = TRUE;
	break;
	
      case 'S':  /* zoom down 5 magsteps (1.2) */
	{
	  int             i;
	  
	  for (i = 0; i < 5; i++)
	    runmag = MAGSIZE(actfact((UNSIGN32) ((runmag * 5) / 6)));
	  conv = ((float) num / (float) den) *
	    ((float) runmag / (float) STDMAG) *
	      
#if    USEGLOBALMAG
	      actfact(mag) *
#endif
		
		((float) RESOLUTION / 254000.0);
	  (void) unloadfonts();
	  show_page = TRUE;
	}
	break;
	
      case 'm':  /* zoom up one magstep (1.2) */
	runmag = MAGSIZE(actfact((UNSIGN32) ((runmag * 6) / 5)));
	conv = ((float) num / (float) den) *
	  ((float) runmag / (float) STDMAG) *
	    
#if    USEGLOBALMAG
	    actfact(mag) *
#endif
	      
	      ((float) RESOLUTION / 254000.0);
	(void) unloadfonts();
	show_page = TRUE;
	break;
	
      case 'M':  /* zoom up 5 magsteps (1.2) */
	{
	  int             i;
	  
	  for (i = 0; i < 5; i++)
	    runmag = MAGSIZE(actfact((UNSIGN32) ((runmag * 6) / 5)));
	  conv = ((float) num / (float) den) *
	    ((float) runmag / (float) STDMAG) *
	      
#if    USEGLOBALMAG
	      actfact(mag) *
#endif
		
		((float) RESOLUTION / 254000.0);
	  (void) unloadfonts();
	  show_page = TRUE;
	}
	
	break;
	
      case 'q':  /* quit */
      case 'x':  /* exit */
      case '\033':  /* CTL-C */
	(void) devterm();  /* terminate device
			    * output */
	(void) dviterm();  /* terminate DVI file
			    * processing */
	(void) alldone();  /* this does not return */
	break;
	
      default:  /* unimplemented command */
	ringbell();
	(void) qreset();  /* clear any typeahead */
	show_page = FALSE;
	break;  /* stay in read-loop */
      }
    default:
      break;
    }
    if (show_page)
      (void) prtpage(page_ptr[cur_index]);
  }
}

void
  fillrect(x, y, width, height)
COORDINATE      x, y, width, height;  /* lower left corner, size */

/***********************************************************************
  With the page origin (0,0) at the lower-left corner of the bitmap,  draw
  a filled rectangle at (x,y).
  ***********************************************************************/

{
  color(fgcolor);
  sboxf(x, y, (x + width), (y + height));
  color(bgcolor);
}

void
  initterm()
{        /* initialize terminal */
  register INT16  i;  /* loop index */
  long ox, oy;
  
  if(win_left >= 0 && win_right < 1280 && win_bottom >= 0 && win_top < 1024)
    prefposition(win_left, win_right, win_bottom, win_top);
  if(win_x_size > 0 && win_y_size > 0)
    prefsize(win_x_size, win_y_size);
  if(win_x_aspect > 0 && win_y_aspect > 0)
    keepaspect(win_y_aspect, win_x_aspect);
  pagewid = winopen("texsgi: Version 1.2 September 1990.");
  wintitle("texsgi: Version 1.2 September 1990. (mg@godzilla.cgl.rmit.oz.au, In US contact: dfr@cad.usna.navy.mil)");
  getsize(&win_x_size, &win_y_size);
  getorigin(&ox, &oy);
  ortho2(0.0, (float) win_x_size, 0.0, (float) (win_y_size));
  winconstraints();
  color(bgcolor);
  clear();
  defcursor(1, hourglass);
  setcursor(1, 0, 0);
  setvaluator(MOUSEX, (ox + (win_x_size/2)), 0, 1280);
  setvaluator(MOUSEY, (oy + (win_y_size/2)), 0, 1024);
}

void
  outrow(c, yoff)      /* send img_row[] to output device */
BYTE            c;  /* current character value */
UNSIGN16        yoff;  /* offset from top row (0,1,...,hp-1) */
{
  /*
   * this is null now that I have redefined SETBIT...
   */
}

void
  rsetterm()
{        /* Reset Terminal */
  
}

void
  setchar(c, update_h)
register BYTE   c;
register BOOLEAN update_h;
{
  register struct char_entry *tcharptr;  /* temporary char_entry
					  * pointer */
  void            (*charyy) ();  /* subterfuge to get around PCC-20
				  * bug */
  
  if (DBGOPT(DBG_SET_TEXT)) {
    (void) fprintf(stderr, "setchar('");
    if (isprint(c))
      (void) putc(c, stderr);
    else
      (void) fprintf(stderr, "\\%03o", (int) c);
    (void) fprintf(stderr, "'<%d>) (hh,vv) = (%ld,%ld) font name <%s>\n",
		   (int) c, (long) hh, (long) vv, fontptr->n);
  }
  tcharptr = &(fontptr->ch[c]);
  
  /*
   * Any character which is off screen is completed ignored; there is
   * no point  sending  bitmaps  or   chardefs  for  invisible
   * characters. Partially visible  characters could  perhaps be
   * supported, but  for now, we ignore them too.
   */
  
  if (((hh - tcharptr->xoffp + tcharptr->pxlw) < (win_x_size - xscreen))
      && (hh >= -xscreen)
      && (vv < (win_y_size + yscreen))
      && ((vv - tcharptr->yoffp) >= yscreen)) {  /* character fits
						  * entirely on screen */
    int             i, j;
    Screencoord     x1, y1, x2, y2;
    
    if (fontptr != pfontptr)
      (void) openfont(fontptr->n);
    if (fontfp == (FILE *) NULL)  /* do nothing if no font file */
      return;
    /*
     * Bug fix: PCC-20 otherwise jumps to charxx instead of
     * *charxx
     */
    charyy = fontptr->charxx;
    (void) (*charyy) (c, outrow);  /* load rasters into parray */
    x1 = (hh - tcharptr->xoffp) + xscreen;

    /* GF font version: y1 = (win_y_size - vv + tcharptr->yoffp ) + yscreen; */

    y1 = (win_y_size - vv + tcharptr->yoffp - tcharptr->hp ) + yscreen;
    x2 = x1 + tcharptr->wp - 1;
    y2 = y1 + tcharptr->hp - 1;
    /*
     * printf("hh: %d, vv: %d, rectwrite: %d %d %d %d\n",
     * (int)hh, (int)vv, x1, y1, x2, y2);
     */
    rectwrite(x1, y1, x2, y2, parray);
  }
  if (update_h) {
    h += (INT32) tcharptr->tfmw;
    hh += (COORDINATE) tcharptr->pxlw;
    hh = (COORDINATE) (fixpos(hh - lmargin, h, conv) + lmargin);
  }
}

printhelp()
{
  int xsize=400, ysize=700;
  int lcolm = 20, rcolm = 170;
  short val;
  
  prefsize(xsize, ysize);
  if (helpwid == -1) {
    if (help_ox >= 0 && help_ox < 1280 && help_oy >= 0 && help_oy < 1024) {
      prefposition(help_ox, (help_ox + xsize), help_oy, (help_oy + ysize));
    }
    helpwid = winopen("TeXsgi Help");
  } else {
    winset(helpwid);
  }
  color(bgcolor);
  clear();
  color(fgcolor);
  ysize -= 25;
  cmov2i((xsize/2 - strwidth("TeXsgi Commands")/2), ysize);
  charstr("TeXsgi Commands");
  cmov2i((xsize/2 - strwidth("------ --------")/2), (ysize - 10));
  charstr("------ --------");

  ysize -= 30;
  cmov2i(lcolm, ysize);  charstr("^U");
  cmov2i(rcolm, ysize);  charstr("Up (small)\n");

  ysize -= 20;
  cmov2i(lcolm, ysize);  charstr("u,^P");
  cmov2i(rcolm, ysize);  charstr("Up\n");

  ysize -= 20;
  cmov2i(lcolm, ysize);  charstr("U");
  cmov2i(rcolm, ysize);  charstr("Up (large)\n\n");

  ysize -= 30;
  cmov2i(lcolm, ysize);  charstr("^D");
  cmov2i(rcolm, ysize);  charstr("Down (small)\n");

  ysize -= 20;
  cmov2i(lcolm, ysize);  charstr("d,^N");
  cmov2i(rcolm, ysize);  charstr("Down\n");

  ysize -= 20;
  cmov2i(lcolm, ysize);  charstr("D");
  cmov2i(rcolm, ysize);  charstr("Down (large)\n\n");

  ysize -= 30;
  cmov2i(lcolm, ysize);  charstr("^L");
  cmov2i(rcolm, ysize);  charstr("Left (small)\n");

  ysize -= 20;
  cmov2i(lcolm, ysize);  charstr("l,^B");
  cmov2i(rcolm, ysize);  charstr("Left\n");

  ysize -= 20;
  cmov2i(lcolm, ysize);  charstr("L");
  cmov2i(rcolm, ysize);  charstr("Left (large)\n\n");

  ysize -= 30;
  cmov2i(lcolm, ysize);  charstr("^R");
  cmov2i(rcolm, ysize);  charstr("\Right (small)\n");

  ysize -= 20;
  cmov2i(lcolm, ysize);  charstr("r,^F");
  cmov2i(rcolm, ysize);  charstr("\Right\n");

  ysize -= 20;
  cmov2i(lcolm, ysize);  charstr("R");
  cmov2i(rcolm, ysize);  charstr("\Right (large)\n\n");

  ysize -= 30;
  cmov2i(lcolm, ysize);  charstr("+,f,^V");
  cmov2i(rcolm, ysize);  charstr("Next Page\n");

  ysize -= 20;
  cmov2i(lcolm, ysize);  charstr("<space>");
  cmov2i(rcolm, ysize);  charstr("Next Page\n\n");

  ysize -= 30;
  cmov2i(lcolm, ysize);  charstr("-,b");
  cmov2i(rcolm, ysize);  charstr("Previous Page\n");

  ysize -= 20;
  cmov2i(lcolm, ysize);  charstr("ALT-V");
  cmov2i(rcolm, ysize);  charstr("Previous Page\n\n");

  ysize -= 30;
  cmov2i(lcolm, ysize);  charstr("[0-9]*g");
  cmov2i(rcolm, ysize);  charstr("Goto Page <n>\n");

  ysize -= 30;
  cmov2i(lcolm, ysize);  charstr("m");
  cmov2i(rcolm, ysize);  charstr("Magnify\n");
		       
  ysize -= 20;
  cmov2i(lcolm, ysize);  charstr("s");
  cmov2i(rcolm, ysize);  charstr("Shrink\n");
  
  ysize -= 30;
  cmov2i(lcolm, ysize);  charstr("M");
  cmov2i(rcolm, ysize);  charstr("Magnify (5 magsteps)\n");
  
  ysize -= 20;
  cmov2i(lcolm, ysize);  charstr("S");
  cmov2i(rcolm, ysize);  charstr("Shrink  (5 magsteps)\n");
  
  ysize -= 30;
  cmov2i(lcolm, ysize); charstr("h,H");
  cmov2i(rcolm, ysize); charstr("Home\n");

  ysize -= 20;
  cmov2i(lcolm, ysize); charstr("i");
  cmov2i(rcolm, ysize); charstr("toggle Inverse Video\n\n");

  ysize -= 20;
  cmov2i(lcolm, ysize); charstr("Q");
  cmov2i(rcolm, ysize); charstr("Quiet Mode (no warnings)\n\n");

  ysize -= 30;
  cmov2i(lcolm, ysize); charstr("?");
  cmov2i(rcolm, ysize); charstr("This Help Message\n\n");

  ysize -= 30;
  cmov2i(lcolm, ysize); charstr("ESC,q,x");
  cmov2i(rcolm, ysize); charstr("Exit\n");
  if (pagewid != -1) {
    winset(pagewid);
  }
}
