.\" $Id: cxterm.man,v 1.3 1991/10/02 20:59:31 ygz Exp $
.TH CXTERM 1 "Release 5" "X Version 11"
.SH NAME
cxterm \- Chinese terminal emulator for X
.SH SYNOPSIS
.B cxterm
[\-\fItoolkitoption\fP ...] [\-option ...]
.SH DESCRIPTION
The \fIcxterm\fP program is a Chinese terminal emulator
for the X Window System. It provides DEC VT102 compatible terminals
with a capability of interfacing Chinese language input/output.
It is fully compatible with X11R5 \fIxterm\fP.
Although the Tektronix 4014 window of xterm remains in cxterm,
you can only use Chinese in the VT102 window (the default mode).
It requires at least two X11 fonts from the X server, one 16-bit Chinese
font and one normal 8-bit terminal character font, to display Chinese
characters as well as normal 7-bit ASCII.
.PP
In \fIcxterm\fP, one Chinese character is represented by 2 bytes, and one
ASCII is represented by 1 byte. There are two kinds of Chinese encoding
schemes, one requires that the highest-bits (MSB) be set to 1 in both bytes
of a Chinese character, the other only requires that the MSB in the first
byte of a Chinese character be set to 1. Both schemes requires that the
MSB in each ASCII code be unset, i.e. second half of the ASCII code set
(from 128 to 255) cannot be used in \fIcxterm\fP.
The \fIcxterm\fP program recognizes both GB and BIG5 encoding,
which are examples of the above two scheme respectively.
However, two encoding cannot co-exist in the same time.
.PP
Please refer manual page \fIxterm(1)\fP for usage of \fIxterm\fP.
This manual will cover only those features related to the Chinese
language processing part.
.SH CHINESE INPUT
\fICxterm\fP adds a special display area to the bottom of window.
It is used to display and convert key sequences into Chinese characters.
This Chinese input area is about 2 lines high and is as wide as the
text window.
To key in a Chinese character, a valid Chinese input string is typed into
the input area first, then it is converted to the Chinese character
according to some input mapping method.  In case the same input string can
be translated into more than one Chinese characters, a selection list of
valid Chinese characters are display in the input area,
then a selection key will bring the character to the screen.
.PP
Chinese input area in \fIcxterm\fP is not a separate window.
Whether the X cursor is in the input area or not makes no
difference to the keyboard input.
.PP
There are different input modes corresponding to different input methods.
Two modes are builtin: ASCII and IC. ASCII mode is not a Chinese mode;
there is no Chinese input capability in this mode
(behave simply like \fIxterm\fP).
IC means Internal Coding. In IC mode every 4 hexadecimal digits are
translated into one Chinese character as the internal code in the adopted
encoding.
.PP
Most other input methods are stored as external files and are loaded
in run-time on demand. Such external input methods are user-accessible
and expandable. See \fItit2cit(1)\fP for how to add your own input
method. The name of the input mode is determined by the name of the
external file where the input method is stored.
.SH OPTIONS
The \fIcxterm\fP program accepts all the standard X Toolkit
command line options, X11R5 \fIxterm\fP command line options, as well as
the following:
.TP 8
.B \-fh \fIchineseFont\fP
This option specifies a Chinese font to be used when display Chinese text.
This font should be the same height and twice the width as the normal
ASCII font.
.TP 8
.B \-fhb \fIchineseFont\fP
This option specifies a Chinese font to be used when display bold Chinese text.
This font must be the same height and width as the normal Chinese font.
If only one of the normal or bold Chinese fonts is specified, it will be
used as the normal font and the bold font will be produced by overstriking
this font. The default is to do overstriking of the normal font.
.TP 8
.B \-hm \fImode\fP
This option specifies the name of the initial input mode when
\fIcxterm\fP starts up. The name of the mode is the name of the input method.
The default is "ASCII"; \fIcxterm\fP will start up in English mode.
.TP 8
.B \-hz \fIencoding\fP
This option specifies which encoding scheme, GB or BIG5, are to be used. 
The default is GB.
.TP 8
.B \-GB
This option indicates that \fIcxterm\fP should use GB encoding.
It is the same as option "\-hz GB".
.TP 8
.B \-BIG5
This option indicates that \fIcxterm\fP should use BIG5 encoding.
It is the same as option "\-hz BIG5".
.TP 8
.B \-hid \fIhanziInputDir\fP
This option specifies the search path for the directory containing the
Chinese input methods.
Alternative directory names are separated by a colon ``:''.
The default is the current directory.
.TP 8
.B \-hls \fIlineSpacing\fP
This option specifies the height of the vertical white space (in pixel)
which is used to separate two adjacent text lines in the screen.
.SH RESOURCES
The program understands all of the core X Toolkit resource names and classes,
all \fIxterm\fP resource names and classes, as well as the following
resources specified as part of the \fIvt100\fP widget (class \fIVT100\fP):
.\".in +1in
.TP 8
.B "hanziFont (\fPclass\fB HanziFont)"
Specifies the name of the Chinese font to use.
.TP 8
.B "hanziBoldFont (\fPclass\fB HanziBoldFont)"
Specifies the name of the bold Chinese font to use instead of overstriking.
.TP 8
.B "hanziMode (\fPclass\fB HanziMode)"
Specifies the name of the initial mode instead of ASCII mode.
.TP 8
.B "hanziEncoding (\fPclass\fB HanziEncoding)"
Specifies the encoding scheme, GB or BIG5.
.TP 8
.B "HanziInputDir (\fPclass\fB HanziInputDir)"
Specifies the search paths for the directory containing the input methods.
The names of the directories are separated by ``:'' characters.
.TP 8
.B "hanziLineSpacing (\fPclass\fB HanziLineSpacing)"
Specifies the vertical spacing (in pixel) between two text lines.
.\".in -1in
.sp
.PP
All the font selection entries in \fIfontMenu\fP can be used
to set Chinese font or fonts as well.
.sp
.SH ACTIONS
In addition to all the \fIxterm\fP \fIvt100\fP \fBtranslations\fP resources,
the following are also accepted by \fIcxterm\fP:
.TP 8
.B "switch-HZ-mode(\fImode\fP)"
This action dynamically switch the input mode to \fImode\fP. If \fImode\fP
is not a builtin input method and does not reside in memory, it is loaded
from external file first. The name of file must be "\fImode\fP.cit", and
it must be under current directory, home directory, or the directory
specified by environment HZINPUTDIR.
.PP
The defaults bindings in \fIcxterm\fP window are:
.sp
.in +4
.DS
.TA 2.5i
.ta 2.5i
.nf
 Shift <KeyPress> Prior:	scroll-back(1,halfpage) \\n\\
  Shift <KeyPress> Next:	scroll-forw(1,halfpage) \\n\\
Shift <KeyPress> Select:	select-cursor-start() \\
	select-cursor-end(PRIMARY, CUT_BUFFER0) \\n\\
Shift <KeyPress> Insert:	insert-selection(PRIMARY, CUT_BUFFER0) \\n\\
          <KeyPress> F1:	switch-HZ-mode(ASCII) \\n\\
          <KeyPress> F2:	switch-HZ-mode(IC) \\n\\
        ~Meta<KeyPress>:	insert-seven-bit() \\n\\
         Meta<KeyPress>:	insert-eight-bit() \\n\\
   Ctrl ~Meta<Btn1Down>:	popup-menu(mainMenu) \\n\\
       ~Meta <Btn1Down>:	select-start() \\n\\
     ~Meta <Btn1Motion>:	select-extend() \\n\\
  Ctrl ~Meta <Btn2Down>:	popup-menu(vtMenu) \\n\\
 ~Ctrl ~Meta <Btn2Down>:	ignore() \\n\\
   ~Ctrl ~Meta <Btn2Up>:	insert-selection(PRIMARY, CUT_BUFFER0) \\n\\
  Ctrl ~Meta <Btn3Down>:	popup-menu(fontMenu) \\n\\
 ~Ctrl ~Meta <Btn3Down>:	start-extend() \\n\\
     ~Meta <Btn3Motion>:	select-extend() \\n\\
    ~Ctrl ~Meta <BtnUp>:	select-end(PRIMARY, CUT_BUFFER0) \\n\\
              <BtnDown>:	bell(0)
.fi
.DE
.sp
.in -4
.PP
Below is a sample of how to use \fBswitch-HZ-mode()\fP action to add more
input methods, or redefine input mode switch keys:
.sp
.in +4
.DS
.TA 3.0i
.ta 3.0i
.nf
cxterm*VT100.Translations: #override \\
           <KeyPress> F1:	switch-HZ-mode(ASCII) \\n\\
           <KeyPress> F2:	switch-HZ-mode(IC) \\n\\
    ~Shift <KeyPress> F3:	switch-HZ-mode(TONEPY) \\n\\
     Shift <KeyPress> F3:	switch-HZ-mode(PY-b5) \\n\\
    ~Shift <KeyPress> F4:	switch-HZ-mode(PY) \\n\\
     Shift <KeyPress> F4:	switch-HZ-mode(ETZY) \\n\\
    ~Shift <KeyPress> F5:	switch-HZ-mode(QJ) \\n\\
     Shift <KeyPress> F5:	switch-HZ-mode(QJ-b5) \\n\\
    ~Shift <KeyPress> F6:	switch-HZ-mode(Punct) \\n\\
     Shift <KeyPress> F6:	switch-HZ-mode(Punct-b5) \\n\\
           <KeyPress> F7:	switch-HZ-mode(QW) \\n\\
 ~Meta <KeyPress> Escape:	insert() switch-HZ-mode(ASCII)
.fi
.DE
.in -4
.sp
In this example, pressing <F2> will
switch the current input method to IC;
<F4> will switch again to PY method
(external input method, requires PY.cit to be in the search path(s) of
the .cit files);
<shift>+<F4> will try to switch again to ETZY method, and so on.
The last line above may be a good setting for those who use celvis.
Pressing <ESC> will pass ESC to celvis to end the insertion mode, and
cause \fIcxterm\fP to switch back to ASCII
(so that you can continue to enter celvis command in ASCII mode).
.PP
The following \fIxterm\fP actions have additional meaning:
.TP 8
.B "set-vt-font(\fId/1/2/3/4/5/6/e/s\fP [,\fInormalfont\fP [, \fIboldfont\fP]])"
This action sets Chinese font or fonts as well,
if the Chinese font or fonts are indicated in the resources
or as arguments.  The font selection entries in \fIfontMenu\fP
can be also used to set Chinese font and fonts.
.TP 8
.B "hard-reset()"
This action also resets the input area, dropping all the external
input methods which are already loaded.
It is also invoked from the \fBhardreset\fP entry in \fIvtMenu\fP.
.SH "CONTROL SEQUENCES"
All the
.I xterm
escape sequences can be used in
.I cxterm
without any change.
(See the
.I "Xterm Control Sequences"
document.)
A set of new escape sequences are added to deal with Chinese characters:
.TP 8
.B "<ESC>]160;\fIstring\fP<BEL>"
Set the input method search paths to \fIstring\fP.
It affects the subsequence loading of input methods.
However, it has no effect on input modes in which
the input method has already been loaded.
.TP 8
.B "<ESC>]161;\fIstring\fP<BEL>"
Switch input mode to \fIstring\fP,
equivalent to action \fBswitch-HZ-mode(\fP\fIstring\fP\fB)\fP.
.SH "ENVIRONMENT VARIABLE"
.IP HZINPUTDIR.
It defines the external input method searching path
in absent of \fI\-hid\fP options or ``hanziInputDir'' resource.
.SH EXAMPLES
.LP
Start a \fIcxterm\fP in reserve video with scroll bar:
(It is in GB encoding and uses X11 fonts cclib16st and 8x16 by default).
.RS
.sp .5
.nf
.B cxterm -rv -sb
.fi
.RE
.LP
Start a \fIcxterm\fP in BIG5 encoding (where hku-ch16 is a BIG5
encoding X11 font):
.RS
.sp .5
.nf
.B cxterm -fh hku-ch16 -fn 8x16 -BIG5
.fi
.RE
.SH "SEE ALSO"
.BI X (1), 
.BI xterm (1),
.BI hzimpath (1),
.BI tit2cit (1)
.SH COPYRIGHT
Copyright 1991, Yongguang Zhang and Man-Chi Pong.
.br
Please also see \fIX(1)\fP for a full statement of rights and permissions
for X11R5.
.SH AUTHORS
\fIXterm\fP is part of the X window system Version 11 Release 4 developed in MIT.
.PP
This version of \fIcxterm\fP is rewritten by
Yongguang Zhang (now with Purdue University, e-mail: ygz@cs.purdue.edu)
from X11R5 \fIxterm\fP.
.PP
The first version of \fIcxterm\fP (X11R4 rev 1) was developed by
Man-Chi Pong
(now with the Hong Kong University of Science and Technology, HK.
E-mail: mcpong@uxmail.usthk.hk).
It was later improved by Yongguang Zhang to become X11R4 rev 2.
.PP
\fICxterm\fP is somewhat inspired by the old \fIccxterm\fP developed
jointly by the Institute of Software, Academia Sinica and
the Institute of Systems Engineering, Ministry of Electronic Industry,
Beijing, China, from 1987 to 1989.

