/*
  bdf2hzfont.c

  Written by Ricky Yeung (yeung@june.cs.washington.edu)  9/10/1989

  This program is free for general use.
*/
#include <stdio.h>

#define GB0 0x2121	/* starting code of GB1 symbols */
#define GB1 0x3021	/* starting code of GB1 hanzi */
#define GB2 0x5821	/* starting code of GB2 hanzi */
#define GBU 0x7821	/* starting code of GB user defined hanzi */
#define GBX 0x7921	/* starting code of my own GB extension */
#define GBXe 0x7A7E	/* ending code of my own GB extension */

#define GBbegin GB0
#define GBend   GBXe
#define GBbox   0x2175	/* ? GB "blank box" code */

#define HB(code)	(((code)&0xff00) >> 8)
#define	LB(code)	((code)&0x00ff)

int indexSize;		/* total number of GB codes in range */
char Font0[80], Font[80], Font1[80], Font2[80], FontX[80];
char *bitmap, *bitmap0, *bitmap1, *bitmap2, *bitmapX;
int bn0, bn1, bn2, bnX, bn;
int hzbyte, HZbm;

#define LEN 100

char line[LEN];

int GB2Index(code)
     unsigned int code;
{
  return ((HB(code) - 0x21) * 0x5E + (LB(code)) - 0x21);
}

int SkipTillStr (s)
    char *s;
{
    for (;;)
    {
	if (!gets(line)) return(0);
	if (strncmp(line,s,strlen(s))==0) return(1);
    }
}

void WriteFntFile (s, bm, n)
    char *s, *bm;
    int n;
{
    FILE *fp;
    
    if (!(fp=fopen(s,"w")))
    {
	fprintf(stderr, "Can't write to font file %s\n", s);
	exit(1);
    }
    if (fwrite(bm, 1, n, fp)!=n)
    {
	fprintf(stderr, "Error in writing to font file %s\n", s);
	exit(1);
    }
}

char2int (c)
    int c;
{
    if ((c>='0')&&(c<='9')) return(c-'0');
    else if ((c>='a')&&(c<='f')) return(c-'a'+10);
    else if ((c>='A')&&(c<='F')) return(c-'A'+10);
    else
    {
	fprintf (stderr, "Bit map error. \n");
	exit(1);
    }
}


Readbdf ()
{
    int code, bindex, i, j, c;
    char tmp[LEN];
    int odd = 1;
                
    while (SkipTillStr ("ENCODING "))
    {
	sscanf(line, "%s %d", tmp, &code);
	code &= 0x7f7f;   /* turn off high bit of each byte */
	bindex = GB2Index(code) * hzbyte;
	SkipTillStr("BITMAP");
	for (i=1;i<=HZbm;i++)
	{
	    for (j=1;j<=(HZbm/4);j++)
	    {
		c = char2int(getchar());
		if (!odd) 
		{
		    bitmap[bindex++] |= c;
		    odd = 1;
		}
		else
		{
		    bitmap[bindex] = bitmap[bindex] | (c<<4);
		    odd = 0;
		}
	    }
	    while ((c=getchar())!='\n');  /* skip rest of line */
	}
    }
}

main(argc, argv)
    int argc;
    char *argv[];
{
    char *calloc(), tmp[LEN];
    
    SkipTillStr("FONT ");
    sscanf(line, "%s %s", tmp, Font);
    SkipTillStr("SIZE ");
    sscanf(line, "%s %d", tmp, &HZbm);
    hzbyte = HZbm * HZbm / 8;
    printf("Font:%s Character size: %d x %d = %d bytes.\n",Font,HZbm,HZbm,hzbyte);
    strcat(Font, "-");
    indexSize = GB2Index(GBend) + 1;
    bn0 = (GB2Index(GB1)-GB2Index(GB0)) * hzbyte;
    bn1 = (GB2Index(GB2)-GB2Index(GB1)) * hzbyte;
    bn2 = (GB2Index(GBU)-GB2Index(GB2)) * hzbyte;
    bnX = (GB2Index(GBXe)-GB2Index(GBX)+1) * hzbyte;
    bn  = (GB2Index(GBend)-GB2Index(GBbegin)+1) * hzbyte;
    if ((bitmap = calloc(bn, 1)) == NULL)
      {
	fprintf(stderr, "Can't allocate enough memory.\n");
	exit(1);
      }
    bitmap0 = bitmap;
    bitmap1 = bitmap + (GB2Index(GB1)-GB2Index(GB0)) * hzbyte;
    bitmap2 = bitmap + (GB2Index(GB2)-GB2Index(GB0)) * hzbyte;
    bitmapX = bitmap + (GB2Index(GBX)-GB2Index(GB0)) * hzbyte;

    sprintf(tmp, "%d", HZbm);
    strcat(Font, tmp);
    strcpy(Font0, Font);
    strcat(Font0, ".0");
    strcpy(Font1, Font);
    strcat(Font1, ".1");
    strcpy(Font2, Font);
    strcat(Font2, ".2");
    strcpy(FontX, Font);
    strcat(FontX, ".X");
    printf("Font set size: %d\n",bn);

    Readbdf();

    WriteFntFile (Font0, bitmap0, bn0);
    WriteFntFile (Font1, bitmap1, bn1);
    WriteFntFile (Font2, bitmap2, bn2);
    WriteFntFile (FontX, bitmapX, bnX);
}









