/*Compilation Hint:  for ultrix and SunOs define V7 = 1 */
/*
*************************************************************************
*         ChText.C      Copyright by Jingbai Wang, August, 1989         *
*                                                                       *
*                jbw@pittvms.bitnet                                     *
*                jbw@cisunx.UUCP                                        *
*************************************************************************

	It is permitted for use and distribution of this file for
	non-profitable purposes only. Commercial usage of this program
	is reserved for the author or with the written permission from
	the author.

	This is a mainframe flavored Chinese text handler.
	Run it to see the help by

	$chtext -h

*/


/* Fix this site-dependent path of CCLIB  and path for Ci2Dian3.chi */ 
/* ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^                            */
/* UNIX environment variables:
CCLIB16jt

VMS logical names:
cclib16$jt

if no environment or logical is found use the following definitions:
*/

#define FALSE 0
#if VMS|unix
#else
#define MSDOS 1
#include <mem.h>
#endif


#if VMS
#define CCLIB16jt "usr2:[10555.jwang.ccdos]cclib.16"
#define CiDianpath "sys$login:"
#endif


#if unix
#ifndef CCLIB16jt
#define CCLIB16jt "/usr/people/jbw/chtex/cclib.16"
#define CCLIB16ft "/usr/people/ftp/ch-series/cclibf.16"
#endif
#ifndef CiDianpath
#define CiDianpath "HOME"
#endif
#endif


#if MSDOS|PCDOS
#ifndef CCLIB16jt
#define CCLIB16jt "cclib.16"
#define CCLIB16ft "cclibf.16"
#endif
#define CiDianpath "HOME"
#endif

 
/*
 It runs on VMS, UNIX and DOS systems.

Syntax:
~~~~~~
1) To view a document
$chtext filename -v
  
   The output can be re-directed into a file by

$chtext filename > outfile -v

   Note the spaces on both sides of '>' are necessary on VMS.

2) To use it as a line editor
$ chtext output_file -e

3) To filter a PinYin file into Chinese file:
$ chtext input_file output_file 

4) To convert a Chinese file into PinYin file:
$ chtext input_file  output_file -p

5) To use it as a PinYin Chinese dictionary
$ chtext  -d

Compiling instruction:
~~~~~~~~~~~~~~~~~~~~~~
1) On VMS,
$CC chtext.c
$link chtext, sys$library:vaxcrtl.olb/lib
$chtext:==$mypath:chtext.exe
where the last step is to define the foreign command to use command line.

2) On unix,
%make chtext
or
cc -o chtext chtext.c

3) On DOS -- compiler dependent

*/

  /* define some preprocessor stuffs */ 
#define TRUE 1

#if VMS
#include <file.h>
#else
#include <fcntl.h>
#endif

#if ultrix
#define V7 1
#endif

#define NUM_Char 512
#define MAX_libsize  256000
#define MAX_filesize 128000  /* Is document file size 128k ok? */
#define MAX_CiZuDic 264000  /* Is document file size 128k ok? */

#include<stdio.h>
#include<string.h>


#define INBUFSIZE 1024

 /* now define ANSI terminal dependent getch() */
#if   MSDOS|PCDOS
#include <stdlib.h>
#if TURBO
#include <conio.h>
#endif
#endif

#define tt_open 1
#define tt_close 0

int tt_status;

#if VMS
#include <stdlib.h>
#include        <stsdef.h>
#include        <ssdef.h>
#include        <descrip.h>
#include        <iodef.h>
#include        <ttdef.h>
#include        <tt2def.h>

#define NIBUF   128                     /* Input buffer size            */
#define NOBUF   1024                    /* MM says bug buffers win!     */
#define EFN     0                       /* Event flag                   */

char    obuf[NOBUF];                    /* Output buffer                */
int     nobuf;                  /* # of bytes in above    */
char    ibuf[NIBUF];                    /* Input buffer          */
int     nibuf;                  /* # of bytes in above  */
int     ibufi;                  /* Read index                   */
int     oldmode[3];                     /* Old TTY mode bits            */
int     newmode[3];                     /* New TTY mode bits            */
short   iochan;                  /* TTY I/O channel             */

#endif

#if VMS|unix

/*   ANSI escape, good for mainframe systems vt100 terminals, e.g., VAX*/
#define DEL 127
#define EXT 27
#define EXT1 '['
#define R_ARROW 'C'
#define L_ARROW 'D'
#define D_ARROW 'B'
#define U_ARROW 'A'

#else
 /* MSDOS extended code escape */
#define DEL  8
#define EXT  0  
#define R_ARROW 77
#define L_ARROW 75
#define D_ARROW 80
#define U_ARROW 72
#endif

/* The getch() and getche() functions */

#if VMS|unix /* define getch() for VMS and unix*/

int getch()
{
int chr;
ttopen();
chr= ttgetc();
ttclose();
return(chr);
}

int getche()
{
char inchar;
inchar=getch();
fputc(inchar, stdout);
return((int)inchar);
}


#endif

FILE *tempfile;

/******* begin terminal dependent codes for ANSI terminals*******/

#define CLS fputs("\033[2J", stderr)
#define GOTOXY(x,y) fprintf(stderr, "\033[%d;%df",x,y)
#define REVERSE fputs( "\033[7m", stderr)
#define NORMAL fputs( "\033[0m", stderr)
#define SAVE_CURSOR fputs( "\033[s", stderr)
#define RESTORE_CURSOR fputs( "\033[u", stderr)
#define BLINK fputs( "\033[5m", stderr)
#define BOLD fputs("\033[1m", stderr)
#define UNDER fputs("\033[4m", stderr)
#define ERASE fputs( "\033[K", stderr)
#define BELL fputs("\007", stderr)
#define CURSOR_RIGHT fputs("\033[1C", stderr)
#define CURSOR_LEFT fputs("\033[1D", stderr)




/*
 * The functions in this file negotiate with the operating system for
 * characters, and write characters in a barely buffered fashion on the display.
 * All operating systems.
 */


#if   MSDOS & TURBO
#include <conio.h>
#endif

#if     AMIGA
#define NEW 1006L
#define AMG_MAXBUF      1024L
static long terminal;
static char     scrn_tmp[AMG_MAXBUF+1];
static long     scrn_tmp_p = 0;
#endif

#if     CPM
#include        <bdos.h>
#endif

#if     MSDOS & (LATTICE | MSC | TURBO | AZTEC | MWC86)
union REGS rg;          /* cpu register for use of DOS calls */
int nxtchar = -1;       /* character held from type ahead    */
#endif

#if RAINBOW
#include "rainbow.h"
#endif

#if     USG                     /* System V */
#include        <signal.h>
#include        <termio.h>
#include        <fcntl.h>
int kbdflgs;                    /* saved keyboard fd flags      */
int kbdpoll;                    /* in O_NDELAY mode                     */
int kbdqp;                      /* there is a char in kbdq      */
char kbdq;                      /* char we've already read      */
struct  termio  otermio;        /* original terminal characteristics */
struct  termio  ntermio;        /* charactoristics to use inside */
#endif

#if V7 | BSD
/*
#undef  CTRL
*/
#include        <sgtty.h>        /* for stty/gtty functions */
#include        <signal.h>
struct  sgttyb  ostate;          /* saved tty state */
struct  sgttyb  nstate;          /* values for editor mode */
struct tchars   otchars;        /* Saved terminal special character set */
struct tchars   ntchars = { 0xff, 0xff, 0xff, 0xff, 0xff, 0xff };
                                /* A lot of nothing */
#if BSD
#include <sys/ioctl.h>          /* to get at the typeahead */
extern  int rtfrmshell();       /* return from suspended shell */
#define         TBUFSIZ         128
char tobuf[TBUFSIZ];            /* terminal output buffer */
#endif
#endif

/*
 * This function is called once to set up the terminal device streams.
 * On VMS, it translates TT until it finds the terminal, then assigns
 * a channel to it and sets it raw. On CPM it is a no-op.
 */
ttopen()
{

#if     AMIGA
        char oline[NSTRING];
#if     AZTEC
        extern  Enable_Abort;   /* Turn off ctrl-C interrupt */

        Enable_Abort = 0;       /* for the Manx compiler */
#endif
        strcpy(oline, "RAW:0/0/640/200/");
        strcat(oline, PROGNAME);
        strcat(oline, " ");
        strcat(oline, VERSION);
        strcat(oline, "/Amiga");
        terminal = Open(oline, NEW);
#endif
#if     VMS
        struct  dsc$descriptor  idsc;
        struct  dsc$descriptor  odsc;
        char    oname[40];
        int     iosb[2];
        int     status;
if (tt_status==tt_open) return;
tt_status=tt_open;
        odsc.dsc$a_pointer = "TT";
        odsc.dsc$w_length  = strlen(odsc.dsc$a_pointer);
        odsc.dsc$b_dtype        = DSC$K_DTYPE_T;
        odsc.dsc$b_class        = DSC$K_CLASS_S;
        idsc.dsc$b_dtype        = DSC$K_DTYPE_T;
        idsc.dsc$b_class        = DSC$K_CLASS_S;
        do {
                idsc.dsc$a_pointer = odsc.dsc$a_pointer;
                idsc.dsc$w_length  = odsc.dsc$w_length;
                odsc.dsc$a_pointer = &oname[0];
                odsc.dsc$w_length  = sizeof(oname);
                status = LIB$SYS_TRNLOG(&idsc, &odsc.dsc$w_length, &odsc);
                if (status!=SS$_NORMAL && status!=SS$_NOTRAN)
                        exit(status);
                if (oname[0] == 0x1B) {
                        odsc.dsc$a_pointer += 4;
                        odsc.dsc$w_length  -= 4;
                }
        } while (status == SS$_NORMAL);
        status = SYS$ASSIGN(&odsc, &iochan, 0, 0);
        if (status != SS$_NORMAL)
                exit(status);
        status = SYS$QIOW(EFN, iochan, IO$_SENSEMODE, iosb, 0, 0,
                          oldmode, sizeof(oldmode), 0, 0, 0, 0);
        if (status!=SS$_NORMAL || (iosb[0]&0xFFFF)!=SS$_NORMAL)
                exit(status);
        newmode[0] = oldmode[0];
        newmode[1] = oldmode[1] | TT$M_NOECHO;
        newmode[1] &= ~(TT$M_TTSYNC|TT$M_HOSTSYNC);
        newmode[2] = oldmode[2] | TT2$M_PASTHRU;
        status = SYS$QIOW(EFN, iochan, IO$_SETMODE, iosb, 0, 0,
                          newmode, sizeof(newmode), 0, 0, 0, 0);
        if (status!=SS$_NORMAL || (iosb[0]&0xFFFF)!=SS$_NORMAL)
                exit(status);
/*---        term.t_nrow = (newmode[1]>>24) - 1;
        term.t_ncol = newmode[0]>>16; */

#endif
#if     CPM
#endif

#if     MSDOS & (HP150 == 0) & LATTICE
        /* kill the ctrl-break interupt */
        rg.h.ah = 0x33;                 /* control-break check dos call */
        rg.h.al = 1;            /* set the current state */
        rg.h.dl = 0;            /* set it OFF */
        intdos(&rg, &rg);       /* go for it! */
#endif

#if     USG
        ioctl(0, TCGETA, &otermio);     /* save old settings */
        ntermio.c_iflag = 0;            /* setup new settings */
        ntermio.c_oflag = 0;
        ntermio.c_cflag = otermio.c_cflag;
        ntermio.c_lflag = 0;
        ntermio.c_line = otermio.c_line;
        ntermio.c_cc[VMIN] = 1;
        ntermio.c_cc[VTIME] = 0;
        ioctl(0, TCSETA, &ntermio);     /* and activate them */
        kbdflgs = fcntl( 0, F_GETFL, 0 );
        kbdpoll = FALSE;
#endif

#if     V7 | BSD
if (tt_status==tt_open) return;
        gtty(0, &ostate);                       /* save old state */
        gtty(0, &nstate);                       /* get base of new state */
        nstate.sg_flags |= RAW;
        nstate.sg_flags &= ~(ECHO|CRMOD);       /* no echo for now... */
        stty(0, &nstate);                       /* set mode */
        ioctl(0, TIOCGETC, &otchars);           /* Save old characters */
        ioctl(0, TIOCSETC, &ntchars);           /* Place new character into K */
tt_status=tt_open;
#if     BSD
        /* provide a smaller terminal output buffer so that
           the type ahead detection works better (more often) */
        setbuffer(stdout, &tobuf[0], TBUFSIZ);
/*---        signal(SIGTSTP,SIG_DFL);         set signals so that we can
        signal(SIGCONT,rtfrmshell);      suspend & restart emacs */
#endif
#endif
        /* on all screens we are not sure of the initial position
           of the cursor                                        */
/*---   ttrow = 999;
        ttcol = 999; */

}

/*
 * This function gets called just before we go back home to the command
 * interpreter. On VMS it puts the terminal back in a reasonable state.
 * Another no-operation on CPM.
 */
ttclose()
{

#if     AMIGA
#if     LATTICE
        amg_flush();
        Close(terminal);
#endif
#if     AZTEC
        amg_flush();
        Enable_Abort = 1;       /* Fix for Manx */
        Close(terminal);
#endif
#endif

#if     VMS
        int     status;
        int     iosb[1];

if (tt_status==tt_close) return;
tt_status=tt_close;

        ttflush();
        status = SYS$QIOW(EFN, iochan, IO$_SETMODE, iosb, 0, 0,
                 oldmode, sizeof(oldmode), 0, 0, 0, 0);
        if (status!=SS$_NORMAL || (iosb[0]&0xFFFF)!=SS$_NORMAL)
                exit(status);
        status = SYS$DASSGN(iochan);
        if (status != SS$_NORMAL)
                exit(status);
#endif
#if     CPM
#endif
#if     MSDOS & (HP150 == 0) & LATTICE
        /* restore the ctrl-break interupt */
        rg.h.ah = 0x33;                 /* control-break check dos call */
        rg.h.al = 1;            /* set the current state */
        rg.h.dl = 1;            /* set it ON */
        intdos(&rg, &rg);       /* go for it! */
#endif

#if     USG
        ioctl(0, TCSETA, &otermio);     /* restore terminal settings */
        fcntl(0, F_SETFL, kbdflgs);
#endif

#if     V7 | BSD
if (tt_status==tt_close) return;
        stty(0, &ostate);
        ioctl(0, TIOCSETC, &otchars);   /* Place old character into K */
tt_status=tt_close;
#endif


}

#if     AMIGA
amg_flush()
{
        if(scrn_tmp_p)
                Write(terminal,scrn_tmp,scrn_tmp_p);
        scrn_tmp_p = 0;
}
#endif

/*
 * Flush terminal buffer. Does real work where the terminal output is buffered
 * up. A no-operation on systems where byte at a time terminal I/O is done.
 */
ttflush()
{
#if     AMIGA
        amg_flush();
#endif
#if     VMS
        int     status;
        int     iosb[2];

        status = SS$_NORMAL;
        if (nobuf != 0) {
                status = SYS$QIOW(EFN, iochan, IO$_WRITELBLK|IO$M_NOFORMAT,
                         iosb, 0, 0, obuf, nobuf, 0, 0, 0, 0);
                if (status == SS$_NORMAL)
                        status = iosb[0] & 0xFFFF;
                nobuf = 0;
        }
        return (status);
#endif

#if     CPM
#endif

#if     MSDOS
#endif

#if     V7 | USG | BSD
        fflush(stdout);
	fflush(stderr);
#endif
}

/*
 * Read a character from the terminal, performing no editing and doing no echo
 * at all. More complex in VMS that almost anyplace else, which figures. Very
 * simple on CPM, because the system can do exactly what you want.
 */
ttgetc()
{
#if     AMIGA
        char ch;
        amg_flush();
        Read(terminal, &ch, 1L);
        return(255 & (int)ch);
#endif
#if     VMS
        int     status;
        int     iosb[2];
        int     term[2];

        while (ibufi >= nibuf) {
                ibufi = 0;
                term[0] = 0;
                term[1] = 0;
                status = SYS$QIOW(EFN, iochan, IO$_READLBLK|IO$M_TIMED,
                         iosb, 0, 0, ibuf, NIBUF, 0, term, 0, 0);
                if (status != SS$_NORMAL)
                        exit(status);
                status = iosb[0] & 0xFFFF;
                if (status!=SS$_NORMAL && status!=SS$_TIMEOUT)
                        exit(status);
                nibuf = (iosb[0]>>16) + (iosb[1]>>16);
                if (nibuf == 0) {
                        status = SYS$QIOW(EFN, iochan, IO$_READLBLK,
                                 iosb, 0, 0, ibuf, 1, 0, term, 0, 0);
                        if (status != SS$_NORMAL
                        || (status = (iosb[0]&0xFFFF)) != SS$_NORMAL)
                                exit(status);
                        nibuf = (iosb[0]>>16) + (iosb[1]>>16);
                }
        }
        return (ibuf[ibufi++] & 0xFF);    /* Allow multinational  */
#endif

#if     CPM
        return (biosb(BCONIN, 0, 0));
#endif

#if RAINBOW
        int Ch;

        while ((Ch = Read_Keyboard()) < 0);

        if ((Ch & Function_Key) == 0)
                if (!((Ch & 0xFF) == 015 || (Ch & 0xFF) == 0177))
                        Ch &= 0xFF;

        return Ch;
#endif

#if     MSDOS & MWC86
        return (getcnb());
#endif

#if     MSDOS & (LATTICE | MSC | TURBO | AZTEC)
        int c;          /* character read */

        /* if a char already is ready, return it */
        if (nxtchar >= 0) {
                c = nxtchar;
                nxtchar = -1;
                return(c);
        }

        /* call the dos to get a char */
        rg.h.ah = 7;            /* dos Direct Console Input call */
        intdos(&rg, &rg);
        c = rg.h.al;            /* grab the char */
        return(c & 255);
#endif

#if     V7 | BSD
        return(127 & fgetc(stdin));
#endif

#if     USG
        if( kbdqp )
                kbdqp = FALSE;
        else
        {
                if( kbdpoll && fcntl( 0, F_SETFL, kbdflgs ) < 0 )
                        return FALSE;
                kbdpoll = FALSE;
                while (read(0, &kbdq, 1) != 1)
                        ;
        }
        return ( kbdq & 127 );
#endif
}

/* typahead:    Check to see if any characters are already in the
                keyboard buffer
*/

typahead()

{
#if     MSDOS & (MSC | TURBO)
        if (kbhit() != 0)
                return(TRUE);
        else
                return(FALSE);
#endif

#if     MSDOS & (LATTICE | AZTEC | MWC86)
        int c;          /* character read */
        int flags;      /* cpu flags from dos call */

        if (nxtchar >= 0)
                return(TRUE);

        rg.h.ah = 6;    /* Direct Console I/O call */
        rg.h.dl = 255;  /*         does console input */
#if     LATTICE | AZTEC
        flags = intdos(&rg, &rg);
#else
        intcall(&rg, &rg, 0x21);
        flags = rg.x.flags;
#endif
        c = rg.h.al;    /* grab the character */

        /* no character pending */
        if ((flags & 64) != 0)
                return(FALSE);

        /* save the character and return true */
        nxtchar = c;
        return(TRUE);
#endif

#if     BSD | V7
        int x;  /* holds # of pending chars */

        return((ioctl(0,FIONREAD,&x) < 0) ? 0 : x);
#endif

#if     USG
        if( !kbdqp )
        {
                if( !kbdpoll && fcntl( 0, F_SETFL, kbdflgs | O_NDELAY ) < 0 )
                        return(FALSE);
                kbdqp = (1 == read( 0, &kbdq, 1 ));
        }
        return ( kbdqp );
#endif

#if VMS
    return (ibufi < nibuf);
#endif
}

#if ultrix
memmove(s1,s2,len) char *s1, *s2; unsigned len;
   { unsigned i;
   if(s1 <= s2) for(i=0; i<len; ++i) *s1++ = *s2++;
   else for(s1 += len, s2+= len, i=0; i<len; ++i) *--s1 = *--s2;
   }
#endif

/*    end of terminal dependent codes */


get_shell()  /* get operating system shell */
{

CLS;

#if MSDOS|PCDOS
system("command");
#endif

#if unix|ultrix
GOTOXY(24, 1);
ERASE; fprintf(stderr, "Type ^D to return\n");
system("csh");
#endif


#if VMS
fputs(" Type logout to return\n", stderr);
system("spawn");
#endif

}


/* Here we define some global variables */

char twobytes[3];
int g_chosen; /* global chosen in insert */

struct CiZu {
int mode;
int zishu;
char str[257];
};


struct MATCHES
{
char str[16];
int lens;
} all[360];
int total_num, the_chosen; /* total number of choices, and
			      the chosen one */

int quiet_pick = 0; /* by default, confirm even if there is only
		       one choice */

#define outhandle 1
#define errhandle 2


FILE *cclib;
int cclib_load = 0;   /* Is cclib loaded */
int piping=0;  /* for VMS piping */

char infile_name[50], outfile_name[50];

extern char *getenv();

long int py_str[27];


make_PinYin(PinYinDic) /* PinYin dictionary */
char *PinYinDic;
	/* Some small systems can't take long tokens, in this case,
	just cut the strings finer */
{
long int l;
int i;
/* Here we have 4336 distinct Chinese characters encoded in PinYin 
   about 4463  in total*/
/* We will still need to encode Greek, Russian and Japanese,
   English in Chinese mode as well as the symbols */


PinYinDic[0] = '\0';

strcpy(PinYinDic,
" a1e0\042 a1k0! a6$\042 a6s$! a7%\042 a7s%! ai10' ai1t0# ai1ts0$ ai1k0& ai1kc0% \
ai2bt0) ai2b0( ai3s0+ ai3ct0* ai4at0. ai4s0- ai4e0/ ai4ct0, \
an1bg02 an1qt01 an1g00 an3dr03 an4ts04 an4y07 an4bg08 an4r05 \
an4st06 ang1y09 ang2rt0: ang4md0; ao10< ao2fw0= ao2sd0> ao2g0? \
ao3sb0@ ao4dr0A ao40B ao4ss0D ao4sx0C\001");

strcat(PinYinDic, "ba1p0K ba10M ba1ts0G ba1tsb0F ba1ct0E ba1bt0L ba1mtN ba1k0I ba1kp0H ba1zt0J \
ba2ts0N ba2z0O ba3ts0Q ba3g0P ba4ft0V ba4l0R ba4st0U ba4yt0T \
ba4t0S ba6$P ba7%P \
baifh#% bai1sj~ bai20W bai30Y bai3m0X bai3dr0[ bai3ts0Z bai4fw0\\ bai4s0] \
bai4h0^ ban1w0` ban1ww0_ ban1z0c ban1ts0a ban1tsf0b ban1f0d ban1btq- ban1btbq# \
ban3eZf ban3m0e ban3p0f ban40k ban4l0l ban4dr0i ban4ts0h ban4tsf0g ban4js0m \
ban4x0j bang1ye0n bang1xj0o bang1m0p bang1ssd: bang3m0q bang3y0r bang3js0s \
bang4dr0x bang4y0y bang4s0u bang4c0v bang4j0w bang4m0t \
bao10| bao1xy0} bao1ct0z bao1zf_ bao1y0{ bao1xhlR bao1ld0~ bao1hEZ \
bao2ct1! bao2yt1\042 bao3dr1# bao3xt1$ bao3yqY bao3bg1& bao3s1% bao3ct]a \
bao4ts1' bao4tsb1( bao4y1+ bao4rt1) bao4h1, bao4c1* bao4zu@ ");

strcat(PinYinDic, "\
be6$Y be7%Y bei110 bei1s1. bei1m1- bei1xx1/ bei311 bei4bt13 bei4pt1[ bei414 bei4q17 \
bei4j15 bei4dr16 bei4h1: bei4wt18 bei4xx19 bei4y1; bei4ypqX bei4ft12 \
bei4k_B bei4ct]m ben1ld1< ben31> ben3ct1= ben4zzt1? beng1st1@ beng1js1A beng2bt1B \
beng4st1C ben4z1D ben4zz1E beng4c0v bi1zz1F bi2zt1G bi31H bi3sr1K bi3zt1J \
bi3ye1I bi41X bi4p1R bi4xb1Q bi4sb1P bi4fw1V bi4xs1O bi4ld1W bi4yx1Y bi4xt1Z bi4xy1[ \
bi4z1\\ bi4xsw1L bi4gt1S bi4bt1T bi4ct1N bi4bct1M bi4mk1U bi4e1] bi6$S bi7%S \
bian1zz1_ bian1js1` bian1hlT bian1cry bian1g1^ bian3ht1b bian3b1a bian3skXR \
bian4x1f bian4xy1g bian4xj1h bian4xu1d bian41e bian4dr1c bian4zz1i \
biao1m1j biao1maft biao1h1k biao1y1l biao1yfl- biao31m biao3nf; \
bie1xx1o bie1xy1n bie2ld1p bie2xzu? bie3bt1q bin1bg1v bin1ss1u bin1ts1w bin1ssp1t \
bin1m1r bin1w1s bin4xbw^ bin4gwF bing11x bing1ls1y bing31{ bing3q1| bing3m1z \
bing3h1~ bing3s1} bing42\042 bing4bt2! bing4ts^p bo1ss2( bo1ct2$ bo1w2# \
bo1tsf2& bo1ts2% \
bo1j2' bo1sbD bo2s2) bo2ts2+ bo2yb22 bo2y21 bo2dr2. bo2j2, bo2xj2/ \
bo2ss24 bo2ssb23 bo2zt2- bo2z20 bo2yl2* bo2m25 bo2ct1! bo3zuK \
bo4ztt$ bo4ct1! bo6$\\ bo7%\\ bu327 bu3y29 bu3ts26 bu3k28 bu42; bu4p2< bu4sx2@ bu4xs2= \
bu4ye2? bu4t2: bu4zt2> bu6$V bu7%V\001");

strcat(PinYinDic,
"ca1ts2A ca1k`j cai1q2B cai22E cai2m2D cai2b2F cai2s2C cai3xm2I cai3fs2J \
cai3m2G cai3z2H cai4ct2K cai4ctj2L can1xs2N can12M can2d2P can2xc2O can2sx2Q \
can3sx2R can4h2S cang1rt2V cang1ct2T cang1ss2W cang1z2U cang2ct2X \
cao1ts2Y cao1m2Z cao2xr2\\ cao2k`P cao2m2[ cao3ct2] ce4dr2` ce4ct2^ ce4ss2b \
ce42a ce4zt2_ cen1xs2N ceng2st2c ceng2xrTx ceng4z2d cha12f cha1mh> cha1ts2e \
cha1kT{ cha2mk2i cha2s2j cha2ct2h cha2ctz2g cha2ts2k cha2bg2l cha3yqC \
cha42n cha4xs2m cha4y2o cha4nf1 chai1ts2p chai1jnN chai2xm2q chai2c2r \
chan1ts2t chan1tsc2s chan2cs8 chan2cd2u chan2jx2x chan2s2v chan2sblx chan2m4* \
chan2sten chan2nf? chan2y2w chan2ssd} chan32z chan3j2y chan3mk2{ \
chan4sxbc chan4yy2| chang1rt2} chan1nf= chang1yvp chang1q2~ chang1drXv \
chang2xy3\042 chang2xd3# chang2dr3% chang2t3! chang2y3& chang23$ chang2nfO \
chang33' chang3t3! chang3fw3( chang3xmk) chang4dr3+ chang4k3* chang4drzXv \
chang4s3) chao1ts3- chao1j3. chao1z3, chao1ld=K chao2yy3/ chao2k30 chao2ss31 \
chao2xg32 chao2rtjK chao3k33 chao3h34 che135 che3ts36 che4ts37 che4xs38 che4ss3: ");

strcat(PinYinDic, "\
che4sr39 chen1ts^S chen1k`A chen1wh! chen1ye3; chen2ct3= chen2sk3< chen2rt3? chen2ss3A \
chen2sx3@ chen2xt3> chen2e3B chen2m3H chen4y3D chen4z3C chen4h3F chengh!A \
cheng1h3F cheng1hp3S cheng1ts3E cheng2mun* cheng2q3I cheng23P cheng2hz3K cheng2y3O \
cheng2t3G cheng2kt3J cheng2h3L cheng2ss3N cheng2m3H cheng2mdJ\042 \
cheng4h3S cheng3xx3M cheng3zz3Q cheng3m3R chi1k_j chi1kc3T chi1kz`M chi1bt3U \
chi2ss3X chi2g3Z chi2m3[ chi2zz3Y chi2ts3V chi3s3W chi33_ chi3zt3] chi3e3\\ \
chi3dty chi3dr3^ chi4tt3` chi43b chi4h3c chi4z3a chong1ls3e chong1sxzbg \
chong1sxc? chong1xe3d chong1ctt) chong23f chong2qVX chong2st3g chong3bg3h \
chong4ls3e chou1ts3i chou2tp3k chou2zt3o chou2sxc0 chou2js3q chou2h3m chou2dr3p \
chou2y3j chou2xx3n chou2z3l chou33s chou3m3r chou4xq3t chuh!B chu1st3v chu1y3u \
chu2e3} chu2ct3x chu2m3w chu2zd3{ chu2ss3| chu2j3z chu2z3y chu3dr4\042 chu3lt3~ chu3s4! \
chu3mhF chu44& chu4zt4# chu4xtPs chu4j4% chu4ts4$ chu4sxbp chuai1ts4' \
chuan14( chuan1xb4) chuan2dr4+ chuan2z4, chuan3k4- chuan4zt4. ");

strcat(PinYinDic, "\
chuang1ld44 chuang1bt4/ chuang1xb40 chuang2gt42 chuang2j41 chuang3mk43 \
chuang4ld44 chuang4sxbk chui1k45 chui1h46 chui2q49 chui2ts47 chui2j48 chui2mi3 \
chun1ct4: chun1m4; chun2js4? chun2ss4> chun2ynpH chun2y4< chun2xk4= \
chun3ct4@ chuo14A chuo4js4B chuo4cj! chuo4czv: \
ci1bt4C ci12n ci2ct4D ci2xx4H ci2sb4E ci2mkY ci2xw4I ci2y4J ci2slt ci2sh4G ci2c4F \
ci3c4K ci4ls4N ci4drKE ci4ld4L ci4b4M cong14R cong1p4Q cong1ct4P cong1e4O \
cong2r4S cong2xy4T cou4ls4U cu1m4V cu4dr4Y cu4y4W cu4zt4X cu4xzu> \
cuan1rtY` cuan1z4Z cuan4xb4\\ cuan4zt4[ cui1st4^ cui1dr4_ cui1ts4] \
cui3wh- cui4ct]M cui4k_} cui4sxc2 cui4ss4c cui4m4b cui4yt4d cui4y4` cui4bt4a \
cun1m4e cun24f cun3sxbb cun44g cuo1ts4i cuo1tsc4j cuo1s4h cuo4ts4k cuo4tsz4l cuo4j4m cuo4jxo1\001");

strcat(PinYinDic,
"da1ts4n da1k`* da1zt4p da1yqW da1dt^G da1bt4q da2zz4o da2zt4p da3ts4r da44s \
da6$@ da7%@ dai1kt4t dai34u dai3zz4~ dai3dr4v dai4xy4| dai4xb4{ dai4xsa7 dai4xhwl dai4dr4z \
dai4zzeJ dai4xx5! dai4xj4x dai4sr4} dai4d4y dai44w dan1xs5% dan15$ dan1ye5& \
dan1mmq dan1e5\042 dan1ts5# dan3y5( dan3ts5' dan4xy5) dan4dr5+ dan4xc50 \
dan4g5/ dan4ss5- dan4qt5* dan4sx5, dan4y5. dan4ts5# dang151 dang1yqI dang1jnu \
dang3xx53 dang3ts52 dang4ct54 dang4m55 dang4yqI dao156 dao1k_6 dao1qtk. \
dao35: dao3ts57 dao3xc5< dao3dr59 dao3z58 dao3y5; dao4ld5= dao4zz5@ dao4md5A \
dao4sx5? dao4h5> de1b5D de2srd5C de2sr5B de2jo= de6$G de7%G dengh#= deng1h5F deng1dt5G deng1z5E \
deng1k`b deng3zt5H deng4m5I deng4xj5J deng4ye5K di1dr5M di1t5L di1ss5N \
di2yt5T di2n5U di2q5R di2zz5O di2zt5Q di2ss5S di2fw5P di3ts5V di3gt5W di3ye[! \
di45\\ di4zz5] di4nf7 di4xj5[ di4zt5Z di4ct5Y di4js5^ di4t5X di4yZP di6$B di7%B \
dian1ss5a dian1yy5_ dian1btq2 dian1ts5` dian1sta[ dian35d dian3s5b dian3sd5c \
dian4q5e dian4ct5j dian4sx5k dian4btd5i dian45g dian4ss5m dian4ys5n dian4btq0 dian4xt5f \
dian4xd5l dian4wgh dian4dr5h diao1ls5r diao15s diao1k5p diao1s5o diao1cuu ");

strcat(PinYinDic, "\
diao1z5q diao4kt5u diao4j5v diao4y5w diao4ts5t die1ft5y die1z5x \
die2y5} die2k`) die2s5z die2c5{ die2zz5| die2xy5~ die2pk: ding16! \
ding1m6\042 ding1j6$ ding1btp[ ding1ytz ding1k6# ding3d6% ding36& ding3ytz \
ding4y6) ding4bg6( ding4ydkk ding4smV ding4j6' diu16* diu1jn{ do6$I do7%I \
dong16+ dong1wt6, dong1qtk1 dong3ct6- dong3sx6. dong4ls63 dong4m60 dong4sa< \
dong4ss64 dong4sx62 dong4y6/ dong4dr61 douh#, dou1ye6< dou1xe65 \
dou367 dou3ts66 dou3e68 dou3cr= dou4h69 dou467 dou4zz6: dou4bt6; dou4xbq< \
du1ye6< du1k`= du1xm6= du2y6A du2ssdB du2xm6> du2q6@ du2n6? \
du3t6B du3b6D du3m6C du3ztsF du4y6G du4gt6H du4ss6I du4j6F du4m6E du4n6J \
du4s< du6$E du7%E duan1l6K duan3s6L duan4ys6N duan4js6P duan4yj6O duan4j6M dui1t6Q \
dui4y6T dui4e6S dui4xe6R dunh!\042 dun1fw6X dun1k6V dun1t6U dun1z6W dun1smb \
dun3mmo dun4sscg dun4j6[ dun4hl@ dun4yy6Y dun46\\ dun4fk6Z dun4zz6] \
duo16` duo1k6_ duo1kc_M duo1ts6^ duo2dt6a duo2gt6H duo2zub \
duo3jt6d duo3t6b duo3s6c duo4mh^ duo4ld6g duo4t6b duo4z6f \
duo4sx6h duo4xt6i duo4zd6e\001");

strcat(PinYinDic,
"e1stem e1nf9 e2dr6m e2s6k e2n6p e2c6j e2yn6l e2y6o e2k6n e2jo0 e3xx6q \
e4xx6q e4mkcU e4X, e4ct6r e4ts6s e4s6v e4ye6u e4yZL e4sxc5 \
e4z6t e6$( e6s$' e7%( e7s%' ei1yZ@ ei2yZ@ ei3yZ@ ei4yZ@ en4ts^t en1xx6w er26x er2p6y \
er36z er3p6{ er3s6| er3ss6} er3zzeG er3wgm er3jno er4h6~ er47!\001");

strcat(PinYinDic,
"fa17\042 \
fa2dr7% fa2xt[R fa2mk7' fa2zt7$ fa27& fa2st7# fa3ss7( fa3sm@ fa3w7) \
fan1ct7* fan1xt7, fan1ctf^, fan1yy7- fan1j7+ fan1jfa& fan272 fan2s7/ fan2j70 fan2xx71 \
fan2h73 fan2xd7. fan374 fan3zz75 fan4s79 fan4b77 fan4q78 fan4ss7: \
fan4ct76 fan4lths fang17= fang1ct7< fang1t7; fang1jnU \
fang2y7> fang2e7@ fang2n7A fang2ht7? fang2yuvP fang3dr7B fang3y7C fang3js7D fang3zt3 \
fang4fw7E fei1h7G fei17I fei1ct7F fei1jsg3 fei1mht fei1htli fei1xcrc fei1k7H fei1nez \
fei2y7J fei3y7L fei3sk7K fei3xytd fei3xwl3 fei4ss7P fei4qat fei4xb7Q fei4y7N \
fei4gt7O fei4btpr fei4joP fei4k7M fenh#; fen1bt7V fen1k7T fen1ct7R fen1js7W \
fen1qt7U fen1y7S fen2t7X fen2lt7Y fen2ss7Z \
fen3m7[ fen4bt7V fen4drf7] fen4xx7^ fen4drYG fen4sx7_ fen4dt7\\ fen4mt7` \
feng1jk7g feng17a feng1m7c feng1bt7h feng1sscc feng1yc7b feng1s7e feng1h7i \
feng1j7f feng1c7d feng2z7j feng2js7l feng2ls7k feng3y7m feng3k_t \
feng4ct7n feng4jk7o feng4drY: feng4js7l fo2dr7p fou3bt7q fu17r fu1y7t fu1mto \
fu2ss8\042 \
fu2l7u fu2fw7s fu2tsf7w fu2ts7v fu2btYk fu2j7y fu2c7x fu2s8# fu2cfrp fu2xzfZ \
fu2drq7} fu2dr7| fu2ssb8! fu2ctf\\r fu2ct\\= fu2zt7{ fu28% fu2y7~ \
fu2sxbv fu2qt7z fu2yb8$ fu38& fu3c8( fu3y8, fu3ftj8+ fu3ft8* fu4k8@ \
fu3gtf8. fu3gt8/ fu3dr8) fu3fy8- fu3ts8' fu4drc86 fu4dr85 fu4e8= fu4z80 fu4wr84 \
fu4y89 fu4yp8< fu4crs fu4xt82 fu4xs87 fu488 fu4n8> fu4xb8: fu4ld81 fu4b83 \
fu4js8? fu4bg8;\001");

strcat(PinYinDic,
"ga1jtj8 ga1k8B ga1kj?' ga2k_H ga3j^N ga6$, ga7%, gai1y8C gai1bj` gai3fw8D \
gai4j8F gai4ss8H gai4m8E gai4md8G gan18J gan1h8I gan1m8K gan1y8N gan1zt8M \
gan1ygt{ gan1t[a gan1mg8L gan1btpa gan1j^O gan3fw8R gan3ts_& gan3mh8K gan3miO \
gan3xx8P gan3h8Q gan3z8O gan4z8S gan48I ganth#! gang1tk8T gang1ld8U gang1st8Z gang1js8Y \
gang1j8V gang1ts?8 gang1y8X gang1f8W gang3ss8[ gang3st8Z gang4m8\\ gao1bt8^ \
gao18_ gao1xy8` gao1zt8] gao1sd8a gao1m8b gao1xxX: gao3ts8c gao3h8e gao3j8d \
gao4xk8f gao4yZ> gao4jo/ ge1yq8h ge1bt8m ge18j ge1kt8g ge1yn8k ge1ts8i ge1ld8n ge1y8l \
ge1k?) ge2e8t ge2k`C ge2m8q ge2mk8s ge2ts8i ge2c8r ge28o ge2yku ge2j8u ");

strcat(PinYinDic, "\
ge3k8A ge3ct8p ge48v ge4wt8w ge4j8u ge6$2 ge7%2 gei3js8x gen1m8y gen1z8z gen4t^ \
geng1gt8} geng18| geng1l8{ geng1xm8~ geng3t9! geng3m9# geng3e9\042 geng3k_l \
geng48| gi6$. gi7%. go6$4 go7%4 gong19$ gong1bt9+ gong1hz9- gong1g9& gong1fw9% gong1cr< gong1s9* \
gong1bg9, gong1gt9' gong1ykE gong3lt9( gong3ts90 gong3g9. gong3gt9/ \
gong492 gong4dr9) gong4gt91 gou1bt94 gou1ss95 gou1j93 gou1gw8 gou1drX~ gou1ztst \
gou3q97 gou3mh[ gou3ct96 gou4m99 gou4b9: gou4t98 gou4j9; \
gu1dr9@ gu1ss9A gu1gt9< gu1k9> gu1n9C gu1ct9= gu1z9B gu3zt9? \
gu3xy9G gu3st9E gu3yz9D gu3y9I gu3xk9H gu3md9F gu4fw9J gu4fk9L gu4yy9K \
gu6$0 gu7%0 gu4st9M \
gua19O guald9N gua1ynp; gua3bg9Q gua3ld9P gua4gXT gua4ts9R gua4y9S guai19T \
guai3ts9U guai4sx9V guan1bg9Y guan1m9W guan19X guan1y9[ guan1drYD guan1tb9Z \
guan1yuw$ guan3zt9\\ guan3s9] guan4ss9` guan4f9^ guan4xb9a guan4sx9_ guan4tb9Z \
guan4ts^h guan4mdnB guang19b guang1ykW guang39c guang3qan guang4zz9d \
gui1mk9k gui1s9h gui1yvY gui1ld9j gui19i gui1w9e gui1yj9f gui1tt9g gui3y9n gui39m \
gui3c9l gui3td9o gui4mg9p gui4m9q gui4z9r gui4ld9t gui4xb9s gun3c9u gun3ss9v gun3sm^ \
gun4m9w guo1j9x guo1ye9y guo2fk9z guo2j`~ guo3xm9{ guo39| guo4z9}\001");

strcat(PinYinDic,
"ha1k9~ ha6$O ha%7O \
hai1k`K hai2zz:\042 hai2z;9 hai2g:! hai3ss:# hai4bg:& hai4m:' \
hai4:% hai4qt:$ han1y:( han1xx:) han1bw} han2jt:, han2:/ han2ss:- han2bg:. \
han2yw:+ han2hlJ han2ye:* han3k:0 han3xg:1 han4j:2 \
han4ssg:9 han4ssy:: han4sse+ han4rt:5 han4sx:6 han4tsh:4 han4ts:3 han4sxh:7 han4h:8 \
hang1dt:; hang2m:< hang2z:= hang2srPP hang2k?T hang4Oo hao1ct]o \
hao2:@ hao2xm:A hao2t:> hao2k`F hao2kh:? hao3n:C hao3ye:B hao4ss:F hao4kt:E \
hao4l:D hao4bp) he1k:H he1kh`@ he1kk:G he2h:M he2rt:O he2md:P he2qy:Q he2dr:N he2ss:S \
he2ct:I he2cth:J he2m:K he2:L he2mk:R he2ssg:T he4k:H he4y:V he4jt:X he4c:U he4yn:W \
he4xt[V he6$X he7%X hei1xs:Z hei1k:Y hen2bt:[ hen3sr:\\ hen3q:] hen4sx:^ heng1xl:` \
heng1k:_ heng2sr:b heng2sx:c heng2m:a hi6$R hi7%R ho6$[ ho7%[ hong1h:f hong1ct:d hong1k:e \
hong2js:l hong2c:g hong2bg:j hong2g:k hong2ss:i hong2ssg:h hong4k:e hong4yZ' \
hou2dr:n hou2k:m hou2q:o hou3k:p hou4dr:r hou4:s hou4ct:q hou4zzeK \
hu1:u hu1kf_| hu1k:t hu1xx:v hu1sxc1 hu2g:z hu2ss:~ hu2m:} hu2qfb) hu2q:| \
hu2fk`q hu2st:x hu2ct:y hu2w:w hu2c:{ hu3ht;\042 hu3wgz hu3ssd0 hu3k;# ");

strcat(PinYinDic, "\
hu4d;' hu4h;% hu4ts;$ hu4ss;& hu6$U hu7%U hua1ct;( hua1k;) hua2xs;* hua2k;) hua2ss;, \
hua2q;+ hua2mhk hua4ld;. hua4dr;/ hua4mhk hua4xk;- hua4y;0 \
huai2sx;3 huai2sr;2 huai2ss;4 huai2m;1 huai2zuW huai4t;5 huan1y;6 \
huan2ssd! huan2m;8 huan2w;7 huan2fk`w huan2bge> huan2zz;9 huan3js;: \
huan4[< huan4ts;; huan4k;= huan4ss;A huan4h;@ huan4bt;> huan4xx;< huan4y;C \
huan4jt;? huan4bg;B huang1ct;D huang1sx;E huang1wtkA huang2bt;J huang2jk;K \
huang2sx;L huang2h;M huang2c;H huang2ct;F huang2ssdj huang2wh+ huang2s;G \
huang2zt;I huang2srae huang3sx;P huang3rt;N huang3j;O huang3y;Q \
hu1g;! hui1ts;S hui1wgu hui1rjM hui1g;T hui1;R hui1yZ6 hui1sx;V hui1sr;U hui1gtwb \
hui2fk;X hui2ct\\n hui2c;W hui3sx;Z hui3ys;Y hui4st;\\ hui4rt;a hui4js;f \
hui4h;b hui4xx;[ hui4xxh;] hui4eg hui4ym;e hui4y;d hui4r;^ hui4ss;c hui4b;_ \
hui4he;` hun1xr;h hun1n;i hun1ct;g hun2ssj;k hun2sbF hun2y;j hun2ss;l \
hun4yZ; hun4ss;l huo1h;m huo2ss;n huo3;p huo3dr;o huo4;r huo4hxx;s huo4xb;u \
huo4ct;q huo4sb;v huo4yt;t huo4h;m\001i6$$ i6s$# i7%$ i7s%#\001");

strcat(PinYinDic,
"ji1yj<% ji1s<\042 ji1m;z ji1yu<! ji1tj;x ji1t;{ ji1xt;y ji1zt;~ ji1js<) ji1jsz<( \
ji1hz;| ji1h;} ji1y<& ji1z<# ji1ss<$ ji1dtFf ji1n<' ji1nijw ji1sh;w ji1stn? \
ji1k_s ji2<0 ji2ss<3 ji2js<6 ji2m<+ ji2st<* ji2bt<2 ji2n<5 ji2xy<9 ji2c<- \
ji2zt<. ji2ye<4 ji2xx<1 ji2s<, ji2xm</ ji3j<8 ji3<: ji3ts<7 \
ji4ss<C ji4y<F ji4yj<G ji4js<L ji4jsj<M ji4xx<I ji4dr<? ji4ts<< ji4n<K ji4ld<A \
ji4ht<> ji4sx<B ji4yw<H ji4bt<= ji4xs<@ ji4e<J ji4bg<D ji4bgs<E ji4ct<; \
jiah#+ jia1l<S jia1m<O jia1btph jia1xj<N jia1bg<R jia1<P jia1dr<Q \
jia2ct<T jia2yy<U jia3<W jia3sa5 jia3ykN jia3xb<V jia3j<X jia3dr<Y \
jia4xma<] jia4xm<\\ jia4h<Z jia4n<^ jia4drd<Y jia4dr<[ jianh#- jian1xd<b jian1zt<c jian1xt<a \
jian1xs<e jian1<f jian1n<i jian1js<j jian1d<_ jian1mk<d jian1ht<g jian1y<h \
jian1md<` jian3dr<s jian3tsj<q jian3m<l jian3ls<u jian3s<n jian3sj<o jian3xd<t jian3zt<r \
jian3<m jian3ts<p jian3ct<k jian4<{ jian4z=\042 jian4jz=( jian4drj=! jian4dr<~ \
jian4j<| jian4s=$ jian4b<z jian4ssj=% jian4ssq=& jian4ss=' \
jian4zt<} jian4xj<x jian4zp<y jian4ct<v jian4ld=# jian4yZI jiang1ss=- jiang1dr=) \
jiang1g=. jiang1=+ jiang1xn=* jiang3xs=, jiang3md=0 jiang3xd=1 jiang3ct=/ jiang3y=2 \
jiang4xy=4 jiang4e=5 jiang4sk=3 jiao1=; jiao1ye=< jiao1ctj\\z jiao1n=? \
jiao1y=: jiao1crT jiao1zuS jiao1sd=9 jiao1ct=6 jiao1s=8 jiao1ss== \
jiao1ma=> jiao1m=7 jiao2k=@ jiao3q=F jiao3sj=H jiao3s=C jiao3jsj=J jiao3js=I \
");

strcat(PinYinDic,
"jiao3j=B jiao3=G jiao3drjY. jiao3dr=D jiao3y=E jiao3ts=A jiao3ld=K jiao3c=O \
jiao3bp( jiao4c=N jiao4fw=L jiao4y=M jiao4xb=Q jiao4k=P jiao4xj>u \
jie1b=T jie1e=W jie1tsq=S jie1ts=R jie1sr=V jie1h=U jie2btp\\ jie2f] jie2ct=Z \
jie2ss=` jie2js=a jie2mu=[ jie2ts=] jie2m=^ jie2l=_ jie2yl=Y jie2xs=\\ \
jie2yg=X jie2nf< jie3j=b jie3n=c jie4=i jie4ct=f jie4bt=j jie4g=d jie4bp=e \
jie4y=k jie4dr=h jie4st=l jie4tt=g jin1rt=q jin1rth=p jin1s=m jin1=o jin1y=s \
jin1ss=r jin1zt=n jin3]@ jin3xx=t jin3y=w jin3wh* jin3dr=v jin3j=u \
jin4zz=x jin4g=y jin4zzj=| jin4ct>! jin4h=} jin4xr=z jin4xs={ jin4ss=~ jin4yl>\042 \
jing1ct>% jing1js>- jing1yqkf jing1mq>& jing1m>+ jing1>) jing1y>( jing1fl: \
jing1sx>* jing1ld># jing1rt>' jing1k>$ jing1mi>, jing3>. jing3yy>1 jing3xy>/ jing3rt>0 \
jing3sxc= jing4sr>6 jing4ykV jing4bt>7 jing4ls>; jing4q>2 jing4l>8 jing4lt>: \
jing4>9 jing4t>3 jing4j>5 jing4fw>4 jiong3xb>= jiong3h>< jiu1js>@ jiu1xb>? \
jiu1ts>> jiu1k`1 jiu1mkcN jiu3w>A jiu3xh>D jiu3>E jiu3xy>B jiu3p>C jiu3ss>F \
jiu4s>I jiu4>J jiu4xn>K jiu4j>M jiu4bt>N jiu4fw>H jiu4xk>L jiu4ct>G juh!# \
ju1ts>P ju1q>Q ju1bt>R ju1st>S ju1g>O ju1m>T ju2st>V ju2m=[ ju2ct>U ju2jo8 ju3s>X ju3>Y \
ju3k>W ju3ss>Z ju4>_ ju4bt>d ju4sk>^ ju4ts>\\ ju4h>f ju4dr>c ju4sx>e ju4fl+ \
ju4ld>g ju4tsj>] ju4z>a ju4j>b ju4qt>[ ju4zj>` juan1ts>h juan1ssd8 juan1n>j juan1yn>i \
juan3jt>m juan4dr>k juan4js>n juan4jt>l juan4>m juan4xnvA jue1ts>o \
jue2ls>v jue2y>w jue2tsm>q jue2dr>s jue2saH jue2ctXJ jue2tsq>p jue2ts>r \
jue2xj>u jue2p>t jue2js>x jue2hgqb jue2f^ jue2joc jue2zuj jun1tb>| jun1t>y \
jun1j>{ jun1xk>} jun3ct>z jun4dr?! jun4ss?# jun4ye?$ jun4s>~ jun4l?\042 jun4m?%\001");


strcat(PinYinDic,
"ka1k?' ka1kk?& ka6$+ ka7%+ ka7s%u \
kai1?* kai1tss?+ ka3st?( kai3yj?- kai3m?, kai3sx?. kai4sxbi \
kan1yl?1 kan1t?0 kan1ld?/ kan3t?2 kan3s?3 kan3m<w kan3drY) kan4?4 kan4mn+ \
kang1gt?5 kang1sx?6 kang1m?7 kang2ts?8 kang4ts?9 kang4xj?: kang4h?; kang4drXx \
kao3?< kao3ts?= kao3h?> kao4xf?? kao4jnm ke1ct?A ke1mg?C ke1m?B ke1yy?E ke1h?F \
ke1s?D ke2?G ke2k?H ke3?I ke3ss?J ke3t?@ ke4?K ke4bg?M ke4y?N ke4ld?L ke4qtk4 \
ke4k`> ke6$1 ke7%1 ken3xy?O ken3k?P ken3xt?Q ken3xx?R keng1t?S keng1k?T ki6$- ki7%- ko6$3 \
ko7%3 kong1xb?U \
kong3z?W kong3xx?V kong4ts?X kou1ts?Y kou3?Z kou4ts?[ kou4bg?\\ kou4ct^\042 \
kou4k_5 ku1m?] ku1xq?^ ku1xb?_ ku3ct?` ku4yu?a ku4gt?b ku4y?c ku6$/ \
ku7%/ ku7s%v kua1dt?d \
kua3drY( kua3t?e kua4ts?f kua4z?g kua4y?h kuai3ldXa kuai4t?i kuai4zt?j \
kuai4dr?k kuai4sx?l kuai4ykZ kuan1bg?m kuan3yq?n kuang1sk?o kuang1zt?p \
kuang1m?r kuang2q?q kuang4s?s kuang4mk?r kuang4m?t kuang4r?u kuang4ls?v \
kui1?w kui1md?x kui1xb?z kui1s?y kui2ct?{ kui2xg?| kui2g?} kui2rjR \
kui2mn% kui2k`- kui3dr?~ kui4sxg@\042 kui4sxc4 kui4ss@# kui4s@! kui4skXQ \
kui4ztsq kun1t@$ kun1xb@% kun1yvo kun4fk@' kun3ts@& kuo4ts@( kuo4tsg@) kuo4gt@* \
kuo4mk@+\001");

strcat(PinYinDic, 
"la1t@, la1ts@- la1k@2 la1zee la2j9 la3k@. la4c@/ la4y@0 la4btpx la4x@1 la4k@2 \
lai2@4 lai2ct@3 lai2jo* lai4s@5 lai4btq. lai4ztt% lan2@< lan2ts@9 lan2m@8 \
lan2ct@6 lan2zt@: lan2ss@= lan2xn@7 lan2jog lan2ybq\\ lan2sta0 lan2mk@; lan2y@> \
lan3xj@@ lan3ts@? lan3js@B lan3sx@A lan3mi- lan4h@C lan4ss@D lang1k`% \
lang2w@E lang2m@F lang2q@G lang2ye@I lang2gt@H lang3yy@J lang4ss@K lao1ts@L \
lao2ct@M lao2bg@N lao2k_k lao2jo) lao2sa@ lao3@O lao3dr@P lao3n@Q lao3jnn \
lao4ss@T lao4y@R lao4h@S le1AK le1g@U le4@V lei2yt@W lei2j@X lei2ct@Y \
lei3st@Z lei3dr@\\ lei3xt@] lei3tt@[ lei4tt@[ lei4y@_ lei4xd@` lei4ss@a \
lei4ts@^ leng2m@b leng3ls@d leng4m@c li2ct@e li2xm@f li2xn@g li2@h li2wA' \
li2zt@i li2k`, li2ynp? li2cr[ li2dh@k li2ss@l li3@o li3kA( li3w@m li3xz@n li3s@q li3y@p \
li3q@j li3dh@k li3nf2 li3jo. li4dA\042 li4hgA& li4hp@t li4A% li4ctw@w li4ct@z li4yl@x \
li4ssA$ li4ld@{ li4mA# li4btA! li4ctsl@s li4ctl@r li4s@y \
li4xm@u li4h@v li4drhY3 li4drl@~ li4drm@} li4k`& li4htle li4dr@| lia3drA) \
lian2zA, lian2ctA+ lian2gtA. lian2sxA/ lian2xbA1 lian2eA* lian2jpA- lian2ssA0 \
lian3yA3 lian3fwA2 lian4jsA7 lian4hA6 lian4jA4 lian4xxA5 \
liang2A< liang2mA8 liang2xmiA; liang2xmA: liang2lsA9 liang2xlA? \
liang3A= liang3drA) liang3gwK liang4yAB liang4xjAA liang4cA> liang4xlA? ");

strcat(PinYinDic, "\
liang4lsA9 liang4zuT liang4rA@ liao1tsAC liao2zzAI liao2ssAJ liao2btAF liao2eAD liao2hAG \
liao2drAE liao2bgAH liao2k`Z liao2jsgT liao3AK liao3jnI liao4tsAL liao4jAM \
liao4gtAN liao4mAO lie3k_V lie4ldAP lie4xyAQ lie4xsAR lie4xlAS lie4qAT lin2mAV lin2wAU \lin2ytAX lin2sAW lin2ldAY lin2yeAZ lin2ssA\\ lin2lwk lin2yA[ lin3lsA] lin3sxcA \
lin4wtA_ lin4xbA^ lin4ct]~ ling1tsA` ling2wAa ling2drAf ling2jAe ling2yAg \
ling2ytAc ling2cAd ling2lsAh ling2eAj ling2ctAb ling2xhAi ling2fk`r \
ling2elqv ling2jsg1 ling2yyta ling3sAk ling3yyAl ling4rtAn ling4ktAm liu1ssAo liu2xtAt liu2slAs \
liu2btAv liu2ldAu liu2ssld/ liu2ssAw liu2sAr liu2mAq liu2wAp liu3mAx liu3jsg8 \
liu4Ay liu4ze^ liu4eB= long2Az long2kA| long2xsmC long2xeA{ \
long2wgg long2ykJ long2xbA~ long2eB! long2ztA} long3xtB\042 long3tsB# long3epB$ \
lou2xnB& lou2mB% lou2drYM lou3tsB' lou3ztB( lou4ssB) lou4eB* \
lu2ctB+ lu2hsB, lu2gtB. lu2hB/ lu2yyB- lu3xrB3 lu3tsB0 lu3B1 lu3htB2 lu3miV \
lu3joe \
lu4eB= lu4xsB< lu4yB; lu4gtB9 lu4zB7 lu4bpB8 lu4ytB6 lu4ygB> lu4sB5 lu4ltB4 \
lu4ssB: lv2mB? \
lv3jBA lv3ktB@ lv3drBB lv3fBC lv3stBE lv3stfBD lv3jsBF lv3ts^[ lv3yqZ \
lv4htBG lv4qtBH lv4srBI lv4xsBJ lv4ssBK lv4jsBL luan2xzBO luan2xsBM luan2xssBN luan2xmho \
luan2ssBP luan4sBR luan3BQ lue4tsBS lue4tBT lun1tsBU lun2cBV lun2drBW \
lun2ssBY lun2jsBZ lun2rtBX lun2`p lun4yB[ luo1stB^ luo2stB^ luo2ctB\\ luo2zB_ \
luo2jB` luo2ztBa luo2mBb luo2cB] luo3yBc luo4ctBd luo4ssBe luo4mBf luo4jsBg\001");

strcat(PinYinDic, 
"ma1nBh ma1kmBp ma1kBo ma2gtBi ma2cs! ma3Bm ma3kBp ma3sBk ma3cBl ma3wBj \
ma4xmBn ma6$^ ma7%^ mai2tBq mai2ytv2 mai3Br mai4Bs mai4stBt mai4zBu mai4yBv \
man2sBx man2xcBy man2mBw man3ssBz man4ctB{ man4sxB} man4ssB~ man4yC! \
man4ja# man4rtB| mang2sxC& mang2xmC$ mang2smK mang2wC% mang2ctmC\042 mang2ctC# \
mang3ctC' mang3cr~ maoh#: mao1qC( mao2C, mao2pC+ mao2xmwV mao2ctC) mao2jC* mao2njs \
mao3C. mao3jC- mao4rtC0 mao4jC1 mao4ctC/ mao4xbC3 mao4cC2 mao4wh# me4C4 me5C4 \
me6$a me7%a \
mei2wC5 mei2mwC6 mei2mC7 mei2yC8 mei2ytC9 mei2C< mei2saR mei2nC= mei2hC: \
mei2ssC; mei2joQ mei3xdC@ mei3jC> mei3wrC? mei4nmCD mei4nCC mei4rCA mei4gwH \
mei4bgCB men1mkCF men2CE men2drCG men2ts^Q men2jnM men4mkCF men4hlK men4xxm/ \
meng2ctmCH meng2ctCI meng2mCJ meng2mdCK meng2yk| meng3qCM meng3jCL meng3sxcB \
meng4mdCO meng4ltCN mi1mCP mi2yuCQ mi2zCT mi2yCU mi2gtCR mi2gtmCS mi2gCV mi2qb( \
mi3CW mi4ssCZ mi4hCX mi4bgcC\\ mi4bgC[ mi4xjCY mi4tbC] mi6$_ mi7%_ mian2jsC` mian2muC^ \
mian2mC_ mian3rtCa mian3Cb mian3ylCc mian3nCd mian3jsCe mian3yko mian4Cf miao1k_w \
miao2ctCg miao2tsCh miao2mCi miao3hCk miao3ssCl miao3ctCj miao4nCn miao4gtCm \
mie1k_c mie4Cp mie4ctCo min2Cq min3fwCt min3mkCv min3tsCr min3sxCu min3Cs \
min3ssc} ming2C{ ming2jCz ming2mn( ming2cCx ming2kCy ming2rCw ming3yu$ ming4C| \
miu4yC} mo1tsC~ mo2sbI mo2mD# mo2yD$ mo2ctD\042 mo2ctsD! mo2gtmD& mo2gtgD' \
mo2gtD% mo3tsD( mo4D) mo4ctm\\T mo4ctD* mo4ssD. mo4bgD/ mo4xtD+ mo4xsD, \
mo6$b mo7%b mu4ssmD- \
mo4eD0 mo4gtD% mou2xnD2 mou2yD1 mou2mmx mou3xmD3 mu3D8 mu3tsD4 mu3nD7 mu3ntD5 \
mu3xtD6 mu4sD? mu4D> mu4ssce mu4cttD< mu4ctjD9 mu4ctD; mu4ctrD: mu4ctsD= \
mu4fwDA mu4mD@ mu4jnb mu4hDB mu6$` mu7%`\001");

strcat(PinYinDic,
"n6$s n7%s na2rtDC na2joU na3kDD na4jsDI na4jDF na4yeDG na4nDH na4ts^` na4kDE na5kDD \
na6$J na7%J \
nai3DK nai3nDL nai3qtDJ nai4ylDM nai4dtDN nan2DO nan2k`+ nan2mi* nan2xlDP \
nan2yDQ nan2ynkn nan4yDQ nang2DR nao2tsDS nao3sxDU nao3yDT nao3wh' nao4mkDV \
nao4ssDW ne1DX ne5DX ne6$M ne7%M nei3sDY \
nei4DZ nen4nD[ neng2D\\ ni1npD] ni2stDa ni2ssD` ni2ytD^ ni2rjG ni2sxbn ni2jnj \
ni2drD_ ni3drDc ni3tsDb ni4zzDf ni4skDd ni4yDe ni4ssDg \
ni6$K ni7%K nian1ctDh nian1tsDi \
nian2Dj nian2mU3 nian3tsnDl nian3tsDm nian3sDk nian4xxDn niang2nDo niang4yDp \
niao3Dq niao3nttA niao4stDr nie1tsDs nie4etDt nie4jnDw nie4jDx nie4ssDy nie4ctDu nie4kDv \
nin2xxDz ning2bgD~ ning2mD{ ning2tsE! ning2k_L ning2lsD} ning2qD| ning3tsE! \
ning4tsE! ning4ssE\042 niu1nf$ niu2E# niu3tsE$ niu3jsE& niu3sxbn niu3jE% \
niu4ts^V no6$N no7%N nong2E) nong2ssE( nong2yE' nong4ldE* nou2tsE2 nou4yE5 nou4sxE3 \
nou4mE4 nu6$L nu7%L nuo4jo; nuo4k_v nu2nE+ nu3xlE, nu4xxE- nv3E. nv3jnO nuan3rE/ \
nue4btE1 nue4htE0\001\
o1kw`8 o1kE6 o6$* o6s$) o7%* o7s%) ou1yqE7 ou1ysE9 ou1kE; ou1yZ) ou1ynE8 \
ou3drE< ou3ctE: ou3kE; ou4sxbf ou4ssE=\001");

strcat(PinYinDic,
"pa1zE? pa1kE> pa1ct]b pa2mhK pa2gE@ pa2ts0G pa2xbEC pa2l0R pa4sxEB pa4jEA \
pa6$Q pa7%Q pai1tsED pai2tsEE pai2srEG pai2pEF pai4ssEI pai4ssbEH pan1ssEK pan1EJ \
pan2mdEL pan2xsEM pan2zug pan4ldEP pan4tEO pan4yfEQ pan4mEN pang1ER \
pang2ptET pang2cs& pang2gtES pang2s0u pang3lpEU pang4yEV pao1tsEW pao2ldEY pao2yE[ \
pao2kEX pao3zE\\ pao4ssE] pao4hEZ pao4btpe pe6$Z pe7%Z pei1kE^ pei1yE_ pei2eEc pei2tE` \
pei2bEb pei2xyEa pei2joB pei4ssEf pei4drEe pei4yEd pen1kEg pen2mdEh \
peng1tsEj peng1sxbq peng1sEi peng1xsEk peng2Es peng2yEr peng2mEo peng2sEp \
peng2ynEt peng2fsEm peng2ssEl peng2ctEn peng2ztEq peng3tsEu peng4sEv \
pi1tsbEz pi1tsE{ pi1sEx pi1tEw pi1xdE| pi1ytEy pi2F$ pi2btF# pi2tE~ pi2xbE} \
pi2kF! pi2yF\042 pi2jnk pi3F% pi3btF& pi4drF' pi4stF( pi4xyF) pi4yx1Y pi6$T pi7%T \
pian1F, pian1drF+ pian1ztF* pian1yytf pian4mF- pian4F, piao1ldXb piao1jsgN \
piao1yfF. piao1ssF/ piao2nfN piao2mFS piao2ygF0 piao3ssF/ piao3mn) \
piao4xsF1 piao4ssF/ pie1qtk- pie1tsF2 pie1xmF3 pie3tsF2 pin1tsF4 pin1nf0 \
pin2xbF6 pin2yyF5 pin3ktF7 pin4eF8 ping1F9 ping2F= ping2yF@ ping2tF: \
ping2ctpF; ping2ctF< ping2stFA ping2ywF? ping2xjF> po1ssb24 po1ssFC po1tFB \
po1yyFD po1jnG po2xnFE po3skXO po3jn^ po3ztsM po4zFH po4wgj po4bFG po4sFF \
po4mFI po6$] po7%] pou1ldFJ pu1drFM pu1tsFK pu1jFL pu1k`[ pu2ctFN pu2ctsFQ pu2ctpFO \
pu2ctbFP pu2y8, pu2Yi pu2jod pu3xrFU pu3ssFV pu3yFW pu3tFR pu3fkFT pu3mFS pu3joh \
pu4ssFY pu4jFL pu4rFX pu6$W pu7%W\001");

strcat(PinYinDic,
"qi1ctF] qi1F_ qi1xmFb qi1yyFZ qi1yqF[ qi1xnF^ qi1lsF` \
qi1ssqFc qi1mF\\ qi1ssFa qi1k`R qi2dtFf qi2tFh qi2sFi qi2maFo qi2wtFk qi2Fd \
qi2mFe qi2fFl qi2zFg qi2yFj qi2wgy qi2ct\\y qi2sbFm qi2yeFn qi3Fr qi3stFq \
qi3hkFt qi3rtFs qi3zFp qi3mh= \
qi4kFw qi4Fx qi4ssF{ qi4sslF| qi4yF} qi4ldFz qi4sFv qi4zFy qi4xdFu qi4xxm, \
qia1tsF~ qia4sxG! qia4ssG\042 qian1fkG' qian1drG* qian1zzG( qian1ztG) \
qian1xnG# qian1tsG$ qian1yG% qian1jG& qian1yqG+ qian2G0 qian2qG, qian2jG. qian2jgG/ qian2htr/ \
qian2ztsi qian2ssG1 qian2hG- qian3ssG3 qian3yG4 qian3zzG2 \
qian4G7 qian4jG8 qian4xtG5 qian4stG6 qian4ct\\g qian4drY; qiang1kG: qiang1mG9 qiang1yG; \
qiang1jjoO qiang1joj qiang1G< qiang2yq_ qiang2gG? qiang2ctG> qiang2tG= qiang3tsG@ \
qiang3ytG qiang4zuD qiang4kG: qiao1sxGD qiao1gGC qiao1zuN qiao1mGA qiao1jGB \
qiao2GG qiao2drGH qiao2mGE qiao2muGF qiao2sxc> qiao2ct\\q qiao3gGI \
qiao4drGN qiao4yZ= qiao4sGM qiao4gGJ qiao4xbGO qiao4yyGL qiao4tsGK \
qie1tGP qie2ctGQ qie3GR qie4xnf* qie4sxGS qie4tGP qie4xbGT \
qie4sxqc+ qie4joF qin1xmGW qin1jGU qin1drGV qin2xhGX qin2ylGZ qin2rtG] qin2k`_ \
qin2tsG\\ qin2ctG[ qin2ctj\\K qin2xjGY qin3bgG^ qin4ssG_ qin4ts^l \
qing1xyG` qing1ssGe qing1cqr_ qing1cGa qing1qtGb qing1drGc qing1Gd \
qing2sxGi qing2rGg qing2qtGh qing2xsGf qing3yGk qing3yyGj qing4gtGl \
qiong2xbGn qiong2xbgq7 qiong2wGm qiu1hGo qiu1yvz qiu1Gp qiu1yeGq \
qiu1crG qiu2fkGt qiu2Gs qiu2dGu qiu2wGr qiu2ssGv qiu2zeO qu1skGx qu1cGy qu1sG{ qu1sqa+ \
qu1mG} qu1stG| qu1zGw qu1cqrP qu2xmG~ qu3Gz qu3eH! qu3xnH\042 qu3cH# qu4H% qu4zH$ \
qu4xjo quan1H& quan2H+ quan2btH, quan2yH) quan2mH( quan2xsH* quan2jtH- \
quan2cri quan2yyH' quan3H. quan4yH0 quan4jtH/ que1H1 que1hH2 que2btH3 \
que4yeH4 que4H8 que4sH7 que4ynH5 que4mH6 qun2yyH: qun2yH9\001");

strcat(PinYinDic,
"ra6$i ra7%i ran2xsH; ran2hH< \
ran2xrwW ran3H= ran3xmH> rang2ygH? rang3tsHA rang3kHB rang3tH@ rang4yHC \
rao2sHD rao3tsHE rao2nf, rao4jsHF re3xxHG re4xsHH re6$l re7%l ren2HK ren2pHI ren2drHJ ren3xxHL \
ren4drHN ren4sb? ren4yHO ren4nHQ ren4HP ren4jsHR ren4yrHM reng1tsHS reng1drHT \
ri4HU ri6$j ri7%j ro6$m ro7%m \
rong2bgH] rong2ssH\\ rong2hH[ rong2miE rong2cteHW rong2ctrHX rong2ctHY rong2saI \
rong2jsH^ rong2ycHZ rong2HV rong3tbH_ rou2xmHa rou2tsH` rou2zue rou4Hb \
ru2nHg ru2drHe ru2zHf ru2jo( ru2ctHc ru2cHd ru3fHi ru3nHj ru3xcHh ru4Hk \
ru6$k ru7%k ru4yHl \
ruan3cHm ruan3eHn rui3ctHo rui4jHq rui4wHp rui4hsn# run4mkHr run4ssHs ruo4ctHt ruo4Hu\001");


strcat(PinYinDic,
"sa1drXm sa3tsHv sa3ssHw sa4X& sa4ctHx sa4ll* sa6$5 sa7%5 sai1bgH{ sai1yHy sai1yuHz \
sai4bgH| sai4bgtH{ san1H} san1xsH~ san3fwI\042 san3rtI! san4fwI\042 sang1xmI# \
sang3kI$ sang3ts^z sang4I% sao1mI' sao1tsI& sao3tsI( sao3nI) sao4yk} \
se4I+ se4xhXD se4ssI, se4xbI* se4jo$ se6$; se7%; sen1mtI- seng1drI. sha1jsI4 sha1sI0 \
sha1ssI3 sha1ctI/ sha1xyitD sha1xyvh sha1xmI1 sha1ldI2 sha3drI5 sha4ytv. \
sha4xsI7 sha4kI6 sha4ctOC shai1ztI8 shai4rI9 shan1I= shan1zt. shan1mI< \
shan1ybI@ shan1yk~ shan1ldI> shan1hI? shan1jnL shan1nf) shan1wI: shan1zcuG \
shan3mkIA shan3eIB shan4xkIF shan4jsII shan4yIE shan4yuw- shan4ssIG shan4btp^ \
shan4htIH shan4tsIC shan4ctI; shan4bID shang1IL shang1tpIJ shang1drIK shang1xyIQ \
shang3rIN shang3xbIM shang4IO shang4pIP shao1hIU shao1hxIT shao1tsIS shao1mIR \
shao1zt9 shao2IW shao2ctIV shao4xkUY shao4yIX shao4IY shao4jsI\\ shao4yeI[ \
shao4kIZ she1dtI] she1bI^ she1xkI` she2rtY\\ she2cI_ she4rtIa she4sbIg she4yIh \
she4ssIf she4fwIb she4sId she4gtwj she4tsIc she4sxIe shen1Ij shen1pIm shen1ssIn shen1drIl \
shen1kIk shen1sIi shen1xs2N shen1nIo shen1jsIp shen2sIq shen2drJ2 shen3bgIs shen3nIt \
shen3ssIr shen4Iu shen4ssIx shen4xyIv shen4sxIw sheng1pIz sheng1I} sheng1stIy \
sheng1nI| sheng1ynI{ sheng2jsI~ sheng3xmJ! sheng4yJ$ sheng4ldJ# sheng4mdJ\042 \
sheng4xtJ% shi1yjJ& shi1qJ( shi1J, shi1pJ' shi1hJ- shi1yJ+ shi1fJ) shi1ssJ* \
shi1s3W shi2J. shi2hJ/ shi2rtJ3 shi2sJ4 shi2bgJ5 shi2rJ1 shi2tsJ0 shi2yJ6 shi2pJ8 shi3nJ< shi3stJ: \
shi3drJ9 shi3J7 shi3mJ; shi4rtJG shi4xjJ@ shi4dhJP shi4sxJQ shi4gtJ= shi4hsJ? shi4pJO shi4hJB \
shi4sJM shi4mJA shi4yJT shi4tsJC shi4xyJD shi4drJL shi4zJJ shi4zsJE shi4drsJK shi4kpJI shi4xxJ> shi4xlJF \
shi4bgJR shi4jn shi4sbJN shi4shJS shi4kJH shou1fwJU shou3JV shou3dJW shou3bgJX \
shou3zt< shou4JY shou4xyJ\\ shou4tsJZ shou4xkdJ^ shou4xkJ[ shou4btJ] \
shu1Ji shu1hzJh shu1tsJc shu1sJf shu1ssJg shu1dJb shu1mJa shu1ctJ_ shu1yyJe shu1cJd \
shu1mqJ` shu2xsJl shu2xt[S shu2bJj shu2cJk shu3rtJn shu3stJp shu3stpJq shu3htJr shu3ctJm shu3rJo \
shu3styJt shu3Js shu4fwJ} shu4gtJ| shu4ssJ~ shu4dJu shu4ctJy shu4Jx shu4xlJz shu4xxK! shu4mJw ");

strcat(PinYinDic,
"shu4xtJ{ shu4zzJv shua1ldK\042 shua1k`' shua3xnK# shuai1K% shuai1tsK$ \
shuai3K& shuai4xsBJ shuai4yjK' shuan1tsK) shuan1mK( shuan1mkcE shuan4ssdL \
shuang1yK+ shuang1ytK* shuang1nfW shuang3K, shui2yK- shui3K. shui4hK0 \
shui4mK/ shun3kK1 shun4yyK3 shun4mK2 shun4atK4 shuo1yK5 shuo4yyK7 shuo4hK8 shuo4sK6 si1xyK? si1xxK< \
si1qK9 si1tsK: si1ks_P si1kK; si1K> si1hK= si1joH si3K@ si4KD si4drsKE si4drKF \
si4mfa si4sKG si4xcKB si4zKA si4ysKC si4xxKH si6$7 si7%7 so6$= so7%= song1mKI song1ssdA song3xxKK song3ctKJ song4bgKN \
song4ygKP song4yKO song4gKL song4zzKM sou1tsKQ sou1sbH sou1fl, sou1zKR sou3tsKS \
sou4kKT su1ctKU su1yKV su2drKW su4KX su4gK` su4bgK^ su4zzKY su4xmKZ su4xtK\\ su4yK_ su4drK[ su4ssK] su6$9 su7%9 \
suan1yKa suan4ctKb suan4ztKc sui1ktKd sui2epKe sui2eKf sui2jsKg sui2zzKl \
sui4stKj sui4sKi sui4eKm sui4hl] sui4heKk sui4xsKn sui4zzKl sui4gKh sun1zKo sun1qax \
sun3ztKq sun3tsKp suo1kKt suo1ctKr suo1mKs suo1ks`B suo1jsKu suo1ytH \
suo3yjKy suo3wKv suo3jKx suo3Kw\001");

strcat(PinYinDic, 
"ta1drK{ ta1nK} ta1bgK| ta1tKz ta1zze] ta3tK~ ta3qL! ta4zL$ ta4ztL# ta4mi= \
ta4tsL\042 ta6$? ta7%? \
tai1yL% tai2xkL( tai2ctL& tai2tsL' tai4yL* tai4L+ tai4ssL- tai4xxL, tai4ctL) \
tai4jnQ tan1tsL/ tan1ssL2 tan1btL1 tan1tL. tan1xbL0 tan2yL8 tan2btL5 tan2tL3 tan2ssL6 tan2ytL7 \
tan2g5/ tan2mL4 tan3tL9 tan3xxl~ tan3mL: tan3jnc tan3yL; tan4sL< tan4stL? \
tan4kL> tan4tsL= tang1ssL@ tang1ytJ tang2gtLF tang2tsLB tang2ssdg tang2mLG \
tang2xtLC tang2xdLD tang2yLE tang2jo[ tang2cs+ tang2tLA tang3sLI tang3drLH \
tang3ssLJ tang4xhLL tang4zLK tao1ssLO tao1jsLP tao1sssLN tao1tsLM tao2k_{ tao2eLU \
tao2ctLQ tao2ssLT tao2zLS tao2mLR tao3yLV tao4dtLW te4nLX te4xxl} te4jo+ ");

strcat(PinYinDic,
"te6$F te7%F teng2btL[ teng2ctLY teng2yLZ teng2xyL\\ ti1mL] ti1ldL^ ti1zL_ ti1jL` \
ti2tsLa ti2sLb ti2kLd ti2zLc ti3drLe ti4ldLj ti4ssLi ti4sxLh ti4stLk \
ti4xrLf ti4kLg ti6$A ti7%A tian1Ll tian1ssLm tian2Lo tian2sLp tian2tLn tian2sxLq tian3sLr \
tian3yLs tiao1tsLt tiao2Lu tiao2zzLv tiao2y5w tiao2xbq; tiao2ztsT tiao4mLw tiao4zLx \
tie1jL{ tie1bLy tie3jLz ting1ctL| ting1kL} ting1hL~ ting1ssM! ting2yzM\042 ting2gtM% \
ting2ytv* ting2xdM$ ting2drM# ting2nfC ting2crQ ting3tsM& ting3zM' \
to6$H to7%H tong1zzM( \
tong2tkM, tong2ltM/ tong2mM+ tong2muM) tong2jM- tong2yM* tong2fsM. tong3jsM3 \
tong3tsM1 tong3mM0 tong3ztM2 tong4btM4 tong4sxbz tou1drM5 tou2M7 tou2tsM6 \
tou4zM8 tu1M9 tu1htM: tu1xbM; tu2ssM? tu2zM> tu2fkM< tu2srM= tu2stM@ tu3MA \
tu3jnJ tu4MC tu4kMB tu6$D tu6s$C tu7%D tu7s%C \
tuan1ssMD tuan2fkME tui1tsMF tui2tMG tui3yMH tui4yMJ \
tui4zMK tui4cMI tun1xkML tun2MM tun2sb= tun2yk` tun2xyMN tuo1tstMP tuo1tsMO \
tuo1yMQ tuo2ssc{ tuo2smH tuo2zuI tuo2mtMU tuo2mMT tuo2nMR tuo2eMS tuo2t[g tuo3xnMW \
tuo3mMV tuo4tsMX tuo4kMY\001u6$& u6s$% u7m%& u7s%% u7%t\001\001");

strcat(PinYinDic,
"wa1tsMZ wa1kM[ wa1ssM] wa1cM\\ wa2nM^ wa3M_ wa4yM` wa6$o wa6s$n wa7s%n wa7%o \
wai1btMa wai4Mb wan1dMc \
wan1ldX` wan1xgMd wan1ssMe wan1crj wan2Mh wan2wMf wan2bgMj wan2yMg \
wan2jsf} wan2hMi wan3bgMp wan3sxMo wan3nMq wan3sMk wan3ynMs wan3ykd wan3bMn \
wan3tsMl wan3rMm wan4Mr wang1ssMt wang2dMu wang2Mv wang3tkMx wang3mkXh wang3mMw \
wang3srMy wang3sxc/ wang4xnM} wang4xxM| wang4rMz wang4xwM{ we6$q we7%q wei1N# wei1chtM~ \
wei1srN\042 wei1stN! wei1drYK wei1ct^1 wei2hN$ wei2N* wei2sxN) wei2kN( wei2jsN, wei2zN% \
wei2fkN' wei2mN& wei2ssN+ wei2ja! wei2staM wei3drwN1 wei3drN0 wei3jsN3 wei3stN2 wei3nf8 \
wei3xnN/ wei3ctwN- wei3ctN. wei3kN( wei3btpt wei4hN4 wei4N@ wei4ttN7 \
wei4kN6 wei4kwN9 wei4xyN8 wei4yN= wei4ssN< wei4ycN> wei4ctN5 wei4xxN? wei4drN; \
wei4ygN: wenh#? wen1btNA wen1ssNB wen2ND wen2jsNF wen2cNC wen2ytv) wen2mkNE wen3hNH wen3kNG \
wen3wtNI wen4mkNJ weng1kNK weng1xyNL weng4xwNM wo1ssNP wo1xbNQ wo1cNO \
wo1tsNN wo1ct]+ wo3NR wo4ssNV wo4NT wo4tsNU wo4jwa\042 wo4jNS wo6$r wo7%r wu1ssN[ wu1t[X \
wu1hNW wu1NZ wu1kNX wu1jNY wu1stN] wu1yN\\ wu2N^ wu2pNc wu2ktNb wu2crZ wu2xkNa \
wu2ssd4 wu2ctN_ wu2mN` wu3hNe wu3Ng wu3tNh wu3wtNd wu3drmNj wu3drNi wu3tsNf \
wu4Np wu4ctNl wu4hX# wu4nNo wu4xlNq wu4ytNm wu4sxNr wu4rNn wu4yNs wu4tpNk wu6$p wu7%p\001");

strcat(PinYinDic,
"xi1pO& xi1Nw xi1nN~ xi1ssxO+ xi1ssO* xi1spNy xi1sNx xi1xbO# xi1hxiO! xi1xrNt \
xi1sxO' xi1mNv xi1riNz xi1kxN{ xi1jN} xi1xxO\042 xi1xxxO$ xi1cs, xi1nufR xi1stO, xi1kN| \
xi1sdNu xi1hO( xi1hxO) xi1yO% xi1rjX xi2O0 xi2gtO/ xi2xyO. xi2nO1 xi2mO- \
xi3ssO4 xi3jO3 xi3stO2 xi4yO7 xi4O5 xi4jsO8 xi4eO6 xia1cO: xia1mO9 \
xiask2O; xia2zzeZ xia2rO> xia2ytO< xia2cO= xia2sO? xia2wh& xia2drO@ xia2qOA xia4OB xia4xwOD xia4kOE \
xia4ctOC xian1OH xian1drOI xian1tsOF xian1jOG xian1yOJ xian1jsOK xian1qtk/ \
xian2gOR xian2zOO xian2mkOP xian2nOS xian2xbOM xian2ctOL xian2ssOQ xian2srON \
xian2nuf5 xian3rtOT xian3eOU xian3lsY~ xian4wOV xian4ct\\H xian4ejO] xian4eO^ \
xian4sOZ xian4OX xian4jsO_ xian4bgO\\ xian4yqOW xian4xcO[ xian4yOY \
xiang1Og xiang1dhOe xiang1ssOf xiang1ctOa xiang1ztOd xiang1xrOc xiang1jOb xiang1mO` \
xiang2yOj xiang2sbOi xiang2yyOh xiang2e=5 xiang3sbC xiang3kOl xiang3xzOm \
xiang3xxOk xiang4xOs xiang4Or xiang4xtOo xiang4drOq xiang4mjOp xiang4mO` \
xiang4gOn xiao1ssO{ xiao1ldOw xiao1ytOv xiao1bgO| xiao1zeP xiao1sOu xiao1jOz \
xiao1ctOt xiao1ztso xiao1kOx xiao1Oy xiao1xtP$ xiao2ssO} xiao3P! xiao3rO~ xiao4ztP& \
xiao4fwP' xiao4mP# xiao4P\042 xiao4kP% xie1ctP) xie1mP( xie1yqP* xie1cP+ \
xie2sP- xie2yjP2 xie2drYI xie2yuP3 xie2yeP0 xie2yP1 xie2twsP. xie2tsP/ xie2gP, \
xie3tbP4 xie4yP; xie4sxP8 xie4sspP9 xie4ssP: xie4yeP6 xie4mP5 ");

strcat(PinYinDic, "\
xie4xcP7 xie4stP< xin1PD xin1dtPA xin1jtvN xin1ctxP> xin1ctP= xin1jP@ xin1jxP? \
xin1qPB xin1sxPC xin1xx\\0 xin4drPE xin4xPF xin4ctP> xing1rtPG xing1qPI xing1sxPJ \
xing1yPH xing1PK xing2srPP xing2fsPN xing2ldPL xing2yePO xing2xtPM \
xing3yPQ xing3ts_) xing4ttPR xing4PK xing4nPU xing4sxPT xing4xkPS \
xiong1PV xiong1xkPW xiong1ssPZ xiong1yPX xiong1btPY xiong2yjP[ xiong2xsP\\ xiu1drmP] \
xiu1drP^ xiu1P_ xiu3mP` xiu4xnPc xiu4jsPe xiu4jPb xiu4yPd xiu4kPa xu1htPi \
xu1tPf xu1kPj xu1yyPk xu1Pg xu1ytPh xu2srPl xu3yPm xu3mhr xu4jPq xu4gtPr \
xu4yPp xu4xtPs xu4sxPt xu4ctPn xu4yuPo xu4jszPw xu4rtPu xu4nPv xu4xslc xu4jsPx xuan1cPy xuan1bgP{ \
xuan1kPz xuan2P~ xuan2fP} xuan2ssdv xuan2xxP| xuan3zQ! xuan3btQ\042 \
xuan4sscy xuan4mQ# xuan4jsQ$ xue1gQ% xue1ctQ& xue2xtQ' xue2bgQ( xue3ytQ) \
xue4Q* xun1yQ+ xun1xsQ, xun2xcQ0 xun2Q. xun2yQ/ xun2mQ1 xun2zzQ2 xun2srQ- \
xun2sa> xun4yQ6 xun4ycQ5 xun4ssQ4 xun4zzQ8 xun4dQ3 xun4zzsQ7\001");

strcat(PinYinDic,
"ya1Q> ya1ctQ9 ya1ynQ< ya1yQ; ya1tsQ: ya1kQ= ya2Q@ \
ya2ctQ? ya2stQB ya2ssQD ya2cQA ya2srQC ya3kQF ya3yjQE ya4QG ya4yQH \
ya6$d ya6s$c ya7%d ya7s%c yan1kQJ \
yan1ykY yan1hQL yan1ssQM yan1mkQK yan1ztQI yan1nfL yan2QO yan2xkQT yan2sQP \
yan2ssQX yan2yzQS yan2stQR yan2htQW yan2mdQN yan2yyQU yan2mkQV yan2mi\\ \
yan2cQQ yan3mQ[ yan3ssQ] yan3dtQY yan3tsQZ yan3srQ\\ yan4fQ^ \
yan4ctQa yan4ctnQc yan4kQd yan4dhQe yan4yQh yan4sQb yan4bgQg yan4mQi yan4hQf yan4xsQ` yan4tQ_ \
yang1Qk yang1dQj yang1hQm yang1xnQl yang2Qr yang2drQp yang2ssQs yang2tsQo \
yang2mQn yang2btQq yang2eQt yang3xjQx yang3qtQu yang3btQw yang3drQv \
yang4mQy yang4ssQz yang4sxbs yang4xxm& yao1yQ| yao1nQ} yao1zQ{ \
yao2yR% yao2tsR! yao2zR# yao2wQ~ yao2nR& yao2xykH yao2xbR$ yao2R\042 \
yao3kR' yao3R( yao4xbq: yao4rjW yao4gR+ yao4xnR* yao4ctR) yao4jT? yao4ynpN \
ye1mR, ye1tsR4 ye1kR- ye1yeR. ye2ftR/ ye3R2 ye3lsR1 ye3lR0 \
ye4R5 ye4dR9 ye4hR3 ye4yR8 ye4kR6 ye4tR7 ye4tsR4 ye4ssR: ");

strcat(PinYinDic, 
"yi1R; yi1stR< yi1tsR> yi1dRB yi1skR= \
yi1drR@ yi1drsRA yi1jR? yi2hhRD yi2RI yi2nRL yi2yRH yi2ssRJ yi2ldRM yi2sxby \
yi2sbB yi2bj] yi2hRF yi2drRG yi2bgRK yi2zRE yi2cRC yi3yrRT yi3hzRR yi3RQ yi3cRO \
yi3xsRS yi3drRP yi3mRN yi4Re yi4dR` yi4ldRl yi4ysRc yi4yRk \
yi4yhRi yi4yzRh yi4yyRj yi4drRZ yi4sxRd yi4ctRU yi4sRY yi4srpR[ yi4btR_ \
yi4ytRa yi4rtRW yi4mdRf yi4ssRg yi4xxRb yi4yuR\\ yi4xlRn yi4xgRm yi4tsRV \
yi4zR] yi4jsRo yi4srRX yi4bR^ yi4xd^H yin1Rr yin1ysRs yin1nRv yin1eRu yin1ctRp yin1ctsRq yin1xrRt yin1jnw \
yin2jRx yin2bgRz yin2ssRy yin2kRw yin3gR} yin3cr> yin3eR~ yin3btq+ yin3R| \
yin3sR{ yin4yeS! ying1ctgS\042 ying1xnS$ ying1jsS' ying1gtwS% ying1gtS& \
ying1gttb_ ying1ct]: ying1mS# ying1ynpP ying2zzS- \
ying2ctS* ying2chtS+ ying2mdS/ ying2wtS. ying2cS, ying2ctbS( ying2ctcS) ying2cts]S \
ying3fsS0 ying3yyS1 ying4rS3 ying4sS2 yo1kS4 yo6$h yo6s$g yo7%h yo7s%g yong1drS6 yong1tsS5 yong1gtS9 \
yong1yS7 yong1bS8 yong1dhS: yong3S@ yong3kS= yong3ssS> yong3ssyS? yong3xlSB yong3xxSA yong3cS< \
yong3zS; yong4tkSC yong4drS6 you1drSE you1sxSG you1xxSF you1SD \
you2ySH you2SI you2btp` you2yhvO you2qSL you2yeSJ you2ssySM you2jSK you2ssSN you2hSO you3SP you3ySQ you3jnp you4SV you4zSR you4drSS you4yyST you4ySU you4ylSW \
yu1zSX yu1ssSY yu1btpv yu2SZ yu2rtS` yu2rtgSa yu2xySc yu2ssSf \
yu2sxSd yu2zzSb yu2mS\\ yu2yZD yu4nSi yu2xxS^ yu2mdS[ yu2dhS] yu2ssySe yu2epSg yu3Sk yu3gSh yu3hSj yu3rS_ \
yu3sSl yu3bgSn yu3pSm yu3xSp yu3ySo yu4Sq yu4ctSs yu4kySu yu4kSw yu4sSx yu4ssT! yu4gS{ yu4tSr \
yu4xyS} yu4bgT\042 yu4zSv yu4xxSz yu4yxT% yu4yyT$ yu4yT# yu4mT& yu4yeSt yu4qS| \
yu4srSy yu4xtS~ yu6$f yu6s$e yu7%f yu7s%e \
yuan2xnT' yuan2tbT) yuan1ssT( yuan2T* yuan2fkT0 yuan2fkyT2 \
yuan2ctT- yuan2ssT4 yuan2ktT1 yuan2tsT. yuan2ttT, yuan2tT+ yuan2qT3 yuan2cT/ yuan2jsT5 \
yuan3zT6 yuan4eT: yuan4ctT7 yuan4xxyT9 yuan4xxT8 yue1T; yue1jsT< \
yue4TB yue4yTA yue4sxTC yue4mkTD yue4zT= yue4zyT> yue4xsT@ yun1rtTN \
yun2btTH yun2TF yun2yeTG yun2lTE yun3xeTJ yun3eTI yun4zTK \
yun4ynTM yun4yTO yun4xzTP yun4ctTL\001");

strcat(PinYinDic,
"za1TQ za2xmTS za2sTR za3kU& za6$6 za7%6 \
zai1hTU zai1TT zai1bgTV zai3bgTW zai3TX zai3staL \
zai4tTZ zai4TY zan2kT[ zan3tsT\\ zan4xrT] zan4xbT^ zang1bT_ zang1yT` \
zang4ctTa zao1zTb zao1mTc zao2ytTd zao3ctTe zao3rtTg zao3Tf zao3xcTi zao3ssTh \
zao4htTn zao4hTo zao4btTm zao4zzTl zao4zTj zao4kTk ze2ldTr ze2tsTq ze2ssTs \
ze2xbTp ze4ctXF ze6$< ze7%< zei2bTt zen3xxTu zeng1tTv zeng1bTy zeng1xrTx zeng4sxTw \
zha1kT{ zha1ssT| zha1tsTz zha2mT} zha2cT~ zha2mkU\042 zha2jU! zha3mU# \
zha4yU) zha4hU( zha4muU$ zha4mU% zha4phU' zhai1tsU* zhai2wtU+ zhai2bgU, zhai3xbU- \
zhai4drU. zhai4bgU/ zhan1ssU4 zhan1maU1 zhan1miU3 zhan1mU0 zhan1U2 zhan3stU9 \
zhan3cU6 zhan3czU7 zhan3stzU8 zhan3mdU5 zhan4gU= zhan4lU> zhan4U< zhan4ssU? \
zhan4ctU: zhan4jsU@ zhan4mU; zhang1gUE zhang1ltUB zhang1ssUD zhang1mUA \
zhang1zUC zhang3xsUF \
zhang33$ zhang4ssUG zhang4UI zhnag4drUL zhang4mUH zhang4jUJ zhang4bUK \
zhang4eUO zhang4btUN zhang4yUM zhao1tsUP zhao1rUQ zhao1yy3/ zhao1dtUY zhao2WE \
zhao3tsUR zhao3W& zhao3ssUS zhao4UW zhao4xpUX zhao4zUT zhao4sdUU zhao4stUV \
zhe1zzUZ zhe1WE zhe2tsU[ zhe2xkU\\ zhe2xcU] zhe2cU^ zhe3U_ zhe3yq^ zhe3jU` \
zhe4zzUb zhe4ctUa zhe4ssUc zhen1wUd zhen1hUj zhen1Uf zhen1drUl zhen1jUk \
zhen1ydUe zhen1ywUg zhen1sUh zhen1zUi zhen3yUo zhen3btUn zhen3mUm zhen4tsUq zhen4jUr zhen4ytUp zhen4eUs zhen4tp[Z zheng1qUx \
zheng1Uy zheng1srUw zheng1sxUz zheng1tsUu zheng1mUv zheng1ctUt zheng1sa? \
zheng1jo# zheng3xzU{ zheng3tsU| zheng4U} zheng4fwU~ zheng4yV$ zheng4btV\042 \
zheng4yeV# zheng4jV! zhi1V. zhi1stV' zhi1ktV; zhi1kV( zhi1mV& zhi1yzV+ \
zhi1jsV/ zhi1sV* zhi1ssV- zhi1ctV% zhi1cV) zhi1yV, zhi2V1 zhi2drrV5 zhi2drV6 zhi2mV2 ");

strcat(PinYinDic,
"zhi2tsV4 zhi2eV0 zhi2dV3 zhi3V9 zhi3tV7 zhi3zV: zhi3jsV= zhi3xrV< zhi3tsV8 \
zhi4xtVA zhi4fwVB zhi4xbVO zhi4hVH zhi4heVI zhi4xxV> zhi4btpk zhi4jVD zhi4VJ \
zhi4xrVG zhi4ldVF zhi4ssVN zhi4sstVM zhi4tsV@ zhi4xzVC zhi4xsV? zhi4xhVK zhi4sVE zhi4bVL \
zhong1VP zhong1dVT zhong1xxVR zhong1mdVQ zhong1jVS zhong1jsVU \
zhong3yVW zhong4rtVZ zhong4VX zhong4hVV zhong4drVY zhou1V] zhou1pV[ zhou1tkV\\ \
zhou1ssV^ zhou1yV_ zhou1gV` zhou2cVa zhou2nf( zhou3yVb zhou3xjVc \
zhou4yVe zhou4bgVf zhou4xjVd zhou4xdVg zhou4mVh zhu1Vl zhu1yhVo zhu1yVn zhu1wVi zhu1mVj \
zhu1cVk zhu1qVm zhu2Vq zhu2zztsC zhu2zVp zhu2hVr zhu3Vw zhu3xsVs zhu3tsVt zhu3kVv \
zhu3mVu zhu4drW! zhu4ssW\042 zhu4maW$ zhu4mVy zhu4cV{ zhu4bV| \
zhu4ctVx zhu4qVz zhu4sW# zhu4ztV~ zhu4jV} zhu4drzXy zhua1tsW% zhua3W& zhuai4tsW' \
zhuan1W( zhuan1sW) zhuan3cW* zhuan4tsW+ zhuan4bW, zhuan4ztW- zhuang1W/ \
zhuang1ynW1 zhuang1mW. zhuang1xyW0 zhuang4ysW3 zhuang4yqW4 zhuang4tsW2 \
zhuang4j41 zhui1mW5 zhui1zzW7 zhui4xbW8 zhui1jW6 zhui4xtW9 zhui4jsW: zhun1yW; zhun3lsW< \
zhuo1xsW? zhuo1xmW@ zhuo1tscW> zhuo1tsW= zhuo2kWD zhuo2wWA zhuo2hWF zhuo2yWC \
zhuo2ctWB zhuo2ssWG zhuo2jom zi1xkWI zi1xnWK zi1xbWJ zi1WH zi1ssWL zi1ssbWM zi1zWN zi3ssWR \
zi3WS zi3xxWO zi3drWP zi3mWQ zi4WT zi4bgWV zi4ssWU zi4xxm' zi6$8 zi7%8 \
zo6$> zo7%> zong1xzWW zong1bgWZ \
zong1jsW[ zong1mWX zong1zWY zong3xxW\\ zong4jsW] zou1yeW^ zou3W_ zou4xtW` \
zou4tsWa zu1hWb zu2ktWc zu2xsWd zu2fWe zu3eWh zu3jsWi zu3sWf zu3yWg zu6$: zu7%: \
zuan1jWj zuan3ztWk zuan4ts_, zui3kWl zui4yWm zui4stWo zui4rtWn zun1xcWp \
zun1zWq zuo1drWw zuo1k`\\ zuo2rWr zuo3Ws zuo3drWt \
zuo4gtWy zuo4drWw zuo4drgWv zuo4mWu zuo4xtWx zuo4ytTd \0"); 

 l = 0;
 i = 1;
 py_str[0] = 0;

while(PinYinDic[l]!='\0') 
	{
		if (PinYinDic[l]==1) {
			PinYinDic[l] = 32;
			py_str[i] = l;
			++i;
			}
		l++;
  	}

  py_str[26] = l+1;

}


/* more global variables defined here */

FILE *infile, *outfile;
long int filelength, orig_cizu, cizu_begin[27];

int  Short = 0;      /* Output PinYin in long form                   -s  */
int  Quiet = 0;      /* Output PinYin in long form                   -q  */
int  Rearrange = 1; /* Rearrange PinYin array after picking  use -n ! it */
int   Editor = 0;    /* Line editor                                  -e  */

int fan2ti3 = 0; /* by default, jian3ti3 */
int symbol_skip = 8; /* by default, cclib.16 same 8 blank symbol
			sections to be skipped , 5/4/1990*/

char pinyin[81];
int pinyin_loc=0;
char str1[81];
char five_ch[30];
int five_lens = 0;
long int start_ptr;
int out_file=1;
int out_ok=1;
int finish_up = 0;

short int ASCII[256][8];


CCDOS2PinYin(PinYinDic) /* translates GB format file to PinYin */
char *PinYinDic;
{
unsigned char inbuffer[1024];
long int i, j, k, quwei;
int ch_byte1, ch_pair, tmpint, l, n, any_ch, lens;
int separate=0;
int shell_mode;
int chmode=0;
		/* modes:
               0 -- ASCII
               1 -- Chinese
               2 -- Pure Chinese
               3 -- Greek
               4 -- Russian
               5 -- Japanese Pin1 Jia3 Min2
               6 -- Japanese Pian4 Jia3 Min2
               7 -- Symbol 1
	       8 -- Symbol 2
	       9 -- CCDOS ASCII
            */

twobytes[2] = ' ';
ch_pair = 1;

	infile = fopen(infile_name, "r");
	outfile = stdout;

	if(!out_file)
		{
		 outfile = fopen(outfile_name, "w");
		 out_ok = 0;
		}
	else
	{
#if VMS
        if (piping) outfile=fopen(outfile_name, "w");
	 out_ok=1;
#endif
	}

	fprintf(stderr, "\n >>> Translating %s into PinYin file ...", infile_name);
	
	if(!Short) fputs("\\Quiet\n", outfile);

        ch_pair = 1;

  while( fgets(inbuffer, 1024, infile) != NULL)
    { /* get the file line by line */
        i =  0;
	lens = strlen(inbuffer);

      while(i<lens)  /* Translate the file */
       {
      
           while (inbuffer[i] == 10)  {   fputc('\n', outfile); i++;
 					ch_pair = 1;
				if (i>=lens) goto next_next;
				}

                               
             if (inbuffer[i]>160)
 	     { ch_pair *= -1;

              if (ch_pair < 0) 
                 {twobytes[0] = inbuffer[i]-128;
                  i++;
                  goto next_while;
                 }
               else
                { twobytes[1] = inbuffer[i] - 128;
                 i++;
		 }

		if (!Short) 
   		{ /* if not Short form */
		 if (twobytes[0] == 33)
		  { if (chmode != 7)
			{shell_mode=chmode;
				chmode = 7; fputs("\\Sb1 ", outfile);}
			fputc(twobytes[1], outfile);
 		  }
		 else if (twobytes[0] == 34)
		  { if (chmode != 8)
			{shell_mode=chmode;
				chmode = 8; fputs("\\Sb2 ", outfile);}
			fputc(twobytes[1], outfile);
		  }
		 else if (twobytes[0] == 35)
		  { if (chmode != 9)
			{shell_mode=chmode;
				chmode = 9; fputs("\\aS ", outfile);}
			fputc(twobytes[1], outfile);
		  }
		 else if (twobytes[0] == 36)
		  { if (chmode != 5)
			{shell_mode=chmode;
				chmode = 5; fputs("\\jp ", outfile);}
			fputc(twobytes[1], outfile);
		  }
		 else if (twobytes[0] == 37)
		  { if (chmode != 6)
			{shell_mode=chmode;
				chmode = 6; fputs("\\Jp ", outfile);}
			fputc(twobytes[1], outfile);
		  }
		 else if (twobytes[0] == 38)
		  { if (chmode != 3)
			{chmode = 3; fputs("\\Gk ", outfile);}
			fputc(twobytes[1], outfile);
		  }
		 else if (twobytes[0] == 39)
		  { if (chmode != 4)
			{shell_mode=chmode;
				chmode = 4; fputs("\\Rs ", outfile);}
			fputc(twobytes[1], outfile);
		  }
		 else if (twobytes[0] < 48) /* Japanese and Russian not yet */
		  { if (chmode != 1)
			{chmode = 1; fputs("\\Zw ", outfile);}
                   fprintf(outfile, " GB%2x%2x", twobytes[0], twobytes[1]+128);
		  }
		else
		  { if (chmode != 1)
			{chmode = 1; fputs("\\Zw", outfile);}
                   if (match_GB(PinYinDic)){separate = 1;
                     pinyin[0] -= 32;
          	     fputc(' ', outfile);
                     fputs(pinyin, outfile);
                     }
                  else {fprintf(outfile, 
			" GB%2x%2x", twobytes[0], twobytes[1]+128);
                       }
		  }
                 }/* end of !Short */
		else{
		 if (twobytes[0] == 33 && twobytes[1] == 35)
		  {fputc('.', outfile);
 		  }
		 else if (twobytes[0] == 35)
		  {
			fputc(twobytes[1], outfile);
		  }
		 else if (twobytes[0] < 48)
                    fprintf(outfile," GB%2x%2x", twobytes[0], twobytes[1]+128);
		else
		  {
                   if (match_GB(PinYinDic)){separate = 1;

          	     fputc(' ', outfile);
                     fputs(pinyin, outfile);
                     }
                  else {fprintf(outfile, " GB%2x%2x", twobytes[0], twobytes[1]+128);
                       }
		   }
                 }/* end of Short */

            } /* end  if (inbuffer[i] > 160)*/
            else { /* Now < 160 */
		if(chmode > 3)
		 {chmode = shell_mode;
		  switch(shell_mode)
		  {case 0: fputs("\\As ", outfile); break;
		   case 1: fputs("\\Zw ", outfile); break;
		   case 2: fputs("\\CZw ", outfile); break;
		   case 3: fputs("\\Gk ", outfile); break;
		   case 4: fputs("\\Rs ", outfile); break;
		   case 5: fputs("\\jp ", outfile); break;
		   case 6: fputs("\\Jp ", outfile); break;
		   default: chmode = 1;  fputs("\\Zw ", outfile); break;
			}
		 }		
              switch(inbuffer[i]){
  		  case 0: goto next_next;
                  case 9:  
                  case 12: 
                  case 13:
                  case '~':
                  case '@':
                  case '$':
                  case '%':
                  case '^':
                  case '&':
                  case '*':
                  case '(':
                  case ')':
                  case '+':
                  case '{':
                  case '}':
                  case '[':
                  case ']':
                  case '|':
                  case '\"':
                  case '\'':
                  case '\\':
                  case '<':
                  case '>':
                  case '`':
                  case '!':
                  case ':':
                  case ';':
                  case ',':
                  case '.':
                  case '?':
                  case '/': /* all these symbols and punctuations prints out
                            */
                             fputc(inbuffer[i++], outfile);
                             goto next_while;
                  case ' ': /* blank space in Chinese mode is #*/
                             i++;
                             if (chmode) fputc('#', outfile);
                             else fputc(' ', outfile);
                            goto next_while;
                  case '#':  /* # in Chinese mode is \# */
                  case '-': /* - in Chinese mode is \- */
                  case '=': /* = in Chinese mode is \= */
                             if (chmode) fputc('\\',outfile);
                             fputc(inbuffer[i++], outfile);
                            goto next_while;   

                   default:
                     if (!Short)
                      { 
                       if (chmode)
                        {chmode = 0; fputs("\\As", outfile);
		         }

                      }
		      if (separate) {fputc(' ', outfile); separate = 0;}
/*
		if (inbuffer[i]>127) inbuffer[i] -= 128;
*/
                fputc(inbuffer[i], outfile);
                                i++;
                   }

             }        /* end < 160 */

        next_while:;
       }
       next_next:;
     }
fclose(outfile);

}




main(argc, argv)
int argc;
char *argv[];
{

int in_file;
int i,j, name_count=0;
char string[60];
char ch, quit;
char PinYinDic[50000]; /* PinYin dictionary */


/* the following variables are used for the option flags */
int C2p = 0,       /* CCDOS Chinese to PinYin                      -p  */
    P2c=1,         /* PinYin file to Chinese                       -c  */
    As2CC=0,	   /* Change pure ASCII to CCDOS ASCII		   -a  */
    Viewing = 0;   /* View Chinese file                            -v  */

#if MSDOS & TURBO
unsigned char huge *cclib_array;
cclib_array = (unsigned char *) farmalloc(MAX_libsize);
#else
unsigned char cclib_array[MAX_libsize];
#endif
    

in_file = out_file = 1;

/*genarate ASCII table*/
	for(i=0; i<256; i++)
		for(j=7; j>=0; j--)
			ASCII[i][j]=(i>>(7-j)) & 01 ;


/* decode the command line*/

for (i = 1; i<argc; i++)
 if (argv[i][0] == '-')
  { for (j=1; j<strlen(argv[i]); j++)
     switch(argv[i][j])
      {
       case 'p':  /* Chinese GB to PinYin */
       case 'P': C2p = 1; P2c = 0; break;
       case 'q': /* do not show message */
       case 'Q': Quiet = 1;  break;
       case '*': quiet_pick = 1;  break; 
       case 'e': /* line editor mode */
       case 'E': Editor = 1; P2c = 0; break;
       case 's': /* short form PinYin */
       case 'S': Short = 1; break;
       case 'f': /* fanti */
       case 'F': fan2ti3 = 1;
	 symbol_skip = 0; break;
       case 'd':  /* dictionary */
       case 't': 
       case 'T':load_cclib(cclib_array);
       		make_PinYin(PinYinDic);
       		dictionary(PinYinDic, cclib_array);
		goto quit;
       case 'V': /* view Chinese text */
       case 'v': Viewing = 1; P2c = 0; break;
       case 'h': /* get help */
       case 'H': help(); exit(-1); break;
       case 'n': /* do not rearrange PinYin Dic */
       case 'N': Rearrange = 0; break;
       case 'a': /* Ascii to GB */
       case 'A': As2CC = 1; P2c = 0; break;
       case '2': make_PinYin(PinYinDic); util2(PinYinDic);
   fputs("\n ** Written PinYin table file pinyin.doc .\n", stderr);
       		goto quit;  /* make a PinYin table */
       case '3': make_PinYin(PinYinDic); util3(PinYinDic);
   fputs("\n ** Written duplicated pinyin file pinyin.dup .\n", stderr);
       		goto quit;
       default: fprintf(stderr, "Invalid flag = %c\n", argv[i][j]);
      }
   

  }
 else
  { 

   switch (name_count++)
   {
    case 0: in_file=0; 
             strcpy(infile_name,argv[i]);
             break;
    case 1: if (argv[i][0]!='>')
             {
            out_file=0; 
            strcpy(outfile_name,argv[i]); 
             }
            else piping = 1;
            break;
    case 2: if (piping)
             {
            out_file=0; 
            strcpy(outfile_name,argv[i]); 
             break;
             }

    default: fprintf(stderr, "Extra argument = %s\n", argv[i]);
   }

  }


if (Editor) 
 {
  if (in_file)
   {
   fputs(" File name (file to be created) >", stderr);
   scanf("%s",outfile_name);
   fflush(stdin);

   }
  else strcpy(outfile_name, infile_name);
   load_cclib(cclib_array);
   make_PinYin(PinYinDic);
   line_editor(PinYinDic, cclib_array);

   CLS;
   fprintf(stderr, "** Written Chinese text file %s.\n", outfile_name);
      fputs("View the created file ? [Y]", stderr);
        while((ch=fgetc(stdin))=='\n');
        if ((ch=='n')||(ch=='N'))   goto quit;

      viewer(cclib_array);
      goto quit;
 }

 if (in_file) 
   {
   fputs(" Input file (file to be viewed/translated) >", stderr);
   scanf("%s",infile_name);
   fflush(stdin);
   }


if (C2p)  /*translate Chinese file into PinYin */
  {

  make_PinYin(PinYinDic);
  CCDOS2PinYin(PinYinDic);
   if (!out_ok)
   fprintf(stderr, "** Written PinYin file %s .\n", outfile_name);
  goto quit;

  }

if (As2CC)  /*translate ASCII to Chinese ASCII */
  {

  As2aS();
  goto quit;

  }


if (Viewing) /* Viewing a Chinese text file */
  {

      viewer(cclib_array);
      goto quit;
  }

while (out_ok)
 {
  if (out_file) 
    {
    fputs(" Output file name >", stderr);
    fscanf(stdin, "%s",outfile_name);
    fflush(stdin);
    }


    out_ok=0; 
/*
   if ((outfile=fopen(outfile_name,"r"))!=NULL)
     { out_ok=1;
            out_file=1;
      fflush(stdin);
      fprintf(stderr," File <%s> already exists, overwrite ? [N]", outfile_name);

        while((ch=fgetc(stdin))=='\n');
        if ((ch=='y')||(ch=='Y')) out_ok=0;
        fclose(outfile);

     }
*/

 }




if (P2c)  /*translate PinYin manuscript into Chinese file*/
  {
  load_cclib(cclib_array);
  make_PinYin(PinYinDic);
  dePinYin(PinYinDic, cclib_array);
   CLS;
   fprintf(stderr, "** Written Chinese text file %s.\n", outfile_name);

      fputs("View the created file ? [Y]", stderr);
        while((ch=fgetc(stdin))=='\n');
        if ((ch=='n')||(ch=='N'))   goto quit;
     strcpy(infile_name, outfile_name);
     viewer(cclib_array);
     goto quit;


  }


quit:;
fprintf(stderr, "\n");
/*
fputs( "\n\t>>> Thank you for using ChText >>>\n", stderr);
fputs( "\t>>> by Jingbai Wang, August 1989 >>>\n", stderr);
*/

}


util2(PinYinDic) /* Make a pinyin table */
char *PinYinDic;
{
char pinyin1[16], pinyin2[16];
long int i, j;
unsigned char chr;

outfile = fopen("pinyin.doc", "w");
i=0;
j=0;
while ( PinYinDic[i++] != NULL)
 {
   pinyin2[j++] = PinYinDic[i];
  if (PinYinDic[i] == 32)
   { 
     
     fputc(pinyin2[j-3]+128,outfile); fputc(pinyin2[j-2]+128, outfile);
     pinyin2[j-3] = 0;
     fputc(32, outfile);
     fputs(pinyin2, outfile);
     if (strcmp(pinyin2, pinyin1) == 0)
         fputs(" <same>\n", outfile);
     else fputc('\n', outfile);
     strcpy(pinyin1, pinyin2);
     j=0;
   }

 }

fclose (outfile);
}


util3(PinYinDic)  /* check if there are duplicated PinYin in the dictionary */
char *PinYinDic;
{
char pinyin1[16], pinyin2[16];
long int i, j;
int num, lens, k, cz;
unsigned char chr;

outfile = fopen("pinyin.dup", "w");
i=0;
j=0;
while ( PinYinDic[i++] != NULL)
 {
   pinyin2[j++] = PinYinDic[i];
  if (PinYinDic[i] == 32)
   { cz = 0;
     pinyin2[j-3] = 0;
     strcpy(&pinyin[1], pinyin2);
     pinyin[0] = 32;
     lens = strlen(pinyin);
     num = match_pinyin(PinYinDic);
     for(k=0; k<num; k++)
     	{
		if (lens == all[k].lens) cz ++;
	}
	if (cz > 1) fprintf(outfile, "%s = %d\n", pinyin, cz-1);

     j = 0;

   }

 }

fclose (outfile);
}



match_GB(PinYinDic)  /* Knowing two-byte Chinese character, find PinYin match
               the 3rd byte of twobytes[] is always #32*/
char *PinYinDic;
{

char *ptr, *startptr, *endptr;
long l, PYsize;
int i, k, j;

ptr = PinYinDic;
startptr=ptr;
PYsize = py_str[26];

while ((ptr=(char *)memchr(ptr, twobytes[0], PYsize))!=NULL)
    {
    if( memcmp(ptr, twobytes, 3)==0)
      { j=0;
        l = ptr-startptr;
        while (PinYinDic[l--]!=32) j++;
        l++;
          for (k=1; k<j; k++)
            pinyin[k-1]=PinYinDic[l+k];

           if (!Short) 
             {
             pinyin[j-1] = 0;
             return(1);
             }
           else
           { for(i=0; i<j; i++)
              if ((pinyin[i]=='0')||(pinyin[i]=='1')||(pinyin[i]=='2')||
                  (pinyin[i]=='3')||(pinyin[i]=='4'))
               {pinyin[i+1] = '\0';return(1);}
           }
           return(1);

      }
    ptr++; 
    }

return(0);

}



rearrange_pinyin(PinYinDic) /* re-arrange the PinYinDic to put
			       just picked at the first of homoymes*/
char *PinYinDic;
{

char *ptr, *startptr, *endptr;
long l;
int i, k, j, Yes;

Yes = 0;
i = strlen(pinyin)-1;

               if ((pinyin[i]=='5')||(pinyin[i]=='1')||(pinyin[i]=='2')||
                  (pinyin[i]=='3')||(pinyin[i]=='4')||(pinyin[i]=='0'))
               Yes = 1;

	if(!Yes) return(-1);

ptr = &PinYinDic[py_str[pinyin[1]-97]];

startptr=ptr + start_ptr;
k = 0;

	for (j=0; j<all[the_chosen].lens+2; j++)
		 *(startptr + k++) = all[the_chosen].str[j];
	for (i=0; i< total_num; i++)
		if (i!=(the_chosen))
			for (j=0; j<all[i].lens+2; j++)
		 	*(startptr + k++) = all[i].str[j];

}



match_pinyin(PinYinDic) /* Knowing PinYin, find the GB match
                  The first byte of the string pinyin[] is always 32 */
char *PinYinDic;
{

char *ptr, *startptr, *endptr;
long l, PYsize;
int num=0;
int i, k, j, lens;
total_num = 0;

if (pinyin[1] < 97 || pinyin[1] > 122) return(0);
if (pinyin[1]=='v') return(0);

ptr = &PinYinDic[py_str[pinyin[1]-97]];
startptr=ptr;
endptr = &PinYinDic[py_str[pinyin[1]-96]];

PYsize = endptr - startptr;

lens = strlen(pinyin);

while ((ptr=(char *)memchr(ptr, pinyin[0], PYsize))!=NULL)
    {  if (ptr>endptr) goto end;
    if( memcmp(ptr, pinyin, lens)==0)
      { j=0;
	l = ptr-startptr ;
        if (!num) start_ptr = l; 
	++l;
        while ( *(startptr+l)!=32) {++j; ++l;}
            j++;
            all[num].lens = j-2;
          for (k=j; k>=0; k--)
            all[num].str[j-k] = *(startptr + l-k);
            all[num].str[j] = 0;
	    ++num;
      }
    ptr++; 
    }
end:
total_num = num;
return(num);

}



match_cizu(cizu, CiDian) /* Knowing cizu PinYin, find the two-byte GB match */
struct CiZu *cizu;
unsigned char *CiDian;
{

unsigned char *ptr, *startptr, *endptr;
char all_str[20];
long l;
int i, k, j, lens, n, a_lens, str_lens;
int num=0;

ptr = CiDian;
startptr = CiDian;
endptr = CiDian + filelength;

lens = strlen(&cizu->str[1]);

while ((ptr=(unsigned char *)memchr(ptr, cizu->str[1], filelength))!=NULL)
    {  if (ptr>endptr) goto end;
    if( memcmp(ptr, &cizu->str[1], lens)==0)
      {
	n=0;
        l = ptr-startptr ;
        while (*(startptr+l)!=32) { ++l; if (*(startptr+l)=='-') n++;}
	n ++;
	l ++;
	j=0;
        while (*(startptr+l+j) != 10) {all_str[j] = *(startptr+l+j); ++j;}

	     str_lens = j;
	    a_lens = cizu->zishu*2;
	j = 0;
	while (j<a_lens) {all[num].str[j]
				= all_str[str_lens-2*n+j];
			 ++j;}
            all[num].str[a_lens] = 0;

        if(num) if (strncmp(all[num-1].str, all[num].str, a_lens)==0);
		else num++;
	 else num=1;

      }
    ptr++; 
    }
end:
return(num);

}


dictionary(PinYinDic, cclib_array)  /* given PinYin display characters */
char *PinYinDic;
unsigned char *cclib_array;
{
int num, i;
char string[17];

     fputs("\033[2J", stderr);

while (1)
 {

fputs(" \033[4;1f\033[K\033[4;1fPinYin >", stderr);
 fgets(string, 17, stdin);


pinyin[0] = 32;
 strcpy(&pinyin[1], string);
pinyin[strlen(pinyin)-1] = 0;

show_choice(match_pinyin(PinYinDic), 0, cclib_array);

 }
}



viewer(cclib_array)
unsigned char *cclib_array;
{
char row[16][NUM_Char], tmpchar;
long int  max_quwei, i, j, k, quwei, new_line=1;
int ch_byte1, ch_pair,  l, n, any_ch;
#if MSDOS|PCDOS
unsigned char huge *AllBuffer;
AllBuffer = (unsigned char *) farmalloc(MAX_filesize);
#else
unsigned char AllBuffer[MAX_filesize];
#endif

ch_pair = 1;


	load_AllBuffer(AllBuffer);

  if (!cclib_load) load_cclib(cclib_array);

#if VMS
        if (piping) stdout=fopen(outfile_name, "w");
#endif

CLS;

   /* Process it by marking the end of lines*/
   i=0; 
  max_quwei = 0;

   while(i<filelength) /* get rid of the WordStar shift codes 
                          and figure out the highest QuWei code used*/

    {  switch((unsigned char) AllBuffer[i])
       {
        case 10:
        case 13: ch_pair = 1; break;
          default: 
              if (AllBuffer[i]>127) 
               { if (AllBuffer[i]<161)
                 {
                  AllBuffer[i] -= 128;
                  break;
                 }
                ch_pair *= -1;
                if (ch_pair < 0) ch_byte1 = AllBuffer[i];
                else {
          
                       if (ch_byte1>175) ch_byte1 -= symbol_skip;
                   quwei = (ch_byte1 - 161)*94 + AllBuffer[i] - 161;
                       if (quwei>max_quwei) max_quwei = quwei;

                     }
                }
       }
     i++;
    }  



  /* view file, use row[][16] to store whole line in bitmap*/

        new_line=ch_pair = 1;
        i = j = k = any_ch = 0;
      while(i<filelength)  /* Print a file in lines */
       {
      
         
    /* If no Chinese in a line, simply print the text */

           if (AllBuffer[i]==10) {new_line = 1; k = i+1; i++;}

            if (new_line)
            {   any_ch  = 0;
                ch_pair = 1;  
                new_line = 0;

               if (j>0)
                 {
                  for (n=0; n<16; n++)
                for (n=0; n<16; n++)
                   {row[n][j] = '\n';
			write(outhandle, row[n], j+1);
		   }
			write(outhandle, "\n", 1);
     
                     j=0;   
                  }

                while ((AllBuffer[k] !='\n')&&(AllBuffer[k] !='\0'))
                  if (AllBuffer[k++] > 160) any_ch = 1;

               if (!any_ch) 
                {
			/*
			tmpchar = AllBuffer[k];
                  AllBuffer[k] = '\0';
                  fputs(&AllBuffer[i], stdout); fputc('\n', stdout);
                  AllBuffer[k] = tmpchar;
		  */
			write(outhandle, &AllBuffer[i], k-i+1);		  
                  i = k;
                  goto next_while;
                }

              }

           if ((AllBuffer[i]>160)&&(AllBuffer[i]<255))
            { ch_pair *= -1;
              if (ch_pair < 0) 
                 {ch_byte1 = AllBuffer[i];
      if (ch_byte1>175) ch_byte1 -= symbol_skip; 
		  /* 168 ~ 175 is repeating 176 ~ 183 */
                  i++;
                  goto next_while;
                 }
               else
                {
               quwei = ((ch_byte1-161)*94 + AllBuffer[i]-161)*32;
 
                   for (l=0; l<16; l++ )
                   {
                     for (n=0; n<8; n++)
                      {     
                      row[l][j+n] = ASCII[cclib_array[(long)(quwei+2*l)]][n]
		      	*5 + 32;
                      row[l][j+8+n]=ASCII[cclib_array[(long)(quwei+2*l+1)]][n]
		      	*5 + 32;
                      }
                   }                   
                  j +=16;
                  i ++;
                }  

            } /* end  if (AllBuffer[i] > 160)*/
            else  /* Now < 160 */
             {   if (AllBuffer[i] == 9) AllBuffer[i] = ' ';
                 for (n=0; n<16; n++)
                   row[n][j] = ' ';
                 row[10][j] = AllBuffer[i]; 
                j++;
                i++;
             }        /* end < 160 */

           if ( j > 64)
             {

                for (n=0; n<16; n++)
                   {row[n][j] = '\n';
			write(outhandle, row[n], j+1);
		    }
			write(outhandle, "\n", 1);
                j  = 0;

              }

        next_while:;

       }

               if (j>0)
                 {
                for (n=0; n<16; n++)
                   {row[n][j] = '\n';
			write(outhandle, row[n], j+1);
		    }

                  }



}



get_choice(num, lens1, cclib_array)
     /* found all homoyme for a PinYin pick a choice */
int num;
int lens1;
unsigned char *cclib_array;
{
char row[16][81], tmpchar, whole[1600];
long int k=0, quwei, byte1;
int the_num = 0, i, l, lens, j, n, tmpint, fives, pick,  lens2;

      fives=j=k=0;
      tmpint = 17;


/* if there is only one choice, see if it needs to be confirmed */

if ((quiet_pick)&&(num==1)) return(fives);

if (lens1)
 {
   for (i=0; i<num; i++)
    if (lens1 == all[i].lens) return(i);
   return(-1);
 }
else for (i=0; i<num; i++)
    {
backup:      lens = all[i].lens;


        byte1 = all[i].str[lens]-33; 
        if (byte1>14) byte1 -= symbol_skip;
      quwei = (byte1*94 + all[i].str[lens+1]-33)*32;
 
                   for (l=0; l<16; l++ )
                   {
                     for (n=0; n<8; n++)
                      {   
                  row[l][j+n] = ASCII[cclib_array[(long)(quwei+2*l)]][n]*tmpint + 32;
                  row[l][j+8+n]=ASCII[cclib_array[(long)(quwei+2*l+1)]][n]*tmpint + 32;
                      }
                   }                   
                  j +=16;
                  tmpint ++; 
          if ((((i+1)%5)==0)||(i==num-1))
          { 
		row[0][j] = '\0';
		lens2 = strlen(row[0]);

                   strcpy(whole, "\033[8;1f");
                  for (n=0; n<16; n++)
                    {
                    row[n][j] = '\0';
                    strcat(whole, row[n]);
		    if (lens2<80)
                    	strcat(whole, "\033[K\n");
			else strcat(whole, "\n");
                    }
strcat(whole, "\033[7m<CR>12345:pick SPC:more <:last ESC:new ^H\
:back I:insert A:str G:giveup @:fin");

re_display:   
		write(errhandle, whole, strlen(whole)); NORMAL;
		fflush(stderr);
               pick = 5 + fives;
               if (pick >= num)
                  fputs("\033[7;38f\033[K\033[7;38f(No more) ==>", stderr);
               else
                   fprintf(stderr, "\033[%d;%df\033[K\033[%d;%df(%d more) ==>",
                 7, 38, 7, 38, num-pick);

             j=0;
             tmpint = 17;
		fflush(stdout);
check_again:    switch( pick=getch())
                 {
                  case 49: /* pick from 1-5 */
                  case 50:
                  case 51:
                  case 52:
                  case 53: 
                           pick = pick - 49 + fives;
                           if (pick>num) {BELL; goto check_again;}
                           else { 
                                return(pick);

                                 }
                           break;                   
                  case 32: break; /* next 5 */
                  case 13: /* return the first one */
#if USG 
                  case 10: 
#endif
                              return(fives);
                  case 8: return(-1); /* return without pickin */
		  case 'i':
		  case 'I': return(-4); /* insert a PinYin */
		  case 27: return(-2); /* new pinyin */
#if !USG
		  case 10: goto check_again;
#endif
                  case 'a':
                  case 'A': return(-3); /* print the string as it is */
                  case 'g':
                  case 'G': return(-5); /* give up this PinYin */
		  case 's':
		  case 'S': show_last_five(cclib_array); goto re_display;
		  case '@': return(-10); /* finish up */ break;
		  case '!': /* get_shell */ 
		  	get_shell();
			goto re_display;
			break;
                  case 3:
                  case 4: exit(-1);
                  case '<': /* previous 5 */
                  case ',': if (fives>0) {  fives -= 5; i=fives; goto backup;}
                  default: 
                           BELL; goto check_again;
                 }

       fives += 5; 

          }
    }
 return(-1);

}



show_choice(num, lens1, cclib_array) /* show the choice */
int num;
int lens1;
unsigned char *cclib_array;
{
char row[16][81], tmpchar, whole[1600];
long int k=0, quwei, byte1;
int the_num = 0, i, l, lens, j, n, tmpint, fives, pick, picked, lens2;

      fives=j=k=0;
      tmpint = 17;


 for (i=0; i<num; i++)
    {
backup:      lens = all[i].lens;


        byte1 = all[i].str[lens]-33; 
        if (byte1>14) byte1 -= symbol_skip;
      quwei = (byte1*94 + all[i].str[lens+1]-33)*32;
 
                   for (l=0; l<16; l++ )
                   {
                     for (n=0; n<8; n++)
                      {   
                  row[l][j+n] = ASCII[cclib_array[(long)(quwei+2*l)]][n]*tmpint + 32;
                  row[l][j+8+n]=ASCII[cclib_array[(long)(quwei+2*l+1)]][n]*tmpint + 32;
                      }
                   }                   
                  j +=16;
                  tmpint ++; 


          if ((((i+1)%5)==0)||(i==num-1))
          { 
		row[0][j] = '\0';
		lens2 = strlen(row[0]);

                   strcpy(whole, "\033[8;1f");
                  for (n=0; n<16; n++)
                    {
                    row[n][j] = '\0';
                    strcat(whole, row[n]);
		    if (lens2<80)
                    strcat(whole, "\033[K\n");
			else strcat(whole, "\n");
                    }
strcat(whole, "\033[7m  <SPACE>: more   Press any other keys to continue           \033[0m");

re_display:   
		write(errhandle, whole, strlen(whole));
		fflush(stderr);
               pick = 5 + fives;

                  fputs("\033[6;1f\033[K\033[7;1f\033[K", stderr);

		for (l=0; (l<5)&&(l<num-fives); l++)
		{ the_num = fives+l;
			fputs("\033[7m", stderr);
		fprintf(stderr, "\033[6;%df GB%02x%02x = %c%c ", 3+l*16,
		all[the_num].str[all[the_num].lens]+128,
		all[the_num].str[all[the_num].lens+1]+128,
		all[the_num].str[all[the_num].lens],
		all[the_num].str[all[the_num].lens+1]);
		fprintf(stderr, "\033[7;%df", 3+l*16);
		write(errhandle, all[the_num].str, all[the_num].lens);
		fputs("\033[0m", stderr);
		}
               if (pick >= num)
                  {fputs("\033[24;1f\033[K", stderr); return(1);}
               else
                   fprintf(stderr, "\033[%d;%df\033[K\033[%d;%df(%d more) ==>",
                 4, 38, 4, 38, num-pick);

             j=0;
             tmpint = 17;

check_again:    switch( pick=getch())
                 {

                  case 32: break;
		  case 10: goto check_again;
                  case 3:
                  case 4: exit(-1);
                  case '<':
                  case ',': if (fives>0) {  fives -= 5; i=fives; goto backup;}
                  default: return(1);
                 }

       fives += 5; 

          }
    }
 return(-1);

}



line_editor(PinYinDic, cclib_array)  /* Input line by line */
char *PinYinDic;
unsigned char *cclib_array;
{
int i, lens;
unsigned char inbuffer[1024], ch;
struct CiZu cizu;
#if MSDOS|PCDOS
unsigned char huge *CiDian;
CiDian = (unsigned char *) farmalloc(MAX_CiZuDic);
#else
unsigned char CiDian[MAX_CiZuDic];
#endif

   load_cidian(CiDian);

   if ((outfile=fopen(outfile_name,"r"))!=NULL)
     { fclose(outfile);
  fprintf(stderr,"\n File <%s> already exists, overwrite/append/new (o/a/n)?",
 outfile_name);

        while((ch=fgetc(stdin))=='\n');
	switch(ch)
	{
		case 'a':
		case 'A':     outfile = fopen(outfile_name, "a");break;
		case 'o':
		case 'O':     outfile = fopen(outfile_name, "w");break;
		default: 
		fputs("  New file name>", stderr);
		fscanf(stdin, "%s", outfile_name);
		strcpy(infile_name, outfile_name);
		outfile = fopen(outfile_name, "w");break;
	}

     }
     else outfile = fopen(outfile_name, "w");


     CLS;
     inbuffer[0] = 32;
       cizu.zishu = 1;
       cizu.mode = 0;

while (1){ /* while not \ */
do_again:
   	fputs(" \033[7;1f\033[K\033[7;1fLine > ", stderr);

	fgets(&inbuffer[1], 1024, stdin);
	lens = strlen(inbuffer);
	if (inbuffer[1] == 10) 
		goto do_again;


         inbuffer[lens-1]='\0';


      if (inbuffer[lens-2] =='\\') /* if the last byte is \ it is a linebreak*/
        {inbuffer[lens-2]='\n';
        }

	/* The first byte is a flag byte
	!	finish up and exit
	<Space> ASCII string
	`	Pure Chinese mode
	\	end of file
	/	Chinese ASCII
	.	Japanese PingJiaMing
	,	Japanese PiangJiaMing
	;	Greek
	'	Russian
	1	Symbol 1
	2	Symbol 2
	ascii	Chinese
	*/

 /* modes:
               0 -- ASCII
               1 -- Chinese
               2 -- Pure Chinese
               3 -- Greek
               4 -- Russian
               5 -- Japanese PinJiaMing
               6 --  Japanese PianJiaMing
               7 -- Symbol 1
	       8 -- Symbol 2
	       9 -- CCDOS ASCII
            */

	switch(inbuffer[1])
	{
	case 32: /* This is an ASCII string */
       		cizu.mode = 0;
		line6_window(&inbuffer[2], lens-2);
       		PinYin_Ch(&inbuffer[2], lens-3, PinYinDic, &cizu, cclib_array, CiDian);
		break;
 	case '`': /* Pure Chinese mode */
       		cizu.mode = 2;
		line6_window(&inbuffer[2], lens-2);
       		PinYin_Ch(&inbuffer[2], lens-3, PinYinDic, &cizu, cclib_array, CiDian);
		break;
 	case ';': /* Greek mode */
       		cizu.mode = 3;
		line6_window(&inbuffer[2], lens-2);
       		PinYin_Ch(&inbuffer[2], lens-3, PinYinDic, &cizu, cclib_array, CiDian);
		break;
 	case '\'': /* Russian mode */
       		cizu.mode = 4;
		line6_window(&inbuffer[2], lens-2);
       		PinYin_Ch(&inbuffer[2], lens-3, PinYinDic, &cizu, cclib_array, CiDian);
		break;
 	case '.': /* This is Japanese PingJiaMing mode */
       		cizu.mode = 5;
		line6_window(&inbuffer[2], lens-2);
       		PinYin_Ch(&inbuffer[2], lens-3, PinYinDic, &cizu, cclib_array, CiDian);
		break;
 	case ',': /* This is Japanese PianJiaMing mode */
       		cizu.mode = 6;
		line6_window(&inbuffer[2], lens-2);
       		PinYin_Ch(&inbuffer[2], lens-3, PinYinDic, &cizu, cclib_array, CiDian);
		break;
 	case '1': /* Symbol 1 mode */
       		cizu.mode = 7;
		line6_window(&inbuffer[2], lens-2);
       		PinYin_Ch(&inbuffer[2], lens-3, PinYinDic, &cizu, cclib_array, CiDian);
		break;
 	case '2': /* Symbol 2 mode */
       		cizu.mode = 8;
		line6_window(&inbuffer[2], lens-2);
       		PinYin_Ch(&inbuffer[2], lens-3, PinYinDic, &cizu, cclib_array, CiDian);
		break;
 	case '/': /* Chinese ASCII mode */
       		cizu.mode = 9;
		line6_window(&inbuffer[2], lens-2);
       		PinYin_Ch(&inbuffer[2], lens-3, PinYinDic, &cizu, cclib_array, CiDian);
		break;
	case '!': /* get shell */
		get_shell();
		break;
	case '@':  /*finish up*/
      		fclose(outfile);
		save_cizu(CiDian);
      		return(1);
	case 'v':
	case 'V':  /* rabish */
			break;

	default: /* It is Chinese */
       		if (cizu.mode!=2) cizu.mode = 1;
		line6_window(inbuffer, lens);
       		PinYin_Ch(inbuffer, lens, PinYinDic, &cizu, cclib_array, CiDian);
		if (total_num>0)
		{
		five_ch[five_lens] = 0;	
		display_ch(five_ch, cclib_array);
		fputs("\033[24;1f\033[K", stderr);
		}
	}

    }
 
}



load_cidian(CiDian) /* load Ci2Dian3 into CiDian */
unsigned char *CiDian;
{

char *cidian3;
int cidianhd;
long int k, bytes;

/* Get Ci2Dian3.chi first */
char  cidian[80];

#if unix|MSDOS|PCDOS
	if (!(cidian3 = getenv("CHTEXTDIC")))
	cidian3 = CiDianpath; /* home directory */
#if unix
  sprintf(cidian, "%s/%s", cidian3, "Ci2Dian3.chi");
#else
  sprintf(cidian, "%s\\%s", cidian3, "Ci2Dian3.chi");
#endif

  filelength = 0;

   if ( (cidianhd=open(cidian, O_RDONLY))<0)
      {
	orig_cizu = filelength;
	filelength = 1;
	CiDian[0] = '\n';
	return;
	}
    else { filelength = read(cidianhd, CiDian, MAX_filesize);
	orig_cizu = filelength;
        close(cidianhd);
      }
#else 

#if VMS 
/* it is VMS */
  sprintf(cidian, "%s:%s", "chtextdic", "Ci2Dian3.chi");

   if ( (cidianhd=open(cidian, O_RDONLY))<0)
 	{ 
		sprintf(&cidian[0], "%s%s", CiDianpath, "Ci2Dian3.chi");
		if ( (cidianhd=open(cidian, O_RDONLY))<0)
		{
			orig_cizu = filelength;
			filelength = 1;
			CiDian[0] = '\n';
			return;
		}
	}
	filelength=bytes=0;
	while((bytes=read(cidianhd, &CiDian[filelength], MAX_filesize))>0)
		filelength += bytes;
		orig_cizu = filelength;
		close(cidianhd);
#else
sprintf(cidian, "%s%s", CiDianpath, "Ci2Dian3.chi");
		if ( (cidianhd=open(cidian, O_RDONLY))<0)
		{
			orig_cizu = filelength;
			filelength = 1;
			CiDian[0] = '\n';
			return;
		}

	filelength=bytes=0;
	while((bytes=read(cidianhd, &CiDian[filelength], MAX_filesize))>0)
		filelength += bytes;
		orig_cizu = filelength;
		close(cidianhd);

#endif
#endif




}


save_cizu(CiDian) /* If the cizu array is updated, save it into Ci2Dian2.chi
                and remove duplicated entries */
unsigned char *CiDian;

{
FILE *ci2dian;
long int i=0, k;
char cidian[80], *cidian3;
unsigned char *ptr, *startptr, *endptr, tmpstr[128];
int lens;

	if (orig_cizu >= filelength) return(-1);

#if unix
	if(!(cidian3 = getenv("CHTEXTDIC")))
	cidian3 = CiDianpath;
	sprintf(cidian, "%s/%s", cidian3, "Ci2Dian3.chi");
#else
	sprintf(cidian, "%s%s", CiDianpath, "Ci2Dian3.chi");
#endif

   ci2dian=fopen(cidian, "w");

i=k=0;
startptr = CiDian;
endptr = startptr + filelength;

  while(CiDian[i] !=0)
  { /* get rid of multiple entries */
   while(CiDian[i] != 10)
	tmpstr[k++]= CiDian[i++];
	tmpstr[k++] = 10;
	tmpstr[k] = 0;
	i++;
	lens = k;

   if (k>2)
   { /* if it is not an empty line */
	ptr = startptr + i;
    while ((ptr=(unsigned char *)memchr(ptr, tmpstr[0], filelength-i))!=NULL)
    {  if (ptr>endptr) goto end;
    if( memcmp(ptr, tmpstr, lens)==0)
      { 
	goto end1;
      }
    ptr++; 
    }
   }
end:     fputs(tmpstr, ci2dian);
end1:;
	k=0;


  }

   fclose(ci2dian);
}


 
load_cclib(cclib_array) /* Load cclib.16 into cclib_array */
unsigned char *cclib_array;
{
long int k=0,  bytes;
int tmpchr;
char *cclibfile;
int cclibhandle;
unsigned char *cclibptr;

#if unix

if (fan2ti3)
  {
   	if (!(cclibfile = getenv("CCLIB16ft")))
		 cclibfile = CCLIB16ft;
      }
  else {
   	if (!(cclibfile = getenv("CCLIB16jt")))
		 cclibfile = CCLIB16jt;
      }

   if (( cclibhandle = open(cclibfile, O_RDONLY) ) <0 )
    {fputs("Missing library file", stderr); exit(-1);}
	read(cclibhandle, cclib_array, 256000);
     close(cclibhandle);
     cclib_load = 1;
	return(1);
#else

#if VMS

if (fan2ti3)
   if (( cclibhandle = open("cclib16$ft", O_RDONLY) ) <0 )
     { cclibfile = CCLIB16ft;
  	 if (( cclibhandle = open(cclibfile, O_RDONLY) ) <0 )
		{fputs("Missing library file", stderr); exit(-1);}
		
      }
  else
   if (( cclibhandle = open("cclib16$jt", O_RDONLY) ) <0 )
     { cclibfile = CCLIB16jt;
  	 if (( cclibhandle = open(cclibfile, O_RDONLY) ) <0 )
		{fputs("Missing library file", stderr); exit(-1);}
		
      }
		k=0;
		bytes = 1;
	while(bytes>0)
	{
	bytes = read(cclibhandle, &cclib_array[k], 512);
	k += bytes;
	}
     close(cclibhandle);
     cclib_load = 1;
     return(1);
#else
#if MSDOS|PCDOS
	cclibptr = cclib_array;
				cclibfile = getenv("CCLIB16");
				strcat(cclibfile, "\\cclib.16");
   if (( cclibhandle = open(cclibfile, O_RDONLY|O_BINARY) ) <0 )
		{
				cclibfile = CCLIB16jt;
   if (( cclibhandle = open(cclibfile, O_RDONLY|O_BINARY) ) <0 )
	{fprintf(stderr, "Missing library file"); exit(-1);}}
	k=0;
	bytes = 1;
	while(bytes>0)
	{
	bytes = read(cclibhandle, (cclibptr+k), 4096);
	k += bytes;
	}

     close(cclibhandle);
     cclib_load = 1;
     return(1);		

#else
	cclibfile = CCLIB16jt;
   if (( cclibhandle = open(cclibfile, O_RDONLY|O_BINARY) ) <0 )
		{fputs("Missing library file", stderr); exit(-1);}

		k=0;
		bytes = 1;

     BLINK;
     fputs(" \nLoading dictionary ....", stderr);
	while(bytes>0)
	{
	bytes = read(cclibhandle, &cclib_array[k], 4096);
	k += bytes;
	}
     close(cclibhandle);
     cclib_load = 1;
          NORMAL;    

     return(1);

#endif

#endif

#endif
}


get_pinyin(flag, PinYinDic, cizu, cclib_array, CiDian)
		/* given PinYin find two_byte GB codes */
char flag;
char *PinYinDic;
struct CiZu *cizu;
unsigned char *cclib_array, *CiDian;
{
int chosen, i, lens, insert=0;
char save_pinyin[80];

g_chosen = -1;
do_again:

if (!flag)
{
fputs(" \033[7;1f\033[K\033[7;1fPinYin:", stderr); fputs(pinyin, stderr);
}
                  chosen = get_choice(match_pinyin(PinYinDic), flag, cclib_array);

                  if (chosen>=0) /* if found one print it out */
                     { the_chosen = chosen;
		       fputc(all[chosen].str[all[chosen].lens]+128, outfile);
               	       fputc(all[chosen].str[all[chosen].lens+1]+128, outfile);
		       last_five(all[chosen].str[all[chosen].lens],
		       all[chosen].str[all[chosen].lens+1]);

			g_chosen = chosen;
		       if (chosen>0 && Rearrange)
		       		rearrange_pinyin(PinYinDic);
		       return(chosen);
                    }
                    else if (chosen==-3)  /* print the string */
                       fputs(&cizu->str[1], outfile);
                    else if (chosen==-2)  /* input PinYin from Keyboard */
                     {
new_one:     

			insert_pinyin(0, PinYinDic, cizu, cclib_array, CiDian);
			if (g_chosen>=0) return(g_chosen);

                     }
		     else if (chosen==-4)
		     { /* insert a pinyin*/
			strcpy(save_pinyin, pinyin);
			insert_pinyin(1, PinYinDic, cizu, cclib_array, CiDian);
			strcpy(pinyin, save_pinyin);
		     goto do_again;

		     }
		     else if (chosen==-5)
		     {
			return(0); /* give up */
		     }
		     else if (chosen==-10)
		     { /* finish up */
			fprintf(outfile, "\\Zw %s ", &cizu->str[1]);
			finish_up = 1;
			return(0);
		     }
                     else
                     { /* else back up one character and  check again*/
                      lens = strlen(pinyin);
                        if(--lens>1)
                          {
      fprintf(stderr, " \033[%d;%df\033[K\033[%d;%dfGive up:%s  Try:",
        7, 1, 7, 1, pinyin);
                            pinyin[lens] = 0;
			    fputs(pinyin, stderr);

                    goto do_again;

                           }
                         else goto new_one;

		    }
return(0);
}



int get_GB(flag, PinYinDic, cizu, cclib_array, CiDian) /* given 4-byte GB codes find 2-byte ones */
char flag;
char *PinYinDic;
struct CiZu *cizu;
unsigned char *cclib_array, *CiDian;
{
int byte1, byte2, i, lens;
char pinyin1[80];
twobytes[2] = 0;

do_again:
     if ((pinyin[1]=='g')&&(pinyin[2]=='b'))  /*that's GB code*/ 
      {
       sscanf(&pinyin[3], "%02x%02x", &byte1, &byte2);
        if (byte1<128) byte1 += 128;
      } /* end GB */
      else if ((pinyin[1]=='q')&&(pinyin[2]=='w')) /*that's QuWei code*/ 
      {
       sscanf(&pinyin[3], "%02d%02d", &byte1, &byte2);
	byte1 += 160;
	byte2 += 160;
      } /* end QuWei */
      else return(0);

      if (flag)
        {
	fputc(byte1, outfile);
	fputc(byte2, outfile);
	last_five(byte1-128, byte2-128);
	return(1);
	}
	else
	{ /* need to check if this GB if wanted */
	twobytes[0] = byte1 - 128;
	twobytes[1] = byte2 - 128;

re_display:
	  display_ch(twobytes, cclib_array);
REVERSE;
	       fputs("\033[K\033[24;1f\
 <CR>: accept  ESC:new GB S:show last 5  G:giveup  A:string  @:finish  !:shell", stderr);
NORMAL;

                  fprintf(stderr,"\033[7;1f\033[K\033[7;2fGuoBiao: %s >", 
		  pinyin);

once_more:       switch(getch())
	       {
		case 13:
#if USG 
                case 10: 
#endif
			fputc(byte1, outfile);
			fputc(byte2, outfile);
			last_five(byte1-128, byte2-128);
			return(1);
#if !USG
		case 10: goto once_more;
#endif
		case 's':
		case 'S': show_last_five(cclib_array); goto re_display;
		case 27: /* new input */
			insert_pinyin(0, PinYinDic, cizu, cclib_array, CiDian);
			break;
/*
                  fputs("\033[7;1f\033[K\033[7;2fNew GuoBiao> ", stderr);
		  fgets(&pinyin[1], 80, stdin);
		  lens = strlen(pinyin);
		  for (i=1; i<lens; i++)
		  	if (pinyin[i]>64 && pinyin[i]<91) pinyin[i] +=32;
		  pinyin[lens-1] = 0;

		  goto do_again; 
*/
		case 'g': /* give up this GuoBiao */
		case 'G':  return(-5); break;
		case 'a':   /*  print this GB as it is */
		case 'A':  return(-3); break;
 		case '@': return(-10); /* finish up */ break;
 		case '!':  /* get shell */
			get_shell();
			goto re_display;
			break;
		case 'i':   /* insert something */
		case 'I': 
			strcpy(pinyin1, pinyin);
			insert_pinyin(1, PinYinDic, cizu, cclib_array, CiDian);
			strcpy(pinyin, pinyin1);
			goto do_again;
			break;
		case 3:
		case 4: exit(-1);
		default: BELL; goto once_more;
		}
	}

}


get_cizu(PinYinDic, cizu, cclib_array, CiDian) /* Given CiZu in PinYin find 2-byte GB for all characters */
char *PinYinDic;
struct CiZu *cizu;
unsigned char *cclib_array, *CiDian;
{
int num, i, j, k, chosen, lens, byte1, byte2;
char str2[20], opinyin[18];

re_do:

for ( i=0; i<20; i++) str2[i] = 0;
for ( i=0; i<81; i++) str1[i] = 0;

	if (cizu->str[strlen(cizu->str)-1] == '-') {
		cizu->str[strlen(cizu->str)-1]=0; cizu->zishu = 1;}

j=1;
	if ((num=match_cizu(cizu, CiDian))==0) /* not in the Cidian */
	{/* it is not in the Ci2Dian3 */
re_start:	for (i=0; i<cizu->zishu; i++)
		{ k = 0;
			pinyin[0] = 32;
 		 while((cizu->str[j+k]!='-')&&(cizu->str[j+k]!='\0'))
		 	{pinyin[k+1] = cizu->str[j+k]; ++k;}

		pinyin[k+1] = 0;
		j += (k+1);
		lens = k+1;
		strcpy(opinyin, pinyin);
do_again:
		chosen = get_pinyin(0, PinYinDic, cizu, cclib_array, CiDian);

		if(chosen >=0)
		      {/* it is PinYin */
			if (i==0) strcpy(str1, &pinyin[1]);
			else { pinyin[0] = '-';
			strcat(str1, pinyin);
			}

		      str2[2*i] = all[chosen].str[all[chosen].lens];
		      str2[2*i+1] = all[chosen].str[all[chosen].lens+1];

		      }
		      else
		      { /* it's GuoBiao */
			if (i==0) strcpy(str1, &opinyin[1]);
			else { opinyin[0] = '-';
			strcat(str1, opinyin);
			}
		      str2[2*i] = twobytes[0];
		      str2[2*i+1] = twobytes[1];
		      }
	   }
	   
	   filelength += (strlen(&cizu->str[1]) + strlen(str2) + 2);
	   strcat(CiDian, str1);
	   strcat(CiDian, " ");
	   strcat(CiDian, str2);
	   strcat(CiDian, "\n");
	}
	else /* it is a CiZu in the Ci2Dian3 */
	{ j=0;

	  if ((quiet_pick)&&(num==1)) 
	    {
		  strcpy(str1, cizu->str); 
		for (i=0; i< cizu->zishu*2; i++)
			{
			if ((i%2)==0) last_five(all[j].str[i],all[j].str[i+1]);
			fputc(all[j].str[i]+128, outfile);
			}
			return(1);
	    }

fputs(" \033[7;1f\033[K\033[7;1fCiZu:", stderr); fputs(&cizu->str[1], stderr);
	       while(j<num)
	      {
re_display:
	       display_ch(all[j].str, cclib_array);

REVERSE;
	       fputs("\033[K\033[24;1f\
<CR>: accept SPACE:more <:back ESC:new S:show last 5 A:string @:finish G:giveup", stderr);
NORMAL;
               if (j >= num-1)
                  fputs("\033[7;38f\033[K\033[7;38f(No more) ==>", stderr);
               else
                   fprintf(stderr, "\033[%d;%df\033[K\033[%d;%df(%d more) ==>",
                 7, 38, 7, 38, num-j-1);

once_more:       switch(getch())
	       {
#if USG 
                case 10: 
#else
		case 10:  goto once_more;
#endif
		case 13: /* return this one */
		  strcpy(str1, cizu->str); 
		for (i=0; i< cizu->zishu*2; i++)
			{
			if ((i%2)==0) last_five(all[j].str[i],all[j].str[i+1]);
			fputc(all[j].str[i]+128, outfile);
			}
			return(1);
		case 32: j ++; break;
		case 27: j = 1; goto re_start; /* decompose it into pinyin */
		case 'g':   /* give up this cizu */
		case 'G':  return(-5); break;
		case 'i':   /* insert something */
		case 'I': 
			insert_pinyin(1, PinYinDic, cizu, cclib_array, CiDian);
			goto re_do;
			break;
		case 'a':   /*  print this cizu as it is */
		case 'A':  return(-3); break;
		case '@': return(-10); /* finish up */ break;
		case '!': /*get shell */
			get_shell();
			goto re_display;
			break;
		case 3:
		case 4: exit(-1);
		case 's':
		case 'S': show_last_five(cclib_array); goto re_display;
		case ',':
		case '<': if (j>0) j--; break;
		default: BELL; goto once_more;
		}
	     }
	     j = 1; BELL; goto re_start;
	}


}



get_Chinese(PinYinDic, cizu, cclib_array, CiDian)
 /* given Chinese expression in PinYin, GB, or CiZu decode it*/ 
char *PinYinDic;
struct CiZu *cizu;
unsigned char *cclib_array, *CiDian;
{
int i, num, lens, chosen, flag;

	total_num =0;
   switch(cizu->mode)
    {
     case 5:
             break;
     case 4:
             break;
     case 3:
             break;
     case 1:
     case 2:
          if (cizu->str[1] < 65)
                     /* That's not PinYin, print it out */
                { if (cizu->str[1] == 0) return(-1);
			fputs(&cizu->str[1], outfile);
                    break;
                }

      pinyin[0] = 32;
      cizu->str[0] = 32;
      
      if (cizu->zishu == 1)
           { /* Only a single Chinese character*/
                lens = strlen(cizu->str);
                for (i=1; i<lens+1; i++)
                  {
                   if (cizu->str[i]>64 && cizu->str[i]<91)
                     pinyin[i] = cizu->str[i] + 32;
                    else pinyin[i] = cizu->str[i];
                   } 

                /* Check GuoBiao and QuWei */

                   if (cizu->str[1] < 91) flag = lens;
		   else flag = 0;

		   if (chosen=get_GB(flag, PinYinDic, cizu, cclib_array, CiDian)) 
		   {
			if (chosen==-10)
				{
				fprintf(outfile, "\\Zw %s ", &cizu->str[1]);
				finish_up = 1;
				}
			else if (chosen==-3)
				{
				fprintf(outfile, " %s ", &cizu->str[1]);
				}
			return(1);
		   }

		/* Now check PinYin */

		 chosen = get_pinyin(flag, PinYinDic, cizu, cclib_array, CiDian);

             }
           else /* it is a cizu with more than one Chinese character
                check into CiDian before doing individual checking */
             {
              chosen = get_cizu(PinYinDic, cizu, cclib_array, CiDian);
			if (chosen==-10)
				{
				fprintf(outfile, "\\Zw %s ", &cizu->str[1]);
				finish_up = 1;
				}
			else if (chosen==-3)
				{
				fprintf(outfile, " %s ", &cizu->str[1]);
				}

             }
 
            break;

     default: fputs("Wrong mode!\n", stderr);
    } 

}

int last_i = 0, last_lb=0, last_le=0, the_x=1, the_y=1,
 tmp_x[1024], tmp_y[1024];



dePinYin(PinYinDic, cclib_array) /* Read a file to be separated into PinYin */
char *PinYinDic;
unsigned char *cclib_array;
{
unsigned char inbuffer[1024];
struct CiZu cizu;
int lens;
#if MSDOS|TURBO
unsigned char huge *CiDian;
CiDian = (unsigned char *) farmalloc(MAX_CiZuDic);
#else
unsigned char CiDian[MAX_CiZuDic];
#endif

 cizu.mode=0; /* modes:
               0 -- ASCII
               1 -- Chinese
               2 -- Pure Chinese
               3 -- Greek
               4 -- Russian
               5 -- Japanese PinJiaMing
               6 --  Japanese PianJiaMing
               7 -- Symbol 1
	       8 -- Symbol 2
	       9 -- CCDOS ASCII
            */

    infile = fopen(infile_name, "r");
    outfile = fopen(outfile_name, "w");

  load_cidian(CiDian);

CLS;
   cizu.zishu=1;
  while( fgets(inbuffer, 1024, infile) != NULL)
 {
   if(finish_up) {fputs(inbuffer, outfile); goto next_while;}
   lens = strlen(inbuffer);
   last_i = 0;
   line6_window(inbuffer, lens);

   PinYin_Ch(inbuffer, lens, PinYinDic, &cizu, cclib_array, CiDian);
   next_while:
   	save_cizu(CiDian);
  }  /* end while */

fclose(infile);
fclose(outfile);

}


PinYin_Ch(inbuffer, lens, PinYinDic, cizu, cclib_array, CiDian)
 /* process a line into separate PinYin, CiZu, GB
				or ASCII */
unsigned char *inbuffer;
int lens;
char *PinYinDic;
struct CiZu *cizu;
unsigned char *cclib_array, *CiDian;
{
int i, j;


   for (i=0; i<lens; i++)
 {   
         while(inbuffer[i]=='\\')
          {

  	                 if (pinyin_loc)  
                               {
                                  cizu->str[pinyin_loc+1] = 0;
                                  get_Chinese(PinYinDic, cizu, cclib_array, CiDian);
                                  pinyin_loc = 0;   cizu->zishu=1;
				  show_str(i, inbuffer);
                               }

             if (strncmp(&inbuffer[i+1], "As", 2) == 0) /* ASCII mode */
                { cizu->mode = 0;  
			five_lens = 0;
                  i += 4; 
                } /* Chinese Mode including PinYin QuWei and GuoBiao */
              else if (strncmp(&inbuffer[i+1], "Zw", 2) == 0)
                { cizu->mode = 1; 
                  i += 4; 
                } /* Pure Chinese */
              else if (strncmp(&inbuffer[i+1], "CZw", 3) == 0)
                { cizu->mode = 2;  
                  i += 5; 
                } /* Greek mode */
              else if (strncmp(&inbuffer[i+1], "Gk", 2) == 0)
                { cizu->mode = 3; 
                  i += 4; 
                } /* Russian Mode */
              else if (strncmp(&inbuffer[i+1], "Rs", 2) == 0)
                { cizu->mode = 4; 
                  i += 4; 
                } /* Japanese mode */ /* Japanese mode */
              else if (strncmp(&inbuffer[i+1], "jp", 2) == 0)
                { cizu->mode = 5; 
                  i += 4; 
                }
              else if (strncmp(&inbuffer[i+1], "Jp", 2) == 0)
                { cizu->mode = 6; 
                  i += 4; 
                } /* Symbol mode */
              else if (strncmp(&inbuffer[i+1], "Sb1", 3) == 0)
                { cizu->mode = 7; 
                  i += 5; 

                } 
              else if (strncmp(&inbuffer[i+1], "Sb2", 3) == 0)
                { cizu->mode = 8; 
                  i += 5; 
                }
              else if (strncmp(&inbuffer[i+1], "aS", 2) == 0)
                { cizu->mode = 9;
                  i += 4; 
                }   /* Line continue */ /* Line continue */
              else if (strncmp(&inbuffer[i+1], "c@", 2) == 0)
                { 
                  i += 4; 
                }
              else if (strncmp(&inbuffer[i+1], "Quiet", 5) == 0)
                { 
                  i += 7;
		  Quiet = 1;
		  BLINK;
		  fputs("Working ...", stderr);
		  NORMAL;
		  Rearrange = 0;
                }
              else if (strncmp(&inbuffer[i+1], "Show", 4) == 0)
                { 
                  i += 6;
		  Quiet = 0;
		  Rearrange = 1;
                }
	      else switch(inbuffer[i+1])
	        {case '-':
		 case '=':
		 case '#': if (!cizu->mode)
		 		{ fputc('\\', outfile);
					fputc(inbuffer[i+1], outfile);
				}
			   else if (cizu->mode==2)
			       { fputc(163, outfile);
					fputc(inbuffer[i+1]+128, outfile);
				}
			   else fputc(inbuffer[i+1], outfile);
			   i += 2; break;
		default:  fputc('\\', outfile); i++;
		}

             }  /* end of if '//' */
           
	     while(inbuffer[i] > 160) fputc(inbuffer[i++], outfile);

        if (i>=lens) {
                             if (pinyin_loc)  
                               {
                                  cizu->str[pinyin_loc+1] = 0;
                                  get_Chinese(PinYinDic, cizu, cclib_array, CiDian);
                                  pinyin_loc = 0;   cizu->zishu=1;
				  show_str(i, inbuffer);

                               }
		return(-1);
		}
        if (cizu->mode==0&&inbuffer[i]!=0)		 /* ASCII */
                  fputc(inbuffer[i], outfile);
        else if (cizu->mode==4&&inbuffer[i]!=0)		 /* Russian */
		{fputc(167, outfile);
                  fputc(inbuffer[i]+128, outfile);
		  last_five(39, inbuffer[i]);
		}
        else if (cizu->mode==5&&inbuffer[i]!=0)	 /* Japanese PingJiaMing */
		{fputc(164, outfile);
                  fputc(inbuffer[i]+128, outfile);
		  last_five(36, inbuffer[i]);
		}
        else if (cizu->mode==6&&inbuffer[i]!=0) 	/* Japanese PianJiaMing */
		{fputc(165, outfile);
                  fputc(inbuffer[i]+128, outfile);
		  last_five(37, inbuffer[i]);
		}
        else if (cizu->mode==3&&inbuffer[i]!=0)		 /* Greek */
                {   /* Greek mode is easy*/
                 switch(inbuffer[i])
                  {
		case 'A': fputc(166,outfile); fputc(161, outfile);
				last_five(38,33);
			break;
		case 'B': fputc(166,outfile); fputc(162, outfile);
				last_five(38,34);
			break;
		case 'G': fputc(166,outfile); fputc(163, outfile);
				last_five(38,35);
			break;
		case 'D': fputc(166,outfile); fputc(164, outfile);
				last_five(38,36);
			break;
		case 'E': fputc(166,outfile); fputc(165, outfile);
				last_five(38,37);
			break;
		case 'Z': fputc(166,outfile); fputc(166, outfile);
				last_five(38,38);
			break;
		case 'H': fputc(166,outfile); fputc(167, outfile);
				last_five(38,39);
			break;
		case 'Q': fputc(166,outfile); fputc(168, outfile);
				last_five(38,40);
			break;
		case 'I': fputc(166,outfile); fputc(169, outfile);
				last_five(38,41);
			break;
		case 'K': fputc(166,outfile); fputc(170, outfile);
				last_five(38,42);
			break;
		case 'L': fputc(166,outfile); fputc(171, outfile);
				last_five(38,43);
			break;
		case 'M': fputc(166,outfile); fputc(172, outfile);
				last_five(38,44);
			break;
		case 'N': fputc(166,outfile); fputc(173, outfile);
				last_five(38,45);
			break;
		case 'O': fputc(166,outfile); fputc(174, outfile);
				last_five(38,46);
			break;
		case 'P': fputc(166,outfile); fputc(175, outfile);
				last_five(38,47);
			break;
		case 'R': fputc(166,outfile); fputc(176, outfile);
				last_five(38,48);
			break;
		case 'S': fputc(166,outfile); fputc(177, outfile);
				last_five(38,49);
			break;
		case 'T': fputc(166,outfile); fputc(178, outfile);
				last_five(38,50);
			break;
		case 'V': fputc(166,outfile); fputc(179, outfile);
				last_five(38,51);
			break;
		case 'F': fputc(166,outfile); fputc(180, outfile);
				last_five(38,52);
			break;
		case 'X': fputc(166,outfile); fputc(181, outfile);
				last_five(38,53);
			break;
		case 'Y': fputc(166,outfile); fputc(182, outfile);
				last_five(38,54);
			break;
		case 'W': fputc(166,outfile); fputc(183, outfile);
				last_five(38,55);
			break;
		case 'a': fputc(166,outfile); fputc(193, outfile);
				last_five(38,65);
			break;
		case 'b': fputc(166,outfile); fputc(194, outfile);
				last_five(38,66);
			break;
		case 'g': fputc(166,outfile); fputc(195, outfile);
				last_five(38,67);
			break;
		case 'd': fputc(166,outfile); fputc(196, outfile);
				last_five(38,68);
			break;
		case 'e': fputc(166,outfile); fputc(197, outfile);
				last_five(38,69);
			break;
		case 'z': fputc(166,outfile); fputc(198, outfile);
				last_five(38,70);
			break;
		case 'h': fputc(166,outfile); fputc(199, outfile);
				last_five(38,71);
			break;
		case 'q': fputc(166,outfile); fputc(200, outfile);
				last_five(38,72);
			break;
		case 'i': fputc(166,outfile); fputc(201, outfile);
				last_five(38,73);
			break;
		case 'k': fputc(166,outfile); fputc(202, outfile);
				last_five(38,74);
			break;
		case 'l': fputc(166,outfile); fputc(203, outfile);
				last_five(38,75);
			break;
		case 'm': fputc(166,outfile); fputc(204, outfile);
				last_five(38,76);
			break;
		case 'n': fputc(166,outfile); fputc(205, outfile);
				last_five(38,77);
			break;
		case 'o': fputc(166,outfile); fputc(206, outfile);
				last_five(38,78);
			break;
		case 'p': fputc(166,outfile); fputc(207, outfile);
				last_five(38,79);
			break;
		case 'r': fputc(166,outfile); fputc(208, outfile);
				last_five(38,80);
			break;
		case 's': fputc(166,outfile); fputc(209, outfile);
				last_five(38,81);
			break;
		case 't': fputc(166,outfile); fputc(210, outfile);
				last_five(38,82);
			break;
		case 'v': fputc(166,outfile); fputc(211, outfile);
				last_five(38,83);
			break;
		case 'f': fputc(166,outfile); fputc(212, outfile);
				last_five(38,84);
			break;
		case 'x': fputc(166,outfile); fputc(213, outfile);
				last_five(38,85);
			break;
		case 'y': fputc(166,outfile); fputc(214, outfile);
				last_five(38,86);
			break;
		case 'w': fputc(166,outfile); fputc(215, outfile);
				last_five(38,87);
			break;
		default: BELL;
                }
              }
        else { if (cizu->mode > 6&&inbuffer[i]!=0)
			{ /* Chinese ASCII, and Symbols */
                    if (inbuffer[i]>31 && inbuffer[i] < 127)
		        {fputc(154+cizu->mode,outfile);
		    	fputc(inbuffer[i]+128,outfile);
			last_five(26+cizu->mode, inbuffer[i]);
			}
                     else fputc(inbuffer[i],outfile);
		     	goto next_for;
                        }
              else  /* Chinese mode */
              switch(inbuffer[i])
               {
                  case 9:  
                  case 12: 
                  case 13:
                  case 10: /* all these control characters
                              end current PinYin and prints out theirself */

                             if (pinyin_loc)  
                               {
                                  cizu->str[pinyin_loc+1] = 0;
                                  get_Chinese(PinYinDic, cizu, cclib_array, CiDian);
                                  pinyin_loc = 0;   cizu->zishu=1;
                               }
                             fputc(inbuffer[i],outfile);
				  show_str(i, inbuffer);
				  break;
                   case 0:
                             if (pinyin_loc)  
                               {
                                  cizu->str[pinyin_loc+1] = 0;
                                  get_Chinese(PinYinDic, cizu, cclib_array, CiDian);
                                  pinyin_loc = 0;   cizu->zishu=1;
                               }
				  show_str(i, inbuffer);
		   	break;

                  case '~':
                  case '@':
                  case '$':
                  case '%':
                  case '^':
                  case '&':
                  case '*':
                  case '(':
                  case ')':
                  case '+':
                  case '{':
                  case '}':
                  case '[':
                  case ']':
                  case '|':
                  case '\"':
                  case '\'':
                  case '<':
                  case '>':
                  case '`':
                  case '!':
                  case ':':
                  case ';':
                  case ',':
                  case '.':
                  case '?':
                  case '/': /* the above symbols and punctuations
                              ends current PinYin and prints out itself */
                             if (pinyin_loc)  
                               {
                                  cizu->str[pinyin_loc+1] = 0;
                                  get_Chinese(PinYinDic, cizu, cclib_array, CiDian);
                                  pinyin_loc = 0;   cizu->zishu=1;
                               }
			   if (cizu->mode == 2)
                          {fputc(163, outfile);
			  fputc(inbuffer[i]+128, outfile);
			  }
                           else  fputc(inbuffer[i], outfile);
			   show_str(i, inbuffer);
                             break;

                  case ' ': /* blank space ends the current PinYin
                              does not print out itself*/

                             if (pinyin_loc)  
                               {
                                  cizu->str[pinyin_loc+1] = 0;
                                  get_Chinese(PinYinDic, cizu, cclib_array, CiDian);
                                  pinyin_loc = 0;   cizu->zishu=1;
                               }
               			   show_str(i, inbuffer);
                            break;
                 case '#':  /* # in Chinese mode is a space, it ends PinYin
                               as well */
                             if (pinyin_loc)  
                               {
                                  cizu->str[pinyin_loc+1] = 0;
                                  get_Chinese(PinYinDic, cizu, cclib_array, CiDian);
                                  pinyin_loc = 0;   cizu->zishu=1;
                               }
                             fputc(32, outfile);
			   show_str(i, inbuffer);
                             break;
                  case '-': /* - between Pinyin forms Ci2 */
                             cizu->str[++pinyin_loc] = '-';
                             cizu->zishu ++;
                            break;
                  case '=': /* = behind Pinyin marks the end of PinYin
                               and says this PinYin is pre-sorted */
                             if (pinyin_loc)  
                               { if (cizu->str[1]>96)
                                      cizu->str[1] -= 32; 
                                 cizu->str[pinyin_loc+1] = 0;
                                  get_Chinese(PinYinDic, cizu, cclib_array, CiDian);
                                  pinyin_loc = 0;   cizu->zishu=1;
                               }
			   show_str(i, inbuffer);
                              break;

                 default: 
                                /* Print it as it is and mark the end
                                   of PinYin */
                         if ((inbuffer[i] < 32) || (inbuffer[i] > 127))
                           {
        
                             if (pinyin_loc)  
                               {
                                  cizu->str[pinyin_loc+1] = 0;
                                  get_Chinese(PinYinDic, cizu, cclib_array, CiDian);
                                  pinyin_loc = 0;   cizu->zishu=1;
                               }
                             fputc(inbuffer[i], outfile);

                                break;
                           }

                        cizu->str[++pinyin_loc] = inbuffer[i];
        
                 }  /* end of switch */

              } /*end else */
	      if (finish_up) {fputs(&inbuffer[i+1], outfile); return(0);}
   next_for:;
   }  /* end for i */

                             if (pinyin_loc)  
                               {
                                  cizu->str[pinyin_loc+1] = 0;
                                  get_Chinese(PinYinDic, cizu, cclib_array, CiDian);
                                  pinyin_loc = 0;   cizu->zishu=1;
				  show_str(i, inbuffer);

                               }
}


display_ch(s, cclib_array) /*  display Chinese characters */
char *s;
unsigned char *cclib_array;
{
char row[17][81],  whole[1600];
long int quwei, byte1;
int i, l, lens, j, n, tmpint, lens2;

lens = strlen(s);

j = 0;
	for (i=0; i<lens; i += 2)
	{  byte1 = s[i];
		if (byte1>47) byte1 -= symbol_skip;
		quwei = ((byte1-33)*94 + s[i+1] - 33)*32;
 
                   for (l=0; l<16; l++ )
                   {
                     for (n=0; n<8; n++)
                      {   
                  row[l][j+n] = ASCII[cclib_array[(long)(quwei+2*l)]][n]*6 + 32;
                  row[l][j+8+n]=ASCII[cclib_array[(long)(quwei+2*l+1)]][n]*6 + 32;
                      }
                   }                   
                  j +=16;

 	}



                   strcpy(whole, "\033[8;1f");
                  for (n=0; n<16; n++)
                    {
                    row[n][j] = '\0';
                    strcat(whole, row[n]);
		    if (lens<10)
		    	strcat(whole, "\033[K\n");
			else strcat(whole, "\n");
                    }

               write(errhandle, whole, strlen(whole)-1);


}



 
clear4() /* clear 6 lines on the screen */
{
        fputs("\033[1;1f\033[K", stderr);
        fputs("\033[2;1f\033[K", stderr);
        fputs("\033[3;1f\033[K", stderr);
        fputs("\033[4;1f\033[K", stderr);
        fputs("\033[5;1f\033[K", stderr);
        fputs("\033[6;1f\033[K", stderr);
}



line6_window(s, lens) /* display text in 6-line window */
char *s;
int lens;
{

int i, j, new_x, new_y, shift_y;

	if (Quiet) return(-1);
	new_x = the_x;
	new_y = the_y;
	for (i=0; i< lens; i++)
	{
	 switch(s[i])
	 	{
		case 9:  tmp_x[i] = new_x; tmp_y[i] = new_y; new_x +=8;
			break;
		case 10: 
			new_y += 1; new_x = 1;
			tmp_x[i] = new_x;  tmp_y[i] = new_y; 
			break;
		case 13: tmp_x[i] = new_x; tmp_y[i] = new_y; 
			break;
		default: 
			tmp_x[i] = new_x; tmp_y[i] = new_y;
			 if (new_x >= 80) {new_y +=1; new_x = 1;}
			else new_x ++;

		}
	 }

	 
	 GOTOXY(the_y, the_x);
	 if (new_y <= 6) {REVERSE;
			fputs(s, stderr);
			}
	 else {

		clear4();
		GOTOXY(1, 1);
		i= 0;
		shift_y = tmp_y[0] - 1;
		while(tmp_y[i] <= tmp_y[0]) tmp_x[i] = 1 + i++;
		for (i=0; i<lens; i++) tmp_y[i] -= shift_y;
		REVERSE;

		fputs(s, stderr);
		}
/*
if(Editor)
	if (s[lens-1] == 10||tmp_x[lens-1]==80) the_y = tmp_y[lens-1] + 1;
	else the_x = tmp_x[lens-1] + 1;
else {
*/
			the_y = tmp_y[lens-1];
			the_x = tmp_x[lens-1];
/*
	}
*/
NORMAL;
}




show_str(n, s) /* show a string on the screen window */
int n;
char *s;
{
int i;

	if (Quiet==1) return(-1);

	GOTOXY(tmp_y[last_i],tmp_x[last_i]);
	for (i=last_i; i< n; i++) fputc(s[i], stderr);
	last_i = n;	

}


load_AllBuffer(AllBuffer) /* load a file into AllBuffer array */
unsigned char *AllBuffer;
{
int Allhd;
long int bytes;

/* read in the input file into a buffer */

    if ((Allhd=open(infile_name, O_RDONLY))<0)
       {fputs("File not found!", stderr);}

filelength=0;
AllBuffer[0] = 0;

while( (bytes=read(Allhd, &AllBuffer[filelength], MAX_filesize)) >0)
     filelength += bytes;

AllBuffer[filelength] = 0;
close(Allhd);

}


As2aS() /* translate pure ASCII to Chinese ASCII */
{
unsigned char inbuffer[1024], tmpchr;
int i, lens;

	CLS;
	infile = fopen(infile_name, "r");

#if VMS
        if (piping) stdout=fopen(outfile_name, "w");
#endif

GOTOXY(10,1);
REVERSE;
fputs("  Press <Space> to convert,  other keys to ignore        ", stderr);
NORMAL; 

  while( fgets(inbuffer, 1024, infile) != NULL)
    { /* get the file line by line */
        i =  0;
	lens = strlen(inbuffer);
	line6_window(inbuffer, lens);
	last_i = 0;

      while(i<lens)  /* Translate the file */
       {

     	 while (inbuffer[i] > 127 || inbuffer[i] < 33)
	 {
		fputc(inbuffer[i], stdout);
		i++;
	 if (i>=lens) goto next_next;
	 }


	 tmpchr = inbuffer[i+1];
	 inbuffer[i+1] = 0;
	 show_str(i+1, inbuffer);
	 inbuffer[i+1] = tmpchr;
	 switch(getch())
	 {
		case 32: fputc(163, stdout);
			 fputc(128+inbuffer[i], stdout);
			 break;
		default: fputc(inbuffer[i], stdout);
	 }

	 i++;
        next_while:;
       }
       next_next:;
     }

}


help() /* display help*/
{

CLS;

fputs("                  Welcome to ChText\n\n\
Introduction : ChText is a Chinese text line editor, intepreter and viewer.\n\
ChText has an internal dictionary (Zi4Dian3) that contains about 4500 Chinese\n\
characters including some punctuations. Each of these characters carries a\n\
unique ID in PinYin+accent+(abreviation of PianPang). Thus, it also has\n\
utility functions to convert Chinese text into PinYin, convert ASCII into\n\
Chinese ASCII and test PinYin match of Chinese words. It likes Ci2-Zu3 input\n\
most, and the Ci2Dian3 is external, and is updated after each run.\n", stdout);

fputs("\n\
The following are the ideas:\n\
1. Line editor mode:\n\
  $chtext filename -e\n\n\
 It lets you append Chinese and English to this file at Line> prompt.\n\
 To input Chinese, you can type in PinYin, e.g., 'wang2', or GuoBiao, e.g.,\n\
 'gba1a5', or a string of PinYin, e.g., wo3-men2 shi4 zhong1-guo2 ren2\n\
", stdout);
fputs("\n\
	The first byte is a flag byte\n\
	@	finish up and exit\n\
	!	get system shell\n\
	<Space> ASCII string\n\
	`	Pure Chinese mode\n\
	/	Chinese ASCII\n\
	.	Japanese PingJiaMing\n\
	,	Japanese PianJiaMing\n\
	;	Greek mode\n\
	'	Russian mode\n\
	1	Symbol 1 mode\n\
	2	Symbol 2 mode\n\
	ascii	Chinese mode\n\n\
If the last byte is a backslash \\, it causes line break.\n\n\
", stdout);
fputs("\n\
Important keys in picking choices,\n", stdout);
fputs("\
digits 1, 2, 3, 4, and 5 to choose the characters appeared on the screen.\n\
<Return> key is for choice 1,\n\
<Space> key for more choices,\n\
key ',' or '<' to back up one screen,\n\
<ESC> key to prompt you for a new PinYin,\n\
<Backspace> to delete a character from PinYin\n\
key 'g' to give up this PinYin\n\
key 'a' to print out string as it is.\n\
key 's' show the last five Chinese characters\n\
key '!' get system shell\n\
key '@' finish up and save the rest of the file as it is\n\
You can also input in Ci2-Zu3 mode. Anything with hyphen makes a Ci2-Zu3,\n\
e.g., pin1-yin1 and wang2- are all Ci2-Zu3. In GuoBiao and Ci2-Zu3 modes,\n\
<Return> is to accept and <ESC> to reject, <Space> bar for more.\n\
If the first character is <SPACE> then it's output as an ASCII string\n\n\
", stdout);
fputs("\
2. Interpretor mode: ChText's major function is an interpretor.\n\
 $chtext PinYinfile outfile\n\n\
 It translates the PinYin file to Chinese text file. The PinYin file is\n\
created with a general purpose editor, such as EMACS. This PinYin file\n\
also contains some ChText commands, such as \\Zw to switch to Chinese mode\n\
and \\As to switch back to ASCII mode.  Individual PinYin's are separated by\n\
spaces or line-break, punctuations also serve as a separater. Again, Ci2-Zu3,\n\
GuoBiao and QuWei inputs are allowed in Chinese modes. Anything that contains\n\
hyphen is considered as Ci2-Zu3, and GuoBiao syntax is normally, e.g.,\n\
'gba1a3' which is equivalent to 'qw0103'.\n\
", stdout);

fputs("\
What are ChText commands? ChText commands are typed in while you edit\n\
the PinYin file and they are used to switch modes, etc., and the general syntax\n\
is a backslash \\ followed by some letters (and a <Space> or <RETURN> for\n\
mode commands), i.e., 10 mode commands\n\
\\As    sets up pure ASCII mode\n\
\\Zw    sets up Chinese mode\n\
\\CZw   sets up pure Chinese\n\
\\aS    sets up Chinese ASCII mode\n\
\\jp    sets up Japanese PingJiaMing mode\n\
\\Jp    sets up Japanese PianJiaMing mode\n\
\\Sb1   sets up set one Symbol mode\n\
\\Sb2   sets up set two Symbol mode\n\
\\Gk    sets up Greek mode\n\
\\Rs    sets up Russian mode\n\
and the other commands are\n\
#       a space in Chinese modes (since space is used as the separater).\n\
\\#	prints # in Chinese modes\n\
=	a PinYin is followed by an equality sign, there is no manual picking\n\
\\= 	prints = in Chinese modes\n\
\\-	prints - in Chinese modes (since - is used as hyphen)\n\
\\@c	used at end of line as line continue sign to break long lines\n\
\\Quiet	to disable screen messages\n\
\\Show	to start screen messages.\n\n\
", stdout);

fputs("\
PinYin strings are normally displayed on the screen if no \\Quiet command was\n\
met, and the choices for each PinYin are displayed. The key strokes to pick\n\
choices are exactly the same as the ones used in line editor mode.\n\
It is strongly encouraged to use Ci2-Zu3 input scheme, because these are\n\
few duplicating Ci2-Zu3 and it is very fast. If a PinYin starts with a \n\
capital letter, there is no manual picking just as a PinYin is followed by\n\
an equality sign, thus unless you know this PinYin has only one Chinese\n\
do not capitalize the first letter or append =.\n\n\
", stdout);

fputs("\
3. Converting a Chinese file into PinYin file:\n\
 $chtext chfile > pinyinfile -p\n\n\
This allows you to convert a Chinese file into a PinYin file that can be\n\
converted right back to Chinese file by\n\n\
 $chtext pinyinfile chfile \n\n\
without picking process. But it is not the purpose, the real purpose is to\n\
give you the chance to edit the pinyinfile instead of editing the chfile.\n\
The converted pinyinfile has \\Quiet command at the very beginning of the\n\
file. If you edit this file, insert \\Show command at the starting of the\n\
edited block to enable screen display and add a \\Quiet command at the end.\n\n\
You can also get a short form PinYin file by\n\
 $chtext chfile > pinyinfile -ps\n\n\
which is only good as mail message in PinYin.\n\n\
", stdout);

fputs("\
4. Chinese PinYin dictionary:\n\
 $chtext -d\n\n\
Sometimes you are not sure which PinYin is right for a word, you can use\n\
ChText PinYin dictionary. It shows you the correspondence between PinYin(long\n\
form), Chinese character, GuoBiao, and two-byte ASCII representations.It will\n\
 not generate any files.\n\n\
", stdout);

fputs("\
5. Viewing a Chinese text file:\n\
 $chtext chfile -v\n\n\
It displays a Chinese text file in text mode.\n\n\
", stdout);

fputs("\
6. Coverting ASCII characters in a Chinese text file into Chinese ASCII for\n\
hamonic fonts in printing:\n\
 $chtext chfile > newfile -a\n\n\
It will prompt at the ASCII letters. Press <Space> to change and any other\n\
keys to ignore.\n\n\
", stdout);

fputs("\
7. Print a PinYin dictionary:\n\
 $chtext -2\n\n\
The output file is pinyin.doc that lists all the characters in the internal\n\
dictionary with the PinYin ID.\n\
", stdout);

fputs("\n\n\
Other useful flags:\n\
-h\n\
 to view the on-line help\n\
-n\n\
  to disable dynamic dictionary arrangement. Otherwise the dictionary is\n\
  arranged each time after you pick a word, because it feels the one you picked\n\
  is more frequently used, and hence puts it in the front.-n flag disables it.\n\
-q\n\
 to make it quiet. It is the same as \\Quiet command in the file.\n\
", stdout);
fputs("\n\n\
Path dependency:\n\
ChText needs to find a font bitmap library and a Ci2Dian3 (phrase library).\n\
The UNIX environment variable to define the font library is CCLIB16jt\n\
and the Ci2Dian3.chi path is CHTEXTDIC, normally Ci2Dian3.chi is personal\n\
", stdout);
}

last_five(chr1, chr2)
char chr1, chr2;
{
int i, lens;
five_lens += 2;
	if (five_lens>10)
	{for(i=0; i<8; i++)
		five_ch[i] = five_ch[i+2];
	five_ch[8] = chr1;
	five_ch[9] = chr2;
	five_lens = 10;
	}
	else
	{
	five_ch[five_lens-2] = chr1;
	five_ch[five_lens-1] = chr2;
	}

}


show_last_five(cclib_array) /*  display the alst file Chinese characters */
unsigned char *cclib_array;
{
 five_ch[five_lens] = 0;
 display_ch(five_ch, cclib_array);
REVERSE;
	       fputs("\033[K\033[24;1f\
    Touch any key to continue                                   ==>            ", stderr);
NORMAL;

while (getch()==10);

}



insert_pinyin(insert, PinYinDic, cizu, cclib_array, CiDian)
/* insert a PinYin in the middle if inputting */
int insert;
char *PinYinDic;
struct CiZu *cizu;
unsigned char *cclib_array, *CiDian;
{
struct CiZu cizu1;
int lens, i;
	cizu1 = *cizu;

	if(insert)
       fprintf(stderr, " \033[%d;%df\033[K\033[%d;%df Insert PinYin > ",
        7, 1, 7, 1);
	else 
    fprintf(stderr, " \033[%d;%df\033[K\033[%d;%df Give up:%s  New PinYin => ",
        7, 1, 7, 1, pinyin);

                      fgets(&cizu->str[1], 80, stdin);
                      cizu->str[0] = 32;
                      lens = strlen(cizu->str);
                       cizu->str[lens-1] = 0;
		      cizu->zishu = 1;
		  for (i=1; i<lens-1; i++)
		  	{if (cizu->str[i]>64 && cizu->str[i]<91)
			 cizu->str[i] +=32;
			 if (cizu->str[i]=='-') cizu->zishu ++;
		        }

			  get_Chinese(PinYinDic, cizu, cclib_array, CiDian);
			  *cizu = cizu1;

}

