/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.commons.math.linear.BigMatrix;
import org.apache.commons.math.linear.InvalidMatrixException;
import org.apache.commons.math.linear.MatrixIndexException;

public class BigMatrixImpl
implements BigMatrix,
Serializable {
    static final long serialVersionUID = -1011428905656140431L;
    private static final BigDecimal ZERO = new BigDecimal(0.0);
    private static final BigDecimal ONE = new BigDecimal(1.0);
    private BigDecimal[][] data = null;
    private BigDecimal[][] lu = null;
    private int[] permutation = null;
    private int parity = 1;
    private int roundingMode = 4;
    private int scale = 64;
    protected static BigDecimal TOO_SMALL = new BigDecimal(1.0E-11);

    public BigMatrixImpl() {
    }

    public BigMatrixImpl(int rowDimension, int columnDimension) {
        this.data = new BigDecimal[rowDimension][columnDimension];
        this.lu = null;
    }

    public BigMatrixImpl(BigDecimal[][] d) {
        int nRows = d.length;
        if (nRows == 0) {
            throw new IllegalArgumentException("Matrix must have at least one row.");
        }
        int nCols = d[0].length;
        if (nCols == 0) {
            throw new IllegalArgumentException("Matrix must have at least one column.");
        }
        for (int row = 1; row < nRows; ++row) {
            if (d[row].length == nCols) continue;
            throw new IllegalArgumentException("All input rows must have the same length.");
        }
        this.copyIn(d);
        this.lu = null;
    }

    public BigMatrixImpl(double[][] d) {
        int nRows = d.length;
        if (nRows == 0) {
            throw new IllegalArgumentException("Matrix must have at least one row.");
        }
        int nCols = d[0].length;
        if (nCols == 0) {
            throw new IllegalArgumentException("Matrix must have at least one column.");
        }
        for (int row = 1; row < nRows; ++row) {
            if (d[row].length == nCols) continue;
            throw new IllegalArgumentException("All input rows must have the same length.");
        }
        this.copyIn(d);
        this.lu = null;
    }

    public BigMatrixImpl(String[][] d) {
        int nRows = d.length;
        if (nRows == 0) {
            throw new IllegalArgumentException("Matrix must have at least one row.");
        }
        int nCols = d[0].length;
        if (nCols == 0) {
            throw new IllegalArgumentException("Matrix must have at least one column.");
        }
        for (int row = 1; row < nRows; ++row) {
            if (d[row].length == nCols) continue;
            throw new IllegalArgumentException("All input rows must have the same length.");
        }
        this.copyIn(d);
        this.lu = null;
    }

    public BigMatrixImpl(BigDecimal[] v) {
        int nRows = v.length;
        this.data = new BigDecimal[nRows][1];
        for (int row = 0; row < nRows; ++row) {
            this.data[row][0] = v[row];
        }
    }

    public BigMatrix copy() {
        return new BigMatrixImpl(this.copyOut());
    }

    public BigMatrix add(BigMatrix m) throws IllegalArgumentException {
        if (this.getColumnDimension() != m.getColumnDimension() || this.getRowDimension() != m.getRowDimension()) {
            throw new IllegalArgumentException("matrix dimension mismatch");
        }
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        BigDecimal[][] outData = new BigDecimal[rowCount][columnCount];
        for (int row = 0; row < rowCount; ++row) {
            for (int col = 0; col < columnCount; ++col) {
                outData[row][col] = this.data[row][col].add(m.getEntry(row, col));
            }
        }
        return new BigMatrixImpl(outData);
    }

    public BigMatrix subtract(BigMatrix m) throws IllegalArgumentException {
        if (this.getColumnDimension() != m.getColumnDimension() || this.getRowDimension() != m.getRowDimension()) {
            throw new IllegalArgumentException("matrix dimension mismatch");
        }
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        BigDecimal[][] outData = new BigDecimal[rowCount][columnCount];
        for (int row = 0; row < rowCount; ++row) {
            for (int col = 0; col < columnCount; ++col) {
                outData[row][col] = this.data[row][col].subtract(m.getEntry(row, col));
            }
        }
        return new BigMatrixImpl(outData);
    }

    public BigMatrix scalarAdd(BigDecimal d) {
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        BigDecimal[][] outData = new BigDecimal[rowCount][columnCount];
        for (int row = 0; row < rowCount; ++row) {
            for (int col = 0; col < columnCount; ++col) {
                outData[row][col] = this.data[row][col].add(d);
            }
        }
        return new BigMatrixImpl(outData);
    }

    public BigMatrix scalarMultiply(BigDecimal d) {
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        BigDecimal[][] outData = new BigDecimal[rowCount][columnCount];
        for (int row = 0; row < rowCount; ++row) {
            for (int col = 0; col < columnCount; ++col) {
                outData[row][col] = this.data[row][col].multiply(d);
            }
        }
        return new BigMatrixImpl(outData);
    }

    public BigMatrix multiply(BigMatrix m) throws IllegalArgumentException {
        if (this.getColumnDimension() != m.getRowDimension()) {
            throw new IllegalArgumentException("Matrices are not multiplication compatible.");
        }
        int nRows = this.getRowDimension();
        int nCols = m.getColumnDimension();
        int nSum = this.getColumnDimension();
        BigDecimal[][] outData = new BigDecimal[nRows][nCols];
        BigDecimal sum = ZERO;
        for (int row = 0; row < nRows; ++row) {
            for (int col = 0; col < nCols; ++col) {
                sum = ZERO;
                for (int i = 0; i < nSum; ++i) {
                    sum = sum.add(this.data[row][i].multiply(m.getEntry(i, col)));
                }
                outData[row][col] = sum;
            }
        }
        return new BigMatrixImpl(outData);
    }

    public BigMatrix preMultiply(BigMatrix m) throws IllegalArgumentException {
        return m.multiply(this);
    }

    public BigDecimal[][] getData() {
        return this.copyOut();
    }

    public double[][] getDataAsDoubleArray() {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        double[][] d = new double[nRows][nCols];
        for (int i = 0; i < nRows; ++i) {
            for (int j = 0; j < nCols; ++j) {
                d[i][j] = this.data[i][j].doubleValue();
            }
        }
        return d;
    }

    public BigDecimal[][] getDataRef() {
        return this.data;
    }

    public int getRoundingMode() {
        return this.roundingMode;
    }

    public void setRoundingMode(int roundingMode) {
        this.roundingMode = roundingMode;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public BigDecimal getNorm() {
        BigDecimal maxColSum = ZERO;
        for (int col = 0; col < this.getColumnDimension(); ++col) {
            BigDecimal sum = ZERO;
            for (int row = 0; row < this.getRowDimension(); ++row) {
                sum = sum.add(this.data[row][col].abs());
            }
            maxColSum = maxColSum.max(sum);
        }
        return maxColSum;
    }

    public BigMatrix getSubMatrix(int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException {
        if (startRow < 0 || startRow > endRow || endRow > this.data.length || startColumn < 0 || startColumn > endColumn || endColumn > this.data[0].length) {
            throw new MatrixIndexException("invalid row or column index selection");
        }
        BigMatrixImpl subMatrix = new BigMatrixImpl(endRow - startRow + 1, endColumn - startColumn + 1);
        BigDecimal[][] subMatrixData = subMatrix.getDataRef();
        for (int i = startRow; i <= endRow; ++i) {
            for (int j = startColumn; j <= endColumn; ++j) {
                subMatrixData[i - startRow][j - startColumn] = this.data[i][j];
            }
        }
        return subMatrix;
    }

    public BigMatrix getSubMatrix(int[] selectedRows, int[] selectedColumns) throws MatrixIndexException {
        if (selectedRows.length * selectedColumns.length == 0) {
            throw new MatrixIndexException("selected row and column index arrays must be non-empty");
        }
        BigMatrixImpl subMatrix = new BigMatrixImpl(selectedRows.length, selectedColumns.length);
        BigDecimal[][] subMatrixData = subMatrix.getDataRef();
        try {
            for (int i = 0; i < selectedRows.length; ++i) {
                for (int j = 0; j < selectedColumns.length; ++j) {
                    subMatrixData[i][j] = this.data[selectedRows[i]][selectedColumns[j]];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MatrixIndexException("matrix dimension mismatch");
        }
        return subMatrix;
    }

    public BigMatrix getRowMatrix(int row) throws MatrixIndexException {
        if (!this.isValidCoordinate(row, 0)) {
            throw new MatrixIndexException("illegal row argument");
        }
        int ncols = this.getColumnDimension();
        BigDecimal[][] out = new BigDecimal[1][ncols];
        System.arraycopy(this.data[row], 0, out[0], 0, ncols);
        return new BigMatrixImpl(out);
    }

    public BigMatrix getColumnMatrix(int column) throws MatrixIndexException {
        if (!this.isValidCoordinate(0, column)) {
            throw new MatrixIndexException("illegal column argument");
        }
        int nRows = this.getRowDimension();
        BigDecimal[][] out = new BigDecimal[nRows][1];
        for (int row = 0; row < nRows; ++row) {
            out[row][0] = this.data[row][column];
        }
        return new BigMatrixImpl(out);
    }

    public BigDecimal[] getRow(int row) throws MatrixIndexException {
        if (!this.isValidCoordinate(row, 0)) {
            throw new MatrixIndexException("illegal row argument");
        }
        int ncols = this.getColumnDimension();
        BigDecimal[] out = new BigDecimal[ncols];
        System.arraycopy(this.data[row], 0, out, 0, ncols);
        return out;
    }

    public double[] getRowAsDoubleArray(int row) throws MatrixIndexException {
        if (!this.isValidCoordinate(row, 0)) {
            throw new MatrixIndexException("illegal row argument");
        }
        int ncols = this.getColumnDimension();
        double[] out = new double[ncols];
        for (int i = 0; i < ncols; ++i) {
            out[i] = this.data[row][i].doubleValue();
        }
        return out;
    }

    public BigDecimal[] getColumn(int col) throws MatrixIndexException {
        if (!this.isValidCoordinate(0, col)) {
            throw new MatrixIndexException("illegal column argument");
        }
        int nRows = this.getRowDimension();
        BigDecimal[] out = new BigDecimal[nRows];
        for (int i = 0; i < nRows; ++i) {
            out[i] = this.data[i][col];
        }
        return out;
    }

    public double[] getColumnAsDoubleArray(int col) throws MatrixIndexException {
        if (!this.isValidCoordinate(0, col)) {
            throw new MatrixIndexException("illegal column argument");
        }
        int nrows = this.getRowDimension();
        double[] out = new double[nrows];
        for (int i = 0; i < nrows; ++i) {
            out[i] = this.data[i][col].doubleValue();
        }
        return out;
    }

    public BigDecimal getEntry(int row, int column) throws MatrixIndexException {
        if (!this.isValidCoordinate(row, column)) {
            throw new MatrixIndexException("matrix entry does not exist");
        }
        return this.data[row][column];
    }

    public double getEntryAsDouble(int row, int column) throws MatrixIndexException {
        return this.getEntry(row, column).doubleValue();
    }

    public BigMatrix transpose() {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        BigMatrixImpl out = new BigMatrixImpl(nCols, nRows);
        BigDecimal[][] outData = out.getDataRef();
        for (int row = 0; row < nRows; ++row) {
            for (int col = 0; col < nCols; ++col) {
                outData[col][row] = this.data[row][col];
            }
        }
        return out;
    }

    public BigMatrix inverse() throws InvalidMatrixException {
        return this.solve(this.getIdentity(this.getRowDimension()));
    }

    public BigDecimal getDeterminant() throws InvalidMatrixException {
        if (!this.isSquare()) {
            throw new InvalidMatrixException("matrix is not square");
        }
        if (this.isSingular()) {
            return ZERO;
        }
        BigDecimal det = this.parity == 1 ? ONE : ONE.negate();
        for (int i = 0; i < this.getRowDimension(); ++i) {
            det = det.multiply(this.lu[i][i]);
        }
        return det;
    }

    public boolean isSquare() {
        return this.getColumnDimension() == this.getRowDimension();
    }

    public boolean isSingular() {
        if (this.lu == null) {
            try {
                this.luDecompose();
                return false;
            }
            catch (InvalidMatrixException ex) {
                return true;
            }
        }
        return false;
    }

    public int getRowDimension() {
        return this.data.length;
    }

    public int getColumnDimension() {
        return this.data[0].length;
    }

    public BigDecimal getTrace() throws IllegalArgumentException {
        if (!this.isSquare()) {
            throw new IllegalArgumentException("matrix is not square");
        }
        BigDecimal trace = this.data[0][0];
        for (int i = 1; i < this.getRowDimension(); ++i) {
            trace = trace.add(this.data[i][i]);
        }
        return trace;
    }

    public BigDecimal[] operate(BigDecimal[] v) throws IllegalArgumentException {
        if (v.length != this.getColumnDimension()) {
            throw new IllegalArgumentException("vector has wrong length");
        }
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        BigDecimal[] out = new BigDecimal[v.length];
        for (int row = 0; row < nRows; ++row) {
            BigDecimal sum = ZERO;
            for (int i = 0; i < nCols; ++i) {
                sum = sum.add(this.data[row][i].multiply(v[i]));
            }
            out[row] = sum;
        }
        return out;
    }

    public BigDecimal[] operate(double[] v) throws IllegalArgumentException {
        BigDecimal[] bd = new BigDecimal[v.length];
        for (int i = 0; i < bd.length; ++i) {
            bd[i] = new BigDecimal(v[i]);
        }
        return this.operate(bd);
    }

    public BigDecimal[] preMultiply(BigDecimal[] v) throws IllegalArgumentException {
        int nRows = this.getRowDimension();
        if (v.length != nRows) {
            throw new IllegalArgumentException("vector has wrong length");
        }
        int nCols = this.getColumnDimension();
        BigDecimal[] out = new BigDecimal[nCols];
        for (int col = 0; col < nCols; ++col) {
            BigDecimal sum = ZERO;
            for (int i = 0; i < nRows; ++i) {
                sum = sum.add(this.data[i][col].multiply(v[i]));
            }
            out[col] = sum;
        }
        return out;
    }

    public BigDecimal[] solve(BigDecimal[] b) throws IllegalArgumentException, InvalidMatrixException {
        int nRows = this.getRowDimension();
        if (b.length != nRows) {
            throw new IllegalArgumentException("constant vector has wrong length");
        }
        BigMatrixImpl bMatrix = new BigMatrixImpl(b);
        BigDecimal[][] solution = ((BigMatrixImpl)this.solve(bMatrix)).getDataRef();
        BigDecimal[] out = new BigDecimal[nRows];
        for (int row = 0; row < nRows; ++row) {
            out[row] = solution[row][0];
        }
        return out;
    }

    public BigDecimal[] solve(double[] b) throws IllegalArgumentException, InvalidMatrixException {
        BigDecimal[] bd = new BigDecimal[b.length];
        for (int i = 0; i < bd.length; ++i) {
            bd[i] = new BigDecimal(b[i]);
        }
        return this.solve(bd);
    }

    public BigMatrix solve(BigMatrix b) throws IllegalArgumentException, InvalidMatrixException {
        int j;
        int i;
        int col;
        if (b.getRowDimension() != this.getRowDimension()) {
            throw new IllegalArgumentException("Incorrect row dimension");
        }
        if (!this.isSquare()) {
            throw new InvalidMatrixException("coefficient matrix is not square");
        }
        if (this.isSingular()) {
            throw new InvalidMatrixException("Matrix is singular.");
        }
        int nCol = this.getColumnDimension();
        int nColB = b.getColumnDimension();
        int nRowB = b.getRowDimension();
        BigDecimal[][] bp = new BigDecimal[nRowB][nColB];
        for (int row = 0; row < nRowB; ++row) {
            for (int col2 = 0; col2 < nColB; ++col2) {
                bp[row][col2] = b.getEntry(this.permutation[row], col2);
            }
        }
        for (col = 0; col < nCol; ++col) {
            for (i = col + 1; i < nCol; ++i) {
                for (j = 0; j < nColB; ++j) {
                    bp[i][j] = bp[i][j].subtract(bp[col][j].multiply(this.lu[i][col]));
                }
            }
        }
        for (col = nCol - 1; col >= 0; --col) {
            for (int j2 = 0; j2 < nColB; ++j2) {
                bp[col][j2] = bp[col][j2].divide(this.lu[col][col], this.scale, this.roundingMode);
            }
            for (i = 0; i < col; ++i) {
                for (j = 0; j < nColB; ++j) {
                    bp[i][j] = bp[i][j].subtract(bp[col][j].multiply(this.lu[i][col]));
                }
            }
        }
        BigMatrixImpl outMat = new BigMatrixImpl(bp);
        return outMat;
    }

    public void luDecompose() throws InvalidMatrixException {
        int nCols;
        int nRows = this.getRowDimension();
        if (nRows != (nCols = this.getColumnDimension())) {
            throw new InvalidMatrixException("LU decomposition requires that the matrix be square.");
        }
        this.lu = this.getData();
        this.permutation = new int[nRows];
        for (int row = 0; row < nRows; ++row) {
            this.permutation[row] = row;
        }
        this.parity = 1;
        for (int col = 0; col < nCols; ++col) {
            int i;
            int row;
            BigDecimal sum = ZERO;
            for (int row2 = 0; row2 < col; ++row2) {
                sum = this.lu[row2][col];
                for (int i2 = 0; i2 < row2; ++i2) {
                    sum = sum.subtract(this.lu[row2][i2].multiply(this.lu[i2][col]));
                }
                this.lu[row2][col] = sum;
            }
            int max = col;
            BigDecimal largest = ZERO;
            for (row = col; row < nRows; ++row) {
                sum = this.lu[row][col];
                for (i = 0; i < col; ++i) {
                    sum = sum.subtract(this.lu[row][i].multiply(this.lu[i][col]));
                }
                this.lu[row][col] = sum;
                if (sum.abs().compareTo(largest) != 1) continue;
                largest = sum.abs();
                max = row;
            }
            if (this.lu[max][col].abs().compareTo(TOO_SMALL) <= 0) {
                this.lu = null;
                throw new InvalidMatrixException("matrix is singular");
            }
            if (max != col) {
                BigDecimal tmp = ZERO;
                for (i = 0; i < nCols; ++i) {
                    tmp = this.lu[max][i];
                    this.lu[max][i] = this.lu[col][i];
                    this.lu[col][i] = tmp;
                }
                int temp = this.permutation[max];
                this.permutation[max] = this.permutation[col];
                this.permutation[col] = temp;
                this.parity = -this.parity;
            }
            for (row = col + 1; row < nRows; ++row) {
                this.lu[row][col] = this.lu[row][col].divide(this.lu[col][col], this.scale, this.roundingMode);
            }
        }
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("BigMatrixImpl{");
        if (this.data != null) {
            for (int i = 0; i < this.data.length; ++i) {
                if (i > 0) {
                    res.append(",");
                }
                res.append("{");
                for (int j = 0; j < this.data[0].length; ++j) {
                    if (j > 0) {
                        res.append(",");
                    }
                    res.append(this.data[i][j]);
                }
                res.append("}");
            }
        }
        res.append("}");
        return res.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BigMatrixImpl)) {
            return false;
        }
        BigMatrix m = (BigMatrix)object;
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (m.getColumnDimension() != nCols || m.getRowDimension() != nRows) {
            return false;
        }
        for (int row = 0; row < nRows; ++row) {
            for (int col = 0; col < nCols; ++col) {
                if (this.data[row][col].equals(m.getEntry(row, col))) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int ret = 7;
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        ret = ret * 31 + nRows;
        ret = ret * 31 + nCols;
        for (int row = 0; row < nRows; ++row) {
            for (int col = 0; col < nCols; ++col) {
                ret = ret * 31 + (11 * (row + 1) + 17 * (col + 1)) * this.data[row][col].hashCode();
            }
        }
        return ret;
    }

    protected BigMatrix getIdentity(int dimension) {
        BigMatrixImpl out = new BigMatrixImpl(dimension, dimension);
        BigDecimal[][] d = out.getDataRef();
        for (int row = 0; row < dimension; ++row) {
            for (int col = 0; col < dimension; ++col) {
                d[row][col] = row == col ? ONE : ZERO;
            }
        }
        return out;
    }

    protected BigMatrix getLUMatrix() throws InvalidMatrixException {
        if (this.lu == null) {
            this.luDecompose();
        }
        return new BigMatrixImpl(this.lu);
    }

    protected int[] getPermutation() {
        int[] out = new int[this.permutation.length];
        System.arraycopy(this.permutation, 0, out, 0, this.permutation.length);
        return out;
    }

    private BigDecimal[][] copyOut() {
        int nRows = this.getRowDimension();
        BigDecimal[][] out = new BigDecimal[nRows][this.getColumnDimension()];
        for (int i = 0; i < nRows; ++i) {
            System.arraycopy(this.data[i], 0, out[i], 0, this.data[i].length);
        }
        return out;
    }

    private void copyIn(BigDecimal[][] in) {
        int nRows = in.length;
        int nCols = in[0].length;
        this.data = new BigDecimal[nRows][nCols];
        System.arraycopy(in, 0, this.data, 0, in.length);
        for (int i = 0; i < nRows; ++i) {
            System.arraycopy(in[i], 0, this.data[i], 0, nCols);
        }
        this.lu = null;
    }

    private void copyIn(double[][] in) {
        int nRows = in.length;
        int nCols = in[0].length;
        this.data = new BigDecimal[nRows][nCols];
        for (int i = 0; i < nRows; ++i) {
            for (int j = 0; j < nCols; ++j) {
                this.data[i][j] = new BigDecimal(in[i][j]);
            }
        }
        this.lu = null;
    }

    private void copyIn(String[][] in) {
        int nRows = in.length;
        int nCols = in[0].length;
        this.data = new BigDecimal[nRows][nCols];
        for (int i = 0; i < nRows; ++i) {
            for (int j = 0; j < nCols; ++j) {
                this.data[i][j] = new BigDecimal(in[i][j]);
            }
        }
        this.lu = null;
    }

    private boolean isValidCoordinate(int row, int col) {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        return row >= 0 && row < nRows && col >= 0 && col < nCols;
    }
}

