# -*- python -*-
# Class wrapper to the low level _tfm module
# $Id: tfm.py,v 1.4 2000/11/21 22:38:43 yotam Exp $

import tfmpkl;
import _tfm;

# header
lf =  0;
lh =  1;
bc =  2;
ec =  3;
nw =  4;
nh =  5;
nd =  6;
ni =  7;
nl =  8;
nk =  9;
ne = 10;
np = 11;
nLengths = 12;

# CharInfo - Tags
no_tag   = 0;
lig_tag  = 1;
list_tag = 2;
ext_tag  = 3;

# LigKern bytes
ligkern_byte_stop     = 0;
ligkern_byte_next     = 1;
ligkern_byte_op       = 2;
ligkern_byte_reminder = 3;

# Extensible bytes
exten_top = 0;
exten_mid = 1;
exten_bot = 2;
exten_rep = 3;

fixedFactor = 1./(1 << 20);

class tfm:
   def __init__(self, filename):
      self._o = _tfm.open(filename);
   def ok(self): 
      return _tfm.ok(self._o);
   def lengths(self): 
      return _tfm.lengths(self._o);
   def header(self, i): 
      return _tfm.header(self._o, i);
   def checksum(self):
      return self.header(0);
   def headdesignsize(self): 
      return _tfm.headdesignsize(self._o);
   def designsize(self): 
      return _tfm.designsize(self._o);
   def extraheader(self): 
      return _tfm.extraheader(self._o, ord(' '));
   def qextraheader(self): 
      return _tfm.extraheader(self._o, ord('?'));
   def charinfo(self, i): 
      return _tfm.charinfo(self._o, i);
   #
   def width(self, i): 
      return _tfm.width(self._o, i);
   def height(self, i): 
      return _tfm.height(self._o, i);
   def depth(self, i): 
      return _tfm.depth(self._o, i);
   def italic(self, i): 
      return _tfm.italic(self._o, i);
   #
   def maxwidth(self):
      return _tfm.maxwidth(self._o);
   def maxheight(self):
      return _tfm.maxheight(self._o);
   def maxdepth(self):
      return _tfm.maxdepth(self._o);
   def maxitalic(self):
      return _tfm.maxitalic(self._o);
	
   #
   def cwidth(self, c): 
      return _tfm.cwidth(self._o, c);
   def cheight(self, c): 
      return _tfm.cheight(self._o, c);
   def cdepth(self, c): 
      return _tfm.cdepth(self._o, c);
   def citalic(self, c): 
      return _tfm.citalic(self._o, c);
   #
   def listascend(self, i): 
      return _tfm.listascend(self._o, i);
   def ligkernowners(self, i): 
      return _tfm.ligkernowners(self._o, i);
   def ligkern(self, i): 
      return _tfm.ligkern(self._o, i);
   def kern(self, i): 
      return _tfm.kern(self._o, i);
   def exten(self, i): 
      return _tfm.exten(self._o, i);
   def params(self): # values via dict
      return _tfm.params(self._o);
   # The ligkernowners method return the _direct_ owner of a ligkern entry.
   # But if we want to consider all character that may use it, we have
   # to add all previous entries owners until we hit a LigKern-Stop.
   def ligkernusers(self, i):
      stop = 0;
      users = [];
      while not stop:
         oldusers = users; # keep natural original order, so append
         users = [];
         for o in self.ligkernowners(i):
            users.append(o);
         users = users + oldusers;
         i = i - 1;
         stop = (i < 0) or stopflag(self.ligkern(i));
      return users;
#

def kernflag(ligKernEntry):
   k = ((ligKernEntry[ligkern_byte_op] & 0x80) != 0);
   return k;
def stopflag(ligKernEntry):
   s = ((ligKernEntry[ligkern_byte_stop] & 0x80) != 0);
   return s;

