// $Id: debug.cc,v 1.1 2000/09/30 19:43:52 yotam Exp $
#if DEBUG

#include <string.h>
#include <pwd.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <iostream>
#include <fstream>
#include <string>

using namespace std;

////////////////////////////////////////////////////////////////////////
// To be called mostly once
static string
makeWaitFileName()
{
   uid_t       myUid = getuid();
   struct passwd* mypwd = getpwuid(myUid);
   return(string("/tmp/") + string(mypwd->pw_name) + string(".wait"));
} // makeWaitFileName


////////////////////////////////////////////////////////////////////////
void
waitOnFile(unsigned maxSleep)
{
   // static const char *waitfn = "/tmp/yotam.wait";
   static const string  waitfn = makeWaitFileName();
   static const char*   cs_waitfn = waitfn.c_str();
   struct stat          statbuf;
   time_t               oldtime;
   unsigned             slept = 0;

   cerr <<  "Process " << getpid() << " will wait until you touch " << 
	    waitfn << " or give up after " << maxSleep << " seconds." << endl;
                   
   stat(cs_waitfn, &statbuf);
   oldtime = statbuf.st_mtime;
   while (statbuf.st_mtime == oldtime && slept < maxSleep)
   {
      sleep(1);  slept++;
      stat(cs_waitfn, &statbuf);
   }
   cerr << "Sensed or gave up -  and continue..." << endl;
} /* waitOnFile */

#endif
