// $Id: ListDir.cc,v 1.2 2000/09/30 19:43:52 yotam Exp $
#include "ListDir.h"
#include <dirent.h>
#include <sys/stat.h>
#include <algorithm>
#include "PushDir.h"
#include "ChildDir.h"
#include "debug.h"


////////////////////////////////////////////////////////////////////////
ListDir::Filter  ListDir::defaultFilter;


////////////////////////////////////////////////////////////////////////
ListDir::ListDir(const std::string& dir, Filter& baseFilt, Filter& fullFilt)
{ DHERE;
   make(dir, baseFilt, fullFilt);
} // ListDir::ListDir


////////////////////////////////////////////////////////////////////////
void ListDir::sDel(void* vthis)
{ DHERE;
   ListDir* pLP = (ListDir*)vthis;
   delete pLP;
} // ListDir::sDel

////////////////////////////////////////////////////////////////////////
unsigned  ListDir::make
(
   const   std::string& dir, 
   Filter&              basenameFilter,
   Filter&              fullnameFilter
)
{ DHERE;
   _pBaseFilter = &basenameFilter;
   _pFullFilter = &fullnameFilter;
   clear();  DHERE;
   const char*  csDir = dir.c_str();
   unsigned     l = dir.size();
   char*        tDir = new char[l + 1];
   strcpy(tDir, csDir); DHERE;
   dirsp(0, tDir);
   delete [] tDir;
   return _entries.size();
} // ListDir::make


////////////////////////////////////////////////////////////////////////
void  ListDir::dirsp(void* pvdir, char* taildir)
{
   // Any "//" in taildir is interpreted as spanning the directory subtree.
   DIR*  tdir = (DIR*)pvdir;
   if (strlen(taildir))
   {
      char*  dblSlash = strstr(taildir, "//");
      int pathLen = _node.length();
      if (dblSlash)
      {
         *dblSlash = '\0'; // temporary trim
      }
      _node += taildir; 
      PushDir  pushdir(_node.c_str()); // will implicitly pop
      DIR*     dir = pushdir.dir();
      if (dir)
      {
         if (dblSlash)
         {
            tree(dir, dblSlash + 1);  // single / may be handy
         }
         else
         {
            addFiles(dir);
         }
         pushdir.pop();
      }
      _node.erase(pathLen);
      if (dblSlash)
      {
         *dblSlash = '/'; // restore  
      }
   }
   else if (tdir)
   {
      addFiles(tdir);
   }
} // ListDir::dirsp


////////////////////////////////////////////////////////////////////////
static bool
hasSubDirs(const char *snode)
{
   bool         has = false;
   struct stat  statNode;
   if (stat(snode, &statNode) == 0)
   {
      has = (statNode.st_nlink > 2); // Kpathsea trick
   }
   return(has);
} // hasSubDirs


////////////////////////////////////////////////////////////////////////
inline static bool
dotORdotdot(const char* node)
{
   bool dod = // inner loop - let's be efficient
              ((node[0] == '.') &&
                 ((node[1] == '\0') ||
                  ((node[1] == '.') && (node[2] == '\0'))
                 )
              );
   return(dod);
} // dotORdotdot


////////////////////////////////////////////////////////////////////////
void  ListDir::tree(void* pvdir, char* taildir)
{
   DIR*  tdir = (DIR*)pvdir;
   if (strlen(taildir) == 1) // == "/"
   {
      taildir = "";
   }
   dirsp(tdir, taildir);
   if (hasSubDirs(_node.c_str()))
   {
      struct dirent*  dent;
      rewinddir(tdir);
      while ((dent = readdir(tdir)) != 0)
      {
         const char* d_name = dent->d_name;
         if (!dotORdotdot(d_name))
         {
            ChildDir  childDir(_node, d_name); // push and implicit pop
            DIR*  dir = childDir.dir();
            if (dir)
            {
               tree(dir, taildir);
               childDir.pop();
            }
         }
      }
   }
} // ListDir::tree


////////////////////////////////////////////////////////////////////////
void  ListDir::addFiles(void* pvdir)
{
   DIR*  dir = (DIR*)pvdir;
   const char*  csNode = _node.c_str();
   std::string  sdirPrefix(csNode);
   if (csNode[0] == '.') // try to skip some leading ./
   {
      if (csNode[1] == '\0')
      {
         sdirPrefix = "";
      }
      else
      {
         if (csNode[1] == '/')
         {
            sdirPrefix = csNode + 2;
         }
      }
   }
   if (!sdirPrefix.empty())
   {
      sdirPrefix += '/';
   }
   const char*  dirPrefix = sdirPrefix.c_str();
   struct dirent*  dent;
   while ((dent = readdir(dir)) != 0)
   {
      const char* d_name = dent->d_name;
      if (!dotORdotdot(d_name))
      {
         addFile(dirPrefix, d_name);
      }
   }
} // ListDir::addFiles


////////////////////////////////////////////////////////////////////////
void ListDir::addFile(const char* dirPrefix, const char* basename)
{
   const char* filename = _node.c_str();
   bool  add = (strchr(filename, ' ') == 0); // ignore filenames with space
   add = add && ((_pBaseFilter == 0) || (*_pBaseFilter)(basename));
   if (add)
   {
      std::string  sfullname(std::string(dirPrefix) + std::string(basename));
      const char*  fullname = sfullname.c_str();
      add = add && ((_pFullFilter == 0) || (*_pFullFilter)(fullname));
      if (add)
      {
         _entries.push_back(sfullname);
      }
   }
} // LspathBlock::AddFile


