/* readpbm.c --- part of pbmtogf program

Copyright (C) 1998 Wai Wong

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  

Version 0.1 1998/03/31 Initial version
Version 1.0 1999/03/25 First public release version
*/

#include <stdio.h>
#include <string.h>

#define EXTERN extern
#include "pbmtogf.h"

#define COMMENT_CHAR '#'
#define PBM_MAGIC "P1"
#define PBMR_MAGIC "P4"
#define PBM 1
#define PBMR 4


char buf[MAXLINELEN];
int filetype = 0;



char *skip_comment(FILE *fp, char *cp)
{
    do{
      if((cp = fgets(buf, MAXLINELEN, fp)) == NULL)
	error(FATAL, "Error reading file");
      }while (*cp == COMMENT_CHAR);
}

char *get_num(char *cp, unsigned short *n)
{
  while(isspace(*cp)){
    if(*cp == '\0') return(cp);
    cp++;
  }

  do{
    if(!isdigit(*cp)) return(cp);
    *n = (*n) * 10 + (*cp -'0');
  }while(*(++cp));

  return(cp);
}

void readpixels(FILE *fp, char *pp, unsigned long nbytes)
{
  char c;
  short n = -1;

  do{
    do{
      c = fgetc(fp);
    }while(isspace(c));

    *pp++ = c -'0';
    }while(--nbytes);
}

void readrawpixels(FILE *fp, char *pp, unsigned long nbytes)
{
    char *cp = NULL;
    int b, i;

    if(debug) fprintf(stderr, "READRAWPIXELS:nbytes=%d\n", nbytes);
    cp = pp;
    while(((b = fgetc(fp)) != EOF) && (nbytes > 0))
      { 
	for(i = 8 ; i > 0; i--){
	  *(cp++) = ((b & 0x0080) == 0) ? 0 : 1;
	  b <<= 1;
	}
	nbytes--;
      }
    if(nbytes > 0){
      if(debug) fprintf(stderr,"nbytes=%d\n", nbytes);
      error(FATAL, "Unexpected end of file");
    }
}

void printpbm(FILE* fp, char *pp, unsigned short width, unsigned short height)
{
  unsigned long nbytes = width * height;
  unsigned w = width;

  fprintf(fp, "%.4d:", height--); 
  while( nbytes-- > 0){
    fprintf(fp, "%c", ((*pp++) == 0) ? '0' :'1');
    if((--w) == 0){
      fprintf(fp, "\n%.4d:", height--);
      w = width;
    }
  }
}

char *readpbm(FILE *fp)
{
  char *cp = NULL;
  char *pp = NULL;
  unsigned short width = 0;
  unsigned short height = 0;
  unsigned long nbytes = 0L;

  if((cp = fgets(buf, MAXLINELEN, fp)) == NULL)
    error(FATAL, "Error reading file type magic number");

  if(strncmp(buf, PBMR_MAGIC, 2) == 0){
    filetype = PBMR;
  }else if(strncmp(buf, PBM_MAGIC, 2) == 0){
    filetype = PBM;
  }else{
    error(FATAL, "NOT a pbm file");
  }

  /* read image size: width height */
  cp = skip_comment(fp, cp);
  cp = get_num(cp, &width);
  cp = get_num(cp, &height);
  img_wid = width; img_ht = height;
  if(debug)
    fprintf(stderr, "Image size is %d x %d=%d\n", width, height, width * height);

  /* allocate space for image data */
  nbytes = width * height + 8;
  if((pp = (char *) malloc((size_t)nbytes)) == NULL)
    error(FATAL, "Cannot allocate memory for image data");

  if(filetype == PBMR) readrawpixels(fp, pp, nbytes/8);
  else readpixels(fp, pp, nbytes-8);
  
  if(debug > 1) printpbm(stderr, pp, width, height);

  return(pp);
}

