*** UNDER DEVELOPMENT ***                         
DVItype change file for LN03 output
This change file has been produced by adding stuff to the Vax/VMS 
change file, originally due to David R. Fuchs. 
It was originally used to produce a special version of DVItype, the
outputs of which were further processed by LN03toPP.PLI, Author: Flavio Rose
of DEC Marlboro
Modified for DVItype version 2.6 by John Sauter, August 3, 1984.
Version 0.8, quick fix to correct bug in rule merging.
Version 0.9, another quick fix to match a Topp bug fix 
(c) 1986 Royal Military College of Science
The current version, still only experimental, was produced to combine
both these phases into one.
Modified for DVItype version 2.7 by B. Hamilton Kelly, March 1986.
(At Royal Military College of Science, Shrivenham, SWINDON, England.)
Minor cosmetic changes (eg 2048 rules, etc.) July 1987
Support for \special added September 1987
Extensive modifications July 88 and March 89.
Support for additional qualifiers August 89.
Support for \specials for changebars added by Robin Fairbairns.
Avoid problems with non-existent glyphs present in some fonts. (April 1990)
Tidy up processing of \special command arguments (December 1990)
Permit use of <physical units> in margin offsets
Avoid hard-wiring of TEX$... logical names
Support virtual fonts
Support \specials for landscape/portrait, mixed on one page
Draw solid rules for glyphs from missing fonts
Optimize access to doubly-indexed arrays, to speed processing
Support DEClaser 2100/2200 (duplex, tray selection, etc)
DVItoLN03 is now at version 4.1


Further work:
(suggestions possibly welcomed!)

@x <BHK 20-SEP-1991> Limbo
% Version 4.0    Cosmetic changes to error messages - new release!!!
@y
% Version 4.0    Cosmetic changes to error messages - new release!!!
% Version 4.0-1  Minor (?!) bug-fixes
% Version 4.0-2  Further corrections to indexing of messages
% Version 4.0-3  Correct bug that rejected fonts > 188 glyphs
% Version 4.0-4  Reorient rules as well as glyphs!
% Version 4.0-5  Need much closed attention to imaging area with mixed
%                orientations!
% Version 4.0-6  PFS commands reset OPM & margins, so need correction
% Version 4.0-7  Trouble caused by fonts which have duplicate characters
% Version 4.0-8  Ensure glyph position checking is against correct limits!
% Version 4.0-9  Add /PAPER_SIZE qualifier; correct duplexing last page
% Version 4.1    (Released 1 Oct 1991)  Added /[NO]VERBOSE qualifier
@z

@x <BHK 30-SEP-1991> Limbo
\def\title{DVI$\,$\lowercase{to}$\,$LN03 V4.0}
@y
\def\title{DVI$\,$\lowercase{to}$\,$LN03 V4.1}
@z

@x <BHK 30-SEP-1991> Limbo
  \centerline{(Version 4.0, 27th February 1991)}
@y
  \centerline{(Version 4.1, 30th September 1991)}
@z

@x <BHK 20-DEC-1990> Limbo
\let\maybe=\iftrue
%\let\maybe=\iffalse
@y Uncomment-out second next line if documentation required of changes only
\let\maybe=\iftrue
\let\maybe=\iffalse
@z

Provide support for /VERBOSE qualifier
@x <BHK 30-SEP-1991> S1.
\yskip\hang\&{V4.0} Supports the new DEClaser~2100 and~2200 printers (the
LN05 and LN06) in addition to the traditional LN03.  With the LN06, paper
feed trays may be selected from the command line, and the duplexing
facilities controlled also.  Support for these printers was provided by
Karsten Nyblad
@^Nyblad, Karsten@>
of TFL, the Danish Telecommunication Research Laboratory, and integrated
into this new release with the other features mentioned above.
@y
\yskip\hang\&{V4.0} Supports the new DEClaser~2100 and~2200 printers (the
LN05 and LN06) in addition to the traditional LN03.  With the LN06, paper
feed trays may be selected from the command line, and the duplexing
facilities controlled also.  Support for these printers was provided by
Karsten Nyblad
@^Nyblad, Karsten@>
of TFL, the Danish Telecommunication Research Laboratory, and integrated
into this new release with the other features mentioned above.
\yskip\hang\&{V4.1} Minor bug fixes; to support mixed orientation printing,
the program requires knowledge of the actual paper size upon which the
output is produced, so the \.{/PAPER\_SIZE} qualifier is introduced.  A
\.{/VERBOSE} qualifier is also introduced, such that sites requiring less
screen output can make the default \.{/NOVERBOSE}.
@z

@x <BHK 30-SEP-1991> S1.
@d banner=='This is DVItoLN03, Vax/VMS Version 4.0'
@y
@d banner=='This is DVItoLN03, Vax/VMS Version 4.1'
@z

Since OPM and margins must be reset after PFS sequences, need to define here
@x <BHK 22-APR-1991 and 20-SEP-1991> S5.
Whenever bitmaps are sent to the printer (in sixel format), it is necessary
to establish the ``printing'' position 29 pixels  above the current
reference point. Despite repeated enquiry of DEC, it has not been
established why this is necessary. Naturally, we call this 29 pixels
|bitmap_offset|.  This same offset also has to be applied to sixel graphics
included through a \.{\\special} command.

When the paper orientation is selected, we may define the |page_len| and
|page_wid| in terms of the physical limits of the paper; these sizes are
as follows (for European A4 paper).
@^European A4 paper@>
(These might later become variables, and be alterable by qualifiers in the
command line.)  There is, however, a further complication.  In either printing
orientation, the printable area is of these dimensions; however, this printing
area starts 0.25~inches from the top left corner of the paper \\{in the
orientation it enters the printer}.  Therefore in portrait mode, we can
actually print from (75,75) to (2475,3475), with (300,300) being the
``normal'' \TeX\ origin, but in landscape mode we can print (35,75) to
(3435,2475), and \TeX's origin should still be at (300,300).
@y
Whenever bitmaps are sent to the printer (in sixel format), it is necessary
to establish the ``printing'' position 29 pixels  below the current
reference point. This is because the printer, apparently arbitrarily, elects
to put the top of the first row of sixels at a height of 70~decipoints above
the current baseline: since DEC's `point' is what \TeX\ calls \.{1bp}, this
offset is $70\over720$in, or $29{1\over6}$ pixels. Naturally, we call this
|bitmap_offset|.  This same offset also has to be applied to sixel
graphics included through a \.{\\special} command.

When the paper orientation is selected, we may define the |page_len| and
|page_wid| in terms of the physical limits of the paper; these sizes are
as follows (for ISO [European] A4 and US letter-size paper).
@^European A4 paper@>
@^A4 (ISO, European) paper@>
@^ISO paper sizes@>
@^Paper sizes@>
@^US letter-size paper@>
Variables are set up with the appropriate set of values, depending upon the
value provided with the \.{/PAPER\_SIZE} qualifier.
@.PAPER\_SIZE@>
@:Qualifiers PAPER SIZE}{\quad\.{PAPER\_SIZE}@>
There is, however, a further complication.  In either printing
orientation, the printable area is of these dimensions; however, this printing
area starts 0.25~inches from the top left corner of the paper \\{in the
orientation it enters the printer}.  Therefore in portrait mode, we can
actually print from (75,75) to (2475,3475), with (300,300) being the
``normal'' \TeX\ origin, but in landscape mode we can print (33,75) to
(3433,2475), and \TeX's origin should still be at (300,300).  (The strange
figure 33 arises from DEC's handling of European A4~paper; with U.S. paper,
\\{without} OPM set, the printable area measures $2400\times3300$
[$8\times11$in], and has an even $1\over4$in margin all round: with A4
paper, the printable area, regardless of orientation, starts the same
$1\over4$in from the leading short edge of the paper, but the printable area
is extended to 3400 pixels $11{1\over3}$in, thus making the left-edge of the
printable area, in landscape orientation, lie $11{7\over12}$in from the
leading edge.  Since A4~paper is 297mm long, this position is therefore
$0{\cdot}10958$in, approximately 33~pixels, from the left-edge.)

This is also a convenient time to introduce certain non-printing control
characters, which will later be used to form control sequences and device
control strings (see ISO Std~2022)
@^ISO Standard 2022@>
for controlling device-specific functions of the printer.  The control
sequence defined by |DECOPM_on| sets DEC's Origin Positioning Mode, such
that dimensions are measured from the edge of the paper rather than the
origin of the printable area (defined by |image_wid@t$\times$@>image_ht|).
The |DECSLRM| macro produces code to set the left- and right-margins of the
printable area, whilst |DECSTBM| sets the top- and bottom-margins;
unfortunately, redefining the page format (through a \\{PFS}\dots sequence)
cancels the effect of all of these, so they must be re-issued anew whenever
the printing orientation is changed.
@z

Closer attention to detail of imaging area
@x <BHK 18-APR-1991 and 20-SEP-1991> S5.
@d paper_ht=3400                {in pixels}
@d paper_wid=2400
@d y_port_min=75
@d y_land_min=35
@d page_x_min=75
@d y_top=75       {Minimum addressable $y$ pixel}
@d y_bot=paper_ht+y_port_min {Maximum addressable $y$ pixel}
@y
@d A4_image_ht=3400    {in pixels (for European A4 paper)}
@d US_image_ht=3225    {in pixels (for American $8{1\over2}\times11$ paper)}
@d image_wid=2400   {(same value, 2400, for U.S. paper)}
@d y_port_min=75    {Lowest addressable $y$ in portrait mode (75)}
@d A4_y_land_min=33 {Lowest addressable $y$ in landscape mode}
@d US_y_land_min=0
@d page_x_min=75    {Lowest addressable $x$ in portrait mode}
@d A4_right_marg=5  {Distance from highest $x$ to right-edge in portrait mode}
@d US_right_marg=75
@d y_top=75       {Minimum addressable $y$ pixel}
@d y_bot==(image_ht+y_port_min) {Maximum addressable $y$ pixel in either mode}
@d paper_ht==(y_top+image_ht+y_land_min)  {Physical size of paper}
@d paper_wd==(page_x_min+image_wid+right_marg)
@d min_seg_y=0    {Lowest and highest addressable rows, either orientation\dots}
@d max_seg_y=3510 {and whatever the paper type; esed to declare |seg_list|}
@z

Since OPM and margins must be reset after PFS sequences, need to define here
@x <BHK 22-APR-1991> S5.
@d PFS_landscape=='?23 J' {Extended A4 paper in landscape orientation}
@d PFS_portrait=='?22 J'  {ditto in portrait; each preceded by |csi|}
@#
@y
@d esc==chr(@"1B)       {The ASCII ESCape character}
@d csi==chr(@"9B)       {Control Sequence Introducer}
@#
@d A4_PFS_landscape==csi+'?23 J' {Extended A4 paper in landscape orientation}
@d A4_PFS_portrait==csi+'?22 J'  {and portrait}
@#
@d US_PFS_landscape==csi+'?21 J' {Extended US letter paper in landscape orientation}
@d US_PFS_portrait==csi+'?20 J'  {and portrait}
@#
@d DECOPM_on==csi+'?52h'      {\&{Set} Origin Placement Mode}
@d DECSLRM(#)==csi,#:1,';',decslrm_end  {Set Left/Right Margins}
@d decslrm_end(#)==#:1,'s'
@d DECSTBM(#)==csi,#:1,';',decstbm_end  {Set Top/Bottom Margins}
@d decstbm_end(#)==#:1,'r'
@#
@z

Correct indexing of warning and error messages
@x <BHK 26-MAR-1991> S28.
@:fatal error Font not loaded TFM file}{\qquad\.{TFM file can't be opened}@>
@y
@:fatal error Font not loaded ...}{\quad\.{Font not loaded...}@>
@:fatal error Font not loaded TFM file}{\qquad\.{TFM file can't be opened}@>
@z

Correct indexing of warning and error messages
@x <BHK 26-MAR-1991> S41.
9997: error('---not loaded, TFM file is bad');
@.TFM file is bad@>
@y
9997: error('---not loaded, TFM file is bad');
@:Error: TFM file is bad}{\quad\.{TFM file is bad}@>
@z

Introduce additional variables to support two differing paper sizes
@x <BHK 20-SEP-1991> S54.
@!orientation,@!new_orient,@!cur_orient : page_orientation;
@y
@!orientation,@!new_orient,@!cur_orient : page_orientation;
@!paper_size : page_sizes;
@!image_ht, @!y_land_min, @!right_marg : integer;
@z

Introduce additional enumeration type
@x <BHK 20-SEP-1991> S55.
@ This type allows us to keep track of whether characters are currently
being imaged in landscape or portrait orientation.

@<Types...@>=
@!page_orientation = (@!portrait,@!landscape);
@y
@ These types allow us to note for what paper size the printer has been
configured, and to keep track of whether characters are currently being
imaged in landscape or portrait orientation. 

@<Types...@>=
@!page_sizes = (@!A4,@!US);
@!page_orientation = (@!portrait,@!landscape);
@z

Cosmetic change of module name
@x <BHK 20-SEP-1991> S65.
@<Determine the desired |orientation|@>;
@y
@<Determine the desired |orientation| and paper size@>;
@z

Correct usage to explicit |term_out|
@x <BHK 30-SEP-1991> S70.
    write_ln(' --- assuming pixel units',crlf);
@y
    write_ln(term_out,' --- assuming pixel units',crlf);
@z

Correct usage to explicit |term_out|
@x <BHK 30-SEP-1991> S70.
    write_ln(' --- assuming pixel units',crlf);
@y
    write_ln(term_out,' --- assuming pixel units',crlf);
@z

Closer attention to detail of imaging area; use macros for application
elsewhere.  Support /PAPER_SIZE qualifier
@x <BHK 18-APR-1991, 10-MAY-1991 & 20-SEP-1991> S72.
@<Determine the desired |orientation|@>=
if odd(VAX_cli_present('ORIENTATION')) then
begin
  if odd(VAX_cli_present('PORTRAIT')) then orientation:=portrait else
  if odd(VAX_cli_present('LANDSCAPE')) then orientation:=landscape else
  warning('/ORIENTATION must be "PORTRAIT" or "LANDSCAPE"; assuming "PORTRAIT"')
@:Warning: orientation must be}{\quad \.{/ORIENTATION must be ...}@>
end;
if orientation=landscape then
begin page_len:=paper_wid+page_x_min; page_wid:=paper_ht+y_land_min;
  y_min:=page_x_min; x_min:=y_land_min end else
begin page_len:=paper_ht+y_port_min; page_wid:=paper_wid+page_x_min;
  y_min:=y_port_min; x_min:=page_x_min end;
@y
@d set_landscape_limits==begin page_len:=image_wid+page_x_min;
                           page_wid:=image_ht+y_land_min;
                           y_min:=page_x_min;
                           x_min:=y_land_min
                         end
@d set_portrait_limits==begin page_len:=image_ht+y_port_min;
                          page_wid:=image_wid+page_x_min;
                          y_min:=y_port_min;
                          x_min:=page_x_min
                        end

@<Determine the desired |orientation| and paper size@>=
if odd(VAX_cli_present('PAPER_SIZE.US')) then
begin {Using US letter-size paper $11\times8{1\over2}$in}
  image_ht := US_image_ht; y_land_min := US_y_land_min;
  right_marg := US_right_marg; paper_size := US;
end else
begin {Assume ISO A4 paper size $297\times210$mm}
  image_ht := A4_image_ht; y_land_min := A4_y_land_min;
  right_marg := A4_right_marg; paper_size := A4;
end;
if odd(VAX_cli_present('ORIENTATION')) then
begin
  if odd(VAX_cli_present('PORTRAIT')) then orientation:=portrait else
  if odd(VAX_cli_present('LANDSCAPE')) then orientation:=landscape else
  warning('/ORIENTATION must be "PORTRAIT" or "LANDSCAPE"; assuming "PORTRAIT"')
@:Warning: orientation must be}{\quad \.{/ORIENTATION must be ...}@>
end;
if orientation=landscape then set_landscape_limits else set_portrait_limits;
@z

Correct usage to explicit |term_out|
@x <BHK 30-SEP-1991> S73.
    write_ln(' --- assuming scaled points',crlf);
@y
    write_ln(term_out,' --- assuming scaled points',crlf);
@z

Correct usage to explicit |term_out|
@x <BHK 30-SEP-1991> S73.
    write_ln(' --- assuming scaled points',crlf);
@y
    write_ln(term_out,' --- assuming scaled points',crlf);
@z

Correct indexing of warning message
@x <BHK 25-MAR-1991> S87.
@:Warning: checksum doesn't match}{\quad\.{checksum doesn't match}@>
@y
@:Warning: checksum doesn\'t match ...}{\quad\.{checksum doesn't match...}@>
@:Warning: checksum doesn\'t match previous def}{\qquad\.{previous definition}@>
@z

Correct indexing of warning message
@x <BHK 25-MAR-1991> S91.
@:Warning: checksum doesn\'t match}{\quad\.{checksum doesn't match}@>
@y
@:Warning: checksum doesn\'t match in TFM file}{\qquad\.{in TFM file}@>
@z

Closer attention to detail of imaging area
@x <BHK 18-APR-1991 & 20-SEP-1991> S94.
  @!seg_list : array [y_land_min..paper_ht+y_port_min] of ^segment;
@y
  @!seg_list : array [min_seg_y..max_seg_y] of ^segment;
@z

Closer attention to detail of imaging area
@x <BHK 18-APR-1991> S95.
  for k:=y_land_min to paper_ht+y_port_min do seg_list[k]:=nil;
@y
  for k:=y_land_min to image_ht+y_port_min do seg_list[k]:=nil;
@z

Some of these characters are now defined much earlier
@x <BHK 22-APR-1991> S101.
@d esc==chr(@"1B)       {The ASCII ESCape character}
@d csi==chr(@"9B)       {Control Sequence Introducer}   
@y
@z

Note whether the character packet was used \\{this time}
@x <BHK 02-MAY-1991> S129.
ch_loc[char_num]:=end_of_packet-packet_length;
with glyph_map(TeX_font)(char_num) do
  if loaded=wanted then
  begin
     base:=ras_beg+ras_len;@/
     @<Process |tfm_width| information@>;
     @<Validate size of character's glyph@>;
     @<Complete remainder of Character Definition parameters@>;
     @<Read and translate raster description@>;
     @<Calculate the number of bytes of rasters transferred@>;
     @<Complete the entry in the font character directory@>
@y
packet_used:=false;
with glyph_map(TeX_font)(char_num) do
  if loaded=wanted then
  begin
     base:=ras_beg+ras_len;@/
     @<Process |tfm_width| information@>;
     @<Validate size of character's glyph@>;
     @<Complete remainder of Character Definition parameters@>;
     @<Read and translate raster description@>;
     @<Calculate the number of bytes of rasters transferred@>;
     @<Complete the entry in the font character directory@>;
     packet_used:=true
@z

Ensure first record of an included sixels file can be 256 chars long
Provide support for /VERBOSE qualifier
@x <BHK 25-MAR-1991 & 30-SEP-1991> S179.
    monitor(' ('+def_file_name);
    print_ln('Sixel graphics included from: ',def_file_name);
@.Sixel graphics included...@>
    reset(sixel_file);
    write(ln3_file,csi,y_position:1,'d',csi,cur_seg^.xs:1,'`');
@y
    if verbose then monitor(' ('+def_file_name);
    print_ln('Sixel graphics included from: ',def_file_name);
@.Sixel graphics included...@>
    reset(sixel_file);
    write_ln(ln3_file,csi,y_position:1,'d',csi,cur_seg^.xs:1,'`');
@z

Provide support for /VERBOSE qualifier
@x <BHK 30-SEP-1991> S179.
    monitor(') ');
@y
    if verbose then monitor(') ');
@z

Closer attention to detail of imaging area
PFS commands reset OPM and margin, so must override.  Track paper size
@x <BHK 22-APR-1991> S183.
    write_ln(ln3_file,csi,PFS_landscape);
    page_len:=paper_wid+page_x_min; page_wid:=paper_ht+y_land_min;
    y_min:=page_x_min; x_min:=y_land_min
  end else
  begin
    write_ln(ln3_file,csi,PFS_portrait);
    page_len:=paper_ht+y_port_min; page_wid:=paper_wid+page_x_min;
    y_min:=y_port_min; x_min:=page_x_min
@y
    if paper_size = US then
      write(ln3_file,US_PFS_landscape,DECOPM_on)
    else
      write(ln3_file,A4_PFS_landscape,DECOPM_on);
    set_landscape_limits;
    write_ln(ln3_file,DECSLRM(x_min)(page_wid),DECSTBM(y_min)(page_len))
    {Set page limits}
  end else
  begin
    if paper_size = US then
      write(ln3_file,US_PFS_portrait,DECOPM_on)
    else
      write(ln3_file,A4_PFS_portrait,DECOPM_on);
    set_portrait_limits;
    write_ln(ln3_file,DECSLRM(x_min)(page_wid),DECSTBM(y_min)(page_len))
    {Set page limits}
@z

Correct handling of last recto page when duplexing
@x <BHK (from Karsten Nyblad) 20-SEP-1991> S196.
  if ptr_blanks>0 then
    if blank_follows[ptr_blanks]=cur_loc_after_bop then
    begin
      decr(ptr_blanks); {and remain in simplex mode}
      if print_mode>=duplex_master_normal then
        write(ln3_file,' ',FF) {eject blank page for \\{verso} master}
    end else
    begin
      write(ln3_file,csi,print_mode:1,' x');
      duplex_to_be_reset:=false
    end
@y
  begin
    duplex_to_be_reset:=false;
    if ptr_blanks>0 then
      if blank_follows[ptr_blanks]=cur_loc_after_bop then
      begin
        decr(ptr_blanks); {and remain in simplex mode}
        duplex_to_be_reset:=true;
        if print_mode>=duplex_master_normal then
          write(ln3_file,' ',FF) {eject blank page for \\{verso} master}
      end else
        write(ln3_file,csi,print_mode:1,' x')
    else
      write(ln3_file,csi,print_mode:1,' x')
  end
@z

Correct indexing of warning and error messages
@x <BHK 26-MAR-1991> S209.
warning('more than ',max_rules:1,' rules on page; excess ignored!');
@.more than ... rules@>
@y
warning('more than ',max_rules:1,' rules on page; excess ignored!');
@:Warning: more than ... rules}{\quad\.{more than ... rules}@>
@z

Correct orientation of rules written when orientation=landscape
@x <BHK 18-APR-1991> S209.
with page_rules[rules_on_page] do begin
        horiz := hhh; vert := vvv; height := hheight;
        width := wwidth; covered := false;
          end;
@y
with page_rules[rules_on_page] do
  if new_orient=orientation then
    begin
        horiz := hhh; vert := vvv; height := hheight;
        width := wwidth; covered := false;
    end else
    if new_orient=landscape then
      begin {landscape rule will be output in portrait orientation}
          vert := paper_ht-hhh-left_marg-top_marg;
          horiz := vvv-hheight+top_marg-left_marg;
          width := hheight; height := wwidth; covered := false;
      end else {portrait rule output in landscape}
      begin
          vert := hhh-wwidth+left_marg-top_marg;
          horiz := paper_ht-vvv-left_marg-top_marg;
          width := hheight; height := wwidth; covered := false;
      end;
@z

Correct indexing of warning and error messages
@x <BHK 26-MAR-1991> S233.
pre: begin error('preamble command within a page!'); goto 9998;
  end;
@.preamble command within a page@>
post,post_post: begin error('postamble command within a page!'); goto 9998;
@.postamble command within a page@>
  end;
othercases begin error('undefined command ',o:1,'!');
  goto done;
@.undefined command@>
@y
pre: begin error('preamble command within a page!'); goto 9998;
  end;
@:Error: preamble command within a page}{\quad\.{preamble command within a page}@>
post,post_post: begin error('postamble command within a page!'); goto 9998;
@:Error: postamble command within a page}{\quad\.{postamble command within a page}@>
  end;
othercases begin error('undefined command ',o:1,'!');
  goto done;
@:Error: undefined command}{\quad\.{undefined command}@>
@z

Correct indexing of warning and error messages
@x <BHK 26-MAR-1991> S234.
@<Cases for commands |nop|, |bop|, \dots, |pop|@>=
nop: goto done;
bop: begin error('bop occurred before eop!'); goto 9998;
@.bop occurred before eop@>
@y
@<Cases for commands |nop|, |bop|, \dots, |pop|@>=
nop: goto done;
bop: begin error('bop occurred before eop!'); goto 9998;
@:Error: bop occurred before eop}{\quad\\{bop }\.{occurred before }\\{eop}@>
@z

Correct orientation of rules written when orientation=landscape
@x <BHK 18-APR-1991> S234.
      @<Combine and...@>@;
      do_page:=true;@/
      @<Output contents of page@>;@/
      write(ln3_file,LF);               {LF after page}
      new_orient:=orientation;
      @<Change page orientation@>;      {reset, if necessary}
@y
      do_page:=true;@/
      @<Output contents of page@>;@/
      new_orient:=orientation;
      @<Change page orientation@>;      {reset, if necessary}
      @<Combine and...@>@;      {Rules always output in default orientation}
      write(ln3_file,LF);               {LF after page}
@z

Change imaging area limits whenever the orientation is changed
@x <BHK 10-MAY-1991> S244.
@<Match the \meta{function name} in a \.{\\special}@>=
case spec_cmd of
  spec_land: new_orient:=landscape; {|'landscape'| or |'ln03:landscape'|}
  spec_port: new_orient:=portrait;  {|'portrait'| or |'ln03:portrait'|}
@y
@<Match the \meta{function name} in a \.{\\special}@>=
case spec_cmd of
  spec_land: begin new_orient:=landscape; {|'landscape'| or |'ln03:landscape'|} 
               set_landscape_limits
             end;
  spec_port: begin new_orient:=portrait;  {|'portrait'| or |'ln03:portrait'|}
               set_portrait_limits
             end;
@z

Correct indexing of warning and error messages
@x <BHK 26-MAR-1991> S246.
@ @<Finish a command that either sets or puts a character...@>=
if p<0 then p:=255-((-1-p) mod 256)
else if p>=256 then p:=p mod 256; {width computation for oriental fonts}
@^oriental characters@>@^Chinese characters@>@^Japanese characters@>
if (p<font_bc[cur_font])or(p>font_ec[cur_font]) then q:=invalid_width
else q:=cur_font_glyph(p).width;
if q=invalid_width then
  begin error('character ',p:1,' invalid in font ');
@.character $c$ invalid...@>
@y
@ @<Finish a command that either sets or puts a character...@>=
if p<0 then p:=255-((-1-p) mod 256)
else if p>=256 then p:=p mod 256; {width computation for oriental fonts}
@^oriental characters@>@^Chinese characters@>@^Japanese characters@>
if (p<font_bc[cur_font])or(p>font_ec[cur_font]) then q:=invalid_width
else q:=cur_font_glyph(p).width;
if q=invalid_width then
  begin error('character ',p:1,' invalid in font ');
@:Error: character $c$ invalid...}{\quad\.{character $c$ invalid...}@>
@z

Correct indexing of warning and error messages
@x <BHK 26-MAR-1991> S248.
@<Finish a command that sets |h:=h+q|, then |goto done|@>=
if (h>0)and(q>0) then if h>infinity-q then
  begin error('arithmetic overflow! parameter changed from ',@|
@.arithmetic overflow...@>
@y
@<Finish a command that sets |h:=h+q|, then |goto done|@>=
if (h>0)and(q>0) then if h>infinity-q then
  begin error('arithmetic overflow! parameter changed from ',@|
@:Error: arithmetic overflow...}{\quad\.{arithmetic overflow...}@>
@z

Correct indexing of warning and error messages
@x <BHK 26-MAR-1991> S251.
@ @<Finish a command that sets |v:=v+p|, then |goto done|@>=
if (v>0)and(p>0) then if v>infinity-p then
  begin error('arithmetic overflow! parameter changed from ',
@.arithmetic overflow...@>
@y
@ @<Finish a command that sets |v:=v+p|, then |goto done|@>=
if (v>0)and(p>0) then if v>infinity-p then
  begin error('arithmetic overflow! parameter changed from ',
@:Error: arithmetic overflow...}{\quad\.{arithmetic overflow...}@>
@z

Provide support for /VERBOSE qualifier
@x <BHK 30-SEP-1991> S255.
  monitor('Gathering font usage statistics...');
@y
  if verbose then monitor('Gathering font usage statistics...');
@z

Certain control sequences now defined in \S5
@x <BHK 22-APR-1991> S266.
character; whilst the end of the font download is marked by the |ST| (String
Terminator) character --- this is preceded by a textual comment.
@y
character; whilst the end of the font download is marked by the |ST| (String
Terminator) character --- this is preceded by a textual comment.

Finally, we define the printable area, and designate up to ten downloaded
fonts to be accessible through |SGR| control sequences.
@z

Certain control sequences now defined in \S5
@x <BHK 22-APR-1991> S266.
{Set page limits}
write(ln3_file,csi,x_min:1,';',page_wid:1,'s',csi,y_min:1,';',page_len:1,'r');
@<Designate first 10 fonts to SGRs |10..19|@>@;
@y
write(ln3_file,DECSLRM(x_min)(page_wid),DECSTBM(y_min)(page_len));
{Set page limits}
@<Designate first 10 fonts to SGRs |10..19|@>@;
@z

Certain control sequences now defined in \S5
@x <BHK 22-APR-1991> S267.
@ We start by writing the LN03 directives to the front of the file.  Since the
introduction of the LN03-Plus, this has been made more complicated, because
the sequence |esc, 'c'| is meaningful (and \&{not} as |RIS|!) when the
LN03-Plus is in the Tektronix emulation mode.  Therefore, we start off by
outputting the sequence |esc, '[!p'| which is DEC's private ``soft terminal
reset'' (|DSCSTR|).  (Note that this sequence uses the ``long-winded'' way of
specifying |csi|; this is because the LN03-plus ignores the eigth bit when it
is emulating a Tektronix terminal.)  However, this won't necessarily reset an
`ordinary' LN03, so we output the ISO-standard |RIS| (Reset Initial State
$\equiv$ |esc,'c'|) sequence as well.

There then follow a number of control sequences which set up further
characteristics of the LN03: (1) |'?27h'| is a DEC private control sequence,
|DECPSP|, which selects proportional spacing mode, whereby the printer moves
forward by the recorded width of the character glyph rather than by some fixed
amount after printing; (2) |'11h'| \&{set}s the |PUM| (Positioning Unit Mode),
when set, this mode indicates that ``cursor movement'' sequences work in units
of either decipoints or pixels, which of these is determined by (3) |'7 I'|
which sets the |SSU| (Select Size Unit) to be in units of a single pixel; (4)
|'?52h'| is another DEC private sequence, \&{set}ting the |DECOPM| (Origin
Placement Mode) which places the origin for all measurement to the upper-left
corner of the physical page (the alternative is 0.25 inches from that point).
Finally, the sequence ending in |'t'| contains the |page_len| as a parameter,
and is another DEC private control sequence which sets the |DECLPP| (Lines per
Physical Page) to be the height of the printable area, in pixels.

@d DECSTR==esc+'[!p'
@d RIS==esc+'c'
@d DECPSP_on==csi+'?27h'
@d PUM_on==csi+'11h'
@d SSU_pixel==csi+'7 I'
@d DECOPM_on==csi+'?52h'

@<Generate \.{LN3} file header@>=
if orientation=landscape then
  write_ln(ln3_file,DECSTR,RIS,csi,PFS_landscape)
else
  write_ln(ln3_file,DECSTR,RIS,csi,PFS_portrait);
@y
@ We start by writing the LN03 directives to the front of the file.  Since the
introduction of the LN03-Plus, this has been made more complicated, because
the sequence |esc, 'c'| is meaningful (and \&{not} as |RIS|!) when the
LN03-Plus is in the Tektronix emulation mode.  Therefore, we start off by
outputting the sequence |esc, '[!p'| which is DEC's private ``soft terminal
reset'' (|DSCSTR|).  (Note that this sequence uses the ``long-winded'' way of
specifying |csi|; this is because the LN03-Plus ignores the eighth bit when it
is emulating a Tektronix terminal.)  However, this won't necessarily reset an
`ordinary' LN03, so we output the ISO-standard |RIS| (Reset Initial State
$\equiv$ |esc,'c'|) sequence as well.

After setting the correct printing orientation, there then follow a number
of control sequences which set up further characteristics of the LN03: (1)
|'?27h'| is a DEC private control sequence, |DECPSP|, which selects
proportional spacing mode, whereby the printer moves forward by the recorded
width of the character glyph rather than by some fixed amount after
printing; (2) |'11h'| \&{set}s the |PUM| (Positioning Unit Mode), when set,
this mode indicates that ``cursor movement'' sequences work in units of
either decipoints or pixels, which of these is determined by (3) |'7 I'|
which sets the |SSU| (Select Size Unit) to be in units of a single pixel;
(4) the |DECOPM| (Origin Placement Mode) is \&{set}, which places the origin
for all measurement to the upper-left corner of the physical page (the
alternative is 0.25 inches from that point). Finally, the sequence ending in
|'t'| contains the |page_len| as a parameter, and is another DEC private
control sequence which sets the |DECLPP| (Lines per Physical Page) to be the
height of the printable area, in pixels.

@d DECSTR==esc+'[!p'
@d RIS==esc+'c'
@d DECPSP_on==csi+'?27h'
@d PUM_on==csi+'11h'
@d SSU_pixel==csi+'7 I'

@<Generate \.{LN3} file header@>=
if orientation=landscape then
  if paper_size = US then
    write_ln(ln3_file,DECSTR,RIS,US_PFS_landscape)
  else
    write_ln(ln3_file,DECSTR,RIS,A4_PFS_landscape)
else
  if paper_size = US then
    write_ln(ln3_file,DECSTR,RIS,US_PFS_portrait)
  else
    write_ln(ln3_file,DECSTR,RIS,A4_PFS_portrait);
@z

Provide support for /VERBOSE qualifier
@x <BHK 30-SEP-1991> S283.
    write_ln(term_out,' is virtual',crlf);@/
@y
    if verbose then write_ln(term_out,' is virtual',crlf);@/
@z

Provide support for /VERBOSE qualifier
@x <BHK 30-SEP-1991> S316.
  @<Report name of font file in use@> ;
  if file_type=unavailable then
    write(' unavailable; printing rules for glyphs;');
  print(' with '); write_ln(term_out,' loaded with ');
@y
  @<Report name of font file in use@> ;
  if file_type=unavailable then
  begin
    if not verbose then
    begin
      write(term_out,'Font ',name);
      if percent <> 100 then write(term_out,' (at ',percent:1,'%)')
    end;
    write(term_out,' unavailable; printing rules for glyphs;');
    if not verbose then write_ln(term_out,crlf);
  end;
  print(' with '); if verbose then write_ln(term_out,' loaded with ');
@z

Suppress checksum warning if either file has zero
@x <BHK 25-MAR-1991> S320.
  if font_check_sum[TeX_font]<>checksum then
      warning('checksum doesn''t match in PK file')
@.checksum doesn't match in PK file@>
@y
  if (font_check_sum[TeX_font]<>0) and (checksum<>0) and
     (font_check_sum[TeX_font]<>checksum) then
      warning('checksum doesn''t match in PK file')
@:Warning: checksum doesn\'t match in PK file}{\qquad\.{in PK file}@>
@z

Provide support for /VERBOSE qualifier
@x <BHK 30-SEP-1991> S321.
write(term_out,'Font ',name);
if percent<> 100 then write(' (at ',percent:1,'%)');
@y
if verbose then
begin
  write(term_out,'Font ',name);
  if percent<> 100 then write(term_out,' (at ',percent:1,'%)');
end;
@z

Must increment character counter if we're making dummy directory entry
@x <BHK 02-MAY-1991> S325.
@<Generate dummy directory entry for font that won't be used@>=
begin
  @<Create null character locator entry@>;
  loaded:=yes
end
@y
@<Generate dummy directory entry for font that won't be used@>=
begin
  @<Create null character locator entry@>;
  incr(first_txfc); loaded:=yes
end
@z

Scream if raster file contains character outside font
Check if glyph has been previously processed
@x <BHK 25-MAR, 02-MAY-1991> S328.
@<Copy glyph from packed file, and find the next one@>=
begin
  repeat
    @<Unpack and write...@>;
    skip_specials
  until (glyph_map(TeX_font)(char_num).loaded<>unused) or
        (flag_byte=pk_post);
  with glyph_map(TeX_font)(char_num) do
  if loaded<>unused then
  begin
    char_code:=first_txfc;
    font_code:=ln_font;
    incr(first_txfc)    {This might later be corrected}
  end;
@y
@<Copy glyph from packed file, and find the next one@>=
begin
  repeat
    @<Unpack and write...@>;
    skip_specials;
    if (flag_byte<>pk_post) then
    begin
      if (char_num<font_bc[TeX_font]) or (char_num>font_ec[TeX_font]) then
        abort('bad pk file, illegal character (',char_num:1,')');
@:fatal error Bad pk file illegal character}{\qquad\.{illegal character}@>
      if not packet_used then {Packet wasn't copied...}
        if (glyph_map(TeX_font)(char_num).loaded<>unused) then
          warning('glyph ',char_num:1,
                        ' has multiple definitions; later one(s) ignored')
@:warning glyph has multiple}{\quad\.{glyph $c$ has multiple definitions}@>
    end
  until packet_used or (flag_byte=pk_post);
  with glyph_map(TeX_font)(char_num) do
  if loaded<>unused then
  begin
    char_code:=first_txfc;
    font_code:=ln_font;
    incr(first_txfc) {Count character added to directory, etc}
  end;
@z

Suppress checksum warning if either file has zero
@x <BHK 25-MAR-1991> S333.
@<Read character directory from |pxl_file|@>=

move_to_pxl(pxl_size-16);
if font_check_sum[TeX_font]<>long_pxl(pxl_ptr) then
  warning('checksum doesn''t match in PXL file');
@.checksum doesn't match in PXL file@>
@y
@<Read character directory from |pxl_file|@>=
move_to_pxl(pxl_size-16); i:=long_pxl(pxl_ptr); {Read checksum from file}
if (font_check_sum[TeX_font]<>0) and (i<>0) and
   (font_check_sum[TeX_font]<>i) then
  warning('checksum doesn''t match in PXL file');
@:Warning: checksum doesn\'t match in PXL file}{\qquad\.{in PXL file}@>
@z

Correct bug with fonts that require an overflow beyond 188 glyphs
@x <BHK 17-APR-1991> S334.
The character numbers will be those of the LN03 font file, having already been
mapped to these during the mapping phase; therefore, if the lowest character
number used is |= left_first| then we must be starting a new font, so must
initialize the empty font file and indicate that this is a |GL| font
(left-hand half of eight-bit character table).

@<Determine lowest and highest characters used in the \TeX\ font@>=
first_txfc:=-1; last_txfc:=-1;      {For |ln_font|}
@y
The character numbers will be those of the LN03 font file, having already been
mapped to these during the mapping phase; therefore, if the lowest character
number used is |= left_first| then we must be starting a new font, so must
initialize the empty font file and indicate that this is a |GL| font
(left-hand half of eight-bit character table).

If the \TeX\ font contained more than 188 glyphs that were used, it will
have been mapped to \&{two} LN03 fonts: |overflow_font| will be set true
when determining which characters were used in the overflow portion (the
first font using all of |left_first..right_first| and
|left_last..right_last|, since such a large font will never be ``fitted in''
along with other fonts mapped to an LN03 font.

@<Determine lowest and highest characters used in the \TeX\ font@>=
first_txfc:=-1; last_txfc:=-1; overflow_font:=false;    {For |ln_font|}
@z

Correct bug with fonts that require an overflow beyond 188 glyphs
@x <BHK 17-APR-1991> S335.
@ As we cycle through all the allocated characters, we note each code in turn,
thus determining the highest code used.  We also note the lowest one when we
meet the first code used.  If the |TeX_font| extends into a second |ln_font|,
the corresponding information will be recorded in |final_txfc| and |txfc_next|,
respectively.

@<Note |last_txfc|, and set |first_txfc| for first character@>=
if loaded = wanted then
begin if txf_to_lnf[font_code]=ln_font then
  begin if first_txfc=-1 then first_txfc:=char_code;
    last_txfc:=char_code; font_code:=ln_font
  end
@y
@ As we cycle through all the allocated characters, we note each code in turn,
thus determining the highest code used (if this is |right_last| then any
subsequent character \\{in this font} will belong to the overflow portion,
in font |ln_font+1|).  We also note the lowest one when we
meet the first code used.  If the |TeX_font| extends into a second |ln_font|,
the corresponding information will be recorded in |final_txfc| and |txfc_next|,
respectively.

@<Note |last_txfc|, and set |first_txfc| for first character@>=
if loaded = wanted then
begin if not overflow_font then
  begin if first_txfc=-1 then first_txfc:=char_code;
    last_txfc:=char_code; font_code:=ln_font;
    overflow_font:= char_code=right_last
  end
@z

Correct bug with fonts that require an overflow beyond 188 glyphs
@x <BHK 17-APR-1991> S337.
\yskip\hang|end_txf| This is |true| if the last character of the present
|TeX_font| is the last character mapped to |ln_font|.

@<Local variables of |add_txf_to_lnf|@>==
@!first_txfc, @!last_txfc : integer;
@!txfc_next, @!final_txfc : integer;
@!begin_txf, @!end_txf : boolean;
@y
\yskip\hang|end_txf| This is |true| if the last character of the present
|TeX_font| is the last character mapped to |ln_font|.

\yskip\hang|overflow_font| Set |true| when we're determining the first and
last characters used in the second LN03 font (|ln_font+1|) into which a font
of more than 188 glyphs has overflowed.

\yskip\hang|packet_used| Set |true| iff a character packet, taken from a
packed pixel file, corresponds to a |wanted| character, and is downloaded.
If a second packet with the same |char_num| is encountered, the |loaded|
field will already have been set to |yes| or |no|, and the packet will be
skipped.  This permits us to detect duplicate characters (and ensure that
we still process \\{all} characters actually used).

@<Local variables of |add_txf_to_lnf|@>==
@!first_txfc, @!last_txfc : integer;
@!txfc_next, @!final_txfc : integer;
@!begin_txf, @!end_txf : boolean;
@!overflow_font : boolean;
@!packet_used : boolean;
@z

Provide support for /VERBOSE qualifier
@x <BHK 30-SEP-1991> S338.
write_ln(term_out,rasters:0,' bytes of rasters (',font_occupancy[TeX_font]:1,
                          ' characters)' ,crlf);
@y
if verbose then write_ln(term_out,rasters:0,' bytes of rasters (',
                          font_occupancy[TeX_font]:1,' characters)' ,crlf);
@z

Character counter wasn't increment for missing characters!
@x <BHK 02-MAY-1991> S343.
      warning('Font ',name,' doesn''t contain character ',char_num:1,crlf);
@:Warning: Font doesn't contain character}{\quad\.{Font doesn't contain...}@>
      @<Decide whereabouts to download the character@>;
      @<Finish off any previous half font on LN03@>;
      tfm_width := width;
      num_cols := pixel_width;
      base := ras_beg + ras_len;
      @<Create null character locator entry@>;
      char_code:=first_txfc; font_code:=ln_font
@y
      warning('Font ',name,' doesn''t contain character ',char_num:1,crlf);
@:Warning: Font doesn't contain character}{\quad\.{Font doesn't contain...}@>
      @<Decide whereabouts to download the character@>;
      @<Finish off any previous half font on LN03@>;
      tfm_width := width;
      num_cols := pixel_width;
      base := ras_beg + ras_len;
      @<Create null character locator entry@>;
      char_code:=first_txfc; font_code:=ln_font;
      incr(first_txfc)
@z

Must count character's addition to directory entry, etc
@x <BHK 02-MAY-1991> S344.
    move_to_pxl(addr*4);
    char_code:=to_where;@/
    @<Process |tfm_width| information@>;
    @<Validate size of character's glyph@>;
    @<Complete remainder of Character Definition parameters@>;
    @<Copy the rasters themselves@>;
    @<Calculate the number of bytes of rasters transferred@>;
    @<Complete the entry in the font character directory@>
  end {|with|}
@y
    move_to_pxl(addr*4);
    char_code:=to_where;@/
    @<Process |tfm_width| information@>;
    @<Validate size of character's glyph@>;
    @<Complete remainder of Character Definition parameters@>;
    @<Copy the rasters themselves@>;
    @<Calculate the number of bytes of rasters transferred@>;
    @<Complete the entry in the font character directory@>;
    incr(first_txfc)
  end {|with|}
@z

Provide support for /VERBOSE qualifier
@x <BHK 30-SEP-1991> S365.
        if (pages_counted mod 10)=0 then monitor('.'); {show progress}
@y
        if ((pages_counted mod 10)=0) and verbose then
            monitor('.'); {show progress}
@z

Suppress spurious `done' message after N pages processed.
@x <BHK 25-MAR-1991> S365.
          monitor('done.'+crlf); term_offset:=0
@y
@z

Provide support for /VERBOSE qualifier
@x <BHK 30-SEP-1991> S365.
    monitor('done.'+crlf); term_offset:=0;
@y
    if verbose then monitor('done.'+crlf); term_offset:=0;
@z

Provide support for /VERBOSE qualifier
@x <BHK 30-SEP-1991> S373.
@<Count the pages and move to the starting page@>=
monitor('Finding starting page...');
@y
@<Count the pages and move to the starting page@>=
if verbose then monitor('Finding starting page...');
@z

Provide support for /VERBOSE qualifier
@x <BHK 30-SEP-1991> S373.
monitor('found.'+crlf); term_offset:=0
@y
if verbose then monitor('found.'+crlf); term_offset:=0
@z

Correct the indexing of some warning messages
@x <BHK 26-MAR-1991> S377.
if signed_quad<>numerator then
  warning('numerator doesn''t match the preamble!');
@:warning numerator doesn't match}{\quad\.{numerator doesn't match...}@>
if signed_quad<>denominator then
  warning('denominator doesn''t match the preamble!');
@:warning denominator doesn't match}{\quad\.{denominator doesn't match...}@>
if signed_quad<>mag then if new_mag=0 then
  warning('magnification doesn''t match the preamble!');
@:warning magnification doesn't match}{\quad\.{magnification doesn't match...}@>
@y
if signed_quad<>numerator then
  warning('numerator doesn''t match the preamble!');
@:Warning: numerator doesn't match}{\quad\.{numerator doesn't match...}@>
if signed_quad<>denominator then
  warning('denominator doesn''t match the preamble!');
@:Warning: denominator doesn't match}{\quad\.{denominator doesn't match...}@>
if signed_quad<>mag then if new_mag=0 then
  warning('magnification doesn''t match the preamble!');
@:Warning: magnification doesn't match}{\quad\.{magnification doesn't match...}@>
@z

Provide support for /VERBOSE qualifier
@x <BHK 30-SEP-1991> S387.
@!file_name,@!actual_file_spec,@!log_file_name,
   @!output_file_name:file_spec;
@!file_message:file_spec;
@!cmd_j,@!cmd_k:integer;
@!ask : boolean;
@y
@!file_name,@!actual_file_spec,@!log_file_name,
   @!output_file_name:file_spec;
@!file_message:file_spec;
@!cmd_j,@!cmd_k:integer;
@!ask,@!verbose : boolean;
@z

Correct indexing of warning and error messages
@x <BHK 26-MAR-1991> S395.
if not ask then bomb_out('No file name provided');
@.No file name provided@>
@y
if not ask then bomb_out('No file name provided');
@z

Provide support for /VERBOSE qualifier
@x <BHK 30-SEP-1991> S396.
if odd(VAX_cli_present('LOG')) then
  VAX_cli_get_value('LOG',log_file_name);
@y
if odd(VAX_cli_present('LOG')) then
  VAX_cli_get_value('LOG',log_file_name);
verbose := odd(VAX_cli_present('VERBOSE'));
@z

