/* commands with one filename and one "other" argument */
#define ALIAS(alias, type) \
int alias(char *filename, type var);

ALIAS(real_access, int)
ALIAS(real_chmod, int)

ALIAS(real_stat, struct stat*)
ALIAS(real_lstat, struct stat*)

#ifdef SYS_UTIME
ALIAS(real_utime, struct utimbuf *)
#endif

#ifdef SYS_UTIMES
int utimes();
ALIAS(real_utimes, struct timeval *)
#endif

#undef ALIAS


/* commands with two filenames */
#define ALIAS(alias) \
int alias(const char *filename, const char *filename2);

ALIAS(real_link);
ALIAS(real_symlink);
ALIAS(real_rename);

#undef ALIAS

int real_chown(const char *filename, int o, int g);
int real_open(const char *pathname, int flags, mode_t mode);
int real_unlink(const char *pathname);
int real_readlink(const char *path, char *buf, size_t bufsiz);
