/* 
   Messages.m

   This program creates Messages.h which contains #defines 
   for the Win32 API windows messages

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Scott Christley <scottc@net-community.com>

   This file is part of the Windows32 API Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   If you are interested in a warranty or support for this source code,
   contact Scott Christley <scottc@net-community.com> for more information.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation, 
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

/*
  You want to include in windows.h from some other compiler
  otherwise you will just recursive create the #defines
  */

// Define OEMRESOURCE so that OBM_* are defined
#define OEMRESOURCE

#ifndef _WIN32
#define _WIN32
#endif

#include <windows.h>
#include <stdio.h>

int main()
{
  printf("/* WARNING:  This file is automatically generated. */\n\n");

  printf("#ifndef _GNU_H_WINDOWS32_MESSAGES\n");
  printf("#define _GNU_H_WINDOWS32_MESSAGES\n\n");

  printf("#ifdef __cplusplus\n");
  printf("extern \"C\" {\n");
  printf("#endif /* __cplusplus */\n\n");

  /* Start of definitions */

  printf("\n/* Application bar */\n");
  /* TODO:
  printf("#define ABM_ACTIVATE\t(%d)\n", ABM_ACTIVATE);
  printf("#define ABM_GETAUTOHIDEBAR\t(%d)\n", ABM_GETAUTOHIDEBAR);
  printf("#define ABM_GETSTATE\t(%d)\n", ABM_GETSTATE);
  printf("#define ABM_GETTASKBARPOS\t(%d)\n", ABM_GETTASKBARPOS);
  printf("#define ABM_NEW\t(%d)\n", ABM_NEW);
  printf("#define ABM_QUERYPOS\t(%d)\n", ABM_QUERYPOS);
  printf("#define ABM_REMOVE\t(%d)\n", ABM_REMOVE);
  printf("#define ABM_SETAUTOHIDEBAR\t(%d)\n", ABM_SETAUTOHIDEBAR);
  printf("#define ABM_SETPOS\t(%d)\n", ABM_SETPOS);
  printf("#define ABM_WINDOWPOSCHANGED\t(%d)\n", ABM_WINDOWPOSCHANGED);
  */
  printf("\n/* Application bar notifications */\n");
  /* TODO:
  printf("#define ABN_FULLSCREENAPP\t(%d)\n", ABN_FULLSCREENAPP);
  printf("#define ABN_POSCHANGED\t(%d)\n", ABN_POSCHANGED);
  printf("#define ABN_STATECHANGE\t(%d)\n", ABN_STATECHANGE);
  printf("#define ABN_WINDOWARRANGE\t(%d)\n", ABN_WINDOWARRANGE);
  */

  printf("\n/* Animation Control */\n");
  printf("#define ACM_OPENW\t(%d)\n", ACM_OPENW);
  printf("#define ACM_OPENA\t(%d)\n", ACM_OPENA);
  printf("#ifdef UNICODE\n");
  printf("#define ACM_OPEN ACM_OPENW\n");
  printf("#else\n");
  printf("#define ACM_OPEN ACM_OPENA\n");
  printf("#endif /* UNICODE */\n");
  printf("#define ACM_PLAY\t(%d)\n", ACM_PLAY);
  printf("#define ACM_STOP\t(%d)\n", ACM_STOP);
  printf("#define ACN_START\t(%d)\n", ACN_START);
  printf("#define ACN_STOP\t(%d)\n", ACN_STOP);

  printf("\n/* Buttons */\n");
  printf("#define BM_CLICK\t(%d)\n", BM_CLICK);
  printf("#define BM_GETCHECK\t(%d)\n", BM_GETCHECK);
  printf("#define BM_GETIMAGE\t(%d)\n", BM_GETIMAGE);
  printf("#define BM_GETSTATE\t(%d)\n", BM_GETSTATE);
  printf("#define BM_SETCHECK\t(%d)\n", BM_SETCHECK);
  printf("#define BM_SETIMAGE\t(%d)\n", BM_SETIMAGE);
  printf("#define BM_SETSTATE\t(%d)\n", BM_SETSTATE);
  printf("#define BM_SETSTYLE\t(%d)\n", BM_SETSTYLE);
  printf("#define BN_CLICKED\t(%d)\n", BN_CLICKED);
  printf("#define BN_DBLCLK\t(%d)\n", BN_DBLCLK);
  printf("#define BN_DISABLE\t(%d)\n", BN_DISABLE);
  printf("#define BN_DOUBLECLICKED\t(%d)\n", BN_DOUBLECLICKED);
  printf("#define BN_HILITE\t(%d)\n", BN_HILITE);
  printf("#define BN_KILLFOCUS\t(%d)\n", BN_KILLFOCUS);
  printf("#define BN_PAINT\t(%d)\n", BN_PAINT);
  printf("#define BN_PUSHED\t(%d)\n", BN_PUSHED);
  printf("#define BN_SETFOCUS\t(%d)\n", BN_SETFOCUS);
  printf("#define BN_UNHILITE\t(%d)\n", BN_UNHILITE);
  printf("#define BN_UNPUSHED\t(%d)\n", BN_UNPUSHED);

  printf("\n/* Combo Box */\n");
  printf("#define CB_ADDSTRING\t(%d)\n", CB_ADDSTRING);
  printf("#define CB_DELETESTRING\t(%d)\n", CB_DELETESTRING);
  printf("#define CB_DIR\t(%d)\n", CB_DIR);
  printf("#define CB_FINDSTRING\t(%d)\n", CB_FINDSTRING);
  printf("#define CB_FINDSTRINGEXACT\t(%d)\n", CB_FINDSTRINGEXACT);
  printf("#define CB_GETCOUNT\t(%d)\n", CB_GETCOUNT);
  printf("#define CB_GETCURSEL\t(%d)\n", CB_GETCURSEL);
  printf("#define CB_GETDROPPEDCONTROLRECT\t(%d)\n", CB_GETDROPPEDCONTROLRECT);
  printf("#define CB_GETDROPPEDSTATE\t(%d)\n", CB_GETDROPPEDSTATE);
  printf("#define CB_GETDROPPEDWIDTH\t(%d)\n", CB_GETDROPPEDWIDTH);
  printf("#define CB_GETEDITSEL\t(%d)\n", CB_GETEDITSEL);
  printf("#define CB_GETEXTENDEDUI\t(%d)\n", CB_GETEXTENDEDUI);
  printf("#define CB_GETHORIZONTALEXTENT\t(%d)\n", CB_GETHORIZONTALEXTENT);
  printf("#define CB_GETITEMDATA\t(%d)\n", CB_GETITEMDATA);
  printf("#define CB_GETITEMHEIGHT\t(%d)\n", CB_GETITEMHEIGHT);
  printf("#define CB_GETLBTEXT\t(%d)\n", CB_GETLBTEXT);
  printf("#define CB_GETLBTEXTLEN\t(%d)\n", CB_GETLBTEXTLEN);
  printf("#define CB_GETLOCALE\t(%d)\n", CB_GETLOCALE);
  printf("#define CB_GETTOPINDEX\t(%d)\n", CB_GETTOPINDEX);
  printf("#define CB_INITSTORAGE\t(%d)\n", CB_INITSTORAGE);
  printf("#define CB_INSERTSTRING\t(%d)\n", CB_INSERTSTRING);
  printf("#define CB_LIMITTEXT\t(%d)\n", CB_LIMITTEXT);
  printf("#define CB_RESETCONTENT\t(%d)\n", CB_RESETCONTENT);
  printf("#define CB_SELECTSTRING\t(%d)\n", CB_SELECTSTRING);
  printf("#define CB_SETCURSEL\t(%d)\n", CB_SETCURSEL);
  printf("#define CB_SETDROPPEDWIDTH\t(%d)\n", CB_SETDROPPEDWIDTH);
  printf("#define CB_SETEDITSEL\t(%d)\n", CB_SETEDITSEL);
  printf("#define CB_SETEXTENDEDUI\t(%d)\n", CB_SETEXTENDEDUI);
  printf("#define CB_SETHORIZONTALEXTENT\t(%d)\n", CB_SETHORIZONTALEXTENT);
  printf("#define CB_SETITEMDATA\t(%d)\n", CB_SETITEMDATA);
  printf("#define CB_SETITEMHEIGHT\t(%d)\n", CB_SETITEMHEIGHT);
  printf("#define CB_SETLOCALE\t(%d)\n", CB_SETLOCALE);
  printf("#define CB_SETTOPINDEX\t(%d)\n", CB_SETTOPINDEX);
  printf("#define CB_SHOWDROPDOWN\t(%d)\n", CB_SHOWDROPDOWN);
  printf("\n/* Combo Box notifications */\n");
  printf("#define CBN_CLOSEUP\t(%d)\n", CBN_CLOSEUP);
  printf("#define CBN_DBLCLK\t(%d)\n", CBN_DBLCLK);
  printf("#define CBN_DROPDOWN\t(%d)\n", CBN_DROPDOWN);
  printf("#define CBN_EDITCHANGE\t(%d)\n", CBN_EDITCHANGE);
  printf("#define CBN_EDITUPDATE\t(%d)\n", CBN_EDITUPDATE);
  printf("#define CBN_ERRSPACE\t(%d)\n", CBN_ERRSPACE);
  printf("#define CBN_KILLFOCUS\t(%d)\n", CBN_KILLFOCUS);
  printf("#define CBN_SELCHANGE\t(%d)\n", CBN_SELCHANGE);
  printf("#define CBN_SELENDCANCEL\t(%d)\n", CBN_SELENDCANCEL);
  printf("#define CBN_SELENDOK\t(%d)\n", CBN_SELENDOK);
  printf("#define CBN_SETFOCUS\t(%d)\n", CBN_SETFOCUS);

  printf("\n/* Control Panel */\n");
  /* TODO: Where is the Control Panel stuff
  printf("#define CPL_DBLCLK\t(%d)\n", CPL_DBLCLK);
  printf("#define CPL_EXIT\t(%d)\n", CPL_EXIT);
  printf("#define CPL_GETCOUNT\t(%d)\n", CPL_GETCOUNT);
  printf("#define CPL_INIT\t(%d)\n", CPL_INIT);
  printf("#define CPL_INQUIRE\t(%d)\n", CPL_INQUIRE);
  printf("#define CPL_NEWINQUIRE\t(%d)\n", CPL_NEWINQUIRE);
  printf("#define CPL_SELECT\t(%d)\n", CPL_SELECT);
  printf("#define CPL_STOP\t(%d)\n", CPL_STOP);
  */
  
  printf("\n/* Device messages */\n");
  /* TODO:
  printf("#define DBT_CONFIGCHANGED\t(%d)\n", DBT_CONFIGCHANGED);
  printf("#define DBT_DEVICEARRIVAL\t(%d)\n", DBT_DEVICEARRIVAL);
  printf("#define DBT_DEVICEQUERYREMOVE\t(%d)\n", DBT_DEVICEQUERYREMOVE);
  printf("#define DBT_DEVICEQUERYREMOVEFAILED\t(%d)\n", DBT_DEVICEQUERYREMOVEFAILED);
  printf("#define DBT_DEVICEREMOVECOMPLETE\t(%d)\n", DBT_DEVICEREMOVECOMPLETE);
  printf("#define DBT_DEVICEREMOVEPENDING\t(%d)\n", DBT_DEVICEREMOVEPENDING);
  printf("#define DBT_DEVICETYPESPECIFIC\t(%d)\n", DBT_DEVICETYPESPECIFIC);
  printf("#define DBT_USERDEFINED\t(%d)\n", DBT_USERDEFINED);
  */

  printf("\n/* Drag list box */\n");
  printf("#define DL_BEGINDRAG\t(%d)\n", DL_BEGINDRAG);
  printf("#define DL_CANCELDRAG\t(%d)\n", DL_CANCELDRAG);
  printf("#define DL_DRAGGING\t(%d)\n", DL_DRAGGING);
  printf("#define DL_DROPPED\t(%d)\n", DL_DROPPED);

  printf("\n/* Default push button */\n");
  printf("#define DM_GETDEFID\t(%d)\n", DM_GETDEFID);
  printf("#define DM_REPOSITION\t(%d)\n", DM_REPOSITION);
  printf("#define DM_SETDEFID\t(%d)\n", DM_SETDEFID);

  printf("\n/* RTF control */\n");
  printf("#define EM_CANPASTE\t(%d)\n", EM_CANPASTE);
  printf("#define EM_CANUNDO\t(%d)\n", EM_CANUNDO);
  printf("#define EM_CHARFROMPOS\t(%d)\n", EM_CHARFROMPOS);
  printf("#define EM_DISPLAYBAND\t(%d)\n", EM_DISPLAYBAND);
  printf("#define EM_EMPTYUNDOBUFFER\t(%d)\n", EM_EMPTYUNDOBUFFER);
  printf("#define EM_EXGETSEL\t(%d)\n", EM_EXGETSEL);
  printf("#define EM_EXLIMITTEXT\t(%d)\n", EM_EXLIMITTEXT);
  printf("#define EM_EXLINEFROMCHAR\t(%d)\n", EM_EXLINEFROMCHAR);
  printf("#define EM_EXSETSEL\t(%d)\n", EM_EXSETSEL);
  printf("#define EM_FINDTEXT\t(%d)\n", EM_FINDTEXT);
  printf("#define EM_FINDTEXTEX\t(%d)\n", EM_FINDTEXTEX);
  printf("#define EM_FINDWORDBREAK\t(%d)\n", EM_FINDWORDBREAK);
  printf("#define EM_FMTLINES\t(%d)\n", EM_FMTLINES);
  printf("#define EM_FORMATRANGE\t(%d)\n", EM_FORMATRANGE);
  printf("#define EM_GETCHARFORMAT\t(%d)\n", EM_GETCHARFORMAT);
  printf("#define EM_GETEVENTMASK\t(%d)\n", EM_GETEVENTMASK);
  printf("#define EM_GETFIRSTVISIBLELINE\t(%d)\n", EM_GETFIRSTVISIBLELINE);
  printf("#define EM_GETHANDLE\t(%d)\n", EM_GETHANDLE);
  printf("#define EM_GETLIMITTEXT\t(%d)\n", EM_GETLIMITTEXT);
  printf("#define EM_GETLINE\t(%d)\n", EM_GETLINE);
  printf("#define EM_GETLINECOUNT\t(%d)\n", EM_GETLINECOUNT);
  printf("#define EM_GETMARGINS\t(%d)\n", EM_GETMARGINS);
  printf("#define EM_GETMODIFY\t(%d)\n", EM_GETMODIFY);
  printf("#define EM_GETIMECOLOR\t(%d)\n", EM_GETIMECOLOR);
  printf("#define EM_GETIMEOPTIONS\t(%d)\n", EM_GETIMEOPTIONS);
  printf("#define EM_GETOPTIONS\t(%d)\n", EM_GETOPTIONS);
  printf("#define EM_GETOLEINTERFACE\t(%d)\n", EM_GETOLEINTERFACE);
  printf("#define EM_GETPARAFORMAT\t(%d)\n", EM_GETPARAFORMAT);
  printf("#define EM_GETPASSWORDCHAR\t(%d)\n", EM_GETPASSWORDCHAR);
  printf("#define EM_GETPUNCTUATION\t(%d)\n", EM_GETPUNCTUATION);
  printf("#define EM_GETRECT\t(%d)\n", EM_GETRECT);
  printf("#define EM_GETSEL\t(%d)\n", EM_GETSEL);
  printf("#define EM_GETSELTEXT\t(%d)\n", EM_GETSELTEXT);
  printf("#define EM_GETTEXTRANGE\t(%d)\n", EM_GETTEXTRANGE);
  printf("#define EM_GETTHUMB\t(%d)\n", EM_GETTHUMB);
  printf("#define EM_GETWORDBREAKPROC\t(%d)\n", EM_GETWORDBREAKPROC);
  printf("#define EM_GETWORDBREAKPROCEX\t(%d)\n", EM_GETWORDBREAKPROCEX);
  printf("#define EM_GETWORDWRAPMODE\t(%d)\n", EM_GETWORDWRAPMODE);
  printf("#define EM_HIDESELECTION\t(%d)\n", EM_HIDESELECTION);
  printf("#define EM_LIMITTEXT\t(%d)\n", EM_LIMITTEXT);
  printf("#define EM_LINEFROMCHAR\t(%d)\n", EM_LINEFROMCHAR);
  printf("#define EM_LINEINDEX\t(%d)\n", EM_LINEINDEX);
  printf("#define EM_LINELENGTH\t(%d)\n", EM_LINELENGTH);
  printf("#define EM_LINESCROLL\t(%d)\n", EM_LINESCROLL);
  printf("#define EM_PASTESPECIAL\t(%d)\n", EM_PASTESPECIAL);
  printf("#define EM_POSFROMCHAR\t(%d)\n", EM_POSFROMCHAR);
  printf("#define EM_REPLACESEL\t(%d)\n", EM_REPLACESEL);
  printf("#define EM_REQUESTRESIZE\t(%d)\n", EM_REQUESTRESIZE);
  printf("#define EM_SCROLL\t(%d)\n", EM_SCROLL);
  printf("#define EM_SCROLLCARET\t(%d)\n", EM_SCROLLCARET);
  printf("#define EM_SELECTIONTYPE\t(%d)\n", EM_SELECTIONTYPE);
  printf("#define EM_SETBKGNDCOLOR\t(%d)\n", EM_SETBKGNDCOLOR);
  printf("#define EM_SETCHARFORMAT\t(%d)\n", EM_SETCHARFORMAT);
  printf("#define EM_SETEVENTMASK\t(%d)\n", EM_SETEVENTMASK);
  printf("#define EM_SETHANDLE\t(%d)\n", EM_SETHANDLE);
  printf("#define EM_SETIMECOLOR\t(%d)\n", EM_SETIMECOLOR);
  printf("#define EM_SETIMEOPTIONS\t(%d)\n", EM_SETIMEOPTIONS);
  printf("#define EM_SETLIMITTEXT\t(%d)\n", EM_SETLIMITTEXT);
  printf("#define EM_SETMARGINS\t(%d)\n", EM_SETMARGINS);
  printf("#define EM_SETMODIFY\t(%d)\n", EM_SETMODIFY);
  /* TODO:
  printf("#define EM_SETOLEINTERFACE\t(%d)\n", EM_SETOLEINTERFACE); 
  */
  printf("#define EM_SETOLECALLBACK\t(%d)\n", EM_SETOLECALLBACK); 
  printf("#define EM_SETOPTIONS\t(%d)\n", EM_SETOPTIONS);
  printf("#define EM_SETPARAFORMAT\t(%d)\n", EM_SETPARAFORMAT);
  printf("#define EM_SETPASSWORDCHAR\t(%d)\n", EM_SETPASSWORDCHAR);
  printf("#define EM_SETPUNCTUATION\t(%d)\n", EM_SETPUNCTUATION);
  printf("#define EM_SETREADONLY\t(%d)\n", EM_SETREADONLY);
  printf("#define EM_SETRECT\t(%d)\n", EM_SETRECT);
  printf("#define EM_SETRECTNP\t(%d)\n", EM_SETRECTNP);
  printf("#define EM_SETSEL\t(%d)\n", EM_SETSEL);
  printf("#define EM_SETTABSTOPS\t(%d)\n", EM_SETTABSTOPS);
  printf("#define EM_SETTARGETDEVICE\t(%d)\n", EM_SETTARGETDEVICE);
  /* TODO:
  printf("#define EM_SETWORDBREAK\t(%d)\n", EM_SETWORDBREAK); 
  */
  printf("#define EM_SETWORDBREAKPROC\t(%d)\n", EM_SETWORDBREAKPROC);
  printf("#define EM_SETWORDBREAKPROCEX\t(%d)\n", EM_SETWORDBREAKPROCEX);
  printf("#define EM_SETWORDWRAPMODE\t(%d)\n", EM_SETWORDWRAPMODE);
  printf("#define EM_STREAMIN\t(%d)\n", EM_STREAMIN);
  printf("#define EM_STREAMOUT\t(%d)\n", EM_STREAMOUT);
  printf("#define EM_UNDO\t(%d)\n", EM_UNDO);

  printf("\n/* Edit control */\n");
  printf("#define EN_CHANGE\t(%d)\n", EN_CHANGE);
  printf("#define EN_CORRECTTEXT\t(%d)\n", EN_CORRECTTEXT);
  printf("#define EN_DROPFILES\t(%d)\n", EN_DROPFILES);
  printf("#define EN_ERRSPACE\t(%d)\n", EN_ERRSPACE);
  printf("#define EN_HSCROLL\t(%d)\n", EN_HSCROLL);
  printf("#define EN_IMECHANGE\t(%d)\n", EN_IMECHANGE);
  printf("#define EN_KILLFOCUS\t(%d)\n", EN_KILLFOCUS);
  printf("#define EN_MAXTEXT\t(%d)\n", EN_MAXTEXT);
  printf("#define EN_MSGFILTER\t(%d)\n", EN_MSGFILTER);
  printf("#define EN_OLEOPFAILED\t(%d)\n", EN_OLEOPFAILED);
  printf("#define EN_PROTECTED\t(%d)\n", EN_PROTECTED);
  printf("#define EN_REQUESTRESIZE\t(%d)\n", EN_REQUESTRESIZE);
  printf("#define EN_SAVECLIPBOARD\t(%d)\n", EN_SAVECLIPBOARD);
  printf("#define EN_SELCHANGE\t(%d)\n", EN_SELCHANGE);
  printf("#define EN_SETFOCUS\t(%d)\n", EN_SETFOCUS);
  printf("#define EN_STOPNOUNDO\t(%d)\n", EN_STOPNOUNDO);
  printf("#define EN_UPDATE\t(%d)\n", EN_UPDATE);
  printf("#define EN_VSCROLL\t(%d)\n", EN_VSCROLL);

  printf("\n/* File Manager extensions */\n");
  /* TODO: Where is the File Manager stuff
  printf("#define FM_GETDRIVEINFO\t(%d)\n", FM_GETDRIVEINFO);
  printf("#define FM_GETFILESEL\t(%d)\n", FM_GETFILESEL);
  printf("#define FM_GETFILESELLFN\t(%d)\n", FM_GETFILESELLFN);
  printf("#define FM_GETFOCUS\t(%d)\n", FM_GETFOCUS);
  printf("#define FM_GETSELCOUNT\t(%d)\n", FM_GETSELCOUNT);
  printf("#define FM_GETSELCOUNTLFN\t(%d)\n", FM_GETSELCOUNTLFN);
  printf("#define FM_REFRESH_WINDOWS\t(%d)\n", FM_REFRESH_WINDOWS);
  printf("#define FM_RELOAD_EXTENSIONS\t(%d)\n", FM_RELOAD_EXTENSIONS);
  */
  printf("\n/* File Manager extensions DLL events */\n");
  /* TODO:
  printf("#define FMEVENT_HELPMENUITEM\t(%d)\n", FMEVENT_HELPMENUITEM);
  printf("#define FMEVENT_HELPSTRING\t(%d)\n", FMEVENT_HELPSTRING);
  printf("#define FMEVENT_INITMENU\t(%d)\n", FMEVENT_INITMENU);
  printf("#define FMEVENT_LOAD\t(%d)\n", FMEVENT_LOAD);
  printf("#define FMEVENT_SELCHANGE\t(%d)\n", FMEVENT_SELCHANGE);
  printf("#define FMEVENT_TOOLBARLOAD\t(%d)\n", FMEVENT_TOOLBARLOAD);
  printf("#define FMEVENT_UNLOAD\t(%d)\n", FMEVENT_UNLOAD);
  printf("#define FMEVENT_USER_REFRESH\t(%d)\n", FMEVENT_USER_REFRESH);
  */

  printf("\n/* Header control */\n");
  printf("#define HDM_DELETEITEM\t(%d)\n", HDM_DELETEITEM);
  printf("#define HDM_GETITEMW\t(%d)\n", HDM_GETITEMW);
  printf("#define HDM_INSERTITEMW\t(%d)\n", HDM_INSERTITEMW);
  printf("#define HDM_SETITEMW\t(%d)\n", HDM_SETITEMW);
  printf("#define HDM_GETITEMA\t(%d)\n", HDM_GETITEMA);
  printf("#define HDM_INSERTITEMA\t(%d)\n", HDM_INSERTITEMA);
  printf("#define HDM_SETITEMA\t(%d)\n", HDM_SETITEMA);
  printf("#ifdef UNICODE\n");
  printf("#define HDM_GETITEM HDM_GETITEMW\n");
  printf("#define HDM_INSERTITEM HDM_INSERTITEMW\n");
  printf("#define HDM_SETITEM HDM_SETITEMW\n");
  printf("#else\n");
  printf("#define HDM_GETITEM HDM_GETITEMA\n");
  printf("#define HDM_INSERTITEM HDM_INSERTITEMA\n");
  printf("#define HDM_SETITEM HDM_SETITEMA\n");
  printf("#endif /* UNICODE */\n");
  printf("#define HDM_GETITEMCOUNT\t(%d)\n", HDM_GETITEMCOUNT);
  printf("#define HDM_HITTEST\t(%d)\n", HDM_HITTEST);
  printf("#define HDM_LAYOUT\t(%d)\n", HDM_LAYOUT);
  printf("\n/* Header control notifications */\n");
  printf("#define HDN_BEGINTRACKW\t(%d)\n", HDN_BEGINTRACKW);
  printf("#define HDN_DIVIDERDBLCLICKW\t(%d)\n", HDN_DIVIDERDBLCLICKW);
  printf("#define HDN_ENDTRACKW\t(%d)\n", HDN_ENDTRACKW);
  printf("#define HDN_ITEMCHANGEDW\t(%d)\n", HDN_ITEMCHANGEDW);
  printf("#define HDN_ITEMCHANGINGW\t(%d)\n", HDN_ITEMCHANGINGW);
  printf("#define HDN_ITEMCLICKW\t(%d)\n", HDN_ITEMCLICKW);
  printf("#define HDN_ITEMDBLCLICKW\t(%d)\n", HDN_ITEMDBLCLICKW);
  printf("#define HDN_TRACKW\t(%d)\n", HDN_TRACKW);
  printf("#define HDN_BEGINTRACKA\t(%d)\n", HDN_BEGINTRACKA);
  printf("#define HDN_DIVIDERDBLCLICKA\t(%d)\n", HDN_DIVIDERDBLCLICKA);
  printf("#define HDN_ENDTRACKA\t(%d)\n", HDN_ENDTRACKA);
  printf("#define HDN_ITEMCHANGEDA\t(%d)\n", HDN_ITEMCHANGEDA);
  printf("#define HDN_ITEMCHANGINGA\t(%d)\n", HDN_ITEMCHANGINGA);
  printf("#define HDN_ITEMCLICKA\t(%d)\n", HDN_ITEMCLICKA);
  printf("#define HDN_ITEMDBLCLICKA\t(%d)\n", HDN_ITEMDBLCLICKA);
  printf("#define HDN_TRACKA\t(%d)\n", HDN_TRACKA);
  printf("#ifdef UNICODE\n");
  printf("#define HDN_BEGINTRACK HDN_BEGINTRACKW\n");
  printf("#define HDN_DIVIDERDBLCLICK HDN_DIVIDERDBLCLICKW\n");
  printf("#define HDN_ENDTRACK HDN_ENDTRACKW\n");
  printf("#define HDN_ITEMCHANGED HDN_ITEMCHANGEDW\n");
  printf("#define HDN_ITEMCHANGING HDN_ITEMCHANGINGW\n");
  printf("#define HDN_ITEMCLICK HDN_ITEMCLICKW\n");
  printf("#define HDN_ITEMDBLCLICK HDN_ITEMDBLCLICKW\n");
  printf("#define HDN_TRACK HDN_TRACKW\n");
  printf("#else\n");
  printf("#define HDN_BEGINTRACK HDN_BEGINTRACKA\n");
  printf("#define HDN_DIVIDERDBLCLICK HDN_DIVIDERDBLCLICKA\n");
  printf("#define HDN_ENDTRACK HDN_ENDTRACKA\n");
  printf("#define HDN_ITEMCHANGED HDN_ITEMCHANGEDA\n");
  printf("#define HDN_ITEMCHANGING HDN_ITEMCHANGINGA\n");
  printf("#define HDN_ITEMCLICK HDN_ITEMCLICKA\n");
  printf("#define HDN_ITEMDBLCLICK HDN_ITEMDBLCLICKA\n");
  printf("#define HDN_TRACK HDN_TRACKA\n");
  printf("#endif /* UNICODE */\n");

  printf("\n/* Hot key control */\n");
  printf("#define HKM_GETHOTKEY\t(%d)\n", HKM_GETHOTKEY);
  printf("#define HKM_SETHOTKEY\t(%d)\n", HKM_SETHOTKEY);
  printf("#define HKM_SETRULES\t(%d)\n", HKM_SETRULES);

#ifdef ENABLE_IME
  /* TODO: IME */
  printf("\n/* IME */\n");
  printf("#define IMC_CLOSESTATUSWINDOW\t(%d)\n", IMC_CLOSESTATUSWINDOW);
  printf("#define IMC_GETCANDIDATEPOS\t(%d)\n", IMC_GETCANDIDATEPOS);
  printf("#define IMC_GETCOMPOSITIONCOLOR\t(%d)\n", IMC_GETCOMPOSITIONCOLOR);
  printf("#define IMC_GETCOMPOSITIONFONT\t(%d)\n", IMC_GETCOMPOSITIONFONT);
  printf("#define IMC_GETCOMPOSITIONWINDOW\t(%d)\n", IMC_GETCOMPOSITIONWINDOW);
  printf("#define IMC_GETCONVERSIONMODE\t(%d)\n", IMC_GETCONVERSIONMODE);
  printf("#define IMC_GETOPENSTATUS\t(%d)\n", IMC_GETOPENSTATUS);
  printf("#define IMC_GETSENTENCEMODE\t(%d)\n", IMC_GETSENTENCEMODE);
  printf("#define IMC_GETSTATUSWINDOWPOS\t(%d)\n", IMC_GETSTATUSWINDOWPOS);
  printf("#define IMC_OPENSTATUSWINDOW\t(%d)\n", IMC_OPENSTATUSWINDOW);
  printf("#define IMC_SETCANDIDATEPOS\t(%d)\n", IMC_SETCANDIDATEPOS);
  printf("#define IMC_SETCOMPOSITIONCOLOR\t(%d)\n", IMC_SETCOMPOSITIONCOLOR);
  printf("#define IMC_SETCOMPOSITIONFONT\t(%d)\n", IMC_SETCOMPOSITIONFONT);
  printf("#define IMC_SETCOMPOSITIONWINDOW\t(%d)\n", IMC_SETCOMPOSITIONWINDOW);
  printf("#define IMC_SETCONVERSIONMODE\t(%d)\n", IMC_SETCONVERSIONMODE);
  printf("#define IMC_SETOPENSTATUS\t(%d)\n", IMC_OPENSTATUS);
  printf("#define IMC_SETSENTENCEMODE\t(%d)\n", IMC_SETSENTENCEMODE);
  printf("#define IMC_SETSTATUSWINDOWPOS\t(%d)\n", IMC_SETSTATUSWINDOWPOS);
  printf("\n/* IME notification */\n");
  printf("#define IMN_CHANGECANDIDATE\t(%d)\n", IMN_CHANGECANDIDATE);
  printf("#define IMN_CLOSECANDIDATE\t(%d)\n", IMN_CLOSECANDIDATE);
  printf("#define IMN_CLOSESTATUSWINDOW\t(%d)\n", IMN_CLOSESTATUSWINDOW);
  printf("#define IMN_GUIDELINE\t(%d)\n", IMN_GUIDELINE);
  printf("#define IMN_OPENCANDIDATE\t(%d)\n", IMN_OPENCANDIDATE);
  printf("#define IMN_OPENSTATUSWINDOW\t(%d)\n", IMN_OPENSTATUSWINDOW);
  printf("#define IMN_SETCANDIDATEPOS\t(%d)\n", IMN_SETCANDIDATEPOS);
  printf("#define IMN_SETCOMPOSITIONFONT\t(%d)\n", IMN_SETCOMPOSITIONFONT);
  printf("#define IMN_SETCOMPOSITIONWINDOW\t(%d)\n", IMN_SETCOMPOSITIONWINDOW);
  printf("#define IMN_SETCONVERSIONMODE\t(%d)\n", IMN_SETCONVERSIONMODE);
  printf("#define IMN_SETOPENSTATUS\t(%d)\n", IMN_SETOPENSTATUS);
  printf("#define IMN_SETSENTENCEMODE\t(%d)\n", IMN_SETSENTENCEMODE);
  printf("#define IMN_SETSTATUSWINDOWPOS\t(%d)\n", IMN_SETSTATUSWINDOWPOS);
#endif /* ENABLE_IME */

  printf("\n/* List box */\n");
  printf("#define LB_ADDFILE\t(%d)\n", LB_ADDFILE);
  printf("#define LB_ADDSTRING\t(%d)\n", LB_ADDSTRING);
  printf("#define LB_DELETESTRING\t(%d)\n", LB_DELETESTRING);
  printf("#define LB_DIR\t(%d)\n", LB_DIR);
  printf("#define LB_FINDSTRING\t(%d)\n", LB_FINDSTRING);
  printf("#define LB_FINDSTRINGEXACT\t(%d)\n", LB_FINDSTRINGEXACT);
  printf("#define LB_GETANCHORINDEX\t(%d)\n", LB_GETANCHORINDEX);
  printf("#define LB_GETCARETINDEX\t(%d)\n", LB_GETCARETINDEX);
  printf("#define LB_GETCOUNT\t(%d)\n", LB_GETCOUNT);
  printf("#define LB_GETCURSEL\t(%d)\n", LB_GETCURSEL);
  printf("#define LB_GETHORIZONTALEXTENT\t(%d)\n", LB_GETHORIZONTALEXTENT);
  printf("#define LB_GETITEMDATA\t(%d)\n", LB_GETITEMDATA);
  printf("#define LB_GETITEMHEIGHT\t(%d)\n", LB_GETITEMHEIGHT);
  printf("#define LB_GETITEMRECT\t(%d)\n", LB_GETITEMRECT);
  printf("#define LB_GETLOCALE\t(%d)\n", LB_GETLOCALE);
  printf("#define LB_GETSEL\t(%d)\n", LB_GETSEL);
  printf("#define LB_GETSELCOUNT\t(%d)\n", LB_GETSELCOUNT);
  printf("#define LB_GETSELITEMS\t(%d)\n", LB_GETSELITEMS);
  printf("#define LB_GETTEXT\t(%d)\n", LB_GETTEXT);
  printf("#define LB_GETTEXTLEN\t(%d)\n", LB_GETTEXTLEN);
  printf("#define LB_GETTOPINDEX\t(%d)\n", LB_GETTOPINDEX);
  printf("#define LB_INITSTORAGE\t(%d)\n", LB_INITSTORAGE);
  printf("#define LB_INSERTSTRING\t(%d)\n", LB_INSERTSTRING);
  printf("#define LB_ITEMFROMPOINT\t(%d)\n", LB_ITEMFROMPOINT);
  printf("#define LB_RESETCONTENT\t(%d)\n", LB_RESETCONTENT);
  printf("#define LB_SELECTSTRING\t(%d)\n", LB_SELECTSTRING);
  printf("#define LB_SELITEMRANGE\t(%d)\n", LB_SELITEMRANGE);
  printf("#define LB_SELITEMRANGEEX\t(%d)\n", LB_SELITEMRANGEEX);
  printf("#define LB_SETANCHORINDEX\t(%d)\n", LB_SETANCHORINDEX);
  printf("#define LB_SETCARETINDEX\t(%d)\n", LB_SETCARETINDEX);
  printf("#define LB_SETCOLUMNWIDTH\t(%d)\n", LB_SETCOLUMNWIDTH);
  printf("#define LB_SETCOUNT\t(%d)\n", LB_SETCOUNT);
  printf("#define LB_SETCURSEL\t(%d)\n", LB_SETCURSEL);
  printf("#define LB_SETHORIZONTALEXTENT\t(%d)\n", LB_SETHORIZONTALEXTENT);
  printf("#define LB_SETITEMDATA\t(%d)\n", LB_SETITEMDATA);
  printf("#define LB_SETITEMHEIGHT\t(%d)\n", LB_SETITEMHEIGHT);
  printf("#define LB_SETLOCALE\t(%d)\n", LB_SETLOCALE);
  printf("#define LB_SETSEL\t(%d)\n", LB_SETSEL);
  printf("#define LB_SETTABSTOPS\t(%d)\n", LB_SETTABSTOPS);
  printf("#define LB_SETTOPINDEX\t(%d)\n", LB_SETTOPINDEX);
  printf("\n/* List box notifications */\n");
  printf("#define LBN_DBLCLK\t(%d)\n", LBN_DBLCLK);
  printf("#define LBN_ERRSPACE\t(%d)\n", LBN_ERRSPACE);
  printf("#define LBN_KILLFOCUS\t(%d)\n", LBN_KILLFOCUS);
  printf("#define LBN_SELCANCEL\t(%d)\n", LBN_SELCANCEL);
  printf("#define LBN_SELCHANGE\t(%d)\n", LBN_SELCHANGE);
  printf("#define LBN_SETFOCUS\t(%d)\n", LBN_SETFOCUS);

  printf("\n/* List view control */\n");
  printf("#define LVM_ARRANGE\t(%d)\n", LVM_ARRANGE);
  printf("#define LVM_CREATEDRAGIMAGE\t(%d)\n", LVM_CREATEDRAGIMAGE);
  printf("#define LVM_DELETEALLITEMS\t(%d)\n", LVM_DELETEALLITEMS);
  printf("#define LVM_DELETECOLUMN\t(%d)\n", LVM_DELETECOLUMN);
  printf("#define LVM_DELETEITEM\t(%d)\n", LVM_DELETEITEM);
  printf("#define LVM_ENSUREVISIBLE\t(%d)\n", LVM_ENSUREVISIBLE);
  printf("#define LVM_GETBKCOLOR\t(%d)\n", LVM_GETBKCOLOR);
  printf("#define LVM_GETCALLBACKMASK\t(%d)\n", LVM_GETCALLBACKMASK);
  printf("#define LVM_GETCOLUMNWIDTH\t(%d)\n", LVM_GETCOLUMNWIDTH);
  printf("#define LVM_GETCOUNTPERPAGE\t(%d)\n", LVM_GETCOUNTPERPAGE);
  printf("#define LVM_GETEDITCONTROL\t(%d)\n", LVM_GETEDITCONTROL);
  printf("#define LVM_GETIMAGELIST\t(%d)\n", LVM_GETIMAGELIST);
  printf("#define LVM_EDITLABELW\t(%d)\n", LVM_EDITLABELW);
  printf("#define LVM_FINDITEMW\t(%d)\n", LVM_FINDITEMW);
  printf("#define LVM_GETCOLUMNW\t(%d)\n", LVM_GETCOLUMNW);
  printf("#define LVM_GETISEARCHSTRINGW\t(%d)\n", LVM_GETISEARCHSTRINGW);
  printf("#define LVM_GETITEMW\t(%d)\n", LVM_GETITEMW);
  printf("#define LVM_GETITEMTEXTW\t(%d)\n", LVM_GETITEMTEXTW);
  printf("#define LVM_GETSTRINGWIDTHW\t(%d)\n", LVM_GETSTRINGWIDTHW);
  printf("#define LVM_INSERTCOLUMNW\t(%d)\n", LVM_INSERTCOLUMNW);
  printf("#define LVM_INSERTITEMW\t(%d)\n", LVM_INSERTITEMW);
  printf("#define LVM_SETCOLUMNW\t(%d)\n", LVM_SETCOLUMNW);
  printf("#define LVM_SETITEMW\t(%d)\n", LVM_SETITEMW);
  printf("#define LVM_SETITEMTEXTW\t(%d)\n", LVM_SETITEMTEXTW);
  printf("#define LVM_EDITLABELA\t(%d)\n", LVM_EDITLABELA);
  printf("#define LVM_FINDITEMA\t(%d)\n", LVM_FINDITEMA);
  printf("#define LVM_GETCOLUMNA\t(%d)\n", LVM_GETCOLUMNA);
  printf("#define LVM_GETISEARCHSTRINGA\t(%d)\n", LVM_GETISEARCHSTRINGA);
  printf("#define LVM_GETITEMA\t(%d)\n", LVM_GETITEMA);
  printf("#define LVM_GETITEMTEXTA\t(%d)\n", LVM_GETITEMTEXTA);
  printf("#define LVM_GETSTRINGWIDTHA\t(%d)\n", LVM_GETSTRINGWIDTHA);
  printf("#define LVM_INSERTCOLUMNA\t(%d)\n", LVM_INSERTCOLUMNA);
  printf("#define LVM_INSERTITEMA\t(%d)\n", LVM_INSERTITEMA);
  printf("#define LVM_SETCOLUMNA\t(%d)\n", LVM_SETCOLUMNA);
  printf("#define LVM_SETITEMA\t(%d)\n", LVM_SETITEMA);
  printf("#define LVM_SETITEMTEXTA\t(%d)\n", LVM_SETITEMTEXTA);
  printf("#ifdef UNICODE\n");
  printf("#define LVM_EDITLABEL LVM_EDITLABELW\n");
  printf("#define LVM_FINDITEM LVM_FINDITEMW\n");
  printf("#define LVM_GETCOLUMN LVM_GETCOLUMNW\n");
  printf("#define LVM_GETISEARCHSTRING LVM_GETISEARCHSTRINGW\n");
  printf("#define LVM_GETITEM LVM_GETITEMW\n");
  printf("#define LVM_GETITEMTEXT LVM_GETITEMTEXTW\n");
  printf("#define LVM_GETSTRINGWIDTH LVM_GETSTRINGWIDTHW\n");
  printf("#define LVM_INSERTCOLUMN LVM_INSERTCOLUMNW\n");
  printf("#define LVM_INSERTITEM LVM_INSERTITEMW\n");
  printf("#define LVM_SETCOLUMN LVM_SETCOLUMNW\n");
  printf("#define LVM_SETITEM LVM_SETITEMW\n");
  printf("#define LVM_SETITEMTEXT LVM_SETITEMTEXTW\n");
  printf("#else\n");
  printf("#define LVM_EDITLABEL LVM_EDITLABELA\n");
  printf("#define LVM_FINDITEM LVM_FINDITEMA\n");
  printf("#define LVM_GETCOLUMN LVM_GETCOLUMNA\n");
  printf("#define LVM_GETISEARCHSTRING LVM_GETISEARCHSTRINGA\n");
  printf("#define LVM_GETITEM LVM_GETITEMA\n");
  printf("#define LVM_GETITEMTEXT LVM_GETITEMTEXTA\n");
  printf("#define LVM_GETSTRINGWIDTH LVM_GETSTRINGWIDTHA\n");
  printf("#define LVM_INSERTCOLUMN LVM_INSERTCOLUMNA\n");
  printf("#define LVM_INSERTITEM LVM_INSERTITEMA\n");
  printf("#define LVM_SETCOLUMN LVM_SETCOLUMNA\n");
  printf("#define LVM_SETITEM LVM_SETITEMA\n");
  printf("#define LVM_SETITEMTEXT LVM_SETITEMTEXTA\n");
  printf("#endif /* UNICODE */\n");
  printf("#define LVM_GETITEMCOUNT\t(%d)\n", LVM_GETITEMCOUNT);
  printf("#define LVM_GETITEMPOSITION\t(%d)\n", LVM_GETITEMPOSITION);
  printf("#define LVM_GETITEMRECT\t(%d)\n", LVM_GETITEMRECT);
  printf("#define LVM_GETITEMSPACING\t(%d)\n", LVM_GETITEMSPACING);
  printf("#define LVM_GETITEMSTATE\t(%d)\n", LVM_GETITEMSTATE);
  printf("#define LVM_GETNEXTITEM\t(%d)\n", LVM_GETNEXTITEM);
  printf("#define LVM_GETORIGIN\t(%d)\n", LVM_GETORIGIN);
  printf("#define LVM_GETSELECTEDCOUNT\t(%d)\n", LVM_GETSELECTEDCOUNT);
  printf("#define LVM_GETTEXTBKCOLOR\t(%d)\n", LVM_GETTEXTBKCOLOR);
  printf("#define LVM_GETTEXTCOLOR\t(%d)\n", LVM_GETTEXTCOLOR);
  printf("#define LVM_GETTOPINDEX\t(%d)\n", LVM_GETTOPINDEX);
  printf("#define LVM_GETVIEWRECT\t(%d)\n", LVM_GETVIEWRECT);
  printf("#define LVM_HITTEST\t(%d)\n", LVM_HITTEST);
  printf("#define LVM_REDRAWITEMS\t(%d)\n", LVM_REDRAWITEMS);
  printf("#define LVM_SCROLL\t(%d)\n", LVM_SCROLL);
  printf("#define LVM_SETBKCOLOR\t(%d)\n", LVM_SETBKCOLOR);
  printf("#define LVM_SETCALLBACKMASK\t(%d)\n", LVM_SETCALLBACKMASK);
  printf("#define LVM_SETCOLUMNWIDTH\t(%d)\n", LVM_SETCOLUMNWIDTH);
  printf("#define LVM_SETIMAGELIST\t(%d)\n", LVM_SETIMAGELIST);
  printf("#define LVM_SETITEMCOUNT\t(%d)\n", LVM_SETITEMCOUNT);
  printf("#define LVM_SETITEMPOSITION\t(%d)\n", LVM_SETITEMPOSITION);
  printf("#define LVM_SETITEMPOSITION32\t(%d)\n", LVM_SETITEMPOSITION32);
  printf("#define LVM_SETITEMSTATE\t(%d)\n", LVM_SETITEMSTATE);
  printf("#define LVM_SETTEXTBKCOLOR\t(%d)\n", LVM_SETTEXTBKCOLOR);
  printf("#define LVM_SETTEXTCOLOR\t(%d)\n", LVM_SETTEXTCOLOR);
  printf("#define LVM_SORTITEMS\t(%d)\n", LVM_SORTITEMS);
  printf("#define LVM_UPDATE\t(%d)\n", LVM_UPDATE);
  printf("\n/* List view control notifications */\n");
  printf("#define LVN_BEGINDRAG\t(%d)\n", LVN_BEGINDRAG);
  printf("#define LVN_BEGINRDRAG\t(%d)\n", LVN_BEGINRDRAG);
  printf("#define LVN_COLUMNCLICK\t(%d)\n", LVN_COLUMNCLICK);
  printf("#define LVN_DELETEALLITEMS\t(%d)\n", LVN_DELETEALLITEMS);
  printf("#define LVN_DELETEITEM\t(%d)\n", LVN_DELETEITEM);
  printf("#define LVN_BEGINLABELEDITW\t(%d)\n", LVN_BEGINLABELEDITW);
  printf("#define LVN_ENDLABELEDITW\t(%d)\n", LVN_ENDLABELEDITW);
  printf("#define LVN_GETDISPINFOW\t(%d)\n", LVN_GETDISPINFOW);
  printf("#define LVN_SETDISPINFOW\t(%d)\n", LVN_SETDISPINFOW);
  printf("#define LVN_BEGINLABELEDITA\t(%d)\n", LVN_BEGINLABELEDITA);
  printf("#define LVN_ENDLABELEDITA\t(%d)\n", LVN_ENDLABELEDITA);
  printf("#define LVN_GETDISPINFOA\t(%d)\n", LVN_GETDISPINFOA);
  printf("#define LVN_SETDISPINFOA\t(%d)\n", LVN_SETDISPINFOA);
  printf("#ifdef UNICODE\n");
  printf("#define LVN_BEGINLABELEDIT LVN_BEGINLABELEDITW\n");
  printf("#define LVN_ENDLABELEDIT LVN_ENDLABELEDITW\n");
  printf("#define LVN_GETDISPINFO LVN_GETDISPINFOW\n");
  printf("#define LVN_SETDISPINFO LVN_SETDISPINFOW\n");
  printf("#else\n");
  printf("#define LVN_BEGINLABELEDIT LVN_BEGINLABELEDITA\n");
  printf("#define LVN_ENDLABELEDIT LVN_ENDLABELEDITA\n");
  printf("#define LVN_GETDISPINFO LVN_GETDISPINFOA\n");
  printf("#define LVN_SETDISPINFO LVN_SETDISPINFOA\n");
  printf("#endif /* UNICODE */\n");
  printf("#define LVN_INSERTITEM\t(%d)\n", LVN_INSERTITEM);
  printf("#define LVN_ITEMCHANGED\t(%d)\n", LVN_ITEMCHANGED);
  printf("#define LVN_ITEMCHANGING\t(%d)\n", LVN_ITEMCHANGING);
  printf("#define LVN_KEYDOWN\t(%d)\n", LVN_KEYDOWN);
  /* TODO: Pen enhancements
  printf("#define LVN_PEN\t(%d)\n", LVN_PEN); 
  */

  printf("\n/* Control notification */\n");
  printf("#define NM_CLICK\t(%d)\n", NM_CLICK);
  printf("#define NM_DBLCLK\t(%d)\n", NM_DBLCLK);
  printf("#define NM_KILLFOCUS\t(%d)\n", NM_KILLFOCUS);
  printf("#define NM_OUTOFMEMORY\t(%d)\n", NM_OUTOFMEMORY);
  printf("#define NM_RCLICK\t(%d)\n", NM_RCLICK);
  printf("#define NM_RDBLCLK\t(%d)\n", NM_RDBLCLK);
  printf("#define NM_RETURN\t(%d)\n", NM_RETURN);
  printf("#define NM_SETFOCUS\t(%d)\n", NM_SETFOCUS);

  printf("\n/* Power status */\n");
  /* TODO: Where is the Power Status stuff
  printf("#define PB_APMPOWERSTATUSCHANGED\t(%d)\n", PB_APMPOWERSTATUSCHANGED);
  printf("#define PB_APMQUERYSTANDBY\t(%d)\n", PB_APMQUERYSTANDBY);
  printf("#define PB_APMQUERYSTANDBYFAILED\t(%d)\n", PB_APMQUERYSTANDBYFAILED);
  printf("#define PB_APMQUERYSUSPEND\t(%d)\n", PB_APMQUERYSUSPEND);
  printf("#define PB_APMQUERYSUSPENDFAILED\t(%d)\n", PB_APMQUERYSUSPENDFAILED);
  printf("#define PB_APMRESUMECRITICAL\t(%d)\n", PB_APMRESUMECRITICAL);
  printf("#define PB_APMRESUMESTANDBY\t(%d)\n", PB_APMRESUMESTANDBY);
  printf("#define PB_APMRESUMESUSPEND\t(%d)\n", PB_APMRESUMESUSPEND);
  printf("#define PB_APMSTANDBY\t(%d)\n", PB_APMSTANDBY);
  printf("#define PB_APMSUSPEND\t(%d)\n", PB_APMSUSPEND);
  */

  printf("\n/* Progress bar control */\n");
  printf("#define PBM_DELTAPOS\t(%d)\n", PBM_DELTAPOS);
  printf("#define PBM_SETPOS\t(%d)\n", PBM_SETPOS);
  printf("#define PBM_SETRANGE\t(%d)\n", PBM_SETRANGE);
  printf("#define PBM_SETSTEP\t(%d)\n", PBM_SETSTEP);
  printf("#define PBM_STEPIT\t(%d)\n", PBM_STEPIT);

  printf("\n/* Property sheets */\n");
  printf("#define PSM_ADDPAGE\t(%d)\n", PSM_ADDPAGE);
  printf("#define PSM_APPLY\t(%d)\n", PSM_APPLY);
  printf("#define PSM_CANCELTOCLOSE\t(%d)\n", PSM_CANCELTOCLOSE);
  printf("#define PSM_CHANGED\t(%d)\n", PSM_CHANGED);
  printf("#define PSM_GETTABCONTROL\t(%d)\n", PSM_GETTABCONTROL);
  printf("#define PSM_GETCURRENTPAGEHWND\t(%d)\n", PSM_GETCURRENTPAGEHWND);
  printf("#define PSM_ISDIALOGMESSAGE\t(%d)\n", PSM_ISDIALOGMESSAGE);
  printf("#define PSM_PRESSBUTTON\t(%d)\n", PSM_PRESSBUTTON);
  printf("#define PSM_QUERYSIBLINGS\t(%d)\n", PSM_QUERYSIBLINGS);
  printf("#define PSM_REBOOTSYSTEM\t(%d)\n", PSM_REBOOTSYSTEM);
  printf("#define PSM_REMOVEPAGE\t(%d)\n", PSM_REMOVEPAGE);
  printf("#define PSM_RESTARTWINDOWS\t(%d)\n", PSM_RESTARTWINDOWS);
  printf("#define PSM_SETCURSEL\t(%d)\n", PSM_SETCURSEL);
  printf("#define PSM_SETCURSELID\t(%d)\n", PSM_SETCURSELID);
  printf("#define PSM_SETFINISHTEXTW\t(%d)\n", PSM_SETFINISHTEXTW);
  printf("#define PSM_SETTITLEW\t(%d)\n", PSM_SETTITLEW);
  printf("#define PSM_SETFINISHTEXTA\t(%d)\n", PSM_SETFINISHTEXTA);
  printf("#define PSM_SETTITLEA\t(%d)\n", PSM_SETTITLEA);
  printf("#ifdef UNICODE\n");
  printf("#define PSM_SETFINISHTEXT PSM_SETFINISHTEXTW\n");
  printf("#define PSM_SETTITLE PSM_SETTITLEW\n");
  printf("#else\n");
  printf("#define PSM_SETFINISHTEXT PSM_SETFINISHTEXTA\n");
  printf("#define PSM_SETTITLE PSM_SETTITLEA\n");
  printf("#endif /* UNICODE */\n");
  printf("#define PSM_SETWIZBUTTONS\t(%d)\n", PSM_SETWIZBUTTONS);
  printf("#define PSM_UNCHANGED\t(%d)\n", PSM_UNCHANGED);
  printf("\n/* Property sheet notifications */\n");
  printf("#define PSN_APPLY\t(%d)\n", PSN_APPLY);
  printf("#define PSN_HELP\t(%d)\n", PSN_HELP);
  printf("#define PSN_KILLACTIVE\t(%d)\n", PSN_KILLACTIVE);
  printf("#define PSN_QUERYCANCEL\t(%d)\n", PSN_QUERYCANCEL);
  printf("#define PSN_RESET\t(%d)\n", PSN_RESET);
  printf("#define PSN_SETACTIVE\t(%d)\n", PSN_SETACTIVE);
  printf("#define PSN_WIZBACK\t(%d)\n", PSN_WIZBACK);
  printf("#define PSN_WIZFINISH\t(%d)\n", PSN_WIZFINISH);
  printf("#define PSN_WIZNEXT\t(%d)\n", PSN_WIZNEXT);

  printf("\n/* Status window */\n");
  printf("#define SB_GETBORDERS\t(%d)\n", SB_GETBORDERS);
  printf("#define SB_GETPARTS\t(%d)\n", SB_GETPARTS);
  printf("#define SB_GETRECT\t(%d)\n", SB_GETRECT);
  printf("#define SB_GETTEXTW\t(%d)\n", SB_GETTEXTW);
  printf("#define SB_GETTEXTLENGTHW\t(%d)\n", SB_GETTEXTLENGTHW);
  printf("#define SB_SETTEXTW\t(%d)\n", SB_SETTEXTW);
  printf("#define SB_GETTEXTA\t(%d)\n", SB_GETTEXTA);
  printf("#define SB_GETTEXTLENGTHA\t(%d)\n", SB_GETTEXTLENGTHA);
  printf("#define SB_SETTEXTA\t(%d)\n", SB_SETTEXTA);
  printf("#ifdef UNICODE\n");
  printf("#define SB_GETTEXT SB_GETTEXTW\n");
  printf("#define SB_GETTEXTLENGTH SB_GETTEXTLENGTHW\n");
  printf("#define SB_SETTEXT SB_SETTEXTW\n");
  printf("#else\n");
  printf("#define SB_GETTEXT SB_GETTEXTA\n");
  printf("#define SB_GETTEXTLENGTH SB_GETTEXTLENGTHA\n");
  printf("#define SB_SETTEXT SB_SETTEXTA\n");
  printf("#endif /* UNICODE */\n");
  printf("#define SB_SETMINHEIGHT\t(%d)\n", SB_SETMINHEIGHT);
  printf("#define SB_SETPARTS\t(%d)\n", SB_SETPARTS);
  printf("#define SB_SIMPLE\t(%d)\n", SB_SIMPLE);

  printf("\n/* Scroll bar control */\n");
  printf("#define SBM_ENABLE_ARROWS\t(%d)\n", SBM_ENABLE_ARROWS);
  printf("#define SBM_GETPOS\t(%d)\n", SBM_GETPOS);
  printf("#define SBM_GETRANGE\t(%d)\n", SBM_GETRANGE);
  printf("#define SBM_GETSCROLLINFO\t(%d)\n", SBM_GETSCROLLINFO);
  printf("#define SBM_SETPOS\t(%d)\n", SBM_SETPOS);
  printf("#define SBM_SETRANGE\t(%d)\n", SBM_SETRANGE);
  printf("#define SBM_SETRANGEREDRAW\t(%d)\n", SBM_SETRANGEREDRAW);
  printf("#define SBM_SETSCROLLINFO\t(%d)\n", SBM_SETSCROLLINFO);

  printf("\n/* Static control */\n");
  printf("#define STM_GETICON\t(%d)\n", STM_GETICON);
  printf("#define STM_GETIMAGE\t(%d)\n", STM_GETIMAGE);
  printf("#define STM_SETICON\t(%d)\n", STM_SETICON);
  printf("#define STM_SETIMAGE\t(%d)\n", STM_SETIMAGE);
  printf("\n/* Static control notifications */\n");
  printf("#define STN_CLICKED\t(%d)\n", STN_CLICKED);
  printf("#define STN_DBLCLK\t(%d)\n", STN_DBLCLK);
  printf("#define STN_DISABLE\t(%d)\n", STN_DISABLE);
  printf("#define STN_ENABLE\t(%d)\n", STN_ENABLE);

  printf("\n/* Toolbar control */\n");
  printf("#define TB_ADDBITMAP\t(%d)\n", TB_ADDBITMAP);
  printf("#define TB_ADDBUTTONS\t(%d)\n", TB_ADDBUTTONS);
  printf("#define TB_AUTOSIZE\t(%d)\n", TB_AUTOSIZE);
  printf("#define TB_BUTTONCOUNT\t(%d)\n", TB_BUTTONCOUNT);
  printf("#define TB_BUTTONSTRUCTSIZE\t(%d)\n", TB_BUTTONSTRUCTSIZE);
  printf("#define TB_CHANGEBITMAP\t(%d)\n", TB_CHANGEBITMAP);
  printf("#define TB_CHECKBUTTON\t(%d)\n", TB_CHECKBUTTON);
  printf("#define TB_COMMANDTOINDEX\t(%d)\n", TB_COMMANDTOINDEX);
  printf("#define TB_CUSTOMIZE\t(%d)\n", TB_CUSTOMIZE);
  printf("#define TB_DELETEBUTTON\t(%d)\n", TB_DELETEBUTTON);
  printf("#define TB_ENABLEBUTTON\t(%d)\n", TB_ENABLEBUTTON);
  printf("#define TB_GETBITMAP\t(%d)\n", TB_GETBITMAP);
  printf("#define TB_GETBITMAPFLAGS\t(%d)\n", TB_GETBITMAPFLAGS);
  printf("#define TB_GETBUTTON\t(%d)\n", TB_GETBUTTON);
  printf("#define TB_ADDSTRINGW\t(%d)\n", TB_ADDSTRINGW);
  printf("#define TB_GETBUTTONTEXTW\t(%d)\n", TB_GETBUTTONTEXTW);
  printf("#define TB_SAVERESTOREW\t(%d)\n", TB_SAVERESTOREW);
  printf("#define TB_ADDSTRINGA\t(%d)\n", TB_ADDSTRINGA);
  printf("#define TB_GETBUTTONTEXTA\t(%d)\n", TB_GETBUTTONTEXTA);
  printf("#define TB_SAVERESTOREA\t(%d)\n", TB_SAVERESTOREA);
  printf("#ifdef UNICODE\n");
  printf("#define TB_ADDSTRING TB_ADDSTRINGW\n");
  printf("#define TB_GETBUTTONTEXT TB_GETBUTTONTEXTW\n");
  printf("#define TB_SAVERESTORE TB_SAVERESTOREW\n");
  printf("#else\n");
  printf("#define TB_ADDSTRING TB_ADDSTRINGA\n");
  printf("#define TB_GETBUTTONTEXT TB_GETBUTTONTEXTA\n");
  printf("#define TB_SAVERESTORE TB_SAVERESTOREA\n");
  printf("#endif /* UNICODE */\n");
  printf("#define TB_GETITEMRECT\t(%d)\n", TB_GETITEMRECT);
  printf("#define TB_GETROWS\t(%d)\n", TB_GETROWS);
  printf("#define TB_GETSTATE\t(%d)\n", TB_GETSTATE);
  printf("#define TB_GETTOOLTIPS\t(%d)\n", TB_GETTOOLTIPS);
  printf("#define TB_HIDEBUTTON\t(%d)\n", TB_HIDEBUTTON);
  printf("#define TB_INDETERMINATE\t(%d)\n", TB_INDETERMINATE);
  printf("#define TB_INSERTBUTTON\t(%d)\n", TB_INSERTBUTTON);
  printf("#define TB_ISBUTTONCHECKED\t(%d)\n", TB_ISBUTTONCHECKED);
  printf("#define TB_ISBUTTONENABLED\t(%d)\n", TB_ISBUTTONENABLED);
  printf("#define TB_ISBUTTONHIDDEN\t(%d)\n", TB_ISBUTTONHIDDEN);
  printf("#define TB_ISBUTTONINDETERMINATE\t(%d)\n", TB_ISBUTTONINDETERMINATE);
  printf("#define TB_ISBUTTONPRESSED\t(%d)\n", TB_ISBUTTONPRESSED);
  printf("#define TB_PRESSBUTTON\t(%d)\n", TB_PRESSBUTTON);
  printf("#define TB_SETBITMAPSIZE\t(%d)\n", TB_SETBITMAPSIZE);
  printf("#define TB_SETBUTTONSIZE\t(%d)\n", TB_SETBUTTONSIZE);
  printf("#define TB_SETCMDID\t(%d)\n", TB_SETCMDID);
  printf("#define TB_SETPARENT\t(%d)\n", TB_SETPARENT);
  printf("#define TB_SETROWS\t(%d)\n", TB_SETROWS);
  printf("#define TB_SETSTATE\t(%d)\n", TB_SETSTATE);
  printf("#define TB_SETTOOLTIPS\t(%d)\n", TB_SETTOOLTIPS);

  printf("\n/* Track bar control */\n");
  printf("#define TBM_CLEARSEL\t(%d)\n", TBM_CLEARSEL);
  printf("#define TBM_CLEARTICS\t(%d)\n", TBM_CLEARTICS);
  printf("#define TBM_GETCHANNELRECT\t(%d)\n", TBM_GETCHANNELRECT);
  printf("#define TBM_GETLINESIZE\t(%d)\n", TBM_GETLINESIZE);
  printf("#define TBM_GETNUMTICS\t(%d)\n", TBM_GETNUMTICS);
  printf("#define TBM_GETPAGESIZE\t(%d)\n", TBM_GETPAGESIZE);
  printf("#define TBM_GETPOS\t(%d)\n", TBM_GETPOS);
  printf("#define TBM_GETPTICS\t(%d)\n", TBM_GETPTICS);
  printf("#define TBM_GETRANGEMAX\t(%d)\n", TBM_GETRANGEMAX);
  printf("#define TBM_GETRANGEMIN\t(%d)\n", TBM_GETRANGEMIN);
  printf("#define TBM_GETSELEND\t(%d)\n", TBM_GETSELEND);
  printf("#define TBM_GETSELSTART\t(%d)\n", TBM_GETSELSTART);
  printf("#define TBM_GETTHUMBLENGTH\t(%d)\n", TBM_GETTHUMBLENGTH);
  printf("#define TBM_GETTHUMBRECT\t(%d)\n", TBM_GETTHUMBRECT);
  printf("#define TBM_GETTIC\t(%d)\n", TBM_GETTIC);
  printf("#define TBM_GETTICPOS\t(%d)\n", TBM_GETTICPOS);
  printf("#define TBM_SETLINESIZE\t(%d)\n", TBM_SETLINESIZE);
  printf("#define TBM_SETPAGESIZE\t(%d)\n", TBM_SETPAGESIZE);
  printf("#define TBM_SETPOS\t(%d)\n", TBM_SETPOS);
  printf("#define TBM_SETRANGE\t(%d)\n", TBM_SETRANGE);
  printf("#define TBM_SETRANGEMAX\t(%d)\n", TBM_SETRANGEMAX);
  printf("#define TBM_SETRANGEMIN\t(%d)\n", TBM_SETRANGEMIN);
  printf("#define TBM_SETSEL\t(%d)\n", TBM_SETSEL);
  printf("#define TBM_SETSELEND\t(%d)\n", TBM_SETSELEND);
  printf("#define TBM_SETSELSTART\t(%d)\n", TBM_SETSELSTART);
  printf("#define TBM_SETTHUMBLENGTH\t(%d)\n", TBM_SETTHUMBLENGTH);
  printf("#define TBM_SETTIC\t(%d)\n", TBM_SETTIC);
  printf("#define TBM_SETTICFREQ\t(%d)\n", TBM_SETTICFREQ);

  printf("\n/* Tool bar control notifications */\n");
  printf("#define TBN_BEGINADJUST\t(%d)\n", TBN_BEGINADJUST);
  printf("#define TBN_BEGINDRAG\t(%d)\n", TBN_BEGINDRAG);
  printf("#define TBN_CUSTHELP\t(%d)\n", TBN_CUSTHELP);
  printf("#define TBN_ENDADJUST\t(%d)\n", TBN_ENDADJUST);
  printf("#define TBN_ENDDRAG\t(%d)\n", TBN_ENDDRAG);
  printf("#define TBN_GETBUTTONINFOW\t(%d)\n", TBN_GETBUTTONINFOW);
  printf("#define TBN_GETBUTTONINFOA\t(%d)\n", TBN_GETBUTTONINFOA);
  printf("#ifdef UNICODE\n");
  printf("#define TBN_GETBUTTONINFO TBN_GETBUTTONINFOW\n");
  printf("#else\n");
  printf("#define TBN_GETBUTTONINFO TBN_GETBUTTONINFOA\n");
  printf("#endif /* UNICODE */\n");
  printf("#define TBN_QUERYDELETE\t(%d)\n", TBN_QUERYDELETE);
  printf("#define TBN_QUERYINSERT\t(%d)\n", TBN_QUERYINSERT);
  printf("#define TBN_RESET\t(%d)\n", TBN_RESET);
  printf("#define TBN_TOOLBARCHANGE\t(%d)\n", TBN_TOOLBARCHANGE);

  printf("\n/* Tab control */\n");
  printf("#define TCM_ADJUSTRECT\t(%d)\n", TCM_ADJUSTRECT);
  printf("#define TCM_DELETEALLITEMS\t(%d)\n", TCM_DELETEALLITEMS);
  printf("#define TCM_DELETEITEM\t(%d)\n", TCM_DELETEITEM);
  /* TODO:
  printf("#define TCM_GETBKCOLOR\t(%d)\n", TCM_GETBKCOLOR);
  */
  printf("#define TCM_GETCURFOCUS\t(%d)\n", TCM_GETCURFOCUS);
  printf("#define TCM_GETCURSEL\t(%d)\n", TCM_GETCURSEL);
  printf("#define TCM_GETIMAGELIST\t(%d)\n", TCM_GETIMAGELIST);
  printf("#define TCM_GETITEMW\t(%d)\n", TCM_GETITEMW);
  printf("#define TCM_INSERTITEMW\t(%d)\n", TCM_INSERTITEMW);
  printf("#define TCM_SETITEMW\t(%d)\n", TCM_SETITEMW);
  printf("#define TCM_GETITEMA\t(%d)\n", TCM_GETITEMA);
  printf("#define TCM_INSERTITEMA\t(%d)\n", TCM_INSERTITEMA);
  printf("#define TCM_SETITEMA\t(%d)\n", TCM_SETITEMA);
  printf("#ifdef UNICODE\n");
  printf("#define TCM_GETITEM TCM_GETITEM\n");
  printf("#define TCM_INSERTITEM TCM_INSERTITEMW\n");
  printf("#define TCM_SETITEM TCM_SETITEMW\n");
  printf("#else\n");
  printf("#define TCM_GETITEM TCM_GETITEMA\n");
  printf("#define TCM_INSERTITEM TCM_INSERTITEMA\n");
  printf("#define TCM_SETITEM TCM_SETITEMA\n");
  printf("#endif /* UNICODE */\n");
  printf("#define TCM_GETITEMCOUNT\t(%d)\n", TCM_GETITEMCOUNT);
  printf("#define TCM_GETITEMRECT\t(%d)\n", TCM_GETITEMRECT);
  printf("#define TCM_GETROWCOUNT\t(%d)\n", TCM_GETROWCOUNT);
  printf("#define TCM_GETTOOLTIPS\t(%d)\n", TCM_GETTOOLTIPS);
  printf("#define TCM_HITTEST\t(%d)\n", TCM_HITTEST);
  printf("#define TCM_REMOVEIMAGE\t(%d)\n", TCM_REMOVEIMAGE);
  /* TODO:
  printf("#define TCM_SETBKCOLOR\t(%d)\n", TCM_SETBKCOLOR); 
  */
  printf("#define TCM_SETCURFOCUS\t(%d)\n", TCM_SETCURFOCUS);
  printf("#define TCM_SETCURSEL\t(%d)\n", TCM_SETCURSEL);
  printf("#define TCM_SETIMAGELIST\t(%d)\n", TCM_SETIMAGELIST);
  printf("#define TCM_SETITEMEXTRA\t(%d)\n", TCM_SETITEMEXTRA);
  printf("#define TCM_SETITEMSIZE\t(%d)\n", TCM_SETITEMSIZE);
  printf("#define TCM_SETPADDING\t(%d)\n", TCM_SETPADDING);
  printf("#define TCM_SETTOOLTIPS\t(%d)\n", TCM_SETTOOLTIPS);

  printf("\n/* Tab control notifications */\n");
  printf("#define TCN_KEYDOWN\t(%d)\n", TCN_KEYDOWN);
  printf("#define TCN_SELCHANGE\t(%d)\n", TCN_SELCHANGE);
  printf("#define TCN_SELCHANGING\t(%d)\n", TCN_SELCHANGING);

  printf("\n/* Tool tip control */\n");
  printf("#define TTM_ACTIVATE\t(%d)\n", TTM_ACTIVATE);
  printf("#define TTM_ADDTOOLW\t(%d)\n", TTM_ADDTOOLW);
  printf("#define TTM_DELTOOLW\t(%d)\n", TTM_DELTOOLW);
  printf("#define TTM_ENUMTOOLSW\t(%d)\n", TTM_ENUMTOOLSW);
  printf("#define TTM_GETCURRENTTOOLW\t(%d)\n", TTM_GETCURRENTTOOLW);
  printf("#define TTM_GETTEXTW\t(%d)\n", TTM_GETTEXTW);
  printf("#define TTM_GETTOOLINFOW\t(%d)\n", TTM_GETTOOLINFOW);
  printf("#define TTM_HITTESTW\t(%d)\n", TTM_HITTESTW);
  printf("#define TTM_NEWTOOLRECTW\t(%d)\n", TTM_NEWTOOLRECTW);
  printf("#define TTM_SETTOOLINFOW\t(%d)\n", TTM_SETTOOLINFOW);
  printf("#define TTM_UPDATETIPTEXTW\t(%d)\n", TTM_UPDATETIPTEXTW);
  printf("#define TTM_ADDTOOLA\t(%d)\n", TTM_ADDTOOLA);
  printf("#define TTM_DELTOOLA\t(%d)\n", TTM_DELTOOLA);
  printf("#define TTM_ENUMTOOLSA\t(%d)\n", TTM_ENUMTOOLSA);
  printf("#define TTM_GETCURRENTTOOLA\t(%d)\n", TTM_GETCURRENTTOOLA);
  printf("#define TTM_GETTEXTA\t(%d)\n", TTM_GETTEXTA);
  printf("#define TTM_GETTOOLINFOA\t(%d)\n", TTM_GETTOOLINFOA);
  printf("#define TTM_HITTESTA\t(%d)\n", TTM_HITTESTA);
  printf("#define TTM_NEWTOOLRECTA\t(%d)\n", TTM_NEWTOOLRECTA);
  printf("#define TTM_SETTOOLINFOA\t(%d)\n", TTM_SETTOOLINFOA);
  printf("#define TTM_UPDATETIPTEXTA\t(%d)\n", TTM_UPDATETIPTEXTA);
  printf("#ifdef UNICODE\n");
  printf("#define TTM_ADDTOOL TTM_ADDTOOLW\n");
  printf("#define TTM_DELTOOL TTM_DELTOOLW\n");
  printf("#define TTM_ENUMTOOLS TTM_ENUMTOOLSW\n");
  printf("#define TTM_GETCURRENTTOOL TTM_GETCURRENTTOOLW\n");
  printf("#define TTM_GETTEXT TTM_GETTEXTW\n");
  printf("#define TTM_GETTOOLINFO TTM_GETTOOLINFOW\n");
  printf("#define TTM_HITTEST TTM_HITTESTW\n");
  printf("#define TTM_NEWTOOLRECT TTM_NEWTOOLRECTW\n");
  printf("#define TTM_SETTOOLINFO TTM_SETTOOLINFOW\n");
  printf("#define TTM_UPDATETIPTEXT TTM_UPDATETIPTEXTW\n");
  printf("#else\n");
  printf("#define TTM_ADDTOOL TTM_ADDTOOLA\n");
  printf("#define TTM_DELTOOL TTM_DELTOOLA\n");
  printf("#define TTM_ENUMTOOLS TTM_ENUMTOOLSA\n");
  printf("#define TTM_GETCURRENTTOOL TTM_GETCURRENTTOOLA\n");
  printf("#define TTM_GETTEXT TTM_GETTEXTA\n");
  printf("#define TTM_GETTOOLINFO TTM_GETTOOLINFOA\n");
  printf("#define TTM_HITTEST TTM_HITTESTA\n");
  printf("#define TTM_NEWTOOLRECT TTM_NEWTOOLRECTA\n");
  printf("#define TTM_SETTOOLINFO TTM_SETTOOLINFOA\n");
  printf("#define TTM_UPDATETIPTEXT TTM_UPDATETIPTEXTA\n");
  printf("#endif /* UNICODE */\n");
  printf("#define TTM_GETTOOLCOUNT\t(%d)\n", TTM_GETTOOLCOUNT);
  printf("#define TTM_RELAYEVENT\t(%d)\n", TTM_RELAYEVENT);
  printf("#define TTM_SETDELAYTIME\t(%d)\n", TTM_SETDELAYTIME);
  printf("#define TTM_WINDOWFROMPOINT\t(%d)\n", TTM_WINDOWFROMPOINT);

  printf("\n/* Tool tip control notification */\n");
  printf("#define TTN_NEEDTEXTW\t(%d)\n", TTN_NEEDTEXTW);
  printf("#define TTN_NEEDTEXTA\t(%d)\n", TTN_NEEDTEXTA);
  printf("#ifdef UNICODE\n");
  printf("#define TTN_NEEDTEXT TTN_NEEDTEXTW\n");
  printf("#else\n");
  printf("#define TTN_NEEDTEXT TTN_NEEDTEXTA\n");
  printf("#endif /* UNICODE */\n");
  printf("#define TTN_POP\t(%d)\n", TTN_POP);
  printf("#define TTN_SHOW\t(%d)\n", TTN_SHOW);

  printf("\n/* Tree view control */\n");
  printf("#define TVM_CREATEDRAGIMAGE\t(%d)\n", TVM_CREATEDRAGIMAGE);
  printf("#define TVM_DELETEITEM\t(%d)\n", TVM_DELETEITEM);
  printf("#define TVM_ENDEDITLABELNOW\t(%d)\n", TVM_ENDEDITLABELNOW);
  printf("#define TVM_ENSUREVISIBLE\t(%d)\n", TVM_ENSUREVISIBLE);
  printf("#define TVM_EXPAND\t(%d)\n", TVM_EXPAND);
  printf("#define TVM_GETCOUNT\t(%d)\n", TVM_GETCOUNT);
  printf("#define TVM_GETEDITCONTROL\t(%d)\n", TVM_GETEDITCONTROL);
  printf("#define TVM_GETIMAGELIST\t(%d)\n", TVM_GETIMAGELIST);
  printf("#define TVM_GETINDENT\t(%d)\n", TVM_GETINDENT);
  printf("#define TVM_GETITEMRECT\t(%d)\n", TVM_GETITEMRECT);
  printf("#define TVM_GETNEXTITEM\t(%d)\n", TVM_GETNEXTITEM);
  printf("#define TVM_GETVISIBLECOUNT\t(%d)\n", TVM_GETVISIBLECOUNT);
  printf("#define TVM_HITTEST\t(%d)\n", TVM_HITTEST);
  printf("#define TVM_EDITLABELW\t(%d)\n", TVM_EDITLABELW);
  printf("#define TVM_GETISEARCHSTRINGW\t(%d)\n", TVM_GETISEARCHSTRINGW);
  printf("#define TVM_GETITEMW\t(%d)\n", TVM_GETITEMW);
  printf("#define TVM_INSERTITEMW\t(%d)\n", TVM_INSERTITEMW);
  printf("#define TVM_SETITEMW\t(%d)\n", TVM_SETITEMW);
  printf("#define TVM_EDITLABELA\t(%d)\n", TVM_EDITLABELA);
  printf("#define TVM_GETISEARCHSTRINGA\t(%d)\n", TVM_GETISEARCHSTRINGA);
  printf("#define TVM_GETITEMA\t(%d)\n", TVM_GETITEMA);
  printf("#define TVM_INSERTITEMA\t(%d)\n", TVM_INSERTITEMA);
  printf("#define TVM_SETITEMA\t(%d)\n", TVM_SETITEMA);
  printf("#ifdef UNICODE\n");
  printf("#define TVM_EDITLABEL TVM_EDITLABELW\n");
  printf("#define TVM_GETISEARCHSTRING TVM_GETISEARCHSTRINGW\n");
  printf("#define TVM_GETITEM TVM_GETITEMW\n");
  printf("#define TVM_INSERTITEM TVM_INSERTITEMW\n");
  printf("#define TVM_SETITEM TVM_SETITEMW\n");
  printf("#else\n");
  printf("#define TVM_EDITLABEL TVM_EDITLABELA\n");
  printf("#define TVM_GETISEARCHSTRING TVM_GETISEARCHSTRINGA\n");
  printf("#define TVM_GETITEM TVM_GETITEMA\n");
  printf("#define TVM_INSERTITEM TVM_INSERTITEMA\n");
  printf("#define TVM_SETITEM TVM_SETITEMA\n");
  printf("#endif /* UNICODE */\n");
  printf("#define TVM_SELECTITEM\t(%d)\n", TVM_SELECTITEM);
  printf("#define TVM_SETIMAGELIST\t(%d)\n", TVM_SETIMAGELIST);
  printf("#define TVM_SETINDENT\t(%d)\n", TVM_SETINDENT);
  printf("#define TVM_SORTCHILDREN\t(%d)\n", TVM_SORTCHILDREN);
  printf("#define TVM_SORTCHILDRENCB\t(%d)\n", TVM_SORTCHILDRENCB);

  printf("\n/* Tree view control notification */\n");
  printf("#define TVN_KEYDOWN\t(%d)\n", TVN_KEYDOWN);
  printf("#define TVN_BEGINDRAGW\t(%d)\n", TVN_BEGINDRAGW);
  printf("#define TVN_BEGINLABELEDITW\t(%d)\n", TVN_BEGINLABELEDITW);
  printf("#define TVN_BEGINRDRAGW\t(%d)\n", TVN_BEGINRDRAGW);
  printf("#define TVN_DELETEITEMW\t(%d)\n", TVN_DELETEITEMW);
  printf("#define TVN_ENDLABELEDITW\t(%d)\n", TVN_ENDLABELEDITW);
  printf("#define TVN_GETDISPINFOW\t(%d)\n", TVN_GETDISPINFOW);
  printf("#define TVN_ITEMEXPANDEDW\t(%d)\n", TVN_ITEMEXPANDEDW);
  printf("#define TVN_ITEMEXPANDINGW\t(%d)\n", TVN_ITEMEXPANDINGW);
  printf("#define TVN_SELCHANGEDW\t(%d)\n", TVN_SELCHANGEDW);
  printf("#define TVN_SELCHANGINGW\t(%d)\n", TVN_SELCHANGINGW);
  printf("#define TVN_SETDISPINFOW\t(%d)\n", TVN_SETDISPINFOW);
  printf("#define TVN_BEGINDRAGA\t(%d)\n", TVN_BEGINDRAGA);
  printf("#define TVN_BEGINLABELEDITA\t(%d)\n", TVN_BEGINLABELEDITA);
  printf("#define TVN_BEGINRDRAGA\t(%d)\n", TVN_BEGINRDRAGA);
  printf("#define TVN_DELETEITEMA\t(%d)\n", TVN_DELETEITEMA);
  printf("#define TVN_ENDLABELEDITA\t(%d)\n", TVN_ENDLABELEDITA);
  printf("#define TVN_GETDISPINFOA\t(%d)\n", TVN_GETDISPINFOA);
  printf("#define TVN_ITEMEXPANDEDA\t(%d)\n", TVN_ITEMEXPANDEDA);
  printf("#define TVN_ITEMEXPANDINGA\t(%d)\n", TVN_ITEMEXPANDINGA);
  printf("#define TVN_SELCHANGEDA\t(%d)\n", TVN_SELCHANGEDA);
  printf("#define TVN_SELCHANGINGA\t(%d)\n", TVN_SELCHANGINGA);
  printf("#define TVN_SETDISPINFOA\t(%d)\n", TVN_SETDISPINFOA);
  printf("#ifdef UNICODE\n");
  printf("#define TVN_BEGINDRAG TVN_BEGINDRAGW\n");
  printf("#define TVN_BEGINLABELEDIT TVN_BEGINLABELEDITW\n");
  printf("#define TVN_BEGINRDRAG TVN_BEGINRDRAGW\n");
  printf("#define TVN_DELETEITEM TVN_DELETEITEMW\n");
  printf("#define TVN_ENDLABELEDIT TVN_ENDLABELEDITW\n");
  printf("#define TVN_GETDISPINFO TVN_GETDISPINFOW\n");
  printf("#define TVN_ITEMEXPANDED TVN_ITEMEXPANDEDW\n");
  printf("#define TVN_ITEMEXPANDING TVN_ITEMEXPANDINGW\n");
  printf("#define TVN_SELCHANGED TVN_SELCHANGEDW\n");
  printf("#define TVN_SELCHANGING TVN_SELCHANGINGW\n");
  printf("#define TVN_SETDISPINFO TVN_SETDISPINFOW\n");
  printf("#else\n");
  printf("#define TVN_BEGINDRAG TVN_BEGINDRAGA\n");
  printf("#define TVN_BEGINLABELEDIT TVN_BEGINLABELEDITA\n");
  printf("#define TVN_BEGINRDRAG TVN_BEGINRDRAGA\n");
  printf("#define TVN_DELETEITEM TVN_DELETEITEMA\n");
  printf("#define TVN_ENDLABELEDIT TVN_ENDLABELEDITA\n");
  printf("#define TVN_GETDISPINFO TVN_GETDISPINFOA\n");
  printf("#define TVN_ITEMEXPANDED TVN_ITEMEXPANDEDA\n");
  printf("#define TVN_ITEMEXPANDING TVN_ITEMEXPANDINGA\n");
  printf("#define TVN_SELCHANGED TVN_SELCHANGEDA\n");
  printf("#define TVN_SELCHANGING TVN_SELCHANGINGA\n");
  printf("#define TVN_SETDISPINFO TVN_SETDISPINFOA\n");
  printf("#endif /* UNICODE */\n");

  printf("\n/* Up/down control */\n");
  printf("#define UDM_GETACCEL\t(%d)\n", UDM_GETACCEL);
  printf("#define UDM_GETBASE\t(%d)\n", UDM_GETBASE);
  printf("#define UDM_GETBUDDY\t(%d)\n", UDM_GETBUDDY);
  printf("#define UDM_GETPOS\t(%d)\n", UDM_GETPOS);
  printf("#define UDM_GETRANGE\t(%d)\n", UDM_GETRANGE);
  printf("#define UDM_SETACCEL\t(%d)\n", UDM_SETACCEL);
  printf("#define UDM_SETBASE\t(%d)\n", UDM_SETBASE);
  printf("#define UDM_SETBUDDY\t(%d)\n", UDM_SETBUDDY);
  printf("#define UDM_SETPOS\t(%d)\n", UDM_SETPOS);
  printf("#define UDM_SETRANGE\t(%d)\n", UDM_SETRANGE);
  printf("\n/* Up/down control notification */\n");
  printf("#define UDN_DELTAPOS\t(%d)\n", UDN_DELTAPOS);

  printf("\n/* Window messages */\n");
  printf("#define WM_ACTIVATE\t(%d)\n", WM_ACTIVATE);
  printf("#define WM_ACTIVATEAPP\t(%d)\n", WM_ACTIVATEAPP);
  printf("#define WM_ASKCBFORMATNAME\t(%d)\n", WM_ASKCBFORMATNAME);
  printf("#define WM_CANCELJOURNAL\t(%d)\n", WM_CANCELJOURNAL);
  printf("#define WM_CANCELMODE\t(%d)\n", WM_CANCELMODE);
  printf("#define WM_CAPTURECHANGED\t(%d)\n", WM_CAPTURECHANGED);
  printf("#define WM_CHANGECBCHAIN\t(%d)\n", WM_CHANGECBCHAIN);
  printf("#define WM_CHAR\t(%d)\n", WM_CHAR);
  printf("#define WM_CHARTOITEM\t(%d)\n", WM_CHARTOITEM);
  printf("#define WM_CHILDACTIVATE\t(%d)\n", WM_CHILDACTIVATE);
  printf("#define WM_CHOOSEFONT_GETLOGFONT\t(%d)\n", WM_CHOOSEFONT_GETLOGFONT);
  printf("#define WM_CHOOSEFONT_SETLOGFONT\t(%d)\n", WM_CHOOSEFONT_SETLOGFONT);
  printf("#define WM_CHOOSEFONT_SETFLAGS\t(%d)\n", WM_CHOOSEFONT_SETFLAGS);
  printf("#define WM_CLEAR\t(%d)\n", WM_CLEAR);
  printf("#define WM_CLOSE\t(%d)\n", WM_CLOSE);
  printf("#define WM_COMMAND\t(%d)\n", WM_COMMAND);
  printf("#define WM_COMPACTING\t(%d)\n", WM_COMPACTING);
  printf("#define WM_COMPAREITEM\t(%d)\n", WM_COMPAREITEM);
  printf("#define WM_CONTEXTMENU\t(%d)\n", WM_CONTEXTMENU);
  printf("#define WM_COPY\t(%d)\n", WM_COPY);
  printf("#define WM_COPYDATA\t(%d)\n", WM_COPYDATA);
  /* TODO: Where is the Control Panel stuff
  printf("#define WM_CPL_LAUNCH\t(%d)\n", WM_CPL_LAUNCH);
  printf("#define WM_CPL_LAUNCHED\t(%d)\n", WM_CPL_LAUNCHED);
  */
  printf("#define WM_CREATE\t(%d)\n", WM_CREATE);
  printf("#define WM_CTLCOLORBTN\t(%d)\n", WM_CTLCOLORBTN);
  printf("#define WM_CTLCOLORDLG\t(%d)\n", WM_CTLCOLORDLG);
  printf("#define WM_CTLCOLOREDIT\t(%d)\n", WM_CTLCOLOREDIT);
  printf("#define WM_CTLCOLORLISTBOX\t(%d)\n", WM_CTLCOLORLISTBOX);
  printf("#define WM_CTLCOLORMSGBOX\t(%d)\n", WM_CTLCOLORMSGBOX);
  printf("#define WM_CTLCOLORSCROLLBAR\t(%d)\n", WM_CTLCOLORSCROLLBAR);
  printf("#define WM_CTLCOLORSTATIC\t(%d)\n", WM_CTLCOLORSTATIC);
  printf("#define WM_CUT\t(%d)\n", WM_CUT);
  /* TODO: Where is the DDE stuff
  printf("#define WM_DDE_ACK\t(%d)\n", WM_DDE_ACK);
  printf("#define WM_DDE_ADVISE\t(%d)\n", WM_DDE_ADVISE);
  printf("#define WM_DDE_DATA\t(%d)\n", WM_DDE_DATE);
  printf("#define WM_DDE_EXECUTE\t(%d)\n", WM_DDE_EXECUTE);
  printf("#define WM_DDE_INITIATE\t(%d)\n", WM_DDE_INITIATE);
  printf("#define WM_DDE_POKE\t(%d)\n", WM_DDE_POKE);
  printf("#define WM_DDE_REQUEST\t(%d)\n", WM_DDE_REQUEST);
  printf("#define WM_DDE_TERMINATE\t(%d)\n", WM_DDE_TERMINATE);
  printf("#define WM_DDE_UNADVISE\t(%d)\n", WM_DDE_UNADVISE);
  */
  printf("#define WM_DEADCHAR\t(%d)\n", WM_DEADCHAR);
  printf("#define WM_DELETEITEM\t(%d)\n", WM_DELETEITEM);
  printf("#define WM_DESTROY\t(%d)\n", WM_DESTROY);
  printf("#define WM_DESTROYCLIPBOARD\t(%d)\n", WM_DESTROYCLIPBOARD);
  printf("#define WM_DEVICECHANGE\t(%d)\n", WM_DEVICECHANGE);
  printf("#define WM_DEVMODECHANGE\t(%d)\n", WM_DEVMODECHANGE);
  printf("#define WM_DISPLAYCHANGE\t(%d)\n", WM_DISPLAYCHANGE);
  printf("#define WM_DRAWCLIPBOARD\t(%d)\n", WM_DRAWCLIPBOARD);
  printf("#define WM_DRAWITEM\t(%d)\n", WM_DRAWITEM);
  printf("#define WM_DROPFILES\t(%d)\n", WM_DROPFILES);
  printf("#define WM_ENABLE\t(%d)\n", WM_ENABLE);
  printf("#define WM_ENDSESSION\t(%d)\n", WM_ENDSESSION);
  printf("#define WM_ENTERIDLE\t(%d)\n", WM_ENTERIDLE);
  printf("#define WM_ENTERMENULOOP\t(%d)\n", WM_ENTERMENULOOP);
  printf("#define WM_ENTERSIZEMOVE\t(%d)\n", WM_ENTERSIZEMOVE);
  printf("#define WM_ERASEBKGND\t(%d)\n", WM_ERASEBKGND);
  printf("#define WM_EXITMENULOOP\t(%d)\n", WM_EXITMENULOOP);
  printf("#define WM_EXITSIZEMOVE\t(%d)\n", WM_EXITSIZEMOVE);
  printf("#define WM_FONTCHANGE\t(%d)\n", WM_FONTCHANGE);
  printf("#define WM_GETDLGCODE\t(%d)\n", WM_GETDLGCODE);
  printf("#define WM_GETFONT\t(%d)\n", WM_GETFONT);
  printf("#define WM_GETHOTKEY\t(%d)\n", WM_GETHOTKEY);
  printf("#define WM_GETICON\t(%d)\n", WM_GETICON);
  printf("#define WM_GETMINMAXINFO\t(%d)\n", WM_GETMINMAXINFO);
  printf("#define WM_GETTEXT\t(%d)\n", WM_GETTEXT);
  printf("#define WM_GETTEXTLENGTH\t(%d)\n", WM_GETTEXTLENGTH);
  printf("#define WM_HELP\t(%d)\n", WM_HELP);
  printf("#define WM_HOTKEY\t(%d)\n", WM_HOTKEY);
  printf("#define WM_HSCROLL\t(%d)\n", WM_HSCROLL);
  printf("#define WM_HSCROLLCLIPBOARD\t(%d)\n", WM_HSCROLLCLIPBOARD);
  printf("#define WM_ICONERASEBKGND\t(%d)\n", WM_ICONERASEBKGND);
  printf("#define WM_IME_CHAR\t(%d)\n", WM_IME_CHAR);
  printf("#define WM_IME_COMPOSITION\t(%d)\n", WM_IME_COMPOSITION);
  printf("#define WM_IME_COMPOSITIONFULL\t(%d)\n", WM_IME_COMPOSITIONFULL);
  printf("#define WM_IME_CONTROL\t(%d)\n", WM_IME_CONTROL);
  printf("#define WM_IME_ENDCOMPOSITION\t(%d)\n", WM_IME_ENDCOMPOSITION);
  printf("#define WM_IME_KEYDOWN\t(%d)\n", WM_IME_KEYDOWN);
  printf("#define WM_IME_KEYUP\t(%d)\n", WM_IME_KEYUP);
  printf("#define WM_IME_NOTIFY\t(%d)\n", WM_IME_NOTIFY);
  printf("#define WM_IME_SELECT\t(%d)\n", WM_IME_SELECT);
  printf("#define WM_IME_SETCONTEXT\t(%d)\n", WM_IME_SETCONTEXT);
  printf("#define WM_IME_STARTCOMPOSITION\t(%d)\n", WM_IME_STARTCOMPOSITION);
  printf("#define WM_INITDIALOG\t(%d)\n", WM_INITDIALOG);
  printf("#define WM_INITMENU\t(%d)\n", WM_INITMENU);
  printf("#define WM_INITMENUPOPUP\t(%d)\n", WM_INITMENUPOPUP);
  printf("#define WM_INPUTLANGCHANGE\t(%d)\n", WM_INPUTLANGCHANGE);
  printf("#define WM_INPUTLANGCHANGEREQUEST\t(%d)\n", WM_INPUTLANGCHANGEREQUEST);
  printf("#define WM_KEYDOWN\t(%d)\n", WM_KEYDOWN);
  printf("#define WM_KEYUP\t(%d)\n", WM_KEYUP);
  printf("#define WM_KILLFOCUS\t(%d)\n", WM_KILLFOCUS);
  printf("#define WM_LBUTTONDBLCLK\t(%d)\n", WM_LBUTTONDBLCLK);
  printf("#define WM_LBUTTONDOWN\t(%d)\n", WM_LBUTTONDOWN);
  printf("#define WM_LBUTTONUP\t(%d)\n", WM_LBUTTONUP);
  printf("#define WM_MBUTTONDBLCLK\t(%d)\n", WM_MBUTTONDBLCLK);
  printf("#define WM_MBUTTONDOWN\t(%d)\n", WM_MBUTTONDOWN);
  printf("#define WM_MBUTTONUP\t(%d)\n", WM_MBUTTONUP);
  printf("#define WM_MDIACTIVATE\t(%d)\n", WM_MDIACTIVATE);
  printf("#define WM_MDICASCADE\t(%d)\n", WM_MDICASCADE);
  printf("#define WM_MDICREATE\t(%d)\n", WM_MDICREATE);
  printf("#define WM_MDIDESTROY\t(%d)\n", WM_MDIDESTROY);
  printf("#define WM_MDIGETACTIVE\t(%d)\n", WM_MDIGETACTIVE);
  printf("#define WM_MDIICONARRANGE\t(%d)\n", WM_MDIICONARRANGE);
  printf("#define WM_MDIMAXIMIZE\t(%d)\n", WM_MDIMAXIMIZE);
  printf("#define WM_MDINEXT\t(%d)\n", WM_MDINEXT);
  printf("#define WM_MDIREFRESHMENU\t(%d)\n", WM_MDIREFRESHMENU);
  printf("#define WM_MDIRESTORE\t(%d)\n", WM_MDIRESTORE);
  printf("#define WM_MDISETMENU\t(%d)\n", WM_MDISETMENU);
  printf("#define WM_MDITILE\t(%d)\n", WM_MDITILE);
  printf("#define WM_MEASUREITEM\t(%d)\n", WM_MEASUREITEM);
  printf("#define WM_MENUCHAR\t(%d)\n", WM_MENUCHAR);
  printf("#define WM_MENUSELECT\t(%d)\n", WM_MENUSELECT);
  printf("#define WM_MOUSEACTIVATE\t(%d)\n", WM_MOUSEACTIVATE);
  printf("#define WM_MOUSEMOVE\t(%d)\n", WM_MOUSEMOVE);
  printf("#define WM_MOVE\t(%d)\n", WM_MOVE);
  printf("#define WM_MOVING\t(%d)\n", WM_MOVING);
  printf("#define WM_NCACTIVATE\t(%d)\n", WM_NCACTIVATE);
  printf("#define WM_NCCALCSIZE\t(%d)\n", WM_NCCALCSIZE);
  printf("#define WM_NCCREATE\t(%d)\n", WM_NCCREATE);
  printf("#define WM_NCDESTROY\t(%d)\n", WM_NCDESTROY);
  printf("#define WM_NCHITTEST\t(%d)\n", WM_NCHITTEST);
  printf("#define WM_NCLBUTTONDBLCLK\t(%d)\n", WM_NCLBUTTONDBLCLK);
  printf("#define WM_NCLBUTTONDOWN\t(%d)\n", WM_NCLBUTTONDOWN);
  printf("#define WM_NCLBUTTONUP\t(%d)\n", WM_NCLBUTTONUP);
  printf("#define WM_NCMBUTTONDBLCLK\t(%d)\n", WM_NCMBUTTONDBLCLK);
  printf("#define WM_NCMBUTTONDOWN\t(%d)\n", WM_NCMBUTTONDOWN);
  printf("#define WM_NCMBUTTONUP\t(%d)\n", WM_NCMBUTTONUP);
  printf("#define WM_NCMOUSEMOVE\t(%d)\n", WM_NCMOUSEMOVE);
  printf("#define WM_NCPAINT\t(%d)\n", WM_NCPAINT);
  printf("#define WM_NCRBUTTONDBLCLK\t(%d)\n", WM_NCRBUTTONDBLCLK);
  printf("#define WM_NCRBUTTONDOWN\t(%d)\n", WM_NCRBUTTONDOWN);
  printf("#define WM_NCRBUTTONUP\t(%d)\n", WM_NCRBUTTONUP);
  printf("#define WM_NEXTDLGCTL\t(%d)\n", WM_NEXTDLGCTL);
  printf("#define WM_NOTIFY\t(%d)\n", WM_NOTIFY);
  printf("#define WM_NOTIFYFORMAT\t(%d)\n", WM_NOTIFYFORMAT);
  printf("#define WM_PAINT\t(%d)\n", WM_PAINT);
  printf("#define WM_PAINTCLIPBOARD\t(%d)\n", WM_PAINTCLIPBOARD);
  printf("#define WM_PAINTICON\t(%d)\n", WM_PAINTICON);
  printf("#define WM_PALETTECHANGED\t(%d)\n", WM_PALETTECHANGED);
  printf("#define WM_PALETTEISCHANGING\t(%d)\n", WM_PALETTEISCHANGING);
  printf("#define WM_PARENTNOTIFY\t(%d)\n", WM_PARENTNOTIFY);
  printf("#define WM_PASTE\t(%d)\n", WM_PASTE);
  printf("#define WM_POWER\t(%d)\n", WM_POWER);
  printf("#define WM_POWERBROADCAST\t(%d)\n", WM_POWERBROADCAST);
  printf("#define WM_PRINT\t(%d)\n", WM_PRINT);
  printf("#define WM_PRINTCLIENT\t(%d)\n", WM_PRINTCLIENT);
  printf("#define WM_PSD_ENVSTAMPRECT\t(%d)\n", WM_PSD_ENVSTAMPRECT);
  printf("#define WM_PSD_FULLPAGERECT\t(%d)\n", WM_PSD_FULLPAGERECT);
  printf("#define WM_PSD_GREEKTEXTRECT\t(%d)\n", WM_PSD_GREEKTEXTRECT);
  printf("#define WM_PSD_MARGINRECT\t(%d)\n", WM_PSD_MARGINRECT);
  printf("#define WM_PSD_MINMARGINRECT\t(%d)\n", WM_PSD_MINMARGINRECT);
  printf("#define WM_PSD_PAGESETUPDLG\t(%d)\n", WM_PSD_PAGESETUPDLG);
  printf("#define WM_PSD_YAFULLPAGERECT\t(%d)\n", WM_PSD_YAFULLPAGERECT);
  printf("#define WM_QUERYDRAGICON\t(%d)\n", WM_QUERYDRAGICON);
  printf("#define WM_QUERYENDSESSION\t(%d)\n", WM_QUERYENDSESSION);
  printf("#define WM_QUERYNEWPALETTE\t(%d)\n", WM_QUERYNEWPALETTE);
  printf("#define WM_QUERYOPEN\t(%d)\n", WM_QUERYOPEN);
  printf("#define WM_QUEUESYNC\t(%d)\n", WM_QUEUESYNC);
  printf("#define WM_QUIT\t(%d)\n", WM_QUIT);
  /* TODO: Remote Access Service
  printf("#define WM_RASDIALEVENT\t(%d)\n", WM_RASDIALEVENT);
  */
  printf("#define WM_RBUTTONDBLCLK\t(%d)\n", WM_RBUTTONDBLCLK);
  printf("#define WM_RBUTTONDOWN\t(%d)\n", WM_RBUTTONDOWN);
  printf("#define WM_RBUTTONUP\t(%d)\n", WM_RBUTTONUP);
  printf("#define WM_RENDERALLFORMATS\t(%d)\n", WM_RENDERALLFORMATS);
  printf("#define WM_RENDERFORMAT\t(%d)\n", WM_RENDERFORMAT);
  printf("#define WM_SETCURSOR\t(%d)\n", WM_SETCURSOR);
  printf("#define WM_SETFOCUS\t(%d)\n", WM_SETFOCUS);
  printf("#define WM_SETFONT\t(%d)\n", WM_SETFONT);
  printf("#define WM_SETHOTKEY\t(%d)\n", WM_SETHOTKEY);
  printf("#define WM_SETICON\t(%d)\n", WM_SETICON);
  printf("#define WM_SETREDRAW\t(%d)\n", WM_SETREDRAW);
  printf("#define WM_SETTEXT\t(%d)\n", WM_SETTEXT);
  printf("#define WM_SETTINGCHANGE\t(%d)\n", WM_SETTINGCHANGE);
  printf("#define WM_SHOWWINDOW\t(%d)\n", WM_SHOWWINDOW);
  printf("#define WM_SIZE\t(%d)\n", WM_SIZE);
  printf("#define WM_SIZECLIPBOARD\t(%d)\n", WM_SIZECLIPBOARD);
  printf("#define WM_SIZING\t(%d)\n", WM_SIZING);
  printf("#define WM_SPOOLERSTATUS\t(%d)\n", WM_SPOOLERSTATUS);
  printf("#define WM_STYLECHANGED\t(%d)\n", WM_STYLECHANGED);
  printf("#define WM_STYLECHANGING\t(%d)\n", WM_STYLECHANGING);
  printf("#define WM_SYSCHAR\t(%d)\n", WM_SYSCHAR);
  printf("#define WM_SYSCOLORCHANGE\t(%d)\n", WM_SYSCOLORCHANGE);
  printf("#define WM_SYSCOMMAND\t(%d)\n", WM_SYSCOMMAND);
  printf("#define WM_SYSDEADCHAR\t(%d)\n", WM_SYSDEADCHAR);
  printf("#define WM_SYSKEYDOWN\t(%d)\n", WM_SYSKEYDOWN);
  printf("#define WM_SYSKEYUP\t(%d)\n", WM_SYSKEYUP);
  printf("#define WM_TCARD\t(%d)\n", WM_TCARD);
  printf("#define WM_TIMECHANGE\t(%d)\n", WM_TIMECHANGE);
  printf("#define WM_TIMER\t(%d)\n", WM_TIMER);
  printf("#define WM_UNDO\t(%d)\n", WM_UNDO);
  printf("#define WM_USER\t(%d)\n", WM_USER);
  printf("#define WM_USERCHANGED\t(%d)\n", WM_USERCHANGED);
  printf("#define WM_VKEYTOITEM\t(%d)\n", WM_VKEYTOITEM);
  printf("#define WM_VSCROLL\t(%d)\n", WM_VSCROLL);
  printf("#define WM_VSCROLLCLIPBOARD\t(%d)\n", WM_VSCROLLCLIPBOARD);
  printf("#define WM_WINDOWPOSCHANGED\t(%d)\n", WM_WINDOWPOSCHANGED);
  printf("#define WM_WINDOWPOSCHANGING\t(%d)\n", WM_WINDOWPOSCHANGING);
  printf("#define WM_WININICHANGE\t(%d)\n", WM_WININICHANGE);

  printf("\n/* Window message ranges */\n");
  printf("#define WM_KEYFIRST\t(%d)\n", WM_KEYFIRST);
  printf("#define WM_KEYLAST\t(%d)\n", WM_KEYLAST);
  printf("#define WM_MOUSEFIRST\t(%d)\n", WM_MOUSEFIRST);
  printf("#define WM_MOUSELAST\t(%d)\n", WM_MOUSELAST);
  /* TODO: DDE
  printf("#define WM_DDE_FIRST\t(%d)\n", WM_DDE_FIRST);
  printf("#define WM_DDE_LAST\t(%d)\n", WM_DDE_LAST);
  */

  /* End of definitions
     Do not add anything beyond this point */

  printf("\n#ifdef __cplusplus\n");
  printf("}\n");
  printf("#endif /* __cplusplus */\n");

  printf("\n#endif /* _GNU_H_WINDOWS32_MESSAGES */\n");

  return(0);
}
