/*
 *   Copyright (C) 1997, 1998, 1999 Loic Dachary
 *
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */
#ifndef _hooks_h
#define _hooks_h

#include <webbase.h>
#include <webbase_url.h>

#ifdef __cplusplus
extern "C" {
#endif

#define HOOK_MAX_RECORDS	1000000

void hook_init(webbase_t* base);
void hook_verbose(int level);
int hook_ok(webbase_t* base, webbase_url_t* webbase_url);
int hook_insert(webbase_t* base, webbase_url_t* webbase_url);
int hook_insert_watch(webbase_t* base);
int hook_update(webbase_t* base, webbase_url_t* webbase_url);
int hook_delete(webbase_t* base, webbase_url_t* webbase_url);
int hook_delete_id(webbase_t* base, int id, char* url, int url_length);
int hook_rehook_start(webbase_t* base);
int hook_rehook_end(webbase_t* base);
int hook_rebuild_start(webbase_t* base);
int hook_rebuild_end(webbase_t* base);
void hook_info_set(char* info);
void hook_server(int server);
void hook_end();

#ifdef __cplusplus
}
#endif

#endif /* _hooks_h */
