/*
 * Copyright (C) 1997 - 2001 Loic Dachary
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdlib.h>
#ifdef HAVE_DMALLOC_H
#include <dmalloc.h>
#endif /* HAVE_DMALLOC_H */
#include <stdio.h>
#include <string.h>

#include <sqlutil.h>
#include <webbase_create.h>
#include <salloc.h>

static const char* default_schema[] = {
" \n\
create table start ( \n\
  rowid int not null auto_increment, \n\
# \n\
# Crawl data \n\
# \n\
  url text not null, \n\
  url_key char(80) not null default '', \n\
  url_md5 char(32) binary not null default '', \n\
  info set ('sleepy', 'unescape', 'nocookie', 'accept', 'heuristics', \n\
            'sticky', 'filter', 'homefree', 'virgin', 'exploring', 'explored', \n\
            'updating', 'in_core', 'allow', 'disallow', 'hook_info'), \n\
  url_max_size smallint default -1, \n\
  size_hrefs int default 102400, \n\
  min int default -1, \n\
  depth int default 2, \n\
  level int default 1000000, \n\
  timeout smallint default -1, \n\
  loaded_delay smallint default -1, \n\
  modified_delay smallint default -1, \n\
  not_found_delay smallint default -1, \n\
  timeout_delay smallint default -1, \n\
  robot_delay smallint default -1, \n\
  accept varchar(255) binary, \n\
  filter varchar(255) binary, \n\
  allow varchar(255) binary, \n\
  disallow varchar(255) binary, \n\
  regex_allow varchar(255) binary, \n\
  regex_disallow varchar(255) binary, \n\
  hook_info varchar(255) binary, \n\
  sources set ('all'), \n\
  disabled enum ('yes', 'no') default 'no', \n\
  created datetime, \n\
  modified timestamp, \n\
# \n\
# Internal data \n\
# \n\
  count int default 0, \n\
  delay int default 0, \n\
 \n\
# \n\
# User defined data start, may be removed or enriched \n\
# \n\
  email varchar(255), \n\
  comment varchar(255), \n\
  town varchar(64), \n\
  country varchar(64), \n\
#  target varchar(64), \n\
#  category varchar(32), \n\
#  other_categories varchar(255), \n\
#  title varchar(255), \n\
#  keywords varchar(255), \n\
#  entity varchar(32), \n\
#  last_name varchar(64), \n\
#  first_name varchar(64), \n\
#  street varchar(255), \n\
#  zip_code varchar(16), \n\
#  company varchar(32), \n\
#  telephone varchar(32), \n\
#  fax varchar(32), \n\
# \n\
# User defined data end \n\
# \n\
 \n\
  unique start1 (rowid), \n\
  index start2 (url_key), \n\
  unique start3 (url_md5) \n\
)",

" \n\
create table robots ( \n\
  rowid int not null auto_increment, \n\
  netloc varchar(255) binary not null, \n\
  next_crawl int, \n\
  queue_crawl int, \n\
  allow text, \n\
  disallow text, \n\
 \n\
  unique robot1 (rowid), \n\
  unique robot2 (netloc) \n\
)",

" \n\
create table servers ( \n\
  rowid int not null auto_increment, \n\
  server varchar(255) binary not null, \n\
  refcount int default 0, \n\
 \n\
  unique servers1 (rowid), \n\
  unique servers2 (server) \n\
)",

" \n\
create table cookies ( \n\
  netloc varchar(255) binary not null, \n\
  path varchar(255) binary not null, \n\
  cookie_in varchar(255) binary not null, \n\
  cookie_out varchar(255) binary, \n\
#  expires datetime, \n\
 \n\
  unique cookies1 (netloc(122), path(122)) \n\
)",

" \n\
create table start2url ( \n\
  start int not null, \n\
  url int not null, \n\
  level smallint not null default -1, \n\
 \n\
  unique start2url1 (start,url), \n\
  index start2url2 (url) \n\
)",

" \n\
create table url ( \n\
  rowid int not null auto_increment, \n\
  url text not null, \n\
  url_md5 char(32) binary not null default '', \n\
  info set ('frame', 'complete', 'cookie', 'base', 'relative', 'absolute', \n\
            'content', 'location', 'timeout', 'not_modified', 'not_found', 'ok', \n\
	    'error', 'http', 'ftp', 'news', 'cumulmd5', 'extract', 'title', \n\
	    'keywords', 'description', 'reading', 'truncated', 'ftp_dir'), \n\
  code smallint, \n\
  mtime datetime, \n\
  mtime_error datetime, \n\
  tags smallint, \n\
# \n\
# To build this list use schema2list < meta-schema.sql \n\
# Leave 'unknown' in the first position \n\
# Don't forget to remove the comman on the last line. \n\
# \n\
  content_type enum( \n\
    'unknown', \n\
	'application/access', \n\
    'application/activemessage', \n\
    'application/andrew-inset', \n\
    'application/applefile', \n\
    'application/atomicmail', \n\
    'application/cals-1840', \n\
    'application/commonground', \n\
    'application/cybercash', \n\
    'application/dca-rft', \n\
    'application/dec-dx', \n\
    'application/dsptype', \n\
    'application/eshop', \n\
    'application/excel', \n\
	'application/font-tdpfr', \n\
	'application/fractals', \n\
    'application/gzip', \n\
    'application/iges', \n\
	'application/java-archive', \n\
    'application/mac-binhex40', \n\
    'application/macwriteii', \n\
    'application/mathematica', \n\
    'application/msword', \n\
    'application/news-message-id', \n\
    'application/news-transmission', \n\
    'application/octet-stream', \n\
    'application/oda', \n\
    'application/pdf', \n\
    'application/pgp-encrypted', \n\
    'application/pgp-keys', \n\
    'application/pgp-signature', \n\
    'application/postscript', \n\
	'application/powerpoint', \n\
    'application/prs.alvestrand.titrax-sheet', \n\
    'application/remote-printing', \n\
    'application/riscos', \n\
    'application/rtf', \n\
	'application/schedule', \n\
    'application/set-payment', \n\
    'application/set-payment-initiation', \n\
    'application/set-registration', \n\
    'application/set-registration-initiation', \n\
    'application/sgml', \n\
    'application/sgml-open-catalog', \n\
    'application/slate', \n\
    'application/vemmi', \n\
    'application/vnd.businessobjects', \n\
    'application/vnd.enliven', \n\
    'application/vnd.fdf', \n\
    'application/vnd.framemaker', \n\
    'application/vnd.intertrust.digibox', \n\
    'application/vnd.intertrust.nncp', \n\
    'application/vnd.japannet-directory-service', \n\
    'application/vnd.japannet-payment-wakeup', \n\
    'application/vnd.japannet-registration-wakeup', \n\
    'application/vnd.japannet-verification-wakeup', \n\
    'application/vnd.koan', \n\
	'application/vnd.lotus-1-2-3', \n\
	'application/vnd.lotus-approach', \n\
	'application/vnd.lotus-freelance', \n\
	'application/vnd.lotus-organizer', \n\
	'application/vnd.lotus-screencam', \n\
	'application/vnd.lotus-wordpro', \n\
    'application/vnd.meridian-slingshot', \n\
    'application/vnd.mif', \n\
	'application/vnd.ms-access', \n\
    'application/vnd.ms-artgalry', \n\
	'application/vnd.ms-excel', \n\
    'application/vnd.ms-powerpoint', \n\
    'application/vnd.ms-project', \n\
	'application/vnd.ms-schedule', \n\
    'application/vnd.ms-tnef', \n\
    'application/vnd.ms-works', \n\
    'application/vnd.music-niff', \n\
    'application/vnd.noblenet-sealer', \n\
    'application/vnd.rapid', \n\
    'application/vnd.seemail', \n\
    'application/vnd.street-stream', \n\
    'application/vnd.svd', \n\
    'application/vnd.truedoc', \n\
    'application/vnd.xara', \n\
    'application/wita', \n\
    'application/wordperfect', \n\
	'application/wordperfect5.1', \n\
    'application/x-bcpio', \n\
    'application/x-cpio', \n\
    'application/x-csh', \n\
    'application/x-dvi', \n\
	'application/x-freelance', \n\
    'application/x-gtar', \n\
    'application/x-hdf', \n\
	'application/x-javascript', \n\
	'application/x-javascript-config', \n\
    'application/x-latex', \n\
    'application/x-maker', \n\
    'application/x-mif', \n\
    'application/x-netcdf', \n\
	'application/x-ns-proxy-autoconfig', \n\
    'application/x-per', \n\
	'application/x-pkcs7-mime', \n\
	'application/x-pkcs7-signature', \n\
    'application/x-sh', \n\
    'application/x-shar', \n\
	'application/x-stuffit', \n\
    'application/x-sv4cpio', \n\
    'application/x-sv4cr', \n\
    'application/x-tar', \n\
    'application/x-tcl', \n\
    'application/x-tex', \n\
    'application/x-texinfo', \n\
    'application/x-troff', \n\
    'application/x-troff-ma', \n\
    'application/x-troff-me', \n\
    'application/x-troff-ms', \n\
    'application/x-usta', \n\
    'application/x-wais-source', \n\
    'application/x400-bp', \n\
    'application/zcat', \n\
	'application/zip', \n\
    'audio/32kadpcm', \n\
    'audio/basic', \n\
    'audio/vnd.qcelp', \n\
    'audio/x-aiff', \n\
    'audio/x-midi', \n\
    'audio/x-mpeg', \n\
    'audio/x-mpeg-', \n\
    'audio/x-pn-realaudio', \n\
    'audio/x-wav', \n\
    'image/Graphics', \n\
    'image/g3fax', \n\
    'image/gif', \n\
    'image/ief', \n\
    'image/jpe', \n\
    'image/jpeg', \n\
    'image/pn', \n\
    'image/tiff', \n\
    'image/vnd.dwg', \n\
    'image/vnd.dxf', \n\
    'image/vnd.fpx', \n\
    'image/vnd.net-fpx', \n\
    'image/vnd.svf', \n\
    'image/x-bm', \n\
    'image/x-cmu-raste', \n\
    'image/x-cmu-raster', \n\
    'image/x-fit', \n\
	'image/x-photo-cd', \n\
	'image/x-png', \n\
    'image/x-portable-anymap', \n\
    'image/x-portable-bitmap', \n\
    'image/x-portable-graymap', \n\
    'image/x-portable-pixmap', \n\
    'image/x-rgb', \n\
    'image/x-targ', \n\
    'image/x-xbitmap', \n\
    'image/x-xpixmap', \n\
    'image/x-xwindowdump', \n\
    'magnus-internal/cgi', \n\
    'magnus-internal/imagemap', \n\
    'magnus-internal/parsed-html', \n\
    'message/external-body', \n\
    'message/http', \n\
    'message/new', \n\
    'message/partial', \n\
    'message/rfc82', \n\
    'model/iges', \n\
    'model/mesh', \n\
    'model/vrml', \n\
    'multipart/alternative', \n\
    'multipart/appledouble', \n\
    'multipart/byteranges', \n\
    'multipart/digest', \n\
    'multipart/encrypted', \n\
    'multipart/form-data', \n\
    'multipart/header-set', \n\
    'multipart/mixed', \n\
    'multipart/parallel', \n\
    'multipart/report', \n\
    'multipart/signed', \n\
    'multipart/voice-message', \n\
    'text/enriched', \n\
    'text/ftp-dir-listing', \n\
    'text/html', \n\
    'text/plain', \n\
    'text/richtext', \n\
    'text/sgml', \n\
    'text/tab-separated-values', \n\
    'text/vnd.fmi.flexstor', \n\
    'text/vnd.latex-z', \n\
    'text/x-po', \n\
    'text/x-setext', \n\
	'text/x-vcard', \n\
    'video/mpeg', \n\
    'video/quicktime', \n\
    'video/vnd.motorola.video', \n\
    'video/vnd.motorola.videop', \n\
    'video/vnd.vivo', \n\
    'video/x-msvideo', \n\
    'video/x-sgi-movie', \n\
	'www/unknown', \n\
    'x-world/x-vrml' \n\
  ), \n\
  content_length int, \n\
  md5 char(32), \n\
  complete_rowid int not null default 0, \n\
  crawl datetime not null default 0, \n\
  hookid int, \n\
  language enum ('unknown', 'fr', 'uk', 'de', 'it', 'es'), \n\
  extract varchar(255) binary, \n\
  title varchar(255) binary, \n\
 \n\
  unique url1 (rowid), \n\
  unique url3 (url_md5), \n\
  index url4 (complete_rowid), \n\
  index url5 (crawl) \n\
) MAX_ROWS=16000000",

" \n\
create table url_complete ( \n\
  rowid int not null auto_increment, \n\
  keywords varchar(255) binary, \n\
  description varchar(255) binary, \n\
  base_url text, \n\
  relative mediumtext, \n\
  absolute mediumtext, \n\
  location text, \n\
 \n\
  unique urlc1 (rowid) \n\
) MAX_ROWS=16000000",

" \n\
create table mime_restrict ( \n\
  spec char(255) binary not null, \n\
  ext text, \n\
  mime text, \n\
 \n\
  unique mime_restrict1 (spec) \n\
)",

" \n\
create table mime2ext ( \n\
  mime char(64) binary not null, \n\
  ext blob not null, \n\
 \n\
  unique mime2ext1 (mime) \n\
)",

" \n\
create table home_re ( \n\
  netloc char(255) binary not null, \n\
  re char(255), \n\
 \n\
  unique home_re1 (netloc) \n\
)",

" \n\
create table statistics ( \n\
  type char(16) binary not null, \n\
  rank int not null, \n\
  info text, \n\
 \n\
  index statistics1 (type), \n\
  index statistics2 (rank) \n\
)",

" \n\
create table locks ( \n\
  name char(32) not null, \n\
  pid int not null, \n\
 \n\
  unique locks1 (name), \n\
  index locks2 (pid) \n\
)",

"insert into mime2ext values ('application/access', 'mdb,mda,mde,') ",
"insert into mime2ext values ('application/activemessage', '') ",
"insert into mime2ext values ('application/andrew-inset', '') ",
"insert into mime2ext values ('application/applefile', '') ",
"insert into mime2ext values ('application/atomicmail', '') ",
"insert into mime2ext values ('application/cals-1840', '') ",
"insert into mime2ext values ('application/commonground', '') ",
"insert into mime2ext values ('application/cybercash', '') ",
"insert into mime2ext values ('application/dca-rft', '') ",
"insert into mime2ext values ('application/dec-dx', '') ",
"insert into mime2ext values ('application/dsptype', 'tsp,') ",
"insert into mime2ext values ('application/eshop', '') ",
"insert into mime2ext values ('application/excel', 'xls,xlt,xlm,xld,xla,xlc,xlw,xll,') ",
"insert into mime2ext values ('application/font-tdpfr', 'pfr,') ",
"insert into mime2ext values ('application/fractals', 'fif,') ",
"insert into mime2ext values ('application/gzip', 'gz,') ",
"insert into mime2ext values ('application/iges', '') ",
"insert into mime2ext values ('application/java-archive', 'jar,') ",
"insert into mime2ext values ('application/mac-binhex40', 'hqx,') ",
"insert into mime2ext values ('application/macwriteii', '') ",
"insert into mime2ext values ('application/mathematica', '') ",
"insert into mime2ext values ('application/msword', 'doc,') ",
"insert into mime2ext values ('application/news-message-id', '') ",
"insert into mime2ext values ('application/news-transmission', '') ",
"insert into mime2ext values ('application/octet-stream', 'bin,exe,') ",
"insert into mime2ext values ('application/oda', 'oda,') ",
"insert into mime2ext values ('application/pdf', 'pdf,') ",
"insert into mime2ext values ('application/pgp-encrypted', '') ",
"insert into mime2ext values ('application/pgp-keys', '') ",
"insert into mime2ext values ('application/pgp-signature', '') ",
"insert into mime2ext values ('application/postscript', 'ai,eps,ps,') ",
"insert into mime2ext values ('application/powerpoint', 'ppt,pot,ppa,pps,pwz,') ",
"insert into mime2ext values ('application/prs.alvestrand.titrax-sheet', '') ",
"insert into mime2ext values ('application/remote-printing', '') ",
"insert into mime2ext values ('application/riscos', '') ",
"insert into mime2ext values ('application/rtf', 'rtf,') ",
"insert into mime2ext values ('application/schedule', 'scd,sch,sc2,') ",
"insert into mime2ext values ('application/set-payment-initiation', '') ",
"insert into mime2ext values ('application/set-payment', '') ",
"insert into mime2ext values ('application/set-registration-initiation', '') ",
"insert into mime2ext values ('application/set-registration', '') ",
"insert into mime2ext values ('application/sgml', '') ",
"insert into mime2ext values ('application/sgml-open-catalog', '') ",
"insert into mime2ext values ('application/slate', '') ",
"insert into mime2ext values ('application/vemmi', '') ",
"insert into mime2ext values ('application/vnd.businessobjects', '') ",
"insert into mime2ext values ('application/vnd.enliven', '') ",
"insert into mime2ext values ('application/vnd.fdf', '') ",
"insert into mime2ext values ('application/vnd.framemaker', '') ",
"insert into mime2ext values ('application/vnd.intertrust.digibox', '') ",
"insert into mime2ext values ('application/vnd.intertrust.nncp', '') ",
"insert into mime2ext values ('application/vnd.japannet-directory-service', '') ",
"insert into mime2ext values ('application/vnd.japannet-payment-wakeup', '') ",
"insert into mime2ext values ('application/vnd.japannet-registration-wakeup', '') ",
"insert into mime2ext values ('application/vnd.japannet-verification-wakeup', '') ",
"insert into mime2ext values ('application/vnd.koan', '') ",
"insert into mime2ext values ('application/vnd.lotus-1-2-3', '123,wk4,wk3,wk1,') ",
"insert into mime2ext values ('application/vnd.lotus-approach', 'apr,vew,') ",
"insert into mime2ext values ('application/vnd.lotus-freelance', '') ",
"insert into mime2ext values ('application/vnd.lotus-organizer', 'or3,or2,org,') ",
"insert into mime2ext values ('application/vnd.lotus-screencam', 'scm') ",
"insert into mime2ext values ('application/vnd.lotus-wordpro', 'lwp,sam,') ",
"insert into mime2ext values ('application/vnd.meridian-slingshot', '') ",
"insert into mime2ext values ('application/vnd.mif', 'mif,') ",
"insert into mime2ext values ('application/vnd.ms-access', '') ",
"insert into mime2ext values ('application/vnd.ms-artgalry', '') ",
"insert into mime2ext values ('application/vnd.ms-excel', '') ",
"insert into mime2ext values ('application/vnd.ms-powerpoint', '') ",
"insert into mime2ext values ('application/vnd.ms-project', '') ",
"insert into mime2ext values ('application/vnd.ms-schedule', '') ",
"insert into mime2ext values ('application/vnd.ms-tnef', '') ",
"insert into mime2ext values ('application/vnd.ms-works', '') ",
"insert into mime2ext values ('application/vnd.music-niff', '') ",
"insert into mime2ext values ('application/vnd.noblenet-sealer', '') ",
"insert into mime2ext values ('application/vnd.rapid', '') ",
"insert into mime2ext values ('application/vnd.seemail', '') ",
"insert into mime2ext values ('application/vnd.street-stream', '') ",
"insert into mime2ext values ('application/vnd.svd', '') ",
"insert into mime2ext values ('application/vnd.truedoc', '') ",
"insert into mime2ext values ('application/vnd.xara', '') ",
"insert into mime2ext values ('application/wita', '') ",
"insert into mime2ext values ('application/wordperfect5.1', '') ",
"insert into mime2ext values ('application/wordperfect', 'wpd,wp6,') ",
"insert into mime2ext values ('application/x400-bp', '') ",
"insert into mime2ext values ('application/x-ace-compressed', 'ace,c00,c01,c02,c03,c04,c05,c06,c07,c08,c09,c10,c11,c12,c13,c14,c15,c16,c17,c18,c19,c20,c21,c22,c23,c24,c25,c26,c27,c28,c29,c30,c31,c32,c33,c34,c35,c36,c37,c38,c39,c40,c41,c42,c43,c44,c45,c46,c47,c48,c49,c50,c51,c52,c53,c54,c55,c56,c57,c58,c59,c60,c61,c62,c63,c64,c65,c66,c67,c68,c69,c70,c71,c72,c73,c74,c75,c76,c77,c78,c79,c80,c81,c82,c83,c84,c85,c86,c87,c88,c89,c90,c91,c92,c93,c94,c95,c96,c97,c98,c99,') ",
"insert into mime2ext values ('application/x-arj-compressed', 'arj,a00,a01,a02,a03,a04,a05,a06,a07,a08,a09,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19,a20,a21,a22,a23,a24,a25,a26,a27,a28,a29,a30,a31,a32,a33,a34,a35,a36,a37,a38,a39,a40,a41,a42,a43,a44,a45,a46,a47,a48,a49,a50,a51,a52,a53,a54,a55,a56,a57,a58,a59,a60,a61,a62,a63,a64,a65,a66,a67,a68,a69,a70,a71,a72,a73,a74,a75,a76,a77,a78,a79,a80,a81,a82,a83,a84,a85,a86,a87,a88,a89,a90,a91,a92,a93,a94,a95,a96,a97,a98,a99,') ",
"insert into mime2ext values ('application/x-bcpio', 'bcpio,') ",
"insert into mime2ext values ('application/x-cpio', 'cpio,') ",
"insert into mime2ext values ('application/x-csh', 'csh,') ",
"insert into mime2ext values ('application/x-dvi', 'dvi,') ",
"insert into mime2ext values ('application/x-freelance', 'prz,pre,') ",
"insert into mime2ext values ('application/x-gtar', 'gtar,') ",
"insert into mime2ext values ('application/x-hdf', 'hdf,') ",
"insert into mime2ext values ('application/x-javascript-config', 'jsc,') ",
"insert into mime2ext values ('application/x-javascript', 'js,mocha,') ",
"insert into mime2ext values ('application/x-latex', 'latex,') ",
"insert into mime2ext values ('application/x-maker', 'fm,') ",
"insert into mime2ext values ('application/x-mif', 'mif,') ",
"insert into mime2ext values ('application/x-netcdf', 'nc,cdf,') ",
"insert into mime2ext values ('application/x-ns-proxy-autoconfig', 'pac,') ",
"insert into mime2ext values ('application/x-per', 'pl,') ",
"insert into mime2ext values ('application/x-pkcs7-mime', 'p7m,p7c,') ",
"insert into mime2ext values ('application/x-pkcs7-signature', 'p7s,') ",
"insert into mime2ext values ('application/x-rar-compressed', 'rar,r00,r01,r02,r03,r04,r05,r06,r07,r08,r09,r10,r11,r12,r13,r14,r15,r16,r17,r18,r19,r20,r21,r22,r23,r24,r25,r26,r27,r28,r29,r30,r31,r32,r33,r34,r35,r36,r37,r38,r39,r40,r41,r42,r43,r44,r45,r46,r47,r48,r49,r50,r51,r52,r53,r54,r55,r56,r57,r58,r59,r60,r61,r62,r63,r64,r65,r66,r67,r68,r69,r70,r71,r72,r73,r74,r75,r76,r77,r78,r79,r80,r81,r82,r83,r84,r85,r86,r87,r88,r89,r90,r91,r92,r93,r94,r95,r96,r97,r98,r99,') ",
"insert into mime2ext values ('application/x-rpm', 'rpm,') ",
"insert into mime2ext values ('application/x-shar', 'shar,') ",
"insert into mime2ext values ('application/x-sh', 'sh,') ",
"insert into mime2ext values ('application/x-stuffit', 'sit,') ",
"insert into mime2ext values ('application/x-sv4cpio', 'sv4cpio,') ",
"insert into mime2ext values ('application/x-sv4cr', 'sv4crc,') ",
"insert into mime2ext values ('application/x-tar', 'tar,') ",
"insert into mime2ext values ('application/x-tcl', 'tcl,') ",
"insert into mime2ext values ('application/x-texinfo', 'texinfo,texi,') ",
"insert into mime2ext values ('application/x-tex', 'tex,') ",
"insert into mime2ext values ('application/x-troff-ma', 'man,1,2,3,4,5,6,7,8,') ",
"insert into mime2ext values ('application/x-troff-me', 'me,') ",
"insert into mime2ext values ('application/x-troff-ms', 'ms,') ",
"insert into mime2ext values ('application/x-troff', 't,tr,roff,') ",
"insert into mime2ext values ('application/x-usta', 'ustar,') ",
"insert into mime2ext values ('application/x-wais-source', 'src,') ",
"insert into mime2ext values ('application/zcat', 'Z,z,') ",
"insert into mime2ext values ('application/zip', 'zip,z00,z01,z02,z03,z04,z05,z06,z07,z08,z09,z10,z11,z12,z13,z14,z15,z16,z17,z18,z19,z20,z21,z22,z23,z24,z25,z26,z27,z28,z29,z30,z31,z32,z33,z34,z35,z36,z37,z38,z39,z40,z41,z42,z43,z44,z45,z46,z47,z48,z49,z50,z51,z52,z53,z54,z55,z56,z57,z58,z59,z60,z61,z62,z63,z64,z65,z66,z67,z68,z69,z70,z71,z72,z73,z74,z75,z76,z77,z78,z79,z80,z81,z82,z83,z84,z85,z86,z87,z88,z89,z90,z91,z92,z93,z94,z95,z96,z97,z98,z99,') ",
"insert into mime2ext values ('audio/32kadpcm', '') ",
"insert into mime2ext values ('audio/basic', 'au,snd,') ",
"insert into mime2ext values ('audio/vnd.qcelp', '') ",
"insert into mime2ext values ('audio/x-aiff', 'aif,aiff,aifc,') ",
"insert into mime2ext values ('audio/x-midi', 'mid,') ",
"insert into mime2ext values ('audio/x-mpeg', 'mp2,mpa,abs,mpega,') ",
"insert into mime2ext values ('audio/x-mpeg-', '') ",
"insert into mime2ext values ('audio/x-pn-realaudio', 'ra,ram,') ",
"insert into mime2ext values ('audio/x-wav', 'wav,') ",
"insert into mime2ext values ('image/g3fax', '') ",
"insert into mime2ext values ('image/gif', 'gif,') ",
"insert into mime2ext values ('image/Graphics', '') ",
"insert into mime2ext values ('image/ief', 'ief,') ",
"insert into mime2ext values ('image/jpeg', 'jpg,') ",
"insert into mime2ext values ('image/jpe', 'jpeg,jpe,jfif,') ",
"insert into mime2ext values ('image/pn', 'png,') ",
"insert into mime2ext values ('image/tiff', 'tiff,tif,') ",
"insert into mime2ext values ('image/vnd.dwg', '') ",
"insert into mime2ext values ('image/vnd.dxf', '') ",
"insert into mime2ext values ('image/vnd.fpx', '') ",
"insert into mime2ext values ('image/vnd.net-fpx', '') ",
"insert into mime2ext values ('image/vnd.svf', '') ",
"insert into mime2ext values ('image/x-bm', 'bmp,') ",
"insert into mime2ext values ('image/x-cmu-raste', 'ras,') ",
"insert into mime2ext values ('image/x-cmu-raster', 'ras,') ",
"insert into mime2ext values ('image/x-fit', 'fts,') ",
"insert into mime2ext values ('image/x-photo-cd', 'pcd,') ",
"insert into mime2ext values ('image/x-png', '') ",
"insert into mime2ext values ('image/x-portable-anymap', 'pnm,') ",
"insert into mime2ext values ('image/x-portable-bitmap', 'pbm,') ",
"insert into mime2ext values ('image/x-portable-graymap', 'pgm,') ",
"insert into mime2ext values ('image/x-portable-pixmap', 'ppm,') ",
"insert into mime2ext values ('image/x-rgb', 'rgb,') ",
"insert into mime2ext values ('image/x-targ', 'tga,') ",
"insert into mime2ext values ('image/x-xbitmap', 'xbm,') ",
"insert into mime2ext values ('image/x-xpixmap', 'xpm,') ",
"insert into mime2ext values ('image/x-xwindowdump', 'xwd,') ",
"insert into mime2ext values ('magnus-internal/cgi', 'cgi,') ",
"insert into mime2ext values ('magnus-internal/imagemap', 'map,') ",
"insert into mime2ext values ('magnus-internal/parsed-html', 'shtml,') ",
"insert into mime2ext values ('message/external-body', '') ",
"insert into mime2ext values ('message/http', '') ",
"insert into mime2ext values ('message/new', 'art,') ",
"insert into mime2ext values ('message/partial', '') ",
"insert into mime2ext values ('message/rfc82', 'mail,') ",
"insert into mime2ext values ('model/iges', '') ",
"insert into mime2ext values ('model/mesh', '') ",
"insert into mime2ext values ('model/vrml', 'wrl,') ",
"insert into mime2ext values ('multipart/alternative', '') ",
"insert into mime2ext values ('multipart/appledouble', '') ",
"insert into mime2ext values ('multipart/byteranges', '') ",
"insert into mime2ext values ('multipart/digest', '') ",
"insert into mime2ext values ('multipart/encrypted', '') ",
"insert into mime2ext values ('multipart/form-data', '') ",
"insert into mime2ext values ('multipart/header-set', '') ",
"insert into mime2ext values ('multipart/mixed', '') ",
"insert into mime2ext values ('multipart/parallel', '') ",
"insert into mime2ext values ('multipart/report', '') ",
"insert into mime2ext values ('multipart/signed', '') ",
"insert into mime2ext values ('multipart/voice-message', '') ",
"insert into mime2ext values ('text/enriched', '') ",
"insert into mime2ext values ('text/ftp-dir-listing', '') ",
"insert into mime2ext values ('text/html', 'htm,html,shtml,') ",
"insert into mime2ext values ('text/plain', 'txt,text,pm,el,c,h,cc,hh,cxx,hxx,f90,') ",
"insert into mime2ext values ('text/richtext', 'rtx,') ",
"insert into mime2ext values ('text/sgml', '') ",
"insert into mime2ext values ('text/tab-separated-values', 'tsv,') ",
"insert into mime2ext values ('text/vnd.fmi.flexstor', '') ",
"insert into mime2ext values ('text/vnd.latex-z', '') ",
"insert into mime2ext values ('text/x-po', 'pod,') ",
"insert into mime2ext values ('text/x-setext', 'etx,') ",
"insert into mime2ext values ('text/x-vcard', 'vcf,') ",
"insert into mime2ext values ('video/mpeg', 'mpeg,mpg,mpe,') ",
"insert into mime2ext values ('video/quicktime', 'qt,mov,') ",
"insert into mime2ext values ('video/vnd.motorola.video', '') ",
"insert into mime2ext values ('video/vnd.motorola.videop', '') ",
"insert into mime2ext values ('video/vnd.vivo', '') ",
"insert into mime2ext values ('video/x-msvideo', 'avi,') ",
"insert into mime2ext values ('video/x-sgi-movie', 'movie,') ",
"insert into mime2ext values ('www/unknown', 'ex7,ex8,ex9,mp3,dat,tmp,wave,sea,tbk,tgz,wks,cab,jbf,qtvr,dbf,cop,moov,bz2,wdz,tap,wst,rm,max,dll,ico,psd,hlp,cac,vqf,mod,asf,unk,wma,cel,fli,gbr,gih,gpb,hrz,pat,pcx,pix,sgi,xcf,xjt,ppz,mv,ex1,ex2,ex3,ex4,ex5,ex6,') ",
"insert into mime2ext values ('x-world/x-vrml', 'wrl,vrz,flr,') "
};

void webbase_create(MYSQL* mysql, const char** schema, int schema_length)
{
  const char** queries;
  int queries_length;

  if(schema) {
    queries = schema;
    queries_length = schema_length;
  } else {
    queries = default_schema;
    queries_length = sizeof(default_schema) / sizeof(char*);
  }
  smysql_queries(mysql, queries, queries_length);
#ifdef WEBBASE_CONTENT_BASE
  if(!schema) {
    char** schema;
    int schema_length;
    schema = webbase_schema_content(&schema_length);
    smysql_queries(mysql, (const char**)schema, schema_length);
  }
#endif /* WEBBASE_CONTENT_BASE */
}

#ifdef WEBBASE_CONTENT_BASE
char** webbase_schema_content(int* lengthp)
{
#ifdef TABLE_SPLIT
  static char** schema = 0;
  static int schema_length = 0;

  if(schema == 0) {
    int table_names_length = strlen("url_content00,") * TABLE_SPLIT_SIZE + 1;
    char* table_names = smalloc(table_names_length);
    char* table_template = " \n\
create table url_content%02d ( \n\
  rowid int primary key, \n\
  content mediumblob \n\
) MAX_ROWS=16000000";
    char* tmp = smalloc(strlen(table_template) + table_names_length + 64);

    table_names[0] = '\0';

    schema = (char**)smalloc(sizeof(char*) * (TABLE_SPLIT_SIZE + 1));
    int i;
    for(i = 0; i < TABLE_SPLIT_SIZE; i++) {
      sprintf(table_names + strlen(table_names), "url_content%02d,", i);
      sprintf(tmp, table_template, i);
      schema[schema_length++] = strdup(tmp);
    }
    /*
     * Strip trailing comma
     */
    table_names[strlen(table_names) - 1] = '\0';
    sprintf(tmp, "\n\
create table url_content ( \n\
  rowid int, \n\
  content mediumblob \n\
) TYPE=MERGE UNION=(%s) MAX_ROWS=16000000", table_names);
    free(table_names);
    schema[schema_length++] = strdup(tmp);
    free(tmp);
  }
  *lengthp = schema_length;
  return schema;

#else /* TABLE_SPLIT */
  static char* schema[] = {
    " \n\
create table url_content ( \n\
  rowid int primary key, \n\
  content mediumblob \n\
) MAX_ROWS=16000000"
  };
  *lengthp = 1;
  return schema;
#endif /* TABLE_SPLIT */
}
#endif /* WEBBASE_CONTENT_BASE */

void webbase_schema()
{
  unsigned int i;
  for(i = 0; i < sizeof(default_schema) / sizeof(char*); i++)
    printf("%s;\n", default_schema[i]);
#ifdef WEBBASE_CONTENT_BASE
  {
    int length;
    char** schema = webbase_schema_content(&length);
    int i;
    for(i = 0; i < length; i++) {
      printf("%s;\n", schema[i]);
    }
  }
#endif /* WEBBASE_CONTENT_BASE */
}

const char* webbase_table_schema(int table)
{
  if(table < 0 || table >= WEBBASE_SCHEMA_LENGTH) {
    fprintf(stderr, "webbase_table_schema: invalid table number %d (must be >= 0 and < %d\n", table, WEBBASE_SCHEMA_LENGTH);
    return 0;
  }

  return default_schema[table];
}
