/*
 *   Copyright (C) 1997, 1998, 1999 Loic Dachary
 *
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */
#ifndef _crawl_h
#define _crawl_h

#include <khash.h>

#include <webtools.h>
#include <webbase.h>
#include <webbase_url.h>
#include <http.h>
#include <robots.h>
#include <cookies.h>
#include <webbase_hook.h>

#define CRAWL_PARAMS_CANDIDATE_LIMIT	200

typedef struct crawl_params {
  hash_t* options;
  webtools_params_t* http;
  webbase_t* base;
  webbase_url_start_t start_in_core;
  robots_t* robots;
  cookies_t* cookies;
  int robot_delayed;
  int noheuristics;
  int update;
  int update_rebuild;
  int candidate_limit;
  int sticky;
  webbase_hook_params_t* hook;
  char* agent;
} crawl_params_t;

struct option* crawl_options(struct option options[]);
struct option_help *crawl_help_options(struct option_help options_help[]);
void crawl_rehook(crawl_params_t* params);
void crawl_rebuild(crawl_params_t* params, int resume, char *where);
void crawl_urls(crawl_params_t* params, char* urls);
crawl_params_t* crawl_init(int argc, char** argv);
crawl_params_t* crawl_alloc(int argc, char** argv, struct option options[]);
void crawl_free(crawl_params_t* params);
void hp_load(crawl_params_t* params);
void hp_unload(crawl_params_t* params, char* url, int keep_start);
void hp_show(crawl_params_t* params, char* url, char* fields, char* where);
void hp_show_indexable(crawl_params_t* params, char* url);
void hp_load_in_core(crawl_params_t* params, char* url);
void hp_load_1(crawl_params_t* params, char* where);
typedef void (*hp_action_callback)(crawl_params_t* params, webbase_url_start_t* start, webbase_url_t* webbase_url);
typedef void (*hp_action_start_callback)(crawl_params_t* params, webbase_url_start_t* start);
void hp_action(crawl_params_t* params, char* where, hp_action_start_callback func_start, hp_action_callback func);
void hp_print_externals(crawl_params_t* params, char* where);
void hp_remove_unloaded(crawl_params_t* params, char* url);
webbase_url_t* crawl_touch(crawl_params_t* params, char* url);

#endif /* _crawl_h */
