%{
/*
 * Copyright (C) 1999, 2000, 2001  Lorenzo Bettini <bettini@gnu.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
  This scanner for prolog was written by 
  Martin Gebert <Murphy.Gebert@gmx.de>
  for Visual Prolog 5.2, but it should match most of the
  other Prolog dialects, at least in the most parts.
*/

int lineno = 1 ; /* number of scanned lines */
char linebuf[1024] ; /* current code line in the source */
int tokenpos = 0 ; /* current token position in the current line */

#include "tags.h"
#include "tokens.h"
#include "colors.h"

#include "genfun.h"

%}


nl \n
cr \r
STRING \"[^\"\n]*\"
not_alpha [^a-zA-Z0-9]

%s COMMENT_STATE
%s SINGLELINE_COMMENT
%s STRING_STATE
%s CHAR_STATE

IDE [a-z]([a-zA-Z0-9_])*
VAR [A-Z_]([a-zA-Z0-9_])*
wspace [ \t\n\r]
templspec \<({wspace}|{IDE})*\>


keywordl1 (abstract|align|as|and|class|clauses|constants|database|determ)
keywordl2 (domains|elsedef|endclass|enddef|erroneous|facts|failure|global)
keywordl3 (goal|if|ifdef|ifndef|implement|include|language|multi|nocopy)
keywordl4 (nondeterm|object|or|procedure|protected|predicates|reference)
keywordl5 (single|static|struct|this)
keywordu1 (ABSTRACT|ALIGN|AS|AND|CLASS|CLAUSES|CONSTANTS|DATABASE|DETERM)
keywordu2 (DOMAINS|ELSEDEF|ENDCLASS|ENDDEF|ERRONEOUS|FACTS|FAILURE|GLOBAL)
keywordu3 (GOAL|IF|IFDEF|IFNDEF|IMPLEMENT|INCLUDE|LANGUAGE|MULTI|NOCOPY)
keywordu4 (NONDETERM|OBJECT|OR|PROCEDURE|PROTECTED|PREDICATES|REFERENCE)
keywordu5 (SINGLE|STATIC|STRUCT|THIS)
special1 (assert|asserta|assertz|bound|chain_inserta|chain_insertafter)
special2 (chain_insertz|chain_terms|consult|db_btrees|db_chains|fail)
special3 (findall|format|free|msgrecv|msgsend|nl|not|readterm|ref_term|retract)
special4 (retractall|save|term_bin|term_replace|term_str|trap|write|writef)

keywordl ({keywordl1}|{keywordl2}|{keywordl3}|{keywordl4}|{keywordl5})
keywordu ({keywordu1}|{keywordu2}|{keywordu3}|{keywordu4}|{keywordu5})
special ({special1}|{special2}|{special3}|{special4})

compiler1 (bgidriver|bgifont|check_determ|code|config|diagnostics|error)
compiler2 (errorlevel|heap|gstacksize|nobreak|nowarnings|printermenu|project)
compiler ({compiler1}|{compiler2})

arith1 (mod|div|abs|exp|ln|log|sqrt|round|trunc|val|cos|sin|tan|arctan)
arith2 (random|randominit)
arith ({arith1}|{arith2})

keyword ({keywordl}|{keywordu}|{special}|{compiler}|{arith})

basetype1 (char|real|string|symbol|byte|sbyte|short|ushort|word|integer)
basetype2 (unsigned|dword|long|ulong|binary|ref)
basetype ({basetype1}|{basetype2}|{VAR})

symbol [\~\!\%\^\*\(\)\-\+\=\[\]\|\\\:\;\,\.\/\?\&\<\>]

cbracket [\[\]]

funccall {IDE}/{wspace}*((({templspec}){0,1}{wspace}*\()|(\:\-))

%%

<INITIAL>"/*" { BEGIN COMMENT_STATE ;
       startComment( yytext ) ;      
     }
<INITIAL>"/*".*"*/" { generateComment( yytext ) ;  }

<COMMENT_STATE>\n { 
   endComment (""); 
   ++lineno;
   generateNewLine() ;
   startComment ("");
   /* if we encounter another // during a comment we simply
      treat it as a ordinary string */
 }
<COMMENT_STATE>"*/" { endComment(yytext) ;
                      BEGIN INITIAL ; /* end of the comment */ }

<INITIAL>"%" { BEGIN SINGLELINE_COMMENT ; startComment( yytext ) ; }
<SINGLELINE_COMMENT>\n { 
   BEGIN INITIAL ; 
   yyless (0); // put the \n back
   endComment( yytext ) ; 
   /* if we encounter another // during a comment we simply
      treat it as a ordinary string */
 }

<INITIAL>\" { BEGIN STRING_STATE ; startString( yytext );  }
<STRING_STATE>\\\\ {  generate_preproc( yytext ) ; }
<STRING_STATE>"\\\"" {  generate_preproc( yytext ) ; }
<STRING_STATE>\" { BEGIN INITIAL ; endString( yytext ) ; }

<INITIAL>\' { BEGIN CHAR_STATE ; startString( yytext );  }
<CHAR_STATE>\\\\ {  generate_preproc( yytext ) ; }
<CHAR_STATE>"\\\'" {  generate_preproc( yytext ) ; }
<CHAR_STATE>\' { BEGIN INITIAL ; endString( yytext ) ; }

<INITIAL>\#[ \t]*[^\"\n\t ]* { generatePreProc( yytext) ; }

<INITIAL>{keyword} { generateKeyWord( yytext ) ; }
<INITIAL>{basetype} { generateBaseType( yytext ) ; }
<INITIAL>{symbol} { generateSymbol( yytext ); }
<INITIAL>[\[\]] { generateCBracket ( yytext ); }

<INITIAL>{keyword}/{wspace}*\( { generateKeyWord( yytext ) ; }
<INITIAL>{basetype}/{wspace}*\( { generateBaseType( yytext ) ; }
<INITIAL>{funccall} { generateFunction ( yytext ); }

<INITIAL>0[xX][0-9a-fA-F]* { generateNumber( yytext ) ; }
<INITIAL>[0-9][0-9]*(\.[0-9]*[eE]?[-+]?[0-9]*)? { generateNumber( yytext ) ; }

<INITIAL>\<[^\"\n ]*\> { generateString (yytext); }

[a-zA-Z_]([a-zA-Z0-9_])* { generate( yytext ) ; }


. { generate_preproc( yytext ) ; /* anything else */ }

\t {
        generateTab() ;
}

\n { 
       ++lineno;
       generateNewLine() ;
}

%%

void yyerror( char *s ) ;

void yyerror( char *s )
{  
  fprintf( stderr, "%d: %s: %s\n%s\n", lineno, s, yytext, linebuf ) ;
  fprintf( stderr, "%*s\n", tokenpos, "^" ) ;
}
