/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     BOLD = 258,
     ITALICS = 259,
     UNDERLINE = 260,
     KEY = 261,
     COLOR = 262
   };
#endif
#define BOLD 258
#define ITALICS 259
#define UNDERLINE 260
#define KEY 261
#define COLOR 262




/* Copy the first part of user declarations.  */


/*
 * Copyright (C) 1999, 2000, 2001 Lorenzo Bettini <bettini@gnu.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <stdio.h>
#include <string.h>
#include <iostream>

#include "my_sstream.h"

#include "tags.h"
#include "colors.h"
#include "keys.h"
#include "messages.h"
#include "parsetags.h"

using std::cerr;

static int opsc_parse() ;
static void opsc_error( char *s ) ;

int line = 0 ;

static FILE *openTagsFile() ;

extern int opsc_lex() ;
extern FILE *opsc_in ;



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)

typedef union YYSTYPE {
  int tok ; /* command */
  char * string ; /* string : id, ... */
  int flag ;
  Tag *tag ;
  Tags *tags ;
} YYSTYPE;
/* Line 191 of yacc.c.  */

# define opsc_stype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */


#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short opsc_ss;
  YYSTYPE opsc_vs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, opsc_size);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = opsc_stacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char opsc_signed_char;
#else
   typedef short opsc_signed_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  6
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   9

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  10
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  7
/* YYNRULES -- Number of rules. */
#define YYNRULES  12
/* YYNRULES -- Number of states. */
#define YYNSTATES  17

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   262

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     9,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     8,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned char yyprhs[] =
{
       0,     0,     3,     5,     8,    10,    11,    17,    21,    23,
      24,    26,    28
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const opsc_signed_char yyrhs[] =
{
      11,     0,    -1,    12,    -1,    12,    13,    -1,    13,    -1,
      -1,     6,     7,    14,    15,     8,    -1,    15,     9,    16,
      -1,    16,    -1,    -1,     3,    -1,     4,    -1,     5,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned char yyrline[] =
{
       0,    64,    64,    67,    68,    72,    71,    83,    84,    87,
      88,    89,    90
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "BOLD", "ITALICS", "UNDERLINE", "KEY", 
  "COLOR", "';'", "','", "$accept", "globaltags", "options", "option", 
  "@1", "values", "value", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,    59,    44
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned char yyr1[] =
{
       0,    10,    11,    12,    12,    14,    13,    15,    15,    16,
      16,    16,    16
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     2,     1,     0,     5,     3,     1,     0,
       1,     1,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned char opsc_defact[] =
{
       0,     0,     0,     2,     4,     5,     1,     3,     9,    10,
      11,    12,     0,     8,     6,     9,     7
};

/* YYDEFGOTO[NTERM-NUM]. */
static const opsc_signed_char opsc_defgoto[] =
{
      -1,     2,     3,     4,     8,    12,    13
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -7
static const opsc_signed_char opsc_pact[] =
{
      -1,     0,     6,    -1,    -7,    -7,    -7,    -7,    -3,    -7,
      -7,    -7,    -5,    -7,    -7,    -3,    -7
};

/* YYPGOTO[NTERM-NUM].  */
static const opsc_signed_char opsc_pgoto[] =
{
      -7,    -7,    -7,     5,    -7,    -7,    -6
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1
static const unsigned char opsc_table[] =
{
       9,    10,    11,    14,    15,     1,     6,     5,     7,    16
};

static const unsigned char opsc_check[] =
{
       3,     4,     5,     8,     9,     6,     0,     7,     3,    15
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned char opsc_stos[] =
{
       0,     6,    11,    12,    13,     7,     0,    13,    14,     3,
       4,     5,    15,    16,     8,     9,    16
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(opsc_char = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrlab1


/* Like YYERROR except do call opsc_error.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (opsc_char == YYEMPTY && opsc_len == 1)				\
    {								\
      opsc_char = (Token);						\
      opsc_lval = (Value);						\
      yytoken = YYTRANSLATE (opsc_char);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      opsc_error ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)         \
  Current.first_line   = Rhs[1].first_line;      \
  Current.first_column = Rhs[1].first_column;    \
  Current.last_line    = Rhs[N].last_line;       \
  Current.last_column  = Rhs[N].last_column;
#endif

/* YYLEX -- calling `opsc_lex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX opsc_lex (YYLEX_PARAM)
#else
# define YYLEX opsc_lex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (opsc_debug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (opsc_debug)					\
    opsc_symprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (opsc_debug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      opsc_symprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (cinluded).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short *bottom, short *top)
#else
static void
yy_stack_print (bottom, top)
    short *bottom;
    short *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (opsc_debug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int opsc_rule)
#else
static void
yy_reduce_print (opsc_rule)
    int opsc_rule;
#endif
{
  int yyi;
  unsigned int opsc_lineno = yyrline[opsc_rule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             opsc_rule - 1, opsc_lineno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[opsc_rule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[opsc_rule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (opsc_debug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int opsc_debug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef opsc_strlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define opsc_strlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
opsc_strlen (const char *opsc_str)
#   else
opsc_strlen (opsc_str)
     const char *opsc_str;
#   endif
{
  register const char *opsc_s = opsc_str;

  while (*opsc_s++ != '\0')
    continue;

  return opsc_s - opsc_str - 1;
}
#  endif
# endif

# ifndef opsc_stpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define opsc_stpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
opsc_stpcpy (char *yydest, const char *opsc_src)
#   else
opsc_stpcpy (yydest, opsc_src)
     char *yydest;
     const char *opsc_src;
#   endif
{
  register char *yyd = yydest;
  register const char *opsc_s = opsc_src;

  while ((*yyd++ = *opsc_s++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
opsc_symprint (FILE *opsc_output, int yytype, YYSTYPE *opsc_valuep)
#else
static void
opsc_symprint (opsc_output, yytype, opsc_valuep)
    FILE *opsc_output;
    int yytype;
    YYSTYPE *opsc_valuep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) opsc_valuep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (opsc_output, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (opsc_output, yytoknum[yytype], *opsc_valuep);
# endif
    }
  else
    YYFPRINTF (opsc_output, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (opsc_output, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *opsc_valuep)
#else
static void
yydestruct (yytype, opsc_valuep)
    int yytype;
    YYSTYPE *opsc_valuep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) opsc_valuep;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int opsc_parse (void *YYPARSE_PARAM);
# else
int opsc_parse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int opsc_parse (void);
#else
int opsc_parse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The lookahead symbol.  */
int opsc_char;

/* The semantic value of the lookahead symbol.  */
YYSTYPE opsc_lval;

/* Number of syntax errors so far.  */
int opsc_nerrs;



/*----------.
| opsc_parse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int opsc_parse (void *YYPARSE_PARAM)
# else
int opsc_parse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
opsc_parse (void)
#else
int
opsc_parse ()

#endif
#endif
{
  
  register int opsc_state;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `opsc_ss': related to states,
     `opsc_vs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	opsc_ssa[YYINITDEPTH];
  short *opsc_ss = opsc_ssa;
  register short *opsc_ssp;

  /* The semantic value stack.  */
  YYSTYPE opsc_vsa[YYINITDEPTH];
  YYSTYPE *opsc_vs = opsc_vsa;
  register YYSTYPE *opsc_vsp;



#define YYPOPSTACK   (opsc_vsp--, opsc_ssp--)

  YYSIZE_T opsc_stacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE opsc_val;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int opsc_len;

  YYDPRINTF ((stderr, "Starting parse\n"));

  opsc_state = 0;
  yyerrstatus = 0;
  opsc_nerrs = 0;
  opsc_char = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  opsc_ssp = opsc_ss;
  opsc_vsp = opsc_vs;

  goto opsc_setstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in opsc_state.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  opsc_ssp++;

 opsc_setstate:
  *opsc_ssp = opsc_state;

  if (opsc_ss + opsc_stacksize - 1 <= opsc_ssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T opsc_size = opsc_ssp - opsc_ss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *opsc_vs1 = opsc_vs;
	short *opsc_ss1 = opsc_ss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &opsc_ss1, opsc_size * sizeof (*opsc_ssp),
		    &opsc_vs1, opsc_size * sizeof (*opsc_vsp),

		    &opsc_stacksize);

	opsc_ss = opsc_ss1;
	opsc_vs = opsc_vs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= opsc_stacksize)
	goto yyoverflowlab;
      opsc_stacksize *= 2;
      if (YYMAXDEPTH < opsc_stacksize)
	opsc_stacksize = YYMAXDEPTH;

      {
	short *opsc_ss1 = opsc_ss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (opsc_stacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (opsc_ss);
	YYSTACK_RELOCATE (opsc_vs);

#  undef YYSTACK_RELOCATE
	if (opsc_ss1 != opsc_ssa)
	  YYSTACK_FREE (opsc_ss1);
      }
# endif
#endif /* no yyoverflow */

      opsc_ssp = opsc_ss + opsc_size - 1;
      opsc_vsp = opsc_vs + opsc_size - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) opsc_stacksize));

      if (opsc_ss + opsc_stacksize - 1 <= opsc_ssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", opsc_state));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = opsc_pact[opsc_state];
  if (yyn == YYPACT_NINF)
    goto opsc_default;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (opsc_char == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      opsc_char = YYLEX;
    }

  if (opsc_char <= YYEOF)
    {
      opsc_char = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (opsc_char);
      YYDSYMPRINTF ("Next token is", yytoken, &opsc_lval, &opsc_lloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || opsc_check[yyn] != yytoken)
    goto opsc_default;
  yyn = opsc_table[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (opsc_char != YYEOF)
    opsc_char = YYEMPTY;

  *++opsc_vsp = opsc_lval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  opsc_state = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| opsc_default -- do the default action for the current state.  |
`-----------------------------------------------------------*/
opsc_default:
  yyn = opsc_defact[opsc_state];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  opsc_len = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  opsc_val = opsc_vsp[1-opsc_len];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:

    { setTags( opsc_vsp[0].tags ) ; }
    break;

  case 3:

    { opsc_vsp[-1].tags->AddTag( opsc_vsp[0].tag ) ; }
    break;

  case 4:

    { opsc_val.tags = new Tags() ; opsc_val.tags->AddTag( opsc_vsp[0].tag ) ;  }
    break;

  case 5:

    {
                 printMessage( opsc_vsp[-1].string ) ;
                 printMessage( opsc_vsp[0].string ) ;
             }
    break;

  case 6:

    {
	       opsc_val.tag = new Tag( opsc_vsp[-4].string, opsc_vsp[-3].string ) ;
               opsc_val.tag->SetFlags(opsc_vsp[-1].flag) ;
	     }
    break;

  case 7:

    { opsc_val.flag = opsc_vsp[-2].flag | opsc_vsp[0].flag ; }
    break;

  case 9:

    { opsc_val.flag = 0 ; printMessage( " (no options) " ) ; }
    break;

  case 10:

    { printMessage( " - bold" ) ; opsc_val.flag = ISBOLD ; }
    break;

  case 11:

    { printMessage( " - italics" ) ; opsc_val.flag = ISITALIC ; }
    break;

  case 12:

    { printMessage( " - underline" ) ; opsc_val.flag = ISUNDERLINE ; }
    break;


    }

/* Line 999 of yacc.c.  */


  opsc_vsp -= opsc_len;
  opsc_ssp -= opsc_len;


  YY_STACK_PRINT (opsc_ss, opsc_ssp);

  *++opsc_vsp = opsc_val;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  opsc_state = opsc_pgoto[yyn - YYNTOKENS] + *opsc_ssp;
  if (0 <= opsc_state && opsc_state <= YYLAST && opsc_check[opsc_state] == *opsc_ssp)
    opsc_state = opsc_table[opsc_state];
  else
    opsc_state = opsc_defgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++opsc_nerrs;
#if YYERROR_VERBOSE
      yyn = opsc_pact[opsc_state];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  YYSIZE_T opsc_size = 0;
	  int yytype = YYTRANSLATE (opsc_char);
	  char *yymsg;
	  int yyx, yycount;

	  yycount = 0;
	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  for (yyx = yyn < 0 ? -yyn : 0;
	       yyx < (int) (sizeof (yytname) / sizeof (char *)); yyx++)
	    if (opsc_check[yyx + yyn] == yyx && yyx != YYTERROR)
	      opsc_size += opsc_strlen (yytname[yyx]) + 15, yycount++;
	  opsc_size += opsc_strlen ("syntax error, unexpected ") + 1;
	  opsc_size += opsc_strlen (yytname[yytype]);
	  yymsg = (char *) YYSTACK_ALLOC (opsc_size);
	  if (yymsg != 0)
	    {
	      char *yyp = opsc_stpcpy (yymsg, "syntax error, unexpected ");
	      yyp = opsc_stpcpy (yyp, yytname[yytype]);

	      if (yycount < 5)
		{
		  yycount = 0;
		  for (yyx = yyn < 0 ? -yyn : 0;
		       yyx < (int) (sizeof (yytname) / sizeof (char *));
		       yyx++)
		    if (opsc_check[yyx + yyn] == yyx && yyx != YYTERROR)
		      {
			const char *yyq = ! yycount ? ", expecting " : " or ";
			yyp = opsc_stpcpy (yyp, yyq);
			yyp = opsc_stpcpy (yyp, yytname[yyx]);
			yycount++;
		      }
		}
	      opsc_error (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    opsc_error ("syntax error; also virtual memory exhausted");
	}
      else
#endif /* YYERROR_VERBOSE */
	opsc_error ("syntax error");
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      /* Return failure if at end of input.  */
      if (opsc_char == YYEOF)
        {
	  /* Pop the error token.  */
          YYPOPSTACK;
	  /* Pop the rest of the stack.  */
	  while (opsc_ss < opsc_ssp)
	    {
	      YYDSYMPRINTF ("Error: popping", opsc_stos[*opsc_ssp], opsc_vsp, yylsp);
	      yydestruct (opsc_stos[*opsc_ssp], opsc_vsp);
	      YYPOPSTACK;
	    }
	  YYABORT;
        }

      YYDSYMPRINTF ("Error: discarding", yytoken, &opsc_lval, &opsc_lloc);
      yydestruct (yytoken, &opsc_lval);
      opsc_char = YYEMPTY;

    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*----------------------------------------------------.
| yyerrlab1 -- error raised explicitly by an action.  |
`----------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = opsc_pact[opsc_state];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && opsc_check[yyn] == YYTERROR)
	    {
	      yyn = opsc_table[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (opsc_ssp == opsc_ss)
	YYABORT;

      YYDSYMPRINTF ("Error: popping", opsc_stos[*opsc_ssp], opsc_vsp, yylsp);
      yydestruct (opsc_stos[opsc_state], opsc_vsp);
      opsc_vsp--;
      opsc_state = *--opsc_ssp;

      YY_STACK_PRINT (opsc_ss, opsc_ssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++opsc_vsp = opsc_lval;


  opsc_state = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  opsc_error ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (opsc_ss != opsc_ssa)
    YYSTACK_FREE (opsc_ss);
#endif
  return yyresult;
}





// this should be passed by the compiler
#ifndef SOURCE_HIGHLIGHT_DATA_DIR
#define SOURCE_HIGHLIGHT_DATA_DIR "."
#endif

#define TAGS_FILE "tags.j2h"

extern char *tags_file;

void
parseTags()
{

  // opens the file for opsc_lex
  opsc_in = openTagsFile() ;
  if (! opsc_in) {
    printWarning( "No tags.j2h file, using defaults ...", cerr ) ;
    setTags( NULL ) ;
    return ;
  }

  printMessage_noln( "Parsing ", cerr ) ;
  if (tags_file)
    printMessage_noln (tags_file, cerr);
  else
    printMessage_noln (TAGS_FILE, cerr);
  printMessage( " file ...", cerr ) ;
  opsc_parse() ;
  printMessage( "Parsing done!", cerr ) ;
}

FILE *
openTagsFile()
{
  FILE *file = 0;

  printMessage( "Trying with..." ) ;

  if ( tags_file )
    {
      printMessage (tags_file);
      file = fopen (tags_file, "r");
      if (file)
        return file;
    }

  printMessage( TAGS_FILE ) ;
  file = fopen( TAGS_FILE, "r") ;
  if ( file )
    return file ;

  file = fopen( SOURCE_HIGHLIGHT_DATA_DIR "/" TAGS_FILE, "r") ;
  printMessage( SOURCE_HIGHLIGHT_DATA_DIR "/" TAGS_FILE ) ;

  return file ;
}

void
opsc_error( char *s )
{
  ostringstream str ;
  str << "*** " << s << " on option # " << line;
  printError( str.str().c_str(), cerr ) ;
  printError( "Using default tags...", cerr ) ;
}

