<?php /* Header.
   Copyright (C) 2006, 2007 David Englund.

This file is part of GNU Sovix.

GNU Sovix is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as
published by the Free Software Foundation, either version 3 of the
License, or (at your option) any later version.

GNU Sovix is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with GNU Sovix.  If not, see <http://www.gnu.org/licenses/>. */

# Start time
function microtime_float()
{
  list($sovix__usec, $sovix__sec) = explode(" ", microtime());
  return ((float)$sovix__usec + (float)$sovix__sec);
}
$sovix__time_start = microtime_float();


# Block banned IP addresses
require "$sovix__directory__dotsovix/private/ip_block.inc.php";
for($sovix__i = 0; $sovix__i < count($sovix__array__ip_block); $sovix__i++) {
  if("{$sovix__array__ip_block[$sovix__i]['sovix__array__ip_block__array__ip_address']}"==$_SERVER['REMOTE_ADDR']) {
    echo "IP ".$_SERVER['REMOTE_ADDR']." blocked"; exit;
  }
 }

header("ETag: PUB" . time());
header("Last-Modified: " . gmdate("D, d M Y H:i:s", time()-10) . " GMT");
header("Expires: " . gmdate("D, d M Y H:i:s", time() + 5) . " GMT");
header("Pragma: no-cache");
header("Cache-Control: max-age=1, s-maxage=1, no-cache, must-revalidate");
session_cache_limiter("nocache");
session_start();

# Require primary Sovix files
require "$sovix__directory__src/browser_detection.inc";
require "$sovix__directory__src/setvar.inc";

if (!empty($_GET['charset'])) $sovix__charset=$_GET['charset'];

require "$sovix__directory__dotsovix/files.inc";
require "$sovix__directory__dotsovix/files.inc"; # Reload to get variables that is dependent of variables
require "$sovix__directory__dotsovix/private/files.inc.php";



if (strpos("http://".$_SERVER['SERVER_NAME'].$_SERVER['PHP_SELF'], "$sovix__url__sovix") !== false && strpos($_SERVER['PHP_SELF'], "/private/") === false) $sovix__sovix=true;

require "$sovix__file__public__global"; # Set global settings for variables that is not set by the user
if (!empty($sovix__file__public)) require "$sovix__file__public"; # Write over gloabal settings with desired settings
require "$sovix__file__private";
require "$sovix__directory__src/setvar-arrays.inc";

# Require personal files
require "$sovix__file__personal";
require "$sovix__file__public__global"; # Set global settings again
require "$sovix__directory__src/setvar.inc";


require "$sovix__directory__src/setvar-arrays.inc";
require "$sovix__directory__src/iso_639.inc"; # Import ISO 693 codes




#
# Content Negotiation
#

# Language
if (strpos($_SERVER['HTTP_ACCEPT_LANGUAGE'], strtolower($sovix__iso_639_2)) === false && empty($_GET['charset'])) $sovix__iso_639_2="en"; # Standard

# Character encoding
if (strpos($_SERVER['HTTP_ACCEPT_CHARSET'], strtolower($sovix__charset)) === false && strpos($_SERVER['HTTP_ACCEPT_CHARSET'], strtolower($sovix__charset__secondary)) !== false && empty($_GET['charset'])) $sovix__charset=$sovix__charset__secondary;
elseif (strpos($_SERVER['HTTP_ACCEPT_CHARSET'], strtolower($sovix__charset)) === false && strpos($_SERVER['HTTP_ACCEPT_CHARSET'], strtolower($sovix__charset__secondary)) === false && empty($_GET['charset'])) $sovix__charset=$sovix__charset__force; # Standard



$sovix__xhtml = false;
if (preg_match('/application\/xhtml\+xml(;q=(\d+\.\d+))?/i', $_SERVER['HTTP_ACCEPT'], $sovix__matches)) {
  $sovix__xhtmlQ = isset($sovix__matches[2]) ? $sovix__matches[2] : 1;
  if (preg_match('/text\/html(;q=(\d+\.\d+))?/i', $_SERVER['HTTP_ACCEPT'], $sovix__matches)) {
    $sovix__htmlQ = isset($sovix__matches[2]) ? $sovix__matches[2] : 1;
    $sovix__xhtml = ($sovix__xhtmlQ >= $sovix__htmlQ);
  } else {
    $sovix__xhtml = true;
  }
 }

# Exclude the W3 HTML validor HTTP user agent from the content negotiation since you _want_ the correct DTD to be used whe you use validate.
if (
    substr($_SERVER['HTTP_USER_AGENT'], 0, 13)=="W3C_Validator" && substr("$sovix__dtd", 0, 10)=="w3c-xhtml-" ||
    $sovix__xhtml == true && substr("$sovix__dtd", 0, 10)=="w3c-xhtml-" ||
    substr($_GET['dtd'], 0, 10)=="w3c-xhtml-"
) {
  $sovix__xhtml = true;
  $sovix__allow_uri_in_meta=true;
  $sovix__close_tag=" /"; # using XHTML-style self-closing tags (such as <meta ... />) in HTML 4.01 or earlier. To fix, remove the extra slash ('/') character. --W3C validator
  if (substr("$sovix__dtd", 0, 16)=="w3c-xhtml-basic-" || $sovix__embedded_device==true) $sovix__xhtml_basic=true;
  if (substr("$sovix__dtd", 0, 16)=="w3c-xhtml-print-" || $sovix__embedded_device==true) $sovix__xhtml_print=true;
  if (substr("$sovix__dtd", 0, 20)=="w3c-xhtml-plus-rdfa-") $sovix__xhtml_plus_rdfa=true;
 }
elseif (substr($_SERVER['HTTP_USER_AGENT'], 0, 13)!="W3C_Validator" && $sovix__xhtml != true && substr("$sovix__dtd", 0, 10)=="w3c-xhtml-" && substr($_GET['dtd'], 0, 10)!="w3c-xhtml-") $sovix__dtd=$sovix__dtd__secondary;

# End Content Negotiation



require "$sovix__directory__src/setvar2.inc"; # Must be here



if (!empty($sovix__file__header)) require "$sovix__file__header";
require "$sovix__directory__private/auth_sovix.inc.php";


    $sovix__fig_dir=$_SERVER['PHP_SELF'];
    require "$sovix__directory__src/read-fig.inc";


# Require secondary Sovix files
if(isset($_GET['sovix__language'])) $sovix__language=$_GET['sovix__language'];
require "$sovix__directory__src/functions.inc";


# Figure out if some text in the autoindex should be translated.
# Do not put this inside the function for autoindex since it will be mutch more CPU expensive.
if (!empty($sovix__file__select_menu_translate)) {
  require "$sovix__file__select_menu_translate";
  for($sovix__activate_translation = 0; $sovix__activate_translation < count($sovix__array__select_menu__translate); $sovix__activate_translation++){}
  if ($sovix__activate_translation>0) $sovix__translate_topics="y";
 }

require "$sovix__directory__src/check-trans.inc";
require "$sovix__directory__src/select-menu.inc";

$sovix__toc="800";
if ($sovix__menu__side_pane_mode=="y" || isset($_SESSION['sovix__user'])) $sovix__toc=$sovix__toc-$sovix__menu_tree_width;
$sovix__menu_tree_width__links=$sovix__menu_tree_width-10;

require "$sovix__directory__src/set_css.inc";
require "$sovix__directory__src/counter.inc";

# Reload 'files.inc*' files to make variables take effect such as icon to meta
require "$sovix__directory__dotsovix/files.inc";
require "$sovix__directory__dotsovix/private/files.inc.php";





require_once "$sovix__directory__src/intro.inc";
require "$sovix__directory__src/toctopic.inc";
require "$sovix__directory__src/translate.inc";
if($sovix__format==html && $sovix__screen_mode==normal) {



if ($sovix__window_border_mode=="y" || isset($_SESSION['sovix__user'])) {
?>
  <div class="sovix__theme__skin_window_border_center sovix__select_menu__index_menu__toctitle"><?php echo "<a class=\"color__white\" href=\"mailto:sovix@".$_SERVER['SERVER_NAME']."\">sovix@".str_replace("www.", "", $_SERVER['SERVER_NAME']); ?></a></div>
<?php
}
 if (
     $sovix__menu_bar_mode==y &&
     $sovix__webbrowser__text_interface!=true &&
     $sovix__xhtml_basic!=true
     ||
     isset($_SESSION['sovix__user']) &&
     $sovix__webbrowser__text_interface!=true &&
     $sovix__xhtml_basic!=true
) require "$sovix__directory__src/menubar.inc";

if ($sovix__tool_bar_mode=="y" || $sovix__select_menu_header_mode=="y" || isset($_SESSION['sovix__user'])) echo "    <div class=\"sovix__menu_bar__div sovix__tool_bar\">\n";
if ($sovix__select_menu_header_mode=="y" || isset($_SESSION['sovix__user'])) echo "      <div>
        <form action=\"$sovix__url__websrc/redirect.php\" method='post'>
          <address>
";
if ($sovix__webbrowser__text_interface!=true && $sovix__xhtml_basic!=true) {

require "$sovix__directory__src/toolbar.inc";
	  }
 if ($sovix__select_menu_header_mode=="n") echo "<!--"; # For the moment we need to comment out, not exclude the code if we want to reuse it.
  if ($sovix__browser_interface=="GUI") {
  echo "            <input type=\"submit\" value=\"\" title=\"";
 sovix__capital($sovix__text="$sovix__translate__Choose_a_location_in_the_select_menu");
 echo ", ";
 echo substr($sovix__translate__then_click, 0, 255);
 echo " ";
 echo substr($sovix__translate__at_the_icon, 0, 255);
 echo "\" class=\"sovix__favicon sovix__flag\"$sovix__close_tag>\n";
} ?>
            <select name="sovix__file" class="sovix__select__menu">
              <option class="sovix__selected_link sovix__theme__window_border_text_color" value="<?php echo "http://" . $_SERVER["SERVER_NAME"]; ?>"><?php sovix__capital($sovix__text="$sovix__translate__sitemap"); ?>:</option>
<?php
$sovix__space="14";

 require "$sovix__file__select_menu_data";

echo "            </select>
            <input type=\"submit\" value=\""; sovix__capital($sovix__text="$sovix__translate__go"); echo "\" title=\"";

 sovix__capital($sovix__text="$sovix__translate__Choose_a_location_in_the_select_menu");
 echo ", ";
 echo substr($sovix__translate__then_click, 0, 255);
 echo " ";
 echo substr($sovix__translate__go, 0, 255);
echo "\" class=\"sovix__input\"$sovix__close_tag>
          </address>
        </form>
      </div>";
if ($sovix__select_menu_header_mode=="n") echo "-->";

if ($sovix__tool_bar_mode=="y" || $sovix__select_menu_header_mode=="y" || isset($_SESSION['sovix__user'])) echo "\n    </div>\n";



# Nestled tables is not allowed
if ($sovix__menu__side_pane_mode=="y") {
# Internet Explorer 6 must use align="center" but that is not even HTML 4.01 Strict valid so we use margin:auto as we should


/*
Use table, div didn't work:

<div style="width: 30%; float: left;">Side pane</div>
<div style="width: 70%; float: left;">TOC</div>
*/

  echo "
<table"; if ($sovix__xhtml_basic!=true && $sovix__xhtml_print!=true) echo " cellspacing=\"0\" cellpadding=\"0\""; echo " class=\"background__color__white\">
  <tr>
    <td valign=\"top\" align=\"left\" class=\"sovix__toc__menu_tree_part_2\">";
?>

      <!-- Begin side pane -->

	 <div class="sovix__menu__tree_topic"><?php sovix__capital($sovix__text="$sovix__translate__sitemap") ?> <a href="?sovix__menu__side_pane_mode=n" title="Close the side pane">[x]</a></div>
      <div class="sovix__menu__tree"><?php require "$sovix__directory__src/select-menu-tree.inc"; ?>      </div>

      <!-- End side pane -->
<?php
 echo "
    </td>
    <td class=\"sovix__toc__menu_tree_part_3\">&nbsp;</td>
    <td valign=\"top\" class=\"toc_main_td sovix__toc__menu_tree_part_4\">";
 }
 }


if (
    $sovix__first_time_visit==true &&
    $sovix__first_time_visit__show_message=="y" &&
    $sovix__select_menu_header_mode=="y"
    ||
    $sovix__first_time_visit==true &&
    $sovix__first_time_visit__show_message=="y" &&
    isset($_SESSION['sovix__user'])
) {
  echo "<div class=\"sovix__first_time_visit\"";
  if ($sovix__xhtml_basic!=true) {
    echo " style=\"background-color:black;";
    if ($sovix__language=="Swedish") echo " padding-left: 70px;";
    echo '"';
  }
  echo ">&nbsp;";
sovix__capital($sovix__text="$sovix__translate__Choose_a_location_in_the_select_menu");
echo "&uarr;</div>";
 }

if ($sovix__format==html) {
  if ($sovix__webbrowser__text_interface==true && $sovix__xhtml_basic!=true) echo "<hr$sovix__close_tag>";
 }
if ($sovix__menu__side_pane_mode=="n" || $sovix__screen_mode=="fullscreen") { echo "    <div class=\"sovix__toc__div toc"; echo "\">"; }
 echo "\n      <!-- TOC __________________________________________________________________________________ -->\n\n";
if (!empty($sovix__file__header_body)) require_once "$sovix__file__header_body";
require "$sovix__directory__src/header-toc.inc";
?>
