<?php /* Copyright (C) 2006, 2007, 2008 David Englund.

This file is part of GNU Sovix.

GNU Sovix is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as
published by the Free Software Foundation, either version 3 of the
License, or (at your option) any later version.

GNU Sovix is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with GNU Sovix.  If not, see <http://www.gnu.org/licenses/>.

The text in $sovix__page__copyright doesn't apply to this file, but
rather to the pages it generates. */

$sovix__page__copyright="Copyright (C) 2006, 2007, 2008 David Englund.
Permission is granted to copy, distribute and/or modify this document
under the terms of the GNU Free Documentation License, Version 1.2 or any
later version published by the Free Software Foundation; with no Invariant
Sections, with no Front-Cover Texts, and with no Back-Cover Texts.";
$sovix__directory__src=$_SERVER['DOCUMENT_ROOT']."/sovix/src";
$sovix__directory__dotsovix=$_SERVER['DOCUMENT_ROOT']."/sovix/dotsovix";
$sovix__topic="";
require_once "$sovix__directory__src/header.inc"; ?>

<?php
$sovix__array__toc_index = array(
              array(
                    'sovix__array__toc_index__array__base' => "0",
                    'sovix__array__toc_index__array__section' => "What is Sovix",
                    'sovix__array__toc_index__array__section_ending_special_chars' => "&#63;",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "0",
                    'sovix__array__toc_index__array__section' => "Terminology",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "1",
                    'sovix__array__toc_index__array__section' => "What is a website revision system",
                    'sovix__array__toc_index__array__section_ending_special_chars' => " (WRS)&#63;",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "1",
                    'sovix__array__toc_index__array__section' => "What is a enterprise WRS",
                    'sovix__array__toc_index__array__section_ending_special_chars' => "&#63;",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "0",
                    'sovix__array__toc_index__array__section' => "Technical aspects for end users",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "1",
                    'sovix__array__toc_index__array__section' => "Supported document type declarations",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "1",
                    'sovix__array__toc_index__array__section' => "Best Viewed with Any Browser",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "1",
                    'sovix__array__toc_index__array__section' => "Sovix is JavaScript independent",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "0",
                    'sovix__array__toc_index__array__section' => "Releases",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "1",
                    'sovix__array__toc_index__array__section' => "Current release",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "1",
                    'sovix__array__toc_index__array__section' => "Development",
                    'sovix__array__toc_index__array__section_ending_special_chars' => " &amp; &ldquo;coming soon&rdquo;",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "0",
                    'sovix__array__toc_index__array__section' => "Supported platforms",
                    'sovix__array__toc_index__array__section_ending_special_chars' => " &amp; software dependencies",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "0",
                    'sovix__array__toc_index__array__section' => "Obtaining GNU Sovix",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "0",
                    'sovix__array__toc_index__array__section' => "Help",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "1",
                    'sovix__array__toc_index__array__section' => "Getting help with GNU Sovix",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "2",
                    'sovix__array__toc_index__array__section' => "Tutorial",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "2",
                    'sovix__array__toc_index__array__section' => "Manuals",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "2",
                    'sovix__array__toc_index__array__section' => "FAQ",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "2",
                    'sovix__array__toc_index__array__section' => "Internet communities",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "1",
                    'sovix__array__toc_index__array__section' => "How to help with GNU Sovix",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "0",
                    'sovix__array__toc_index__array__section' => "Finding packages for GNU Sovix",
                    ),
              array(
                    'sovix__array__toc_index__array__base' => "0",
                    'sovix__array__toc_index__array__section' => "Further information",
                    ),
/*
              array(
                    'sovix__array__toc_index__array__base' => "0",
                    'sovix__array__toc_index__array__section' => "GNU Sovix Fun",
                    ),
*/
              array(
                    'sovix__array__toc_index__array__base' => "0",
                    'sovix__array__toc_index__array__section' => "Inspiration",
                    ),
          );
require_once "$sovix__directory__src/toc-index.inc"; ?>

<?php sovix__toc_index__base($sovix__toc_index__base="What is Sovix", $sovix__section_ending_special_chars="&#63;"); ?>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&ldquo;<em<?php if($sovix__xhtml_plus_rdfa==true) echo ' property="dc:description"'; ?>>Sovix is the <abbr title="PHP: Hypertext Preprocessor">PHP</abbr>-based, extensible, customizable, semantic <abbr title="WRS">website revision system</abbr>.</em>&rdquo;
<p></p>
If this seems to be a bit of a mouthful, an easier explanation is <?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:title">'; ?>Sovix<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?> is a free Emacs-like <abbr title="Website Revision Sytem">WRS</abbr>, the text editor <?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:title">'; ?>Sovix<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?> was developed in.

<p></p>

Some of the features of <abbr title="Gnu's Not Unix"<?php if($sovix__xhtml_plus_rdfa==true) echo ' property="dc:source"'; ?>>GNU</abbr> <?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:title">'; ?>Sovix<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?> include:
<p></p>
<ul>
  <li>Mechanisms to receive the software code over network protected by the <?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:rights">'; ?><acronym title="GNU's Not Unix">GNU</acronym> <abbr title="AGPL">Affero General Public License</abbr><? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?>.</li>
  <li>Semantically valid <abbr title="HyperText Markup Language">HTML</abbr> and <abbr title="Extensible HyperText Markup Language">XHTML</abbr> markup.</li>
  <li>Agnostic <abbr title="Relational Database Management System">RDBMS</abbr> support for Postgre<abbr title="Structured Query Language">SQL</abbr> and My<abbr title="Structured Query Language">SQL</abbr> via <?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:title">'; ?>Sovix<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?> web template engine.</li>
  <li>Cross platform/web server/browser compatible.</li>
  <li>Online documentation available direct from <?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:title">'; ?>Sovix<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?>, including a <?php sovix__local_link($sovix__local_link__link="Tutorial.php",$sovix__local_link__text="tutorial"); ?> for new users.</li>
</ul>

<p>
<?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:title">'; ?>Sovix<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?> was originally dubed a <acronym title="Gnu's Not Unix">GNU</acronym> package in 2008. The name &ldquo;<?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:title">'; ?>Sovix<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?>&rdquo; was originally chosen from the domain name sovix.org. &ldquo;<?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:title">'; ?>Sovix<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?>&rdquo; is neither an acronym or an abbrevation.
</p>

<p>
Read the <?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:title">'; ?>Sovix<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?> <?php sovix__local_link($sovix__local_link__link="Specification",$sovix__local_link__text="Specification"); ?> for more information.
</p>

<?php sovix__toc_index__base($sovix__toc_index__base="Terminology", $sovix__section_ending_special_chars=""); ?>

<?php sovix__toc_index__sub($sovix__toc_index__sub="What is a website revision system", $sovix__section_ending_special_chars=" (WRS)&#63;"); ?>
A <abbr title="Website Revision System">WRS</abbr> is a system for revising websites. We avoid using the term &ldquo;<abbr title="WCMS">web content management system</abbr>&rdquo; after a conversation with <?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:contributor">'; ?>Richard Stallman<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?> where he stated:
<p>
The term &ldquo;content management&rdquo; takes the prize for vacuity. Neither word has any specific meaning; &ldquo;content&rdquo; means &ldquo;some sort of information&rdquo;, and &ldquo;management&rdquo; in this context means &ldquo;doing something with it&rdquo;. So a &ldquo;<abbr title="CMS">content management system</abbr>&rdquo; is a system for doing something to some sort of information. In most cases, that term really refers to a system for updating a website. For that, we recommend the term &ldquo;<abbr title="WRS">website revision system</abbr>&rdquo; (<abbr title="Website Revision System">WRS</abbr>)<a href="http://www.gnu.org/philosophy/words-to-avoid.html#Content"><?php if ($sovix__xhtml_basic!=true) echo '<sup>'; ?>[ref]<?php if ($sovix__xhtml_basic!=true) echo '</sup>'; ?></a>.
</p>

<p>
The recommendation was set up a gnu.org after this conversation and we started to use the term the same day, the term itself it most likely invented at from that time.
</p>

<?php sovix__toc_index__sub($sovix__toc_index__sub="What is a enterprise WRS", $sovix__section_ending_special_chars="&#63;"); ?>
<?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:creator">'; ?>David Englund<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?> coined the term &ldquo;enterprise <abbr title="WRS">website revision system</abbr>&rdquo; as a replacement for &ldquo;enterprise <abbr title="WCMS">web content management system</abbr>&rdquo;.

<?php sovix__toc_index__base($sovix__toc_index__base="Tecnhical aspects for end users", $sovix__section_ending_special_chars=""); ?>

<?php sovix__toc_index__sub($sovix__toc_index__sub="Supported document type declarations", $sovix__section_ending_special_chars="&#63;"); ?>

<?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:title">'; ?>Sovix<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?> is valid <abbr title="Extensible HyperText Markup Language">XHTML</abbr>, <abbr title="Extensible HyperText Markup Language">XHTML</abbr> Basic, <abbr title="Extensible HyperText Markup Language">XHTML</abbr> Print and <abbr title="Extensible HyperText Markup Language">XHTML</abbr>+<abbr title="Resource Description Framework in attributes">RDFa</abbr>. By using your own definitions, you can customize the <abbr title="Document Type Declarations">DTD</abbr> and page source from the menu or with <abbr title="Document Type Declarations">dtd</abbr>-* commands, popular <abbr title="Document Type Declarations">DTD</abbr>s are listed there.

<?php sovix__toc_index__sub($sovix__toc_index__sub="Best Viewed with Any Browser", $sovix__section_ending_special_chars=""); ?>

<p>
<?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:title">'; ?>Sovix<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?> pages are <a href="http://www.anybrowser.org/campaign/">Best Viewed with Any Browser</a> but are tested with:
</p>

<table width="100%"<?php if ($sovix__xhtml_basic!=true && $sovix__xhtml_print!=true) echo ' border="0" cellspacing="0" cellpadding="0"'; ?>>
  <tr valign="top">
    <td>
      <strong>Graphical web browsers:</strong>
      <ul>
<!--        <li><acronym title="Gnu's Not Unix">GNU</acronym> IceCat</li>-->
        <li>BurningDog</li>
        <li>IceWeasel</li>
        <li>Mozilla <abbr title="FF">Firefox</abbr> 1.5 and 2.0</li>
        <li>Mozilla</li>
        <li>Epiphany</li>
        <li>Galeon</li>
        <li>Konqueror</li>
        <li>Windows <abbr title="IE">Internet Explorer</abbr> 7</li>
      </ul>
    </td>
    <td>
    <strong>Text web browsers:</strong>
      <ul>
        <li>Emacs/w3m</li>
        <li>w3m</li>
        <li>Links 1 and 2</li>
        <li>Lynx</li>
        <li>ELinks</li>
      </ul>
    </td>
  </tr>
</table>

<p><abbr title="Gnu's Not Unix"<?php if($sovix__xhtml_plus_rdfa==true) echo ' property="dc:source"'; ?>>GNU</abbr> <?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:title">'; ?>Sovix<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?> also runs fine on minimal web browsers, like Dillo,  and micro-browsers used by embedded systems.<br<?php echo $sovix__close_tag; ?>>
<?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:title">'; ?>Sovix<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?> adjusts it's <abbr title="User Interface">UI</abbr> to get visually optimal for both text-only and graphical web browsers.</p>

<?php sovix__toc_index__sub($sovix__toc_index__sub="Sovix is JavaScript independent", $sovix__section_ending_special_chars=""); ?>
I made this decision since lots of users have <abbr title="JS">JavaScript</abbr> disabled in their web browser due to its <abbr title="XSS">cross-site scripting</abbr> vulnerability.

<?php sovix__toc_index__base($sovix__toc_index__base="Releases", $sovix__section_ending_special_chars=""); ?>
<abbr title="Gnu's Not Unix"<?php if($sovix__xhtml_plus_rdfa==true) echo ' property="dc:source"'; ?>>GNU</abbr> <?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:title">'; ?>Sovix<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?> is a rapidly evolving project. Extensions require time for bug-free development and thorough testing. Packages targeted at <?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:title">'; ?>Sovix<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?> (such as <?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:title">'; ?>Sovix-diet<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?>, not official yet) will be released separately to avoid exploits.

<?php sovix__toc_index__sub($sovix__toc_index__sub="Current release", $sovix__section_ending_special_chars=""); ?>
<ul>
<li>Latest release: <abbr title="Gnu's Not Unix"<?php if($sovix__xhtml_plus_rdfa==true) echo ' property="dc:source"'; ?>>GNU</abbr> <?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:title">'; ?>Sovix<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?> 0.0.1.6 (2008-09-26)
  <ul>
<li><?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:title">'; ?>Sovix<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?> version 0.0.1.6
is the first official <acronym title="GNU's Not Unix">GNU</acronym> package of <?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:title">'; ?>Sovix<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?>.</li>
  </ul>
</li>
<li>For more info, read the 
<?php sovix__local_link($sovix__local_link__link="NEWS",$sovix__local_link__text="NEWS"); ?>.</li>
<li>To download, visit <a href="#Obtaining_GNU_Sovix">obtaining</a> section.</li>
</ul>

<?php sovix__toc_index__sub($sovix__toc_index__sub="Development", $sovix__section_ending_special_chars=" &amp; &ldquo;coming soon&rdquo;"); ?>
<ul>
<li>For more information please read upcoming release's anticipated <?php sovix__local_link($sovix__local_link__link="etc/TODO",$sovix__local_link__text="TODOs"); ?>.</li>
<li><abbr title="Gnu's Not Unix"<?php if($sovix__xhtml_plus_rdfa==true) echo ' property="dc:source"'; ?>>GNU</abbr> <?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:title">'; ?>Sovix<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?> is actively evolving, please see <a href="http://sovix.org/Releases">sovix.org/Releases</a> for an up-to-date list.</li>
</ul>

<?php sovix__toc_index__sub($sovix__toc_index__sub="Supported platforms", $sovix__section_ending_special_chars=" &amp; software dependencies"); ?>

<?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:title">'; ?>Sovix<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?> is cross-platform project. <?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:title">'; ?>Sovix<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?> requires <abbr title="PHP: Hypertext Preprocessor">PHP</abbr> 4.3.0 (required by file_get_contents) or later as application server. It also requires a web server which supports <abbr title="PHP: Hypertext Preprocessor">PHP</abbr> extension (such as the Apache <abbr title="Hypertext Transfer Protocol">HTTP</abbr> Server). You will need Postgre<abbr title="Structured Query Language">SQL</abbr> 7.4 or later or My<abbr title="Structured Query Language">SQL</abbr> 4.1 or later to use <?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:title">'; ?>Sovix<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?> web template engine to set up database driven tables, but this feature is optional. <abbr title="PHP: Hypertext Preprocessor">PHP</abbr>, Apache, Postgre<abbr title="Structured Query Language">SQL</abbr> <strong>and</strong> My<abbr title="Structured Query Language">SQL</abbr> are also supported on multiple platforms. <?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:title">'; ?>Sovix<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?> will be cloned as a cross-platformed Python-based application later.

<?php sovix__toc_index__base($sovix__toc_index__base="Obtaining GNU Sovix", $sovix__section_ending_special_chars=""); ?>
<abbr title="Gnu's Not Unix"<?php if($sovix__xhtml_plus_rdfa==true) echo ' property="dc:source"'; ?>>GNU</abbr> <?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:title">'; ?>Sovix<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?> can be obtained from <a href="http://ftp.gnu.org/gnu/sovix/">&lt;http://ftp.gnu.org/gnu/sovix/&gt;</a>.
<p>The <a href="http://cvs.savannah.gnu.org/viewvc/sovix/"><abbr title="Gnu's Not Unix"<?php if($sovix__xhtml_plus_rdfa==true) echo ' property="dc:source"'; ?>>GNU</abbr> <?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:title">'; ?>Sovix<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?> <abbr title="Concurrent Versions System">CVS</abbr> repository</a> is available for general access through <a href="https://savannah.gnu.org/projects/sovix/">savannah.gnu.org's <?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:title">'; ?>Sovix<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?> task page</a>.</p>

<?php sovix__toc_index__base($sovix__toc_index__base="Help", $sovix__section_ending_special_chars=""); ?>

<?php sovix__toc_index__sub($sovix__toc_index__sub="Getting help with GNU Sovix", $sovix__section_ending_special_chars=""); ?>

<p>
Information on getting help with Sovix in general is available at the
<a href="http://sovix.org/Help/Get_help">Get help with Sovix</a> page.
</p>

<?php sovix__toc_index__sub($sovix__toc_index__sub="Tutorial", $sovix__section_ending_special_chars=""); ?>

Go through the <?php sovix__local_link($sovix__local_link__link="Tutorial",$sovix__local_link__text="Tutorial"); ?> to learn how to use <?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:title">'; ?>Sovix<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?> and how to set up a website with <?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:title">'; ?>Sovix<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?>.

<?php sovix__toc_index__sub($sovix__toc_index__sub="Manuals", $sovix__section_ending_special_chars=""); ?>
<ul>
<li>The <cite><abbr title="Gnu's Not Unix"<?php if($sovix__xhtml_plus_rdfa==true) echo ' property="dc:source"'; ?>>GNU</abbr> <?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:title">'; ?>Sovix<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?> Manual</cite> is still in &ldquo;Work in Progress&rdquo; in this version.</li>
</ul>

<?php sovix__toc_index__sub( $sovix__toc_index__sub="FAQ", $sovix__section_ending_special_chars=""); ?>
<ul>
  <li>The <cite><abbr title="Gnu's Not Unix"<?php if($sovix__xhtml_plus_rdfa==true) echo ' property="dc:source"'; ?>>GNU</abbr> <?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:title">'; ?>Sovix<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?> <abbr title="Frequently Asked Question">FAQ</abbr></cite> is still in &ldquo;Work in Progress&rdquo; in this version.</li>
</ul>

<?php sovix__toc_index__sub( $sovix__toc_index__sub="Internet communities", $sovix__section_ending_special_chars=""); ?>
<ul>
<li>Visit <a href="http://sovix.org/Communities">sovix.org/Communities</a> for a list of active <?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:title">'; ?>Sovix<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?> communities over internet such as mailing lists.</li>
</ul>

<!--    <ul>
      <li>The <a href="/sovix/FAQ.html"<?php if($sovix__xhtml_plus_rdfa==true) echo ' property="dc:title"'; ?>>Sovix <abbr title="Frequently Asked Question">FAQ</abbr>, html</a>.
      <li>The <a href="/sovix/FAQ.text"<?php if($sovix__xhtml_plus_rdfa==true) echo ' property="dc:title"'; ?>>Sovix <abbr title="Frequently Asked Question">FAQ</abbr>, plain text</a>.
      <li>The <abbr title="Frequently Asked Question">FAQ</abbr> is maintained as part of the <?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:title">'; ?>Sovix<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?> distribution, so
          the Texinfo source for these documents are in the <?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:title">'; ?>Sovix<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?> sources.
    </ul>
-->

<?php sovix__toc_index__sub($sovix__toc_index__sub="How to help with GNU Sovix", $sovix__section_ending_special_chars=""); ?>

<p>
To report bugs, or to contribute fixes and improvements, send mail to
<kbd><a href="mailto:bug-sovix@gnu.org">&lt;bug-sovix@gnu.org&gt;</a></kbd>.
</p>

<?php sovix__toc_index__base($sovix__toc_index__base="Finding packages for GNU Sovix", $sovix__section_ending_special_chars=""); ?>
<ul>
  <li>Check out the <a href="http://sovix.org/Packages"<?php if($sovix__xhtml_plus_rdfa==true) echo ' property="dc:title"'; ?>>Sovix package</a> page.</li>
</ul>

<?php sovix__toc_index__base($sovix__toc_index__base="Further information", $sovix__section_ending_special_chars=""); ?>
<p>The <a href="https://savannah.gnu.org/projects/sovix/"<?php if($sovix__xhtml_plus_rdfa==true) echo ' property="dc:title"'; ?>>Savannah Sovix page</a> has additional information about <?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:title">'; ?>Sovix<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?>, including <abbr title="Concurrent Versions System">CVS</abbr> access
to the <?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:title">'; ?>Sovix<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?> development sources.</p>

<!--<p>
The <a href="http://www.sovixwiki.org/">Sovix Wiki</a> is a community
website which collects code, questions and answers related to
<?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:title">'; ?>Sovix<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?> code and style; introductions to <?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:title">'; ?>Sovix<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?> packages and links to
their sources; complete manuals or documentation fragments; comments
on features, differences, and history of different <?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:title">'; ?>Sovix<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?> versions,
flavors, and ports; jokes; pointers to clones and <?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:title">'; ?>Sovix<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?> look-alikes, as
well as references to other <?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:title">'; ?>Sovix<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?> related information on the Web.</p>
-->

<!--<?php sovix__toc_index__base($sovix__toc_index__base="GNU Sovix Fun", $sovix__section_ending_special_chars=""); ?>
<ul>
  <li>April Fool Mail - <a href="/fun/jokes/gnusovix.html">sovix rewrite</a></li>
  <li><a href="/fun/humor.html">More</a> humors related to <abbr title="Gnu's Not Unix"<?php if($sovix__xhtml_plus_rdfa==true) echo ' property="dc:source"'; ?>>GNU</abbr> <?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:title">'; ?>Sovix<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?> and others</li>
</ul>-->

<?php sovix__toc_index__base($sovix__toc_index__base="Inspiration", $sovix__section_ending_special_chars=""); ?>
A big &ldquo;Thank You&rdquo; is devoted to my mentor, <?php if($sovix__xhtml_plus_rdfa==true) echo '<span property="dc:contributor">'; ?>Richard Stallman<? if($sovix__xhtml_plus_rdfa==true) echo '</span>'; ?> for free software license consulting and for founding the <acronym title="Gnu's Not Unix">GNU</acronym> project, <acronym title="Gnu's Not Unix">GNU</acronym> <abbr title="General Public License">GPL</abbr>, <abbr title="FSF">Free Software Foundation</abbr>, <acronym title="Gnu's Not Unix">GNU</acronym> Emacs and Texinfo (inspiration to make agnostic <abbr title="Structured Query Language">SQL</abbr> management). They were key inspiration to the success of this project. I also want to thank him for suggesting the term "<abbr title="WRS">website revision system</abbr>"<!-- and kindly letting me use modified text-->.

<?php require_once "$sovix__directory__src/footer.inc"; ?>
