/* Source Installer, Copyright (c) 2005,2006,2007 Claudio Fontana

 global.h - information that should be globally available

 This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
     (at your option) any later version.

 This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
     along with this program (look for the file called COPYING);
     if not, write to the Free Software Foundation, Inc.,
         51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

     You can contact the author (Claudio Fontana) by sending a mail
     to claudio@gnu.org
*/

#ifndef GLOBAL_H
#define GLOBAL_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_STDIO_H
#include <stdio.h>
#endif

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#include "gettext.h"
#define _(msgid)            gettext (msgid)
#define N_(msgid)           gettext_noop (msgid)
#define S_(msg1,msg2,num)   ngettext (msg1,msg2,num)

#ifdef HAVE_LOCALE_H
#include <locale.h>
#endif

#include <srcinst/srcinst.h>
#include <gtk/gtk.h>

#include "options.h"

struct state {
    struct options o;
    int actions_locked;
    SRCINST_PHANDLE package;
};

extern struct state state;

extern int bw;			/* border width */
extern int lw;			/* alignment label width */

int value_updated(char *oldvalue, char *newvalue);

#if SIZEOF_OFF_T == SIZEOF_INT
# define OFF_FMT "%d"
#elif SIZEOF_OFF_T == SIZEOF_LONG
# define OFF_FMT "%ld"
#else
# define OFF_FMT "%lld"
#endif

#endif				/* GLOBAL_H */
