/* Source Installer, Copyright (c) 2005,2006,2007 Claudio Fontana

 about.c - About dialog

 This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
     (at your option) any later version.

 This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
     along with this program (look for the file called COPYING);
     if not, write to the Free Software Foundation, Inc.,
         51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

     You can contact the author (Claudio Fontana) by sending a mail
     to claudio@gnu.org
*/

#include "global.h"
#include "gui.h"
#include "about.h"

GtkWidget* w_about[W_ABOUT_N];

void about_create(void) {
  GdkPixbuf* logo;
  
  char* authors[] = { "Claudio Fontana <claudio@gnu.org>", 0 };
  char* artists[] = { "Pete Trbovich", 0 };
  char* comments = "portable source code installer and manager";
  char* copyright = "Copyright (c) 2005,2006,2007 Claudio Fontana";
  char* license = "\n\
 This program is free software; you can redistribute it and/or modify\n\
     it under the terms of the GNU General Public License as published by\n\
 the Free Software Foundation; either version 3 of the License, or\n\
     (at your option) any later version.\n\
\n\
 This program is distributed in the hope that it will be useful,\n\
     but WITHOUT ANY WARRANTY; without even the implied warranty of\n\
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n\
     GNU General Public License for more details.\n\
\n\
 You should have received a copy of the GNU General Public License\n\
     along with this program (look for the file called COPYING);\n\
     if not, write to the Free Software Foundation, Inc.,\n\
         51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA\n\
\n\
     You can contact the author (Claudio Fontana) by sending an email\n\
     to claudio@gnu.org\n\
";
  char* name = "GNU Source Installer";
  char* version = PACKAGE_VERSION;
  char* website = "http://www.gnu.org/software/sourceinstall/";

#if GTK_CHECK_VERSION(2, 6, 0)
  GtkAboutDialog* about;
#else
  GtkWidget* about;
#endif

  logo = gdk_pixbuf_new_from_file(DATADIR "/images/logo.png", NULL);

#if GTK_CHECK_VERSION(2, 6, 0)
  about = GTK_ABOUT_DIALOG(gtk_about_dialog_new());
  gtk_about_dialog_set_name(about, name);
  gtk_about_dialog_set_version(about, version);
  gtk_about_dialog_set_copyright(about, copyright);
  gtk_about_dialog_set_comments(about, comments);
  gtk_about_dialog_set_license(about, license);
  gtk_about_dialog_set_website(about, website);
  gtk_about_dialog_set_authors(about, authors);
  gtk_about_dialog_set_artists(about, artists);

  if (logo)
    gtk_about_dialog_set_logo(about, logo);
#else
  about = dialog_create_msgbox_scroll("About GNU Source Installer",
				      PACKAGE, comments, license, copyright,
				      GTK_MESSAGE_INFO, GTK_BUTTONS_OK);
#endif

  
  w_about[W_ABOUT] = GTK_WIDGET(about);
}

void about_run(void) {
  gtk_widget_show_all(w_about[W_ABOUT]);
  gtk_dialog_run(GTK_DIALOG(w_about[W_ABOUT]));
  gtk_widget_hide_all(w_about[W_ABOUT]);
}
