/* Source Installer, Copyright (c) 2005,2006,2007 Claudio Fontana

 srcinst_internal.h - declarations shared among the internal modules

 This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
     (at your option) any later version.

 This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
     along with this program (look for the file called COPYING);
     if not, write to the Free Software Foundation, Inc.,
         51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

     You can contact the author (Claudio Fontana) by sending a mail
     to claudio@gnu.org

*/

#ifndef SRCINST_INTERNAL_H
#define SRCINST_INTERNAL_H

#define SRCINST_BUFSIZE 2048

#include <srcinst/srcinst.h>
#include "package_list.h"
#include "srccallback.h"
#include "preferences.h"

struct _srcinst_state {
    struct _package_list packages;
    struct _preferences preferences;

    char *dirs[SRCINST_DIR_N + 1];
    char *files[SRCINST_FILE_N + 1];

    int initialized;
    int sigint_seen;
    int user_locked;
    int lockfile_fd;

    int log_stdout;
    int log_stderr;
    int log_spawn;

    struct _callback_list stdout_callbacks;
    struct _callback_list stderr_callbacks;
    struct _callback_list spawn_callbacks;
    struct _callback_list beat_callbacks;

    SRCINST_SPAWN_ID waiting_for;
    long beat_delay;

    struct sigaction sa_old_SIGINT;
    struct sigaction sa_old_SIGTERM;
    struct sigaction sa_old_SIGPIPE;
};

extern struct _srcinst_state _srcinst_state;

#endif				/* SRCINST_INTERNAL_H */
