/* Source Installer, Copyright (c) 2005,2006,2007 Claudio Fontana

   string_list.h - simple string set

   This program is free software; you can redistribute it and/or modify
       it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
       (at your option) any later version.

   This program is distributed in the hope that it will be useful,
       but WITHOUT ANY WARRANTY; without even the implied warranty of
       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
       GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
       along with this program (look for the file called COPYING);
       if not, write to the Free Software Foundation, Inc.,
           51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

       You can contact the author (Claudio Fontana) by sending a mail
       to claudio@gnu.org
*/

#ifndef SRCINST_STRING_LIST_H
#define SRCINST_STRING_LIST_H

/* this is a set of file strings (or any other strings).             */
/* In fact it is a simple char** with a counter and some functions.  */

struct srcinst_string_list {
  size_t count;
  char** strings;
};

/* the following function just sets ->count and ->strings to 0 */
void srcinst_init_string_list(struct srcinst_string_list* list);

/* the following function unallocates the strings and ->strings.
   (char*)0 strings are skipped. */
void srcinst_free_string_list(struct srcinst_string_list* list);

/* init a string LIST globbing a certain DIRECTORY. PATTERN is a shell
   wildcard pattern. Entries '.' and '..' are not included in the glob */
int srcinst_glob_string_list(struct srcinst_string_list* list, char* dirname, char* pattern);

/* the following is relatively slow, it reallocs ->strings to add a new
   element. If you want a faster way to build a list, prepare the char** and
   count yourself, and set the elements in the struct.
   Note that you _can_ pass a (char*)0 STRING element. (So you can produce
   a 0-ended string array).
   However, do not call functions different than srcinst_free_string afterwards
   or you will get nice SIGSEGV */

void srcinst_add_string_list(struct srcinst_string_list* list, char* string);

/* deep copy SRC string list to DEST */
void srcinst_copy_string_list(struct srcinst_string_list* dest,
			      struct srcinst_string_list* src);

/* this is a variation, where only the ->strings array is allocated, while
   the strings are only mirrored by copying the pointers.
   Do not srcinst_free_string_list() the mirror, just free(->strings);
   use for performance when needed.
*/

void srcinst_mirror_string_list(struct srcinst_string_list* dest,
				struct srcinst_string_list* src);

/* the following function purges a filelist from "" and, optionally,
   non-existing files. */

void srcinst_purge_string_list(struct srcinst_string_list* l, int nonexistant);

/* returns a newly allocated string that is the concatenation of all
   strings in list L, separated by string SEP */

char* srcinst_collapse_string_list(struct srcinst_string_list* l, char* sep);


/* sort a string list using the compare function passed as argument COMPARE */
void srcinst_sort_string_list(struct srcinst_string_list* list,
			      int (*compare)(char**, char**));

/* a search function is not needed.
   Define your order in the string list, then use srcinst_bsearch.
   
   int srcinst_search_string_list(struct srcinst_string_list* list, char* str);
*/

/* prefix each element of the string list with the argument PREFIX */
void srcinst_prefix_string_list(struct srcinst_string_list* l, char* prefix);


#endif /* SRCINST_STRING_LIST_H */

