# spec file for sipwitch, used for official builds for GNU Telephony.
#
# Copyright (c) 2008 David Sugar, Tycho Softworks.
# This file is free software; as a special exception the author gives
# unlimited permission to copy and/or distribute it, with or without
# modifications, as long as this notice is preserved.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY, to the extent permitted by law; without
# even the implied warranty of MERCHANTABILITY or FITNESS FOR A
# PARTICULAR PURPOSE.

%{!?release: %define release 0}
%{!?version: %define version 0.5.3}

%{!?uses_avahi:  %define uses_avahi 1}
%{!?uses_openssl:  %define uses_openssl 1}
%{!?uses_gcrypt: %define uses_gcrypt 0}
%{!?uses_python: %define uses_python 1}
%{!?uses_php: %define uses_php 1}

%define _libname libsipwitch0
%define _devname libsipwitch-devel

%if %{uses_gcrypt}
%define	uses_openssl 0
%endif

%define mod_zeroconf 0
%if %{uses_avahi}
%define	mod_zeroconf 1
%endif

%define req_swig 0
%define mod_python 0
%define mod_php 0

%if %{uses_python}
%define	req_swig 1
%define mod_python 1
%endif

%if %{uses_php}
%define	req_swig 1
%define mod_php 1
%endif

Name: sipwitch
Summary: "sipwitch" - SIP telephony server for secure phone systems
Version: %{version}
Release: %{release}%{?dist}
License: GPL v3 or later
URL: http://www.gnu.org/software/sipwitch
Group: Networking/Telephony
Source0: http://www.gnutelephony.org/dist/tarballs/sipwitch-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
BuildRequires: ucommon-devel >= 2.0.0
BuildRequires: libeXosip2-devel >= 3.0.0
BuildRequires: gcc-c++ pkgconfig
%if %{req_swig}
BuildRequires: swig >= 1.3.30
%endif
%if %{mod_python}
BuildRequires: python-devel
%endif
%if %{mod_php}
BuildRequires: php-devel >= 5.0.0
%endif
%if %uses_openssl
BuildRequires: openssl-devel
%endif
%if %uses_gcrypt
BuildRequires: libgcrypt-devel
%endif
%if %uses_avahi
BuildRequires: avahi-devel
%endif
Requires: %{_libname} = %{version}
Packager: David Sugar <dyfet@gnutelephony.org>

%package -n %{_libname}
Group: System/Libraries
Summary: Runtime library for sipwitch server and plugins

%package -n %{_devname}
Requires: libucommon-devel >= 1.9.5
Requires: %{_libname} = %{version}
Group: Development/Libraries
Summary: Headers and static link library
Provides: %{name}-devel = %{version}-%{release}

%if %{mod_zeroconf}
%package plugin-zeroconf
Requires: sipwitch = %{version}
Group: Networking/Telephony
Summary: Zeroconf plugin for sipwitch
%endif

%if %{mod_python}
%package -n python-sipwitch
Requires: python
Group: Networking/Telephony
Summary: Python package to control sipwitch server
%endif

%if %{mod_php}
%package -n php-sipwitch
Requires: php
Group: Networking/Telephony
Summary: PHP package to control sipwitch server
%endif

%package plugin-scripting
Requires: sipwitch = %{version}
Group: Networking/Telephony
Summary: Scripting plugin for sipwitch

%package plugin-forward
Requires: sipwitch = %{version}
Group: Networking/Telephony
Summary: Forward registration and routing plugin

%package plugin-rtpproxy
Requires: sipwitch = %{version}
Group: Networking/Telephony
Summary: Generic rtp proxy plugin for sipwitch

%package plugin-subscriber
Requires: sipwitch = %{version}
Group: Networking/Telephony
Summary: Subscriber gateway plugin for sipwitch

%description
GNU SIP Witch is a pure SIP-based office telephone call server that supports
generic phone system features like call forwarding, hunt groups and call
distribution, call coverage and ring groups, holding, and call transfer, as
well as offering SIP specific capabilities such as presence and messaging. It
supports secure telephone extensions for making calls over the Internet, and
intercept/decrypt-free peer-to-peer audio and video extensions. It is not a SIP
proxy, a multi-protocol telephone server, or an IP-PBX, and does not try to
emulate Asterisk, FreeSWITCH, or Yate. 

%description -n %{_libname}
Runtime library needed for GNU SIP Witch server and plugins.

%description -n %{_devname}
Static link and header files for building plugins that interface with sipwitch.
This might be used for externally creating sipwitch modules, though normally
modules are found or added to the core distribution directly.  This may also
be for developing external application services which need to communicate with 
a running sipwitch daemon instance.

%if %{mod_zeroconf}
%description plugin-zeroconf
This plugin activates zeroconf network services for sipwitch and publishes
sipwitch as a sip server.
%endif

%if %{mod_python}
%description -n python-sipwitch
This module allows one to interact with and control a locally running 
instance of the GNU SIP Witch daemon using python.  This can be used to
create sipwitch admininstration scripts or python web services that
interact with the locally running instance of sipwitch.
%endif

%if %{mod_php}
%description -n php-sipwitch
This extension allows one to interact with and control a locally running 
instance of the GNU SIP Witch daemon using php.  This can be used to
create sipwitch admininstration scripts or php web services that
interact with the locally running instance of sipwitch.
%endif

%description plugin-scripting
This plugin enables shell scripting in connection with specific sipwitch events.

%description plugin-forward
This plugin enables forwarding of registration requests and destination routes
for unknown numbers so that one can create a "secure" peer to peer media
domain managed by sipwitch and still access an "insecure" b2bua based ip-pbx.

%description plugin-rtpproxy
Generic assignment of RTP proxy for packet forwarding when local and
remote caller is not directly routable.  This can include briding when
both source and destination are offsite or on different subnets.  This
will enable calls between local users and remote users when either or
both parties are behind NAT.  It is assumed a block of rtp ports (and 
the sip port) will be "port forwarded" to sipwitch.  All proxying is 
transparent and hence directly usable for secure calling with ZRTP.

%description plugin-subscriber
This module is meant to eventually offer generic support for premise 
routers when used by providers to offer sip/voip service to a subscriber.
It offers rtp proxying and routing based on the assumption that all calls
will be handed off to an external voip provider and automatic rtp
proxy bridging between a subscribers local subnet and an isp.  In theory
this would be deployed in an isp supplied premise router to enable a 
local user to subscribe a series of local softphone/sip devices with a 
remote voip service provider.

%prep
%setup
%build

%configure --with-pkg-config CXXFLAGS="$RPM_OPT_FLAGS" 
%{__make} %{?_smp_mflags} 

%install

%makeinstall
%{__strip} %{buildroot}/%{_libdir}/lib*.so.*.*
%{__strip} %{buildroot}/%{_libdir}/sipwitch/*.so
%{__strip} %{buildroot}/%{_sbindir}/*
%{__strip} %{buildroot}/%{_bindir}/*
%{__rm} -f %{buildroot}/%{_libdir}/sipwitch/*.a
%{__rm} -f %{buildroot}/%{_libdir}/sipwitch/*.la

%if %{mod_python}
%{__make} DESTDIR=%{buildroot} swig-python
%endif

%if %{mod_php}
%{__make} DESTDIR=%{buildroot} swig-php5
%endif

# setup for automatic plugin loading.  
# Plugins selected by packages admin has installed.
echo "PLUGINS=auto" >>%{buildroot}/etc/sysconfig/sipwitch

%clean
%{__rm} -rf %{buildroot}

%files 
%defattr(-,root,root,-)
%doc README COPYING INSTALL NEWS FEATURES SUPPORT TODO NOTES AUTHORS MODULES ChangeLog
%doc %{_mandir}/man8/*.8*
%{_sbindir}/*
%{_bindir}/*
%{_datadir}/snmp/mibs/GNUTelephony-MIB.txt
%dir %{_libdir}/sipwitch
%config %{_sysconfdir}/logrotate.d/sipwitch
%attr(0755,root,root) %{_sysconfdir}/init.d/sipwitch
%attr(0755,root,root) %{_sysconfdir}/cron.hourly/sipwitch
%attr(0770,root,root) %dir %{_sysconfdir}/sipwitch.d
%attr(0660,root,root) %config %{_sysconfdir}/sipwitch.conf
%attr(0660,root,root) %config %{_sysconfdir}/sysconfig/sipwitch
%attr(0660,root,root) %config %{_sysconfdir}/sipwitch.d/*.xml

%files -n %{_libname}
%defattr(-,root,root,-)
%{_libdir}/lib*.so.*

%if %{mod_zeroconf}
%files plugin-zeroconf
%defattr(-,root,root,-)
%{_libdir}/sipwitch/zeroconf.*
%endif

%if %{mod_python}
%files -n python-sipwitch
%defattr(-,root,root,-)
%{_prefix}/lib/python*/site-packages/sipwitch.py
%{_prefix}/lib/python*/site-packages/_sipwitch.so
%endif

%if %{mod_php}
%files -n php-sipwitch
%defattr(-,root,root,-)
%{_libdir}/php*/*/sipwitch.so
%endif

%files plugin-forward
%defattr(-,root,root,-)
%{_libdir}/sipwitch/forward.*

%files plugin-scripting
%defattr(-,root,root,-)
%{_libdir}/sipwitch/scripting.*

%files plugin-rtpproxy
%defattr(-,root,root,-)
%{_libdir}/sipwitch/rtpproxy.*

%files plugin-subscriber
%defattr(-,root,root,-)
%{_libdir}/sipwitch/subscriber.*

%files -n %{_devname}
%defattr(-,root,root,-)
%{_libdir}/lib*.a
%{_libdir}/lib*.so
%{_libdir}/lib*.la
%dir %{_includedir}/sipwitch
%{_includedir}/sipwitch/*.h
%{_libdir}/pkgconfig/*.pc

%post -n %{_libname} -p /sbin/ldconfig

%postun -n %{_libname} -p /sbin/ldconfig

%if %{mod_python}
%post -n python-sipwitch 
version=`python -c "import sys ; print sys.version[:3]"`
prefix=/usr/lib/python$version/site-packages
cmd="import py_compile ; py_compile.compile('$prefix/$source')"
python -c "$cmd"
python -O -c "$cmd"

%preun -n python-sipwitch
version=`python -c "import sys ; print sys.version[:3]"`
rm -f /usr/lib/python$version/site-packages/sipwitch.pyc
rm -f /usr/lib/python$version/site-packages/sipwitch.pyo
%endif

%post
if [ -x /sbin/chkconfig ] ; then /sbin/chkconfig --add sipwitch ; fi

%preun
if [ -x /sbin/chkconfig ] ; then /sbin/chkconfig --del sipwitch ; fi

%changelog
* Fri Jul 25 2008 - dyfet@gnutelephony.org
- spec file updated for plugins and new library naming.

* Mon Jul 21 2008 - dyfet@gnutelephony.org
- initial spec file distribution.


