# Copyright (c) 2008, 2009 David Sugar, Tycho Softworks.
# This file is free software; as a special exception the author gives
# unlimited permission to copy and/or distribute it, with or without
# modifications, as long as this notice is preserved.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY, to the extent permitted by law; without
# even the implied warranty of MERCHANTABILITY or FITNESS FOR A
# PARTICULAR PURPOSE.

Name: sipwitch
Summary: SIP telephony server for secure phone systems
Version: 0.5.10
Release: 0%{?dist}
License: GPLv3+
URL: http://www.gnu.org/software/sipwitch
Group: Applications/Communications
Source: http://www.gnutelephony.org/dist/tarballs/sipwitch-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
BuildRequires: ucommon-devel >= 2.0.0
BuildRequires: libeXosip2-devel >= 3.0.0
BuildRequires: avahi-devel
BuildRequires: libgcrypt-devel
Requires(post): chkconfig
Requires(preun): chkconfig
Requires(preun): initscripts
Requires(postun): initscripts
Requires: %{name}-runtime = %{version}-%{release}

%package runtime
Group: Development/Libraries
Summary: Runtime library support for sipwitch

%package devel
Requires: ucommon-devel >= 2.0.0
Requires: %{name}-runtime = %{version}-%{release}
Group: Development/Libraries
Summary: Headers for building sipwitch plugins

%package plugin-zeroconf
Requires: %{name} = %{version}-%{release}
Summary: Zeroconf plugin for sipwitch

%package plugin-scripting
Requires: %{name} = %{version}-%{release}
Summary: Scripting plugin for sipwitch

%package plugin-forward
Requires: %{name} = %{version}-%{release}
Summary: Forward registration and routing plugin

%package plugin-subscriber
Requires: %{name} = %{version}-%{release}
Summary: Subscriber gateway plugin for sipwitch

%description
GNU SIP Witch is a pure SIP-based office telephone call server that supports
generic phone system features like call forwarding, hunt groups and call
distribution, call coverage and ring groups, holding, and call transfer, as
well as offering SIP specific capabilities such as presence and messaging. It
supports secure telephone extensions for making calls over the Internet, and
intercept/decrypt-free peer-to-peer audio and video extensions. It is not a 
SIP proxy, a multi-protocol telephone server, or an IP-PBX, and does not try 
to emulate Asterisk, FreeSWITCH, or Yate. 

%description devel
Header files for building plugins that interface with sipwitch. This might be 
used for externally creating sipwitch modules, though normally modules are 
found or added to the core distribution directly.  This may also be for 
developing external application services which need to communicate with a 
running sipwitch daemon instance.

%description runtime
Runtime library required for sipwitch development and for using the server.
This is available as a separate package so that one building sipwitch plugins
with the required devel package does not also require installing a server
image.

%description plugin-zeroconf
This plugin activates zeroconf network services for sipwitch and publishes
sipwitch as a sip server.

%description plugin-scripting
This plugin enables shell scripting in connection with specific sipwitch 
events.

%description plugin-forward
This plugin enables forwarding of registration requests and destination routes
for unknown numbers so that one can create a "secure" peer to peer media
domain managed by sipwitch and still access an "insecure" b2bua based ip-pbx.

%description plugin-subscriber
This module is meant to eventually offer generic support for premise 
routers when used by providers to offer sip/voip service to a subscriber.
It offers rtp proxying and routing based on the assumption that all calls
will be handed off to an external voip provider and automatic rtp
proxy bridging between a subscribers local subnet and an isp.  In theory
this would be deployed in an isp supplied premise router to enable a 
local user to subscribe a series of local softphone/sip devices with a 
remote voip service provider.

%prep
%setup -q
%build
%configure --with-pkg-config --disable-static --with-initrddir=%{_initrddir}

%{__make} %{?_smp_mflags} 

%install
%{__rm} -rf %{buildroot}
%{__make} DESTDIR=%{buildroot} INSTALL="install -p" install
%{__rm} -f %{buildroot}/%{_libdir}/*.la
%{__rm} -f %{buildroot}/%{_libdir}/sipwitch/*.la

%clean
%{__rm} -rf %{buildroot}

%files 
%defattr(-,root,root,-)
%doc README COPYING NEWS FEATURES SUPPORT TODO NOTES AUTHORS MODULES ChangeLog
%{_mandir}/man8/*.8*
%{_sbindir}/*
%{_bindir}/*
%dir %{_libdir}/sipwitch
%config(noreplace) %{_sysconfdir}/logrotate.d/sipwitch
%attr(0755,root,root) %{_initrddir}/sipwitch
%attr(0755,root,root) %{_sysconfdir}/cron.hourly/sipwitch
%attr(0770,root,root) %dir %{_sysconfdir}/sipwitch.d
%attr(0660,root,root) %config(noreplace) %{_sysconfdir}/sipwitch.conf
%attr(0660,root,root) %config(noreplace) %{_sysconfdir}/sysconfig/sipwitch
%attr(0660,root,root) %config(noreplace) %{_sysconfdir}/sipwitch.d/*.xml

%files runtime
%defattr(-,root,root,-)
%{_libdir}/*.so.*

%files plugin-zeroconf
%defattr(-,root,root,-)
%{_libdir}/sipwitch/zeroconf.so

%files plugin-forward
%defattr(-,root,root,-)
%{_libdir}/sipwitch/forward.so

%files plugin-scripting
%defattr(-,root,root,-)
%{_libdir}/sipwitch/scripting.so

%files plugin-subscriber
%defattr(-,root,root,-)
%{_libdir}/sipwitch/subscriber.so

%files devel
%defattr(-,root,root,-)
%{_libdir}/*.so
%{_includedir}/sipwitch/
%{_libdir}/pkgconfig/*.pc

%post runtime
/sbin/ldconfig

%post
/sbin/chkconfig --add sipwitch

%preun
if [ $1 = 0 ] ; then
    /sbin/service sipwitch stop >/dev/null 2>&1
    /sbin/chkconfig --del sipwitch
fi

%postun 
if [ "$1" -ge "1" ] ; then
    /sbin/service sipwitch condrestart >/dev/null 2>&1 || :
fi

%postun runtime
/sbin/ldconfig

%changelog
* Thu Nov 18 2009 David Sugar <dyfet@gnutelephony.org> - 0.5.9-0
- removed snmp/mib from this package
- removed unused swig support and complex packaging it required.

* Mon Jul 13 2009 Remi Collet <Fedora@FamilleCollet.com> - 0.5.6-1
- rebuild for new PHP 5.3.0 ABI (20090626)
- add PHP ABI check
- add php configuration file (/etc/php.d/sipwitch.ini)

* Sat Jul 04 2009 - David Sugar <dyfet@gnutelephony.org> - 0.5.6-0
- split runtime from server to build plugins without requiring server.
- removed separate rtp proxy, functionality will be integrated into server.

* Wed Jun 10 2009 - David Sugar <dyfet@gnutelephony.org> - 0.5.5-0
- upstream fixed in rel 0.5.5, no patches now needed for rpm distros.

* Sun May 10 2009 - David Sugar <dyfet@gnutelephony.org> - 0.5.4-3
- new generic init script layout as a patch until next upstream release.

* Fri May 08 2009 - David Sugar <dyfet@gnutelephony.org> - 0.5.4-2
- some fixups until upstream is changed, and new init scriptlets.

* Wed May 06 2009 - David Sugar <dyfet@gnutelephony.org> - 0.5.4-1
- temporary patch file added until upstream catches up, other cleanup.

* Sat May 02 2009 - David Sugar <dyfet@gnutelephony.org> - 0.5.4-0
- spec file updated for redhat/fedora submission.

* Fri Jul 25 2008 - David Sugar <dyfet@gnutelephony.org> - 0.2.0-0
- spec file updated for plugins and new library naming.

* Mon Jul 21 2008 - David Sugar <dyfet@gnutelephony.org> - 0.1.0-0
- initial spec file distribution.

