/* -*-C-*-
 * access to the X Window System for Sather
 * (c) 1995/01/13 - 1995/02/19 by Erik Schnetter
 */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "header.h"



INT X_WMHints_sizet (void)
{ return (sizeof(XWMHints)+sizeof(INT)-1)/sizeof(INT); }



void X_WMHints_flags_set (XWMHints* wm_hints, INT flags)
{ wm_hints->flags = flags; }

void X_WMHints_input_set (XWMHints* wm_hints, BOOL input)
{ wm_hints->input = input; }

void X_WMHints_initial_state_set (XWMHints* wm_hints, INT initial_state)
{ wm_hints->initial_state = initial_state; }

void X_WMHints_icon_pixmap_set (XWMHints* wm_hints, INT icon_pixmap)
{ wm_hints->icon_pixmap = icon_pixmap; }

void X_WMHints_icon_window_set (XWMHints* wm_hints, INT icon_window)
{ wm_hints->icon_window = icon_window; }

void X_WMHints_icon_x_set (XWMHints* wm_hints, INT icon_x)
{ wm_hints->icon_x = icon_x; }

void X_WMHints_icon_y_set (XWMHints* wm_hints, INT icon_y)
{ wm_hints->icon_y = icon_y; }

void X_WMHints_icon_mask_set (XWMHints* wm_hints, INT icon_mask)
{ wm_hints->icon_mask = icon_mask; }

void X_WMHints_window_group_set (XWMHints* wm_hints, INT window_group)
{ wm_hints->window_group = window_group; }



INT X_WMHints_flags_get (XWMHints* wm_hints)
{ return wm_hints->flags; }

BOOL X_WMHints_input_get (XWMHints* wm_hints)
{ return wm_hints->input; }

INT X_WMHints_initial_state_get (XWMHints* wm_hints)
{ return wm_hints->initial_state; }

INT X_WMHints_icon_pixmap_get (XWMHints* wm_hints)
{ return wm_hints->icon_pixmap; }

INT X_WMHints_icon_window_get (XWMHints* wm_hints)
{ return wm_hints->icon_window; }

INT X_WMHints_icon_x_get (XWMHints* wm_hints)
{ return wm_hints->icon_x; }

INT X_WMHints_icon_y_get (XWMHints* wm_hints)
{ return wm_hints->icon_y; }

INT X_WMHints_icon_mask_get (XWMHints* wm_hints)
{ return wm_hints->icon_mask; }

INT X_WMHints_window_group_get (XWMHints* wm_hints)
{ return wm_hints->window_group; }



void X_SetWMHints (Display* display, INT window, XWMHints* wm_hints)
{
  XSetWMHints (display, window, wm_hints);
}

BOOL X_GetWMHints (Display* display, INT window, XWMHints* wm_hints)
{
  XWMHints* hints;
  hints = XGetWMHints (display, window);
  *wm_hints = *hints;
  XFree (hints);
  return hints!=0;
}
